Ext.define('ChangeConfiguration.controller.Main', {
	extend : 'Ext.app.Controller',
	views : [
		'Main',
		'configutilities.Tools',
		'configutilities.PrintPreview',
		'configutilities.SendMail',
		'configutilities.TimeLine',
		'ErrorPanel',
		'ConfigGridTemplate',
		'AllConfigChangesChart',
		'ConfigGridTemplate',
		'ConfigPagingGrid',
		'ConfigurationForm',
		'SearchForm',
		'utilities.CommonPanel',
		'AllOptionConfigGridTemplate'
	],
	refs :[
		{selector : 'main',ref : 'main'},
		{selector : 'main #resultViewContainer',ref : 'resultViewContainer'},
		{selector : 'tools',ref : 'tools'},
		{selector : 'configurationform',ref : 'configurationform'},
		{selector : 'configurationform #hiddenFieldsCt',ref : 'hiddenFieldsCt'},
		{selector : 'configurationform combo[id="ec_criteria"]',ref : 'ecCriteria'},
		{selector : 'configurationform #ec_userOption',ref : 'ecUserOption'},
		{selector : 'configurationform #ec_option1',ref : 'ecOption1'},
		{selector : 'configurationform #ec_option2',ref : 'ecOption2'},
		{selector : 'configurationform #ec_test',ref : 'testNameList'},
		//{selector : 'configurationform #ec_changetype1',ref : 'ecShowByRecent'},
		//{selector : 'configurationform #ec_changetype2',ref : 'ecShowByAll'},
		//{selector : 'configurationform #ec_viewchange1',ref : 'ecViewbyInfo'},
		//{selector : 'configurationform #ec_viewchange2',ref : 'ecViewbyDate'},
		{selector : 'configurationform #ec_maxpageitems',ref : 'maxPageItems'},
		{selector : 'configurationform #ec_timeline',ref : 'timeLine'},
		{selector : 'configurationform #ec_stdate',ref : 'startDate'},
		{selector : 'configurationform #ec_sthr',ref : 'startHour'},
		{selector : 'configurationform #ec_startmin',ref : 'startMinute'},
		{selector : 'configurationform #ec_enddate',ref : 'endDate'},
		{selector : 'configurationform #ec_endhr',ref : 'endHour'},
		{selector : 'configurationform #ec_endmin',ref : 'endMinute'},
		{selector : 'configurationform #compSearch',ref : 'compSearch'},
		{selector : 'configurationform #testSearch',ref : 'testSearch'},
		{selector : 'configurationform #descSearch',ref : 'descSearch'},
		{selector : 'configurationform #formItemContainer',ref : 'formItemContainer'},
		{selector: 'errorpanel',ref: 'errorpanel'},
		{selector: 'configgridtemplate',ref: 'configgridtemplate'},
		{selector: 'allconfigchangeschart',ref: 'allconfigchangeschart'},
		{selector: 'configpaginggrid',ref: 'configpaginggrid'},
		{selector: 'alloptionconfiggridtemplate',ref: 'alloptionconfiggridtemplate'}
	],
	init :function() {
		appCtn = this;
		this.buildFieldData()
		this.control({
			'main': {
				'afterrender': this.afterMainRender
			},
			'main #backBtnMain': {
				'click': this.forwardRequestedURI
			},
			'tools' :{
				'afterrender' : this.loadTools
			},
			//'configurationform':{
				//'boxready' : this.loadResultData
			//},
			'main #resultViewContainer':{
				'boxready' : this.loadResultData
			},
			'configurationform button[id="btnGo"]': {
				'click': this.getSearchDetails
			},
			'configurationform combo[id="ec_criteria"]':
			{
				'select': this.getDetails
			},
			'configurationform combo[id="ec_userOption"]':
			{
				'select': this.getDetails
			},
			'configurationform combo[id="ec_option1"]':
			{
				'select': this.getCompInfo
			},
			'configurationform combo[id="ec_option2"]':
			{
				'select': this.getCompInfo
			},
			'configurationform combo[id="ec_timeline"]':
			{
				'select': this.changeTimeLine
			},
			'configurationform button[id="submit"]':
			{
				'click': this.submitConfigDetails
			},
			//'configurationform checkbox[name="ec_viewchange"]':
			//{
				//'change': this.setViewChange
			//},
			'tools button[id="saveBtn"]' : {
				'click' : this.saveAsPDF
			},
			'tools button[id="printBtn"]' : {
				'click' : this.printData
			},
			'tools button[id="csvBtn"]' : {
				'click' : this.saveAsCSV
			},
			'tools button[id="mailBtn"]' : {
				'click' : this.sendMail
			},
			'tools button[id="scheduleBtn"]' : {
				'click' : this.setschedule
			},
			'configurationform trigger[id="compSearch"]' : {
				'change' : this.filterMultiselect
			}
		});
	},
	buildFieldData : function()
	{
		Ext.Ajax.request({
			url : config.urls.servletURL,
			params : queryString+"&needData=yes",
			method : 'POST',
			async : false,
			success : function( response ){
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					hiddenFieldsKeys = publicJSON['hiddenFields'];
					timeLineCollection = publicJSON['hiddenCollections'];
					backOperation = publicJSON['backOperation'];
				}
			}
		});
	},
	afterMainRender : function()
	{
		var me = this;
		me.getMain().setTitle(publicJSON.applicationTitle);
		configurationLayoutCt = publicJSON.configurationLayout;

		if(request_from == "CAAG")
		{
			Ext.getCmp('main').setTitle('CONFIGURATION CHANGE : DETAILED - COMPONENT NAME');
		}
		else if(request_from == "CS")
		{
			Ext.getCmp('main').setTitle('CONFIGURATION CHANGE : DETAILED - COMPONENT TYPE');
		}

		if (publicJSON.configurationLayout == 'showConfigForm')
		{
			fromMonitorToConfig = publicJSON.fromMonitorToConfig;
			me.getConfigurationform().show();
			if (fromMonitorToConfig)
			{
				Ext.getCmp('backBtnMain').show();
				Ext.getCmp('bkSeperator').show();
			}
			else if (backOperation.requestFromHome || backOperation.requestForHome || backOperation.requestFromDCDS)
			{
				Ext.getCmp('backBtnMain').show();
				Ext.getCmp('bkSeperator').show();
			}
			else
			{
				Ext.getCmp('backBtnMain').hide();
				Ext.getCmp('bkSeperator').hide();
			}
			me.getEcCriteria().getStore().loadRawData(publicJSON.viewByList);
			me.getEcCriteria().setValue(publicJSON.selectedEcOpt);
			if (publicJSON.selectedEcOpt != 'Component')
			{
				me.getEcUserOption().getStore().loadRawData(publicJSON.specViewByList);
				me.getEcUserOption().setValue(publicJSON.selectedUserOptionText);
				me.getEcUserOption().setFieldLabel(publicJSON.specViewByTitle);
				if (publicJSON.specViewByTitle == null || publicJSON.specViewByTitle == 'undefined')
				{
					me.getEcUserOption().setValue(me.getEcUserOption().getStore().getAt(0).get("valueField"));
				}
				me.getEcUserOption().show();
			}
			else
			{
				me.getEcUserOption().hide();
			}
			me.fillConfigData();
			if (request_from != null && request_from == "saveSchedule")
			{
				Ext.getCmp('backBtnMain').show();
				Ext.getCmp('bkSeperator').show();
				Ext.getCmp('submit').setText('Save');
			}
		}
		else if (publicJSON.configurationLayout == 'Search1') // component type
		{
			me.getConfigurationform().show();
			Ext.getCmp('schSep').hide();
			Ext.getCmp('scheduleTool').hide();
			Ext.getCmp('backBtnMain').show();
			Ext.getCmp('bkSeperator').show();
			me.getFormItemContainer().removeAll();
			me.getFormItemContainer().suspendEvents(true);
			me.getFormItemContainer().add({xtype : 'searchform'});
			me.getFormItemContainer().resumeEvents();
			Ext.getCmp('compSearch').show();
		}
		else if (publicJSON.configurationLayout == 'Search2') // component name
		{
			Ext.getCmp('schSep').hide();
			Ext.getCmp('scheduleTool').hide();
			Ext.getCmp('backBtnMain').show();
			Ext.getCmp('bkSeperator').show();
			me.getConfigurationform().show();
			me.getFormItemContainer().removeAll();
			me.getFormItemContainer().suspendEvents(true);
			me.getFormItemContainer().add({xtype : 'searchform'});
			me.getFormItemContainer().resumeEvents();
			Ext.getCmp('compSearch').hide();
			//me.loadResultData();
		}
		else
		{
			Ext.getCmp('schSep').hide();
			Ext.getCmp('scheduleTool').hide();
			Ext.getCmp('backBtnMain').show();
			Ext.getCmp('bkSeperator').show();
			me.getConfigurationform().hide();
			me.getConfigurationform().setDisabled(true);
			//me.loadResultData();
		}
		me.setToolsState(true);
		me.getMain().doLayout();
		delete publicJSON;
	},
	setViewChange : function()
	{
		var me = this;
		if (Ext.getCmp('ecViewchangeRgroup').getValue() == false)// arrange by info and hide max items per page
		{
			me.getMaxPageItems().hide();
		}
		if (Ext.getCmp('ecViewchangeRgroup').getValue() == true)// arrange by date and show max items per page
		{
			me.getMaxPageItems().show();
			me.getMaxPageItems().getStore().loadRawData(publicJSON.pageResultCount);
			me.getMaxPageItems().setValue(publicJSON.selectedPageList);
		}
	},
	getDetails : function(obj)
	{
		var me = this;
		var tempCriteria ="";
		var tempCriteriaPrevious ="";
		var tempUserOption ="";
		var tempUserOptionPrevious ="";
		var s_timeline = me.getTimeLine().getValue()
		var s_maxpageitems = me.getMaxPageItems().getValue();
		var s_viewchange = "";
		var s_changetype = "";
		var compname = "";
		var descname = "";
		var testname = "";
		me.hideApplicationActivities();

		tempCriteria = me.getEcCriteria().getValue();

		if (tempCriteria != 'Component')
		{
			tempUserOption = me.getEcUserOption().getValue();
		}

		if (hiddenFieldsKeys.ec_criteriaPrevious != null && hiddenFieldsKeys.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = hiddenFieldsKeys.ec_criteriaPrevious;
		}
		if (hiddenFieldsKeys.ec_userOptionPrevious != null && hiddenFieldsKeys.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = hiddenFieldsKeys.ec_userOptionPrevious;
		}

		s_changetype = Ext.getCmp("ecChangetypeRgroup").getValue();
		s_viewchange = Ext.getCmp("ecViewchangeRgroup").getValue();

		if (tempCriteria != "" && tempCriteriaPrevious != "")
		{
			if (tempCriteria == tempCriteriaPrevious)
			{
				if (tempUserOption != tempUserOptionPrevious)
				{
					s_changetype = "Latest";
					s_viewchange = "byInformation";
					s_timeline = "1 day";
				}
			}
			else
			{
				s_changetype = "Latest";
				s_viewchange = "byInformation";
				s_timeline = "1 day";
			}
		}

		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
		var url = "../servlet/com.eg.EcConfigurationServletNew";

		this.storeHiddenFields(timeLineCollection);
		var me = this;
		me.getConfigurationform().submit({
			url: url,
			params: "needData=yes&cmd=ChangeConfigNew&ec_viewchange="+s_viewchange+"&ec_changetype="+s_changetype+"&ec_timeline="+s_timeline+"&ec_criteria="+tempCriteria+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&request_from="+request_from+"&id="+id+"&searchCompValue="+encodeURIComponent(compname)+"&searchTestValue="+encodeURIComponent(testname)+"&searchDescValue="+encodeURIComponent(descname)+"&"+hiddenFields,
			method: 'POST',
			success: function(form, action){
				if ( action.response.status == 200 && !Ext.isEmpty( action.response.responseText ) ) {
					publicJSON = Ext.decode(action.response.responseText);
					hiddenFieldsKeys = publicJSON.hiddenFields;
					if (publicJSON.selectedEcOpt != 'Component')
					{
						if (obj.getId() != "ec_userOption")
						{
							me.getEcUserOption().getStore().loadRawData(publicJSON.specViewByList);
							me.getEcUserOption().setValue(publicJSON.selectedUserOptionText);
							me.getEcUserOption().setFieldLabel(publicJSON.specViewByTitle);
							if (publicJSON.specViewByTitle == null || publicJSON.specViewByTitle == undefined)
							{
								me.getEcUserOption().setValue(me.getEcUserOption().getStore().getAt(0).get("valueField"));
							}
						}
						me.getEcUserOption().show();
					}
					else
					{
						me.getEcUserOption().hide();
					}
					me.fillConfigData();
					me.setToolsState(true);
					delete publicJSON;
					delete hiddenFields;
				}
			},
			failure: function(form, action) // if result page doest not contain success:true, this method fires
			{
				switch (action.failureType) {
					case Ext.form.action.Action.CLIENT_INVALID:
						Ext.Msg.alert('Failure', 'Form fields may not be submitted with invalid values');
						break;
					case Ext.form.action.Action.CONNECT_FAILURE:
						Ext.Msg.alert('Failure', 'Ajax communication failed');
						break;
					case Ext.form.action.Action.SERVER_INVALID:
					   Ext.Msg.alert('Failure', action.result.msg);
				}
				delete hiddenFields;
			}
		});
	},
	getCompInfo : function(obj)
	{
		var me = this;
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
		me.hideApplicationActivities();
		//if(obj == "ecOption2")
		//{
			me.getTestNameList().boundList.getSelectionModel().selectAll();
		//}
		//else
		//{
			//me.getTestNameList().boundList.getSelectionModel().deselectAll();
		//}
		this.storeHiddenFields(timeLineCollection);
		Ext.getCmp('ec_test').setDisabled(true);
		me.getConfigurationform().submit({
			url: config.urls.initialURL,
			params : hiddenFields+'request_from='+request_from+'&id='+id+'date='+new Date().getTime(),
			method: 'POST',
			success: function(form, action){
				publicJSON = Ext.decode(action.response.responseText);
				hiddenFieldsKeys = publicJSON.hiddenFields;
				timeLineCollection = publicJSON.hiddenCollections;
				me.getMain().setTitle(publicJSON.applicationTitle);
				Ext.getCmp('ec_test').setDisabled(false);
				me.fillConfigData();
				me.setToolsState(true);
				delete hiddenFields;
				delete publicJSON;
			},
			failure: function(form, action) // if result page doest not contain success:true, this method fires
			{
				delete hiddenFields;
				switch (action.failureType) {
					case Ext.form.action.Action.CLIENT_INVALID:
						Ext.Msg.alert('Failure', 'Form fields may not be submitted with invalid values');
						break;
					case Ext.form.action.Action.CONNECT_FAILURE:
						Ext.Msg.alert('Failure', 'Ajax communication failed');
						break;
					case Ext.form.action.Action.SERVER_INVALID:
					   Ext.Msg.alert('Failure', action.result.msg);
				}
			}
		});
	},
	submitConfigDetails : function()
	{
		var me = this;
		if (request_from != null && request_from == "saveSchedule")
		{
			appCtn.setschedule();
		}
		else
		{
			var checkFlag = appCtn.checkFormValidation("submit");
			if (checkFlag == false)
			{
				return false;
			}
			hiddenFieldsKeys = publicJSON.hiddenFields;
			var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			this.storeHiddenFields(timeLineCollection);
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
			myMask.show();

			var changeTypeVal = Ext.getCmp('ecChangetypeRgroup').inputValue;
			var viewChangeTypeVal = Ext.getCmp('ecViewchangeRgroup').inputValue;

			var curDateFormatInExtjs = getExtjsDateFormat(currentDateFormat);

			var ec_stdate = Ext.Date.dateFormat(Ext.getCmp('ec_stdate').getValue(), curDateFormatInExtjs);
			var ec_enddate = Ext.Date.dateFormat(Ext.getCmp('ec_enddate').getValue(), curDateFormatInExtjs);

			me.getConfigurationform().submit({
				url: config.urls.servletURL,
				async : false,
				params : 'needData=yes&'+hiddenFields+'&ec_changetype='+changeTypeVal+'&ec_viewchange='+viewChangeTypeVal+'&ec_stdate='+ec_stdate+'&ec_enddate='+ec_enddate+'&userDateFormat='+userDateFormat,
				method: 'POST',
				success: function(form, action){
					if(action.response.responseText != null && action.response.responseText != "")
					{
						publicJSON = Ext.decode(action.response.responseText);
						me.loadResultData();
						myMask.hide();
						delete publicJSON;
					}
					else
					{
						myMask.hide();
					}
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
					switch (action.failureType) {
						case Ext.form.action.Action.CLIENT_INVALID:
							Ext.Msg.alert('Failure', 'Form fields may not be submitted with invalid values');
							break;
						case Ext.form.action.Action.CONNECT_FAILURE:
							Ext.Msg.alert('Failure', 'Ajax communication failed');
							break;
						case Ext.form.action.Action.SERVER_INVALID:
						   Ext.Msg.alert('Failure', action.result.msg);
					}
					delete hiddenFields;
				}
			});
		}
	},
	checkFormValidation : function(path)
	{
		var me = this;
		var tempCriteria = "";
		var tempUserOption = "";

		tempCriteria = me.getEcCriteria().getValue();
		if (tempCriteria != 'Component')
		{
			tempUserOption = me.getEcUserOption().getValue();
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != "-1")
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == "-1")
			{
				if (tempCriteria == "Zone")
				{
					Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorZone);
					return false;
				}
				else if (tempCriteria == "Service")
				{
					Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorService);
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorSegment);
					return false;
				}
			}
		}

		var option1 = me.getEcOption1().getValue();
		if (option1 != "All Components")
		{
			var option2 = me.getEcOption2().getValue();
			
			if (option2 == "Please choose a component type")
			{
				Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorMsg1);
				return false;
			}

			if (option2 == "Please choose a component")
			{
				Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorMsg2);
				return false;
			}
		}

		if (me.getTestNameList().getValue() == "-1")
		{
			Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorMsg3);
			return false;
		}

		var timeline = me.getTimeLine().getValue();
		if (timeline == "Any" && path == "schedule")
		{
			Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorMsg4);
			return false;
		}

		if (timeline == "Any")
		{
			var startDate = me.getStartDate().getValue();
			var startHr = me.getStartHour().getValue();
			var startMin = me.getStartMinute().getValue();

			var endDate = me.getEndDate().getValue();
			var endHr = me.getEndHour().getValue();
			var endMin = me.getEndMinute().getValue();

			var curDateInExtjsFormat = getExtjsDateFormat(currentDateFormat);

			//Convert to original format(i.e., to MM/dd/yyyy)
			var startdate1 = Ext.Date.dateFormat(startDate, curDateInExtjsFormat);
			var enddate1 = Ext.Date.dateFormat(endDate, curDateInExtjsFormat);

			var sDate = formatDate(new Date(getDateFromFormat(startdate1,currentDateFormat)),"MM/dd/yyyy");
			var eDate = formatDate(new Date(getDateFromFormat(enddate1,currentDateFormat)),"MM/dd/yyyy");

			if(!validateDateTime(sDate,eDate,startHr,endHr,startMin,endMin))
			{
				Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorTimeLine);
				return false;
			}
		}
	},
	loadResultData : function()
	{
		var me = this;
		if (publicJSON.hasConfigDetails)
		{
			Ext.getCmp("configurationform").collapse();
			me.getErrorpanel().hide();
			me.getResultViewContainer().removeAll();
			me.getResultViewContainer().show();

			if (publicJSON.allComponentsOpt != undefined && publicJSON.allComponentsOpt)
			{
				Ext.getCmp('changesTimeLineId').setText(publicJSON.allComponentsDiv.timeLineHead);
				Ext.getCmp('resultViewContainer').setTitle(publicJSON.allComponentsDiv.subHead);
				var viewPanel = {
					xtype: 'outerPanel',
					layout:{
						type:'vbox',
						align:'stretch',
						pack:'center',
					},
					height:'100%',
					id:'allCompPanel',
					margin: '10 10 0 10',
					items: [
						{
							xtype: 'allconfigchangeschart',
							style : {'text-align':'center'}
						},
						{
							xtype : 'alloptionconfiggridtemplate',
							margin : 10,
							style:{'border-color': '#222222 #424242 #424242 #424242'},
							tools : [
								{
									xtype : 'tbspacer'
								},
								{
									xtype : 'label',
									html : publicJSON.allComponentsDiv.gridSubTitle1
								},
								{
									xtype : 'tbseparator'
								},
								{
									xtype : 'label',
									html : publicJSON.allComponentsDiv.gridSubTitle2
								},
								{
									xtype : 'tbseparator'
								},
								{
									xtype: 'button',
									id : 'te',
									name : 'te',
									iconCls: 'iconExpandAll',
									hidden:true,
									style: {
										background: 'none',
										border: '0px'
									},
									listeners: {
										'click':function(obj){
											this.hide();
											Ext.getCmp('tc').show();
											var thisGrid = Ext.getCmp('alloptionconfiggridtemplate');
											var groupingFeature = thisGrid.view.getFeature('groupHeaderId');
											groupingFeature.expandAll();
										}
									}
								},
								{
									xtype:'button',
									id :'tc',
									name :'tc',
									iconCls: 'iconCollapseAll',
									hidden:false,
									style: {
										background: 'none',
										border: '0px'
									},
									listeners:{
										'click':function(obj){
											this.hide();
											Ext.getCmp('te').show();
											var thisGrid = Ext.getCmp('alloptionconfiggridtemplate');
											var groupingFeature = thisGrid.view.getFeature('groupHeaderId');
											groupingFeature.collapseAll();
										}
									}
								}
							],
							title : publicJSON.allComponentsDiv.gridTitle
						}
					]
				}
				me.getResultViewContainer().suspendEvents(true);
				me.getResultViewContainer().add(viewPanel);
				me.getAllconfigchangeschart().updateBoxData(publicJSON.allComponentsDiv);
				me.getAlloptionconfiggridtemplate().getStore().loadRawData(publicJSON.allComponentsDiv.gridData);
				me.getResultViewContainer().resumeEvents();
			}
			else if (publicJSON.ComponentTypeOnly != undefined && publicJSON.ComponentTypeOnly)
			{
				Ext.getCmp('changesTimeLineId').setText(publicJSON.allComponentsDiv.timeLineHead);
				Ext.getCmp('resultViewContainer').setTitle(publicJSON.allComponentsDiv.subHead);
				var viewPanel = {
					xtype: 'outerPanel',
					id : 'compTypePanel',
					margin: '10 10 0 10',
					items: [
						{
							xtype: 'allconfigchangeschart',
							style : {'text-align':'center'},
							margin : '10 10 10 10'
						},
						{
							xtype : 'configgridtemplate',
							store: new Ext.data.Store({
								fields: ['column_1', 'column_2','column_3','componentType'],
								data: publicJSON.allComponentsDiv.gridData,
								groupField : ['componentType'],
								sortOnLoad : false
							}),
							features: [{
								ftype: 'grouping',
								id : 'groupHeaderId',
								groupHeaderTpl: [
									'<div>{name:this.formatgroupHeaderFun}</div>',
									{
										formatgroupHeaderFun: function(name) {
											return Ext.String.trim(name);
										}
									}
								],
								hideGroupedHeader: false,
								startCollapsed: false
							}],
							viewConfig:{
								cls:'gridSkin_expander_view'
							},
							cls:'gridSkin_expander',
							margin : 10,
							title : publicJSON.allComponentsDiv.gridTitle,
							columns : {
								defaults: {
									sortable: false,
									hideable: false,
									menuDisabled: true,
									draggable: false,
									resizable: false
								},
								items : [
									{
										header : '',
										dataIndex : 'column_1',
										menuDisabled : true,
										flex : 1,
										renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
										{
											if (value.indexOf("|C|") != -1)
											{
												var tmpArr = value.split("|C|");
												
												return '<a id="mouse" href="javascript:void(0)" onclick=\'javascript:appCtn.showComponentChanges("'+tmpArr[2]+'")\' class="eg_monlink" style="font-size: 11px;">'+tmpArr[0]+'</a> ['+tmpArr[1]+']';
											}
											else
											{
												metaData.tdCls += "OStable_emptytd";
												return value;
											}
										}
									},
									{
										header : '',
										dataIndex : 'column_2',
										flex : 1,
										menuDisabled : true,
										renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
										{
											if (value.indexOf("|C|") != -1)
											{
												var tmpArr = value.split("|C|");
												
												return '<a id="mouse" href="javascript:void(0)" onclick=\'javascript:appCtn.showComponentChanges("'+tmpArr[2]+'")\' class="eg_monlink" style="font-size: 11px;">'+tmpArr[0]+'</a> ['+tmpArr[1]+']';
											}
											else
											{
												metaData.tdCls += "OStable_emptytd";
												return value;
											}
										}
									},
									{
										header : '',
										dataIndex : 'column_3',
										menuDisabled : true,
										sortable : false,
										flex : 1,
										renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
										{
											if (value.indexOf("|C|") != -1)
											{
												var tmpArr = value.split("|C|");
												
												return '<a id="mouse" href="javascript:void(0)" onclick=\'javascript:appCtn.showComponentChanges("'+tmpArr[2]+'")\' class="eg_monlink" style="font-size: 11px;">'+tmpArr[0]+'</a> ['+tmpArr[1]+']';
											}
											else
											{
												metaData.tdCls += "OStable_emptytd";
												return value;
											}
										}
									}
								]
							},
							hideHeaders : true,
							tools : [
								{
									xtype : 'tbspacer'
								},
								{
									xtype : 'label',
									html : publicJSON.allComponentsDiv.gridSubTitle1
								},
								{
									xtype : 'tbseparator'
								},
								{
									xtype : 'label',
									html : publicJSON.allComponentsDiv.gridSubTitle2
								},
								{
									xtype : 'tbseparator'
								},
								{
									xtype: 'button',
									id : 'te',
									name : 'te',
									iconCls: 'iconExpandAll',
									hidden:true,
									style: {
										background: 'none',
										border: '0px'
									},
									listeners: {
										'click':function(obj){
											this.hide();
											Ext.getCmp('tc').show();
											var thisGrid = Ext.getCmp('configgridtemplate');
											var groupingFeature = thisGrid.view.getFeature('groupHeaderId');
											groupingFeature.expandAll();
										}
									}
								},
								{
									xtype:'button',
									id :'tc',
									name :'tc',
									iconCls: 'iconCollapseAll',
									hidden:false,
									style: {
										background: 'none',
										border: '0px'
									},
									listeners:{
										'click':function(obj){
											this.hide();
											Ext.getCmp('te').show();
											var thisGrid = Ext.getCmp('configgridtemplate');
											var groupingFeature = thisGrid.view.getFeature('groupHeaderId');
											groupingFeature.collapseAll();
										}
									}
								}
							]
						}
					]
				}
				me.getResultViewContainer().suspendEvents(true);
				me.getResultViewContainer().add(viewPanel);
				me.getAllconfigchangeschart().updateBoxData(publicJSON.allComponentsDiv);
				me.getResultViewContainer().resumeEvents();
			}
			if(publicJSON.ArrangeBy == "info")
			{
				var gridCollection = "";
				var tplView = "";
				var chartArray = new Array();
				for (key in publicJSON.aListComponentsView)
				{
					if (request_from == 'DCDSForDashboard' || request_from == 'CSForDashboard') // for dashboard only[i.e., from dashboard]
					{
						Ext.getCmp('changesTimeLineId').setText(publicJSON.allComponentsDiv.timeLineHead); // main title
						Ext.getCmp('resultViewContainer').setTitle(publicJSON.allComponentsDiv.subHead);

						tplView = tplView + '<div class="dataPanel config_datapanelWithoutShadow" style="margin:10px" ><div class="x-panel-header" style="padding:5px 10px 5px 10px"><span class="x-panel-header-text" style="float:left; height: 29px;">'+publicJSON.aListComponentsView[key].panelLeftDisplayValue+'</span>&nbsp;&nbsp;<span class="x-panel-header-text" style="float:right; height: 29px;">'+publicJSON.aListComponentsView[key].panelRightDisplayValue+'</span></div>'; // for each comp title
					}
					else // for own page, changes by comp name and changes by comp type
					{
						if (!Ext.isEmpty(request_from) && request_from.toLowerCase() == 'current')
						{
							Ext.getCmp('changesTimeLineId').setText(publicJSON.aListComponentsView[key].panelRightDisplayValue); // main title
							Ext.getCmp('resultViewContainer').setTitle(publicJSON.aListComponentsView[key].panelLeftDisplayValue);
						}

						if (!Ext.isEmpty(request_from) && request_from.toLowerCase() == 'os')
						{
							Ext.getCmp('changesTimeLineId').setText(publicJSON.aListComponentsView[key].panelRightDisplayValue); // main title
							Ext.getCmp('resultViewContainer').setTitle(publicJSON.aListComponentsView[key].panelLeftDisplayValue);
						}

						var configLayout = publicJSON.configurationLayout;
						if ( !Ext.isEmpty(configLayout) && ( configLayout.toLowerCase() == 'search1' || configLayout.toLowerCase() == 'search2') && !Ext.isEmpty(request_from) && !request_from.toLowerCase() == 'cs')
						{
							Ext.getCmp('changesTimeLineId').setText(publicJSON.aListComponentsView[key].panelRightDisplayValue); // main title
							Ext.getCmp('resultViewContainer').setTitle(publicJSON.aListComponentsView[key].panelLeftDisplayValue);
						}
						else
						{
							var option1Obj = Ext.getCmp('ec_option1');
							if (!Ext.isEmpty(option1Obj))
							{
								var selChangeCriteria = option1Obj.getValue();
								if (!Ext.isEmpty(selChangeCriteria) && selChangeCriteria.toLowerCase() == 'component name')
								{
									Ext.getCmp('changesTimeLineId').setText(publicJSON.aListComponentsView[key].panelRightDisplayValue); // main title
									Ext.getCmp('resultViewContainer').setTitle(publicJSON.aListComponentsView[key].panelLeftDisplayValue);
								}
							}
							else
							{
								if (!Ext.isEmpty(request_from) && !request_from.toLowerCase() == 'cs')
								{
									tplView = tplView + '<div class="dataPanel  config_datapanelWithoutShadow" style="margin:10px"><div class="x-panel-header"  style="padding:5px 10px 5px 10px"><span class="x-panel-header-text" style="float:left; height: 29px;">'+publicJSON.aListComponentsView[key].panelLeftDisplayValue+'</span>&nbsp;&nbsp;<span class="x-panel-header-text" style="float:right; height: 29px;">'+publicJSON.aListComponentsView[key].panelRightDisplayValue+'</span></div>'; // each component title
								}
							}
						}

						var option1Obj = Ext.getCmp('ec_option1');
						if (!Ext.isEmpty(option1Obj))
						{
							var selChangeCriteria = option1Obj.getValue();
							if (!Ext.isEmpty(selChangeCriteria) && selChangeCriteria.toLowerCase() != 'component name')
							{
								tplView = tplView + '<div class="dataPanel  config_datapanelWithoutShadow" style="margin:10px"><div class="x-panel-header"  style="padding:5px 10px 5px 10px"><span class="x-panel-header-text" style="float:left; height: 29px;">'+publicJSON.aListComponentsView[key].panelLeftDisplayValue+'</span>&nbsp;&nbsp;<span class="x-panel-header-text" style="float:right; height: 29px;">'+publicJSON.aListComponentsView[key].panelRightDisplayValue+'</span></div>'; // each component title
							}
						}

						if (!Ext.isEmpty(request_from) && (request_from.toLowerCase() == 'caag' || request_from.toLowerCase() == 'caagfordashboard'))
						{
							Ext.getCmp('changesTimeLineId').setText(publicJSON.aListComponentsView[key].panelRightDisplayValue); // main title
							Ext.getCmp('resultViewContainer').setTitle(publicJSON.aListComponentsView[key].panelLeftDisplayValue);
						}

						if (!Ext.isEmpty(request_from) && request_from.toLowerCase() == 'cs' && linkClickFrom.toLowerCase() != 'componentname')
						{
							tplView = tplView + '<div class="dataPanel  config_datapanelWithoutShadow" style="margin:10px"><div class="x-panel-header"  style="padding:5px 10px 5px 10px"><span class="x-panel-header-text" style="float:left; height: 29px;">'+publicJSON.aListComponentsView[key].panelLeftDisplayValue+'</span>&nbsp;&nbsp;<span class="x-panel-header-text" style="float:right; height: 29px;">'+publicJSON.aListComponentsView[key].panelRightDisplayValue+'</span></div>'; // each component title
						}

						if (!Ext.isEmpty(linkClickFrom) && linkClickFrom.toLowerCase() == 'componentname')
						{
							Ext.getCmp('changesTimeLineId').setText(publicJSON.aListComponentsView[key].panelRightDisplayValue); // main title
							Ext.getCmp('resultViewContainer').setTitle(publicJSON.aListComponentsView[key].panelLeftDisplayValue);
						}
					}

					tplView = tplView + '<div id="'+publicJSON.aListComponentsView[key].chartContainer.chartId+'" style="text-align:center;"></div>';
					chartArray.push(publicJSON.aListComponentsView[key].chartContainer);
					for (key2 in publicJSON.aListComponentsView[key].gridContainer)
					{
						tplView = tplView + me.createXTemplate(publicJSON.aListComponentsView[key].gridContainer[key2]);
					}
					tplView = tplView + "</div>";
				}

				var viewPanel2 = {
					xtype: 'panel',
					id : 'byInfoPanel',
					layout:{
						align:'stretch',
						pack:'center'
					},
					flex:1,
					html : tplView
				}

				me.getResultViewContainer().add(viewPanel2);
				if (Ext.isEmpty(fromMonitor) || fromMonitor != 'true')
				{
					for (chartCol in chartArray)
					{
						if (chartType == 'fusioncharts')
						{
							if (FusionCharts("myColumnChartId_"+chartCol)) 
								FusionCharts("myColumnChartId_"+chartCol).dispose();
							var chart2 = new FusionCharts(chartArray[chartCol].swfPath, "myColumnChartId_"+chartCol, "650", "250","0","1");
							chart2.setDataXML(chartArray[chartCol].xmlString);
							chart2.setTransparent(true);
							chart2.render(chartArray[chartCol].chartId);
						}
						else
						{
							var highChart = {};
							highChart = jQuery.extend(true, {}, getHighChartsInstance(chartArray[chartCol].chartId,chartArray[chartCol].chartHeight-20,chartArray[chartCol].chartWidth+50), highChart);
							highChart.setData(chartArray[chartCol],currentDateFormat,'');
							highChart.drawChart();
						}
					}
				}
			}
			else
			{
				if (publicJSON.ComponentNameOnly != undefined && publicJSON.ComponentNameOnly)
				{
					Ext.getCmp('changesTimeLineId').setText(publicJSON.allComponentsContaienr.timeLineHead);
					Ext.getCmp('resultViewContainer').setTitle(publicJSON.allComponentsContaienr.subHead);
					var viewPanel = {
						xtype: 'panel',
						id : 'byDatePanel',
						style :{'border':'1px'},
						defaults : {
							margin : 10
						},
						items: [
							{
								xtype: "allconfigchangeschart",
								style : {'text-align':'center'},
								margin :5
							}
						]
					}
					me.getResultViewContainer().suspendEvents(true);
					me.getResultViewContainer().add(viewPanel);
					me.getAllconfigchangeschart().updateBoxData(publicJSON.allComponentsContaienr);
					me.getResultViewContainer().resumeEvents();
				}

				me.getResultViewContainer().add({
					xtype : 'configpaginggrid',
					margin : '5 10 10 10',
					arrayStore : publicJSON.allComponentsContaienr.gridData,
					pageLimit : publicJSON.allComponentsContaienr.maxPageItems
				});

				if (publicJSON.allComponentsContaienr.hideComponentColumn)
				{
					me.getConfigpaginggrid().columns[1].hide();
				}
				else
				{
					me.getConfigpaginggrid().columns[1].show();
				}
			}
			me.getResultViewContainer().doComponentLayout();
			me.setToolsState(false);
		}
		else
		{
			me.getResultViewContainer().removeAll();
			me.getResultViewContainer().hide();
			me.setToolsState(true);
			me.getErrorpanel().hide();
			if (publicJSON.errorText != null && publicJSON.errorText != undefined)
			{
				me.getErrorpanel().update('<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+ publicJSON.errorText +'</div></div></div>');
				me.getErrorpanel().show();
			}
		}
	},
	loadTools : function()
	{
		this.getTools().loadIcon(true,true,true,true,true,true);
	},
	setToolsState : function(iconState)
	{
		var me = this;
		var saveObj =me.getTools().getComponent('saveTool');
		var printObj =me.getTools().getComponent('printTool');
		var mailObj =me.getTools().getComponent('mailTool');
		var csvObj =me.getTools().getComponent('csvTool');
		var scheduleToolObj = me.getTools().getComponent('scheduleTool');
		var combineBookletObj = me.getTools().getComponent('bookletTool');
		if (publicJSON.configurationLayout == 'showConfigForm')
		{
			var ec_option2 = me.getEcOption2().getValue();
			var ec_option1 = me.getEcOption1().getValue();
			var ecUserOption = me.getEcUserOption().getValue();

			if (!Ext.isEmpty(scheduleToolObj) && (ec_option2 != '-1' || (ec_option1 == 'All Components' && ecUserOption != '-1' && ecUserOption != null && ecUserOption != ""))) {
				scheduleToolObj.setDisabled(false);
			}
			else
			{
				scheduleToolObj.setDisabled(iconState);
			}
		}
		else
		{
			if (!Ext.isEmpty(scheduleToolObj)) {
				scheduleToolObj.setDisabled(iconState);
			}
		}
		if (!Ext.isEmpty(saveObj)) {
			saveObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(printObj)) {
			printObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(mailObj)) {
			mailObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(csvObj)) {
			csvObj.setDisabled(iconState);
		}

		if (!Ext.isEmpty(scheduleToolObj) && (ec_option2 != '-1' || (ec_option1 == 'All Components' && ecUserOption != '-1' && ecUserOption != null && ecUserOption != ""))) {
			scheduleToolObj.setDisabled(false);
		}
		else
		{
			scheduleToolObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(combineBookletObj)) {
			combineBookletObj.setDisabled(iconState);
		}
	},
	fillConfigData : function()
	{
		var me = this;
		me.getTimeLine().getStore().loadRawData(publicJSON.timeLineDetails.ec_timelineArr);
		me.getTimeLine().setValue(publicJSON.timeLineDetails.selectedTimeLine);
		me.getTimeLine().setValue(publicJSON.timeLineDetails.selectedTimeLine);
		me.getTimeLine().setFieldLabel(publicJSON.timeLineDetails.TimeLineLabel);
		
		// From Date
		me.getStartDate().setValue(publicJSON.timeLineDetails.ec_stdate);
		me.getStartDate().setFieldLabel(publicJSON.timeLineDetails.FromLabel);

		me.getStartHour().getStore().loadRawData(publicJSON.timeLineDetails.ec_sthr);
		me.getStartHour().setValue(publicJSON.timeLineDetails.selectedStartHr);
		me.getStartHour().setFieldLabel(publicJSON.timeLineDetails.FromHrLabel);

		me.getStartMinute().getStore().loadRawData(publicJSON.timeLineDetails.ec_startmin);
		me.getStartMinute().setValue(publicJSON.timeLineDetails.selectedStartMin);
		me.getStartMinute().setFieldLabel(publicJSON.timeLineDetails.FromMinsLabel);

		// To Date
		me.getEndDate().setValue(publicJSON.timeLineDetails.ec_enddate);
		me.getEndDate().setFieldLabel(publicJSON.timeLineDetails.ToLabel);

		me.getEndHour().getStore().loadRawData(publicJSON.timeLineDetails.ec_endhr);
		me.getEndHour().setValue(publicJSON.timeLineDetails.selectedEndHr);
		me.getEndHour().setFieldLabel(publicJSON.timeLineDetails.ToHrLabel);

		me.getEndMinute().getStore().loadRawData(publicJSON.timeLineDetails.ec_endmin);
		me.getEndMinute().setValue(publicJSON.timeLineDetails.selectedEndMin);
		me.getEndMinute().setFieldLabel(publicJSON.timeLineDetails.ToMinsLabel);

		if (publicJSON.timeLineDetails.selectedTimeLine == "Any")
		{
			me.getStartDate().setDisabled(false);
			me.getStartHour().setDisabled(false);
			me.getStartMinute().setDisabled(false);

			me.getEndDate().setDisabled(false);
			me.getEndHour().setDisabled(false);
			me.getEndMinute().setDisabled(false);
		}
		else
		{
			me.getStartDate().setDisabled(true);
			me.getStartHour().setDisabled(true);
			me.getStartMinute().setDisabled(true);

			me.getEndDate().setDisabled(true);
			me.getEndHour().setDisabled(true);
			me.getEndMinute().setDisabled(true);
		}

		me.getEcOption1().getStore().loadRawData(publicJSON.changeCrArr);
		me.getEcOption1().setValue(publicJSON.changeCriteria);

		if (publicJSON.hasSelectionCmb)
		{
			me.getEcOption2().setFieldLabel(publicJSON.selectionCmbTitle);
			me.getEcOption2().getStore().loadRawData(publicJSON.ec_option2Arr);
			me.getEcOption2().setValue(publicJSON.selectedEcOption2);
			me.getEcOption2().show();
		}
		else
		{
			me.getEcOption2().hide();
			me.getEcOption2().getStore().removeAll();
		}
		me.getTestNameList().getStore().loadRawData(publicJSON.ec_testArr);
		me.getTestNameList().setValue(publicJSON.selectedTests);

		if (publicJSON.showBy == "Latest") // show recent changes
		{
			Ext.getCmp('ecChangetypeRgroup').setValue(false);
		}
		else // show all changes
		{
			Ext.getCmp('ecChangetypeRgroup').setValue(true);
		}

		if (publicJSON.arrangeBy == "byInformation") // arrange by info
		{
			Ext.getCmp('ecViewchangeRgroup').setValue(false);
			me.getMaxPageItems().hide();
		}
		else // arrange by date and show max items per page
		{
			Ext.getCmp('ecViewchangeRgroup').setValue(true);
			me.getMaxPageItems().show();
			me.getMaxPageItems().getStore().loadRawData(publicJSON.pageResultCount);
			me.getMaxPageItems().setValue(publicJSON.selectedPageList);
		}
	},
	changeTimeLine : function()
	{
		var me = this;
		var tempCriteria = me.getEcCriteria().getValue();
		var tempUserOption = "";
		if (tempCriteria != 'Component')
		{
			tempUserOption = me.getEcUserOption().getValue();
		}
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
		me.hideApplicationActivities();
		this.storeHiddenFields(timeLineCollection);

		var ec_stdate = Ext.Date.dateFormat(Ext.getCmp('ec_stdate').getValue(), mgrDateFormat);
		var ec_enddate = Ext.Date.dateFormat(Ext.getCmp('ec_enddate').getValue(), mgrDateFormat);

		var me = this;
		me.getConfigurationform().submit({
			url: config.urls.initialURL,
			params : hiddenFields+'&request_from='+request_from+'&id='+id+'date='+new Date().getTime()+'&ec_stdate='+ec_stdate+'&ec_enddate='+ec_enddate,
			method: 'POST',
			success: function(form, action){

				publicJSON = Ext.decode(action.response.responseText);
				timeLineCollection = publicJSON.hiddenCollections;
				me.fillConfigData();
				me.getHiddenFieldsCt().removeAll();
				delete publicJSON;
				delete hiddenFields;
			},
			failure: function(form, action) // if result page doest not contain success:true, this method fires
			{
				me.getHiddenFieldsCt().removeAll();
				delete hiddenFields;
				switch (action.failureType) {
					case Ext.form.action.Action.CLIENT_INVALID:
						Ext.Msg.alert('Failure', 'Form fields may not be submitted with invalid values');
						break;
					case Ext.form.action.Action.CONNECT_FAILURE:
						Ext.Msg.alert('Failure', 'Ajax communication failed');
						break;
					case Ext.form.action.Action.SERVER_INVALID:
					   Ext.Msg.alert('Failure', action.result.msg);
				}
			}
		});
	},
	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+hiddenFields[key]+"&";
		}
		return hiddenQstr;
	},
	storeHiddenFields : function(fields)
	{
		var me = this;
		var tmpField = "";
		var tmpArr = new Array();

		this.getHiddenFieldsCt().removeAll();

		for (key in fields)
		{

			if (key == "ec_stdate_h" || key == "ec_enddate_h")
			{
				if (me.getTimeLine().getValue() == "Any")
				{
					var startdate = Ext.Date.dateFormat(Ext.getCmp('ec_stdate').getValue(), mgrDateFormat);
					var enddate = Ext.Date.dateFormat(Ext.getCmp('ec_enddate').getValue(), mgrDateFormat);
					if (key == "ec_stdate_h")
					{
						tmpField = {
							xtype : 'hiddenfield',
							name : key,
							value : startdate
						}
					}
					else
					{
						tmpField = {
							xtype : 'hiddenfield',
							name : key,
							value : enddate
						}
					}
				}
				else
				{
					tmpField = {
						xtype : 'hiddenfield',
						name : key,
						value : fields[key]
					}
				}
			}
			else
			{
				tmpField = {
					xtype : 'hiddenfield',
					name : key,
					value : fields[key]
				}
			}
			tmpArr.push(tmpField);
		}
		this.getHiddenFieldsCt().add(tmpArr);
		tmpArr = new Array();
	},
	getAllChangesDateForThisMeasure : function(curMesCnt,data)
	{
		var allChangesDate = "";
		for(var t = curMesCnt; t < data.length; t++)
		{
			if( t > curMesCnt && data[t].Measure != '&nbsp;')
			{
				break;
			}
			allChangesDate += "<div style='line-height:2em;'>"+data[t].ChangeDate +"</div>";
		}
		return allChangesDate;
	},

	getAllPreviousValueForThisMeasure : function(curMesCnt,data)
	{
		var allPreviousDate = "";
		for(var t = curMesCnt; t < data.length; t++)
		{
			var descriptor = data[0].Descriptor;
			if (typeof descriptor == 'undefined')
			{
				descriptor = "+";
			}
			
			else if(descriptor.indexOf("New#new_info")> -1)	
			{	
				descriptor = descriptor.substring(0, descriptor.indexOf("New#new_info")-1);
			}
			if( t > curMesCnt && data[t].Measure != '&nbsp;')
			{
				break;
			}
			var preVal = data[t].PreviousValue;
			var preValTemp = preVal.split(/[ ,]/);
			if(preValTemp[0].toLowerCase() == 'click')
			{
				var preValTemp1 = preVal.split("#$#");
				var realPreVal = preValTemp1[0];
				var urlLink = preValTemp1[1];
				allPreviousDate += '<div style="line-height:2em;"><a id="mouse" href=\'javascript:goToMeasureComparisonPage(\"'+encodeURIComponent(filterEncode(descriptor))+'\",\"'+ urlLink+'\")\' target="_self">'+realPreVal+'</a></div>';				
			}
			else
			{
				allPreviousDate += "<div style='line-height:2em;'>" + preVal + "</div>";
			}
		}
		return allPreviousDate;
	},

	getAllPresentValueForThisMeasure : function(curMesCnt,data)
	{
		var allPresentDate = "";
		for(var t = curMesCnt; t < data.length; t++)
		{
			var descriptor = data[0].Descriptor;
			if (typeof descriptor == 'undefined')
			{
				descriptor = "+";
			}
			else if(descriptor.indexOf("New#new_info")> -1)	
			{	
				descriptor = descriptor.substring(0, descriptor.indexOf("New#new_info")-1);
			}
			if( t > curMesCnt && data[t].Measure != '&nbsp;')
			{
				break;
			}
			var presentVal = data[t].PresentValue;
			var presentValTemp = presentVal.split(/[ ,]/);
			if(presentValTemp[0].toLowerCase() == 'click')
			{
				var presentValTemp1 = presentVal.split("#$#");
				var realPresentVal = presentValTemp1[0];
				var urlLink = presentValTemp1[1];
				allPresentDate += '<div style="line-height:2em;"><a id="mouse" href=\'javascript:goToMeasureComparisonPage(\"'+encodeURIComponent(filterEncode(descriptor))+'\",\"'+ urlLink+'\")\' target="_self">'+realPresentVal+'</a></div>';								
			}
			else
			{
				var preVal = "";
				var tmpStr = data[t].PresentValue;
				if (tmpStr.indexOf("|Diff#") != -1)
				{
					var tmpStr2 = tmpStr.substring(tmpStr.indexOf("|Diff#") + 6);
					var diffArr = tmpStr2.split("|$|");
					preVal += tmpStr.substring(0,tmpStr.indexOf("|Diff#"));
					preVal += '<img src="/final/images/diff.png" onclick=\'javascript:appCtn.loadChange("'+encodeURIComponent(filterEncode(diffArr[0]))+'","'+encodeURIComponent(filterEncode(diffArr[1]))+'","'+encodeURIComponent(filterEncode(diffArr[2]))+'","'+encodeURIComponent(filterEncode(diffArr[3]))+'","'+encodeURIComponent(filterEncode(diffArr[4]))+'","'+encodeURIComponent(filterEncode(diffArr[5]))+'");\' alt="Show the difference" class="mouse"/>';
				}
				else
				{
					preVal += tmpStr;
				}
				allPresentDate += "<div style='line-height:2em;'>"+ preVal +"</div>";
			}
		}
		return allPresentDate;
	},


	createXTemplate : function(gridContainerObj)
	{
		var me = this;
		var tplView = "";
		tplView += '<div class="changeConfig_div">';
		if(gridContainerObj.hasDescriptors == "true")
		{
			tplView += '<table border="0" cellspacing="0" cellpadding="0" class="configurationTable2" width="100%">';
		}
		else
		{
			tplView += '<table border="0" cellspacing="0" cellpadding="0" class="configurationTable1" width="100%">';
		}
		tplView = tplView + '<thead><th class="configurationTableHead">'+gridContainerObj.gridTitle+'</th></thead>';

		tplView = tplView +'<tbody><tr><td><div class="configurationInnerTable"><table cellspacing="0" style="width:100%" cellpadding="5" border="0" align="center"><thead><tr>';
		for (c in gridContainerObj.gridColumns)
		{
			var str = gridContainerObj.gridColumns[c];
			tplView = tplView + '<th>'+str+'</th>';
		}
		tplView = tplView + '</tr></thead>';

		for (c1 in gridContainerObj.gridColumnData)
		{
			var rowData = gridContainerObj.gridColumnData[c1].rowData;
			var count = 0;
			var hasDesc = false;
			for (var i = 0; i < rowData.length; i++) // measures and changes data
			{
				var measure = rowData[i].Measure;
				if(measure != null && measure != "" && measure != undefined)
				{
					if(measure != "&nbsp;")
					{
						tplView = tplView + '<tr>';
						if (count == 0)
						{
							if (gridContainerObj.hasDescriptors == "true")
							{
								hasDesc = true;
								var tmpStr = rowData[0].Descriptor;
								if (tmpStr.indexOf("|New#") != -1)
								{
									tplView = tplView + '<td style="vertical-align:top; width:30%">'+tmpStr.substring(0,tmpStr.indexOf("|New#"));
									tplView = tplView + '&nbsp;<img src="/final/config/images/new_info.gif" border="0"></td>';
								}
								else
								{
									tplView = tplView + '<td style="vertical-align:top; width:30%">'+tmpStr+'</td>';
								}
							}
							count++;
						}
						else
						{
							if (hasDesc)
							{
								tplView = tplView + '<td style="vertical-align:top; width:30%">&nbsp;</td>';
							}
						}
						tplView = tplView +'<td style="vertical-align:top;width:17.5%">'+rowData[i].Measure+'</td>';
						var changesDate = me.getAllChangesDateForThisMeasure(i,rowData);
						tplView += "<td style='vertical-align:top;width:17.5%'>"+changesDate+"</td>";
						var previousValues = me.getAllPreviousValueForThisMeasure(i,rowData);
						tplView += "<td style='vertical-align:top;width:17.5%'>"+previousValues+"</td>";
						var presentValues = me.getAllPresentValueForThisMeasure(i,rowData);
						tplView += "<td style='vertical-align:top;width:17.5%'>"+presentValues+"</td>";
						tplView = tplView + '</tr>';
					}
				}
			}
			//tplView += '</tr>';
		}
		tplView = tplView + '</table></div></td></tr></tbody></table></div>';
		return tplView;
	},

	loadChange : function(previousValue,presentValue,compValue,testValue,descValue,measureValue)
	{
		var me = this;
		Ext.Ajax.request({
			url : '/final/config/ecShowDifference.jsp',
			params : "previousValue="+previousValue+"&presentValue="+presentValue+"&componentName="+compValue+"&testName="+testValue+"&descriptor="+descValue+"&measureName="+measureValue,
			method : 'POST',
			success : function(response)
			{
				Ext.widget('window',{
					layout : 'fit',
					minHeight:250,
					maxHeight:500,
					autoHeight : true,
					width: 400,
					flex : 1,
					modal : true,
					ghost : false,
					bodyCls:'config_diff_window',
					autoScroll : true,
					scroll : false,
					closeAction: 'destory',
					constrain : true,
					title : 'Difference',
					html : response.responseText,
					doClose: function() {
						this.destroy();
					},
					listeners:{
						show: function(win) {
							if (this.modal) {
								var doms = Ext.dom.Query.select('.x-mask');
								for (var key in doms)
								{
									this.dom=doms[key];
									if (!Ext.isEmpty(this.dom.offsetParent))
									{
										if (this.dom.offsetParent.tagName=='BODY')
										{
											Ext.fly(this.dom).addCls('windowModal');
										}
									}
								}
							}
						},
						hide:  function(win) {
							if (this.modal) {
								Ext.fly(this.dom).removeCls('windowModal');
							}
						},
						afterrender:function(){
							Ext.EventManager.onWindowResize(function(){
							var me = this;
							me.center();
							},this);
						}
					}
				}).show();
			}
		});
	},
	hideApplicationActivities : function()
	{
		var me = this;
		me.getResultViewContainer().hide();
		me.getErrorpanel().hide();
		me.setToolsState(true);
	},
	saveAsPDF : function()
	{
		//var getSaveObj = Ext.widget('savepdf');
		//getSaveObj.savePDF("/final/servlet/com.eg.EcPdfDownloadC");

		downloadAsPDF("/final/servlet/com.eg.EcPdfDownloadC");
	},
	printData : function()
	{
		var printQueryStr = publicJSON.printQueryStr;
		Ext.widget('print',{title : config.title.mainPageTitle}).show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set({
			src: printQueryStr
		});
	},
	saveAsCSV : function()
	{
		var me = this;
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
		var urlStr = "../servlet/com.eg.EcCSVController";


		me.getConfigurationform().submit({
			url: urlStr,
			params: "ec_criteria="+backOperation.ec_criteria+"&ec_userOption="+encodeURIComponent(backOperation.ec_userOption)+"&"+hiddenFields,
			standardSubmit : true,
			method: 'POST'
		});
	},
	sendMail : function()
	{
		Ext.widget('sendmail').show();
	},
	setschedule : function()
	{
		var op = "schedule";
		var me = this;
		var ecCriteria = me.getEcCriteria().getValue();
		var ecUserOption = me.getEcUserOption().getValue();
		var ecOption1 = me.getEcOption1().getValue();
		var ecOption2 = me.getEcOption2().getValue();
		var testNameList = me.getTestNameList().getValue();
		var timeLine = me.getTimeLine().getValue();
		var startDate = me.getStartDate().getValue();
		var endDate = me.getEndDate().getValue();
		var maxPageItems = me.getMaxPageItems().getValue();
		var changetype = Ext.getCmp("ecChangetypeRgroup").getValue();

		//Convert to original format(i.e., to MM/dd/yyyy)
		var startdate1 = Ext.Date.dateFormat(startDate, mgrDateFormat);
		var enddate1 = Ext.Date.dateFormat(endDate, mgrDateFormat);

		hiddenFieldsKeys = publicJSON.hiddenFields;
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
		var timeLineHiddenFields =  me.getHiddenFields(timeLineCollection);
		if (op == "schedule")
		{
			if (request_from != null && request_from == "saveSchedule")
			{
				var checkFlag = me.checkFormValidation("schedule");
				if (checkFlag == false)
				{
					return false;
				}

				me.getConfigurationform().submit({
					url: '/final/config/EcSaveScheduleNew.jsp',
					params : 'id='+id+'&'+hiddenFields+'ec_changetype='+changetype+'&ec_criteria='+ecCriteria+'&ec_userOption='+ecUserOption+'&ec_option1='+ecOption1+'&ec_option2='+ecOption2+'&ec_test='+testNameList+'&ec_timeline='+timeLine+'&currentDateFormat='+currentDateFormat+'&ec_stdate='+startdate1+'&ec_enddate='+enddate1+'&'+timeLineHiddenFields+'&ec_maxpageitems='+maxPageItems,
					standardSubmit : true,
					method: 'POST'
				});
			}
			else
			{
				urlStr = "/final/config/EcSaveScheduleNew.jsp?id="+id+"&request_from=Consolidated&"+hiddenFields+"ec_changetype="+changetype+"&ec_criteria="+ecCriteria+"&ec_userOption="+ecUserOption+"&ec_option1="+ecOption1+"&ec_option2="+ecOption2+"&ec_test="+testNameList+"&ec_timeline="+timeLine+"&currentDateFormat="+currentDateFormat+"&ec_stdate="+startdate1+"&ec_enddate="+enddate1+"&showWindow=yes&"+timeLineHiddenFields+"&com.eg.CSRF_NONCE="+csrfToken;
				scheduleWindow(urlStr);
			}
		}
		else if (op =="favorite")
		{
			urlStr = "/final/config/EcSaveFavorite.jsp?"+hiddenFields;
		}
		else
		{
			Ext.MessageBox.alert(pageTitle,"Illegal Access");
			return;
		}
	},
	forwardRequestedURI : function()
	{
		var me = this;
		if (me.getTestNameList() != null && me.getTestNameList() != undefined)
		{
			me.getTestNameList().setDisabled(true);
		}
		if (backOperation.historyBack != undefined && backOperation.historyBack)
		{
			window.history.back();
		}
		else if (backOperation.configChange1 != undefined && backOperation.configChange1)
		{
			window.parent.loadConfigWindow('/final/egm?entry=monitor&displayTab=all&isConfigGlobalSearch=true&uname=&integritycheckviolated=false&newwindow=&com.eg.CSRF_NONCE='+csrfToken);
		}
		else if (backOperation.Current != undefined && backOperation.Current)
		{
			me.getHiddenFieldsCt().removeAll();
			me.getHiddenFieldsCt().add(me.loadHiddenFields(hiddenFieldsKeys));
			me.getHiddenFieldsCt().add(me.loadHiddenFields(timeLineCollection));

			var urlStr = '../servlet/com.eg.EcConfigurationServletNew';
			me.getConfigurationform().submit({
				url: urlStr,
				params: "cmd=CurrentConfig&ec_comptype="+backOperation.ec_comptype+"&ec_component="+backOperation.ec_component+"&old_comptype="+backOperation.old_comptype+"&ec_test="+backOperation.ec_test+"&navigatingFrom=Change&ec_criteria="+encodeURIComponent(backOperation.ec_criteria)+"&ec_userOption="+encodeURIComponent(backOperation.ec_userOption)+"&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if (backOperation.ACO != undefined && backOperation.ACO)
		{
			window.history.go(-3);
		}
		else if (backOperation.DCDS != undefined && backOperation.DCDS)
		{
			hiddenFieldsKeys['ec_rtype'] = "";
			me.getHiddenFieldsCt().removeAll();
			me.getHiddenFieldsCt().add(me.loadHiddenFields(hiddenFieldsKeys));
			me.getHiddenFieldsCt().add(me.loadHiddenFields(timeLineCollection));

			var urlStr = '../servlet/com.eg.EcConfigurationServletNew';
			me.getConfigurationform().submit({
				url: urlStr,
				params: 'cmd=DaywiseChangeDistributionNew&ec_option1='+backOperation.ec_option1+'&ec_option2='+backOperation.ec_option2+'&request_start='+request_start+'&ec_timeline='+backOperation.ec_timeline+'&ec_prevtimeline='+backOperation.ec_prevtimeline+'&ec_stdate_h='+backOperation.ec_stdate_h+'&ec_sthr_h='+backOperation.ec_sthr_h+'&ec_startmin_h='+backOperation.ec_startmin_h+'&ec_enddate_h='+backOperation.ec_enddate_h+'&ec_endhr_h='+backOperation.ec_endhr_h+'&ec_endmin_h='+backOperation.ec_endmin_h+'&ec_criteria='+encodeURIComponent(backOperation.ec_criteria)+'&ec_userOption='+encodeURIComponent(backOperation.ec_userOption)+'&pageFrom=applink&com.eg.CSRF_NONCE='+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if (backOperation.CAAG != undefined && backOperation.CAAG)
		{
			hiddenFieldsKeys['ec_rtype'] = "";
			me.getHiddenFieldsCt().removeAll();
			me.getHiddenFieldsCt().add(me.loadHiddenFields(hiddenFieldsKeys));
			me.getHiddenFieldsCt().add(me.loadHiddenFields(timeLineCollection));

			var urlStr = '../servlet/com.eg.EcConfigurationServletNew';
			me.getConfigurationform().submit({
				url: urlStr,
				params: 'cmd=ChangesAtAGlanceNew&request_start='+request_start+'&ec_timeline='+backOperation.ec_timeline+'&ec_prevtimeline='+backOperation.ec_prevtimeline+'&ec_stdate_h='+backOperation.ec_stdate_h+'&ec_sthr_h='+backOperation.ec_sthr_h+'&ec_startmin_h='+backOperation.ec_startmin_h+'&ec_enddate_h='+backOperation.ec_enddate_h+'&ec_endhr_h='+backOperation.ec_endhr_h+'&ec_endmin_h='+backOperation.ec_endmin_h+'&ec_criteria='+encodeURIComponent(backOperation.ec_criteria)+'&ec_userOption='+encodeURIComponent(backOperation.ec_userOption)+'&pageFrom=applink&com.eg.CSRF_NONCE='+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if (backOperation.CS != undefined && backOperation.CS)
		{
			hiddenFieldsKeys['ec_rtype'] = "";
			me.getHiddenFieldsCt().removeAll();
			me.getHiddenFieldsCt().add(me.loadHiddenFields(hiddenFieldsKeys));
			me.getHiddenFieldsCt().add(me.loadHiddenFields(timeLineCollection));

			var urlStr = '../servlet/com.eg.EcConfigurationServletNew';
			me.getConfigurationform().submit({
				url: urlStr,
				params: 'cmd=ChangeSummaryNew&request_start='+request_start+'&ec_timeline='+backOperation.ec_timeline+'&ec_prevtimeline='+backOperation.ec_prevtimeline+'&ec_stdate_h='+backOperation.ec_stdate_h+'&ec_sthr_h='+backOperation.ec_sthr_h+'&ec_startmin_h='+backOperation.ec_startmin_h+'&ec_enddate_h='+backOperation.ec_enddate_h+'&ec_endhr_h='+backOperation.ec_endhr_h+'&ec_endmin_h='+backOperation.ec_endmin_h+'&ec_criteria='+encodeURIComponent(backOperation.ec_criteria)+'&ec_userOption='+encodeURIComponent(backOperation.ec_userOption)+'&pageFrom=applink&com.eg.CSRF_NONCE='+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if (backOperation.saveSchedule != undefined && backOperation.saveSchedule)
		{
			me.getHiddenFieldsCt().removeAll();
			me.getHiddenFieldsCt().add(me.loadHiddenFields(hiddenFieldsKeys));
			me.getHiddenFieldsCt().add(me.loadHiddenFields(timeLineCollection));

			var urlStr = '/final/config/EcSaveScheduleNew.jsp';
			me.getConfigurationform().submit({
				url: urlStr,
				params: 'request_from='+request_from+'&id='+id+'&pageFrom=applink&com.eg.CSRF_NONCE='+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if (backOperation.AllComponentsOption != undefined && backOperation.AllComponentsOption)
		{
			me.getHiddenFieldsCt().removeAll();
			me.getHiddenFieldsCt().add(me.loadHiddenFields(hiddenFieldsKeys));
			me.getHiddenFieldsCt().add(me.loadHiddenFields(timeLineCollection));

			var urlStr = '../servlet/com.eg.EcConfigurationServletNew';
			me.getConfigurationform().submit({
				url: urlStr,
				params: 'ec_rtype=Change&ec_option1=All Components&ec_changetype='+backOperation.ec_changetype+'&ec_timeline='+backOperation.ec_timeline+'&ec_prevtimeline='+backOperation.ec_prevtimeline+'&ec_stdate_h='+backOperation.ec_stdate_h+'&ec_sthr_h='+backOperation.ec_sthr_h+'&ec_startmin_h='+backOperation.ec_startmin_h+'&ec_enddate_h='+backOperation.ec_enddate_h+'&ec_endhr_h='+backOperation.ec_endhr_h+'&ec_endmin_h='+backOperation.ec_endmin_h+'&ec_viewchange='+backOperation.ec_viewchange+'&ec_maxpageitems='+backOperation.ec_maxpageitems+'&ec_test='+backOperation.selectedTests+'&ec_criteria='+encodeURIComponent(backOperation.ec_criteria)+'&ec_userOption='+encodeURIComponent(backOperation.ec_userOption)+'&pageFrom=applink&com.eg.CSRF_NONCE='+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if (backOperation.requestFromHome != undefined && backOperation.requestFromHome)
		{
			me.getHiddenFieldsCt().removeAll();
			me.getHiddenFieldsCt().add(me.loadHiddenFields(hiddenFieldsKeys));
			me.getHiddenFieldsCt().add(me.loadHiddenFields(timeLineCollection));

			//var urlStr = '/final/config/EcDashboardIndex.jsp';
			//me.getConfigurationform().submit({
				//url: urlStr,
				//params: 'ec_criteria='+encodeURIComponent(backOperation.db_ec_criteria)+'&ec_userOption='+encodeURIComponent(backOperation.db_ec_userOption)+'&pageFrom=applink',
				//standardSubmit : true,
				//method: 'POST'
			//});
			window.location = '/final/config/EcDashboardIndex.jsp?ec_criteria='+encodeURIComponent(backOperation.db_ec_criteria)+'&ec_userOption='+encodeURIComponent(backOperation.db_ec_userOption)+'&pageFrom=applink';
		}
		else if (backOperation.requestForHome != undefined && backOperation.requestForHome)
		{
			me.getHiddenFieldsCt().removeAll();
			me.getHiddenFieldsCt().add(me.loadHiddenFields(hiddenFieldsKeys));
			me.getHiddenFieldsCt().add(me.loadHiddenFields(timeLineCollection));

			//var urlStr = '/final/config/EcDashboardIndex.jsp';
			//me.getConfigurationform().submit({
				//url: urlStr,
				//params: 'ec_criteria='+encodeURIComponent(backOperation.db_ec_criteria)+'&ec_userOption='+encodeURIComponent(backOperation.db_ec_userOption)+'&pageFrom=applink',
				//standardSubmit : true,
				//method: 'POST'
			//});
			window.location = '/final/config/EcDashboardIndex.jsp?ec_criteria='+encodeURIComponent(backOperation.db_ec_criteria)+'&ec_userOption='+encodeURIComponent(backOperation.db_ec_userOption)+'&pageFrom=applink';
		}
		else if (backOperation.requestFromDCDS != undefined && backOperation.requestFromDCDS)
		{
			me.getHiddenFieldsCt().removeAll();
			me.getHiddenFieldsCt().add(me.loadHiddenFields(hiddenFieldsKeys));
			me.getHiddenFieldsCt().add(me.loadHiddenFields(timeLineCollection));

			//var urlStr = '/final/config/EcDashboardIndex.jsp';
			//me.getConfigurationform().submit({
				//url: urlStr,
				//params: 'ec_criteria='+encodeURIComponent(backOperation.db_ec_criteria)+'&ec_userOption='+encodeURIComponent(backOperation.db_ec_userOption)+'&pageFrom=applink',
				//standardSubmit : true,
				//method: 'POST'
			//});
			window.location = '/final/config/EcDashboardIndex.jsp?ec_criteria='+encodeURIComponent(backOperation.db_ec_criteria)+'&ec_userOption='+encodeURIComponent(backOperation.db_ec_userOption)+'&pageFrom=applink';
		}
		else if (backOperation.requestForAllComp != undefined && backOperation.requestForAllComp)
		{
			me.getHiddenFieldsCt().removeAll();
			me.getHiddenFieldsCt().add(me.loadHiddenFields(hiddenFieldsKeys));
			me.getHiddenFieldsCt().add(me.loadHiddenFields(timeLineCollection));

			var urlStr = '../servlet/com.eg.EcConfigurationServletNew';

			me.getConfigurationform().submit({
				url: urlStr,
				params: 'ec_rtype=Change&request_from=DCDSForDashboard&request_start=DCDSForDashboard&&ec_option1=All Components&ec_changetype='+backOperation.ec_changetype+'&ec_timeline='+backOperation.ec_timeline+'&ec_prevtimeline='+backOperation.ec_prevtimeline+'&ec_stdate_h='+backOperation.ec_stdate_h+'&ec_sthr_h='+backOperation.ec_sthr_h+'&ec_startmin_h='+backOperation.ec_startmin_h+'&ec_enddate_h='+backOperation.ec_enddate_h+'&ec_endhr_h='+backOperation.ec_endhr_h+'&ec_endmin_h='+backOperation.ec_endmin_h+'&ec_viewchange='+backOperation.ec_viewchange+'&ec_criteria='+encodeURIComponent(backOperation.ec_criteria)+'&ec_userOption='+encodeURIComponent(backOperation.ec_userOption)+'&searchCompValue='+backOperation.searchCompValue+'&searchTestValue='+backOperation.searchTestValue+'&searchDescValue='+backOperation.searchDescValue+'&timeZone='+backOperation.timeZone+'&selectDate='+backOperation.selectDate+'&pageFrom=applink',
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if (backOperation.measCompPage != undefined && backOperation.measCompPage)
		{
			me.getHiddenFieldsCt().removeAll();
			me.getHiddenFieldsCt().add(me.loadHiddenFields(hiddenFieldsKeys));
			me.getHiddenFieldsCt().add(me.loadHiddenFields(timeLineCollection));

			var urlStr = '../servlet/com.eg.EcConfigurationServletNew';
			me.getConfigurationform().submit({
				url: urlStr,
				params: "cmd=CurrentConfig&ec_comptype="+backOperation.ec_comptype+"&ec_component="+backOperation.ec_component+"&old_comptype="+backOperation.old_comptype+"&ec_test="+backOperation.ec_test+"&navigatingFrom=Change&ec_criteria="+encodeURIComponent(backOperation.ec_criteria)+"&ec_userOption="+encodeURIComponent(backOperation.ec_userOption)+"&pageFrom=applink",
				standardSubmit : true,
				method: 'POST'
			});
		}
	},
	loadHiddenFields : function(fields)
	{
		var me = this;
		var tmpField = "";
		var tmpArr = new Array();
		for (key in fields)
		{
			
			tmpField = {
				xtype : 'hiddenfield',
				name : key,
				value : fields[key]
			}
			tmpArr.push(tmpField);
		}
		return tmpArr;
	},
	showComponentChanges : function(comp)
	{
		var me = this;
		if (publicJSON.configurationLayout == 'showConfigForm')
		{
			var tempCriteria = me.getEcCriteria().getValue();
			var tempUserOption = "";
			if (tempCriteria != 'Component')
			{
				tempUserOption = me.getEcUserOption().getValue();
			}
		}
		var compname = "";
		var descname = "";
		var testname = "";
		if (me.getCompSearch() != null && me.getCompSearch() != undefined)
		{
			compname = me.getCompSearch().getValue();
		}
		if (me.getTestSearch() != null && me.getTestSearch() != undefined)
		{
			testname = me.getTestSearch().getValue();
		}
		if (me.getDescSearch() != null && me.getDescSearch() != undefined)
		{
			descname = me.getDescSearch().getValue();
		}

		if(request_start == null && request_from != null && request_from.toLowerCase() == "allcomponentsoption")
		{
			request_start = "AllComponentsOption";
		}

		window.location.href = '/final/config/ecShowCompChangesIndex.jsp?componentName='+comp+'&ec_criteria='+tempCriteria+'&ec_userOption='+encodeURIComponent(tempUserOption)+'&request_from='+request_from+'&request_start='+request_start+'&searchCompValue='+encodeURIComponent(compname)+'&searchTestValue='+encodeURIComponent(testname)+'&searchDescValue='+encodeURIComponent(descname);
	},
	getSearchDetails : function()
	{
		var timeZone = backOperation.timeZone;
		var selectDate = backOperation.selectDate;
		var me = this;
		var compname = "";
		if (publicJSON.configurationLayout == 'Search1')
		{
			compname = me.getCompSearch().getValue();
		}

		var descname = me.getDescSearch().getValue();
		var testname = me.getTestSearch().getValue();

		var urlStr = '../servlet/com.eg.EcConfigurationServletNew';

		if (Ext.isEmpty(timeZone))
		{
			timeZone = null;
		}

		if (Ext.isEmpty(selectDate))
		{
			selectDate = null;
		}

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		me.getHiddenFieldsCt().removeAll();
		//me.getHiddenFieldsCt().add(me.loadHiddenFields(hiddenFieldsKeys));
		me.getConfigurationform().submit({
			url: config.urls.initialURL,
			params : 'request_from='+request_from+'&request_start='+request_start+'&ec_option2='+backOperation.ec_option2+'&ec_option1='+backOperation.ec_option1+'&ec_changetype='+backOperation.ec_changetype+'&ec_timeline='+backOperation.ec_timeline+'&ec_prevtimeline='+backOperation.ec_prevtimeline+'&ec_stdate_h='+backOperation.ec_stdate_h+'&ec_sthr_h='+backOperation.ec_sthr_h+'&ec_startmin_h='+backOperation.ec_startmin_h+'&ec_enddate_h='+backOperation.ec_enddate_h+'&ec_endhr_h='+backOperation.ec_endhr_h+'&ec_endmin_h='+backOperation.ec_endmin_h+'&ec_viewchange='+backOperation.ec_viewchange+'&ec_criteria='+backOperation.ec_criteria+'&ec_userOption='+encodeURIComponent(backOperation.ec_userOption)+'&searchCompValue='+encodeURIComponent(compname)+'&searchTestValue='+encodeURIComponent(testname)+'&searchDescValue='+encodeURIComponent(descname)+'&timeZone='+timeZone+'&selectDate='+selectDate,
			method: 'POST',
			success: function(form, action){
				publicJSON = Ext.decode(action.response.responseText);
				me.getHiddenFieldsCt().removeAll();
				me.loadResultData();
				myMask.hide();
				delete publicJSON;
			},
			failure: function(form, action) // if result page doest not contain success:true, this method fires
			{
				myMask.hide();
				me.getHiddenFieldsCt().removeAll();
				switch (action.failureType) {
					case Ext.form.action.Action.CLIENT_INVALID:
						Ext.Msg.alert('Failure', 'Form fields may not be submitted with invalid values');
						break;
					case Ext.form.action.Action.CONNECT_FAILURE:
						Ext.Msg.alert('Failure', 'Ajax communication failed');
						break;
					case Ext.form.action.Action.SERVER_INVALID:
					   Ext.Msg.alert('Failure', action.result.msg);
				}
			}
		});
	},

	filterMultiselect: function (obj) 
	{
		this.filterComboStore(obj,Ext.getCmp('ec_test'),publicJSON.ec_testArr);
		obj.toggleTriggger();
    },

	filterComboStore:function(searchFieldObj,comboObj,compStore)
	{
		var findVal = searchFieldObj.getValue().toLowerCase();
		if (Ext.isEmpty(findVal))
		{
			comboObj.getStore().loadRawData(compStore);
			comboObj.setValue(compStore[0]['valueField']);
		}
		else 
		{
			var isRecordFound = false;
			var genStore = new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			});

			for (var i = 0; i < compStore.length; i++)
			{
				var valueFied = compStore[i]['valueField'].toLowerCase();
				if(valueFied.indexOf('-1') !=0)
				{
					var getRecord = compStore[i]['displayField'].toLowerCase();
					if (getRecord.indexOf(findVal) > -1) 
					{
						isRecordFound = true;
						genStore.add({
							'displayField': compStore[i]['displayField'],
							'valueField': compStore[i]['valueField']
						});
					}
				}
			}
			if (isRecordFound)
			{
				comboObj.getStore().removeAll();
				for (var i = 0; i < genStore.getCount(); i++)
				{
					var getRecord = genStore.getAt(i);
					comboObj.getStore().add(getRecord);
				}
				comboObj.setValue(genStore.getAt(0).get('valueField'));
			} 
			else 
			{
				comboObj.getStore().removeAll();
				comboObj.getStore().add({
					'displayField': 'Not Applicable!',
					'valueField': '-1'
				});
				comboObj.setValue('-1');
			}
		}
		searchFieldObj.focus();
	}
});


function doCloseWin()
{
	Ext.getCmp('scheduleWin').destroy();
}


function goToMeasureComparisonPage(descriptor, linkurl)
{
	window.location.href = "../servlet/com.eg.EcConfigurationServletNew?cmd=xmlCurrentConfig&request_from=ChangeConfig&descriptor="+encodeURIComponent(filterEncode(descriptor))+"&"+linkurl;
}

