
Ext.define('ChangeConfiguration.view.ConfigurationForm',{
	extend:'Ext.form.Panel',
	alias:'widget.configurationform',

	requires : [
		'utilities.ScrollCombo',
		'Ext.ux.form.MultiSelectSI',
		'configutilities.TimeLine'
	],

	cls:'formOuter accordionArrow',
	id:'configurationform',
	collapsible: true,
	margin: '0 5 5 5',

	items:[
		{
			xtype : 'container',
			id : 'formItemContainer',
			items: [
				{
					xtype : 'container',
					layout : {
						type : 'hbox',
						pack : 'center'
					},
					defaults: {
						labelSeparator : '',
						labelAlign: 'top',
						width: 200
					},
					margin: 10,
					items: [
						{
							xtype:'combo',
							cls: 'dropdown',
							width: 100,
							editable : false,
							fieldLabel:'View By',
							name: 'ec_criteria',
							id: 'ec_criteria',
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local',
							margin: '0 0 0 5'
						},
						{
							xtype:'scrollcombo',
							width: 150,
							cls: 'dropdown',
							fieldLabel:'Zone',
							id: 'ec_userOption',
							name: 'ec_userOption',
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							hidden: true,
							margin:'0 0 0 10',
							defaultListConfig: {
								minWidth: 250,
								maxHeight: 300
							}
						},
						{
							xtype:'combo',
							cls: 'dropdown',
							width: 130,
							editable : false,
							id: 'ec_option1',
							name: 'ec_option1',
							fieldLabel:'Change criteria',
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							hidden: false,
							margin:'0 0 0 10'
						},
						{
							xtype:'scrollcombo',
							cls: 'dropdown',
							id: 'ec_option2',
							name: 'ec_option2',
							fieldLabel:'Component Type',
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							hidden: false,
							margin:'0 0 0 10',
							defaultListConfig: {
								minWidth: 250,
								maxHeight: 300
							}
						},
						{
							xtype: 'fieldcontainer',
							id : 'testCont',
							margin: '2 0 0 10',
							items: [
								{
									xtype: 'label',
									id: 'compLbl',
									name: 'compLbl',
									text: 'Show changes in'
								},
								{
									xtype: 'container',
									margin: '5 0 0 0',
									items: [
										{
											xype: 'container',
											cls: 'multisearchlist',
											items: [
												{
													xtype: 'customtrigger',
													id: 'compSearch',
													width:188,
												}
											]
										}, 
										{
											xtype: 'multiselectSi',
											id : 'ec_test',
											name: 'ec_test',
											cls:"multiselect",
											displayField: 'displayField',
											valueField: 'valueField',
											margin: 0,
											height: 100,
											width: 200,
											store:new Ext.data.Store({
												fields: ['displayField','valueField'],
												data: []
											})
										}
									]
								}
							]
						},
						{
							xtype : 'container',
							layout : {
								type : 'vbox',
								pack : 'start'
							},
							width: 130,
							items: [
								{
									xtype : 'checkbox',
									cls : 'checkbt',
									boxLabel:'All Changes',
									name: 'ec_changetype',
									id: 'ecChangetypeRgroup',
									checked : false,
									inputValue : 'Latest',
									listeners : {
										'change' : function(checkboxView,newValue,oldValue,opts)
										{
											if(checkboxView.getValue() == true)
											{
												checkboxView.inputValue = "All";
											}
											else if(checkboxView.getValue() == false)
											{
												checkboxView.inputValue = "Latest";
											}
										}
									},
									margin: '20 0 0 10'
								},
								{
									xtype : 'checkbox',
									cls : 'checkbt',
									boxLabel:'Changes by date',
									name: 'ec_viewchange',
									id: 'ecViewchangeRgroup',
									checked : false,
									inputValue : 'byInformation',
									listeners : {
										'change' : function(checkboxView,newValue,oldValue,opts)
										{
											if(checkboxView.getValue() == true)
											{
												checkboxView.inputValue = "byDate";
											}
											else if(checkboxView.getValue() == false)
											{
												checkboxView.inputValue = "byInformation";
											}
											appCtn.setViewChange();
										}
									},
									margin: '10 0 0 10'
								},
								{
									xtype:'scrollcombo',
									cls: 'dropdown',
									width: 60,
									id: 'ec_maxpageitems',
									name: 'ec_maxpageitems',
									fieldLabel:'Changes/page',
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
									displayField: 'displayField',
									valueField: 'valueField',
									queryMode: 'local',
									hidden: true,
									labelAlign:'top',
									labelSeparator:'',
									margin: '10 0 0 10'
								}
							]
						},
						{
							xtype: 'hiddenfield',
							name: 'prevRequestFrom',
							value: request_from
						},
						{
							xtype: 'hiddenfield',
							name: 'prevStartRequestFrom',
							value: request_start
						}
					]
				},
				{
					xtype : 'container',
					layout : {
						type : 'hbox',
						pack : 'center'
					},
					margin: 10,
					items: [
						{
							xtype : 'timeline',
							id : 'timeline',
						},
						{
							xtype:'button',
							text: "SUBMIT",
							cls: "button20",
							id: "submit",
							name: "submit",
							margin: '20 0 0 20'
						}
					]
				}
			]
		},
		{
			xtype : 'container',
			id : 'hiddenFieldsCt',
			hidden: true
		},
	],
	listeners:
	{
		afterrender:function(panel)
		{
			var headerObj = Ext.getCmp("configurationform_header");
			headerObj.removeCls("x-panel-header-default");
		},

		collapse: function()
		{
			var titleStr = '';
			var selectedEcOpt = publicJSON.selectedEcOpt;
			var changeCriteria = publicJSON.changeCriteria;
			var selectedEcOption2 = publicJSON.selectedEcOption2;
			var selectedEcOption2DispName = publicJSON.selectedEcOption2DispName;
			var ecChangetypeRgroup = Ext.getCmp("ecChangetypeRgroup").getValue();
			var ecViewchangeRgroup = Ext.getCmp("ecViewchangeRgroup").getValue();
			var selectedUserOptionText = publicJSON.selectedUserOptionText;
			var hasConfigDetails = publicJSON.hasConfigDetails;

			if (selectedEcOpt != null &&  selectedEcOpt != "-1")
			{
				if (selectedEcOpt == "Component")
				{
					titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>';
				}
				else
				{
					if (selectedUserOptionText != null && selectedUserOptionText != "-1")
					{
						titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">'+selectedEcOpt+'</span> - <span class="formSelectionValue">'+selectedUserOptionText+'</span>';
					}
					else
					{
						titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>';
					}
				}
				if (changeCriteria != null && changeCriteria != "-1")
				{
					titleStr = titleStr + '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">Change By Criteria</span> - <span class="formSelectionValue">'+changeCriteria+'</span>';
				}
				if (selectedEcOption2 != null && selectedEcOption2 != "-1")
				{
					titleStr = titleStr + '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">'+changeCriteria+'</span> - <span class="formSelectionValue">'+selectedEcOption2DispName+'</span>';
				}
				if (ecChangetypeRgroup == true && ecViewchangeRgroup == true)
				{
					titleStr = titleStr + '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">Show</span> - <span class="formSelectionValue">All Changes</span> & <span class="formSelectionValue">Changes by date</span>';
				}
				else if (ecChangetypeRgroup == true && ecViewchangeRgroup == false)
				{
					titleStr = titleStr + '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">Show</span> - <span class="formSelectionValue">All Changes</span>';
				}
				else if (ecChangetypeRgroup == false && ecViewchangeRgroup == true)
				{
					titleStr = titleStr+'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">Show</span> - <span class="formSelectionValue">Changes by date</span>';
				}
				if (hasConfigDetails != null && hasConfigDetails == true)
				{
					var FromDateAndTime = publicJSON.FromDateAndTime;
					var ToDateAndTime = publicJSON.ToDateAndTime;
					titleStr = titleStr+'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">From</span> - <span class="formSelectionValue">'+FromDateAndTime+'</span>';
					titleStr = titleStr+'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">To</span> - <span class="formSelectionValue">'+ToDateAndTime+'</span>';
				}
			}
			Ext.getCmp("configurationform").setTitle(titleStr);
		},

		expand: function()
		{
			Ext.getCmp("configurationform").setTitle('');
		}
	}
});




