Ext.define('ChangeConfiguration.view.Main',{
	extend: 'utilities.OuterPanel',
	alias : 'widget.main',
	requires:[
		'ChangeConfiguration.view.ConfigurationForm',
		'ChangeConfiguration.view.ConfigGridTemplate',
		'ChangeConfiguration.view.ErrorPanel',
		'configutilities.Tools',
		'utilities.CustomTrigger',
		'Ext.ux.form.MultiSelect',
  		'utilities.Multiselector'
	],
	id: "main",
	title : config.title.mainPageTitle,
	layout: {
		type: "vbox",
		align: "stretch"
	},
	margin : '8 8 0 8',
	tools : [
		{
			xtype : 'button',
			text : config.title.backTitle,
			cls : 'backbutton',
			id : 'backBtnMain',
			iconCls:'iconBack',
			hidden : true
		},
		{
			xtype: 'tbseparator',
			id: 'bkSeperator',
			hidden : true
		},
		{
			xtype : 'tools',
			id:'confChangeTools'
		}
	],

	items : [
		{
			xtype : 'configurationform',
			hidden : true,
			margin : '8 8 0 8'
		},
		{
			xtype : 'panel',
			layout : 'auto',
			cls:'config_resultPanel ConfigDockItem',
			bodyCls:'config_body',
			scroll:true,
			autoScroll:true,
			flex : 1,
			style: {
				'overflow-x' : 'hide'
			},
			id : 'resultViewContainer',
			tools : [
				{
					xtype : 'tbspacer'
				},
				{
					xtype : 'label',
					id : 'changesTimeLineId'
				}
			],
			listeners: {
				afterrender : function() 
				{
					if (!Ext.isEmpty(fromMonitor) && fromMonitor == 'true')
					{
						Ext.getCmp('resultViewContainer').header.hidden = true;
						Ext.getCmp('resultViewContainer').margin = 0;
					}
					else
					{
						Ext.getCmp('resultViewContainer').header.hidden = false;
						Ext.getCmp('resultViewContainer').margin = 8;
					}
				}
			}

		},
		{
			xtype: "errorpanel",
			hidden: true,
			flex : 1
		}
	],
	listeners: {
		afterrender : function() 
		{
			if (!Ext.isEmpty(fromMonitor) && fromMonitor == 'true')
			{
				Ext.getCmp('main').header.hide();
			}
			else
			{
				Ext.getCmp('main').header.show();
			}
		}
	}
});



