Ext.define('ChangesByComponentName.view.ChangesInGrid',{
	extend: 'utilities.CustomGrid',
	alias : 'widget.changesingrid',
	autoScroll :true,
	flex : 1,
	margin : 10,
	store: new Ext.data.Store({
		fields: ['componentName', 'changeCount','hiddencol_1','changesIn'],
		data: []
	}),
	cls:'gridSkin',
	title : 'changes',
	titleAlign : 'center',
	emptyText:'<table border="0" height="350px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">No Data Found.</div></td></tr></table>',
	ecXtemplate : new Ext.XTemplate(
		'<div class=""><table cellspacing="0" width="100%" cellpadding="5" border="0" align="center" class="" style="border:0px solid #c3c3c3">',
		'<tpl for=".">',
			'<tr class="">',
				'<td class=""><div class="" >{[this.createHTMLLink1(values)]}<div></td>',
				'<td class=""><div class="" >{[this.createHTMLLink2(values)]}<div></td>',
				'<td class=""><div class="" >{[this.createHTMLLink3(values)]}<div></td>',
			'</tr>',
		'</tpl>',
		'</table></div>',
		{
			createHTMLLink1: function(values){
				var tmpTag = '<a id="mouse" href="'+values.hiddencol_2+'" target="main" class="eg_monlink" style="font-size: 11px;">'+values.column_1+'</a>';
				return tmpTag;
			},
			createHTMLLink2: function(values){
				var tmpTag = '<a id="mouse" href="'+values.hiddencol_2+'" target="main" class="eg_monlink" style="font-size: 11px;">'+values.column_2+'</a>';
				return tmpTag;
			},
			createHTMLLink3: function(values){
				var tmpTag = '<a id="mouse" href="'+values.hiddencol_2+'" target="main" class="eg_monlink" style="font-size: 11px;">'+values.column_3+'</a>';
				return tmpTag;
			}
		}
	),
	columns : {
		defaults: {
			sortable: true,
			hideable: false,
			menuDisabled: true,
			draggable: false,
			resizable: false
		},
		items : [
			{
				header : 'Component Name',
				dataIndex : 'componentName',
				width : 400,
				renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
				{
					var tmpTag = '<a id="mouse" href="'+record.get("hiddencol_1")+'" target="main" class="eg_monlink">'+value+'</a>';
					return tmpTag;
				}
			},
			{
				header : 'Changes',
				dataIndex : 'changeCount',
				width : 100,
			},
			{
				header : 'Changes in',
				dataIndex : 'changesIn',
				flex : 1,
				renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
				{
					return this.ecXtemplate.apply(value);
				}
			},
			{
				header : 'hiddencol_1',
				dataIndex : 'hiddencol_1',
				hidden : true
			}
		]
	}
});