Ext.define('ChangesByComponentType.controller.Main', {
	extend : 'Ext.app.Controller',
	views : [
		'Main',
		'FormItems',
		'configutilities.Tools',
		'configutilities.PrintPreview',
		'configutilities.SendMail',
		'configutilities.TimeLine',
		'ChangesInGrid',
		'ErrorContainer'
	],
	refs	:[
		{
			selector : 'main', 
			ref : 'main'
		},
		{
			selector : 'formitems', 
			ref : 'formitems'
		},
		{
			selector : 'tools', 
			ref : 'tools'
		},
		{
			selector : 'timeline', 
			ref : 'timeline'
		},
		{
			selector : 'changesingrid',
			ref : 'changesingrid'
		},
		{
			selector : 'errorcontainer',
			ref : 'errorcontainer'
		},
		{
			selector : 'formitems #hiddenFieldsCt',
			ref : 'hiddenFieldsCt'
		}
	],
	init :function() {
		me = this;
		this.buildFieldData()
		this.control({
			'main': {
				'afterrender': this.afterMainRender
			},
			'tools' :{
				'afterrender' : this.loadTools
			},
			'timeline combo[id="ec_timeline"]':
			{
				'select': this.changeTimeLine
			},
			'formitems':
			{
				'boxready' : this.loadResultData
			},
			'formitems combobox[id="ec_criteria"]' :{
				'select' : this.getDetails
			},
			'formitems combobox[id="ec_userOption"]' :{
				'select' : this.getDetails
			},
			'formitems button[id="submit"]' :{
				'click' : this.showDetails
			},
			'tools button[id="saveBtn"]' : {
				'click' : this.saveAsPDF
			},
			'tools button[id="printBtn"]' : {
				'click' : this.printData
			},
			'tools button[id="csvBtn"]' : {
				'click' : this.saveAsCSV
			},
			'tools button[id="mailBtn"]' : {
				'click' : this.sendMail
			},
			'tools button[id="scheduleBtn"]' : {
				'click' : this.setschedule
			},
			'main #backBtnMain': {
				'click': this.forwardRequestedURI
			}
		});
	},
	buildFieldData : function()
	{
		Ext.Ajax.request({
			url : config.urls.servletURL,
			params : queryString+'&needData=yes',
			method : 'POST',
			async : false,
			success : function( response ){
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					hiddenFieldsKeys = publicJSON['hiddenFields'];
					timeLineCollection = publicJSON['hiddenCollections'];
				}
			}
		});
	},
	afterMainRender : function()
	{
		var ec_userOption = me.getFormitems().getComponent('infoCont').getComponent('ec_userOption');
		var ec_criteria = me.getFormitems().getComponent('infoCont').getComponent('ec_criteria');

		if (publicJSON.selectedEcOpt != 'Component')
		{
			ec_userOption.getStore().loadRawData(publicJSON.specViewByList);
			ec_userOption.setValue(publicJSON.selectedUserOptionText);
			ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
			ec_userOption.show();
		}
		else
		{
			ec_userOption.hide();
		}

		ec_criteria.getStore().loadRawData(publicJSON['viewByList']);
		ec_criteria.setValue(publicJSON.selectedEcOpt);
		//me.setToolsState(true);
		me.fillTimeLineView();
		//me.loadResultData();
	},
	loadTools : function()
	{
		this.getTools().loadIcon(true,true,true,true,true,true);
	},
	fillTimeLineView : function()
	{
		var ec_timeline = me.getTimeline().getComponent('ec_timeline');
		var ec_stdate = me.getTimeline().getComponent('ec_stdate');
		var ec_sthr = me.getTimeline().getComponent('ec_sthr');
		var ec_startmin = me.getTimeline().getComponent('ec_startmin');
		var ec_enddate = me.getTimeline().getComponent('ec_enddate');
		var ec_endhr = me.getTimeline().getComponent('ec_endhr');
		var ec_endmin = me.getTimeline().getComponent('ec_endmin');

		ec_timeline.getStore().loadRawData(publicJSON.timeLineDetails.ec_timelineArr);

		var selTimeLine = publicJSON.timeLineDetails.selectedTimeLine;
		if (selTimeLine != "" && selTimeLine != null && selTimeLine != undefined)
			ec_timeline.setValue(selTimeLine);
		else
		{
			selTimeLine = publicJSON.timeLineDetails.ec_timelineArr[0].valueField;
			ec_timeline.setValue(selTimeLine);
		}
		ec_timeline.setFieldLabel(publicJSON.timeLineDetails.TimeLineLabel);
		
		// From Date
		ec_stdate.setValue(publicJSON.timeLineDetails.ec_stdate);
		ec_stdate.setFieldLabel(publicJSON.timeLineDetails.FromLabel);

		ec_sthr.getStore().loadRawData(publicJSON.timeLineDetails.ec_sthr);
		ec_sthr.setValue(publicJSON.timeLineDetails.selectedStartHr);
		ec_sthr.setFieldLabel(publicJSON.timeLineDetails.FromHrLabel);

		ec_startmin.getStore().loadRawData(publicJSON.timeLineDetails.ec_startmin);
		ec_startmin.setValue(publicJSON.timeLineDetails.selectedStartMin);
		ec_startmin.setFieldLabel(publicJSON.timeLineDetails.FromMinsLabel);

		//// To Date
		ec_enddate.setValue(publicJSON.timeLineDetails.ec_enddate);
		ec_enddate.setFieldLabel(publicJSON.timeLineDetails.ToLabel);

		ec_endhr.getStore().loadRawData(publicJSON.timeLineDetails.ec_endhr);
		ec_endhr.setValue(publicJSON.timeLineDetails.selectedEndHr);
		ec_endhr.setFieldLabel(publicJSON.timeLineDetails.ToHrLabel);

		ec_endmin.getStore().loadRawData(publicJSON.timeLineDetails.ec_endmin);
		ec_endmin.setValue(publicJSON.timeLineDetails.selectedEndMin);
		ec_endmin.setFieldLabel(publicJSON.timeLineDetails.ToMinsLabel);

		if (selTimeLine == "Any")
		{
			ec_stdate.setDisabled(false);
			ec_sthr.setDisabled(false);
			ec_startmin.setDisabled(false);

			ec_enddate.setDisabled(false);
			ec_endhr.setDisabled(false);
			ec_endmin.setDisabled(false);
		}
		else
		{
			ec_stdate.setDisabled(true);
			ec_sthr.setDisabled(true);
			ec_startmin.setDisabled(true);

			ec_enddate.setDisabled(true);
			ec_endhr.setDisabled(true);
			ec_endmin.setDisabled(true);
		}
	},
	loadResultData : function()
	{
		if (publicJSON.hasConfigDetails)
		{
			Ext.getCmp('formitems').collapse();
			Ext.getCmp('hiddenPanel').show();
			me.getErrorcontainer().hide();
			me.getChangesingrid().show();
			me.getChangesingrid().getStore().loadRawData(publicJSON.gridData);
			me.getChangesingrid().setTitle(publicJSON.gridTitle);
			for (i = 0; i<me.getChangesingrid().columns.length-1;i++)
			{
				me.getChangesingrid().columns[i].setText(publicJSON.gridColumns[i]);
			}
			me.setToolsState(false);
		}
		else
		{
			Ext.getCmp('hiddenPanel').hide();
			me.getChangesingrid().hide();
			me.getErrorcontainer().update('<table border="0" height="400px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+publicJSON.errorText+'.</div></td></tr></table>');
			me.getErrorcontainer().show();
			me.setToolsState(true);


			//if (publicJSON.hasResultText)
			//{
				//me.getChangesingrid().getStore().loadRawData('');
				//me.getChangesingrid().setTitle('');
				//me.getChangesingrid().getView().emptyText='<table border="0" height="350px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+publicJSON.errorText+'.</div></td></tr></table>';
				//me.getChangesingrid().getView().refresh();
			//}
			//else
			//{
				//me.getChangesingrid().hide();
			//}
		}
		if (strRequestFrom != null && strRequestFrom == "saveSchedule")
		{
			Ext.getCmp('backBtnMain').show();
			Ext.getCmp('bkSeperator').show();
			Ext.getCmp('submit').setText('Save');
		}
	},
	getDetails : function(obj)
	{
		var str_ec_timeline = me.getTimeline().getComponent('ec_timeline').getValue();
		var tempCriteria = "";
		var tempUserOption = "";
		var tempCriteriaPrevious = "";
		var tempUserOptionPrevious = "";

		var ec_criteria = me.getFormitems().getComponent('infoCont').getComponent('ec_criteria');
		var ec_userOption =  me.getFormitems().getComponent('infoCont').getComponent('ec_userOption');

		if (ec_criteria != null && ec_criteria != 'undefined')
		{
			tempCriteria = ec_criteria.getValue();
		}
		if (ec_userOption != null && ec_userOption != undefined)
		{
			tempUserOption = ec_userOption.getValue();
		}
		if (hiddenFieldsKeys.ec_criteriaPrevious != null && hiddenFieldsKeys.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = hiddenFieldsKeys.ec_criteriaPrevious;
		}
		if (hiddenFieldsKeys.ec_userOptionPrevious != null && hiddenFieldsKeys.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = hiddenFieldsKeys.ec_userOptionPrevious;
		}

		if (tempCriteria != "" && tempCriteriaPrevious != "")
		{
			if (tempCriteria == tempCriteriaPrevious)
			{
				if (tempUserOption != tempUserOptionPrevious)
				{
					componentType = "All";
					str_ec_timeline = "1 day";
				}
			}
			else
			{
				componentType = "All";
				str_ec_timeline = "1 day";
			}
		}
		var hiddenFieldsStr = me.getHiddenFields(hiddenFieldsKeys);
		this.storeHiddenFields(timeLineCollection);

		me.getFormitems().submit({
			url: config.urls.configServletURL,
			params:'needData=yes&cmd=ChangeSummaryNew&ec_timeline='+str_ec_timeline+'&request_from='+strRequestFrom+'&id='+id+'&'+hiddenFieldsStr+'&request_start='+strRequestStart+'&date='+new Date().getTime(),
			method: 'POST',
			success: function(form, action){
				publicJSON = Ext.decode(action.response.responseText);
				hiddenFieldsKeys = publicJSON.hiddenFields;
				timeLineCollection = publicJSON.hiddenCollections;
				if (publicJSON.selectedEcOpt != 'Component')
				{
					if (obj.getId() != "ec_userOption")
					{
						ec_userOption.getStore().loadRawData(publicJSON.specViewByList);
						ec_userOption.setValue(publicJSON.selectedUserOptionText);
						ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
						if (publicJSON.EcUserOptionText == null || publicJSON.EcUserOptionText == undefined)
						{
							ec_userOption.setValue(ec_userOption.getStore().getAt(0).get("valueField"));
						}
					}
					ec_userOption.show();
				}
				else
				{
					ec_userOption.hide();
				}
				me.setToolsState(true);
			},
			failure: function(form, action) // if result page doest not contain success:true, this method fires
			{
				Ext.MessageBox.alert("Ajax Failed","Error in updating details");
			}
		});
		me.getChangesingrid().hide();
	},
	showDetails : function()
	{
		if ((strRequestFrom != null && strRequestFrom == "saveSchedule") || (strRequestStart != null && strRequestStart == "saveSchedule"))
		{
			me.setschedule();
		}
		else
		{

			var checkFlag = me.componentSearch();
			if (checkFlag == false)
			{
				return false;
			}

			hiddenFieldsKeys = publicJSON['hiddenFields'];
			var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			this.storeHiddenFields(timeLineCollection);

			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
			myMask.show();

			var thisForm = this.getFormitems().getForm();
			if (thisForm.isValid())
			{
				this.getFormitems().submit({
					url : config.urls.servletURL,
					params : 'needData=yes&cmd=ChangeSummaryNew&request_start='+strRequestStart+'&'+hiddenFields,
					method: 'POST',
					success: function(form, action){
						myMask.hide();
						publicJSON = Ext.decode(action.response.responseText);
						me.loadResultData();
						//printQueryStr = publicJSON.printURL;
						delete publicJSON;
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
						Ext.MessageBox.alert("Ajax Failed","Error in updating details");
					}
				});
			}
		}
	},
	componentSearch : function()
	{
		var ec_criteria = me.getFormitems().getComponent('infoCont').getComponent('ec_criteria');
		var ec_userOption = me.getFormitems().getComponent('infoCont').getComponent('ec_userOption');
		var tempCriteria = "";
		var tempUserOption = "";

		if (ec_criteria != null && ec_criteria != undefined)
		{
			tempCriteria = ec_criteria.value;
		}
		if (ec_userOption != null && ec_userOption != undefined)
		{
			tempUserOption = ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorZone);
					return false;
				}
				else if (tempCriteria == "Service")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorService);
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorSegment);
					return false;
				}
			}
		}

		var ec_timeline = me.getTimeline().getComponent('ec_timeline').getValue();

		if (ec_timeline == "Any")
		{
			var startDate = me.getTimeline().getComponent('ec_stdate').getValue();
			var startHr = me.getTimeline().getComponent('ec_sthr').getValue();
			var startMin = me.getTimeline().getComponent('ec_startmin').getValue();

			var endDate = me.getTimeline().getComponent('ec_enddate').getValue();
			var endHr = me.getTimeline().getComponent('ec_endhr').getValue();
			var endMin = me.getTimeline().getComponent('ec_endmin').getValue();

			var curDateInExtjsFormat = getExtjsDateFormat(currentDateFormat);

			//Convert to original format(i.e., to MM/dd/yyyy)
			var startdate1 = Ext.Date.dateFormat(startDate, curDateInExtjsFormat);
			var enddate1 = Ext.Date.dateFormat(endDate, curDateInExtjsFormat);

			var sDate = formatDate(new Date(getDateFromFormat(startdate1,currentDateFormat)),"MM/dd/yyyy");
			var eDate = formatDate(new Date(getDateFromFormat(enddate1,currentDateFormat)),"MM/dd/yyyy");

			if(!validateDateTime(sDate,eDate,startHr,endHr,startMin,endMin))
			{
				Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorTimeLine);
				return false;
			}
		}
	},
	forwardRequestedURI : function()
	{
		if ((strRequestFrom != null && strRequestFrom == "saveSchedule") || (strRequestStart != null && strRequestStart == "saveSchedule"))
		{
			var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			var urlStr = "/final/config/EcSaveScheduleNew.jsp";
			me.getFormitems().submit({
				url: urlStr,
				params: "request_from="+strRequestFrom+"&id="+id+"&"+hiddenFields+"&currentDateFormat="+currentDateFormat+"&pageFrom=applink",
				standardSubmit : true,
				method: 'POST'
			});
		}
	},
	changeTimeLine : function()
	{
		var tempCriteria = me.getFormitems().getComponent('infoCont').getComponent('ec_criteria').getValue();
		var tempUserOption = "";
		if (tempCriteria != 'Component')
		{
			tempUserOption =  me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').getValue();
		}

		me.setToolsState(true);
		me.getChangesingrid().hide();

		var hiddenFieldsStr = me.getHiddenFields(hiddenFieldsKeys);
		this.storeHiddenFields(timeLineCollection);

		var ec_stdate = Ext.Date.dateFormat(Ext.getCmp('ec_stdate').getValue(), mgrDateFormat);
		var ec_enddate = Ext.Date.dateFormat(Ext.getCmp('ec_enddate').getValue(), mgrDateFormat);

		me.getFormitems().submit({
			url: config.urls.initialURL,
			params : hiddenFieldsStr+'request_from=Timeline'+'&id='+id+ '&request_start='+strRequestStart+'&ec_criteria='+tempCriteria+'ec_userOption='+ec_userOption+'&date='+new Date().getTime()+'&ec_stdate='+ec_stdate+'&ec_enddate='+ec_enddate,
			method: 'POST',
			success: function(form, action){
				publicJSON = Ext.decode(action.response.responseText);
				timeLineCollection = publicJSON.hiddenCollections;
				backOperation = publicJSON.backOperation;

				me.fillTimeLineView();
				me.getHiddenFieldsCt().removeAll();
				delete publicJSON;
			},
			failure: function(form, action) // if result page doest not contain success:true, this method fires
			{
				Ext.MessageBox.alert("Ajax Failed","Error in updating details");
			}
		});
	},
	setToolsState : function(iconState)
	{
		var saveObj =me.getTools().getComponent('saveTool');
		var printObj =me.getTools().getComponent('printTool');
		var mailObj =me.getTools().getComponent('mailTool');
		var csvObj =me.getTools().getComponent('csvTool');
		var scheduleToolObj = me.getTools().getComponent('scheduleTool');
		var combineBookletObj = me.getTools().getComponent('bookletTool');
		var ec_userOption = publicJSON.selectedUserOptionText;
		if (!Ext.isEmpty(saveObj)) {
			saveObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(printObj)) {
			printObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(mailObj)) {
			mailObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(csvObj)) {
			csvObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(combineBookletObj)) {
			combineBookletObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(scheduleToolObj) && ec_userOption != "-1") {
			scheduleToolObj.setDisabled(false);
		}
		else
		{
			scheduleToolObj.setDisabled(iconState);
		}
	},
	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+hiddenFields[key]+"&";
		}
		return hiddenQstr;
	},
	storeHiddenFields : function(fields)
	{
		var ec_timeline = me.getTimeline().getComponent('ec_timeline');
		var tmpField = "";
		var tmpArr = new Array();

		this.getHiddenFieldsCt().removeAll();
		
		for (key in fields)
		{

			if (key == "ec_stdate_h" || key == "ec_enddate_h")
			{
				if (ec_timeline.getValue() == "Any")
				{
					var startdate = Ext.Date.dateFormat(Ext.getCmp('ec_stdate').getValue(), mgrDateFormat);
					var enddate = Ext.Date.dateFormat(Ext.getCmp('ec_enddate').getValue(), mgrDateFormat);
					if (key == "ec_stdate_h")
					{
						tmpField = {
							xtype : 'hiddenfield',
							name : key,
							value : startdate
						}
					}
					else
					{
						tmpField = {
							xtype : 'hiddenfield',
							name : key,
							value : enddate
						}
					}
				}
				else
				{
					tmpField = {
						xtype : 'hiddenfield',
						name : key,
						value : fields[key]
					}
				}
			}
			else
			{
				tmpField = {
					xtype : 'hiddenfield',
					name : key,
					value : fields[key]
				}
			}
			tmpArr.push(tmpField);
		}
		this.getHiddenFieldsCt().add(tmpArr);
		tmpArr = new Array();
	},
	saveAsPDF : function()
	{
		//var getSaveObj = Ext.widget('savepdf');
		//getSaveObj.savePDF("/final/servlet/com.eg.EcPdfDownloadC");

		downloadAsPDF("/final/servlet/com.eg.EcPdfDownloadC");
	},
	printData : function()
	{
		var printQueryStr = publicJSON.printQueryStr;
		Ext.widget('print',{title : config.title.mainPageTitle}).show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set({
			src: printQueryStr
		});
	},
	saveAsCSV : function()
	{
		var ec_criteria = me.getFormitems().getComponent('infoCont').getComponent('ec_criteria').getValue();
		var ec_userOption = "";
		if (ec_criteria != 'Component')
		{
			 ec_userOption = me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').getValue();
		}
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
		this.storeHiddenFields(timeLineCollection);
		me.getFormitems().submit({
			url: '../servlet/com.eg.EcCSVController',
			params : 'ec_criteria='+ec_criteria+'&ec_userOption='+encodeURIComponent(ec_userOption)+'&'+hiddenFields,
			standardSubmit : true,
			method: 'POST'
		});
	},
	sendMail : function()
	{
		Ext.widget('sendmail').show();
	},
	setschedule : function()
	{
		var op = "schedule";
		var ec_criteria = me.getFormitems().getComponent('infoCont').getComponent('ec_criteria').getValue();
		var ec_userOption = me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').getValue();
		var ec_timeline = me.getTimeline().getComponent('ec_timeline').getValue();
		var startDate = me.getTimeline().getComponent('ec_stdate').getValue();
		var endDate = me.getTimeline().getComponent('ec_enddate').getValue();

		//Convert to original format(i.e., to MM/dd/yyyy)
		var startdate1 = Ext.Date.dateFormat(startDate, mgrDateFormat);
		var enddate1 = Ext.Date.dateFormat(endDate, mgrDateFormat);

		hiddenFieldsKeys = publicJSON['hiddenFields'];
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
		var timeLineHiddenFields =  me.getHiddenFields(timeLineCollection);
		if (op == "schedule")
		{
			if ((strRequestFrom != null && strRequestFrom == "saveSchedule") || (strRequestStart != null && strRequestStart == "saveSchedule"))
			{
				var checkFlag = me.componentSearch();
				if (checkFlag == false)
				{
					return false;
				}
				me.getFormitems().submit({
					url: '/final/config/EcSaveScheduleNew.jsp',
					params : 'id='+id+'&ec_criteria='+ec_criteria+'&ec_userOption='+ec_userOption+'&'+hiddenFields+'&ec_timeline='+ec_timeline+'&'+timeLineHiddenFields+'currentDateFormat='+currentDateFormat+'&ec_stdate='+startdate1+'&ec_enddate='+enddate1,
					standardSubmit : true,
					method: 'POST'
				});
			}
			else
			{
				urlStr = "/final/config/EcSaveScheduleNew.jsp?id="+id+"&request_from=ChangeSummary&"+hiddenFields+"showWindow=yes&ec_criteria="+ec_criteria+"&ec_userOption="+ec_userOption+"&"+timeLineHiddenFields+"ec_timeline="+ec_timeline+"&currentDateFormat="+currentDateFormat+"&ec_stdate="+startdate1+"&ec_enddate="+enddate1+"&com.eg.CSRF_NONCE="+csrfToken;
				scheduleWindow(urlStr);
			}
		}
		else if (op =="favorite")
		{
			urlStr = "/final/config/EcSaveFavorite.jsp";
		}
		else
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,".Illegal Access");
			return false;
		}
		//urlStr = "/final/config/EcSaveSchedule.jsp?id="+id+"&showWindow=yes&request_from=DaywiseChanges&"+hiddenFields+"ec_criteria="+ec_criteria+"&ec_userOption="+ec_userOption+"&ec_comptype="+ec_comptype+"&"+timeLineHiddenFields+"ec_timeline="+ec_timeline+"&currentDateFormat="+currentDateFormat+"&ec_stdate="+startdate1+"&enddate1="+enddate1;
	}
});

function doCloseWin()
{
	Ext.getCmp('scheduleWin').destroy();
}
