Ext.define('ChangesByComponentType.view.ChangesInGrid',{
	extend: 'utilities.CustomGrid',
	alias : 'widget.changesingrid',
	id : 'changesingrid',
	requires: [
		'Ext.grid.feature.Grouping',
		'Ext.grid.*'
	],
	autoScroll :true,
	scroll : true,
	collapsible: false,
	resizable: false,
	flex : 1,
	//margin : 10,
	store: new Ext.data.Store({
		fields: ['componentType', 'column_1','column_2','column_3'],
		groupField: 'componentType',
		data: [],
		sortOnLoad : false
	}),
	
	cls:'gridSkin_expander',
	title : 'changes',
	titleAlign : 'center',
	viewConfig:{
		cls:'gridSkin_expander_view'
	},
	features: [{
		ftype: 'grouping',
		id : 'componentTypeGrouping',
		groupHeaderTpl: [
			'<span class="ux-grow-action-text">{name:this.formatCompName}',
			{
				formatCompName: function(name) {
					var compArr = name.split("#$#");
					return compArr[0] + " ("+compArr[1]+")</span><a href='"+compArr[2]+"'  target='main' class='eg_monlink'><img src='/final/images/spacer.gif' data-qtip='Show Changes' data-qclass='yellowTip' class='iconBarChart' style='vertical-align:middle;margin-left:5px;'/></a>";
				}
			}
		],
		hideGroupedHeader: false,
		startCollapsed: false,
	}],

	tools: [
		{
			xtype:'button',
			id :'tc',
			name :'tc',
			iconCls: 'iconCollapseAll',
			pressedCls:'iconExpandAll',
			enableToggle : true,
			style: {
				background: 'none',
				border: '0px'
			},
			listeners:{
				'toggle':function(obj, pressed, eOpts){
					var thisGrid = Ext.getCmp('changesingrid'),
					groupingFeature = thisGrid.view.getFeature('componentTypeGrouping');
					if(pressed)
					{
						groupingFeature.collapseAll();
						obj.setIconCls('iconExpandAll');
					}
					else
					{
						groupingFeature.expandAll();
						obj.setIconCls('iconCollapseAll');
					}
					thisGrid.doLayout();
				}
			}
		}
	],

	emptyText:'<table border="0" height="350px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">No Data Found.</div></td></tr></table>',
	columns : {
		defaults: {
			sortable: false,
			hideable: false,
			menuDisabled: true,
			draggable: false,
			resizable: false
		},
		items : [
			{
				header: '',
				sortable: false,
				menuDisabled : true,
				dataIndex: 'column_1',
				flex : 1,
				renderer : function(val,meta,record)
				{
					if (val != "" && val.length > 0)
					{
						var tmpArr = val.split("#$#");
						var tmpTag = "<img src='../images/clear.png' class='iconConfigTest' style='vertical-align:baseline;' /><a id='mouse' href='"+tmpArr[1]+"' target='main' class='eg_monlink' style='vertical-align:text-bottom'>"+tmpArr[0]+"</a>";
						return tmpTag;
					}
					else
					{
						meta.tdCls += "OStable_emptytd";
						return "&nbsp";
					}
				}
			},
			{
				header: '',
				sortable: false,
				menuDisabled : true,
				dataIndex: 'column_2',
				flex : 1,
				renderer : function(val,meta,record)
				{
					if (val != "" && val.length > 0)
					{
						var tmpArr = val.split("#$#");
						var tmpTag = "<img src='../images/clear.png' class='iconConfigTest' style='vertical-align:baseline;' /><a id='mouse' href='"+tmpArr[1]+"' target='main' class='eg_monlink' style='vertical-align:text-bottom'>"+tmpArr[0]+"</a>";
						return tmpTag;
					}
					else
					{
						meta.tdCls += "OStable_emptytd";
						return "&nbsp";
					}
				}
			},
			{
				header: '',
				sortable: false,
				menuDisabled : true,
				dataIndex: 'column_3',
				flex : 1,
				renderer : function(val,meta,record)
				{
					if (val != "" && val.length > 0)
					{
						var tmpArr = val.split("#$#");
						var tmpTag = "<img src='../images/clear.png' class='iconConfigTest' style='vertical-align:baseline;' /><a id='mouse' href='"+tmpArr[1]+"' target='main' class='eg_monlink' style='vertical-align:text-bottom'>"+tmpArr[0]+"</a>";
						return tmpTag;
					}
					else
					{
						meta.tdCls += "OStable_emptytd";
						return "&nbsp";
					}
				}
			}
		]
	},
	hideHeaders : true
});