Ext.define('ChangesByComponentType.view.FormItems', {
	extend: 'Ext.form.Panel',
	alias: 'widget.formitems',
	id: 'formitems',
	cls:'formOuter accordionArrow',
	margin: '8 5 5 5',
	collapsible: true,
	requires : [
		'utilities.ScrollCombo'
	],

	items : [
		{
			xtype: 'container',
			id : 'infoCont',
			margin : 10,
			padding: '5 0 5 0',
			layout : {
				type : 'hbox',
				pack : 'center'
			},
			defaults : {
				labelSeparator : '',
				labelAlign : 'top'
			},
			items: [
				{
					xtype : 'combo',
					fieldLabel : config.title.viewByTitle,
					id : 'ec_criteria',
					cls: 'dropdown',
					name : 'ec_criteria',
					itemId : 'ec_criteria',
					store : new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
					editable : false,
					width: 130,
					margin: '0 10 0 0'
				},
				{
					xtype : 'scrollcombo',
					cls: 'dropdown',
					id : 'ec_userOption',
					name : 'ec_userOption',
					itemId : 'ec_userOption',
					store : new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
					hidden : true,
					margin: '0 10 0 0'
				},
				{
					xtype : 'timeline',
					id : 'timeline'
				},
				{
					xtype:'button',
					text: config.title.submitTitle,
					cls: "button20",
					id: "submit",
					name: "submit",
					margin: '20 0 0 10',
					width: 60
				}
			]
		},
		{
			xtype : 'container',
			id : 'hiddenFieldsCt',
			height : 0,
			hidden : true
		}
	],
	listeners:
	{
		afterrender:function(panel)
		{
			var headerObj = Ext.getCmp("formitems_header");
			headerObj.removeCls("x-panel-header-default");
		},
		collapse: function()
		{
			var titleStr = '';
			var selectedEcOpt = publicJSON.selectedEcOpt;
			var selectedUserOptionText = publicJSON.selectedUserOptionText;
			var hasConfigDetails = publicJSON.hasConfigDetails;
			var fromDateAndTime = publicJSON.FromDateAndTime;
			var toDateAndTime = publicJSON.ToDateAndTime;

			if (selectedEcOpt != null &&  selectedEcOpt != "-1")
			{
				if (selectedEcOpt == "Component")
				{
					titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>';
				}
				else
				{
					if (selectedUserOptionText != null && selectedUserOptionText != "-1")
					{
						titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">'+selectedEcOpt+'</span> - <span class="formSelectionValue">'+selectedUserOptionText+'</span>';
					}
					else
					{
						titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>';
					}
				}

				if (hasConfigDetails != null && hasConfigDetails == true)
				{
					if (fromDateAndTime != null && toDateAndTime != null)
					{
						titleStr = titleStr + '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">From</span> - <span class="formSelectionValue">'+fromDateAndTime+'</span>';
						titleStr = titleStr + '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">To</span> - <span class="formSelectionValue">'+toDateAndTime+'</span>';
					}
				}
			}
			Ext.getCmp("formitems").setTitle(titleStr);
		},
		expand: function()
		{
			Ext.getCmp("formitems").setTitle("");
		}
	}
});



