Ext.define('CitrixAppUsers.controller.Main',{
	extend : 'Ext.app.Controller',
	views : [
		'Main',
		'ErrorContainer',
		'FormItems',
		'configutilities.Tools',
		'configutilities.PrintPreview',
		'configutilities.SendMail'
	],
	refs : [
		{
			selector : 'main',
			ref : 'main'
		},
		{
			selector : 'formitems', 
			ref : 'formitems'
		},
		{
			selector : 'tools', 
			ref : 'tools'
		},
		{
			selector : 'errorcontainer', 
			ref : 'errorcontainer'
		}
	],

	init : function()
	{
		thisCtrl = this;
		this.buildFieldData()
		this.control({
			'main' :{
				'afterrender' : this.afterMainRender
			},
			'formitems combobox[id="ec_criteria"]' :{
				'select' : this.getDetails
			},
			'formitems combobox[id="ec_userOption"]' :{
				'select' : this.getDetails
			},
			'formitems combobox[id="ec_comptype"]' :{
				'select' : this.getData
			},
			'formitems combo[id="ec_component"]' :{
				'select' : this.getApplications
			},
			'formitems button[id="submit"]' :{
				'click' : this.getApplicationUsers
			},
			'formitems combo[id="applicationName"]' :{
				'select' : this.onChangeApplication
			},
			'tools' :{
				'afterrender' : this.loadTools
			},
			'tools button[id="saveBtn"]' : {
				'click' : this.saveAsPDF
			},
			'tools button[id="printBtn"]' : {
				'click' : this.printData
			},
			'tools button[id="csvBtn"]' : {
				'click' : this.saveAsCSV
			},
			'tools button[id="mailBtn"]' : {
				'click' : this.sendMail
			},
			'tools button[id="scheduleBtn"]' : {
				'click' : this.setschedule
			},
			'main #backBtnMain': {
				'click': this.forwardRequestedURI
			}
		});
	},


	buildFieldData : function()
	{
		Ext.Ajax.request({
			url : config.urls.servletURL,
			params : queryString+"&needData=yes",
			method : 'POST',
			async : false,
			success : function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) 
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					hiddenFieldsKeys = publicJSON['hiddenFields'];
					backOperation = publicJSON['backOperation'];
				}
			}
		});
	},

	
	afterMainRender : function()
	{
		me = this;

		var ec_userOption = Ext.getCmp('ec_userOption');
		var ec_criteria = Ext.getCmp('ec_criteria');
		var applicationName = Ext.getCmp('applicationName');
		ec_criteria.getStore().loadRawData(publicJSON['viewByList']);
		ec_criteria.setValue(publicJSON.selectedEcOpt);

		if (publicJSON.selectedEcOpt != 'Component')
		{
			ec_userOption.getStore().loadRawData(publicJSON['specViewByList']);
			ec_userOption.setValue(publicJSON.selectedUserOption);
			ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
			ec_userOption.show();
		}
		else
		{
			ec_userOption.hide();
		}
		me.loadConfigData();

		if (strRequestFrom == "CitrixUserAppsPage") // reqFrom CitrixUserAppsPage
		{
			me.getApplicationUsers("reqFromOtherPage");
		}
		else // reqFrom own page 
		{
			var appValue = applicationName.getValue();
			if (appValue != "" && appValue != undefined && appValue != "-1")
			{
				me.setToolsState(true,true,true,true,false);
			}
			else
			{
				me.setToolsState(true,true,true,true,true);
			}

			if ((strRequestFrom != null && strRequestFrom == "saveSchedule"))
			{
				Ext.getCmp('backBtnMain').show();
				Ext.getCmp('bkSeperator').show();
				Ext.getCmp('submit').setText('Save');
			}

			if(backOperation != "" && backOperation != undefined && backOperation.schedule != null && backOperation.schedule != undefined && backOperation.schedule == true && backOperation.schedule != "" )
			{
				Ext.getCmp('backBtnMain').show();
			}
		}
	},


	loadConfigData : function()
	{
		var compType = Ext.getCmp('ec_comptype');
		var compName = Ext.getCmp('ec_component');
		var serverName = Ext.getCmp('fsctrl');
		var applicationName = Ext.getCmp('applicationName');

		compType.getStore().removeAll();
		compType.getStore().loadRawData(publicJSON['compTypeList']);
		compType.setValue(publicJSON.selectedCompType);

		compName.getStore().removeAll();
		compName.getStore().loadRawData(publicJSON['compNameList']);
		compName.setValue(publicJSON.selectedCompName);

		serverName.setFieldLabel(publicJSON['LabelName']);
		serverName.setValue(publicJSON['serverName']);

		applicationName.getStore().removeAll();
		applicationName.getStore().loadRawData(publicJSON['applicationList']);
		applicationName.setValue(publicJSON.selectedApplication);
	},

	loadTools : function()
	{
		thisCtrl.getTools().loadIcon(
			true, //save
			true, //print
			true, //mail
			true, //csv
			true //schedule
		);
	},


	saveAsPDF : function(obj)
	{
		downloadAsPDF(config.urls.pdfURL);
	},

	printData : function()
	{
		var printQueryStr = publicJSON.printQueryStr;
		Ext.widget('print',{title : config.title.mainPageTitle}).show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set({
			src: printQueryStr
		});
	},

	saveAsCSV : function()
	{
		me = this;
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var ec_userOption = "";
		if (ec_criteria != 'Component')
		{
			 ec_userOption = Ext.getCmp('ec_userOption').getValue();
		}
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
		var urlStr = '../servlet/com.eg.EcCSVController?ec_criteria='+ec_criteria+'&ec_userOption='+ec_userOption+'&'+hiddenFields;
		me.getFormitems().submit({
			url: urlStr,
			standardSubmit : true,
			method: 'POST'
		});
	},

	sendMail : function()
	{
		Ext.widget('sendmail').show();
	},


	setschedule : function()
	{
		var op = "schedule";
		var me = this;

		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var ec_userOption = Ext.getCmp('ec_userOption').getValue();
		var ec_comptype = Ext.getCmp('ec_comptype').getValue();
		var ec_component = Ext.getCmp('ec_component').getValue();
		var applicationName = Ext.getCmp('applicationName').getValue();
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);


		if (op == "schedule")
		{
			if (strRequestFrom != null && strRequestFrom == "saveSchedule")
			{
				var checkFlag = me.checkFormValidation();
				if (checkFlag == false)
				{
					return false;
				}
				me.getFormitems().submit({
					url: '/final/config/EcSaveScheduleNew.jsp',
					params :"id="+id+"&ec_criteria="+ec_criteria+"&ec_comptype="+ec_comptype+"&"+hiddenFields+"&ec_component="+ec_component+"&applicationName="+applicationName,
					standardSubmit : true,
					method: 'POST'
				});
			}
			else
			{
				var urlStr =  "/final/config/EcSaveScheduleNew.jsp?showWindow=yes&id="+id+"&request_from=CitrixApplicationsAndUsers&ec_criteria="+ec_criteria+"&ec_comptype="+ec_comptype+"&"+hiddenFields+"&ec_component="+ec_component+"&applicationName="+applicationName;
				scheduleWindow(urlStr);
			}
		}
		else if(op =="favorite")
		{
			window.location.href = "/final/config/EcSaveFavorite.jsp";
		}
		else
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,".Illegal Access");
			return false;
		}
	},

	
	setToolsState : function(save,print,mail,csv,schedule)
	{
		var saveObj =me.getTools().getComponent('saveTool');
		var printObj =me.getTools().getComponent('printTool');
		var mailObj =me.getTools().getComponent('mailTool');
		var csvObj =me.getTools().getComponent('csvTool');
		var scheduleToolObj = me.getTools().getComponent('scheduleTool');

		if (!Ext.isEmpty(saveObj)) {
			saveObj.setDisabled(save);
		}
		if (!Ext.isEmpty(printObj)) {
			printObj.setDisabled(print);
		}
		if (!Ext.isEmpty(mailObj)) {
			mailObj.setDisabled(mail);
		}
		if (!Ext.isEmpty(csvObj)) {
			csvObj.setDisabled(csv);
		}
		if (!Ext.isEmpty(scheduleToolObj)) {
			scheduleToolObj.setDisabled(schedule);
		}
	},


	getDetails : function()
	{
		var me = this;
		Ext.getCmp('hiddenPanel').hide();
		var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);

		var ec_userOption = Ext.getCmp('ec_userOption');
		var ec_criteria = Ext.getCmp('ec_criteria');

		var compTypeVal = Ext.getCmp('ec_comptype').getValue();
		var componentVal = Ext.getCmp('ec_component').getValue();

		var tempCriteria ="";
		var tempCriteriaPrevious ="";
		var tempUserOption ="";
		var tempUserOptionPrevious ="";
		if (ec_criteria != null && ec_criteria != undefined)
		{
			tempCriteria = ec_criteria;
		}
		if (ec_userOption != null && ec_userOption != undefined)
		{
			tempUserOption = ec_userOption;
		}

		if (hiddenFieldsKeys.ec_criteriaPrevious != null && hiddenFieldsKeys.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = hiddenFieldsKeys.ec_criteriaPrevious;
		}
		if (hiddenFieldsKeys.ec_userOptionPrevious != null && hiddenFieldsKeys.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = hiddenFieldsKeys.ec_userOptionPrevious;
		}


		if (tempCriteria != "" && tempCriteriaPrevious != "")
		{
			if (tempCriteria == tempCriteriaPrevious)
			{
				if (tempUserOption != tempUserOptionPrevious)
				{
					compTypeVal = null;
					componentVal = null;
				}
			}
			else
			{
				compTypeVal = null;
				componentVal = null;
			}
		}

		this.getFormitems().submit({
			url : config.urls.configServletURL,
			params :"cmd=ThinClientUsers&needData=yes&request_from="+strRequestFrom+"&id="+id+"&ec_criteria="+tempCriteria+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious),
			method : 'POST',
			success : function(form, action){

				publicJSON = Ext.decode(action.response.responseText);
				hiddenFieldsKeys = publicJSON.hiddenFields;

				ec_criteria.getStore().loadRawData(publicJSON.viewByList);
				ec_criteria.setValue(publicJSON.selectedEcOpt);

				if (publicJSON.selectedEcOpt != 'Component')
				{
					ec_userOption.getStore().loadRawData(publicJSON.specViewByList);
					ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
					ec_userOption.setValue(publicJSON['selectedUserOption']);
					ec_userOption.show();
				}
				else
				{
					ec_userOption.hide();
				}

				me.loadConfigData();

				delete publicJSON;

				me.setToolsState(true,true,true,true,true);
			},
			failure: function(form, action) // if result page doest not contain success:true, this method fires
			{
				Ext.MessageBox.alert("Ajax Failed","Error in updating details");
			}
		});
	},

	
	getData : function()
	{
		me = this;
		var urlStr = ""; 
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);

		if(id != null && id != "null")
		{
			//urlStr = config.urls.initialURL+"?id="+id+"&request_from=saveSchedule&"+hiddenFields;
			urlStr = config.urls.initialURL+"?id="+id+"&request_from=saveSchedule&"+hiddenFields;
		}
		else
		{
			//urlStr = config.urls.initialURL+"&"+hiddenFields;
			urlStr = config.urls.configServletURL+"?cmd=ThinClientUsers&needData=yes";
		}

		this.getFormitems().submit({
			url : urlStr,
			method : 'POST',
			success : function(form, action)
			{
				publicJSON = Ext.decode(action.response.responseText);
				hiddenFieldsKeys = publicJSON.hiddenFields;

				me.loadConfigData();
				delete hiddenFields;

				me.setToolsState(true,true,true,true,true);
			},
			failure: function(form, action) 
			{
				Ext.MessageBox.alert("Ajax Failed","Error in updating details");
			}
		});
	},


	getApplications : function()
	{
		me = this;
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);

		var compType = Ext.getCmp('ec_comptype').getValue();
		var compName = Ext.getCmp('ec_component').getValue();

		var urlStr = config.urls.configServletURL+"?needData=yes&"+hiddenFields+"&ec_comptype="+compType+"&ec_component="+compName;

		var component = Ext.getCmp('ec_component').getValue();

		if(id != null && id != "null")
		{
			urlStr = config.urls.initialURL+"?id="+id+"&request_from=saveSchedule";
		}
		else
		{
			if(component == -1)
			{
				Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorMsg1);
				Ext.getCmp('fsctrl').setValue("Not Applicable");
				Ext.getCmp('applicationName').setValue("-1");
				return false;
			}
		}

		this.getFormitems().submit({
			url : urlStr,
			method : 'POST',
			success : function(form, action)
			{
				if ( action.response.status == 200 && !Ext.isEmpty( action.response.responseText ) ) 
				{
					publicJSON = Ext.decode(action.response.responseText);
					hiddenFieldsKeys = publicJSON.hiddenFields;

					me.loadConfigData();
					delete hiddenFields;

					me.setToolsState(true,true,true,true,true);
				}
			},
			failure: function(form, action) 
			{
				Ext.MessageBox.alert("Ajax Failed","Error in updating details");
			}
		});
	},


	getApplicationUsers : function(reqFrom)
	{
		if(reqFrom == "reqFromOtherPage")
		{
			var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);

			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
			myMask.show();

			this.getFormitems().submit({
				url : config.urls.servletURL+"?needData=yes&"+queryString,
				method : 'POST',
				success : function(form, action)
				{
					if (action.response.status == 200 && !Ext.isEmpty(action.response.responseText)) 
					{
						myMask.hide();
						publicJSON = Ext.decode(action.response.responseText);
						hiddenFieldsKeys = publicJSON.hiddenFields;

						me.loadResultData();
						delete hiddenFields;
					}
				},
				failure: function(form, action) 
				{
					myMask.hide();
					Ext.MessageBox.alert("Ajax Failed","Error in updating details.");
				}
			});
		}
		else
		{
			var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);

			var ec_userOption = Ext.getCmp('ec_userOption').getValue();
			var ec_criteria = Ext.getCmp('ec_criteria').getValue();
			var applicationName = Ext.getCmp('applicationName').getValue();
			var component = Ext.getCmp('ec_component').getValue();
			var comptype = Ext.getCmp('ec_comptype').getValue();


			if (strRequestFrom != null && strRequestFrom == "saveSchedule")
			{
				me.setschedule();
			}
			else
			{
				var checkFlag = me.checkFormValidation();
				if (checkFlag == false)
				{
					return false;
				}
				var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
				myMask.show();

				this.getFormitems().submit({
					url : config.urls.servletURL+"?needData=yes&"+hiddenFields+"&ec_component="+component+"&ec_comptype="+comptype,
					method : 'POST',
					success : function(form, action)
					{
						if (action.response.status == 200 && !Ext.isEmpty(action.response.responseText)) 
						{
							myMask.hide();
							publicJSON = Ext.decode(action.response.responseText);
							hiddenFieldsKeys = publicJSON.hiddenFields;

							me.loadResultData();
							delete hiddenFields;
						}
					},
					failure: function(form, action) 
					{
						myMask.hide();
						Ext.MessageBox.alert("Ajax Failed","Error in updating details.");
					}
				});
			}
		}
	},


	loadResultData : function()
	{
		var me = this;
		var applicationName = Ext.getCmp('applicationName').getValue();
		var individualAppUser = publicJSON.ListOfUsers;
		var allAppUser = publicJSON.AllUsersGridValues;
		var hasConfigDetails = publicJSON.hasConfigDetails;
		var errorText = publicJSON.errorText;

		if(hasConfigDetails)
		{
			me.setToolsState(false,false,false,false,false);
			Ext.getCmp('hiddenPanel').show();
			me.getErrorcontainer().hide();
			if(applicationName != "All")
			{
				if(individualAppUser != null && individualAppUser != "" && individualAppUser != undefined)
				{
					var gridSubTitle = publicJSON.gridSubTitle;
					var gridMainTitle = publicJSON.gridMainTitle;

					Ext.getCmp('hiddenPanel').setTitle(gridMainTitle);
					Ext.getCmp('appGrid').show();
					Ext.getCmp('appGrid').setTitle(gridSubTitle);
					Ext.getCmp('mainGrid').hide();
					Ext.getCmp('appGrid').getStore().loadRawData(individualAppUser);
				}
			}
			else if(applicationName == "All")
			{
				if(allAppUser != null && allAppUser != "" && allAppUser != undefined)
				{
					var TitleForAllUsersGrid = publicJSON.TitleForAllUsersGrid;
					Ext.getCmp('mainGrid').show();
					Ext.getCmp('hiddenPanel').setTitle(TitleForAllUsersGrid);
					Ext.getCmp('appGrid').hide();
					Ext.getCmp('mainGrid').getStore().loadRawData(allAppUser);
				}
			}
		}
		else
		{
			me.setToolsState(true,true,true,true,true);
			Ext.getCmp('hiddenPanel').hide();
			me.getErrorcontainer().show();
			me.getErrorcontainer().update('<table border="0" height="400px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+errorText+'.</div></td></tr></table>');
			Ext.getCmp('mainGrid').hide();
			Ext.getCmp('appGrid').hide();
		}
	},


	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			hiddenQstr += key+"="+hiddenFields[key]+"&";
		}
		return hiddenQstr;
	},


	onChangeApplication : function()
	{
		var applicationName = Ext.getCmp('applicationName').getValue();
		Ext.getCmp('hiddenPanel').hide();

		if(applicationName != "-1")
		{
			me.setToolsState(true,true,true,true,false);
		}
		else
		{
			me.setToolsState(true,true,true,true,true);
		}
	},


	forwardRequestedURI : function()
	{
		if (backOperation.schedule != null && backOperation.schedule != undefined && backOperation.schedule == "yes")
		{
			var me = this;
			hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			me.getFormitems().submit({
				url: '/final/config/EcSaveScheduleNew.jsp',
				params : 'request_from='+strRequestFrom+'&id='+id+'&'+hiddenFields,
				standardSubmit : true,
				method: 'POST'
			});
		}
	},


	checkFormValidation : function()
	{
		var ec_userOption = Ext.getCmp('ec_userOption').getValue();
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var applicationName = Ext.getCmp('applicationName').getValue();
		var component = Ext.getCmp('ec_component').getValue();
		var comptype = Ext.getCmp('ec_comptype').getValue();

		var tempCriteria = "";
		var tempUserOption = "";
		if (ec_criteria != null && ec_criteria != undefined)
		{
			tempCriteria = ec_criteria.value;
		}
		if (ec_userOption != null && ec_userOption != undefined)
		{
			tempUserOption = ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorZone);
					return false;
				}
				else if (tempCriteria == "Service")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorService);
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorSegment);
					return false;
				}
			}
		}

		if (component == "-1")
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorMsg1);
			return false;
		}

		if (applicationName == "-1")
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorApp);
			return false;
		}
	}


});



function doCloseWin()
{
	Ext.getCmp('scheduleWin').destroy();
}



