Ext.define('CitrixAppUsers.view.Main',{
	extend: "utilities.OuterPanel",
	alias: "widget.main",
	
	requires: [
		'CitrixAppUsers.view.FormItems',
		'CitrixAppUsers.view.ErrorContainer',
		'configutilities.Tools',
		'utilities.CommonPanel'
	],

	id: "main",
	title : config.title.mainPageTitle,
	layout: {
		align: "stretch",
		type: "vbox"
	},
	margin : '8 8 0 8',
	tools : [
		{
			xtype : 'button',
			text : config.title.backBtn,
			cls : 'backbutton',
			id : 'backBtnMain',
			iconCls:'iconBack',
			hidden : true
		},
		{
			xtype: 'tbseparator',
			id: 'bkSeperator',
			hidden : true
		},
		{
			xtype : 'tools'
		}
	],

	items : [
		{
			xtype : 'formitems'
		},
		{
			xtype : 'commonPanel',
			id : 'hiddenPanel',
			hidden : true,
			items : [
				{
					xtype : 'grid',
					cls :'gridSkin_expander',
					id : 'appGrid',
					margin : '10 10 10 10',
					hidden : true,
					store : new Ext.data.Store({
						fields : ['column_1','column_2','column_3','column_4','applicationName'],
						data : [],
						sortOnLoad : false,
						groupField: 'applicationName',
						groupDir : undefined
					}),
					queryMode : 'local',
					autoScroll : true,
					hideHeaders : true,
					viewConfig : {
						deferEmptyText : true
					},

					features: [{
						ftype: 'grouping',
						id : 'appGrouping',
						groupHeaderTpl: [
							'{name:this.formatServerName}',
							{
								formatServerName: function(name) 
								{
									return name;
								}
							}
						],
						hideGroupedHeader: false,
						startCollapsed: false
					}],

					tools: [
						{
							xtype: 'button',
							id : 'expandTool',
							name : 'expandTool',
							iconCls: 'iconExpandAll',
							hidden:true,
							style: {
								background: 'none',
								border: '0px'
							},
							listeners: {
								'click':function(obj){
									this.hide();
									Ext.getCmp('collapseTool').show();
									var thisGrid = Ext.getCmp('appGrid');
									var groupingFeature = thisGrid.view.getFeature('appGrouping');
									groupingFeature.expandAll();
								}
							}
						},
						{
							xtype:'button',
							id :'collapseTool',
							name :'collapseTool',
							iconCls: 'iconCollapseAll',
							hidden:false,
							style: {
								background: 'none',
								border: '0px'
							},
							listeners:
							{
								'click':function(obj)
								{
									this.hide();
									Ext.getCmp('expandTool').show();
									var thisGrid = Ext.getCmp('appGrid');
									var groupingFeature = thisGrid.view.getFeature('appGrouping');
									groupingFeature.collapseAll();
								}
							}
						}
					], 

					emptyText : "<table border='0' height='350px' width='100%'><tr><td align=center vlaign=top><img src='/final/admin/eg_images/exclamation-icon.gif'><div>No result found for the current selection</div></td></tr></table>",

					columns : {
						defaults : {
							sortable : true,
							hideable : false,
							menuDisabled : true,
							draggable : false,
							resizable : false,
							flex : 1
						},
						items : [
							{
								header: '',
								sortable: false,
								menuDisabled : true,
								dataIndex: 'column_1',
								flex : 1,
								renderer : function(val, metaData, record, rowIndex, colIndex, store, view)
								{
									if (val != "" && val.length > 0)
									{
										var tmpArr = val.split("#$#");
										var tmpTag = "<img src='../images/clear.png' class='iconUser' style='vertical-align:baseline;margin-right:5px' /><a id='mouse' href='"+tmpArr[1]+"' target='main' class='eg_monlink' style='vertical-align:text-bottom'>"+tmpArr[0]+"</a>";
										return tmpTag;
									}
									else
									{
										metaData.tdCls += "OStable_emptytd";
										return "&nbsp";
									}
								}
							},
							{
								header: '',
								sortable: false,
								menuDisabled : true,
								dataIndex: 'column_2',
								flex : 1,
								renderer : function(val, metaData, record, rowIndex, colIndex, store, view)
								{
									if (val != "" && val.length > 0)
									{
										var tmpArr = val.split("#$#");
										var tmpTag = "<img src='../images/clear.png' class='iconUser' style='vertical-align:baseline;margin-right:5px' /><a id='mouse' href='"+tmpArr[1]+"' target='main' class='eg_monlink' style='vertical-align:text-bottom'>"+tmpArr[0]+"</a>";
										return tmpTag;
									}
									else
									{
										metaData.tdCls += "OStable_emptytd";
										return "&nbsp";
									}
								}
							},
							{
								header: '',
								sortable: false,
								menuDisabled : true,
								dataIndex: 'column_3',
								flex : 1,
								renderer : function(val, metaData, record, rowIndex, colIndex, store, view)
								{
									if (val != "" && val.length > 0)
									{
										var tmpArr = val.split("#$#");
										var tmpTag = "<img src='../images/clear.png' class='iconUser' style='vertical-align:baseline;margin-right:5px' /><a id='mouse' href='"+tmpArr[1]+"' target='main' class='eg_monlink' style='vertical-align:text-bottom'>"+tmpArr[0]+"</a>";
										return tmpTag;
									}
									else
									{
										metaData.tdCls += "OStable_emptytd";
										return "&nbsp";
									}
								}
							},
							{
								header: '',
								sortable: false,
								menuDisabled : true,
								dataIndex: 'column_4',
								flex : 1,
								renderer : function(val, metaData, record, rowIndex, colIndex, store, view)
								{
									if (val != "" && val.length > 0)
									{
										var tmpArr = val.split("#$#");
										var tmpTag = "<img src='../images/clear.png' class='iconUser' style='vertical-align:baseline;margin-right:5px' /><a id='mouse' href='"+tmpArr[1]+"' target='main' class='eg_monlink' style='vertical-align:text-bottom'>"+tmpArr[0]+"</a>";
										return tmpTag;
									}
									else
									{
										metaData.tdCls += "OStable_emptytd";
										return "&nbsp";
									}
								}
							}
						]
					}
				},
				{
					xtype : 'grid',
					cls :'gridSkin_expander',
					id : 'mainGrid',
					margin : '10 10 10 10',
					hidden : true,
					store : new Ext.data.Store({
						fields : ['column_1','column_2','column_3','application'],
						data : [],
						groupField: 'application',
						sortOnLoad : false,
						groupDir : undefined
					}),
					queryMode : 'local',
					autoScroll : true,
					hideHeaders : true,
					viewConfig : {
						deferEmptyText : true
					},
					features: [{
						ftype: 'grouping',
						id : 'usersGrouping',
						groupHeaderTpl: [
							'{name:this.formatServerName}',
							{
								formatServerName: function(name) 
								{
									var appName = name.split("#$#");
									return appName[0] + " ("+appName[1]+")";
								}
							}
						],
						hideGroupedHeader: false,
						startCollapsed: false
					}],

					tools: [
						{
							xtype: 'button',
							id : 'toolExpand',
							name : 'toolExpand',
							iconCls: 'iconExpandAll',
							hidden:true,
							style: {
								background: 'none',
								border: '0px'
							},
							listeners: {
								'click':function(obj){
									this.hide();
									Ext.getCmp('toolCollapse').show();
									var thisGrid = Ext.getCmp('mainGrid');
									var groupingFeature = thisGrid.view.getFeature('usersGrouping');
									groupingFeature.expandAll();
								}
							}
						},
						{
							xtype:'button',
							id :'toolCollapse',
							name :'toolCollapse',
							iconCls: 'iconCollapseAll',
							hidden:false,
							style: {
								background: 'none',
								border: '0px'
							},
							listeners:
							{
								'click':function(obj)
								{
									this.hide();
									Ext.getCmp('toolExpand').show();
									var thisGrid = Ext.getCmp('mainGrid');
									var groupingFeature = thisGrid.view.getFeature('usersGrouping');
									groupingFeature.collapseAll();
								}
							}
						}
					], 

					emptyText : "<table border='0' height='350px' width='100%'><tr><td align=center vlaign=top><img src='/final/admin/eg_images/exclamation-icon.gif'><div>No result found for the current selection</div></td></tr></table>",

					columns : {
						defaults : {
							sortable : true,
							hideable : false,
							menuDisabled : true,
							draggable : false,
							resizable : false,
							flex : 1
						},
						items : [
							{
								header: '',
								dataIndex: 'column_1',
								renderer : function(val, metaData, record, rowIndex, colIndex, store, view)
								{
									if (val != "" && val.length > 0)
									{
										var tmpArr = val.split("#$#");
										var tmpTag = "<img src='../images/clear.png' class='iconUser' style='vertical-align:baseline;margin-right:5px' /><a id='mouse' href='"+tmpArr[1]+"' target='main' class='eg_monlink' style='vertical-align:text-bottom'>"+tmpArr[0]+"</a>";
										return tmpTag;
									}
									else
									{
										metaData.tdCls += "OStable_emptytd";
										return "&nbsp";
									}
								}
							},
							{
								header: '',
								dataIndex: 'column_2',
								renderer : function(val, metaData, record, rowIndex, colIndex, store, view)
								{
									if (val != "" && val.length > 0)
									{
										var tmpArr = val.split("#$#");
										var tmpTag = "<img src='../images/clear.png' class='iconUser' style='vertical-align:baseline;margin-right:5px' /><a id='mouse' href='"+tmpArr[1]+"' target='main' class='eg_monlink' style='vertical-align:text-bottom'>"+tmpArr[0]+"</a>";
										return tmpTag;
									}
									else
									{
										metaData.tdCls += "OStable_emptytd";
										return "&nbsp";
									}
								}
							},
							{
								header: '',
								dataIndex: 'column_3',
								renderer : function(val, metaData, record, rowIndex, colIndex, store, view)
								{
									if (val != "" && val.length > 0)
									{
										var tmpArr = val.split("#$#");
										var tmpTag = "<img src='../images/clear.png' class='iconUser' style='vertical-align:baseline;margin-right:5px' /><a id='mouse' href='"+tmpArr[1]+"' target='main' class='eg_monlink' style='vertical-align:text-bottom'>"+tmpArr[0]+"</a>";
										return tmpTag;
									}
									else
									{
										metaData.tdCls += "OStable_emptytd";
										return "&nbsp";
									}
								}
							}
						]
					}
				}
			]
		},
		{
			xtype: "errorcontainer",
			hidden: true
		}
	]
});



