Ext.define('CitrixUserApps.view.FormItems', {
	extend : 'Ext.form.Panel',
	alias : 'widget.formitems',
	id : 'formitems',
	cls:'formOuter',
	margin: '8 5 5 5',

	requires : [
		'utilities.ScrollCombo'
	],

	items : [
		{
			xtype : 'container',
			id : 'infoCont',
			layout : {
				type : 'hbox',
				pack : 'center'
			},
			defaults: {
				labelSeparator : '',
				labelAlign: 'top',
				width: 180
			},
			margin: 10,
			items : [
				{
					xtype:'scrollcombo',
					cls: 'dropdown',
					width: 100,
					editable : false,
					fieldLabel:config.title.viewByTitle,
					name: 'ec_criteria',
					id: 'ec_criteria',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local'
				},
				{
					xtype:'scrollcombo',
					cls: 'dropdown',
					fieldLabel:'Zone',
					id: 'ec_userOption',
					name: 'ec_userOption',
					editable : false,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					hidden: true,
					margin: '0 0 0 10',
					defaultListConfig: {
						minWidth: 250,
						maxHeight: 300
					},
					width: 100
				},
				{
					xtype : 'scrollcombo',
					cls: 'dropdown',
					fieldLabel : config.title.compTypeTitle,
					id : 'ec_comptype',
					itemId : 'ec_comptype',
					name : 'ec_comptype',
					store :  new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
					editable : false,
					margin: '0 0 0 10',
					defaultListConfig: {
						minWidth: 250,
						maxHeight: 300
					}
				},
				{
					xtype : 'scrollcombo',
					cls: 'dropdown',
					fieldLabel : config.title.compNameTitle,
					id : 'ec_component',
					itemId : 'ec_component',
					name : 'ec_component',
					store :  new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
					editable : false,
					margin: '0 0 0 10',
					defaultListConfig: {
						minWidth: 250,
						maxHeight: 300
					}
				},
				{
					xtype : 'textfield',
					cls: 'textbox',
					readOnly : true,
					fieldLabel : config.title.serverTitle,
					id : 'fsctrl',
					name : 'fsctrl',
					margin: '0 0 0 10',
					width : 170,
					hidden: true
				},
				{
					xtype : 'scrollcombo',
					cls: 'dropdown',
					fieldLabel : config.title.userLabelTitle,
					id : 'userName',
					itemId : 'userName',
					name : 'userName',
					store :  new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
					editable : false,
					margin: '0 0 0 10',
					defaultListConfig: {
						minWidth: 250,
						maxHeight: 300
					}
				},
				{
					xtype : 'button',
					text : config.title.submitTitle,
					action : 'submit',
					id : 'submit',
					cls: 'button20',
					margin: '20 0 0 10',
					width: 50
				}
			]
		}
	]
});



