
Ext.define('CompareConfiguration.controller.Main',{
	extend: 'Ext.app.Controller',
	views : ['Main','ErrorPanel','configutilities.Tools','ConfigurationForm','CompareComponentConfig'],

	refs : [
		{selector : 'main',ref : 'main'},
		{selector : 'configurationform combo[id="ec_criteria"]',ref : 'ecCriteria'},
		{selector : 'configurationform #ec_userOption',ref : 'ecUserOption'},
		{selector : 'configurationform #componentType',ref : 'ecComponentType'},
		{selector : 'configurationform #referenceComponent',ref : 'referenceComponent'},
		{selector : 'configurationform #otherComponents',ref : 'otherComponents'},
		{selector : 'main #similarCompGrid',ref : 'similarCompGridView'},
		{selector : 'main #dissimilarCompGrid',ref : 'disSimilarCompGridView'},
		{selector : 'configurationform #tests',ref : 'ecTest'},
		{selector: 'configurationform',ref: 'configurationform'},
		{selector: 'comparecomponentconfig',ref: 'comparecomponentconfig'},
		{selector: 'tools',ref: 'tools'}
	],

	init : function(){
		appCtn = this;
		this.buildFieldData();
		this.control({
			'main':
			{
				'afterrender' : this.afterMainRender
			},
			'configurationform combo[id="ec_criteria"]':
			{
				'select': this.getDetails
			},
			'configurationform combo[id="ec_userOption"]':
			{
				'select': this.getDetails
			},
			'configurationform combo[id="referenceComponent"]':
			{
				'select': this.getCompInfo
			},
			'configurationform combo[id="componentType"]':
			{
				'select': this.getCompInfo
			},
			'configurationform button[id="submit"]':
			{
				'click': this.showDetails
			},
			'configurationform trigger[id="infoSearch"]' :
			{
				'change': this.filterMultiselectTest
			},
			'configurationform trigger[id="otherSearch"]' :
			{
				'change': this.filterMultiselectOther
			}
			//'configurationform button[id="panelinsidetoggle"]': {
				//'click': this.toggleForm
			//}
		});
	},
	buildFieldData : function()
	{
		Ext.Ajax.request({
			url : config.urls.servletURL,
			params : queryString+'&needData=yes',
			method : 'POST',
			async : false,
			success : function( response ){
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					hiddenFieldsKeys = publicJSON['hiddenFields'];
				}
			}
		});
	},
	afterMainRender : function()
	{
		//Ext.getCmp('panelinsidetoggle').setDisabled(true);
		appCtn.loadPageConfigs();
	},
	loadPageConfigs : function()
	{
		var me = this;
		me.getEcCriteria().getStore().loadRawData(publicJSON.ec_criteriaArr);
		me.getEcCriteria().setValue(publicJSON.selectedEcOpt);
		if (publicJSON.selectedEcOpt != 'Component')
		{
			me.getEcUserOption().getStore().loadRawData(publicJSON.userOptionArr);
			me.getEcUserOption().setValue(publicJSON.selectedUserOptionText);
			me.getEcUserOption().setFieldLabel(publicJSON.EcUserOptionText);
			me.getEcUserOption().show();
		}
		else
		{
			me.getEcUserOption().hide();
		}
		me.getEcComponentType().getStore().loadRawData(publicJSON.compArr);
		me.getEcComponentType().setValue(publicJSON.selectedCmpType);

		me.getEcTest().getStore().loadRawData(publicJSON.ec_testArr);

		if (strRequestFrom == 'CompareComponentConfigPage')
		{
			me.getEcTest().setValue(publicJSON.selectedTests);
		}
		else
		{
			me.getEcTest().setValue(publicJSON.ec_testArr[0].valueField);
		}

		me.getReferenceComponent().getStore().loadRawData(publicJSON.referenceComponentArr);
		me.getReferenceComponent().setValue(publicJSON.selectedRefComponent);

		me.getOtherComponents().getStore().loadRawData(publicJSON.otherComponentArr);
		me.getOtherComponents().setValue(publicJSON.selectedOtherComponent);

		me.getSimilarCompGridView().getStore().loadRawData("");
		me.getDisSimilarCompGridView().getStore().loadRawData("");

		delete publicJSON;
	},

	//toggleForm:function(obj)
	//{
		//Ext.getCmp('panelinsidetoggle').setDisabled(false);
		//var ornt = Ext.getCmp('configurationform');
		//if (ornt.isHidden())
		//{
			//ornt.show();
			//Ext.getCmp('selectionDetails').hide();
		//}
		//else
		//{
			//ornt.hide();
			//Ext.getCmp('selectionDetails').show();
		//}
	//},
	getCompInfo : function(obj)
	{
		var me = this;
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
		me.getConfigurationform().submit({
			url: config.urls.initialURL,
			params : hiddenFields+'&date='+new Date().getTime(),
			method: 'POST',
			success: function(form, action){

				publicJSON = Ext.decode(action.response.responseText);
				hiddenFieldsKeys = publicJSON.hiddenFields;
				me.loadPageConfigs();
			},
			failure: function(form, action) // if result page doest not contain success:true, this method fires
			{
				Ext.MessageBox.alert("Ajax Failed","Error in updating details");
			}
		});
	},
	getDetails : function(obj)
	{
		var me = this;
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
		//Ext.getCmp('panelinsidetoggle').setDisabled(true);
		me.getConfigurationform().submit({
			url: config.urls.servletURL,
			params : 'needData=yes&cmd=CompareConfig&'+hiddenFields+'&date='+new Date().getTime(),
			method: 'POST',
			success: function(form, action){

				publicJSON = Ext.decode(action.response.responseText);
				hiddenFieldsKeys = publicJSON.hiddenFields;

				if (obj.getId() != "ec_userOption")
				{
					if (publicJSON.selectedEcOpt != 'Component')
					{
						me.getEcUserOption().getStore().loadRawData(publicJSON.userOptionArr);
						me.getEcUserOption().setValue(publicJSON.selectedUserOptionText);
						me.getEcUserOption().setFieldLabel(publicJSON.EcUserOptionText);
						me.getEcUserOption().show();
					}
					else
					{
						me.getEcUserOption().hide();
					}
				}

				me.getEcComponentType().getStore().loadRawData(publicJSON.compArr);
				me.getEcComponentType().setValue(publicJSON.selectedCmpType);

				me.getEcTest().getStore().loadRawData(publicJSON.ec_testArr);
				me.getEcTest().setValue(publicJSON.selectedTests);

				me.getReferenceComponent().getStore().loadRawData(publicJSON.referenceComponentArr);
				me.getReferenceComponent().setValue(publicJSON.selectedRefComponent);

				me.getOtherComponents().getStore().loadRawData(publicJSON.otherComponentArr);
				me.getOtherComponents().setValue(publicJSON.selectedOtherComponent);

				me.getSimilarCompGridView().getStore().loadRawData("");
				me.getDisSimilarCompGridView().getStore().loadRawData("");

				delete publicJSON;
			},
			failure: function(form, action) // if result page doest not contain success:true, this method fires
			{
				Ext.MessageBox.alert("Ajax Failed","Error in updating details");
			}
		});
	},
	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			if (key == "vsTypes")
			{
				continue;
			}
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	showDetails : function()
	{
		var me = this;
		var tempCriteria = "";
		var tempUserOption = "";
		if (me.getEcCriteria() != null && me.getEcCriteria() != undefined)
		{
			tempCriteria = me.getEcCriteria().getValue();
		}
		if (me.getEcUserOption() != null && me.getEcUserOption() != undefined & tempCriteria != 'Component')
		{
			tempUserOption = me.getEcUserOption().getValue();
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorZone);
					return false;
				}
				else if (tempCriteria == "Service")
				{
					Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorService);
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorSegment);
					return false;
				}
			}
		}

		var server = me.getEcComponentType().getValue();
		if(server == -1 || server == "-1")
		{
			Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorCompType);
			return false;
		}

		var information = me.getEcTest().getValue();
		if(information == "-1" || information == '')
		{
			Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorInfo);
			return false;
		}

		var othercomponent = me.getOtherComponents().getValue();
		if(othercomponent == "-1" || othercomponent == '')
		{
			Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorRefComp);
			return false;
		}
		me.submitConfigDetails();
	},
	submitConfigDetails : function(queryString,objArr)
	{
		var me = this;
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		me.getConfigurationform().submit({
			url: config.urls.servletURL,
			params : 'needData=yes&'+hiddenFields+'&date='+new Date().getTime(),
			method: 'POST',
			//timeout : 60000, // 1 minute
			success: function(form, action){
				myMask.hide();
				publicJSON = Ext.decode(action.response.responseText);
				Ext.getCmp('configurationform').collapse();
				me.getSimilarCompGridView().getStore().loadRawData(publicJSON.similarCmpGridArray);
				me.getDisSimilarCompGridView().getStore().loadRawData(publicJSON.disimilarCmpGridArray);
				//var tpl = new Ext.XTemplate(
					//'<tpl exec="this.objectToArray(values)"></tpl>',
					//'<tpl for="this.array">',
					//'<span style="margin-right:20px;margin-bottom:5px;float:left;"><span class="font_bold">{key}</span> - {value}</span>',
					//'</tpl>',
					//{
						//objectToArray: function(values){
							//this.array = [];
							//for(var key in values){
								//var dataObj = values[key];
								//for(var key2 in dataObj){
									//this.array.push({key: key2, value: dataObj[key2]});
								//}
							//}
						//}
					//}
				//);
				//Ext.getCmp('selcetioninnerpanel').tpl=tpl;
				//Ext.getCmp('selcetioninnerpanel').update(publicJSON.selectionDetailsArr);
				//Ext.getCmp('panelinsidetoggle').setDisabled(false);
				delete publicJSON;
			},
			failure: function()
			{
				myMask.hide();
				Ext.MessageBox.alert("Ajax Failed","Error in updating details");
			}
		});
	},
	showComponentChanges : function(comp)
	{
		var me = this;
		var tempCriteria = "";
		var tempUserOption = "";
		tempCriteria = me.getEcCriteria().getValue();
		if(tempCriteria != 'Component')
		{
			tempUserOption = me.getEcUserOption().getValue();
		}

		var urlStr = '/final/config/ecCompareCompConfig.jsp?componentName='+encodeURIComponent(comp)+'&ec_criteria='+tempCriteria+'&ec_userOption='+encodeURIComponent(tempUserOption);

		Ext.getCmp('viewport').removeAll();
		Ext.getCmp('viewport').add({xtype: 'comparecomponentconfig'});

		var resultPanelObj = Ext.select('#resultPanel');
		resultPanelObj.set({
			src: urlStr
		});

		me.tempCriteria = tempCriteria;
		me.tempUserOption = tempUserOption;

		Ext.getCmp('backButton').on('click',me.goToComparison,me);

	},
	goToComparison : function()
	{
		var me = this;
		me.getComparecomponentconfig().submit({
			url: '../servlet/com.eg.EcConfigurationServletNew',
			params: "request_from=CompareComponentConfigPage&ec_rtype=Comparison&ec_criteria="+me.tempCriteria+"&ec_userOption="+encodeURIComponent(me.tempUserOption),
			standardSubmit : true,
			method: 'POST'
		});
	},

	filterMultiselectTest : function(obj)
	{
		this.filterComboStore(obj,Ext.getCmp('tests'),publicJSON.ec_testArr);
		obj.toggleTriggger();
	},

	filterMultiselectOther : function(obj)
	{
		this.filterComboStore(obj,Ext.getCmp('otherComponents'),publicJSON.otherComponentArr);
		obj.toggleTriggger();
	},

	filterComboStore : function(searchFieldObj,comboObj,compStore)
	{
		var findVal = searchFieldObj.getValue().toLowerCase();
		if (Ext.isEmpty(findVal))
		{
			comboObj.getStore().loadRawData(compStore);
			comboObj.setValue(compStore[0]['valueField']);
		}
		else 
		{
			var isRecordFound = false;
			var genStore = new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			});

			for (var i = 0; i < compStore.length; i++)
			{
				var valueFied = compStore[i]['valueField'].toLowerCase();
				if(valueFied.indexOf('-1') !=0)
				{
					var getRecord = compStore[i]['displayField'].toLowerCase();
					if (getRecord.indexOf(findVal) > -1) 
					{
						isRecordFound = true;
						genStore.add({
							'displayField': compStore[i]['displayField'],
							'valueField': compStore[i]['valueField']
						});
					}
				}
			}
			if (isRecordFound)
			{
				comboObj.getStore().removeAll();
				for (var i = 0; i < genStore.getCount(); i++)
				{
					var getRecord = genStore.getAt(i);
					comboObj.getStore().add(getRecord);
				}
				comboObj.setValue(genStore.getAt(0).get('valueField'));
			} 
			else 
			{
				comboObj.getStore().removeAll();
				comboObj.getStore().add({
					'displayField': 'Not Applicable!',
					'valueField': '-1'
				});
				comboObj.setValue('-1');
			}
		}
		searchFieldObj.focus();
	}
});




