Ext.define('ComplianceCheckRun.controller.Main',
{
	extend: 'Ext.app.Controller',
	views:
	[
		'Main',
		'configutilities.PrintPreview',
		'configutilities.SendMail'
	],
	refs:
	[
		{
			selector: 'main',
			ref: 'main'
		},
		{
			selector: 'formitems',
			ref: 'formitems'
		}
	],
	init: function ()
	{
		var me = this;
		var resultStoreData = null;
		var resultStore = null;
		me.control(
		{
			'formitems':
			{
				'afterrender': me.loadEnbldTmpltNames
			}
			,'formitems combobox[id="TmpltNm"]':
			{
				'select': me.loadMngdCmpntsAndScanForOptns
			}
			,'formitems combobox[id="ScanFor"]':
			{
				'select': me.scanForChngd
			}
			,'formitems combobox[id="ZoneSerSeg"]':
			{
				'select': me.scanForChngd
			}
			,'formitems button[id="submit"]':
			{
				'click': me.checkCompliance
			}
			,'formitems button[id="panelinsidetoggle"]':
			{
				'click': me.toggleForm
			}
			,'button[id="printIconId"]' : 
			{
				'click' : me.printData
			}
			,'button[id="pdfDownloadIconId"]' : 
			{
				'click' : me.saveAsPDF
			}
			,'button[id="mailIconId"]' : 
			{
				'click' : me.sendMail
			}
			,'egcomponent button[id="expandComp"]':
			{
				'click': this.expandMe
			}
		});
	},

	expandMe: function (btn)
	{
		Ext.widget("erutils").expandMultiComboButton(Ext.getCmp('components'), 'Components', btn);
	},
	
	printData : function()
	{
		var printQueryStr = config.urls.servletURL + '?cmd=Compliance_Run&reqfrom=printPreview';
		Ext.widget('print',{title : config.title.printPreview, width : '1030px'}).show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set({
			src: printQueryStr
		});
	},
	saveAsPDF : function()
	{
		downloadAsPDF("/final/servlet/com.eg.EcPdfDownloadC");
	},
	sendMail : function()
	{
		Ext.widget('sendmail').show();
	},	
	loadEnbldTmpltNames: function()
	{
		var me = this;
		Ext.getBody().mask(config.msgs.loading);
		Ext.Ajax.request(
		{
			url : config.urls.servletURL,
			params :
			{
				'cmd' : "Compliance_Run",
				'reqfrom' : "loadEnbldTmpltNames",
				'pullData' : "true",
			},
			method : 'POST',
			async : false,
			success : function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					var tmpltNms = Ext.getCmp('TmpltNm');
					tmpltNms.getStore().loadRawData(publicJSON['EnbledTmpltNames']);
					Ext.getCmp('ScanFor').setValue(publicJSON['selctdScanFor']);
				}
				Ext.getBody().unmask();
			},
			failure:function()
			{
				Ext.getBody().unmask();
			}
		});
		me.showMailPrintPdfIcns(false);
	},
	scanForChngd:function ()
	{
		var me = this;
		me.showMailPrintPdfIcns(false);
		if(Ext.getCmp('ScanFor').getValue() == "component")
		{
			Ext.getCmp('ZoneSerSeg').hide();
			Ext.getCmp('TmpltNm').setValue(null);
			Ext.getCmp('components').setValue(null);
			
			me.loadMngdCmpntsAndScanForOptns();
		}
		else if(Ext.getCmp('ScanFor').getValue() != "component")
		{
			Ext.getCmp('components').getStore().removeAll();
			Ext.getCmp('ZoneSerSeg').show();
			if(Ext.getCmp('ScanFor').getValue() == 'zone')
			{
				Ext.getCmp('ZoneSerSeg').setFieldLabel(config.labels.zones);
				Ext.getCmp('ZoneSerSeg').emptyText = [config.labels.selectAZone];
				Ext.getCmp('ZoneSerSeg').applyEmptyText();
				
				Ext.getCmp('TmpltNm').setValue(null);
				Ext.getCmp('components').setValue(null);
			}
			else if(Ext.getCmp('ScanFor').getValue() == 'service')
			{
				Ext.getCmp('ZoneSerSeg').setFieldLabel(config.labels.services);
				Ext.getCmp('ZoneSerSeg').emptyText = [config.labels.selectAService];
				Ext.getCmp('ZoneSerSeg').applyEmptyText();
				
				Ext.getCmp('TmpltNm').setValue(null);
				Ext.getCmp('components').setValue(null);
			}
			else if(Ext.getCmp('ScanFor').getValue() == 'segment')
			{
				Ext.getCmp('ZoneSerSeg').setFieldLabel(config.labels.segments);
				Ext.getCmp('ZoneSerSeg').emptyText = [config.labels.selectASegment];
				Ext.getCmp('ZoneSerSeg').applyEmptyText();

				Ext.getCmp('TmpltNm').setValue(null);
				Ext.getCmp('components').setValue(null);
			}
			me.loadMngdCmpntsAndScanForOptns();
		}
	},
	loadMngdCmpntsAndScanForOptns: function ()
	{
		if( 
		(Ext.getCmp('ScanFor').getValue() != null) )
		{
			Ext.getBody().mask(config.msgs.loading);
			Ext.Ajax.request(
			{
				url : config.urls.servletURL,
				params :
				{
					'cmd' : "Compliance_Run",
					'reqfrom' : "loadMngdCmpnts",
					'pullData' : "true",
					'selEnbldTmpltNm' : Ext.getCmp('TmpltNm').getValue(),
					'ec_criteria' : Ext.getCmp('ScanFor').getValue(),
					'ec_userOption' : Ext.getCmp('ZoneSerSeg').getValue(),
				},
				method : 'POST',
				async : false,
				success : function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
						var assctdCmptNms = Ext.getCmp('components');
						assctdCmptNms.getStore().loadRawData(publicJSON['assctdCmptNms']);
						assctdCmptNms.setValue(publicJSON['selAssctdCmptNms']);

						Ext.getCmp('ZoneSerSeg').getStore().loadRawData(publicJSON['scanForOptions']);
						Ext.getCmp('ZoneSerSeg').setValue(publicJSON['slctdScanForOptn']);
					}
					Ext.getBody().unmask();
				},
				failure:function()
				{
					Ext.getBody().unmask();
				}
			});
		}		
	},
	checkCompliance: function ()
	{
		var me = this;

		if(Ext.getCmp('TmpltNm').getValue() == null)
		{
			Ext.Msg.alert('&nbsp;', config.msgs.plsSlctATmpltNm);
		}
		else if(Ext.getCmp('components').getValue() == '')
		{
			Ext.Msg.alert('&nbsp;', config.msgs.plsSlctMngdCmpnts);
		}
		else
		{
			Ext.getBody().mask(config.msgs.loading);
			Ext.Ajax.request(
			{
				url : config.urls.servletURL,
				params : {
					'cmd' : "Compliance_Run",
					'reqfrom' : "checkCompliance",
					'pullData' : "true",
					'selEnbldTmpltNm' : Ext.getCmp('TmpltNm').getValue(),
					'selAssctdCmpnts' : Ext.getCmp('components').getValue(),
					//'skipSts' : Ext.getCmp('skipSts').getValue(),
				},
				method : 'POST',
				async : true,
				waitMsg : config.msgs.scnngMngdCmpnts,
				waitTitle: config.msgs.scanInPrgrs,
				success : function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
						if(publicJSON['success']=="true")
						{
							me.resultStoreData = null;

							Ext.getCmp('formitems').hide();
							Ext.getCmp('main').setTitle('<div id="backMain" class="iconRoundLeftArrow handSymbol" ><span style="position:relative;top:1px;margin-left: 30px;" class="newFont_bold15">' + config.title.complianceCheck + ' - ' + config.title.run + '</span></div>');
							me.addComplianceStatus(publicJSON);
							Ext.get('backMain').on('click', function() 
							{ 
								Ext.getCmp('main').setTitle('<span class="newFont_bold15">' + config.title.complianceCheck + ' - ' + config.title.run + '</span>');
								Ext.getCmp("upper_panel").destroy();
								Ext.getCmp("acc_panel").destroy();
								Ext.getCmp('formitems').show();
							});							
							me.showMailPrintPdfIcns(true);
						}
						else
						{
							Ext.Msg.alert('&nbsp;', config.msgs.somethngWntWrng);
						}
					}
					Ext.getBody().unmask();
				},
				failure:function()
				{
					Ext.getBody().unmask();
				}
			});
		}		
	},
	showMailPrintPdfIcns: function(visible)
	{
		if(visible)
		{
			Ext.getCmp('mailIconId').show();
			Ext.getCmp('printIconId').show();
			Ext.getCmp('pdfDownloadIconId').show();
		}
		else
		{
			Ext.getCmp('mailIconId').hide();
			Ext.getCmp('printIconId').hide();
			Ext.getCmp('pdfDownloadIconId').hide();
		}
	},
	addDetailsPage: function(category)
	{
		var ime = this;
		Ext.getBody().mask(config.msgs.loading);
		Ext.Ajax.request(
		{
			url : config.urls.servletURL,
			params : {
				'cmd' : "Compliance_Run",
				'reqfrom' : "gridDtlsForAllCmpnts",
				'pullData' : "true",
				'selCategory' : category,
			},
			method : 'POST',
			async : false,
			success : function( response )
			{
				var dtlPgJSON;
				if ( response.status == 200 && !Ext.isEmpty(response.responseText) )
				{
					var jsonText = response.responseText;
					dtlPgJSON = Ext.decode( jsonText );
					var resultObj = Ext.getCmp('main');
					resultObj.add({
						xtype:'panel',
						flex:1,
						id:'mainDetail',
						layout:{type:'vbox',align:'stretch'},
						forceFit:true,
						items:[{
							xtype:'panel',
							id:'detailContainer',
							height:100,
							flex:1,
							layout: {
								type: 'hbox',
								align: 'stretch'
							},
							forceFit: true,
							items:[],
							listeners:
							{
								afterrender:function(e)
								{
									var me = this;
									var retPanel = ime.addSearchCheckBoxPanel(dtlPgJSON, category);
									me.add(retPanel);
									var retGridPanel = ime.addTempGridPanel(dtlPgJSON);
									me.add(retGridPanel);						
								}
							}
						}]
					});
					Ext.get('gridCollapsebtn').on('click', function() 
					{
						Ext.getCmp('detailTree').expand('right');
						Ext.get('gridCollapsebtn').setStyle('display','none');
					});
					Ext.get('treeCollapsebtn').on('click', function() 
					{ 
						Ext.getCmp('detailTree').collapse('left');
						Ext.get('gridCollapsebtn').setStyle('display','block');
					});
				}
				Ext.getBody().unmask();
			},			
			failure:function()
			{
				Ext.getBody().unmask();
			}
		});
	},
	changeGridntpl: function(category)
	{
		var allcheckGrp = Ext.getCmp('allcheckGrp');
		var otherCheckGrp = Ext.getCmp('otherCheckGrp');
		var allcheckGrpC = allcheckGrp.getChecked();
		var otherCheckGrpC = otherCheckGrp.getChecked();
		if(allcheckGrpC.length == 0 && otherCheckGrpC.length == 0)
		{
			Ext.Msg.alert('&nbsp;', config.msgs.plsSlctMngdCmpnts);
		}
		else
		{
			var selectedCmpnts = [];
			if(allcheckGrpC.length != 0)
			{
				selectedCmpnts.push("All");
			}
			else if(otherCheckGrpC.length != 0)
			{
				for(var rt=0;rt<otherCheckGrpC.length;rt++)
				{
					selectedCmpnts.push(otherCheckGrpC[rt].inputValue);
				}
			}
			//Hit for Grid & condition template
			Ext.getBody().mask(config.msgs.loading);
			Ext.Ajax.request(
			{
				url : config.urls.servletURL,
				params : {
					'cmd' : "Compliance_Run",
					'reqfrom' : "gridDtlsForSlctdCmpnts",
					'pullData' : "true",
					'selectedCmpnts' : selectedCmpnts,
					'selCategory' : category
				},
				method : 'POST',
				async : false,
				success : function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText) )
					{
						var jsonText = response.responseText;
						var slctdCmpntsGridDltsJSON = Ext.decode( jsonText );
						Ext.getCmp('rulesinCompl').update(slctdCmpntsGridDltsJSON["condData"]);
						Ext.getCmp('totalrules').update(slctdCmpntsGridDltsJSON["condData"]);
						Ext.getCmp('matchingrules').update(slctdCmpntsGridDltsJSON["condData"]);
						Ext.getCmp('nmatchingrules').update(slctdCmpntsGridDltsJSON["condData"]);	
						Ext.getCmp('detailsGrid').update(slctdCmpntsGridDltsJSON["gridData"]);
					}
					Ext.getBody().unmask();
				},
				failure:function()
				{
					Ext.getBody().unmask();
				}
			});
		}		
	},
	remloadTextBox: function(serachText,dialogNeeded)
	{
		var searchGroup = Ext.getCmp('otherCheckGrp');
		var checkBoxGrp = searchGroup.checkBoxObjectGrp;
		var searched = [];
		for(var i=0;i<checkBoxGrp.length;i++)
		{
			if(checkBoxGrp[i].boxLabel.indexOf(serachText) > -1)
			{
				searched.push(checkBoxGrp[i]);
			}
		}
		if(searched.length == 0)
		{
			if(dialogNeeded)
			{
				Ext.Msg.alert('&nbsp;', config.msgs.spcfdSrcjNotFound);
				Ext.getCmp('searchTextBox').reset();
			}
			else
				searchGroup.removeAll(true);
		}
		else
		{
			searchGroup.removeAll(true);
			searchGroup.add(searched);
		}
	},
	addSearchCheckBoxPanel: function(publicJSON, category)
	{
		var me = this;
		var panel = {
			xtype:'panel',
			id:'detailTree',
			cls:'treePanelDesign',
			layout : {
				align : 'stretch',
				type : 'vbox'
			},
			flex:1,
			width: 250,
			maxWidth:250,
			minWidth:250,
			listeners:
			{
				afterrender:function(e)
				{
					this.setTitle('<span class="newFont_bold14">'+publicJSON["componentData"].title+'</span><span id="treeCollapsebtn" style="float:right;margin-right:-6px" class="iconTreeCollapse mouse"></span>');
				}
			},
			dockedItems:[{
				xtype:'toolbar',
				dock: 'bottom',
				cls:'buttonBg',
				layout:{type:'vbox',align:'center'},
				padding:'13 0 13 0',
				items:[
					{
						xtype: 'button',
						text: 'Apply',
						id: 'apply',
						ui: 'newButtonSmall',
						cls:'f13-normal',
						height:25,
						width:100,
						listeners:{
							click:function()
							{
								me.changeGridntpl(category);
							}
						}
					}
				]
			}],
			items:[
			{
				xtype:'container',
				cls:'dropdownBg',
				layout:{type:'anchor',pack:'center'},
				items:[
					{
						xtype:'trigger',
						width:230,
						fieldLabel:'',
						cls: 'whitedropdown_search',
						emptyText:config.msgs.searchCmpnts,
						id : 'searchTextBox',
						name : 'searchTextBox',		
						margin:'4 10 5 10',
						enableKeyEvents: true,
						onTriggerClick : function(event)
						{
							var serachText = this.getValue();
							me.remloadTextBox(serachText,true);
						},
						listeners:
						{
							change: function(field, e)
							{
								var serachText = this.getValue();
								me.remloadTextBox(serachText,false);
							}
						}
					}	
				]
			},
			{
				xtype:'container',
				cls:'checkBoxBorder',
				layout:{type:'anchor',pack:'center'},
				items:[
					{
						xtype: 'checkboxgroup',
						id:'allcheckGrp',
						columns:1,
						vertical: true,
						items:[
						{
							boxLabel: config.labels.all,
							name: 'checkboxAll',
							inputValue:'All',
							checked: false,
							cls: 'showLegend checkbt',
							margin: '6 5 0 5',									
						}],
						listeners:
						{
							change: function(field, newValue, oldValue, eOpts)
							{
								if(newValue.checkboxAll == "All")
									Ext.getCmp('otherCheckGrp').setDisabled(true);
								else
									Ext.getCmp('otherCheckGrp').setDisabled(false);
							}
						}
					}]
			},
			{
				xtype: 'checkboxgroup',
				id:'otherCheckGrp',
				columns:1,
				margin:'5 0 0 0',
				vertical: true,
				checkBoxObjectGrp:[],
				listeners:
				{
					afterrender:function(e)
					{
						var checkBoxArray = publicJSON["componentData"].checkBoxArray;
						for(var tc=0;tc<checkBoxArray.length;tc++)
						{
							var data = checkBoxArray[tc];
							this.checkBoxObjectGrp.push({
								boxLabel: data.boxLabel,
								inputValue:data.inputValue,
								checked: data.checked,
								cls: 'showLegend checkbt',
								margin: '5 5 3 5',									
							});
						}	
						this.add(this.checkBoxObjectGrp);
					}					
				},
				items:[]				
			}]
		};
		return panel;
	},
	addTempGridPanel: function(publicJSON)
	{
		var gridPanel = {
			xtype:'panel',
			id:'detailGrid',
			title:'<span style="float:left;display:none;margin-top:-2px" id="gridCollapsebtn" class="iconTreeCollapse mouse"></span><span class="f14-bold" style="position:relative;top:0px">'+publicJSON.condData.title+'</span>',
			margin:'0 5 3 5',
			layout:{type:'vbox',align:'stretch'},
			flex:4,
			items:[
			{
				xtype:'container',
				layout:{type:'hbox',align:'stretch'},
				height:40,
				items:[
				{
					xtype:'panel',
					id:'rulesinCompl',
					style:{'margin-top':'-3px'},
					bodyStyle:{'display':'table-cell','vertical-align':'middle'},
					flex:1,
					tpl:new Ext.XTemplate
					(
						'<tpl for=".">',
							'<span class="f13-bold" style="margin-left:5px;">' + config.labels.rulsInCmplnc + '&nbsp;<span class="{rulesinComplState}" style="padding:5px 10px 5px 10px;"><span style="display:inline-block;vertical-align:bottom" class="{rulesinCompliconCls}"></span><span class="whiteText f16-bold" style="margin-left:5px;">{rulesinCompl}<span class="f12-bold">%</span></span></span></span>',
						'</tpl>'
					)
				},{
					xtype:'panel',
					id:'totalrules',
					style:{'margin-top':'1px'},
					bodyStyle:{'display':'table-cell','vertical-align':'middle','text-align':'center'},
					flex:1,
					tpl:new Ext.XTemplate
					(
						'<tpl for=".">',
							'<span class="f13-bold">' + config.labels.totRuls + '&nbsp;{totalrules}</span>',
						'</tpl>'
					)
				},{
					xtype:'panel',
					id:'matchingrules',
					style:{'margin-top':'-2px'},
					bodyStyle:{'display':'table-cell','vertical-align':'middle','text-align':'center'},
					flex:1,
					tpl:new Ext.XTemplate
					(
						'<tpl for=".">',
							'<span style="margin-top:-2px;display:inline-block;vertical-align:bottom" class="{matchingiconCls}"></span><span class="f13-bold" style="margin-left:5px;">' + config.labels.mtchngRuls +'<span class="stateConfigText_Compliance">&nbsp;{matchingrules}</span></span>',
						'</tpl>'
					)
				},{
					xtype:'panel',
					id:'nmatchingrules',
					style:{'margin-top':'-2px'},
					bodyStyle:{'display':'table-cell','vertical-align':'middle','text-align':'center'},
					flex:1,
					tpl:new Ext.XTemplate
					(
						'<tpl for=".">',
							'<span style="display:inline-block;vertical-align:bottom" class="{nonmatchingiconCls}"></span><span class="f13-bold" style="margin-left:5px;">' + config.labels.nonMtchngRuls +'<span class="stateConfigText_OutofCompliance">&nbsp;{nonmatchingrules}</span></span>',
						'</tpl>'
					)
				}
				]
			},{
				xtype:'commongrid',
				flex:1,
				cgdata:publicJSON["gridData"]				
			}],
			listeners:
			{
				afterrender:function()
				{
					Ext.getCmp('rulesinCompl').update(publicJSON["condData"]);
					Ext.getCmp('totalrules').update(publicJSON["condData"]);
					Ext.getCmp('matchingrules').update(publicJSON["condData"]);
					Ext.getCmp('nmatchingrules').update(publicJSON["condData"]);					
				}
			}
		};
		return gridPanel;
	},	
	addComplianceStatus: function(publicJSON)
	{
		var me = this;
		var resultObj = Ext.getCmp('main');
		resultObj.add({
			xtype:'panel',
			id:'upper_panel',
			cls:'formOuter',
			//flex: 1,
			height:215,
			listeners:
			{
				afterrender:function(e)
				{
					var me = this;
					me.add({
						xtype:'container',
						cls:'gstServerStatus',
						padding:'8 0 14 0',
						html:"<div style='margin: 8px 0px 0px 0px;'><span class='f13-normal'>" + config.labels.tmpltNmColon + "</span><span  class='f13-bold'>" + " " + publicJSON['templateName'] + "</span> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class='f13-normal'>" + config.labels.noOfCmplnChkInTmplt + " " + "</span><span  class='f13-bold'>" + publicJSON['noOfRulesInTemplate'] +"</span></div>"
					});

					var complianceStatus = [];
					var complianceStatusJson = publicJSON['complianceSts'];

					for(var i=0; i < complianceStatusJson.length;i++)
					{
						var sepNeeded = "";
						if(i != complianceStatusJson.length-1)
							sepNeeded = 'separatorRight'
						complianceStatus.push({
							xtype:'container',
							cls:sepNeeded,
							height:135,
							layout:
							{
								type:'vbox',
								align:'stretch'
							},
							no:i,
							complianceStatusJson:complianceStatusJson[i],
							items:[],
							listeners:
							{
								afterrender:function(e)
								{
									var me = this;
									var detailsTab = "";
									if(me.complianceStatusJson.detailTab)
										detailsTab = "<span style='margin-top:5px;float:right' id='detailId" + me.no + "' class='iconMoreDetails mouse'>";
									
									me.add(
									{
										xtype:'container',
										height:20,
										html:"<div style='margin: 0px 10px 0px 10px;' class='f14-bold'>"+me.complianceStatusJson.title+""+detailsTab+"</span></div>"
									});

									if(me.complianceStatusJson.charType != undefined && me.complianceStatusJson.charType != null && me.complianceStatusJson.charType.toLowerCase() == "donut")
									{
										me.add({
											xtype:'container',
											cls:'gstServerStatus',
											html:'<div style="margin-top:5px;height:113px;" id="donutGraph"></div>'
										});
										var ret = getHighChartsJSONforTextDonutLeg(me.complianceStatusJson);
										Ext.defer(function(){
											$('#donutGraph').highcharts(ret);
										},10);
									}
									else if(me.complianceStatusJson.charType != undefined && me.complianceStatusJson.charType != null && me.complianceStatusJson.charType.toLowerCase() == "line")
									{
										me.add(
										{
											xtype:'container',
											cls:'gstServerStatus',
											margin:'13 0 0 0',
											html:'<div class='+me.complianceStatusJson.iconName+'></div><div class="f45-normal" onclick="me.viewServersList(\''+me.complianceStatusJson.serverState+'\')" style="margin:0 5px">'+me.complianceStatusJson.count+'</div>'
										},
										{
											xtype:'container',
											height:15,
											margin:'2 0 0 0',
											id:'lineGraph_'+me.complianceStatusJson.title,
											html:'<table align=\"center\"><tbody><tr><td><table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" height=\"3\" class=\"prog_border\"><tbody><tr><td align=\"left\" width=\"100%\" height=\"3\" ><table width=\"'+me.complianceStatusJson.lineData+'%\" height=\"3\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody><tr><td class=\"progress_'+me.complianceStatusJson.lineCls+'\" width=\"100%\"></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>'
										});											
									}
									else
									{
										me.add({
											xtype:'container',
											cls:'gstServerStatus',
											margin:10,
											html:'<div class="gstServerStatus '+me.complianceStatusJson.stateCss+'" style="height:60px;margin-top:20px;padding-left: 13px;padding-right: 13px;"><div style="position:relative;top:-7px" class='+me.complianceStatusJson.iconName+'></div><div class="whiteText f50-light" style="position:relative;top:-4px;margin:0 0 0 5px">'+me.complianceStatusJson.count+'</div><div style="position:relative;top:-4px" class="whiteText f28-light" >'+me.complianceStatusJson.unit+'</div></div>'
										});
									}
								}
							}
						});
					}

					var complianceStatusDetail =
					{
						xtype:'container',
						//margin:'0 10 0 10',
						//border:true,
						layout:{
							type:'column',
						},
						cls:'gstServerStatusOuter',
						style:{'height':'145px !important'},
						defaults:{
						   columnWidth:.25,
						},
						items:complianceStatus
					}
				   me.add(complianceStatusDetail);										
				}
			}
		},
		{
			xtype:'panel',
			id:'acc_panel',
			ui:'eg-accordion-panel',
			padding:0,
			margin:'0 10 10 10',
			flex:2,
			layout: {
				type: 'accordion',
				animate: true,
				multi: false,				
			},
			items:[],
			listeners:
			{
				afterrender:function(e)
				{
					var me = this;
					var accordian_data = publicJSON['accordian_data'];
					for(var i=0; i < accordian_data.length;i++)
					{
						var marginn = '5 0 10 0';
						if(i == accordian_data.length - 1)
							marginn = '0 0 10 0';
						me.add({
							title:accordian_data[i].title,
							cls:'formOuter',
							width:'100%',
							layout:{type:'vbox',align:'stretch'},
							margin:marginn,
							data:accordian_data[i],
							bodyPadding:'0 10 10 10',
							scroll:true,
							autoScroll:true,
							listeners:
							{
								expand:function(e)
								{
									var ime = this;
									$('#'+ime.data.id).highcharts(chartConfig(ime.data.chartData,ime));
								},
								afterrender:function(e)
								{
									var ime = this;
									var heightPanel = null;
									var flexPanel = 1;
									if(ime.data.chartData.DataSet[0].data.length > 7)
										heightPanel = 250;	

									ime.add({
										xtype:'panel',
										minHeight:heightPanel,
										flex:flexPanel,
										id:ime.data.id,
										listeners:{
											afterrender:function(e)
											{
												var me = this;
												Ext.defer(function()
												{
													$('#'+ime.data.id).highcharts(chartConfig(ime.data.chartData,ime));
												},100);									
											}
										}
									});		
								}			
							}
						});						
					}
				}
			}
		});
		Ext.get('detailId2').on('click', function() 
		{ 
			Ext.getCmp('main').setTitle('<div id="backForm" class="iconRoundLeftArrow handSymbol" ><span style="position:relative;top:1px;margin-left: 30px;" class="newFont_bold15">' + config.title.complianceCheck + ' - ' + config.title.run + '</span></div>');
			Ext.get('backForm').on('click', function() 
			{ 
				Ext.getCmp('main').setTitle('<div id="backMain" class="iconRoundLeftArrow handSymbol" ><span style="position:relative;top:1px;margin-left: 30px;" class="newFont_bold15">' + config.title.complianceCheck + ' - ' + config.title.run + '</span></div>');
				Ext.get('backMain').on('click', function() 
				{ 
					Ext.getCmp('main').setTitle('<span class="newFont_bold15">' + config.title.complianceCheck + ' - ' + config.title.run + '</span>');
					Ext.getCmp("upper_panel").destroy();
					Ext.getCmp("acc_panel").destroy();
					Ext.getCmp('formitems').show();
				});
				Ext.getCmp("mainDetail").destroy();
				Ext.getCmp("upper_panel").show();
				Ext.getCmp("acc_panel").show();
			});
			Ext.getCmp("upper_panel").hide();
			Ext.getCmp("acc_panel").hide();
			me.addDetailsPage("matching");
		});
		Ext.get('detailId3').on('click', function() 
		{ 
			Ext.getCmp('main').setTitle('<div id="backForm" class="iconRoundLeftArrow handSymbol" ><span style="position:relative;top:1px;margin-left: 30px;" class="newFont_bold15">' + config.title.complianceCheck + ' - ' + config.title.run + '</span></div>');
			Ext.get('backForm').on('click', function() 
			{ 
				Ext.getCmp('main').setTitle('<div id="backMain" class="iconRoundLeftArrow handSymbol" ><span style="position:relative;top:1px;margin-left: 30px;" class="newFont_bold15">' + config.title.complianceCheck + ' - ' + config.title.run + '</span></div>');
				Ext.get('backMain').on('click', function() 
				{ 
					Ext.getCmp('main').setTitle('<span class="newFont_bold15">' + config.title.complianceCheck + ' - ' + config.title.run + '</span>');
					Ext.getCmp("upper_panel").destroy();
					Ext.getCmp("acc_panel").destroy();
					Ext.getCmp('formitems').show();
				});
				Ext.getCmp("mainDetail").destroy();
				Ext.getCmp("upper_panel").show();
				Ext.getCmp("acc_panel").show();
			});
			Ext.getCmp("upper_panel").hide();
			Ext.getCmp("acc_panel").hide();
			me.addDetailsPage("non-matching");
		});
	}	
});

function chartConfig(data,me)
{
	var jsonData = "";
	try{		
		var barChart = {};
		barChart = jQuery.extend(true, {}, createBarforCtx(""), barChart);	
		data["tick"]=true;
		data["noconstraints"]=true;
		barChart.setData(data,'','','bar');
		jsonData = barChart.highchart;
	}
	catch(eo)
	{
		console.log("Exception occured: ",eo)
	}
	return jsonData;
}

function getHighChartsJSONforTextDonutLeg(Jdata)
{
	var titleColor = ( strSkin == 'Light' )?"#2a292a":"#c6c6c6";
	var borderColor = ( strSkin == 'Light' )?"#ffffff":"#444444";
	var jsonData = {
		"chart": {
			"height": null,
			"width": null,
			"plotBorderWidth": 0,
			"backgroundColor": "transparent",
			"plotBackgroundColor": "transparent",
			"plotShadow": false,
			"shadow": false,
			"zoomType": "xy",
			"ignoreHiddenSeries": false,
			"spacing": [0,0,5,0],
			"events": {},
			"type": "pie",
			"borderWidth": 0,
			"renderTo": ""
		},
		"rangeSelector": {
			"enabled": false
		},
		"global": {
			"useUTC": true
		},
		"navigator": {
			"enabled": false
		},
		"yAxis": {
			"endOnTick": true,
			"showFirstLabel": true,
			"startOnTick": true,
			"max": null,
			"border": 0,
			"lineWidth": 1,
			"labels": {
				"style": {
					"color": "black",
					"fontFamily": "Lucida Grande Bold",
					"fontSize": "11px"
				}
			},
			"showLastLabel": true,
			"gridLineWidth": 1,
			"title": {
				"text": "",
				"style": {
					"fontSize": "10px"
				}
			}
		},
		"scrollbar": {
			"enabled": false
		},
		"legend": {
			"verticalAlign": "middle",
			"align": "right",
			"layout": "vertical",
			"borderWidth": 0,
			"y": 0,
			"x": 225,
			"width": 300,
			"adjustChartSize": false,
			"navigation": {
				"arrowSize": 5
			},
			"itemStyle": {},
			"symbolWidth": 15,
			"enabled": false
		},
		"labels": {
			"itemStyle": {}
		},
		"tooltip": {
			"shared": true,
			"borderColor": null,
			"valueDecimals": 4,
			"style": {
				"padding": "5px"
			},
			"hideDelay": 100,
			"enabled": false
		},
		"exporting": {
			"enabled": false
		},
		"credits": {
			"enabled": false
		},
		"xAxis": {
			"tickWidth": 0,
			"border": 1,
			"lineWidth": 1,
			"minPadding": 0.02,
			"maxPadding": 0.02,
			"ordinal": false,
			"endOnTick": true,
			"showFirstLabel": true,
			"startOnTick": true,
			"labels": {
				"style": {
					"width": "100px",
					"whiteSpace": "nowrap"
				},
				"overflow": "justify",
				"showLastLabel": true,
				"endOnTick": true,
				"showFirstLabel": true,
				"startOnTick": false,
				"useHTML": false,
				"tickPixelInterval": 50,
				"rotation": 0,
				"tickmarkPlacement": "on",
				"x": 0,
				"y": 0,
				"step": 0
			},
			"title": {
				"enabled": true,
				"text": "21",
				"align": "center",
				"verticalAlign": "middle",
				"y": 40
			},
			"categories": "",
			"min": 0,
			"gridLineWidth": 0,
			"tickPixelInterval": 75,
			"tickLength": 0
		},
		"title": {
			"text": "<span style='display:block;'>"+Jdata.value+"</span>",
			"margin": 0,
			"useHTML": true,
			"y": 13,
			"x": -1,
			"style": {
				"textAlign": "center",
				"color": titleColor,
				"fontFamily": "Arial",
				"fontSize": "30px",
			},
			"verticalAlign": "middle",
			"floating": true,
			"zIndex": "-10000"
		},
		"series": Jdata.DataSet,
		"subtitle": {
			"text": "",
			"style": {}
		},
		"plotOptions": {
			"pie": {
				"borderColor": borderColor,
				"borderWidth": 1,
				"size": "100%",
				"allowPointSelect": false,
				"cursor": "",
				"innerSize": "78%",
				"dataLabels": {
					"softConnector": false,
					"enabled": false,
					"distance": 7,
					"style": {
						"fontSize": "11px",
						"textOutline": false,
						"textShadow": false
					}
				},
				"showInLegend": true,
				"tooltip": {
					"valueDecimals": 4,
					"pointFormat": "<span style=\"color:{point.color}\">{point.y}</span> "
				},
				"point": {
					"events": {}
				}
			},
			"series": {
				"shadow": false,
				"stacking": "normal",
				"groupPadding": 0.2,
				"pointPadding": 0.4,
				"dataLabels": {
					"enabled": false,
					"inside": false,
					"textOutline": false,
					"textShadow": false
				},
				"states": {
					"hover": {
						"enabled": true,
						"halo": {
							"size": 4
						}
					}
				},
				"minPointLength": 0,
				"cursor": "",
				"point": {
					"events": {}
				}
			}
		}
	};
	return jsonData;
}