Ext.define('ComplianceCheckRun.view.CommonGrid', 
{
	extend:'Ext.panel.Panel',
	alias:'widget.commongrid',
	autoDestroy:true,
	header:false,
	bodyPadding:'0 0 0 0',
	layout:'fit',
	margin:'0 5 5 5',
	alignR:'',
	config: 
	{
		data: {},
		storeData:[],
		storefileds:[],
		gridColumns:[]
	},
	constructor: function(config) 
	{
		var me = this;
		me.initConfig(config);
		me.callParent(arguments);		
	},
	initComponent:function()
	{
		var me = this;
		me.storeData = me.cgdata.gridData;
		me.storefileds = me.cgdata.gridFields;
		me.gridColumns = me.cgdata.gridColumns;
		var gridCol = this.columnsgrouping(me.gridColumns);
		me.gridColumns = gridCol;
		var pagStoreObj = new Ext.create('Ext.data.Store',
		{
			fields:me.storefileds,
			data:me.storeData,
			realData:me.storeData,
			sortOnLoad: true,
			pageSize: parseInt(me.cgdata.colSize),
			//pageSize: me.cgdata.colSize,
			proxy: 
			{
				type: 'pagingmemory'
			}
		});
		me.items = me.loadGrid(pagStoreObj);
		me.callParent();
		me.addDocked({		
				xtype: 'pagingtoolbar',
				id:'pagingtoolbarid',
				cls:"pagingtoolbar",
				//cls:"newPagination", 
				store:[],				  // same store GridPanel is using
				dock: 'bottom',
				displayInfo: true,			
				displayMsg: 'Displaying {0} - {1} of {2} &nbsp;records ',
				emptyMsg: "No records to display&nbsp;",
				listeners: { 
					afterrender : function() 
					{
						this.child('#refresh').hide(); 
					} 
				}   
		});			
		if(!Ext.isEmpty(Ext.getCmp('pagingtoolbarid')))
		{
			Ext.getCmp('pagingtoolbarid').bindStore(pagStoreObj);
		}
	},
	columnsgrouping:function(data)
	{
		data[0].renderer=function(value,metaData,record,rowIndex,colIndex,store)
		{
			var backgroundShade = record.data.HIGHLIGHT_ROW;
			var first = !rowIndex || value !== store.data.items[rowIndex - 1].data.COMPONENT_NAME;
			if (first) 
			{
				var i = rowIndex + 1, span = 1; 
				while (i < store.getCount() && value === store.data.items[i].data.COMPONENT_NAME) { 
					i++; 
					span++; 
				} 
				if(backgroundShade != undefined && backgroundShade != null && backgroundShade)
					metaData.tdAttr = 'rowspan = ' + span ; 
				else
					metaData.tdAttr = 'rowspan = ' + span ; 
			} 
			else
			{ 
				metaData.tdAttr='style="display:none;"'; 
			} 
			
			var backgroundShade = record.data.HIGHLIGHT_ROW;
			if(backgroundShade != undefined && backgroundShade != null && backgroundShade)
				metaData.tdAttr += ' style="background:#ffffff !important;"'; 
			else
				metaData.tdAttr += ' style="background:#f9f9f9 !important;"'; 

			return first ? value : ''; 
		};
		data[1].renderer=function(value,metaData,record,rowIndex,colIndex,store)
		{
			var backgroundShade = record.data.HIGHLIGHT_ROW;
			var first = !rowIndex || (record.get('COMPONENT_NAME') !== store.data.items[rowIndex - 1].data.COMPONENT_NAME || value !== store.data.items[rowIndex - 1].data.COMP_TYPE_TEST_NAME);
			if (first) 
			{ 
				var i = rowIndex + 1, span = 1; 
				while (i < store.getCount() && (record.get('COMPONENT_NAME') === store.data.items[i].data.COMPONENT_NAME && value === store.data.items[i].data.COMP_TYPE_TEST_NAME)) { 
					i++; 
					span++; 
				} 
				if(backgroundShade != undefined && backgroundShade != null && backgroundShade)
					metaData.tdAttr = 'rowspan = ' + span; 
				else
					metaData.tdAttr = 'rowspan = ' + span;   
			} 
			else{ 
				metaData.tdAttr='style="display:none;"'; 
			} 
			
			var backgroundShade = record.data.HIGHLIGHT_ROW;
			if(backgroundShade != undefined && backgroundShade != null && backgroundShade)
				metaData.tdAttr += ' style="background:#ffffff !important;"'; 
			else
				metaData.tdAttr += ' style="background:#f9f9f9 !important;"'; 

			return first ? value : ''; 
		};
		data[2].renderer=function(value,metaData,record,rowIndex,colIndex,store)
		{
			var backgroundShade = record.data.HIGHLIGHT_ROW;
			if(backgroundShade != undefined && backgroundShade != null && backgroundShade)
				metaData.tdAttr = 'style="background:#ffffff !important;"'; 
			else
				metaData.tdAttr = 'style="background:#f9f9f9 !important;"'; 

			return value; 
		};
		data[3].renderer=function(value,metaData,record,rowIndex,colIndex,store)
		{
			var backgroundShade = record.data.HIGHLIGHT_ROW;
			if(backgroundShade != undefined && backgroundShade != null && backgroundShade)
				metaData.tdAttr = 'style="background:#ffffff !important;"'; 
			else
				metaData.tdAttr = 'style="background:#f9f9f9 !important;"'; 

			return value; 
		};
		data[4].renderer=function(value,metaData,record,rowIndex,colIndex,store)
		{
			var backgroundShade = record.data.HIGHLIGHT_ROW;
			if(backgroundShade != undefined && backgroundShade != null && backgroundShade)
				metaData.tdAttr = 'style="background:#ffffff !important;"'; 
			else
				metaData.tdAttr = 'style="background:#f9f9f9 !important;"'; 

			return value; 
		};
		data[5].renderer=function(value,metaData,record,rowIndex,colIndex,store)
		{
			var backgroundShade = record.data.HIGHLIGHT_ROW;
			if(backgroundShade != undefined && backgroundShade != null && backgroundShade)
				metaData.tdAttr = 'style="background:#ffffff !important;"'; 
			else
				metaData.tdAttr = 'style="background:#f9f9f9 !important;"'; 

			return value ? "Yes" : "No"; 
		};
		data[6].renderer=function(value,metaData,record,rowIndex,colIndex,store)
		{
			var backgroundShade = record.data.HIGHLIGHT_ROW;
			if(backgroundShade != undefined && backgroundShade != null && backgroundShade)
				metaData.tdAttr = 'style="background:#ffffff !important;"'; 
			else
				metaData.tdAttr = 'style="background:#f9f9f9 !important;"'; 

			return value ? "Yes" : "No"; 
		};
		return data;
	},
	loadGrid:function(pagStoreObj)
	{
		var me = this;
		var hiddenob = true;
		var ovObj = 'auto';
		var emptytext = '<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>' + config.msgs.noDataFound + '</div></div></div>';
		var grid = Ext.create('Ext.grid.Panel', 
		{
			flex:1,
			ui:'newGridPanel',
			border:true,
			id:'detailsGrid',
			header:false,
			scroll:true,
			autoScroll:true,
			overflowX: ovObj,
			dockedItems: [{
				xtype:'label',
				hidden:hiddenob,
				html:'<span class="font_normal11 fontStyleRobotRegular" style="float:right">Last '+me.data.timeline+'</span>',
				height:'15px'
			}],
			columnLines : true,
			store:pagStoreObj,
			viewConfig: {
				emptyText: emptytext,
				deferEmptyText: false,
				trackOver : false,
				disableSelection:true
			},
			columns: me.gridColumns,
			update: function(data)
			{
				var gridCol = me.columnsgrouping(data.gridColumns);
				data.gridColumns = gridCol;
				var pagStoreObj = new Ext.create('Ext.data.Store',{
					fields:data.gridFields,
					data:data.gridData,
					realData:data.gridData,
					sortOnLoad: true,
					pageSize: parseInt(data.colSize),
					proxy: {
						type: 'pagingmemory'
					}
				});
				if(!Ext.isEmpty(Ext.getCmp('pagingtoolbarid')))
				{
					Ext.getCmp('pagingtoolbarid').bindStore(pagStoreObj);
				}
				Ext.getCmp('detailsGrid').reconfigure(pagStoreObj, data.gridColumns);
				Ext.getCmp('detailsGrid').getView().refresh();
			}
		});
		return grid;
	}   
});