var index = 0;
var indexMeasure = 0;
var panelIndex = 0;

var selectedTmpltNmForCurOprtns;
var selectedTmpltDscForCurOprtns;
var selectedMngdCmpntTypForCurOprtns;
var selectedMngdCmpntNmForCurOprtns;
var selectedCnfgTstForCurOprtns;
var selectedCnfgTstCdForCurOprtns;
var isCnfgTstCdDscrptrBasedForCurOprtns;
var givnMinNoOfDscrptrCndtn;
var givnMaxNoOfDscrptrCndtn;
var tmpltTestSeqNo = null;
var selectedDscrptrForCurOprtns;
var isSelectedDscrptrAlrdyAvlblInTmplt;

var stringNumberValueCndtnStore;
var stringValueCndtnStore;

var expectedUnitsStore;

var listOfStringCndtnVlus;
var listOfNumberCndtnVlus;

var jsonForChooseDscrptrPg;

Ext.define('ComplianceCheckTemplates.controller.Main', {
	extend : 'Ext.app.Controller',
	views : [
		'Main',
	],
	refs:[
		{
			selector : 'main',
			ref : 'main'
		},
		{
			selector : 'formitems',
			ref : 'formitems'
		},
		{
			selector : 'templatelistgrid', //tlg
			ref : 'templatelistgrid'
		},
		{
			selector : 'templatedetailswindow',
			ref : 'templatedetailswindow'
		},
	],
	init :function() {
		me = this;
		this.control({
			'templatelistgrid':
			{
				'afterrender': this.tlg_loadTemplatesList
			}
			,'templatelistgrid button[id="AddNewTemplate"]':
			{
				'click': this.addNewTemplate
			}
			,'templatelistgrid trigger[id="searchTmpltNmTextBox"]':
			{
				'keyup': this.tlg_searchMatchingTmplts
			}
			,'#searchTmpltNmTextBox' : {
				'ontriggerclick': this.tlg_searchMatchingTmplts
			}
			,'formitems':
			{
				'afterrender': this.getCmpntTypesData
			}
			,'formitems combobox[id="compType"]' :{
				'select' : this.mngdCmpntTypChanged
			}
			,'formitems combobox[id="component"]' :{
				'select' : this.mngdCmpntChanged
			}
			,'formitems combobox[id="enableConfigTest"]' :{
				'select' : this.cnfgTstChanged
			}
			,'formitems textfield[id="templateName"]' :{
				'blur' : this.checkTmpltNmExistence
			}
			,'formitems button[id="submit"]' :{
				'click' : {
					fn:function()
					{
						this.onSubmit(null);
					}
				}
			}
		});
	},
	tlg_loadTemplatesList : function()
	{
		var me = this;

		selectedTmpltNmForCurOprtns = null;
		selectedTmpltDscForCurOprtns = null;
		selectedMngdCmpntTypForCurOprtns = null;
		selectedMngdCmpntNmForCurOprtns = null;
		selectedCnfgTstForCurOprtns = null;
		selectedCnfgTstCdForCurOprtns = null;;
		isCnfgTstCdDscrptrBasedForCurOprtns =null;
		givnMinNoOfDscrptrCndtn = null;
		givnMaxNoOfDscrptrCndtn = null;
		tmpltTestSeqNo = null;
		selectedDscrptrForCurOprtns=null;
		isSelectedDscrptrAlrdyAvlblInTmplt=null;

		Ext.getCmp('main').setTitle('<span class="newFont_bold15">' + config.title.complianceCheck + ' - ' + config.title.listOfAllTmplts + ' </span>');

		Ext.Ajax.request({
			url : config.urls.servletURL,
			params : {
				'cmd' : "Compliance_Templates",
				'reqfrom' : "getTemplatesList",
				'pullData' : "true",
			},
			method : 'POST',
			async : false,
			success : function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var templateListJSON = Ext.decode( jsonText );
					me.createTmpltLstGridAndLoadData(templateListJSON);
				}
			}
		});
	},
	addNewTemplate : function()
	{
		Ext.getCmp('main').removeAll();
		Ext.getCmp('main').add(Ext.create('ComplianceCheckTemplates.view.FormItems'));
		Ext.getCmp('main').setTitle('<span class="newFont_bold15">' + config.title.complianceCheck + ' - ' + config.title.addNewTmplt + ' </span>');
		Ext.getCmp('newOrExistingTmplt').setValue('new');

		jsonForChooseDscrptrPg=null;
		tmpltTestSeqNo = null;
		selectedTmpltDscForCurOprtns = null;
		selectedMngdCmpntTypForCurOprtns = null;
		selectedMngdCmpntNmForCurOprtns = null;
		selectedCnfgTstForCurOprtns = null;
		selectedCnfgTstCdForCurOprtns = null;
		selectedDscrptrForCurOprtns = null;
		isSelectedDscrptrAlrdyAvlblInTmplt = null;

		Ext.getCmp('homeIconSeparator').show();
		Ext.getCmp('homeIconId').show();
		Ext.getCmp('main').doLayout();
		tmpltTestSeqNo=null;
	},
	getCmpntTypesData : function()
	{
		Ext.Ajax.request({
			url : config.urls.servletURL,
			params : {
				'cmd' : "Compliance_Templates",
				'reqfrom' : "loadCmpntTyps",
				'pullData' : "true",
			},
			method : 'POST',
			async : false,
			success : function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var cmpntTypesJSON = Ext.decode( jsonText );
					var compType = Ext.getCmp('compType');
					compType.getStore().loadRawData(cmpntTypesJSON['ComponentTypes']);
					compType.setValue(cmpntTypesJSON['selMngdCmpntTyp']);

					Ext.getCmp('component').getStore().loadRawData(cmpntTypesJSON['MngdCmpnts']);
					Ext.getCmp('enableConfigTest').getStore().loadRawData(cmpntTypesJSON['EnbldCnfgTsts']);
				}
			}
		});
	},
	mngdCmpntTypChanged : function()
	{
		Ext.getCmp('numOfDescriptorConditionId').hide();
		Ext.getCmp('submit').enable();
		if(Ext.getCmp('compType').getValue() != -1)
		{
			Ext.Ajax.request({
				url : config.urls.servletURL,
				params : {
					'cmd' : "Compliance_Templates",
					'reqfrom' : "cmpTypSelctd",
					'pullData' : "true",
					'selMngdCmpntTyp' : Ext.getCmp('compType').getValue(),
				},
				method : 'POST',
				async : false,
				success : function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var mngdCmpntsJSON = Ext.decode( jsonText );
						var mngdCmpnts = Ext.getCmp('component');
						mngdCmpnts.getStore().loadRawData(mngdCmpntsJSON['MngdCmpnts']);
						mngdCmpnts.setValue(mngdCmpntsJSON['selMngdCmpnt']);

						Ext.getCmp('enableConfigTest').getStore().loadRawData(mngdCmpntsJSON['EnbldCnfgTsts']);
						Ext.getCmp('enableConfigTest').setValue('');
						Ext.getCmp('min').setValue('');
						Ext.getCmp('max').setValue('');
					}
				}
			});
		}
		else
		{
			Ext.getCmp('component').getStore().removeAll();
			Ext.getCmp('component').setValue('');
			Ext.getCmp('enableConfigTest').getStore().removeAll();
			Ext.getCmp('enableConfigTest').setValue('');
			Ext.getCmp('min').setValue('');
			Ext.getCmp('max').setValue('');
		}
	},
	mngdCmpntChanged : function()
	{
		Ext.getCmp('numOfDescriptorConditionId').hide();
		Ext.getCmp('submit').enable();
		if(Ext.getCmp('component').getValue() != -1)
		{
			Ext.Ajax.request({
				url : config.urls.servletURL,
				params : {
					'cmd' : "Compliance_Templates",
					'reqfrom' : "mngCmpntSelctd",
					'pullData' : "true",
					'selMngdCmpntTyp' : Ext.getCmp('compType').getValue(),
					'selMngdCmpnt' : Ext.getCmp('component').getValue(),
				},
				method : 'POST',
				async : false,
				success : function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ))
					{
						var jsonText = response.responseText;
						var cnfgTstsJSON = Ext.decode( jsonText );
						var enbldCnfgTsts = Ext.getCmp('enableConfigTest');
						enbldCnfgTsts.getStore().loadRawData(cnfgTstsJSON['EnbldCnfgTsts']);
						enbldCnfgTsts.setValue(cnfgTstsJSON['selCnfgTst']);
					}
				}
			});
		}
		else
		{
			Ext.getCmp('enableConfigTest').getStore().removeAll();
			Ext.getCmp('enableConfigTest').setValue('');
			Ext.getCmp('min').setValue('');
			Ext.getCmp('max').setValue('');
		}
	},
	cnfgTstChanged : function()
	{
		if(Ext.getCmp('enableConfigTest').getValue() != '-1')
		{
			Ext.Ajax.request({
				url : config.urls.servletURL,
				params : {
					'cmd' : "Compliance_Templates",
					'reqfrom' : "cnfgTstSelected",
					'selMngdCmpntTyp' : Ext.getCmp('compType').getValue(),
					'selMngdCmpnt' : Ext.getCmp('component').getValue(),
					'selCnfgTst' : Ext.getCmp('enableConfigTest').getValue(),
					'pullData' : "true",
					'selectedTmpltNmForCurOprtns' : selectedTmpltNmForCurOprtns,
				},
				method : 'POST',
				async : false,
				success : function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var isDscrptrJSON = Ext.decode( jsonText );
						if(isDscrptrJSON['isDscrptrBased']=="true")
						{
							isCnfgTstCdDscrptrBasedForCurOprtns = true;
							Ext.getCmp('numOfDescriptorConditionId').show();
							Ext.getCmp('min').setValue(isDscrptrJSON['minValue']);
							Ext.getCmp('max').setValue(isDscrptrJSON['maxValue']);
							Ext.getCmp('submit').enable();
						}
						else if(isDscrptrJSON['isDscrptrBased']=="false")
						{
							isCnfgTstCdDscrptrBasedForCurOprtns = false;
							Ext.getCmp('numOfDescriptorConditionId').hide();
							Ext.getCmp('min').setValue(isDscrptrJSON['minValue']);
							Ext.getCmp('max').setValue(isDscrptrJSON['maxValue']);
							Ext.getCmp('submit').enable();
						}
						else if(isDscrptrJSON['isDscrptrBased']=="null")
						{
							Ext.getCmp('numOfDescriptorConditionId').hide();
							Ext.getCmp('submit').disable();
							Ext.Msg.alert('&nbsp;', config.msgs.cnfgDataNotAvl);
						}
					}
				}
			});
		}
		else
		{
			Ext.getCmp('numOfDescriptorConditionId').hide();
			Ext.getCmp('min').setValue('');
			Ext.getCmp('max').setValue('');
		}
	},
	checkTmpltNmExistence : function()
	{
		if(Ext.getCmp('templateName').getValue().trim() != "" && !Ext.getCmp('templateName').readOnly)
		{
			Ext.Ajax.request({
				url : config.urls.servletURL,
				params : {
					'cmd' : "Compliance_Templates",
					'reqfrom' : "checkTmpltNmExistence",
					'pullData' : "true",
					'templateName' : Ext.getCmp('templateName').getValue().trim(),
				},
				method : 'POST',
				async : false,
				success : function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var isTmpltNmAlrdyExistJSON = Ext.decode( jsonText );
						if("true" == (isTmpltNmAlrdyExistJSON['isTmpltNmExists']))
						{
							Ext.Msg.alert('&nbsp;', config.msgs.tmpltNmAlrdyExst);
						}
					}
				}
			});
		}
	},
	onSubmit : function(partialOverride)
	{
		if(!isCnfgTstCdDscrptrBasedForCurOprtns)
		{
			Ext.getCmp('min').setValue('');
			Ext.getCmp('max').setValue('');
		}

		if( (Ext.getCmp('templateName').getValue().trim() != '') &&
			(Ext.getCmp('templateName').getValue().trim().substring(0,1) != ';') &&
			(Ext.getCmp('compType').getValue() != '-1') &&
			(Ext.getCmp('component').getValue() != '-1') &&
			(Ext.getCmp('enableConfigTest').getValue() != '-1') &&
			(Ext.getCmp('min').getValue() == null || Ext.getCmp('max').getValue() == null ||
			((Ext.getCmp('min').getValue() != null && Ext.getCmp('max').getValue() != null && Ext.getCmp('min').getValue() < Ext.getCmp('max').getValue())))
		  )
		{
			Ext.Ajax.request({
				url : config.urls.servletURL,
				params : {
					'cmd' : "Compliance_Templates",
					'reqfrom' : "submitChooseTest",
					'pullData' : "true",
					'newOrExistingTmplt' : Ext.getCmp('newOrExistingTmplt').getValue(),
					'templateName' : Ext.getCmp('templateName').getValue().trim(),
					'templateDesc' : Ext.getCmp('templateDesc').getValue().trim(),
					'selMngdCmpntTyp' : Ext.getCmp('compType').getValue(),
					'selMngdCmpnt' : Ext.getCmp('component').getValue(),
					'selCnfgTst' : Ext.getCmp('enableConfigTest').getValue(),
					'minNoOfDscrptrCndtn' : Ext.getCmp('min').getValue(),
					'maxNoOfDscrptrCndtn' : Ext.getCmp('max').getValue(),
					'tmpltTestSeqNo' : tmpltTestSeqNo,
					'partialOverride' : partialOverride,
				},
				method : 'POST',
				async : false,
				success : function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText) )
					{
						var jsonText = response.responseText;
						var savedPartialTmpltJSON = Ext.decode( jsonText );

						if(savedPartialTmpltJSON['tmpltSaveSts']=="true")
						{
							var givnTmpltNm = Ext.getCmp('templateName').getValue().trim();
							var givnTmpltDsc = Ext.getCmp('templateDesc').getValue().trim();
							var slctdCmpntTyp = Ext.getCmp('compType').getValue();
							var slctdCmpnt = Ext.getCmp('component').getValue();
							var slctdCnfgTst = Ext.getCmp('enableConfigTest').getValue();

							selectedTmpltNmForCurOprtns = Ext.getCmp('templateName').getValue().trim();
							selectedTmpltDscForCurOprtns = Ext.getCmp('templateDesc').getValue().trim();
							selectedMngdCmpntTypForCurOprtns = Ext.getCmp('compType').getValue();
							selectedMngdCmpntNmForCurOprtns = Ext.getCmp('component').getValue();
							selectedCnfgTstForCurOprtns = Ext.getCmp('enableConfigTest').getRawValue();
							selectedCnfgTstCdForCurOprtns = slctdCnfgTst;
							givnMinNoOfDscrptrCndtn = Ext.getCmp('min').getValue();
							givnMaxNoOfDscrptrCndtn = Ext.getCmp('max').getValue();
							tmpltTestSeqNo = savedPartialTmpltJSON['tmpltTestSeqNo'];
							selectedDscrptrForCurOprtns = null;
							isSelectedDscrptrAlrdyAvlblInTmplt = null;

							if(savedPartialTmpltJSON['conditionsFrmCmplncChckTmpltForView'] != null)
							{
								me.loadTemplateDetailsWindow(savedPartialTmpltJSON['conditionsFrmCmplncChckTmpltForView']);
								if(Ext.getCmp('toolsButId').curntExpndCollpsSts != null && Ext.getCmp('toolsButId').curntExpndCollpsSts == 'expanded')
								{
									Ext.getCmp('templatedetailswindow').toggleWindowAnimation();
								}
							}

							if(isCnfgTstCdDscrptrBasedForCurOprtns)
							{
								jsonForChooseDscrptrPg = savedPartialTmpltJSON;
								me.loadChooseDescriptorPage();
							}
							else
							{
								Ext.getCmp('main').setTitle('<span class="newFont_bold15">' + config.title.complianceCheck + ' - ' + config.title.addMdfyCndtnsForTmplt + ' \'' + givnTmpltNm + '\' </span>');
								Ext.getCmp('templateName').setReadOnly(true);
								Ext.getCmp('newOrExistingTmplt').setValue('existing');
								me.loadAddEditConditionsWindow(null, null, null, savedPartialTmpltJSON['allMsrColumnNmCds']);
							}
						}
						else if(savedPartialTmpltJSON['duplicateTmpltNm'])
						{
							Ext.Msg.alert('&nbsp;', config.msgs.tmpltNmAlrdyExst);
						}
						else if(savedPartialTmpltJSON['getPartialOverrideCnfrmtn'])
						{
							//partial over ride confirmation
							Ext.Msg.confirm("&nbsp;", config.msgs.tstCndtnsNotAdded + " '" + savedPartialTmpltJSON['cmpTypDescToOverride'] + "/" + savedPartialTmpltJSON['tstDescToOverride'] + "'. " + config.msgs.cnfrmToOvrwrtTst, function(btnText)
							{
								if(btnText == "yes")
								{
									me.onSubmit("true");
								}
							}, this);
						}
					}
				}
			});
		}
		else
		{
			if(Ext.getCmp('templateName').getValue().trim() == '')
			{
				Ext.Msg.alert('&nbsp;', config.msgs.plsPrvdTmpltNm);
			}
			else if(Ext.getCmp('templateName').getValue().trim().substring(0,1) == ';')
			{
				Ext.Msg.alert('&nbsp;', config.msgs.tmpltNmNotSWsemiCln);
			}
			else if(Ext.getCmp('compType').getValue() == '-1' || Ext.getCmp('compType').getValue() == '')
			{
				Ext.Msg.alert('&nbsp;', config.msgs.plsSlctCmpntTyp);
			}
			else if(Ext.getCmp('component').getValue() == '-1' || Ext.getCmp('component').getValue() == '')
			{
				Ext.Msg.alert('&nbsp;', config.msgs.plsSlctCmpnt);
			}
			else if(Ext.getCmp('enableConfigTest').getValue() == '-1' || Ext.getCmp('enableConfigTest').getValue() == '')
			{
				Ext.Msg.alert('&nbsp;', config.msgs.plsSlctCnfgTst);
			}
			else if(
				(Ext.getCmp('min').getValue() != null && Ext.getCmp('max').getValue() != null && Ext.getCmp('min').getValue() >= Ext.getCmp('max').getValue())
			)
			{
				Ext.Msg.alert('&nbsp;', config.msgs.minShdLTMax);
			}
		}
	},
	loadChooseDescriptorPage : function()
	{
		tmpltTestSeqNo = jsonForChooseDscrptrPg['tmpltTestSeqNo'];

		var fieldItems = Ext.create('Ext.form.FieldSet', {
			columnWidth: 1,
			ui: 'newFieldSetSimple',
			id: 'fieldsetId',
			title: Ext.getCmp('enableConfigTest').getRawValue(),
			padding: '0 10 10 10',
			items:
			[
				{
					xtype: 'container',
					layout:{
						type:'hbox',
						align:'stretch',
					},
					items:[
					{
						xtype:'container',
						flex:1,
						//padding:'4 0 2 0',
					},
					{
						xtype:'container',
						id: 'machinToolId',
						width:30,
						height:25,
						//border:true,
						//style:{'border':'1px solid red'},
						//margin:'-5px 0 0 0',
						html: '<div style="float:right;cursor:pointer;"><img src="/final/images/spacer.gif" class="iconAddColumn" id="callTooltip" onclick="javascript:openChooseMeasuresWindow(null);" ></div>',
					}]
				}, {
					xtype: 'container',
					id: 'gridContainerId',
				},
				{
					xtype:'container',
					flex:1,
					//height:20,
					margin:'10 0 0 0',
					html:'<div class="aPanelSmallText"><img src="/final/images/spacer.gif" class="cIconTip" style="vertical-align:bottom">' + config.labels.clkDscrptrLnk_1 + ' \'' + jsonForChooseDscrptrPg['slctdCols'][0].toUpperCase() + '\' ' +  config.labels.clkDscrptrLnk_2 + '</div>'
				},
			]
		})
		
		var configDetailsHeaderToolbar = Ext.create('Ext.toolbar.Toolbar',{
			dock:'top',
			padding:'0 0 10 0',
			margin:'2 0 10 0',
			cls:'toolsBottomBorder',
			id:'configDetailsHeaderToolbarId',
			// style:{
			// 	'border-bottom':'1px solid #cccccc !important'
			// },
			items:[{
				xtype:'button',
				width:28,
				height:28,
				margin:'0 5 0 0',
				iconCls:'iconRoundLeftArrowBlue',
				style:{
					'background':'transparent',
					'border':'none',
					'width':'24px',
					'height':'24px',
				},
				handler:function()
				{
					Ext.getCmp('main').removeAll();
					Ext.getCmp('main').add(Ext.create('ComplianceCheckTemplates.view.FormItems'));
					Ext.getCmp('newOrExistingTmplt').setValue('existing');
					Ext.getCmp('main').setTitle('<span class="newFont_bold15">' + config.title.complianceCheck + ' - ' + config.title.addMdfyCndtnsForTmplt + ' \'' + selectedTmpltNmForCurOprtns + '\' </span>');
					Ext.getCmp('templateName').setReadOnly(true);
					Ext.getCmp('templateName').setValue(selectedTmpltNmForCurOprtns);
					Ext.getCmp('templateDesc').setValue(selectedTmpltDscForCurOprtns);
					Ext.getCmp('compType').setValue(selectedMngdCmpntTypForCurOprtns);
					me.mngdCmpntTypChanged();
					Ext.getCmp('component').setValue(selectedMngdCmpntNmForCurOprtns);
					me.mngdCmpntChanged();
					Ext.getCmp('enableConfigTest').setValue(selectedCnfgTstCdForCurOprtns);
					if(isCnfgTstCdDscrptrBasedForCurOprtns)
					{
						Ext.getCmp('numOfDescriptorConditionId').show();
						Ext.getCmp('min').setValue(givnMinNoOfDscrptrCndtn);
						Ext.getCmp('max').setValue(givnMaxNoOfDscrptrCndtn);
					}
					jsonForChooseDscrptrPg=null;
					selectedTmpltNmForCurOprtns = null;
					tmpltTestSeqNo = null;
					selectedTmpltDscForCurOprtns = null;
					selectedMngdCmpntTypForCurOprtns = null;
					selectedMngdCmpntNmForCurOprtns = null;
					selectedCnfgTstForCurOprtns = null;
					selectedCnfgTstCdForCurOprtns = null;
					selectedDscrptrForCurOprtns = null;
					isSelectedDscrptrAlrdyAvlblInTmplt = null;
					Ext.getCmp('homeIconSeparator').show();
					Ext.getCmp('homeIconId').show();
					Ext.getCmp('main').doLayout();
				}
			},{
				xtype:'container',
				html:'<div class="newFont_bold14" style="padding-top:0px;padding-left:2px;float:left" >' + config.labels.cnfgDtlsFor + ' ' + Ext.getCmp('component').getValue() + ' (' + Ext.getCmp('compType').getValue() + ') </div>'
			}]
		})
		
		Ext.getCmp('main').setTitle('<span class="newFont_bold15">' + config.title.complianceCheck + ' - ' + config.title.addMdfyCndtnsForTmplt + ' \'' + Ext.getCmp('templateName').getValue().trim() + '\' </span>');
		Ext.getCmp('formitems').removeAll();
		Ext.getCmp('formitems').addDocked(configDetailsHeaderToolbar);
		Ext.getCmp('formitems').add(fieldItems);
		me.loadChooseDescriptorGridData(jsonForChooseDscrptrPg['slctdCols']);
	},
	chngeTmpltSts : function(templateName, currentStatus)
	{
		if(templateName != '')
		{
			Ext.Ajax.request({
				url : config.urls.servletURL,
				params : {
					'cmd' : "Compliance_Templates",
					'reqfrom' : "chngeTmpltSts",
					'pullData' : "true",
					'tmpltSts_2b_chngd' : templateName,
				},
				method : 'POST',
				async : false,
				success : function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var tmpltStsChangedJSON = Ext.decode( jsonText );

						me.createTmpltLstGridAndLoadData(tmpltStsChangedJSON);
						if(tmpltStsChangedJSON['tmpltStsChange'] == true)
						{
							if(currentStatus == 'iconInActive')
							{
								Ext.Msg.alert('&nbsp;', config.msgs.template + " '" + templateName + "' " + config.msgs.enabled);
							}
							else if(currentStatus == 'iconActive')
							{
								Ext.Msg.alert('&nbsp;', config.msgs.template + " '" + templateName + "' " + config.msgs.disabled);
							}
						}
						else if(tmpltStsChangedJSON['tmpltStsChange'] == false)
						{
							Ext.Msg.alert('&nbsp;', config.msgs.issueInstatsChng);
						}
					}
				}
			});
		}
	},
	mdfyTmplt : function(tmpltNm)
	{
		Ext.Ajax.request({
			url : config.urls.servletURL,
			params : {
				'cmd' : "Compliance_Templates",
				'reqfrom' : "mdfyTmplt",
				'pullData' : "true",
				'tmpltNm' : tmpltNm,
			},
			method : 'POST',
			async : false,
			success : function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var mdfyTmpltJSON = Ext.decode( jsonText );

					Ext.getCmp('main').removeAll();
					Ext.getCmp('homeIconId').show();
					Ext.getCmp('homeIconSeparator').show();
					Ext.getCmp('main').add(Ext.create('ComplianceCheckTemplates.view.FormItems'));
					Ext.getCmp('main').setTitle('<span class="newFont_bold15">' + config.title.complianceCheck + ' - ' + config.title.addMdfyCndtnsForTmplt + ' \'' + tmpltNm + '\' </span>');
					Ext.getCmp('templateName').setReadOnly(true);
					Ext.getCmp('templateName').setValue(tmpltNm);
					Ext.getCmp('templateDesc').setValue(mdfyTmpltJSON['tmpltDesc']);
					Ext.getCmp('newOrExistingTmplt').setValue('existing');
					jsonForChooseDscrptrPg=null;
					tmpltTestSeqNo = null;
					selectedTmpltNmForCurOprtns = tmpltNm;
					selectedTmpltDscForCurOprtns = null;
					selectedMngdCmpntTypForCurOprtns = null;
					selectedMngdCmpntNmForCurOprtns = null;
					selectedCnfgTstForCurOprtns = null;
					selectedCnfgTstCdForCurOprtns = null;
					selectedDscrptrForCurOprtns = null;
					isSelectedDscrptrAlrdyAvlblInTmplt = null;
					isCnfgTstCdDscrptrBasedForCurOprtns = null;
					givnMinNoOfDscrptrCndtn = null;
					givnMaxNoOfDscrptrCndtn = null;

					Ext.Ajax.request({
						url : config.urls.servletURL,
						params : {
							'cmd' : "Compliance_Templates",
							'reqfrom' : "getSavedConditions",
							'pullData' : "true",
							'tmpltNm' : tmpltNm,
						},
						method : 'POST',
						async : false,
						success : function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var jsonText = response.responseText;
								var cndtnsFrmCmplncChckTmpltForViewJSON = Ext.decode( jsonText );
								selectedTmpltNmForCurOprtns = tmpltNm;
								me.loadTemplateDetailsWindow(cndtnsFrmCmplncChckTmpltForViewJSON['conditionsFrmCmplncChckTmpltForView']);
								if(Ext.getCmp('toolsButId').curntExpndCollpsSts != null && Ext.getCmp('toolsButId').curntExpndCollpsSts == 'collapsed')
								{
									Ext.getCmp('templatedetailswindow').toggleWindowAnimation();
								}
							}
						}
					});
				}
			}
		});
	},
	delTmplt : function(value)
	{
		if(value != '')
		{
			Ext.Ajax.request({
				url : config.urls.servletURL,
				params : {
					'cmd' : "Compliance_Templates",
					'reqfrom' : "delTmplt",
					'pullData' : "true",
					'tmplt_2b_del' : value,
				},
				method : 'POST',
				async : false,
				success : function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var delTmpltJSON = Ext.decode( jsonText );

						me.createTmpltLstGridAndLoadData(delTmpltJSON);

						if(delTmpltJSON['templateDelStatus'] == true)
						{
							Ext.Msg.alert('&nbsp;', config.msgs.tmpltDltd);
						}
						else if(delTmpltJSON['templateDelStatus'] == false)
						{
							Ext.Msg.alert('&nbsp;', config.msgs.issueInTmpltDel);
						}
					}
				}
			});
		}
	},
	createTmpltLstGridAndLoadData : function(jsonObj)
	{
		var dataArray=jsonObj['templateList'];

		var tmpltLstGridDataModel = Ext.define('templateListGridDataModel',
		{
			extend: 'Ext.data.Model',
			fields: [
				{ name: 'templateName', type: 'string'},
				{ name: 'tmpltNmDscrption', type: 'string'},
				{ name: 'tmpltCrtdDt', type: 'date', dateFormat: 'M d, Y H:i T'},
				{ name: 'tmpltLstMdfdDt', type: 'date', dateFormat: 'M d, Y H:i T'},
				{ name: 'owner', type: 'string'},
				{ name: 'status', type: 'string'},
			]
		});

		var store = new Ext.data.Store(
		{
			fields: ['templateName', 'tmpltNmDscrption', 'tmpltCrtdDt', 'tmpltLstMdfdDt', 'owner', 'status'],
			proxy: {
				type: 'pagingmemory',
				enablePaging:true,
				reader: {
					type: 'json'
				}
			},
			pageSize:10,
			model: tmpltLstGridDataModel,
			data: dataArray,
			autoLoad : true,
			sortOnLoad: true,
		});

		var gridpanel = Ext.create('Ext.grid.Panel',
		{
			ui: 'newGridPanelNoBorder',
			autoScroll: true,
			scroll: true,
			border:true,
			//cls:'panelBorder',
			store: store,
			viewConfig:
			{
				emptyText : '<table width="100%" height="100%" align="center" valign="middle"><tr><td align="center" valign="middle"><div  class="iconExclamation"></div><div class="font_normal11">' + config.msgs.tmpltsNotAvlbl + '</div></td></tr></table>',
				deferEmptyText:false,
			},
			dockedItems: [
			{
				xtype: 'pagingtoolbar',
				cls: 'newPagination2',
				pageSize: 10,
				store: store,
				dock: 'bottom',
				displayInfo: true,
				id:'pageingTool',
				name:'pageingTool',
				displayMsg: config.labels.displyngTmplts + " {0} - {1} " + config.labels.of + " {2}",
				emptyMsg: config.msgs.tmpltsNotAvlbl,
				listeners:
				{
					change : function(thisd, params)
					{
						if(!Ext.isEmpty(params))
							Ext.getCmp('templateListGridId').activePage = params.currentPage;
						else
							Ext.getCmp('templateListGridId').activePage=0;
					}
				}
			}],
			listeners:
			{
				sortchange:function(ct, column, e, t, eOpts )
				{
					if((!Ext.isEmpty(column)) && (!Ext.isEmpty(e)))
					{
						Ext.getCmp('templateListGridId').sortColumn = column.dataIndex;
						Ext.getCmp('templateListGridId').sortOrder = e;
					}
					this.getStore().loadPage(Ext.getCmp('templateListGridId').activePage);
				},
			},
			columns:
			{
				defaults:
				{
					menuDisabled: false,
					sortable: true,
					enableColumnMove: true,
				},
				items:
				[
					{
						text: config.labels.hdr_tmpltNm,
						dataIndex: 'templateName',
						flex: 1.5,
						renderer:function(value,metaData,record,rowIndex,colIndex)
						{
							metaData.tdAttr = 'data-qtip="' + value + '"';
							return '<img style="margin:0px 10px 2px 0px;vertical-align:middle" class="iconTemplateName" src="/final/images/clear.png"/>'+value;
						}
					},
					{
						text: config.labels.hdr_tmpltDesc,
						dataIndex: 'tmpltNmDscrption',
						align: 'left',
						flex: 2,
						renderer : function(value, metadata, record)
						{
							metadata.tdAttr = 'data-qtip="' + value + '"';
							return value;
						}
					},
					{
						text: config.labels.hdr_crtdDt,
						dataIndex: 'tmpltCrtdDt',
						align: 'left',
						width: 170,
						xtype: 'datecolumn',
						format: 'M d, Y H:i T',
						sortable: true,
					},
					{
						text: config.labels.hdr_mdfdDt,
						dataIndex: 'tmpltLstMdfdDt',
						align: 'left',
						width: 170,
						xtype: 'datecolumn',
						format: 'M d, Y H:i T',
						sortable: true,
					},
					{
						text: config.labels.hdr_owner,
						dataIndex: 'owner',
						align: 'left',
						//flex: 1,
						width:80,
					},
					{
						text: config.labels.hdr_status,
						dataIndex:'status',
						width:70,
						style:{
							'border-right':'0px',
						},
						align:'center',
						renderer:function(value,metaData,record,rowIndex,colIndex)
						{
							metaData.style='text-align:center';
							if(value == "iconActive")
							{
								return '<img data-qtip="' + config.msgs.tooltipEnbld + '" data-qclass="yellowTip" style="margin:0px 0px 2px 0px;vertical-align:middle" class="'+record.get('status')+'" src="/final/images/clear.png"/>';
							}
							else if(value == "iconInActive")
							{
								return '<img data-qtip="' + config.msgs.tooltipDsbld + '" data-qclass="yellowTip" style="margin:0px 0px 2px 0px;vertical-align:middle" class="'+record.get('status')+'" src="/final/images/clear.png"/>';
							}
							else if(value == "")
							{
								return '<img data-qtip="' + config.msgs.tooltipPrtlTmplt + '" data-qclass="yellowTip" style="margin:0px 0px 2px 0px;vertical-align:middle" class="stateSymbol_GRAY" src="/final/images/clear.png"/>';
							}
						},
						listeners :
						{
							'click':function(grid, htmlRow, index, columnIndex,mouseEvent, record)
							{
								var curSts = record.get('status');
								if(curSts == 'iconActive' || curSts == 'iconInActive')
								{
									me.chngeTmpltSts(record.get('templateName'), curSts);
								}
							}
						}
					},
					{
						header: '<div >&nbsp;</div>',
						menuDisabled:true,
						height:20,
						sortable :false,
						style:{'border':'0px'},
						columns :
						[
							{
								xtype: 'actioncolumn',
								width: 50,
								style:{'border':'0px'},
								align: 'center',
								items: [{
									iconCls: 'iconModify',
									tooltip: config.msgs.tooltipModify,
								}],
								listeners :
									{
										'click':function(grid, htmlRow, index, columnIndex,mouseEvent, record)
										{
											me.mdfyTmplt(record.get('templateName'));
										}
									}
							},
							{
								xtype: 'actioncolumn',
								width: 50,
								style:{'border':'0px'},
								align: 'center',
								items: [{
									iconCls: 'iconDelete',
									tooltip: config.msgs.tooltipDelete,
								}],
								listeners :
									{
										'click':function(grid, htmlRow, index, columnIndex,mouseEvent, record)
										{
											Ext.MessageBox.confirm('Confirm', config.msgs.cnfrmToDelTmplt + " '" + record.get('templateName') + "' ", callbackFunction);
											function callbackFunction(btn)
											{
												if(btn == 'yes')
												{
													me.delTmplt(record.get('templateName'));
												}
											};
										}
									}
							},
						]
					}
				],
			}
		});

		var calculatedActivePage;
		var calculatedTotNoOfPages;

		if(dataArray.length  - (Math.round(dataArray.length/store.pageSize)*store.pageSize) > 0)
		{
			calculatedTotalNoOfPages = Math.round(dataArray.length/store.pageSize) + 1;
		}
		else
		{
			calculatedTotalNoOfPages = Math.round(dataArray.length/store.pageSize);
		}

		if(Ext.getCmp('templateListGridId').activePage > calculatedTotalNoOfPages)
		{
			calculatedActivePage = calculatedTotalNoOfPages;
		}
		else
		{
			calculatedActivePage = Ext.getCmp('templateListGridId').activePage;
		}

		if(calculatedActivePage == 0)
		{
			calculatedActivePage = 1;
		}

		store.loadPage(calculatedActivePage);

		if( (!Ext.isEmpty(Ext.getCmp('templateListGridId').sortColumn)) &&  (!Ext.isEmpty(Ext.getCmp('templateListGridId').sortOrder)) )
		{
			store.sort(Ext.getCmp('templateListGridId').sortColumn, Ext.getCmp('templateListGridId').sortOrder);
		}

		Ext.getCmp('templateListGridId').removeAll();
		Ext.getCmp('templateListGridId').add(gridpanel);
		Ext.getCmp('templateListGridId').doLayout();
	},
	openChooseMeasuresWindow: function (selColArry)
	{
		if (Ext.isEmpty(Ext.getCmp('GenericWindowId'))) {
			var allColumnArray = [];
			var me = this;
			var heading = jsonForChooseDscrptrPg['allMsrColumnNms'];
			var headingSelCol;
			if(selColArry == null)
			{
				headingSelCol = jsonForChooseDscrptrPg['slctdCols'];
			}
			else
			{
				headingSelCol = selColArry;
			}
			var allMsrColNameCds = jsonForChooseDscrptrPg['allMsrColumnNmCds'];
			var allDscrptrMsrVlus = jsonForChooseDscrptrPg['dscrptrAndMsrVlus'];
			var dscrptrMsrNm = jsonForChooseDscrptrPg['dscrptrMsrNm'];

			var headingGrid = heading;
			var dscrptrMsrNm = jsonForChooseDscrptrPg['dscrptrMsrNm'];
			if (headingSelCol != undefined && headingSelCol != 'undefined' && headingSelCol.length > 0) {
				headingGrid = headingSelCol;
			}
			for (var n in heading) {
				var eachCol = heading[n];
				var checkedField = false;
				var readOnlyField = false;
				if (headingGrid.includes(eachCol)) {
					checkedField = true;
				}
				if (eachCol == dscrptrMsrNm) {
					readOnlyField = true;
				}
				var citBxLable = eachCol;

				allColumnArray.push(
					{
						xtype: 'checkbox',
						cls: 'checkbt',
						boxLabel: citBxLable,
						name: eachCol,
						inputValue: eachCol,
						checked: checkedField,
						readOnly: readOnlyField,
						style: { 'overflow-x': 'hidden', 'white-space': 'nowrap', 'margin': '5px 5px 10px 10px' },
					}
				);
			}
			var gWindow = Ext.create('Ext.tip.ToolTip', {
				anchor: 'top',
				anchorToTarget: true,
				//anchorOffset: 470,
				target: 'callTooltip',
				scroll: false,
				layout: 'fit',
				autoHide: false,
				border: true,
				width: 540,
				padding:0,
				maxWidth: 540,
				bodyPadding:'10 0 0 0',
				height: 250,
				id: 'GenericWindowId',
				closeAction: 'destroy',
				closable: true,
				ui: 'newTooltipPopup',
				title: config.title.selctRqrdCols,
				header: {
					style: {
						'margin': '0 10 0 10',
						'padding':'10px',
					}
				},
				listeners: {
					hide: function () {
						if (!Ext.isEmpty(Ext.getCmp('GenericWindowId'))) {
						}
					},
					el: {
						'mouseenter': function () {
							if (!Ext.isEmpty(Ext.getCmp('GenericWindowId'))) {
								Ext.getCmp('GenericWindowId').show();
							}
						},
						'mouseleave': function () {
							if (!Ext.isEmpty(Ext.getCmp('GenericWindowId'))) {
							}
						}
					}
				},
				items: [
					{
						xtype: 'container',
						margin: 0,
						padding: 0,
						id: 'chkPanel',
						layout: {
							type: 'fit',
							align: 'left',
							pack: 'start'
						},
						items: [
							{
								xtype: 'panel',
								id: 'chekboxAllCol',
								scroll: false,
								autoScroll: true,
								layout: {
									type: 'fit',
									align: 'left',
									pack: 'start'
								},
								autoScroll: true,
								items: [
									{
										xtype: 'checkboxgroup',
										columns: 3,
										vertical: true,
										style:{
											'vertical-align':'top'
										},
										cls:'topAlign',
										labelAlign: 'right',
										id: 'multiColchkboxgroup',
										items: allColumnArray,
									}
								],
								dockedItems: [
									{
										xtype: 'toolbar',
										dock: 'bottom',
										height: 50,
										cls:'bottomToolbarBg',
										// style: {
										// 	'background-color': '#f5f5f5 !important'
										// },
										hidden: false,
										items: [
											'->',
											{
												xtype: 'button',
												text: config.labels.update,
												id: 'updateBtn',
												itemId: 'Update',
												margin: '0 0 0 0',
												padding: '5 10 5 10',
												ui: 'newButtonSmall',
												handler: function () {
													{
														var selectedCols = Ext.getCmp('multiColchkboxgroup').getChecked();
														var selColArry = new Array();
														Ext.each(selectedCols, function (obj, index) {
															selColArry.push(obj.getSubmitValue());
														});

														var fieldstoStore = jsonForChooseDscrptrPg['allMsrColumnNms'];

														Ext.getCmp('machinToolId').update('<div style="float:right;cursor:pointer"><img src="/final/images/spacer.gif" class="iconAddColumn" id="callTooltip" onclick="javascript:openChooseMeasuresWindow(\'' + selColArry + '\');" ></div>');
														me.loadChooseDescriptorGridData(selColArry);

														if (!Ext.isEmpty(Ext.getCmp('GenericWindowId'))) {
															Ext.getCmp('GenericWindowId').doClose();
														}
													}
												}
											}, '->']
									}
								]
							}
						]
					}
				]
			}).show();
		}
	},
	loadChooseDescriptorGridData: function (selectedCol)
	{
		var me = this;
		var fieldstoStore = selectedCol;
		var configStoreData = jsonForChooseDscrptrPg['dscrptrAndMsrVlus'];
		var dscrptrMsrNm = jsonForChooseDscrptrPg['dscrptrMsrNm'];
		var itemsPerPage = 12;
		
		if (!Ext.isEmpty(configStoreData)) {
			var store = new Ext.data.Store(
				{
					fields: fieldstoStore,
					proxy: {
						type: 'pagingmemory',
						enablePaging: true,
						reader: {
							type: 'json'
						}
					},
					pageSize: itemsPerPage,
					data: configStoreData
				});

			var colm = new Array();
			for(var incr=0; incr<fieldstoStore.length; incr++){
				var keys = fieldstoStore[incr];
				if (selectedCol.indexOf(keys) == -1) {
					continue;
				}
				if (keys == dscrptrMsrNm) {
					colm.push({
						header: keys,
						flex: 1,
						sortable: true,
						dataIndex: keys,
						renderer: function (value, metaData, record, row, col, store, gridView) {
							value = '<a href="javascript:void(0);"  class="anchorLinkBlue">' + value + '</a>';
							return value;
						}
					});
				} else {
					colm.push({
						header: keys,
						flex: 1,
						sortable: true,
						dataIndex: keys,
						renderer: function (value, metaData, record, row, col, store, gridView) {
							return value;
						}
					});
				}

			}

			var gridpanel;
			if(configStoreData.length > itemsPerPage)
			{
				gridpanel = Ext.create('Ext.grid.Panel', {
					ui: 'newGridPanel headerTextWrap bodyTextWrap',
					autoScroll: true,
					scroll: true,
					store: store,
					listeners:{
						cellclick:function( vt, td, cellIndex, record, tr, rowIndex, e, eOpts ){
							var clickedDataIndex = vt.panel.headerCt.getHeaderAtIndex(cellIndex).dataIndex;
							var clickedDscrptrVlu = record.get(clickedDataIndex);
							if(clickedDataIndex == jsonForChooseDscrptrPg['dscrptrMsrNm'])
							{
								for(var incr=0; incr<configStoreData.length; incr++)
								{
									if(clickedDscrptrVlu == configStoreData[incr][clickedDataIndex])
									{
										me.loadAddEditConditionsWindow(dscrptrMsrNm, clickedDscrptrVlu, configStoreData, configStoreData[incr]['allMsrColumnNmCds']);
										break;
									}
								}
							}
						}
					},
					 dockedItems: [
					 {
					 	xtype: 'pagingtoolbar',
					 	cls: 'newPagination2',
					 	 ui:'plain',
					 	id: 'paginationId',
					 	pageSize: itemsPerPage,
					 	style: { 'border-top': '0px solid transparent !important' },
					 	store: store,
					 	dock: 'bottom',
					 	displayInfo: true
					 }],
					columns: colm,
				});
			}
			else
			{
				gridpanel = Ext.create('Ext.grid.Panel', {
					ui: 'newGridPanel headerTextWrap bodyTextWrap',
					autoScroll: true,
					scroll: true,
					store: store,
					listeners:{
						cellclick:function( vt, td, cellIndex, record, tr, rowIndex, e, eOpts ){
							var clickedDataIndex = vt.panel.headerCt.getHeaderAtIndex(cellIndex).dataIndex;
							var clickedDscrptrVlu = record.get(clickedDataIndex);
							if(clickedDataIndex == jsonForChooseDscrptrPg['dscrptrMsrNm'])
							{
								for(var incr=0; incr<configStoreData.length; incr++)
								{
									if(clickedDscrptrVlu == configStoreData[incr][clickedDataIndex])
									{
										me.loadAddEditConditionsWindow(dscrptrMsrNm, clickedDscrptrVlu, configStoreData, configStoreData[incr]['allMsrColumnNmCds']);
										break;
									}
								}
							}
						}
					},
					columns: colm,
				});
			}
			Ext.getCmp('gridContainerId').removeAll();
			Ext.getCmp('gridContainerId').add(gridpanel);
			Ext.getCmp('homeIconId').show();
			Ext.getCmp('homeIconSeparator').show();
			Ext.getCmp('gridContainerId').doLayout();
		}
	},
	loadAddEditConditionsWindow: function(dscrptrMsrNm, dscrptr, allDscrptrMsrVlus, allMsrColNameCds)
	{
		var me=this;
		selectedDscrptrForCurOprtns = dscrptr;

		stringValueCndtnStore = [
			{"displayField":config.labels.EQ, "valueField":"EQ"},
			{"displayField":config.labels.notEQ, "valueField":"NOT EQ"},
			{"displayField":config.labels.SW, "valueField":"SW"},
			{"displayField":config.labels.notSW, "valueField":"NOT SW"},
			{"displayField":config.labels.EW, "valueField":"EW"},
			{"displayField":config.labels.notEW, "valueField":"NOT EW"},
			{"displayField":config.labels.LK, "valueField":"LK"},
			{"displayField":config.labels.notLK, "valueField":"NOT LK"},
			{"displayField":config.labels.AN, "valueField":"AN"}
		];

		stringNumberValueCndtnStore = [
			{"displayField":config.labels.EQ, "valueField":"EQ"},
			{"displayField":config.labels.notEQ, "valueField":"NOT EQ"},
			{"displayField":config.labels.LT, "valueField":"LT"},
			{"displayField":config.labels.notLT, "valueField":"NOT LT"},
			{"displayField":config.labels.LE, "valueField":"LE"},
			{"displayField":config.labels.notLE, "valueField":"NOT LE"},
			{"displayField":config.labels.GT, "valueField":"GT"},
			{"displayField":config.labels.notGT, "valueField":"NOT GT"},
			{"displayField":config.labels.GE, "valueField":"GE"},
			{"displayField":config.labels.notGE, "valueField":"NOT GE"},
			{"displayField":config.labels.SW, "valueField":"SW"},
			{"displayField":config.labels.notSW, "valueField":"NOT SW"},
			{"displayField":config.labels.EW, "valueField":"EW"},
			{"displayField":config.labels.notEW, "valueField":"NOT EW"},
			{"displayField":config.labels.LK, "valueField":"LK"},
			{"displayField":config.labels.notLK, "valueField":"NOT LK"},
			{"displayField":config.labels.AN, "valueField":"AN"}
		];

		listOfStringCndtnVlus = ["SW", "NOT SW", "EW", "NOT EW", "LK", "NOT LK", "AN"];

		listOfNumberCndtnVlus = ["LT", "NOT LT", "LE", "NOT LE", "GT", "NOT GT", "GE", "NOT GE"];

		

		var addEditWindow = Ext.create('Ext.window.Window', {
			ui: 'newPopupWindow',
			header:false,
			layout: 'fit',
			width: 1000,
			height: 520,
			border:false,
			ghost: false,
			modal:true,
			closable:false,
			disabledCls:'my-disabled-window',
			disabled :false,
			closeAction: 'destroy',
			id:'addEditConditionWindowId',
			padding:'15 20 10 20',

			items:[{
				xtype:'panel',
				ui:'newOuterPanelForWindow',
				title:isCnfgTstCdDscrptrBasedForCurOprtns ? (config.title.addMdfyCndtnsForDscrptr + " '" + dscrptr +"' " + config.title.addMdfyCndtnsForDscrptrInTst + " '" + selectedMngdCmpntTypForCurOprtns + '/' + selectedCnfgTstForCurOprtns + "' " + config.title.addMdfyCndtnsForDscrptrForTmplt + " '" + selectedTmpltNmForCurOprtns + "'") : (config.title.addMdfyCndtnsInTst + " '" + selectedMngdCmpntTypForCurOprtns + '/' + selectedCnfgTstForCurOprtns + "' " + config.title.addMdfyCndtnsForDscrptrForTmplt + " '" + selectedTmpltNmForCurOprtns + "'"),
				closable:true,
				border:false,
				viewConfig: {
					preserveScrollOnRefresh: true,
				},
				style:{'background':'transparent'},
				header:{
					style:{
						'padding':'0px 0px 10px 0px',
					}
				},
				layout:'fit',
				listeners:{
					'close':function(){
						var win = Ext.getCmp('addEditConditionWindowId');
						if(win)win[win.closeAction]();
						if(Ext.getCmp('toolsButId').curntExpndCollpsSts != null && Ext.getCmp('toolsButId').curntExpndCollpsSts == 'collapsed')
						{
							Ext.getCmp('templatedetailswindow').toggleWindowAnimation();
						}
					},
					'hide':function(){
						var win = Ext.getCmp('addEditConditionWindowId');
						if(win)win[win.closeAction]();
						if(Ext.getCmp('toolsButId').curntExpndCollpsSts != null && Ext.getCmp('toolsButId').curntExpndCollpsSts == 'collapsed')
						{
							Ext.getCmp('templatedetailswindow').toggleWindowAnimation();
						}
					}
				},
				dockedItems:[{
					xtype:'toolbar',
					dock:'bottom',
					ui:'plain',
					padding:'15 0 5 0',
					items:['->',{
						xtype:'button',
						ui:'newButtonSmall',
						padding:'5 10',
						text: config.labels.save,
						action:'save',
						id:'saveButtonId',
						handler:function(){
							me.saveTemplateCndtns(dscrptr);
						}
					},'->']
				}],
				items:[{
					xtype:'panel',
					margin:0,
					scroll:false,
					autoScroll:false,
					style:{
						'overflow-x':'visible',
						'overflow-y':'auto',
					},
					ui:'newFormPanelForWindow',
					id:'fieldContainerOuterPanel',
					layout: 'column',
					viewConfig: {
						preserveScrollOnRefresh: true
					},
					padding:20,
					items:[{
						xtype:'fieldcontainer',
						fieldLabel:config.labels.dscrptrCndtns,
						labelWidth:70,
						labelAlign:'left',
						margin:'0 0 10 0',
						id: 'descriptorCndtnsCntnrId',
						columnWidth:1,
						items:[
						{
							xtype:'container',
							cls:'newFormContainerConfigDesc',
							padding:'10 0 0 0',
							id:'addDescriptorForm',
						}]
					},{
						xtype:'fieldcontainer',
						fieldLabel:config.labels.msrCndtns,
						labelWidth:70,
						labelAlign:'left',
						id:'measureFormOuter',
						columnWidth:1,
						items:[]
					},{
						xtype:'container',
						id: 'addAddtnlMsrLnk',
						margin:'5 -6 10 0',
						columnWidth:1,
						layout:{
							type:'hbox',
							pack:'end',
						},
						items:[
							{
								xtype:'button',
								style:{
									'background':'none',
									'border':'1px',
								},
								cls:'newFont_normal11 lineOnHover',
								text: config.labels.addAddtnlMsr,
								handler:function()
								{
									me.measureFormOuterFunction(null, allMsrColNameCds);
								}
							}
						]
					}]
				}]
			}],
			listeners: {
				 show: function(win) {
					if (this.modal) {
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.addCls('windowModal');
						console.log("dom[1]: " + dom[1]);
						if(dom[1] != null)
						{
							el = Ext.fly(dom[1]);
							el.addCls('windowModal');
						}
					}
				 },
				  hide:  function(win) {
					 if (this.modal) {
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.removeCls('windowModal');
						console.log("dom[1]: " + dom[1]);
						if(dom[1] != null)
						{
							el = Ext.fly(dom[1]);
							el.removeCls('windowModal');
						}							
					}
				},
				close: function(b) {
					if (this.modal) {
						var c = Ext.dom.Query.select(".x-mask");
						var a = Ext.fly(c[0]);
						a.removeCls("windowModal");
						console.log("c[1]: " + c[1]);
						if(c[1] != null)
						{
							a = Ext.fly(c[1]);
							a.removeCls("windowModal");
						}							
					}
				},
				render:function(){
					if(!isCnfgTstCdDscrptrBasedForCurOprtns)
					{
						Ext.getCmp('descriptorCndtnsCntnrId').hide();
					}
				}
			}
		}).show();

		Ext.Ajax.request({
			url : config.urls.servletURL,
			params : {
				'cmd' : "Compliance_Templates",
				'reqfrom' : "getSavedConditionsForAddEdit",
				'pullData' : "true",
				'tmpltNm' : selectedTmpltNmForCurOprtns,
				'compTyp' : selectedMngdCmpntTypForCurOprtns,
				'testCode' : selectedCnfgTstCdForCurOprtns,
				'dscrptrCd' : filterEncode(selectedDscrptrForCurOprtns),
			},
			method : 'POST',
			async : false,
			success : function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var respJsonObj = Ext.decode( jsonText );

					if(respJsonObj['isCndtnsAlrdyExists'] == true) //non-partial status template
					{
						if(respJsonObj['isDscrptrBased'] == true)
						{
							if(respJsonObj['isDscrptrAvlbInTmplt'] == true)
							{
								isSelectedDscrptrAlrdyAvlblInTmplt = "true";
								for(var incr=0; incr<respJsonObj['dscrptrJsonObj']['descriptorEvlCondition'].length; incr++)
								{
									var rowIndex;
									if(incr==0)
									{
										me.descFormFields(respJsonObj['dscrptrJsonObj']['descriptorCode'], true);
										rowIndex = Ext.getCmp('addDescriptorForm').items.items[incr].index;
										var dataType = respJsonObj['dscrptrJsonObj']['dataType'];
										Ext.getCmp('descDataTypeId_'+rowIndex).setValue(dataType);
										Ext.getCmp('descCaseSensitiveId_'+rowIndex).setValue(""+respJsonObj['dscrptrJsonObj']['isCaseSensitive']);
										var notCndtn = respJsonObj['dscrptrJsonObj']['descriptorEvlCondition'][incr][0];
										if(notCndtn == 'NOT')
										{
											Ext.getCmp('descConditionId_'+rowIndex).setValue("NOT " + respJsonObj['dscrptrJsonObj']['descriptorEvlCondition'][incr][1]);
										}
										else
										{
											Ext.getCmp('descConditionId_'+rowIndex).setValue(respJsonObj['dscrptrJsonObj']['descriptorEvlCondition'][incr][1]);
										}
										Ext.getCmp('descTextValueId_'+rowIndex).setValue(respJsonObj['dscrptrJsonObj']['descriptorEvlCondition'][incr][2]);
										Ext.getCmp('descAndOrComboId_'+rowIndex).setValue(respJsonObj['dscrptrJsonObj']['descriptorEvlCondition'][incr][3]);
										if(respJsonObj['dscrptrJsonObj']['descriptorEvlCondition'].length == 1)
										{
											Ext.getCmp('descAndOrComboId_'+rowIndex).isLastRow = true;
										}
										else
										{
											Ext.getCmp('descAndOrComboId_'+rowIndex).isLastRow = false;
										}
									}
									else
									{
										me.descFormFields(respJsonObj['dscrptrJsonObj']['descriptorCode'], false);
										rowIndex = Ext.getCmp('addDescriptorForm').items.items[incr].index;
										var notCndtn = respJsonObj['dscrptrJsonObj']['descriptorEvlCondition'][incr][0];
										if(notCndtn == 'NOT')
										{
											Ext.getCmp('descConditionId_'+rowIndex).setValue("NOT " + respJsonObj['dscrptrJsonObj']['descriptorEvlCondition'][incr][1]);
										}
										else
										{
											Ext.getCmp('descConditionId_'+rowIndex).setValue(respJsonObj['dscrptrJsonObj']['descriptorEvlCondition'][incr][1]);
										}
										Ext.getCmp('descTextValueId_'+rowIndex).setValue(respJsonObj['dscrptrJsonObj']['descriptorEvlCondition'][incr][2]);
										Ext.getCmp('descAndOrComboId_'+rowIndex).setValue(respJsonObj['dscrptrJsonObj']['descriptorEvlCondition'][incr][3]);
										if(incr==respJsonObj['dscrptrJsonObj']['descriptorEvlCondition'].length-1)
										{
											Ext.getCmp('descAndOrComboId_'+rowIndex).isLastRow = true;
										}
										else
										{
											Ext.getCmp('descAndOrComboId_'+rowIndex).isLastRow = false;
										}
									}
									index++;
								}
								var noOfMsrs = respJsonObj['msrCndtnsJsonObj'].length;
								for(var incr=0; incr<noOfMsrs; incr++)
								{
									var curMsr = respJsonObj['msrCndtnsJsonObj'][incr];
									me.measureFormOuterFunction(curMsr, allMsrColNameCds);
								}
							}
							else
							{
								isSelectedDscrptrAlrdyAvlblInTmplt = "false";
								me.descFormFields(dscrptr, true);
								me.measureFormOuterFunction(null, allMsrColNameCds);
							}
						}
						else
						{
							if(respJsonObj['isMsrCndtnsAlrAvlbInTmplt'] == true)
							{
								var noOfMsrs = respJsonObj['msrCndtnsJsonObj'].length;
								for(var incr=0; incr<noOfMsrs; incr++)
								{
									var curMsr = respJsonObj['msrCndtnsJsonObj'][incr];
									me.measureFormOuterFunction(curMsr, allMsrColNameCds);
								}
							}
							else
							{
								me.measureFormOuterFunction(null, allMsrColNameCds);
							}
						}
					}
					else //partial status template
					{
						me.descFormFields(dscrptr, true);
						me.measureFormOuterFunction(null, allMsrColNameCds);
					}
				}
			}
		});
	},
	descFormFields:function(dscrptr, showLabel)
	{
		var me = this;
		var dscrptrCndtnOptions;
		var dscrptrDataType;
		if(isNaN(dscrptr))
		{
			dscrptrCndtnOptions = stringValueCndtnStore;
			dscrptrDataType = "String";
		}
		else
		{
			dscrptrCndtnOptions = stringNumberValueCndtnStore;
			dscrptrDataType = "Number";
		}

		var descFields = {
			xtype:'container',
			id:'descFieldsId_'+index,
			index:index,
			layout:'hbox',
			flex:1,
			defaults:{
				labelAlign:'top',
				labelSeparator:'',
				margin:'0 8 10 0',
			},
			items:[
				{
					xtype : 'hiddenfield',
					id : 'descDataTypeId_'+index,
					value : dscrptrDataType,
				},{
					xtype: 'combo',
					fieldLabel: showLabel ? config.labels.condition :'',
					cls: 'dropdown',
					id:'descConditionId_'+index,
					width:90,
					matchFieldWidth:false,
					emptyText: config.labels.select,
					store : new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: dscrptrCndtnOptions,
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
				},{
					xtype:'textfield',
					cls:'textbox',
					fieldLabel: showLabel ? config.labels.expctdDscrptrVlu :'',
					id:'descTextValueId_'+index,
					flex:1,
					emptyText: config.labels.expctdDscrptrVluForTxtFld,
					value: dscrptr,
				},{
					xtype: 'combo',
					fieldLabel: showLabel ? config.labels.isCaseSnstv :'',
					cls: 'dropdown',
					id:'descCaseSensitiveId_'+index,
					width:110,
					hidden:!showLabel,
					emptyText: config.labels.select,
					store : new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: [
								{'displayField':config.labels.yes, 'valueField':'true'},
								{'displayField':config.labels.no, 'valueField':'false'}
							]
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
				},{
					xtype:'container',
					width:110,
					hidden:showLabel,
					id:'dummyContForDscrptrCaseSens_'+index,
					hidden:showLabel,
				},{
					xtype: 'combo',
					fieldLabel: showLabel ? config.labels.andOr :'',
					cls: 'dropdown',
					id:'descAndOrComboId_'+index,
					width:55,
					margin:'0 5 10 0',
					emptyText: config.labels.select,
					store : new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: [
								{'displayField':config.labels.and, 'valueField':'AND'},
								{'displayField':config.labels.or, 'valueField':'OR'}
							]
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
					isLastRow:true,
					listeners:{
						select:function(obj){
							if(obj.isLastRow){
								obj.isLastRow = false;
								index++;
								me.descFormFields(dscrptr, false);

								var slctdDscrtrDataTyp = Ext.getCmp('addDescriptorForm').items.items[0].items.items[0].value;
							}
						}
					},
				},{
					xtype: 'button',
					iconCls:'iconRemoveItems',
					width:20,
					height:20,
					index:index,
					id:'descRemoveId_'+index,
					margin:showLabel ? '20 2 0 0' : '0 2 0 0',
					style:{
						'background':'transparent',
						'border':'none'
					},
					handler:function(){

						var totalItems = Ext.getCmp('addDescriptorForm').items;
						if(totalItems==1)
						{
							return;
						}
						var perviousIndex = '';
						var secondIndex = '';
						var isFirstRow = false;

						for(var i=0;i<totalItems.length;i++)
						{
							var currentIndex = totalItems.items[i].index;
							if(i==1)
							{
								secondIndex = currentIndex;
							}
							if(currentIndex==this.index && i==0)
							{
								isFirstRow = true;
							}
							if(currentIndex==this.index && i==totalItems.length-1)
							{
								Ext.getCmp('descAndOrComboId_'+perviousIndex).setValue('');
								Ext.getCmp('descAndOrComboId_'+perviousIndex).isLastRow = true;
							}
							perviousIndex = totalItems.items[i].index;
						}
						if(isFirstRow)
						{
							Ext.getCmp('descCaseSensitiveId_'+secondIndex).setFieldLabel(config.labels.isCaseSnstv);
							Ext.getCmp('descConditionId_'+secondIndex).setFieldLabel(config.labels.condition);
							Ext.getCmp('descTextValueId_'+secondIndex).setFieldLabel(config.labels.expctdDscrptrVlu);
							Ext.getCmp('descAndOrComboId_'+secondIndex).setFieldLabel(config.labels.andOr);
							Ext.getCmp('descRemoveId_'+secondIndex).addCls('RemoveButtonMargin');
							Ext.getCmp('descCaseSensitiveId_'+secondIndex).setValue(Ext.getCmp('descCaseSensitiveId_'+totalItems.items[0].index).getValue());
							Ext.getCmp('descCaseSensitiveId_'+secondIndex).show();
							Ext.getCmp('dummyContForDscrptrCaseSens_'+secondIndex).hide();
						}
						Ext.getCmp('addDescriptorForm').remove('descFieldsId_'+this.index);

						if(Ext.getCmp('addDescriptorForm').items.length == 1)
						{
							Ext.getCmp('descRemoveId_'+Ext.getCmp('addDescriptorForm').items.items[0].index).disable();
						}
						else
						{
							Ext.getCmp('descRemoveId_'+Ext.getCmp('addDescriptorForm').items.items[0].index).enable();
						}

					}
				}]
		}
		Ext.getCmp('addDescriptorForm').add(descFields);

		var dscrptrFirstRowIndex = Ext.getCmp('addDescriptorForm').items.items[0].index;
		if(Ext.getCmp('descDataTypeId_' + dscrptrFirstRowIndex).getValue() == "String")
		{
			Ext.getCmp('descCaseSensitiveId_' + dscrptrFirstRowIndex).enable();
		}
		else if(Ext.getCmp('descDataTypeId_' + dscrptrFirstRowIndex).getValue() == "Number")
		{
			Ext.getCmp('descCaseSensitiveId_' + dscrptrFirstRowIndex).setValue('false');
			Ext.getCmp('descCaseSensitiveId_' + dscrptrFirstRowIndex).disable();
		}

		if(Ext.getCmp('addDescriptorForm').items.length == 1)
		{
			Ext.getCmp('descRemoveId_'+Ext.getCmp('addDescriptorForm').items.items[0].index).disable();
		}
		else
		{
			Ext.getCmp('descRemoveId_'+Ext.getCmp('addDescriptorForm').items.items[0].index).enable();
		}
	},
	measureFormFields:function(showLabel,panelId, allMsrColNameCds)
	{
		var me = this;

		expectedUnitsStore = [
								{'displayField': config.labels.NotApplicable, 'valueField':'-'},
								{'displayField': config.labels.Bit, 'valueField':'BIT'},
								{'displayField': config.labels.Kilobit, 'valueField':'KBIT'},
								{'displayField': config.labels.Megabit, 'valueField':'MBIT'},
								{'displayField': config.labels.Gigabit, 'valueField':'GBIT'},
								{'displayField': config.labels.Terabit, 'valueField':'TBIT'},
								{'displayField': config.labels.Petabit, 'valueField':'PBIT'},
								{'displayField': config.labels.Bytes, 'valueField':'BYTES'},
								{'displayField': config.labels.Kilobytes, 'valueField':'KB'},
								{'displayField': config.labels.Megabytes, 'valueField':'MB'},
								{'displayField': config.labels.Gigabytes, 'valueField':'GB'},
								{'displayField': config.labels.Terabytes, 'valueField':'TB'},
								{'displayField': config.labels.Petabytes, 'valueField':'PB'},
								{'displayField': config.labels.Nanoseconds, 'valueField':'NANOSECONDS'},
								{'displayField': config.labels.Microseconds, 'valueField':'MICROSECONDS'},
								{'displayField': config.labels.Milliseconds, 'valueField':'MILLISECONDS'},
								{'displayField': config.labels.Seconds, 'valueField':'SECONDS'},
								{'displayField': config.labels.Minutes, 'valueField':'MINUTES'},
								{'displayField': config.labels.Hours, 'valueField':'HOURS'},
								{'displayField': config.labels.Days, 'valueField':'DAYS'},
								{'displayField': config.labels.Weeks, 'valueField':'WEEKS'},
								{'displayField': config.labels.Months, 'valueField':'MONTHS'},
								{'displayField': config.labels.Years, 'valueField':'YEARS'},
								{'displayField': config.labels.BitsPerSec, 'valueField':'BIT/SEC'},
								{'displayField': config.labels.BytesPerSec, 'valueField':'BYTE/SEC'},
								{'displayField': config.labels.KilobitsPerSec, 'valueField':'KBIT/SEC'},
								{'displayField': config.labels.KbPerSec, 'valueField':'KB/SEC'},
								{'displayField': config.labels.MegabitsPerSec, 'valueField':'MBIT/SEC'},
								{'displayField': config.labels.MbPerSec, 'valueField':'MB/SEC'},
								{'displayField': config.labels.GigabitsPerSec, 'valueField':'GBIT/SEC'},
								{'displayField': config.labels.GbPerSec, 'valueField':'GB/SEC'},
								{'displayField': config.labels.TerabitsPerSec, 'valueField':'TBIT/SEC'},
								{'displayField': config.labels.TbPerSec, 'valueField':'TB/SEC'},
								{'displayField': config.labels.PetabitsPerSec, 'valueField':'PBIT/SEC'},
								{'displayField': config.labels.PbPerSec, 'valueField':'PB/SEC'},
								{'displayField': config.labels.Hertz, 'valueField':'HERTZ'},
								{'displayField': config.labels.Kilohertz, 'valueField':'KILOHERTZ'},
								{'displayField': config.labels.Megahertz, 'valueField':'MEGAHERTZ'},
								{'displayField': config.labels.Gigahertz, 'valueField':'GIGAHERTZ'},
							];

		var measureFields = {
			xtype:'container',
			id:'measureFieldsId_'+indexMeasure,
			layout:'hbox',
			border:true,
			indexMeasure:indexMeasure,
			padding:'0 0 5 10',
			flex:1,
			defaults:{
				labelAlign:'top',
				labelSeparator:'',
				margin:'0 8 5 0',
			},
			items:[
				{
					xtype: 'scrollcombo',
					fieldLabel: showLabel ? config.labels.msrNm :'',
					cls: 'dropdown',
					id:'measureName_'+indexMeasure,
					width:110,
					matchFieldWidth:false,
					hidden:!showLabel,
					emptyText: config.labels.select,
					store : new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: allMsrColNameCds,
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
					curCnfgVlu : '',
					unit : '',
					prevMsrNmVlu : '',
					listeners:{
						select:function(obj){
							if( (obj.prevMsrNmVlu != '') && (obj.prevMsrNmVlu != obj.value) )
							{
								Ext.Msg.confirm("&nbsp;", "All the measure condition values will be reset. Please confirm to proceed.", function(btnText)
								{
									if(btnText == "yes")
									{
										obj.prevMsrNmVlu = obj.value;
										var noOfMsrCndtns = Ext.getCmp(panelId).items.length;
										for(var incr=noOfMsrCndtns-1; incr>0; incr--)
										{
											var curMsrCndtRowIndex = Ext.getCmp(panelId).items.items[incr].indexMeasure;
											Ext.getCmp(panelId).remove('measureFieldsId_'+curMsrCndtRowIndex);
										}
										me.populateMeasureFields(obj, allMsrColNameCds);
									}
									else
									{
										Ext.getCmp(obj.id).setValue(obj.prevMsrNmVlu);
									}
								}, this);
							}
							else
							{
								obj.prevMsrNmVlu = obj.value;
								me.populateMeasureFields(obj, allMsrColNameCds);
							}
						}
					},
				},{
					xtype:'container',
					width:110,
					id:'dummyContForMsrNm_'+indexMeasure,
					hidden:showLabel,
				},{
					xtype : 'hiddenfield',
					id : 'measureDataTypeId_'+indexMeasure,
				},{
					xtype: 'combo',
					fieldLabel: showLabel ? config.labels.condition :'',
					cls: 'dropdown',
					id:'measureConditionId_'+indexMeasure,
					width:90,
					matchFieldWidth:false,
					emptyText: config.labels.select,
					store : new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: [],
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
				},{
					xtype:'textfield',
					cls:'textbox',
					fieldLabel: showLabel ? config.labels.expctdMsrVlu :'',
					id:'measureTextValueId_'+indexMeasure,
					emptyText: config.labels.expctdMsrVluForTxtFld,
					flex:1,
				},{
					xtype: 'combo',
					fieldLabel: showLabel ? config.labels.isCaseSnstv :'',
					cls: 'dropdown',
					id:'measureCaseSensitiveId_'+indexMeasure,
					width:110,
					emptyText: config.labels.select,
					hidden:!showLabel,
					store : new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: [
								{'displayField':config.labels.yes, 'valueField':'true'},
								{'displayField':config.labels.no, 'valueField':'false'}
							]
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
				},{
					xtype:'container',
					width:110,
					id:'dummyContForMsrCaseSens_'+indexMeasure,
					hidden:showLabel,
				},{
					xtype: 'combo',
					fieldLabel: showLabel ? config.labels.expctdUnit :'',
					cls: 'dropdown',
					id:'measureExpectedUnitId_'+indexMeasure,
					width:110,
					hidden:!showLabel,
					emptyText: config.labels.expctdUnitForTxtFld,
					store : new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: expectedUnitsStore,
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
				},{
					xtype:'container',
					width:110,
					id:'dummyContForExpectedUnitId_'+indexMeasure,
					hidden:showLabel,
				},{
					xtype: 'combo',
					fieldLabel: showLabel ? config.labels.andOr:'',
					cls: 'dropdown',
					id:'measureAndOrComboId_'+indexMeasure,
					width:55,
					margin:'0 5 5 0',
					emptyText: config.labels.select,
					store : new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: [
								{'displayField':config.labels.and, 'valueField':'AND'},
								{'displayField':config.labels.or, 'valueField':'OR'}
							]
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
					panelId:panelId,
					isLastRow:true,
					listeners:{
						select:function(obj){
							if(obj.isLastRow){
								obj.isLastRow = false;
								me.measureFormFields(false, this.panelId, allMsrColNameCds);
								var slctdMsrDataTyp = Ext.getCmp(this.panelId).items.items[0].items.items[2].value;

								for(var incr=0; incr<allMsrColNameCds.length; incr++)
								{
									if(allMsrColNameCds[incr]['valueField']==Ext.getCmp(this.panelId).items.items[0].items.items[0].getValue())
									{
										if(isNaN(allMsrColNameCds[incr]['curCnfgVlu']))
										{
											Ext.getCmp('measureConditionId_'+(indexMeasure-1)).getStore().loadRawData(stringValueCndtnStore);
											Ext.getCmp('measureDataTypeId_'+(indexMeasure-1)).setValue("String");
										}
										else
										{
											Ext.getCmp('measureConditionId_'+(indexMeasure-1)).getStore().loadRawData(stringNumberValueCndtnStore);
											Ext.getCmp('measureDataTypeId_'+(indexMeasure-1)).setValue("Number");
										}
										Ext.getCmp('measureTextValueId_'+(indexMeasure-1)).setValue(allMsrColNameCds[incr]['curCnfgVlu']);
										break;
									}
								}
							}
						}
					},
				},{
					xtype: 'button',
					iconCls:'iconRemoveItems',
					width:20,
					height:20,
					indexMeasure:indexMeasure,
					id:'measureRemoveId_'+indexMeasure,
					margin:showLabel ? '20 2 0 0' : '0 2 0 0',
					panelId:panelId,
					style:{
						'background':'transparent',
						'border':'none'
					},
					handler:function(){
						var totalItems = Ext.getCmp(this.panelId).items;
						if(totalItems==1)
						{
							return;
						}
						var perviousIndex = '';
						var secondIndex = '';
						var isFirstRow = false;
						var currentMsrNm = Ext.getCmp('measureName_'+totalItems.items[0].indexMeasure).getValue();
						var currentMsrDataTyp = Ext.getCmp('measureDataTypeId_'+totalItems.items[0].indexMeasure).getValue();
						var currentMsrCaseSnstv = Ext.getCmp('measureCaseSensitiveId_'+totalItems.items[0].indexMeasure).getValue();
						var currentMsrExpctdUnt = Ext.getCmp('measureExpectedUnitId_'+totalItems.items[0].indexMeasure).getValue();
						for(var i=0;i<totalItems.length;i++)
						{
							var currentIndex = totalItems.items[i].indexMeasure;
							if(i==1)
							{
								secondIndex = currentIndex;
							}
							if(currentIndex==this.indexMeasure && i==0)
							{
								isFirstRow = true;
							}
							if(currentIndex==this.indexMeasure && i==totalItems.length-1)
							{
								if( (Ext.getCmp('measureAndOrComboId_'+perviousIndex) != null) && (Ext.getCmp('measureAndOrComboId_'+perviousIndex) != 'undefined') && (Ext.getCmp('measureAndOrComboId_'+perviousIndex) != undefined))
								{
									Ext.getCmp('measureAndOrComboId_'+perviousIndex).setValue('');
									Ext.getCmp('measureAndOrComboId_'+perviousIndex).isLastRow = true;
								}
							}
							perviousIndex = totalItems.items[i].indexMeasure;
						}
						if(isFirstRow)
						{
							Ext.getCmp('measureName_'+secondIndex).setFieldLabel(config.labels.msrNm);
							Ext.getCmp('measureCaseSensitiveId_'+secondIndex).setFieldLabel(config.labels.isCaseSnstv);
							Ext.getCmp('measureConditionId_'+secondIndex).setFieldLabel(config.labels.condition);
							Ext.getCmp('measureTextValueId_'+secondIndex).setFieldLabel(config.labels.expctdMsrVlu);
							Ext.getCmp('measureExpectedUnitId_'+secondIndex).setFieldLabel(config.labels.expctdUnit);
							Ext.getCmp('measureAndOrComboId_'+secondIndex).setFieldLabel(config.labels.andOr);
							Ext.getCmp('measureName_'+secondIndex).show();
							Ext.getCmp('measureName_'+secondIndex).setValue(currentMsrNm);
							Ext.getCmp('measureDataTypeId_'+secondIndex).setValue(currentMsrDataTyp);
							Ext.getCmp('measureCaseSensitiveId_'+secondIndex).setValue(currentMsrCaseSnstv);
							Ext.getCmp('measureCaseSensitiveId_'+secondIndex).show();
							Ext.getCmp('measureExpectedUnitId_'+secondIndex).setValue(currentMsrExpctdUnt);
							Ext.getCmp('measureExpectedUnitId_'+secondIndex).show();
							Ext.getCmp('dummyContForMsrNm_'+secondIndex).hide();
							Ext.getCmp('dummyContForMsrCaseSens_'+secondIndex).hide();
							Ext.getCmp('dummyContForExpectedUnitId_'+secondIndex).hide();
							Ext.getCmp('measureRemoveId_'+secondIndex).addCls('RemoveButtonMargin');
							if(currentMsrDataTyp == "String")
							{
								Ext.getCmp('measureCaseSensitiveId_' + secondIndex).enable();
								Ext.getCmp('measureExpectedUnitId_' + secondIndex).disable();
							}
							else if(currentMsrDataTyp == "Number")
							{
								Ext.getCmp('measureCaseSensitiveId_' + secondIndex).setValue('false');
								Ext.getCmp('measureCaseSensitiveId_' + secondIndex).disable();
								Ext.getCmp('measureExpectedUnitId_' + secondIndex).enable();
							}
						}
						Ext.getCmp(this.panelId).remove('measureFieldsId_'+this.indexMeasure);
						if(Ext.getCmp(panelId).items.length == 1)
						{
							Ext.getCmp('measureRemoveId_'+Ext.getCmp(panelId).items.items[0].indexMeasure).disable();
						}
						else
						{
							Ext.getCmp('measureRemoveId_'+Ext.getCmp(panelId).items.items[0].indexMeasure).enable();
						}
					}
				}]
		}
		Ext.getCmp(panelId).add(measureFields);

		var noOfMeasures = Ext.getCmp('measureFormOuter').items.length;
		for(var incr=0; incr<noOfMeasures; incr++)
		{
			var curRowMsrIndex = Ext.getCmp('measureFormOuter').items.items[incr].items.items[0].indexMeasure;
			if(Ext.getCmp('measureDataTypeId_' + curRowMsrIndex).getValue() == "String")
			{
				Ext.getCmp('measureCaseSensitiveId_' + curRowMsrIndex).enable();
				Ext.getCmp('measureExpectedUnitId_' + curRowMsrIndex).disable();
			}
			else if(Ext.getCmp('measureDataTypeId_' + curRowMsrIndex).getValue() == "Number")
			{
				Ext.getCmp('measureCaseSensitiveId_' + curRowMsrIndex).setValue('false');
				Ext.getCmp('measureCaseSensitiveId_' + curRowMsrIndex).disable();
				Ext.getCmp('measureExpectedUnitId_' + curRowMsrIndex).enable();
			}
		}

		if(Ext.getCmp(panelId).items.length == 1)
		{
			Ext.getCmp('measureRemoveId_'+Ext.getCmp(panelId).items.items[0].indexMeasure).disable();
		}
		else
		{
			Ext.getCmp('measureRemoveId_'+Ext.getCmp(panelId).items.items[0].indexMeasure).enable();
		}
		indexMeasure = indexMeasure+1;
	},
	populateMeasureFields:function(obj, allMsrColNameCds)
	{
		var indexMeasure = obj.id.substring(12);

		for(var incr=0; incr<allMsrColNameCds.length; incr++)
		{
			if(allMsrColNameCds[incr]['valueField']==obj.value)
			{
				if(allMsrColNameCds[incr]['curCnfgVlu'] != null)
				{
					obj.curCnfgVlu = allMsrColNameCds[incr]['curCnfgVlu'];
					obj.unit = allMsrColNameCds[incr]['unit'];
					break;
				}
			}
		}

		var msrCndtnOptions;
		var msrDataType;
		if(isNaN(obj.curCnfgVlu))
		{
			msrCndtnOptions = stringValueCndtnStore;
			msrDataType = "String";
		}
		else
		{
			msrCndtnOptions = stringNumberValueCndtnStore;
			msrDataType = "Number";
		}

		Ext.getCmp('measureTextValueId_'+indexMeasure).setValue(obj.curCnfgVlu);
		Ext.getCmp('measureExpectedUnitId_'+indexMeasure).setValue(obj.unit);
		Ext.getCmp('measureConditionId_'+indexMeasure).getStore().loadRawData(msrCndtnOptions);;
		Ext.getCmp('measureConditionId_'+indexMeasure).setValue(null);
		Ext.getCmp('measureDataTypeId_'+indexMeasure).setValue(msrDataType);

		if(msrDataType == "String")
		{
			Ext.getCmp('measureCaseSensitiveId_' + indexMeasure).enable();
			Ext.getCmp('measureCaseSensitiveId_' + indexMeasure).setValue(null);

			Ext.getCmp('measureExpectedUnitId_' + indexMeasure).disable();
			Ext.getCmp('measureExpectedUnitId_' + indexMeasure).setValue('-');
		}
		else if(msrDataType == "Number")
		{
			Ext.getCmp('measureCaseSensitiveId_' + indexMeasure).disable();
			Ext.getCmp('measureCaseSensitiveId_' + indexMeasure).setValue('false');

			Ext.getCmp('measureExpectedUnitId_' + indexMeasure).enable();
			if( (Ext.getCmp('measureExpectedUnitId_' + indexMeasure).getValue() == null) )
			{
				Ext.getCmp('measureExpectedUnitId_' + indexMeasure).setValue('-');
			}
		}

		Ext.getCmp('measureAndOrComboId_'+indexMeasure).setValue(null);
		Ext.getCmp('measureAndOrComboId_'+indexMeasure).isLastRow=true;
	},
	measureFormOuterFunction:function(curMsr, allMsrColNameCds)
	{
		var me = this;
		var measureFormOuterObj =
		{
			xtype:'container',
			cls:'newFormContainerConfig',
			style:{'position':'relative'},
			panelIndex:panelIndex,
			padding:'10 0 0 0',
			id:'addMeasureForm_'+panelIndex,
			html:'<div class="removeMeasureButton newFont_normal11" id="addMeasureForm_'+panelIndex+'_remove" data-qtip=' + config.labels.removeMsr + '><div class="iconCloseWidget" style="margin:9px 2px;"></div></div>',
			listeners:
			{
				afterrender:function(cmp)
				{
					if(!Ext.isEmpty(Ext.get(cmp.id+'_remove'))){
						Ext.get(cmp.id+'_remove').on('click', function(){
							Ext.destroy(Ext.getCmp(cmp.id))
						});
					}
					cmp.getEl().on('mouseenter',function(){
						if(!Ext.isEmpty(Ext.get(cmp.id+'_remove'))){
							if(Ext.getCmp('measureFormOuter').items.length>1)
								Ext.get(cmp.id+'_remove').show();
						}
					}).on('mouseleave',function(){
							if(!Ext.isEmpty(Ext.get(cmp.id+'_remove'))){
								Ext.get(cmp.id+'_remove').hide();
							}
					})
					Ext.getCmp('addMeasureForm_'+panelIndex).doLayout();
				}
			},
		}
		Ext.getCmp('measureFormOuter').add(measureFormOuterObj);

		if(curMsr != null)
		{
			for(var incr=0; incr<curMsr['msrEvlCondition'].length; incr++)
			{
				var rowIndex;
				if(incr==0)
				{
					this.measureFormFields(true,'addMeasureForm_'+panelIndex, allMsrColNameCds);
					rowIndex = Ext.getCmp('addMeasureForm_'+panelIndex).items.items[incr].indexMeasure;
					Ext.getCmp('measureName_'+rowIndex).setValue(curMsr['measureName']);
					Ext.getCmp('measureDataTypeId_'+rowIndex).setValue(curMsr['dataType']);
					Ext.getCmp('measureCaseSensitiveId_'+rowIndex).setValue(""+curMsr['isCaseSensitive']);
					Ext.getCmp('measureExpectedUnitId_'+rowIndex).setValue(curMsr['expectedUnit']);

					Ext.getCmp('measureName_'+rowIndex)['prevMsrNmVlu']=curMsr['measureName']; 

					if(curMsr['dataType'] == "String")
					{
						Ext.getCmp('measureCaseSensitiveId_' + rowIndex).enable();

						Ext.getCmp('measureExpectedUnitId_' + rowIndex).disable();
						Ext.getCmp('measureExpectedUnitId_' + rowIndex).setValue('-');

						Ext.getCmp('measureConditionId_'+rowIndex).getStore().loadRawData(stringValueCndtnStore);
					}
					else if(curMsr['dataType'] == "Number")
					{
						Ext.getCmp('measureCaseSensitiveId_' + rowIndex).disable();
						Ext.getCmp('measureCaseSensitiveId_' + rowIndex).setValue('false');

						Ext.getCmp('measureExpectedUnitId_' + rowIndex).enable();

						Ext.getCmp('measureConditionId_'+rowIndex).getStore().loadRawData(stringNumberValueCndtnStore);
					}
				}
				else
				{
					this.measureFormFields(false,'addMeasureForm_'+panelIndex, allMsrColNameCds);
					rowIndex = Ext.getCmp('addMeasureForm_'+panelIndex).items.items[incr].indexMeasure;

					if(curMsr['dataType'] == "String")
					{
						Ext.getCmp('measureConditionId_'+rowIndex).getStore().loadRawData(stringValueCndtnStore);
					}
					else if(curMsr['dataType'] == "Number")
					{
						Ext.getCmp('measureConditionId_'+rowIndex).getStore().loadRawData(stringNumberValueCndtnStore);
					}
				}

				if(curMsr['msrEvlCondition'][incr][0]=='NOT')
				{
					Ext.getCmp('measureConditionId_'+rowIndex).setValue('NOT ' + curMsr['msrEvlCondition'][incr][1]);
				}
				else
				{
					Ext.getCmp('measureConditionId_'+rowIndex).setValue(curMsr['msrEvlCondition'][incr][1]);
				}

				Ext.getCmp('measureTextValueId_'+rowIndex).setValue(curMsr['msrEvlCondition'][incr][2]); 
				Ext.getCmp('measureAndOrComboId_'+rowIndex).setValue(curMsr['msrEvlCondition'][incr][3]);
				if(incr == curMsr['msrEvlCondition'].length-1)
				{
					Ext.getCmp('measureAndOrComboId_'+rowIndex).isLastRow = true;
				}
				else
				{
					Ext.getCmp('measureAndOrComboId_'+rowIndex).isLastRow = false;
				}
			}
			panelIndex=panelIndex+1;

			Ext.getCmp('saveButtonId').setText(config.labels.update);
		}
		else
		{
			this.measureFormFields(true,'addMeasureForm_'+panelIndex, allMsrColNameCds);
			panelIndex=panelIndex+1;
			if(Ext.getCmp('saveButtonId').getText() != config.labels.update)
			{
				Ext.getCmp('saveButtonId').setText(config.labels.save);
			}
		}
	},
	saveTemplateCndtns : function(dscrptr)
	{
		var dscrptrCndtnObj = null;
		if(dscrptr != null)
		{
			selectedDscrptrForCurOprtns = dscrptr;
			dscrptrCndtnObj = new Object();
			var dscrptrCndtnEndPartObj = new Array();

			var noOfDscrptrCndnRow = Ext.getCmp('addDescriptorForm').items.length;

			for(var incr=0; incr<noOfDscrptrCndnRow; incr++)
			{
				var curDscrptrRowIndex = Ext.getCmp('addDescriptorForm').items.items[incr].index;
				if(incr == 0)
				{
					dscrptrCndtnObj.descCode = filterEncode(dscrptr);
					dscrptrCndtnObj.descDataTypeId = Ext.getCmp('descDataTypeId_'+curDscrptrRowIndex).getValue();
					dscrptrCndtnObj.descCaseSensitiveId = Ext.getCmp('descCaseSensitiveId_'+curDscrptrRowIndex).getValue();
				}

				var dscrptrCndtnEndPartArrObj;
				if(Ext.getCmp('descConditionId_'+curDscrptrRowIndex).getValue() != null && Ext.getCmp('descConditionId_'+curDscrptrRowIndex).getValue() != '')
				{
					if(Ext.getCmp('descConditionId_'+curDscrptrRowIndex).getValue().startsWith("NOT"))
					{
						dscrptrCndtnEndPartArrObj = ["NOT", Ext.getCmp('descConditionId_'+curDscrptrRowIndex).getValue().replace("NOT ", ""), filterEncode(Ext.getCmp('descTextValueId_'+curDscrptrRowIndex).getValue()), Ext.getCmp('descAndOrComboId_'+curDscrptrRowIndex).getValue()];
					}
					else
					{
						dscrptrCndtnEndPartArrObj = ["", Ext.getCmp('descConditionId_'+curDscrptrRowIndex).getValue(), filterEncode(Ext.getCmp('descTextValueId_'+curDscrptrRowIndex).getValue()), Ext.getCmp('descAndOrComboId_'+curDscrptrRowIndex).getValue()];
					}
				}

				dscrptrCndtnEndPartObj.push(dscrptrCndtnEndPartArrObj);
			}
			dscrptrCndtnObj.endCndtn = dscrptrCndtnEndPartObj;
		}

		var noOfMeasures = Ext.getCmp('measureFormOuter').items.length;

		var allMsrCndtnsObj = new Array();
		for(var incr=0; incr<noOfMeasures; incr++)
		{
			var eachMsrCndtnObj = new Object();
			var eachMsrEndPartObj = new Array();

			var noOfMsrRowCndtn = Ext.getCmp('measureFormOuter').items.items[incr].items.items.length;
			for(var incr1=0; incr1<noOfMsrRowCndtn; incr1++)
			{
				var curRowMsrIndex = Ext.getCmp('measureFormOuter').items.items[incr].items.items[incr1].indexMeasure;
				if(incr1 == 0)
				{
					eachMsrCndtnObj.measureName = Ext.getCmp('measureName_'+curRowMsrIndex).getValue();
					eachMsrCndtnObj.measureDataTypeId = Ext.getCmp('measureDataTypeId_'+curRowMsrIndex).getValue();
					eachMsrCndtnObj.measureCaseSensitiveId = Ext.getCmp('measureCaseSensitiveId_'+curRowMsrIndex).getValue();
					eachMsrCndtnObj.measureExpectedUnitId = Ext.getCmp('measureExpectedUnitId_'+curRowMsrIndex).getValue();
				}

				var eachMsrEndPartArrObj;
				if(Ext.getCmp('measureConditionId_'+curRowMsrIndex).getValue() != null && Ext.getCmp('measureConditionId_'+curRowMsrIndex).getValue() != '')
				{
					if(Ext.getCmp('measureConditionId_'+curRowMsrIndex).getValue().startsWith("NOT"))
					{
						eachMsrEndPartArrObj = ["NOT", Ext.getCmp('measureConditionId_'+curRowMsrIndex).getValue().replace("NOT ",""), Ext.getCmp('measureTextValueId_'+curRowMsrIndex).getValue(), Ext.getCmp('measureAndOrComboId_'+curRowMsrIndex).getValue()];
					}
					else
					{
						eachMsrEndPartArrObj = ["", Ext.getCmp('measureConditionId_'+curRowMsrIndex).getValue(), Ext.getCmp('measureTextValueId_'+curRowMsrIndex).getValue(), Ext.getCmp('measureAndOrComboId_'+curRowMsrIndex).getValue()];
					}
				}

				eachMsrEndPartObj.push(eachMsrEndPartArrObj);
			}
			eachMsrCndtnObj.endCndtn = eachMsrEndPartObj;
			allMsrCndtnsObj.push(eachMsrCndtnObj);
		}

		if(me.validateAddEditCndtnsData())
		{
			Ext.Ajax.request({
				url : config.urls.servletURL,
				params : {
					'cmd' : "Compliance_Templates",
					'reqfrom' : "save",
					'pullData' : "true",
					'tmpltNm' : selectedTmpltNmForCurOprtns,
					'tmpltDsc' : selectedTmpltDscForCurOprtns,
					'selMngdCmpntTyp' : selectedMngdCmpntTypForCurOprtns,
					'selMngdCmpnt' : selectedMngdCmpntNmForCurOprtns,
					'selCnfgTst' : selectedCnfgTstCdForCurOprtns,
					'minNoOfDscrptrCndtn' : givnMinNoOfDscrptrCndtn,
					'maxNoOfDscrptrCndtn' : givnMaxNoOfDscrptrCndtn,
					'tmpltTestSeqNo' : tmpltTestSeqNo,
					'selDscrptrCode' : filterEncode(selectedDscrptrForCurOprtns),
					'isSelctdDscrptrAvlblInTmplt' : isSelectedDscrptrAlrdyAvlblInTmplt,
					'dscrptrCndtn' : Ext.encode(dscrptrCndtnObj),
					'allMsrCndtns' : Ext.encode(allMsrCndtnsObj),
				},
				method : 'POST',
				async : false,
				success : function( response )
				{
					var msg;
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						respJsonObj = Ext.decode( jsonText );
						if(respJsonObj['saveStatus']=="true")
						{
							if(Ext.getCmp('newOrExistingTmplt') != null)
							{
								Ext.getCmp('newOrExistingTmplt').setValue('existing');
							}
							if(Ext.getCmp('saveButtonId').getText == config.labels.save)
							{
								msg = config.msgs.cndtnsSaved;
							}
							else
							{
								msg = config.msgs.cndtnsUpdated;
							}
						}
						else
						{
							msg = config.msgs.issueInSaveCndtns;
						}

						if(respJsonObj['conditionsFrmCmplncChckTmpltForView'] != null)
						{
							me.loadTemplateDetailsWindow(respJsonObj['conditionsFrmCmplncChckTmpltForView']);
							if(Ext.getCmp('toolsButId').curntExpndCollpsSts != null && Ext.getCmp('toolsButId').curntExpndCollpsSts == 'collapsed')
							{
								Ext.getCmp('templatedetailswindow').toggleWindowAnimation();
							}
						}
						me.flashMsgBox(msg);
					}
				}
			});
		}
	},
	flashMsgBox:function(msg){
		Ext.create('utilities.GenericWindow', {
			floating:true,
			plain:true,
			ui:'flash-msg',
			resizable:false,
			frame:false,
			maskOpacity:'0.9',
			maskColor:'#000',
			header:false,
			border:false,
			closeAction:'destroy',
			bodyPadding:10,
			html:'<div style="margin:10px;text-wrap:nowrap;white-space:nowrap">'+msg+'</div>',
			listeners:{
				show:function(win){
				var win2 = Ext.getCmp('addEditConditionWindowId');
					win2.mask();
					win2.addCls('windowModalWhite');
					win.getEl().setOpacity(0);
					win.getEl().fadeIn({
						duration: 1000,
						callback:function(){
							Ext.defer(function(){
								win.hide();
							},1000)
						}
					});
					win.hide();
				},
				hide : function(win) {
					win.getEl().fadeOut({duration: 1000, callback: function() {
						win.close();
						var win2 = Ext.getCmp('addEditConditionWindowId');
						win2.unmask();
						win2.removeCls('windowModalWhite');
						if(win2){
							win2[win2.closeAction]();
						}
					}});
				}
			}
		}).show();
	},
	validateAddEditCndtnsData:function()
	{
		var status = true;
		if(isCnfgTstCdDscrptrBasedForCurOprtns)
		{
			var noOfDscrptrCndnRow = Ext.getCmp('addDescriptorForm').items.length;
			for(var incr=0; incr<noOfDscrptrCndnRow; incr++)
			{
				var curDscrptrRowIndex = Ext.getCmp('addDescriptorForm').items.items[incr].index;
				var dscrDataTyp;
				if(incr == 0)
				{
					dscrDataTyp = Ext.getCmp('descDataTypeId_'+curDscrptrRowIndex).getValue();
					if( (Ext.getCmp('descCaseSensitiveId_'+curDscrptrRowIndex).getValue() == null) || (Ext.getCmp('descCaseSensitiveId_'+curDscrptrRowIndex).getValue() == '') )
					{
						status = false;
						Ext.Msg.alert('&nbsp;', config.msgs.noCaseSnstvInDscrptrCndtn);
						break;
					}
				}

				if( (Ext.getCmp('descConditionId_'+curDscrptrRowIndex).getValue() == null) || (Ext.getCmp('descConditionId_'+curDscrptrRowIndex).getValue() == '') )
				{
					status = false;
					Ext.Msg.alert('&nbsp;', config.msgs.noCndtnInDscrptrCndtn);
					break;
				}
				else if( (Ext.getCmp('descTextValueId_'+curDscrptrRowIndex).getValue() == null) || (Ext.getCmp('descTextValueId_'+curDscrptrRowIndex).getValue().trim() == '') )
				{
					status = false;
					Ext.Msg.alert('&nbsp;', config.msgs.noCndtnPrvdInDscrptrCndtn);
					break;
				}
				else if( (Ext.getCmp('descConditionId_'+curDscrptrRowIndex).getValue() != null) && (listOfNumberCndtnVlus.indexOf(Ext.getCmp('descConditionId_'+curDscrptrRowIndex).getValue()) >= 0) && (isNaN(Ext.getCmp('descTextValueId_'+curDscrptrRowIndex).getValue())) )
				{
					status = false;
					Ext.Msg.alert('&nbsp;', config.msgs.numTypDscrptrVluExpctd + " '" + Ext.getCmp('descConditionId_'+curDscrptrRowIndex).getRawValue() + "'");
					break;
				}
			}
		}

		if(status)
		{
			var noOfMeasures = Ext.getCmp('measureFormOuter').items.length;
			var selectedMsrCodes = [];
			var selectedMsrNames = [];
			outerloop:
			for(var incr=0; incr<noOfMeasures; incr++)
			{
				var noOfMsrRowCndtn = Ext.getCmp('measureFormOuter').items.items[incr].items.items.length;
				for(var incr1=0; incr1<noOfMsrRowCndtn; incr1++)
				{
					var curRowMsrIndex = Ext.getCmp('measureFormOuter').items.items[incr].items.items[incr1].indexMeasure;
					if(incr1 == 0)
					{
						selectedMsrCodes[incr] = Ext.getCmp('measureName_'+curRowMsrIndex).getValue();
						selectedMsrNames[incr] = Ext.getCmp('measureName_'+curRowMsrIndex).getRawValue();
						curMsrDataTyp = Ext.getCmp('measureDataTypeId_'+curRowMsrIndex).getValue();
						if( (Ext.getCmp('measureName_'+curRowMsrIndex).getValue() == null) || (Ext.getCmp('measureName_'+curRowMsrIndex).getValue() == '') )
						{
							status = false;
							Ext.Msg.alert('&nbsp;', config.msgs.noMsrNmPrvd);
							break outerloop;
						}
						else if( (Ext.getCmp('measureCaseSensitiveId_'+curRowMsrIndex).getValue() == null) || (Ext.getCmp('measureCaseSensitiveId_'+curRowMsrIndex).getValue() == '') )
						{
							status = false;
							Ext.Msg.alert('&nbsp;', config.msgs.noCaseSnstvInMsrCndtn);
							break outerloop;
						}
					}
					if( (Ext.getCmp('measureConditionId_'+curRowMsrIndex).getValue() == null) || (Ext.getCmp('measureConditionId_'+curRowMsrIndex).getValue() == '') )
					{
						status = false;
						Ext.Msg.alert('&nbsp;', config.msgs.noCndtnInMsrCndtn);
						break outerloop;
					}
					else if( (Ext.getCmp('measureTextValueId_'+curRowMsrIndex).getValue() == null) || (Ext.getCmp('measureTextValueId_'+curRowMsrIndex).getValue() == '') )
					{
						status = false;
						Ext.Msg.alert('&nbsp;', config.msgs.noCndtnPrvdInMsrCndtn);
						break outerloop;
					}
					else if( (Ext.getCmp('measureConditionId_'+curRowMsrIndex).getValue() != null) && (listOfNumberCndtnVlus.indexOf(Ext.getCmp('measureConditionId_'+curRowMsrIndex).getValue()) >= 0) && (isNaN(Ext.getCmp('measureTextValueId_'+curRowMsrIndex).getValue())) )
					{
						status = false;
						Ext.Msg.alert('&nbsp;', config.msgs.numTypMsrVluExpctd + " '" + Ext.getCmp('measureConditionId_'+curRowMsrIndex).getRawValue() + "' " + config.msgs.inTheMsrNm + " '" + selectedMsrNames[incr] + "'");
						break outerloop;
					}
				}
			}

			nextouterloop:
			for(var incr=0; incr<selectedMsrCodes.length; incr++)
			{
				for(var incr1=incr+1; incr1<selectedMsrCodes.length; incr1++)
				{
					if(selectedMsrCodes[incr] == selectedMsrCodes[incr1])
					{
						status = false;
						Ext.Msg.alert('&nbsp;', config.msgs.duplctMsrNm + " '" + selectedMsrNames[incr] + "' " + config.msgs.moreThanOnce);
						break nextouterloop;
					}
				}
			}
		}
		return status;
	},
	loadTemplateDetailsWindow:function(savedChangesForViewJSON)
	{
		for(var incr=0; incr<savedChangesForViewJSON.length; incr++)
		{
			for(var incr1=0; incr1<savedChangesForViewJSON[incr].cndtns.length; incr1++)
			{
				var dscrptrCodeTmp = savedChangesForViewJSON[incr].cndtns[incr1].dscrptrCode;
				savedChangesForViewJSON[incr].cndtns[incr1].dscrptrCode=dscrptrCodeTmp.replace("\\","\\\\");
			}
		}

		if(Ext.getCmp('templatedetailswindow') == null)
		{
			Ext.getCmp('main').add(Ext.create('ComplianceCheckTemplates.view.TemplateDetailsWindow'));

			var sampleModel = Ext.define('saveChangesTableModel', {
					extend: 'Ext.data.Model',
					fields: [
						{ name:'templateName', type:'string'},
						{ name:'testCode', type:'string'},
						{ name:'testName', type:'string'},
						{ name:'compType', type:'string'},
						{ name:'compTypeDescription', type:'string'},
						{ name:'isDescriptorBased', type:'string'},
						{ name:'noOfDscrptrCndtn', type:'string'},
						{ name:'cndtns'},
						{ name:'dscrptrCndtn', type:'string'},
						{ name:'dscrptrCode', type:'string'},
						{ name:'msrCndtns'},
						{ name:'msrCode', type:'string'},
						{ name:'msrName', type:'string'},
						{ name:'msrCndtn', type:'string'},
					]
				  });

			Ext.getCmp('templatedetailswindow').add({

						xtype:'container',
						autoScroll: true,
						padding: 0,
						flex: 1,
						items:[{
							xtype:'dataview',
							id: 'templatedetailswindowcontainer',
							renderTo: Ext.getBody(),
							store:Ext.data.Store({
								model:sampleModel,
								data:savedChangesForViewJSON,
							}),
							tpl: new Ext.XTemplate(
								'<tpl>',
								'<div class="newTableRowBorder" >',
									'<table  width="100%">',
										'<thead>',
											'<tr>',
												'<th style="width:15%">',
													'<div style="width:100%;padding:4px;vertical:middle;" >',
														'<p style="line-height:1.5em"><span class="font_bold11">' + config.labels.cmpntTypeTstNm + '</span></p>',
													'</div>',
												'</th>',
												'<th style="width:20%">',
													'<div style="width:100%;padding:4px;vertical:middle;" >',
														'<p style="line-height:1.5em"><span class="font_bold11">' + config.labels.noOfDscrptrCndtn + '</span></p>',
													'</div>',
												'</th>',
												'<th style="width:30%">',
													'<div style="width:100%;padding:4px;vertical:middle;" >',
														'<p style="line-height:1.5em"><span class="font_bold11">' + config.labels.dscrptrCndtns + '</span></p>',
													'</div>',
												'</th>',
												'<th style="width:30%">',
													'<div style="width:100%;padding:4px;vertical:middle;" >',
														'<p style="line-height:1.5em"><span class="font_bold11">' + config.labels.msrCndtns + '</span></p>',
													'</div>',
												'</th>',
												'<th>',
													'<div style="width:100%;padding:4px;vertical:middle;" >',
														'<p style="line-height:1.5em"><span class="font_bold11">&nbsp;</span></p>',
													'</div>',
												'</th>',
											'</tr>',
										'</thead>',
										'<tbody>',
											'<tpl for=".">',
												'<tr class="trSelector">',
													'<td class="bottomBorder" style="width:15%">',
														'<div style="width:100%;padding:4px;vertical:middle;" >',
															'<p style="line-height:1.5em"><span class="font_normal11">{compTypeDescription} / {testName}</span></p>',
														'</div>',
													'</td>',
													'<td class="bottomBorder" style="width:20%">',
														'<div style="width:100%;padding:4px;vertical:middle;" >',
															'<p style="line-height:1.5em"><span class="font_normal11">{noOfDscrptrCndtn}</span></p>',
														'</div>',
													'</td>',
													'<td colspan="2" style="padding:0px;width:60%" class="bottomBorder">',
														'<table width="100%" style="border:0px">',
															'<tpl for="cndtns">',
																'<tr style="background:transparent">',
																	'<td style="width:50%;border:0px 0px 1px 0px" class="{[this.lastRowTd(xindex, xcount)]}">',
																		'<div style="width:100%;padding:4px;vertical:middle;">',
																			'<tpl if="dscrptrCode==\'\'">',
																				'<p style="line-height:1.5em;display:inline-block" class=""><span class="font_normal11">{dscrptrCndtn}</span></p>',
																			'<tpl elseif="isDescriptorBased && xcount &gt; 1">',
																				'<p style="line-height:1.5em;display:inline-block" class="iconHoverClass"><span class="font_normal11">{dscrptrCndtn}</span><a href="javascript:void(0)" <span>&nbsp;<img data-qtip=' + config.labels.mdfyDscrprtCndtn + ' data-qclass="yellowTip" src="/final/images/spacer.gif" class="iconModify" style="vertical-align:middle"  onClick="me.modifyDescriptor(\'{templateName}\',\'{compType}\',\'{compTypeDescription}\',\'{testCode}\',\'{testName}\',\'{dscrptrCode}\');"/>&nbsp;<img data-qtip=' + config.labels.delDscrprtCndtn + ' data-qclass="yellowTip" src="/final/images/spacer.gif" class="iconDelete" style="vertical-align:middle" onClick="me.deleteDescriptorWithCnrmtn(\'descriptor\',false,\'{templateName}\',\'{compType}\',\'{compTypeDescription}\',\'{testCode}\',\'{testName}\',\'{dscrptrCode}\');"/></span></a></p>',
																			'<tpl elseif="isDescriptorBased && xcount == 1">',
																				'<p style="line-height:1.5em;display:inline-block" class="iconHoverClass"><span class="font_normal11">{dscrptrCndtn}</span><a href="javascript:void(0)" <span>&nbsp;<img data-qtip=' + config.labels.mdfyDscrprtCndtn + ' data-qclass="yellowTip" src="/final/images/spacer.gif" class="iconModify" style="vertical-align:middle"  onClick="me.modifyDescriptor(\'{templateName}\',\'{compType}\',\'{compTypeDescription}\',\'{testCode}\',\'{testName}\',\'{dscrptrCode}\');"/>&nbsp;<img data-qtip=' + config.labels.delDscrprtCndtn + ' data-qclass="yellowTip" src="/final/images/spacer.gif" class="iconDelete" style="vertical-align:middle" onClick="me.deleteDescriptorWithCnrmtn(\'test\',false,\'{templateName}\',\'{compType}\',\'{compTypeDescription}\',\'{testCode}\',\'{testName}\',\'{dscrptrCode}\');"/></span></a></p>',
																			'<tpl elseif="!isDescriptorBased">',
																				'<p style="line-height:1.5em;display:inline-block" class=""><span class="font_normal11">{dscrptrCndtn}</span></p>',
																			'</tpl>',
																		'</div>',
																	'</td>',
																	'<td style="width:50%;" class="{[this.lastRowTd(xindex ,xcount)]} " >',
																		'<tpl for="msrCndtns">',
																			'<div style="width:100%;padding:4px;vertical:middle;" class="{[this.lastRowDiv(xindex ,xcount)]}">',
																				'<tpl if="msrCode==\'\'">',
																					'<p style="line-height:1.5em;display:inline-block" class="iconHoverClass"><span class="font_normal11">{msrCndtn}</span></p>',
																				'<tpl elseif="xcount &gt; 1">',
																					'<p style="line-height:1.5em;display:inline-block" class="iconHoverClass"><span class="font_normal11">{msrCndtn}</span><span>&nbsp;<img data-qtip=' + config.labels.mdfyMsrCndtn + ' data-qclass="yellowTip" src="/final/images/spacer.gif" class="iconModify" style="vertical-align:middle" onClick="me.modifyMeasure(\'{templateName}\',\'{compType}\',\'{compTypeDescription}\',\'{testCode}\',\'{testName}\',\'{parent.dscrptrCode}\',\'{msrCode}\',\'{msrName}\');"/>&nbsp;<img data-qtip= ' + config.labels.delMsrCndtn + ' data-qclass="yellowTip" src="/final/images/spacer.gif"  class="iconDelete" style="vertical-align:middle" onClick="me.deleteMeasure(\'measure\',\'{templateName}\',\'{compType}\',\'{compTypeDescription}\',\'{testCode}\',\'{testName}\',\'{parent.dscrptrCode}\',\'{msrCode}\',\'{msrName}\');"/></span></p>',
																				'<tpl elseif="parent.isDescriptorBased">',
																					'<p style="line-height:1.5em;display:inline-block" class="iconHoverClass"><span class="font_normal11">{msrCndtn}</span><span>&nbsp;<img data-qtip=' + config.labels.mdfyMsrCndtn + ' data-qclass="yellowTip" src="/final/images/spacer.gif" class="iconModify" style="vertical-align:middle" onClick="me.modifyMeasure(\'{templateName}\',\'{compType}\',\'{compTypeDescription}\',\'{testCode}\',\'{testName}\',\'{parent.dscrptrCode}\',\'{msrCode}\',\'{msrName}\');"/>&nbsp;<img data-qtip=' + config.labels.delMsrCndtn + ' data-qclass="yellowTip" src="/final/images/spacer.gif"  class="iconDelete" style="vertical-align:middle" onClick="me.deleteMeasure(\'descriptor\',\'{templateName}\',\'{compType}\',\'{compTypeDescription}\',\'{testCode}\',\'{testName}\',\'{parent.dscrptrCode}\',\'{msrCode}\',\'{msrName}\');"/></span></p>',
																				'<tpl else>',
																					'<p style="line-height:1.5em;display:inline-block" class="iconHoverClass"><span class="font_normal11">{msrCndtn}</span><span>&nbsp;<img data-qtip=' + config.labels.mdfyMsrCndtn + ' data-qclass="yellowTip" src="/final/images/spacer.gif" class="iconModify" style="vertical-align:middle" onClick="me.modifyMeasure(\'{templateName}\',\'{compType}\',\'{compTypeDescription}\',\'{testCode}\',\'{testName}\',\'{parent.dscrptrCode}\',\'{msrCode}\',\'{msrName}\');"/>&nbsp;<img data-qtip=' + config.labels.delMsrCndtn + ' data-qclass="yellowTip" src="/final/images/spacer.gif"  class="iconDelete" style="vertical-align:middle" onClick="me.deleteMeasure(\'test\',\'{templateName}\',\'{compType}\',\'{compTypeDescription}\',\'{testCode}\',\'{testName}\',\'{parent.dscrptrCode}\',\'{msrCode}\',\'{msrName}\');"/></span></p>',
																				'</tpl>',
																			'</div>',
																		'</tpl>',
																	'</td>',
																'</tr>',
															'</tpl>',
														'</table>',
													'</td>',
													'<td class="bottomBorder">',
														'<div style="width:100%;vertical-align:middle;width:50px" >',
															'<img data-qtip=' + config.labels.mdfyTst + ' data-qclass="yellowTip" src="/final/images/spacer.gif" style="margin-right:10px;margin-top:4px" class="iconModify handSymbol" onClick="me.modifyTest(\'{templateName}\',\'{compType}\',\'{compTypeDescription}\',\'{testCode}\',\'{testName}\');"/>',
															'<img data-qtip=' + config.labels.delTst + ' data-qclass="yellowTip" src="/final/images/spacer.gif" class="iconDelete handSymbol" onClick="me.deleteTestWithCnrmtn(false,\'{templateName}\',\'{compType}\',\'{compTypeDescription}\',\'{testCode}\',\'{testName}\');"/>',
														'</div>',
													'</td>',
												'</tr>',
											'</tpl>',
										'</tbody>',
									'</table>',
								'</div>',
							'</tpl>',
							{
								lastRowTd: function (xind, length) {
									return xind == length ? '' : 'bottomBorder';
								},
								lastRowDiv: function (xind, length) {
									return xind == length ? '' : 'divBorder';
								},
							}),
						}]
			});
			Ext.getCmp('templatedetailswindow').title=config.title.dtlsOfTmplt + " '" + selectedTmpltNmForCurOprtns + "'";
			Ext.getCmp('templatedetailswindow').show();
			Ext.getCmp('toolsButId').curntExpndCollpsSts = 'expanded';
			Ext.getCmp('main').doLayout();
		}
		else
		{
			Ext.getCmp('templatedetailswindowcontainer').getStore().loadRawData(savedChangesForViewJSON);
		}
	},
	modifyTest:function(templateName, compType, compTypeDescription, testCode, testName)
	{
		var me = this;
		me.mdfyTmplt(templateName);
		Ext.getCmp('compType').setValue(compType);
		me.mngdCmpntTypChanged();
		Ext.Msg.alert('&nbsp;', config.msgs.selSutblCmpntToMdyTst + " '" + testName + "'");
		Ext.getCmp('templatedetailswindow').toggleWindowAnimation();
	}
	,
	deleteTestWithCnrmtn:function(alrdyCnfrmdByUsr, templateName, compType, compTypeDescription, testCode, testName)
	{
		if(!alrdyCnfrmdByUsr)
		{
			Ext.Msg.confirm("&nbsp;", config.msgs.allCndtnsBeDltdCnfrmToDelTst + " '" + compTypeDescription + "/" + testName + "'. <br/><br/>" + config.msgs.allCndtnsBeDltdCnfrmToDelTstNote, function(btnText)
			{
				if(btnText == "yes")
				{
					me.deleteTest(templateName, compType, compTypeDescription, testCode, testName);
				}
			}, this);
		}
		else
		{
			me.deleteTest(templateName, compType, compTypeDescription, testCode, testName);
		}
	},
	deleteTest:function(templateName, compType, compTypeDescription, testCode, testName)
	{
		Ext.Ajax.request({
			url : config.urls.servletURL,
			params : {
				'cmd' : "Compliance_Templates",
				'reqfrom' : "deleteTest",
				'pullData' : "true",
				'tmpltNm' : templateName,
				'compType' : compType,
				'testCode' : testCode,
			},
			method : 'POST',
			async : false,
			success : function( response )
			{
				var msg;
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var dltTstRspnsJsonObj = Ext.decode( jsonText );

					if(dltTstRspnsJsonObj['deleteTestStatus']==false && dltTstRspnsJsonObj['containsSingleTest']==true)
					{
						Ext.Msg.confirm("&nbsp;", config.msgs.shldHvOneTstCnfrmDelTmplt + " '" + templateName + "' ", function(btnText)
						{
							if(btnText == "yes")
							{
								Ext.Ajax.request({
									url : config.urls.servletURL,
									params : {
										'cmd' : "Compliance_Templates",
										'reqfrom' : "delTmplt",
										'pullData' : "true",
										'tmplt_2b_del' : templateName,
									},
									method : 'POST',
									async : false,
									success : function( response )
									{
										if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
										{
											var jsonText = response.responseText;
											var delTmpltJSON = Ext.decode( jsonText );

											if(delTmpltJSON['templateDelStatus'] == true)
											{
												Ext.getCmp('main').removeAll();
												if(Ext.getCmp('templatedetailswindow') != null)
												{
													Ext.getCmp('templatedetailswindow').destroy();
												}
												Ext.getCmp('main').add(Ext.create('ComplianceCheckTemplates.view.TemplateListGrid'));
												me.tlg_loadTemplatesList();
												Ext.Msg.alert('&nbsp;', config.msgs.tmpltDltd);
											}
											else if(delTmpltJSON['templateDelStatus'] == false)
											{
												Ext.Msg.alert('&nbsp;', config.msgs.issueInTmpltDel);
											}
											if ($('#layer'))
											{
												$('#layer').remove();
											}
											if (!Ext.isEmpty(me.layer))
											{
												Ext.getCmp('layer').destroy();
											}
										}
									}
								});
							}
						}, this);
					}
					else if(dltTstRspnsJsonObj['deleteTestStatus']==true && dltTstRspnsJsonObj['conditionsFrmCmplncChckTmpltForView'] != null)
					{
						me.loadTemplateDetailsWindow(dltTstRspnsJsonObj['conditionsFrmCmplncChckTmpltForView']);
						Ext.Msg.alert('&nbsp;', config.msgs.tstDeltd);
					}
				}
			}
		});
	},
	modifyDescriptor:function(templateName, compType, compTypeDescription, testCode, testName, dscrptrCode)
	{
		me.modifyDescriptorORMeasure(templateName, compType, compTypeDescription, testCode, testName, dscrptrCode, null, null);
	}
	,
	deleteDescriptorWithCnrmtn:function(getCnfrmToDelTestOrDscrptr, alrdyCnfrmdByUsr, templateName, compType, compTypeDescription, testCode, testName, dscrptrCode)
	{
		if(getCnfrmToDelTestOrDscrptr == 'test')
		{
				Ext.Msg.confirm("&nbsp;", config.msgs.shldHvOneDscrptrCnfrmDelTst + " '" + compTypeDescription + "/" + testName + "' ", function(btnText)
				{
					if(btnText == "yes")
					{
						me.deleteTest(templateName, compType, compTypeDescription, testCode, testName);
					}
				}, this);
		}
		else if(getCnfrmToDelTestOrDscrptr == 'descriptor')
		{
			if(!alrdyCnfrmdByUsr)
			{
				Ext.Msg.confirm("&nbsp;", config.msgs.cnfrmToDelDscrptr + " '" + dscrptrCode + "' " + config.msgs.inTheTst + " '" + compTypeDescription + "/" + testName + "' ", function(btnText)
				{
					if(btnText == "yes")
					{
						me.deleteDescriptor(templateName, compType, compTypeDescription, testCode, testName, dscrptrCode);
					}
				}, this);
			}
			else
			{
				me.deleteDescriptor(templateName, compType, compTypeDescription, testCode, testName, dscrptrCode);
			}
		}
	}
	,
	deleteDescriptor:function(templateName, compType, compTypeDescription, testCode, testName, dscrptrCode)
	{
		Ext.Ajax.request({
			url : config.urls.servletURL,
			params : {
				'cmd' : "Compliance_Templates",
				'reqfrom' : "deleteDescriptor",
				'pullData' : "true",
				'tmpltNm' : templateName,
				'compType' : compType,
				'testCode' : testCode,
				'selDscrptrCode' : filterEncode(dscrptrCode),
			},
			method : 'POST',
			async : false,
			success : function( response )
			{
				var msg;
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var dltDscrptrRspnsJsonObj = Ext.decode( jsonText );

					if(dltDscrptrRspnsJsonObj['conditionsFrmCmplncChckTmpltForView'] != null)
					{
						me.loadTemplateDetailsWindow(dltDscrptrRspnsJsonObj['conditionsFrmCmplncChckTmpltForView']);
					}
					Ext.Msg.alert('&nbsp;', config.msgs.dscrptrDeltd);
				}
			}
		});
	}
	,
	modifyMeasure:function(templateName, compType, compTypeDescription, testCode, testName, dscrptrCode, msrCode, msrName)
	{
		me.modifyDescriptorORMeasure(templateName, compType, compTypeDescription, testCode, testName, dscrptrCode, msrCode, msrName);
	},
	deleteMeasure:function(getCnfrmToDelTestORDscrptr, templateName, compType, compTypeDescription, testCode, testName, dscrptrCode, msrCode, msrName)
	{
		if(getCnfrmToDelTestORDscrptr == 'measure')
		{
			Ext.Msg.confirm("&nbsp;", config.msgs.cnfrmToDelMsr + " '" + msrName + "' " + config.msgs.forTheDscrptr + " '" + dscrptrCode + "' " + config.msgs.inTheTst + " '" + compTypeDescription + "/" + testName + "' ", function(btnText)
			{
				if(btnText == "yes")
				{
					Ext.Ajax.request({
						url : config.urls.servletURL,
						params : {
							'cmd' : "Compliance_Templates",
							'reqfrom' : "deleteMeasure",
							'pullData' : "true",
							'tmpltNm' : templateName,
							'compType' : compType,
							'testCode' : testCode,
							'selDscrptrCode' : filterEncode(dscrptrCode),
							'msrCode' : msrCode,
						},
						method : 'POST',
						async : false,
						success : function( response )
						{
							var msg;
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var jsonText = response.responseText;
								var dltMsrRspnsJsonObj = Ext.decode( jsonText );

								if(dltMsrRspnsJsonObj['conditionsFrmCmplncChckTmpltForView'] != null)
								{
									me.loadTemplateDetailsWindow(dltMsrRspnsJsonObj['conditionsFrmCmplncChckTmpltForView']);
								}
								Ext.Msg.alert('&nbsp;', config.msgs.msrDeltd);
							}
						}
					});
				}
			}, this);
		}
		else if(getCnfrmToDelTestORDscrptr == 'descriptor')
		{
			Ext.Msg.confirm("&nbsp;", config.msgs.shldHvOneMsrCnfrmDelDscrptr + " '" + dscrptrCode + "' " + config.msgs.inTheTst + " '" + compTypeDescription + "/" + testName + "' ", function(btnText)
				{
					if(btnText == "yes")
					{
						me.deleteDescriptorWithCnrmtn('descriptor', true, templateName, compType, compTypeDescription, testCode, testName, dscrptrCode);
					}
				}, this);
		}
		else if(getCnfrmToDelTestORDscrptr == 'test')
		{
			Ext.Msg.confirm("&nbsp;", config.msgs.shldHvOneMsrCnfrmDelTst + " '" + compTypeDescription + "/" + testName + "' ", function(btnText)
				{
					if(btnText == "yes")
					{
						me.deleteTestWithCnrmtn(true, templateName, compType, compTypeDescription, testCode, testName);
					}
				}, this);
		}
	},
	modifyDescriptorORMeasure:function(templateName, compType, compTypeDescription, testCode, testName, dscrptrCode, msrCode, msrName)
	{
		Ext.Ajax.request({
			url : config.urls.servletURL,
			params : {
				'cmd' : "Compliance_Templates",
				'reqfrom' : "modifyDescriptorORMeasure",
				'pullData' : "true",
				'tmpltNm' : templateName,
				'compType' : compType,
				'testCode' : testCode,
				'dscrptrCode' : filterEncode(dscrptrCode),
				'msrCode' : msrCode,
			},
			method : 'POST',
			async : false,
			success : function( response )
			{
				var msg;
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var mdfyDscrptrMsrRspnsJsonObj = Ext.decode( jsonText );

					if(mdfyDscrptrMsrRspnsJsonObj['foundSutblMngdCmpntNm'])
					{
						selectedTmpltNmForCurOprtns = templateName;
						selectedCnfgTstCdForCurOprtns = testCode;
						selectedCnfgTstForCurOprtns = testName;
						selectedMngdCmpntNmForCurOprtns = testName;
						selectedMngdCmpntTypForCurOprtns = compType;
						selectedMngdCmpntNmForCurOprtns = mdfyDscrptrMsrRspnsJsonObj['sutblMngdCmpntNm'];
						isCnfgTstCdDscrptrBasedForCurOprtns = mdfyDscrptrMsrRspnsJsonObj['isDscrptrBased'];

						if(Ext.getCmp('toolsButId').curntExpndCollpsSts != null && Ext.getCmp('toolsButId').curntExpndCollpsSts == 'expanded')
						{
							Ext.getCmp('templatedetailswindow').toggleWindowAnimation();
						}
						if( (dscrptrCode == null) || (dscrptrCode.trim() == "") )
						{
							selectedDscrptrForCurOprtns = null;
							isSelectedDscrptrAlrdyAvlblInTmplt = null;
							me.loadAddEditConditionsWindow(null, null, null, mdfyDscrptrMsrRspnsJsonObj['allMsrColumnNmCds']);
						}
						else
						{
							selectedDscrptrForCurOprtns = dscrptrCode;
							isSelectedDscrptrAlrdyAvlblInTmplt = "true";
							me.loadAddEditConditionsWindow(null, dscrptrCode, null, mdfyDscrptrMsrRspnsJsonObj['allMsrColumnNmCds']);
						}
					}
					else
					{
						Ext.Msg.alert('&nbsp;', config.msgs.choseSutblCmpntToMdfyTst);
					}
				}
			}
		});
	},
	tlg_searchMatchingTmplts:function(field, event)
	{
		if( (!Ext.isEmpty(event)) && ((event.getKey() == event.ENTER) || (event.type=='click')) )
		{
			if( (field != null) && (field.value.trim() != undefined))
			{
				Ext.Ajax.request({
					url : config.urls.servletURL,
					params : {
						'cmd' : "Compliance_Templates",
						'reqfrom' : "searchMatchingTmplts",
						'pullData' : "true",
						'tmpltNmToBeMatched' : field.value.trim(),
					},
					method : 'POST',
					async : false,
					success : function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var matchingTmpltsJSON = Ext.decode( jsonText );
							me.createTmpltLstGridAndLoadData(matchingTmpltsJSON);
						}
					}
				});
			}
		}
	},
});


// Ext.EventManager.onWindowResize(function () {
// 	console.log('aaaa');
// 	//Ext.getCmp('templatedetailswindowcontainer').doLayout();
// 	//Ext.getCmp('templatedetailswindowcontainer').doLayout();
//     Ext.getCmp('templatedetailswindow').toggleWindowAnimation();
//     console.log('bbbb');
//     Ext.getCmp('templatedetailswindow').setSize();
//     console.log('cccc');
// }); 