Ext.define('ComplianceCheckTemplates.view.FormItems', {
	extend: 'Ext.form.Panel',
	alias: 'widget.formitems',
	id: 'formitems',
	margin: '8 8 0 8',
	layout: {
		type:'vbox',
		align:'stretch'
	},
	scroll:false,
	autoScroll:true,
	requires: [
		'utilities.ScrollCombo',
	],
	items : [{
			xtype:'container',
			columnWidth:1,
			defaults:{
				labelAlign:'top',
				margin: 10,
				labelSeparator:'',
			},
			layout:{
				type:'hbox',
			},
			items:[
				{
					xtype : 'textfield',
					fieldLabel :config.labels.templateName,
					id : 'templateName',
					cls: 'textbox',
					name:'textName',
					width:300,
					emptyText :config.labels.plsPrvdNewtmpltNm,
					readOnly: false,
				},{
					xtype:'textarea',
					fieldLabel:config.labels.description,
					width:500,
					cls:'text-area',
					id : 'templateDesc',
					emptyText :config.labels.plsPrvdTmpltNmDscrptn,
				}
			]
		},{
			xtype:'container',
			columnWidth:1,
			cls:'formOuter',
			layout:{
				type:'vbox',
				align:'stretch'
			},
			margin:'10 10 10 10',
			items:[
				{
					xtype:'container',
					cls:'font_normal12',
					html:config.labels.slctMtchngCmpntAndTsts,
					flex:1,
					margin:'20 10 10 10',
				},
				{
					xtype:'container',
					columnWidth:1,
					defaults:{
						labelAlign:'top',
						margin: '10 10 10 10',
						labelSeparator:'',
						width: 260,
					},
					layout:{
						type:'hbox',
					},
					items:[
						{
							xtype : 'scrollcombo',
							fieldLabel :config.labels.componentType,
							id : 'compType',
							cls: 'dropdown',
							store : new Ext.data.Store(
							{
								fields: ['displayField','valueField'],
								data: []
							}),
							queryMode : 'local',
							displayField :'displayField',
							valueField : 'valueField',
						},{
							xtype : 'scrollcombo',
							fieldLabel :config.labels.component,
							id : 'component',
							cls: 'dropdown',
							store : new Ext.data.Store(
							{
								fields: ['displayField','valueField'],
								data: []
							}),
							queryMode : 'local',
							displayField :'displayField',
							valueField : 'valueField',
						},{
							xtype : 'scrollcombo',
							fieldLabel :config.labels.enbldCnfgTsts,
							id : 'enableConfigTest',
							cls: 'dropdown',
							store : new Ext.data.Store(
							{
								fields: ['displayField','valueField'],
								data: []
							}),
							queryMode : 'local',
							displayField :'displayField',
							valueField : 'valueField',
						},{
							xtype : 'fieldcontainer',
							fieldLabel :config.labels.expctdNoOfDscrptrs,
							width:190,
							hidden:true,
							id:'numOfDescriptorConditionId',
							defaults:{
								labelAlign:'right',
								labelSeparator:'',
								width:90,
								margin:'0 0 0 0'
							},
							layout:'hbox',
							items:[
								{
									xtype:'fieldcontainer',
									layout:'vbox',
									margin:'0 10 0 0',
									defaults:{
										labelAlign:'right',
										labelSeparator:'',
										labelWidth:20,
									},
									items:[{
										xtype : 'numberfield',
										fieldLabel :config.labels.min,
										id : 'min',
										cls: 'textbox',
										hideTrigger:true,
										name:'min',
										width:85,
									},{
										xtype:'container',
										margin:'0 0 0 23',
										width:65,
										html:'<div class="font_normal9" style="line-height:1em" >' + config.labels.leaveBlnkIfNtRqrd + '</div>'
									}]
								},{
									xtype:'fieldcontainer',
									layout:'vbox',
									defaults:{
										labelAlign:'right',
										labelSeparator:'',
										labelWidth:24,
									},
									items:[{
										xtype : 'numberfield',
										fieldLabel :config.labels.max,
										id : 'max',
										hideTrigger:true,
										cls: 'textbox',
										name:'max',
										width:85,
									},{
										xtype:'container',
										margin:'0 0 0 26',
										width:65,
										html:'<div class="font_normal9" style="line-height:1em" >' + config.labels.leaveBlnkIfNtRqrd + '</div>'
									}]
								}
							]
						},{
							xtype : 'button',
							text : config.labels.submit,
							action : 'submit',
							id : 'submit',
							ui: 'newButtonSmall',
							margin: '30 10 0 10',
							width: 60
						},{
							xtype : 'hiddenfield',
							id : 'newOrExistingTmplt',
						}
					]
				}
			]
		}
	]
});