
Ext.define('ComplianceCheckTemplates.view.TemplateDetailsWindow', {
    extend: "Ext.window.Window",
    alias: "widget.templatedetailswindow",
    layout: {
        type: 'hbox'
    },
    ui: 'newPopupWindow withBorderShadow',
    title: config.title.dtlsOfTmplt + " '" + selectedTmpltNmForCurOprtns + "'",
    layout: 'fit',
    width: Ext.getBody().getViewSize().width - 40,
    height: Ext.getBody().getViewSize().height - 100,
    ghost: false,
    id: 'templatedetailswindow',
    draggable: false,
    modal: false,
    closable: false,
    resizable:true,
    header: {
        height: 40,
        style: {
            'cursor': 'pointer'
        }
    },
    bodyPadding: 10,
    scroll: false,
    autoScroll: false,
    listeners:
    {
        afterlayout: function () {
            var me = this;
        },
        afterrender: function (obj) {
            var me = this;
            me.layer = "";
            if ($('#layer')) {
                $('#layer').remove();
            }

            me.layer = Ext.create('Ext.Layer', {
                useDisplay: true,
                hideMode: 'display',
                cls: 'x-mask windowModal',
                shim: false,
                id: 'layer',
                zIndex: 9999,
                constrain: true,
                shadowOffset: 8
            });

            me.layer.setWidth(Ext.getBody().getViewSize().width);
            me.layer.setHeight(Ext.getBody().getViewSize().height);
            me.mon(me.header, 'click', function () {
                me.toggleWindowAnimation();
            });
        
            //  Window resize function start here
            Ext.EventManager.onWindowResize(function(){
            var me = this;
                var getViewW = Ext.getBody().getViewSize().width;
                var getViewH = Ext.getBody().getViewSize().height;
                var h = Math.floor(getViewW-40);
                var w = Math.floor(getViewH-100);
                obj.setSize(h, w);
                
                if(me.layer!='')
                {
                    me.layer.setWidth(Ext.getBody().getViewSize().width);
                    me.layer.setHeight(Ext.getBody().getViewSize().height);
                }
                //me.center();
            },this);
            //  Window resize function end here
        },
       
    },

    toggleWindowAnimation: function () {
        var me = this;
        var curSts = Ext.getCmp('toolsButId').curntExpndCollpsSts;
        if (curSts == 'expanded') {
            Ext.getCmp('toolsButId').setIconCls('toggleArrowUp');
            Ext.get('templatedetailswindow').animate({
                duration: 300,
                to: {
                    y: Ext.get('main').getHeight() - (Ext.get('templatedetailswindow').getHeight() - (Ext.getBody().getViewSize().height - 130))
                }
            });
            Ext.getCmp('toolsButId').curntExpndCollpsSts = 'collapsed';

			me.layer = "";
            if ($('#layer')) {
                $('#layer').remove();
            }

            if (!Ext.isEmpty(me.layer)) {
                Ext.getCmp('layer').destroy();
            }
        }
        else {
            Ext.getCmp('toolsButId').setIconCls('iconCloseNew');
            Ext.get('templatedetailswindow').animate({
                duration: 300,
                to: {
                    y: (Math.round(Ext.get('main').getHeight()) - Math.round(Ext.get('templatedetailswindow').getHeight()))
                }
            });
            Ext.getCmp('toolsButId').curntExpndCollpsSts = 'expanded';

            me.layer = "";
            if ($('#layer')) {
                $('#layer').remove();
            }

            me.layer = Ext.create('Ext.Layer', {
                useDisplay: true,
                hideMode: 'display',
                cls: 'x-mask windowModal',
                shim: false,
                id: 'layer',
                zIndex: 9999,
                constrain: true,
                shadowOffset: 8
            });

            me.zindex = $(me.getEl().dom).css("z-index");
            me.layer.setZIndex(me.zindex - 2);

            me.layer.setWidth(Ext.getBody().getViewSize().width);
            me.layer.setHeight(Ext.getBody().getViewSize().height);

            me.layer.show();
        }
    },
    tools: [
        {
            xtype: 'button',
            style: {
                'border': 'none',
                'background': 'transparent'
            },
            id: 'toolsButId',
            iconCls: 'iconCloseNew',
            hidden: false,
            curntExpndCollpsSts: 'expanded',
        }
    ]
});

