Ext.define('ComponentsView.controller.Main',{
	extend : 'Ext.app.Controller',
	views : [
		'Main',
		'ErrorContainer',
		'FormItems',
		'InfoGrid',
		'ComponentsViewChart',
		'configutilities.Tools',
		'configutilities.PrintPreview',
		'configutilities.SendMail'
	],
	refs : [
		{
			selector : 'main',
			ref : 'main'
		},
		{
			selector : 'formitems', 
			ref : 'formitems'
		},
		{
			selector : 'tools', 
			ref : 'tools'
		},
		{
			selector : 'infoGrid', 
			ref : 'infoGrid'
		},
		{
			selector : 'componentsviewchart', 
			ref : 'componentsviewchart'
		},
		{
			selector : 'errorcontainer', 
			ref : 'errorcontainer'
		}
	],

	init : function()
	{
		thisCtrl = this;
		this.buildFieldData()
		this.control({
			'main' : {
				'afterrender' : this.afterMainRender
			},
			'formitems' :{
				'boxready' : this.loadChartCt
			},
			'formitems combobox[id="ec_criteria"]' :{
				'select' : this.getInformations
			},
			'formitems combobox[id="ec_userOption"]' :{
				'select' : this.getInformations
			},
			'formitems combobox[id="compType"]' :{
				'select' : this.onChangeCompType
			},
			'formitems button[id="submit"]' :{
				'click' : this.componentSearch
			},
			'tools' :{
				'afterrender' : this.loadTools
			},
			'tools button[id="saveBtn"]' : {
				'click' : this.saveAsPDF
			},
			'tools button[id="printBtn"]' : {
				'click' : this.printData
			},
			'tools button[id="csvBtn"]' : {
				'click' : this.saveAsCSV
			},
			'tools button[id="mailBtn"]' : {
				'click' : this.sendMail
			},
			'tools button[id="scheduleBtn"]' : {
				'click' : this.setschedule
			},
			'main #backBtnMain': {
				'click': this.forwardRequestedURI
			}
		});
	},


	buildFieldData : function()
	{
		Ext.Ajax.request({
			url		: config.urls.servletURL,
			params	: queryString+"&needData=yes",
			method	: 'POST',
			async	: false,
			success	: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) 
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					hiddenFieldsKeys = publicJSON['hiddenFields'];
					backOperation = publicJSON['backOperation'];
				}
			}
		});
	},


	afterMainRender : function()
	{
		me = this;
		Ext.getCmp('selectedType').setValue(selectedType);

		if (strRequestFrom != null && strRequestFrom == "Devices")
		{
			Ext.getCmp('bkSeperator').show();
			Ext.getCmp('formitems').hide();
			Ext.getCmp('schSep').hide();
			Ext.getCmp('scheduleTool').hide();
			me.loadChartCt();
		}
		else
		{
			var ec_userOption = me.getFormitems().getComponent('infoCont').getComponent('ec_userOption');
			var ec_criteria = me.getFormitems().getComponent('infoCont').getComponent('ec_criteria');
			var compTypeId = me.getFormitems().getComponent('infoCont').getComponent('compType');

			ec_criteria.getStore().loadRawData(publicJSON['viewByList']);
			ec_criteria.setValue(publicJSON.selectedEcOpt);

			if (publicJSON.selectedEcOpt != 'Component')
			{
				ec_userOption.getStore().loadRawData(publicJSON['specViewByList']);
				ec_userOption.setValue(publicJSON.selectedUserOption);
				ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
				ec_userOption.show();
			}
			else
			{
				ec_userOption.hide();
			}
			compTypeId.getStore().loadRawData(publicJSON['CompTypeList']);

			if (publicJSON['selectedCompType'] != "" && publicJSON['selectedCompType'] != null && publicJSON['selectedCompType'] != undefined)
			{
				compTypeId.setValue(publicJSON['selectedCompType']);
			}
			else
			{
				compTypeId.setValue(publicJSON['CompTypeList'][0].valueField);
			}
		}

		if (publicJSON.hasConfigDetails != false && publicJSON.hasConfigDetails != undefined)
		{
			me.setToolsState(false);
		}
		else
		{
			if (publicJSON['selectedCompType'] != "" && publicJSON['selectedCompType'] != null && publicJSON['selectedCompType'] != undefined)
			{
				me.setToolsState(true,publicJSON['selectedCompType']);
			}
			else
			{
				me.setToolsState(true,publicJSON['CompTypeList'][0].valueField);
			}
		}

		if (req_SaveSchedule != null && req_SaveSchedule == "saveSchedule")
		{
			Ext.getCmp('backBtnMain').show();
			Ext.getCmp('bkSeperator').show();
			Ext.getCmp('submit').setText('Save');
		}
		if (backOperation != null && backOperation.home != undefined && backOperation.home)
		{
			Ext.getCmp('backBtnMain').show();
		}
		if (backOperation != null && backOperation.schedule != undefined && backOperation.schedule)
		{
			Ext.getCmp('backBtnMain').show();
		}
	},


	loadChartCt : function()
	{
		if (req_SaveSchedule != null && req_SaveSchedule != "saveSchedule")
		{
			thisCtrl.getMain().getComponent('hiddenPanel').setTitle(publicJSON.pageInfoCaption);
			if (publicJSON.chartData !="" && publicJSON.chartData != undefined)
			{
				thisCtrl.getComponentsviewchart().loadChart(publicJSON,thisCtrl);
			}

			if (publicJSON.hasConfigDetails != false)
			{
				Ext.getCmp('formitems').collapse();
				thisCtrl.getMain().getComponent('hiddenPanel').show();
				thisCtrl.getMain().getComponent('hiddenPanel').getComponent('gridContainer').getStore().loadRawData(publicJSON['gridData']);
			}
			else if (publicJSON.hasConfigDetails == false)
			{
				Ext.getCmp('hiddenPanel').hide();
				me.getErrorcontainer().update('<table border="0" height="400px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+publicJSON.errorText+'.</div></td></tr></table>');
				me.getErrorcontainer().show();
			}
		}
	},

	loadTools : function()
	{
		thisCtrl.getTools().loadIcon(
			true, //save
			true, //print
			true, //mail
			true, //csv
			true, //booklet
			true //schedule
		);
	},

	saveAsPDF : function()
	{
		//var getSaveObj = Ext.widget('savepdf');
		//getSaveObj.savePDF(config.urls.pdfURL);
		downloadAsPDF(config.urls.pdfURL);
	},

	printData : function()
	{
		var printQueryStr = publicJSON.printQueryStr;
		Ext.widget('print',{title : config.title.mainPageTitle}).show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set({
			src: printQueryStr
		});
	},

	saveAsCSV : function()
	{
		me = this;
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var ec_userOption = "";
		if (ec_criteria != 'Component')
		{
			 ec_userOption = Ext.getCmp('ec_userOption').getValue();
		}

		var urlStr = '../servlet/com.eg.EcCSVController';

		me.getFormitems().submit({
			url: urlStr,
			params: 'ec_criteria='+ec_criteria+'&ec_userOption='+encodeURIComponent(ec_userOption),
			standardSubmit : true,
			method: 'POST'
		});
	},

	sendMail : function()
	{
		Ext.widget('sendmail').show();
	},


	setschedule : function()
	{
		var op = "schedule";
		var me = this;
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var ec_userOption = Ext.getCmp('ec_userOption').getValue();
		var compTypeVal = Ext.getCmp('compType').getValue();
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);


		if (op == "schedule")
		{
			if (req_SaveSchedule != null && req_SaveSchedule == "saveSchedule")
			{
				var checkFlag = me.validateForm();
				if (checkFlag == false)
				{
					return false;
				}
				me.getFormitems().submit({
					url: '/final/config/EcSaveScheduleNew.jsp',
					params :"id="+id+"&ec_criteria="+ec_criteria+"&componentSelect="+compTypeVal+"&"+hiddenFields+"&ec_userOption="+encodeURIComponent(ec_userOption),

					standardSubmit : true,
					method: 'POST'
				});
			}
			else
			{
				var urlStr = "/final/config/EcSaveScheduleNew.jsp?id="+id+"&showWindow=yes&request_from=compsView&ec_criteria="+ec_criteria+"&componentSelect="+compTypeVal+"&"+hiddenFields+"&ec_userOption="+encodeURIComponent(ec_userOption)+"&com.eg.CSRF_NONCE="+csrfToken;
				scheduleWindow(urlStr);
			}
		}
		else if(op == "favorite")
		{
			window.location.href = "/final/config/EcSaveFavorite.jsp";
		}
		else
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,".Illegal Access");
			return false;
		}
	},

	
	setToolsState : function(iconState,compType)
	{
		me = this;
		var saveObj =me.getTools().getComponent('saveTool');
		var printObj =me.getTools().getComponent('printTool');
		var mailObj =me.getTools().getComponent('mailTool');
		var csvObj =me.getTools().getComponent('csvTool');
		var scheduleToolObj = me.getTools().getComponent('scheduleTool');
		var combineBookletObj = me.getTools().getComponent('bookletTool');
		if (!Ext.isEmpty(saveObj)){
			saveObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(printObj)){
			printObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(mailObj)){
			mailObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(csvObj)){
			csvObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(combineBookletObj)){
			combineBookletObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(scheduleToolObj) && compType != "-1"){
			scheduleToolObj.setDisabled(false);
		}
		else{
			scheduleToolObj.setDisabled(iconState);
		}
	},
	

	onChangeCompType : function()
	{
		Ext.getCmp('hiddenPanel').hide();
	},

	getInformations : function()
	{
		Ext.getCmp('hiddenPanel').hide();
		var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		var ec_userOption = me.getFormitems().getComponent('infoCont').getComponent('ec_userOption');
		var ec_criteria = me.getFormitems().getComponent('infoCont').getComponent('ec_criteria');
		var compTypeId = me.getFormitems().getComponent('infoCont').getComponent('compType');

		compTypeId.setDisabled(true);

		this.getFormitems().submit({
			url : config.urls.configServletURL,
			params :hiddenFields+"&cmd=ComponentsView&needData=yes&requestFrom="+strRequestFrom+"&request_from="+req_SaveSchedule+"&id="+id,
			method : 'POST',
			success : function(form, action){
				var publicJSON = Ext.decode(action.response.responseText);
				hiddenFieldsKeys = publicJSON.hiddenFields;
				ec_criteria.getStore().loadRawData(publicJSON.viewByList);
				ec_criteria.setValue(publicJSON.selectedEcOpt);

				if (publicJSON.selectedEcOpt != 'Component')
				{
					ec_userOption.getStore().loadRawData(publicJSON.specViewByList);
					ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
					ec_userOption.setValue(publicJSON['selectedUserOption']);
					ec_userOption.show();
				}
				else
				{
					ec_userOption.hide();
				}
				compTypeId.getStore().removeAll();
				compTypeId.getStore().loadRawData(publicJSON['CompTypeList']);
				compTypeId.setValue(publicJSON['selectedCompType']);
				delete publicJSON;
				compTypeId.setDisabled(false);
				me.setToolsState(true,publicJSON['selectedCompType']);
			},
			failure: function(form, action) // if result page doest not contain success:true, this method fires
			{
				Ext.MessageBox.alert("Ajax Failed","Error in updating details");
			}
		});
	},

	componentSearch : function()
	{
		//var hiddenFieldsKeys = publicJSON.hiddenFields;
		//var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var compTypeVal = Ext.getCmp('compType').getValue();
		var ec_userOption = Ext.getCmp('ec_userOption').getValue();

		if (req_SaveSchedule != null && req_SaveSchedule == "saveSchedule")
		{
			me.setschedule();
		}
		else
		{
			var checkFlag = me.validateForm();
			if (checkFlag == false)
			{
				return false;
			}
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
			myMask.show();

			this.getFormitems().submit({
				url: config.urls.servletURL,
				params :hiddenFields+ "&cmd=ComponentsView&needData=yes&requestFrom="+strRequestFrom+"&componentType="+compTypeVal+"&ec_criteria="+ec_criteria+"&ec_userOption="+encodeURIComponent(ec_userOption)+"&selectedType="+selectedType,
				method: 'POST',
				success: function(form,action)
				{
					myMask.hide();
					var jsonData = Ext.decode(action.response.responseText);
					publicJSON = jsonData;
					var title = jsonData['pageInfoCaption'];
					var gridData = jsonData['gridData'];
					Ext.getCmp('hiddenPanel').show();

					if (jsonData.errorText != null && jsonData.errorText != undefined)
					{
						Ext.getCmp('hiddenPanel').hide();
						me.getErrorcontainer().update('<table border="0" height="400px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+jsonData.errorText+'.</div></td></tr></table>');
						me.getErrorcontainer().show();
					}
					else
					{
						me.getErrorcontainer().hide();

						if(jsonData.chartData != null && jsonData.chartData != "")
						{
							Ext.getCmp('chartPlaceHolder').show();
							Ext.getCmp('chartPlaceHolder').loadChart(jsonData,me);
						}
						else
						{
							Ext.getCmp('chartPlaceHolder').hide();
						}

						Ext.getCmp('gridContainer').getStore().removeAll();
						Ext.getCmp('gridContainer').getStore().loadRawData(jsonData['gridData']);
					}

					if(jsonData.gridData == "")
					{
						me.setToolsState(true,jsonData['selectedCompType']);
					}
					else
					{
						Ext.getCmp('formitems').collapse();
						me.setToolsState(false,jsonData['selectedCompType']);
					}
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
					Ext.MessageBox.alert("Ajax Failed","Error in updating details");
				}
			});
		}
	},


	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+hiddenFields[key]+"&";
		}
		return hiddenQstr;
	},

	forwardRequestedURI : function()
	{
		if ( (req_SaveSchedule != "" && req_SaveSchedule == "saveSchedule") || (backOperation != null && backOperation.schedule != undefined && backOperation.schedule))
		{
			var me = this;
			hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			me.getFormitems().submit({
				url: '/final/config/EcSaveScheduleNew.jsp',
				params : 'request_from='+req_SaveSchedule+'&id='+id+'&'+hiddenFields,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if((backOperation != null && backOperation.home != undefined && backOperation.home))
		{
			var ec_criteria = backOperation.ec_criteria;
			var ec_userOption = backOperation.ec_userOption;
			window.location.href= '../servlet/com.eg.EcConfigurationServletNew?cmd=Home&ec_criteria='+ec_criteria+'&ec_userOption='+encodeURIComponent(ec_userOption);
		}
	},


	validateForm : function()
	{
		var tempCriteria = "";
		var tempUserOption = "";

		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var compTypeVal = Ext.getCmp('compType').getValue();
		var ec_userOption = Ext.getCmp('ec_userOption').getValue();
		
		if (ec_criteria != null && ec_criteria != undefined)
		{
			tempCriteria = ec_criteria;
		}
		if (ec_userOption != null && ec_userOption != undefined)
		{
			tempUserOption = ec_userOption;
		}
		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorZone);
					return false;
				}
				else if (tempCriteria == "Service")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorService);
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorSegment);
					return false;
				}
			}
		}
		if (ec_criteria != null && ec_criteria != undefined)
		{
			tempCriteria = ec_criteria;
		}
		if (ec_userOption != null && ec_userOption != undefined)
		{
			tempUserOption = ec_userOption;
		}

		if(compTypeVal =="-1")
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorCompType);
			return false;
		}
	}


});


function doCloseWin()
{
	Ext.getCmp('scheduleWin').destroy();
}



function loadURL(compType,compName)
{
	var criteria = Ext.getCmp('ec_criteria').getValue();
	var userOption = Ext.getCmp('ec_userOption').getValue();
	var cType = Ext.getCmp('compType').getValue();

	var request_from = "compsView";

	if (strRequestFrom == "Devices")
	{
		request_from = "Devices";
	}

	var tmpURI = "../servlet/com.eg.EcConfigurationServletNew?ec_rtype=Current&request_from="+request_from+"&old_comptype=" + compType + "&ec_comptype=" + compType + "&ec_component=" + encodeURIComponent(compName) + "&selectedType=" + selectedType + "&cType="+ cType + "&ec_criteria=" + criteria +"&requestFrom="+strRequestFrom+"&clickOn=&ec_trgttype=Configuration_Report&submitClicked=false&cmd=CurrentConfig&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken;

	if (criteria != 'Component')
	{
		var userOption = Ext.getCmp('ec_userOption').getValue();
		tmpURI = tmpURI + "&ec_userOption="+encodeURIComponent(userOption);
	}

	window.location.href= tmpURI;
}



