Ext.define('ConfigMgmtHome.controller.Main',{
	extend : 'Ext.app.Controller',

	views : [
		'FormItems',
		'OsBoxInfoChart',
		'DaywiseChangesChart',
		'ErrorContainer',
		'configutilities.Tools',
		'configutilities.PrintPreview',
		'configutilities.SendMail'
	],

	refs : [
		{
			selector : 'formitems', 
			ref : 'formitems'
		},
		{
			selector : 'osboxinfochart', 
			ref : 'osboxinfochart'
		},
		{
			selector : 'daywisechangeschart', 
			ref : 'daywisechangeschart'
		},
		{
			selector : 'tools', 
			ref : 'tools'
		},
		{
			selector : 'errorcontainer', 
			ref : 'errorcontainer'
		}
	],

	init : function()
	{
		thisCtrl = this;
		me = this;
		this.control({
			'formitems' :{
				'afterrender' : this.afterMainRender
			},
			'formitems combo[id="ec_criteria"]' :{
				'select' : this.goTo
			},
			'formitems combo[id="ec_userOption"]' :{
				'select' : this.goTo
			},
			'formitems combo[id="ec_osOption"]' :{
				'select' : this.getOSwiseMachineStatus
			},
			'formitems combo[id="NHour"]' :{
				'select' : this.goToChangeSummary
			},
			'formitems combo[id="ec_os_sw"]' :{
				'select' : this.getTopNSoftwareInstalls
			},
			'formitems combo[id="ec_os_hf"]' :{
				'select' : this.getTopNHotfixInstalls
			},
			'formitems combo[id="Hour"]' :{
				'select' : this.goToChangesAtAGlance
			},
			'formitems combo[id="componentType"]' :{
				'select' : this.goToDaywiseChangeDistribution
			},
			'formitems combo[id="duration"]' :{
				'select' : this.goToDaywiseChangeDistribution
			},
			'tools' :{
				'afterrender' : this.loadTools
			},
			'tools button[id="saveBtn"]' : {
				'click' : this.saveAsPDF
			},
			'tools button[id="printBtn"]' : {
				'click' : this.printData
			},
			'tools button[id="mailBtn"]' : {
				'click' : this.sendMail
			},
			'tools button[id="scheduleBtn"]' : {
				'click' : this.setschedule
			}
		});
	},


	afterMainRender : function()
	{
		var me = this;
		var ec_userOption = Ext.getCmp('ec_userOption');
		var ec_criteria = Ext.getCmp('ec_criteria');

		Ext.Ajax.request({
			url : config.urls.initialURL,
			params : queryString+"&needData=yes",
			method : 'POST',
			async : false,
			success : function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) 
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					hiddenFieldsKeys = publicJSON['hiddenFields'];

					ec_criteria.getStore().loadRawData(publicJSON['viewByList']);
					ec_criteria.setValue(publicJSON.selectedEcOpt);

					if (publicJSON.selectedEcOpt != 'Component')
					{
						ec_userOption.getStore().loadRawData(publicJSON['specViewByList']);
						ec_userOption.setValue(publicJSON.selectedUserOption);
						ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
						ec_userOption.show();
					}
					else
					{
						ec_userOption.hide();
					}


					if (publicJSON.hasRecords)
					{
						Ext.getCmp('column1').show();
						Ext.getCmp('column2').show();
						me.getErrorcontainer().hide();
						me.syncConfigDataByMachine('');
						me.syncConfigDataByComponentTypeSummary();
						me.syncConfigDataByTopNSoftwareAvails('afterMainRender','SoftwareList_cf');
						me.syncConfigDataByTopNHotfixesAvails('afterMainRender','HotFix_cf');
						me.syncConfigDataByChangesAtAGlance('afterMainRender');
						me.syncConfigDataByWeekChanges();
						setInterval('thisCtrl.onRefresh()',120000);
					}
					else
					{
						Ext.getCmp('column1').hide();
						Ext.getCmp('column2').hide();
						me.getErrorcontainer().show();
						me.getErrorcontainer().update('<table border="0" height="360px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+publicJSON.errorText+'.</div></td></tr></table>');
					}
					var hasAssociatedComp = publicJSON["hasRecords"];
					if (!hasAssociatedComp)
					{
						me.setToolsState();
					}
					delete publicJSON;
				}
			}
		});
	},

	syncConfigDataByMachine : function(osOption)
	{
		var parameters = "";
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var userOption = "";
		var me = this;

		if (ec_criteria != 'Component')
		{
			userOption = Ext.getCmp('ec_userOption').getValue();
		}

		var urlString = config.urls.servletURL;
		parameters = "needData=yes&cmd=OswiseComponentStatus&ec_criteria="+ec_criteria+"&ec_userOption="+encodeURIComponent(userOption);

		if (osOption.length > 0)
		{
			if (osOption == "OS")
			{
				parameters = parameters + "&version=No";
			}
			else if(osOption == "OSVersion")
			{
				parameters = parameters + "&version=Yes";
			}
			else if(osOption == "NetworkDevices")
			{
				parameters = parameters + "&machines=NetworkDevices";
			}
			else if(osOption == "Virutualization")
			{
				parameters = parameters + "&machines=Virutualization";
			}
		}

		parameters = parameters + "&"+Math.random();

		//var myMask = new Ext.LoadMask(Ext.getCmp('machineCtn'), {msg: 'Loading...'});
		//myMask.show();

		Ext.Ajax.request({
		
			url : urlString,
			params: parameters,
			method : 'POST',
			success : function(response)
			{
				//myMask.hide();

				if (response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var chartData = jsonData.chartData;
					var errorText = jsonData.errorText;

					Ext.getCmp('ec_osOption').getStore().removeAll();
					Ext.getCmp('machineCtn').setTitle('<a id="mouse" href="'+jsonData.HeaderLink+'" target="main" class="eg_monlink">'+jsonData.headerLinkText+'</a>');
					Ext.getCmp('ec_osOption').getStore().loadRawData(jsonData.ecOSOptionArr);
					Ext.getCmp('ec_osOption').setValue(jsonData.SelectedEcOSOptionText);

					osOption = Ext.getCmp('ec_osOption').getValue();

					if (errorText != null && errorText != undefined && errorText != "")
					{
						Ext.getCmp('byMachineOSVersionGrid').hide();
						me.getOsboxinfochart().hide();
						Ext.getCmp('resultCntByMachine').removeAll();
						Ext.getCmp('resultCntByMachine').add({
							xtype : 'errorcontainer',
							html : "<table border='0' width='100%' align='center' height='180px'><tr><td align='center' valign=middle><img src='/final/images/spacer.gif' class='iconInformation' valign='middle' /><div class='commonErrorMsgText'>" +errorText+ "</div></td></tr></table>"
						});
					}
					else
					{
						Ext.getCmp('resultCntByMachine').removeAll();
						me.getErrorcontainer().hide();
						if(osOption == "OS" || osOption == "")
						{
							Ext.getCmp('byMachineOSVersionGrid').hide();
							if (chartData != null && chartData != "" && chartData != undefined)
							{
								me.getOsboxinfochart().show();
								me.getOsboxinfochart().loadChart(jsonData,me);
							}
							else
							{
								me.getOsboxinfochart().hide();
							}
						}
						else if(osOption == "OSVersion")
						{
							me.getOsboxinfochart().hide();
							Ext.getCmp('byMachineOSVersionGrid').show();
							Ext.getCmp('displayMessage1').update('<div style="padding:2px;" class="font_bold11" align="center">'+jsonData.gridTitle+'</div>');

							if(jsonData.gridArr != "" && jsonData.gridArr != null && jsonData.gridArr != undefined)
							{
								Ext.getCmp('byMachineOSVersionGrid').getStore().loadRawData(jsonData.gridArr);
							}
							else
							{
								Ext.getCmp('byMachineOSVersionGrid').getView().emptyText = "<table border='0' width='100%' height='100px'><tr><td align=center valign=middle><img src='/final/images/spacer.gif' class='iconInformation' valign='middle' /><div class='commonErrorMsgText'>" + jsonData.errorText + "</div></td></tr></table>";
							}
						}
						else if(osOption == "NetworkDevices")
						{
							Ext.getCmp('byMachineOSVersionGrid').hide();
							if (chartData != null && chartData != "" && chartData != undefined)
							{
								me.getOsboxinfochart().show();
								me.getOsboxinfochart().loadChart(jsonData,me);
							}
							else
							{
								me.getOsboxinfochart().hide();
							}
						}
						else if(osOption == "Virutualization")
						{
							Ext.getCmp('byMachineOSVersionGrid').hide();
							if (chartData != null && chartData != "" && chartData != undefined)
							{
								me.getOsboxinfochart().show();
								me.getOsboxinfochart().loadChart(jsonData,me);
							}
							else
							{
								me.getOsboxinfochart().hide();
							}
						}
					}
				}
			}
		});
	},


	syncConfigDataByComponentTypeSummary : function(time)
	{
		var parameters = "";
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var userOption = "";
		var me = this;

		if (ec_criteria != 'Component')
		{
			userOption = Ext.getCmp('ec_userOption').getValue();
		}

		var urlString = config.urls.servletURL;
		parameters = "needData=yes&cmd=DashboardChangeSummary&ec_criteria="+ec_criteria+"&ec_userOption="+encodeURIComponent(userOption);

		if (time != null && time != undefined)
		{
			parameters = parameters + "&NHour="+time;
		}

		parameters = parameters + "&"+Math.random();
		//var myMask = new Ext.LoadMask(Ext.getCmp('changeSummary'), {msg: 'Loading...'});
		//myMask.show();

		Ext.Ajax.request({
			url : urlString,
			params: parameters,
			method : 'POST',
			success : function(response)
			{
				//myMask.hide();
				var jsonData = Ext.decode(response.responseText);
				Ext.getCmp('NHour').getStore().removeAll();
				Ext.getCmp('NHour').getStore().loadRawData(jsonData.timeLineArr);
				Ext.getCmp('NHour').setValue(jsonData.selectedTime);
				if(jsonData.gridTitle != "" && jsonData.gridTitle != null && jsonData.gridTitle != undefined)
				{
					Ext.getCmp('changeSummaryGrid').setTitle('<span style="font-weight:500"><a id="mouse" href="'+jsonData.HeaderLink+'" target="main" class="eg_monlink">'+jsonData.HeaderText+'</a>' + '&nbsp;('+jsonData.gridTitle+')</span>');
				}
				else
				{
					Ext.getCmp('changeSummaryGrid').setTitle('<span style="font-weight:500"><a id="mouse" href="'+jsonData.HeaderLink+'" target="main" class="eg_monlink">'+jsonData.HeaderText+'</a></span>');
				}

				//if(jsonData.gridTitle != "" && jsonData.gridTitle != null && jsonData.gridTitle != undefined)
				//{
					//Ext.getCmp('displayMessage').show();
					//Ext.getCmp('displayMessage').update('<div style="padding:2px;" class="font_bold11">'+jsonData.gridTitle+'</div>');
				//}
				//else
				//{
					//Ext.getCmp('displayMessage').hide();
				//}
				Ext.getCmp('changeSummaryGrid').getStore().loadRawData(jsonData.gridArr);
				delete jsonData;
			},
			failure : function()
			{
				//myMask.hide();
			}
		});
	},



	syncConfigDataByTopNSoftwareAvails : function(from,testName,osname)
	{
		var parameters = "";
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var userOption = "";
		var me = this;

		if (ec_criteria != 'Component')
		{
			userOption = Ext.getCmp('ec_userOption').getValue();
		}

		var urlString = config.urls.servletURL;
		parameters = "needData=yes&cmd=TopNAvailability&ec_criteria="+ec_criteria+"&ec_userOption="+encodeURIComponent(userOption);
		
		if (from != null && from != "" && from != undefined && from.toLowerCase() != "aftermainrender")
		{
			if (osname != null && osname != undefined)
			{
				parameters = parameters + "&osName="+osname;
			}
		}
		parameters = parameters +"&testName="+testName + "&"+Math.random();

		//var myMask = new Ext.LoadMask(Ext.getCmp('topNSoftwares'), {msg: 'Loading...'});
		//myMask.show();

		Ext.Ajax.request({
			url : urlString,
			params: parameters,
			method : 'POST',
			success : function(response)
			{
				//myMask.hide();

				if (response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonData = Ext.decode(response.responseText);
					var ec_osObj = Ext.getCmp('ec_os_sw');
					ec_osObj.getStore().removeAll();
					ec_osObj.getStore().loadRawData(jsonData.ec_os);
					ec_osObj.setValue(jsonData.selectedEcOS);

					Ext.getCmp('sofwareInstallsGrid').setTitle('<span style="font-weight:500"><a id="mouse" href="'+jsonData.HeaderLink+'" target="main" class="eg_monlink">'+jsonData.HeaderText+'</a></span>');
					Ext.getCmp('headerText_sw').setValue('<span style="font-size:12px;font-weight:500">'+jsonData.SystemLabel+'</span>');
					Ext.getCmp('sofwareInstallsGrid').getStore().loadRawData(jsonData.TopNInstallsArr);
					delete jsonData;
				}
			},
			failure : function()
			{
				//myMask.hide();
			}
		});
	},


	syncConfigDataByTopNHotfixesAvails : function(from,testName,osname)
	{
		var parameters = "";
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var userOption = "";
		var me = this;

		if (ec_criteria != 'Component')
		{
			userOption = Ext.getCmp('ec_userOption').getValue();
		}

		var urlString = config.urls.servletURL;
		parameters = "needData=yes&cmd=TopNAvailability&ec_criteria="+ec_criteria+"&ec_userOption="+encodeURIComponent(userOption);
		
		if (from != null && from != "" && from != undefined && from.toLowerCase() != "aftermainrender")
		{
			if (osname != null && osname != undefined)
			{
				parameters = parameters + "&osName="+osname;
			}
		}
		parameters = parameters +"&testName="+testName + "&"+Math.random();

		Ext.Ajax.request({
		
			url : urlString,
			params: parameters,
			method : 'POST',
			success : function(response)
			{
				if (response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonData = Ext.decode(response.responseText);
					var ec_osObj = Ext.getCmp('ec_os_hf');
					ec_osObj.getStore().removeAll();
					ec_osObj.getStore().loadRawData(jsonData.ec_os);
					ec_osObj.setValue(jsonData.selectedEcOS);

					Ext.getCmp('hotfixInstallsGrid').setTitle('<span style="font-weight:500"><a id="mouse" href="'+jsonData.HeaderLink+'" target="main" class="eg_monlink">'+jsonData.HeaderText+'</a></span>');
					Ext.getCmp('headerText_hf').setValue('<span style="font-size:12px;font-weight:500">'+jsonData.SystemLabel+'</span>');
					//Ext.getCmp('headerText_hf').setText(jsonData.SystemLabel);
					Ext.getCmp('hotfixInstallsGrid').getStore().loadRawData(jsonData.TopNInstallsArr);
					delete jsonData;
				}
			},
			failure : function()
			{
			}
		});
	},


	syncConfigDataByChangesAtAGlance : function(from,hour)
	{
		var parameters = "";
		var me = this;
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var userOption = "";

		if (ec_criteria != 'Component')
		{
			userOption = Ext.getCmp('ec_userOption').getValue();
		}

		var urlString = config.urls.servletURL;
		parameters = "needData=yes&cmd=DashboardChangesAtAGlance&ec_criteria="+ec_criteria+"&ec_userOption="+encodeURIComponent(userOption);

		if (from != null && from != "" && from != undefined && from.toLowerCase() != "aftermainrender")
		{
			if (hour != "" && hour != null && hour != undefined)
			{
				parameters = parameters + "&NHour="+hour;
			}
		}

		parameters = parameters + "&"+Math.random();

		Ext.Ajax.request({
			url : urlString,
			params: parameters,
			method : 'POST',
			success : function(response)
			{
				var jsonData = Ext.decode(response.responseText);
				var hourObj = Ext.getCmp('Hour');
				hourObj.getStore().removeAll();
				hourObj.getStore().loadRawData(jsonData.timeLineArr);
				hourObj.setValue(jsonData.selectedTime);

				if(jsonData.gridTitle != "" && jsonData.gridTitle != null && jsonData.gridTitle != undefined)
				{
					Ext.getCmp('changeAtAGlanceGrid').setTitle('<span style="font-weight:500"><a id="mouse" href="'+jsonData.HeaderLink+'" target="main" class="eg_monlink">'+jsonData.HeaderText+'</a>' + '&nbsp;('+jsonData.gridTitle+')</span>');
				}
				else
				{
					Ext.getCmp('changeAtAGlanceGrid').setTitle('<span style="font-weight:500"><a id="mouse" href="'+jsonData.HeaderLink+'" target="main" class="eg_monlink">'+jsonData.HeaderText+'</a></span>');
				}

				Ext.getCmp('changeAtAGlanceGrid').getStore().loadRawData(jsonData.gridValues);
				delete jsonData;
			},
			failure : function()
			{
				//myMask.hide();
			}

		});
	},


	syncConfigDataByWeekChanges : function(compType,timeDuration)
	{
		var parameters = "";
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var userOption = "";
		var me = this;

		if (ec_criteria != 'Component')
		{
			userOption = Ext.getCmp('ec_userOption').getValue();
		}

		var urlString = config.urls.servletURL;
		parameters = "needJsonData=yes&cmd=DashboardDaywiseChangeDistribution&ec_criteria="+ec_criteria+"&ec_userOption="+encodeURIComponent(userOption);

		if (compType != null && compType != undefined)
		{
			parameters = parameters + "&componentType="+compType+"&duration="+timeDuration;
		}

		parameters = parameters + "&"+Math.random();
		//var myMask = new Ext.LoadMask(Ext.getCmp('changesovertime'), {msg: 'Loading...'});
		//myMask.show();

		Ext.Ajax.request({
			url : urlString,
			params: parameters,
			method : 'POST',
			success : function(response)
			{
				//myMask.hide();
				var jsonData = Ext.decode(response.responseText);

				Ext.getCmp('changesovertime').setTitle('<a id="mouse" href="'+jsonData.HeaderLink+'" target="main" class="eg_monlink">'+jsonData.HeaderText+'</a>');

				var componentTypeObj = Ext.getCmp('componentType');
				componentTypeObj.getStore().removeAll();
				componentTypeObj.getStore().loadRawData(jsonData.serverList);
				if(jsonData.selectedServer != null && jsonData.selectedServer != "" && jsonData.selectedServer != undefined)
				{
					componentTypeObj.setValue(jsonData.selectedServer);
				}
				else
				{
					componentTypeObj.setValue(jsonData.serverList[0].valueField);
				}

				var durationObj = Ext.getCmp('duration');
				durationObj.getStore().removeAll();
				durationObj.getStore().loadRawData(jsonData.durationList);
				durationObj.setValue(jsonData.selectedDuration);

				//if(jsonData.hasConfigDetails)
				//{
					//Ext.getCmp('configDockItemDaywise').show();
					//Ext.getCmp('daywiseChartTitle').update(jsonData.chartTitle);
				//}
				//else
				//{
					//Ext.getCmp('configDockItemDaywise').hide();
				//}

				Ext.getCmp('daywiseChartCnt').removeAll();
				Ext.getCmp('daywiseChartCnt').add({xtype : 'daywisechangeschart'});
				me.getDaywisechangeschart().loadChart(jsonData,me);
				delete jsonData;
			},
			failure : function()
			{
				//myMask.hide();
			}
		});
	},


	goTo : function(obj)
	{
		var from = obj.getId();
		var me = this;
		var ecOpt = Ext.getCmp('ec_criteria').getValue();
		var usrOpt = "";
		if (ecOpt != 'Component')
		{
			usrOpt = Ext.getCmp('ec_userOption').getValue();
		}
		me.initConfigController(ecOpt,usrOpt,from);
	},


	initConfigController : function(ecOpt,usrOpt,from)
	{
		var parameters = "";
		var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		var me = this;
		var urlStr = config.urls.initialURL;
		parameters = "ec_criteria="+ecOpt+"&"+hiddenFields;
		if (usrOpt != null && usrOpt.length > 0 && usrOpt != undefined)
		{
			parameters = parameters + "&ec_userOption="+usrOpt;
		}

		var ec_criteria = Ext.getCmp('ec_criteria');
		var ec_userOption = Ext.getCmp('ec_userOption');

		Ext.Ajax.request({
			url : urlStr,
			params: parameters,
			method : 'POST',
			success : function(response)
			{
				publicJSON = Ext.decode(response.responseText);
				ec_criteria.getStore().loadRawData(publicJSON['viewByList']);
				ec_criteria.setValue(publicJSON.selectedEcOpt);

				if (publicJSON.selectedEcOpt != 'Component')
				{
					ec_userOption.getStore().loadRawData(publicJSON['specViewByList']);
					ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
					if(from == "ec_criteria")
					{
						ec_userOption.setValue(publicJSON['selectedUserOption']);
					}
					ec_userOption.show();
				}
				else
				{
					ec_userOption.hide();
				}
				if (publicJSON.hasRecords)
				{
					Ext.getCmp('column1').show();
					Ext.getCmp('column2').show();
					me.getErrorcontainer().hide();

					me.syncConfigDataByMachine("");
					me.syncConfigDataByComponentTypeSummary();
					me.syncConfigDataByTopNSoftwareAvails("initConfigController","SoftwareList_cf");
					me.syncConfigDataByTopNHotfixesAvails("initConfigController","HotFix_cf");
					me.syncConfigDataByChangesAtAGlance("initConfigController");
					me.syncConfigDataByWeekChanges();
				}
				else
				{
					Ext.getCmp('column1').hide();
					Ext.getCmp('column2').hide();
					me.getErrorcontainer().show();
					me.getErrorcontainer().update('<table border="0" height="360px" width="100%"><tr><td align=center valign=bottom><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">.</div></td></tr></table>');
				}
				delete publicJSON;
			},
			failure : function()
			{
			}
		});
	},


	getOSwiseMachineStatus : function()
	{
		var me = this;
		var ec_osOption = Ext.getCmp('ec_osOption').getValue();
		if (ec_osOption != null && ec_osOption != undefined)
		{
			me.syncConfigDataByMachine(ec_osOption);
		}
	},

	goToChangeSummary : function()
	{
		var me = this;
		var NHour = Ext.getCmp('NHour').getValue();
		if (NHour != null && NHour != undefined)
		{
			me.syncConfigDataByComponentTypeSummary(NHour);
		}
	},

	getTopNSoftwareInstalls : function()
	{
		var me = this;
		var osValue = Ext.getCmp('ec_os_sw').getValue();
		if (osValue != null && osValue != undefined)
		{
			me.syncConfigDataByTopNSoftwareAvails("osChange","SoftwareList_cf",osValue);
		}
	},

	getTopNHotfixInstalls : function()
	{
		var me = this;
		var osValue = Ext.getCmp('ec_os_hf').getValue();
		if (osValue != null && osValue != undefined)
		{
			me.syncConfigDataByTopNHotfixesAvails("osChange","HotFix_cf",osValue);
		}
	},

	goToChangesAtAGlance : function()
	{
		var me = this;
		var time = Ext.getCmp('Hour').getValue();
		if (time != null && time != undefined)
		{
			me.syncConfigDataByChangesAtAGlance("onchangeduration",time);
		}
	},


	goToDaywiseChangeDistribution : function()
	{
		var me = this;
		var componentType = Ext.getCmp('componentType').getValue();
		var duration = Ext.getCmp('duration').getValue();
		if (componentType != null && componentType != undefined && duration != null && duration != undefined)
		{
			me.syncConfigDataByWeekChanges(componentType,duration);
		}
	},


	onRefresh : function()
	{
		var me = this;
		me.getOSwiseMachineStatus();
		me.getTopNSoftwareInstalls();
		me.getTopNHotfixInstalls();
		me.goToChangeSummary();
		me.goToChangesAtAGlance();
		me.goToDaywiseChangeDistribution();
	},


	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			hiddenQstr += key+"="+hiddenFields[key]+"&";
		}
		return hiddenQstr;
	},

	loadTools : function()
	{
		var me = this;
		thisCtrl.getTools().loadIcon(true,true,true,false,true,true);
	},

	setToolsState : function(iconState)
	{
		Ext.getCmp("toolbar").hide();
		Ext.getCmp("configDbId").hide();
	},

	printData : function()
	{
		var printQueryStr = publicJSON.printQueryStr;
		Ext.widget('print',{title : config.title.mainPageTitle}).show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set({
			src: printQueryStr
		});
	},

	saveAsPDF : function()
	{
		downloadAsPDF(config.urls.pdfURL)
	},

	sendMail : function()
	{
		Ext.widget('sendmail').show();
	},

	setschedule : function()
	{
		var schQueryStr = publicJSON.schQueryStr;
		scheduleWindow(schQueryStr);
	}
});

function doCloseWin()
{
	Ext.getCmp("scheduleWin").destroy();
}


