Ext.define('ConfigMgmtHome.view.FormItems', {
	extend : 'Ext.form.Panel',
	alias : 'widget.formitems',
	id : 'formitems',
	cls:'outerpanel',
	margin: '8 8 0 8',
	title: 'Dashboard',

	layout: {
		type: 'hbox',
		pack: 'center',
		align: 'stretch'
	},

	requires : [
		'utilities.ScrollCombo',
		'utilities.CommonPanel',
		'ConfigMgmtHome.view.OsBoxInfoChart',
		'ConfigMgmtHome.view.DaywiseChangesChart',
		'utilities.CustomGrid',
		'Ext.grid.feature.Grouping',
		'Ext.grid.*',
		'configutilities.Tools'
	],

	tools : [
		{
			xtype : 'combo',
			fieldLabel : config.title.viewByTitle,
			labelSeparator : '',
			cls: "dropdown",
			editable: false,
			width: 170,
			labelWidth : 60,
			margin : '0 5 0 0',
			name: "ec_criteria",
			id: "ec_criteria",
			displayField: "displayField",
			valueField: "valueField",
			queryMode: "local",
			store: new Ext.create("Ext.data.Store", {
				fields: ["displayField", "valueField"],
				data: []
			})
		},
		{
			xtype: "scrollcombo",
			cls: "dropdown",
			fieldLabel : 'Zone',
			labelSeparator : '',
			hidden : true,
			width: 260,
			labelWidth : 60,
			margin : '0 5 0 15',
			name: "ec_userOption",
			id: "ec_userOption",
			displayField: "displayField",
			valueField: "valueField",
			queryMode: "local",
			store: new Ext.create("Ext.data.Store", {
				fields: ["displayField", "valueField"],
				data: []
			})
		},
		{
			xtype:'tbseparator',
			id: 'configDbId'
		},
		{
			xtype : 'tools'
		}
	],

	items : [
		{
			xtype: 'container',
			id : 'column1',
			border: false,
			style: 'border: 1px solid blue',
			layout : {
				type : 'vbox',
				align : 'stretch'
			},
			flex: 0.5,
			items: [
				{
					xtype : 'panel',
					id : 'machineCtn',
					cls : 'containerShadow config_containerShadow',
					margin:'10 5 5 10',
					title : config.title.row1col1title,
					//autoScroll : false,
					flex:.33,
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					tools :[
						{
							xtype: "combo",
							cls: "dropdown",
							width: 130,
							name: "ec_osOption",
							id: "ec_osOption",
							displayField: "displayField",
							valueField: "valueField",
							queryMode: "local",
							store: new Ext.create("Ext.data.Store", {
								fields: ["displayField", "valueField"],
								data: []
							}),
							editable : false
						}
					],
					items: [
						{
							xtype: 'osboxinfochart',
							bodyPadding:'0'
						},
						{
							xtype : 'customgrid',
							frame:false,
							hidden : true,
							flex : 1,
							cls:'gridSkin',
							scroll: true,
							autoScroll: true,
							id: 'byMachineOSVersionGrid',
							defaults: {
								menuDisabled: true,
								draggable: false,
								resizable: false
							},

							emptyText: "<table border='0' width='100%' height='30px'><tr><td align=center valign=top><img src='/final/images/spacer.gif' class='iconInformation' valign='middle' /><div class='commonErrorMsgText'>" + 'No configuration changes found.' + "</div></td></tr></table>",

							viewConfig: {
								deferEmptyText: false
							},

							store: new Ext.data.Store({
								fields: ['OS','Version','Count'],
								data: [],
								groupField: 'OS',
								sortOnLoad : false
							}),

							features: [{
								ftype: 'grouping',
								id : 'osWiseGrouping',
								groupHeaderTpl: [
									'<div class="ux-grow-action-text">{name:this.formatOSName}',
									{
										formatOSName: function(name) {
											var compArr = name.split("#$#");
											return '<a id="mouse" href="'+compArr[2]+'" target="main" class="eg_monlink">'+compArr[0] + " (" +compArr[1]+")"+'</a></div>';
										}
									}
								],
								hideGroupedHeader: false,
								startCollapsed: false
							}],

							tools: [{
								xtype:'container',
								id : 'displayMessage1',
								html:'Total Systems'
							},{
								xtype : 'tbfill'
							},{
								xtype: 'button',
								id : 'te',
								name : 'te',
								iconCls: 'iconExpandAll',
								hidden:true,
								style: {
									background: 'none',
									border: '0px'
								},
								listeners: {
									'click':function(obj){
										this.hide();
										Ext.getCmp('tc').show();
										var thisGrid = Ext.getCmp('byMachineOSVersionGrid');
										var groupingFeature = thisGrid.view.getFeature('osWiseGrouping');
										groupingFeature.expandAll();
									}
								}
							},{
									xtype:'button',
									id :'tc',
									name :'tc',
									iconCls: 'iconCollapseAll',
									hidden:false,
									style: {
										background: 'none',
										border: '0px'
									},
									listeners:{
									'click':function(obj){
										this.hide();
										Ext.getCmp('te').show();
										var thisGrid = Ext.getCmp('byMachineOSVersionGrid');
										var groupingFeature = thisGrid.view.getFeature('osWiseGrouping');
										groupingFeature.collapseAll();
									}
								}
							}],

							columns: {
								defaults: {
									sortable: false,
									hideable: false,
									menuDisabled: true,
									draggable: false,
									resizable: false
								},
								items : [
									{
										header : config.title.byOSVersionGridColLabel2,
										dataIndex : 'Version',
										menuDisabled : true,
										flex : 3,
										renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
										{
											var version = value.split("#$#");
											metaData.tdAttr = 'data-qtip="' + version[0] + '"';
											var tmpTag = '<a id="mouse" href="'+version[1]+'" target="main" class="eg_monlink">'+version[0]+'</a>';
											return tmpTag;
										}
									},
									{
										header : config.title.byOSVersionGridColLabel3,
										dataIndex : 'Count',
										menuDisabled : true,
										flex : 1,
										renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
										{
											var count = value.split("#$#");
											var tmpTag = '<a id="mouse" href="'+count[1]+'" target="main" class="eg_monlink">'+count[0]+'</a>';
											return tmpTag;
										}
									}
								]
							}
						},
						{
							xtype : 'container',
							id : 'resultCntByMachine'
						}
					]
				},
				{
					xtype : 'customgrid',
					frame:false,
					flex:.33,
					margin: '5 5 5 10',
					cls:'gridSkin',
					scroll: true,
					autoScroll: true,
					id: 'sofwareInstallsGrid',
					title: 'Top N Installed Softwares',
					defaults: {
						menuDisabled: true,
						draggable: false,
						resizable: false
					},
					emptyText: "<table border='0' width='100%' height='134px'><tr><td align=center valign=middle><img src='/final/images/spacer.gif' class='iconInformation' valign='middle' /><div class='commonErrorMsgText'>" + 'No data available' + "</div></td></tr></table>",
					viewConfig: {
						deferEmptyText: false
					},
					store: new Ext.data.Store({
						fields: ['Name', 'count','hiddenCol'],
						data: []
					}),
					columns: {
						defaults: {
							sortable: false,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false
						},
						items : [
							{
								header : config.title.topninstallsGridLabel1,
								dataIndex : 'Name',
								menuDisabled : true,
								width : 390,
								renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
								{
								
									var tmpTag = '<a id="mouse" href="'+record.get("hiddenCol")+'" target="main" class="eg_monlink">'+value+'</a>';
									return tmpTag;
								}
							},
							{
								header : config.title.topninstallsGridLabel2,
								dataIndex : 'count',
								menuDisabled : true,
								flex : 1,
								renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
								{
								
									var tmpTag = '<a id="mouse" href="'+record.get("hiddenCol")+'" target="main" class="eg_monlink">'+value+'</a>';
									return tmpTag;
								}
							},
							{
								header : 'hiddenCol',
								dataIndex : 'hiddenCol',
								menuDisabled : true,
								hidden : true
							}
						]
					},
					tools: [
						{
							xtype: "scrollcombo",
							cls: "dropdown",
							width: 200,
							name: "ec_os_sw",
							id: "ec_os_sw",
							displayField: "displayField",
							valueField: "valueField",
							queryMode: "local",
							store: new Ext.create("Ext.data.Store", {
								fields: ["displayField", "valueField"],
								data: []
							})
						},
						{
							xtype : 'displayfield',
							id : 'headerText_sw',
							margin : '0 0 0 5'
						}
					]
				},
				{
					xtype : 'customgrid',
					frame:false,
					flex:.34,
					margin: '5 5 10 10',
					cls:'gridSkin',
					scroll: true,
					autoScroll: true,
					id: 'hotfixInstallsGrid',
					title: 'Top N Installed Hotfixes',
					defaults: {
						menuDisabled: true,
						draggable: false,
						resizable: false
					},
					emptyText: "<table border='0' width='100%' height='134px'><tr><td align=center valign=middle><img src='/final/images/spacer.gif' class='iconInformation' valign='middle' /><div class='commonErrorMsgText'>" + 'No data available' + "</div></td></tr></table>",
					viewConfig: {
						deferEmptyText: false
					},
					store: new Ext.data.Store({
						fields: ['Name', 'count','hiddenCol'],
						data: []
					}),
					columns: {
						defaults: {
							sortable: false,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false
						},
						items : [
							{
								header : config.title.topninstallsGridLabel1,
								dataIndex : 'Name',
								menuDisabled : true,
								width : 390,
								renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
								{
								
									var tmpTag = '<a id="mouse" href="'+record.get("hiddenCol")+'" target="main" class="eg_monlink">'+value+'</a>';
									return tmpTag;
								}
							},
							{
								header : config.title.topninstallsGridLabel2,
								dataIndex : 'count',
								menuDisabled : true,
								flex : 1,
								renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
								{
								
									var tmpTag = '<a id="mouse" href="'+record.get("hiddenCol")+'" target="main" class="eg_monlink">'+value+'</a>';
									return tmpTag;
								}
							},
							{
								header : 'hiddenCol',
								dataIndex : 'hiddenCol',
								menuDisabled : true,
								hidden : true
							}
						]
					},
					tools: [
						{
							xtype: "scrollcombo",
							cls: "dropdown",
							width: 200,
							name: "ec_os_hf",
							id: "ec_os_hf",
							displayField: "displayField",
							valueField: "valueField",
							queryMode: "local",
							store: new Ext.create("Ext.data.Store", {
								fields: ["displayField", "valueField"],
								data: []
							})
						},
						{
							xtype : 'displayfield',
							id : 'headerText_hf',
							margin : '0 0 0 5'
						}
					]
				}
			]
		},
		{
			xtype: 'container',
			id : 'column2',
			border: false,
			style: 'border: 1px solid green',
			layout : {
				type : 'vbox',
				align : 'stretch'
			},
			flex: 0.5,
			items: [
				{
					xtype : 'customgrid',
					frame:false,
					margin:'10 10 5 5',
					flex:.33,
					cls:'gridSkin',
					scroll: true,
					autoScroll: true,
					id: 'changeSummaryGrid',
					title: 'Change Summary',
					defaults: {
						menuDisabled: true,
						draggable: false,
						resizable: false
					},
					emptyText: "<table border='0' width='100%' height='134px'><tr><td align='center' valign='middle'><img src='/final/images/spacer.gif' class='iconInformation' valign='middle' /><div class='commonErrorMsgText'>" + 'No configuration changes found.' + "</div></td></tr></table>",
					viewConfig: {
						deferEmptyText: false
					},
					store: new Ext.data.Store({
						fields: ['componentType', 'count','hiddenCol'],
						data: []
					}),
					columns: {
						defaults: {
							sortable: false,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false
						},
						items : [
							{
								header : config.title.changesummaryGridLabel1,
								dataIndex : 'componentType',
								menuDisabled : true,
								width : 350,
								renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
								{
								
									var tmpTag = '<a id="mouse" href="'+record.get("hiddenCol")+'" target="main" class="eg_monlink">'+value+'</a>';
									return tmpTag;
								}
							},
							{
								header : config.title.changesummaryGridLabel2,
								dataIndex : 'count',
								menuDisabled : true,
								flex: 1,
								renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
								{
								
									var tmpTag = '<a id="mouse" href="'+record.get("hiddenCol")+'" target="main" class="eg_monlink">'+value+'</a>';
									return tmpTag;
								}
							},
							{
								header : 'hiddenCol',
								dataIndex : 'hiddenCol',
								menuDisabled : true,
								hidden : true
							}
						]
					},
					tools: [
						{
							xtype: "combo",
							cls: "dropdown",
							editable: false,
							width: 100,
							name: "NHour",
							id: "NHour",
							displayField: "displayField",
							valueField: "valueField",
							queryMode: "local",
							store: new Ext.create("Ext.data.Store", {
								fields: ["displayField", "valueField"],
								data: []
							})
						}
					]
				},
				{
					xtype : 'customgrid',
					frame:false,
					margin: '5 10 5 5',
					flex:.33,
					cls:'gridSkin',
					scroll: true,
					autoScroll: true,
					id: 'changeAtAGlanceGrid',
					defaults: {
						menuDisabled: true,
						draggable: false,
						resizable: false
					},
					emptyText: "<table border='0' width='100%' align='center' height='134px'><tr><td align='center' valign=middle><img src='/final/images/spacer.gif' class='iconInformation' valign='middle' /><div class='commonErrorMsgText'>" + 'No configuration changes found.' + "</div></td></tr></table>",
					viewConfig: {
						deferEmptyText: false
					},
					store: new Ext.data.Store({
						fields: ['componentName', 'count','changein','hiddenCol'],
						data: []
					}),
					columns: {
						defaults: {
							sortable: false,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false
						},
						items : [
							{
								header : config.title.changeAtAGlanceGridLabel1,
								dataIndex : 'componentName',
								menuDisabled : true,
								//width : 250,
								flex : 1,
								renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
								{
									metaData.tdAttr = 'data-qtip="' + value + '"';
									var tmpTag = '<a id="mouse" href="'+record.get("hiddenCol")+'" target="main" class="eg_monlink">'+value+'</a>';
									return tmpTag;
								}
							},
							{
								header : config.title.changeAtAGlanceGridLabel2,
								dataIndex : 'count',
								menuDisabled : true,
								width : 70,
								renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
								{
									var tmpTag = '<a id="mouse" href="'+record.get("hiddenCol")+'" target="main" class="eg_monlink">'+value+'</a>';
									return tmpTag;
								}
							},
							{
								header : config.title.changeAtAGlanceGridLabel3,
								dataIndex : 'changein',
								menuDisabled : true,
								flex : 1,
								renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
								{
									metaData.tdAttr = 'data-qtip="' + value + '"';
									var tmpTag = '<a id="mouse" href="'+record.get("hiddenCol")+'" target="main" class="eg_monlink">'+value+'</a>';
									return tmpTag;
								}
							},
							{
								header : 'hiddenCol',
								dataIndex : 'hiddenCol',
								menuDisabled : true,
								hidden : true
							}
						]
					},
					tools: [
						{
							xtype: "combo",
							cls: "dropdown",
							editable: false,
							width: 100,
							name: "Hour",
							id: "Hour",
							displayField: "displayField",
							valueField: "valueField",
							queryMode: "local",
							store: new Ext.create("Ext.data.Store", {
								fields: ["displayField", "valueField"],
								data: []
							})
						}
					]
				},
				{
					xtype: 'panel',
					cls : 'containerShadow config_containerShadow',
					title: config.title.row3col2title,
					id: "changesovertime",
					margin: '5 10 10 5',
					flex:.34,
					tools: [
						{
							xtype: "scrollcombo",
							cls: "dropdown",
							width: 180,
							name: "componentType",
							id: "componentType",
							displayField: "displayField",
							valueField: "valueField",
							queryMode: "local",
							store: new Ext.create("Ext.data.Store", {
								fields: ["displayField", "valueField"],
								data: []
							})
						},
						{
							xtype: "combo",
							cls: "dropdown",
							editable: false,
							width: 70,
							name: "duration",
							id: "duration",
							displayField: "displayField",
							valueField: "valueField",
							queryMode: "local",
							store: new Ext.create("Ext.data.Store", {
								fields: ["displayField", "valueField"],
								data: []
							}),
							margin: '0 0 0 10'
						}
					],
					//dockedItems: [
						//{
							//xtype: 'toolbar',
							//dock: 'top',
							//id : 'configDockItemDaywise',
							////hidden : true,
							//layout:{
								//type : 'hbox',
								//pack:'center'
							//},
							//items: [
								//{
									//xtype:'container',
									//id : 'daywiseChartTitle',
									//html:''
								//}
							//]
						//}
					//],
					items: [
						{
							xtype : 'container',
							id : 'daywiseChartCnt'
						}
					]
				}
			]
		},
		{
			xtype : 'errorcontainer',
			hidden : true
		}
	]

});



