Ext.define('ConsolidatedView.controller.Main', {
	extend : 'Ext.app.Controller',
	views : [
		'Main',
		'FormItems',
		'configutilities.Tools',
		'configutilities.PrintPreview',
		'configutilities.SendMail',
		'ErrorContainer',
		'utilities.CommonPanel'
	],
	refs :[
		{selector : 'main',ref : 'main'},
		{selector : 'main #resultViewContainer',ref : 'resultViewContainer'},
		{selector : 'main combo[id="ec_criteria"]',ref : 'ecCriteria'},
		{selector : 'main #ec_userOption',ref : 'ecUserOption'},
		{selector : 'main #componentType',ref : 'ecComponentType'},
		{selector : 'main #components',ref : 'components'},
		{selector : 'main #testName',ref : 'testNameList'},
		{selector : 'main #descriptor',ref : 'descriptors'},
		{selector : 'tools',ref : 'tools'},
		{selector : 'main #hiddenFieldsCt',ref : 'hiddenFieldsCt'},
		{selector: 'errorcontainer',ref: 'errorcontainer'},
		{selector: 'formitems',ref: 'formitems'}
	],
	init :function() {
		me = this;
		this.buildFieldData()
		this.control({
			'main': {
				'afterrender': this.afterMainRender
			},
			'main combo[id="ec_criteria"]':
			{
				'select': this.getDetails
			},
			'main multiselect[id="descriptor"]':
			{
				'change': this.showSchedule
			},
			'main combo[id="ec_userOption"]':
			{
				'select': this.getDetails
			},
			'main combo[id="componentType"]':
			{
				'select': this.getCompInfo
			},
			'main combo[id="testName"]':
			{
				'select': this.getCompInfo
			},
			'main button[id="submit"]':
			{
				'click': this.submitConfigDetails
			},
			'tools' :
			{
				'afterrender' : this.loadTools
			},
			'tools button[id="saveBtn"]' : 
			{
				'click' : this.saveAsPDF
			},
			'tools button[id="printBtn"]' : 
			{
				'click' : this.printData
			},
			'tools button[id="csvBtn"]' : 
			{
				'click' : this.saveAsCSV
			},
			'tools button[id="mailBtn"]' : 
			{
				'click' : this.sendMail
			},
			'tools button[id="scheduleBtn"]' : 
			{
				'click' : this.setschedule
			},
			'main #backBtnMain': 
			{
				'click': this.forwardRequestedURI
			},
			'main trigger[id="compSearch"]' :
			{
				'change': this.filterMultiselectComp
			},
			'main trigger[id="descSearch"]' :
			{
				'change': this.filterMultiselectDesc
			}
		});
	},
	buildFieldData : function()
	{
		Ext.Ajax.request({
			//url :  "/final/config/ConsolidatedView/data/EcConsolidatedViewJson.jsp",
			url : config.urls.servletURL,
			params : queryString+"&needData=yes",
			method : 'POST',
			async : false,
			success : function( response )
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					hiddenFieldsKeys = publicJSON['hiddenFields'];
				}
			},
			failure : function(response)
			{
				console.log(response.responseText);
			}
		});
	},
	loadTools : function()
	{
		this.getTools().loadIcon(true,true,true,true,true,true);
	},
	afterMainRender : function()
	{
		me.getEcCriteria().getStore().loadRawData(publicJSON.ec_criteriaArr);
		me.getEcCriteria().setValue(publicJSON.selectedEcOpt);
		if (publicJSON.selectedEcOpt != 'Component')
		{
			me.getEcUserOption().getStore().loadRawData(publicJSON.userOptionArr);
			me.getEcUserOption().setValue(publicJSON.selectedUserOptionText);
			me.getEcUserOption().setFieldLabel(publicJSON.EcUserOptionText);
			if (publicJSON.EcUserOptionText == null || publicJSON.EcUserOptionText == undefined)
			{
				me.getEcUserOption().setValue(publicJSON.userOptionArr[0].valueField);
			}
			me.getEcUserOption().show();
		}
		else
		{
			me.getEcUserOption().hide();
		}
		//me.loadResultData();
		me.getEcComponentType().getStore().loadRawData(publicJSON.compTypeArr);
		me.getEcComponentType().setValue(publicJSON.selectedCmpType);

		me.getComponents().getStore().loadRawData(publicJSON.componentArr);
		me.getComponents().setValue(publicJSON.selectedComponent);

		me.getTestNameList().getStore().loadRawData(publicJSON.reportArr);
		me.getTestNameList().setValue(publicJSON.selectedReportType);

		if (publicJSON.showDescriptor)
		{
			me.getDescriptors().show();
			me.getDescriptors().getStore().loadRawData(publicJSON.descriptors);
			me.getDescriptors().setValue(publicJSON.selectedDescriptor);
			Ext.getCmp('descriptor').setDisabled(false);
			Ext.getCmp('descTitle').show();
		}
		else
		{
			me.getDescriptors().hide();
			Ext.getCmp('descriptor').setDisabled(true);
			Ext.getCmp('descTitle').hide();
		}
		showDescriptor = publicJSON.showDescriptor;

		if (strRequestFrom != null && strRequestFrom == "saveSchedule")
		{
			Ext.getCmp('backBtnMain').show();
			Ext.getCmp('bkSeperator').show();
			Ext.getCmp('submit').setText('Save');
		}
		me.setToolsState(true);
	},

	showSchedule : function()
	{
		me.setToolsState(true);
	},
	getDetails : function(obj)
	{
		var tempCriteria ="";
		var tempCriteriaPrevious ="";
		var tempUserOption ="";
		var tempUserOptionPrevious ="";
		var me = this;
		me.hideApplicationActivities();
		tempCriteria = me.getEcCriteria().getValue();

		if (tempCriteria != 'Component')
		{
			tempUserOption = me.getEcUserOption().getValue();
		}

		if (hiddenFieldsKeys.ec_criteriaPrevious != null && hiddenFieldsKeys.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = hiddenFieldsKeys.ec_criteriaPrevious;
		}
		if (hiddenFieldsKeys.ec_userOptionPrevious != null && hiddenFieldsKeys.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = hiddenFieldsKeys.ec_userOptionPrevious;
		}

		var url = "../servlet/com.eg.EcConfigurationServletNew";

		var me = this;
		me.getFormitems().submit({
			url: url,
			params: "needData=yes&cmd=ConsolidatedView&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious)+"&id="+id+"&request_from="+strRequestFrom,
			method: 'POST',
			success: function(form, action){

				publicJSON = Ext.decode(action.response.responseText);
				hiddenFieldsKeys = publicJSON.hiddenFields;
				if (publicJSON.selectedEcOpt != 'Component')
				{
					if (obj.getId() != "ec_userOption")
					{
						me.getEcUserOption().getStore().loadRawData(publicJSON.userOptionArr);
						me.getEcUserOption().setValue(publicJSON.selectedUserOptionText);
						me.getEcUserOption().setFieldLabel(publicJSON.EcUserOptionText);
						if (publicJSON.EcUserOptionText == null || publicJSON.EcUserOptionText == undefined)
						{
							me.getEcUserOption().setValue(me.getEcUserOption().getStore().getAt(0).get("valueField"));
						}
					}
					me.getEcUserOption().show();
				}
				else
				{
					me.getEcUserOption().hide();
				}
				me.loadPageConfigs();
				me.setToolsState(true);
				delete publicJSON;
			},
			failure: function(form, action) // if result page doest not contain success:true, this method fires
			{
				Ext.MessageBox.alert("Ajax Failed","Error in updating details");
			}
		});
	},
	loadPageConfigs : function()
	{
		var me = this;
		me.getEcComponentType().getStore().loadRawData(publicJSON.compTypeArr);
		me.getEcComponentType().setValue(publicJSON.selectedCmpType);

		me.getComponents().getStore().loadRawData(publicJSON.componentArr);
		me.getComponents().setValue(publicJSON.selectedComponent);

		me.getTestNameList().getStore().loadRawData(publicJSON.reportArr);
		me.getTestNameList().setValue(publicJSON.selectedReportType);

		showDescriptor = publicJSON.showDescriptor;
		if (publicJSON.showDescriptor != undefined && publicJSON.showDescriptor)
		{
			me.getDescriptors().show();
			me.getDescriptors().getStore().loadRawData(publicJSON.descriptors);
			me.getDescriptors().setValue(publicJSON.selectedDescriptor);
			Ext.getCmp('descriptor').setDisabled(false);
			Ext.getCmp('descTitle').show();
		}
		else
		{
			me.getDescriptors().hide();
			Ext.getCmp('descriptor').setDisabled(true);
			Ext.getCmp('descTitle').hide();
		}
		delete publicJSON;
	},
	getCompInfo : function()
	{
		var me = this;
		var descriptorArr = new Array();
		var ec_criteria = Ext.getCmp("ec_criteria").getValue();
		var ec_userOption = Ext.getCmp("ec_userOption").getValue();
		var componentType = Ext.getCmp("componentType").getValue();
		var components = Ext.getCmp("components").getValue();
		var testName = Ext.getCmp("testName").getValue();
		var descriptor = Ext.getCmp("descriptor").getValue();
		for (var i=0; i<descriptor.length; i++)
		{
			descriptorArr[i] = filterEncode(descriptor[i]);
		}
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		//Ext.getCmp('submit').setDisabled(true);
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
		me.hideApplicationActivities();

		var paramStr =  hiddenFields+'&date='+new Date().getTime()+'&ec_criteria='+ec_criteria+'&ec_userOption='+encodeURIComponent(ec_userOption)+'&componentType='+encodeURIComponent(componentType)+'&components='+encodeURIComponent(components)+'&testName='+encodeURIComponent(testName)+'&descriptor='+encodeURIComponent(descriptorArr);
		if (id != null && id != "null")
		{
			paramStr =  hiddenFields+'&request_from=saveSchedule&date='+new Date().getTime()+'&id='+id+'&ec_criteria='+ec_criteria+'&ec_userOption='+encodeURIComponent(ec_userOption)+'&componentType='+encodeURIComponent(componentType)+'&components='+encodeURIComponent(components)+'&testName='+encodeURIComponent(testName)+'&descriptor='+encodeURIComponent(descriptorArr);
		}

		Ext.Ajax.request({
			url:  config.urls.initialURL,
			params : paramStr,
			method: 'POST',
			success: function(response){
				myMask.hide();
				//Ext.getCmp('submit').setDisabled(false);
				publicJSON = Ext.decode(response.responseText);
				hiddenFieldsKeys = publicJSON.hiddenFields;
				me.loadPageConfigs();
				me.setToolsState(true);
				delete hiddenFields;
			},
			failure: function(form, action) // if result page doest not contain success:true, this method fires
			{
				delete hiddenFields;
				switch (action.failureType) {
					case Ext.form.action.Action.CLIENT_INVALID:
						Ext.Msg.alert('Failure', 'Form fields may not be submitted with invalid values');
						break;
					case Ext.form.action.Action.CONNECT_FAILURE:
						Ext.Msg.alert('Failure', 'Ajax communication failed');
						break;
					case Ext.form.action.Action.SERVER_INVALID:
					   Ext.Msg.alert('Failure', action.result.msg);
				}
			}
		});
	},
	forwardRequestedURI : function()
	{
		if (strRequestFrom != null && strRequestFrom == "saveSchedule")
		{
			var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			var urlStr = "/final/config/EcSaveScheduleNew.jsp";
			me.getFormitems().submit({
				url: urlStr,
				params: "request_from="+strRequestFrom+"&id="+id+"&"+hiddenFields,
				standardSubmit : true,
				method: 'POST'
			});
		}
	},
	submitConfigDetails : function()
	{
		var me = this;

		if (strRequestFrom != null && strRequestFrom == "saveSchedule")
		{
			me.setschedule();
		}
		else
		{
			var descriptorArr = new Array();
			var ec_criteria = Ext.getCmp("ec_criteria").getValue();
			var ec_userOption = Ext.getCmp("ec_userOption").getValue();
			var componentType = Ext.getCmp("componentType").getValue();
			var components = Ext.getCmp("components").getValue();
			var testName = Ext.getCmp("testName").getValue();
			var descriptor = Ext.getCmp("descriptor").getValue();
			for (var i=0; i<descriptor.length; i++)
			{
				descriptorArr[i] = filterEncode(descriptor[i]);
			}
			var checkFlag = me.checkFormValidation("submit");
			if (checkFlag == false)
			{
				return false;
			}

			var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);

			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
			myMask.show();
			Ext.Ajax.request({
				url: config.urls.servletURL,
				params : hiddenFields+'needData=yes&fromApp=ConsolidatedView&ec_criteria='+ec_criteria+'&ec_userOption='+encodeURIComponent(ec_userOption)+'&componentType='+encodeURIComponent(componentType)+'&components='+encodeURIComponent(components)+'&testName='+encodeURIComponent(testName)+'&descriptor='+encodeURIComponent(descriptorArr),
				method: 'POST',
				success: function(response)
				{
					myMask.hide();
					publicJSON = Ext.decode(response.responseText);
					me.getResultViewContainer().show();
					//showTemplate = false;
					if(showTemplate != null && (showTemplate.toLowerCase() == "true" || showTemplate.toLowerCase() == "yes"))
					{
						Ext.getCmp('formitems').collapse();
						me.loadResultData();
						//me.getResultViewContainer().update("");
					}
					else
					{
						me.getResultViewContainer().update(publicJSON.tableHtmlData);
					}
					//me.toggleForm();

					//printQueryStr = publicJSON.printURL;
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
					Ext.MessageBox.alert("Ajax Failed","Error in updating details");
				}
			});
		}
	},
	checkFormValidation : function(path)
	{
		var tempCriteria = "";
		var tempUserOption = "";

		tempCriteria = me.getEcCriteria().getValue();
		if (tempCriteria != 'Component')
		{
			tempUserOption = me.getEcUserOption().getValue();
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != "-1")
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == "-1")
			{
				if (tempCriteria == "Zone")
				{
					Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorZone);
					return false;
				}
				else if (tempCriteria == "Service")
				{
					Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorService);
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorSegment);
					return false;
				}
			}
		}

		if (me.getEcComponentType().getValue() == "-1")
		{
			Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorMsg1);
			return false;
		}

		if (me.getComponents().getValue() == "-1" || me.getComponents().getValue() == '')
		{
			Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorMsg2);
			return false;
		}

		if (me.getTestNameList().getValue() == "-1")
		{
			Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorMsg3);
			return false;
		}

		if (showDescriptor && me.getDescriptors().getValue() == "-1" || me.getDescriptors().getValue() == '')
		{
			Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorMsg4);
			return false;
		}

	},
	loadResultData : function()
	{
		var me = this;
		if (publicJSON.hasConfigDetails)
		{
			me.setToolsState(false);
			//var result = publicJSON.tableHtmlData;

			var gridData = createXTemplate(publicJSON.consolidatedGridCollection,true,false,true,"consolidatedview");
			Ext.suspendLayouts();
			Ext.getCmp('resultViewContainer').update(gridData);

			//Ext.getCmp('resultViewContainer').update(result);
			Ext.getCmp('resultViewContainer').show();
			Ext.resumeLayouts(true);
			var panelWidth = Ext.getCmp('main').getWidth();

			if(panelWidth != null && panelWidth != "" && panelWidth != undefined)
			{
				$('#consolidatedView_div').width(panelWidth);
			}
			else
			{
				$('#consolidatedView_div').width(1000);
			}

			/*var gridCollection = "";
			for(key in publicJSON.consolidatedGridCollection)
			{
				gridCollection.push(me.getGridPanel(publicJSON.consolidatedGridCollection[key].gridStore,publicJSON.consolidatedGridCollection[key].gridColumn,publicJSON.consolidatedGridCollection[key].dataViewHeading));
				var tplView = new Array();
				tplView.push('<div class="gridSkin" style="width: 100%;margin-bottom:10px;">');

				if(publicJSON.consolidatedGridCollection[key].dataViewHeading != undefined)
				{
					tplView.push('<div class="x-panel-header" style="height: 26px;"><span class="font_bold">{dataViewHeading}</span></div>');
				}

				tplView.push('<div class="x-table"><table cellspacing="0" style="width:100%" cellpadding="5" border="0" align="center" class="x-grid-table">',
				'<thead><tr class="x-grid-row">',
					'<tpl for="gridColumn">',
						'<th class="x-grid-cell" ><div class="x-grid-cell-inner" >{.}<div></th>',
					'</tpl>',
				'</tr></thead>',
				'<tpl for="gridStore">',
					'<tr class="{[xindex % 2 === 0 ? "x-grid-row x-grid-row-alt" : "x-grid-row"]}">'
				);

				for (c1 in publicJSON.consolidatedGridCollection[key].gridColumn)
				{
					var str = publicJSON.consolidatedGridCollection[key].gridColumn[c1];
					str = str.split(' ').join('');
					str = str.split('(').join('');
					str = str.split(')').join('');
					tplView.push('<td class="x-grid-cell"><div class="x-grid-cell-inner" >{'+str+'}</div></td>');
				}

				tplView.push(
					'</tr>',
					'</tpl>',
					'</table></div></div>'
				);
				var template = Ext.create('Ext.XTemplate', tplView);
				var data = template.apply(publicJSON.consolidatedGridCollection[key]);
				gridCollection = gridCollection + data;
			}


			Ext.suspendLayouts();
			me.getResultViewContainer().update(gridCollection);
			me.getResultViewContainer().show();
			Ext.resumeLayouts(true);
			gridCollection = new Array();*/
		}
		else
		{
			me.getResultViewContainer().hide();
			me.setToolsState(true);
			if (publicJSON.errorText != null && publicJSON.errorText != undefined)
			{
				me.getErrorcontainer().update('<div class = "iconExclamation" style="margin:10% auto 0 auto;"></div><div style="text-align:center"><b>'+publicJSON.errorText+'</b>.</div>');
				me.getErrorcontainer().show();
			}
		}
	},
	table_columnwidth: function(){
		var temp_len = $('#my_table');
	},
	hideApplicationActivities : function()
	{
		me.getResultViewContainer().hide();
		me.getErrorcontainer().hide();
		me.setToolsState(true);
	},
	setToolsState : function(iconState)
	{
		var saveObj = Ext.getCmp('saveTool');
		var printObj = Ext.getCmp('printTool');
		var mailObj = Ext.getCmp('mailTool');
		var csvObj = Ext.getCmp('csvTool');
		var scheduleToolObj = Ext.getCmp('scheduleTool');
		var combineBookletObj = me.getTools().getComponent('bookletTool');
		var testName = Ext.getCmp('testName').getValue();
		var descriptorObj = Ext.getCmp('descriptor');
		
		if (!Ext.isEmpty(saveObj)) {
			saveObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(printObj)) {
			printObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(mailObj)) {
			mailObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(csvObj)) {
			csvObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(combineBookletObj)) {
			combineBookletObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(scheduleToolObj) && testName != -1) {
			if (descriptorObj.isHidden())
			{
				scheduleToolObj.setDisabled(false);
			}
			else
			{
				if (descriptorObj.getValue() != "" && descriptorObj.getValue() != "-1")
				{
					scheduleToolObj.setDisabled(false);
				}
				else
				{
					scheduleToolObj.setDisabled(iconState);
				}
			}
		}
		else
		{
			scheduleToolObj.setDisabled(iconState);
		}
	},
	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+hiddenFields[key]+"&";
		}
		return hiddenQstr;
	},
	saveAsPDF : function()
	{
		//var getSaveObj = Ext.widget('savepdf');
		//getSaveObj.savePDF("/final/servlet/com.eg.EcPdfDownloadC");

		downloadAsPDF("/final/servlet/com.eg.EcPdfDownloadC");
	},
	printData : function()
	{
		var printQueryStr = publicJSON.printQueryStr;
		Ext.widget('print',{title : config.title.mainPageTitle}).show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set({
			src: printQueryStr
		});
	},
	saveAsCSV : function()
	{
		var me = this;
		var descriptorArr = new Array();
		var componentType = Ext.getCmp("componentType").getValue();
		var components = Ext.getCmp("components").getValue();
		var testName = Ext.getCmp("testName").getValue();
		var descriptor = Ext.getCmp("descriptor").getValue();
		for (var i=0; i<descriptor.length; i++)
		{
			descriptorArr[i] = filterEncode(descriptor[i]);
		}

		var ec_criteria = me.getEcCriteria().getValue();
		var ec_userOption = "";
		if (ec_criteria != 'Component')
		{
			 ec_userOption = me.getEcUserOption().getValue();
		}
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
		window.location = '../servlet/com.eg.EcCSVController?ec_criteria='+ec_criteria+'&ec_userOption='+encodeURIComponent(ec_userOption);
	},
	sendMail : function()
	{
		Ext.widget('sendmail').show();
	},
	setschedule : function()
	{
		var op = "schedule";
		var descriptorArr = new Array();
		var ec_criteria = me.getEcCriteria().getValue();
		var ec_userOption = me.getEcUserOption().getValue();
		var components = me.getComponents().getValue();
		var descriptor = me.getDescriptors().getValue();
		for (var i=0; i<descriptor.length; i++)
		{
			descriptorArr[i] = filterEncode(descriptor[i]);
		}
		var testName = me.getTestNameList().getValue();
		var componentType = me.getEcComponentType().getValue();

		hiddenFieldsKeys = publicJSON['hiddenFields'];
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
		if (op == "schedule")
		{
			if (strRequestFrom != null && strRequestFrom == "saveSchedule")
			{
				var checkFlag = me.checkFormValidation();
				if (checkFlag == false)
				{
					return false;
				}
				window.location = '/final/config/EcSaveScheduleNew.jsp?id='+id+'&'+hiddenFields+'currentDateFormat='+currentDateFormat+'&ec_criteria='+ec_criteria+'&ec_userOption='+encodeURIComponent(ec_userOption)+"&components="+components+"&descriptor="+encodeURIComponent(descriptorArr)+"&testName="+testName+"&componentType="+componentType;
			}
			else
			{
				urlStr = "/final/config/EcSaveScheduleNew.jsp?id="+id+"&request_from=Consolidated&"+hiddenFields+"ec_criteria="+ec_criteria+"&ec_userOption="+encodeURIComponent(ec_userOption)+"&currentDateFormat="+currentDateFormat+"&showWindow=yes"+"&components="+components+"&descriptor="+encodeURIComponent(descriptorArr)+"&testName="+testName+"&componentType="+componentType+"&com.eg.CSRF_NONCE="+csrfToken;
				scheduleWindow(urlStr);
			}
		}
		else if (op =="favorite")
		{
			urlStr = "/final/config/EcSaveFavorite.jsp";
		}
		else
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,".Illegal Access");
			return false;
		}
	},

	filterMultiselectComp : function(obj)
	{
		this.filterComboStore(obj,Ext.getCmp('components'),publicJSON.componentArr);
		obj.toggleTriggger();
	},

	filterMultiselectDesc : function(obj)
	{
		this.filterComboStore(obj,Ext.getCmp('descriptor'),publicJSON.descriptors);
		obj.toggleTriggger();
	},

	filterComboStore:function(searchFieldObj,comboObj,compStore)
	{
		var findVal = searchFieldObj.getValue().toLowerCase();
		if (Ext.isEmpty(findVal))
		{
			comboObj.getStore().loadRawData(compStore);
			comboObj.setValue(compStore[0]['valueField']);
		}
		else 
		{
			var isRecordFound = false;
			var genStore = new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			});

			for (var i = 0; i < compStore.length; i++)
			{
				var valueFied = compStore[i]['valueField'].toLowerCase();
				if(valueFied.indexOf('-1') !=0)
				{
					var getRecord = compStore[i]['displayField'].toLowerCase();
					if (getRecord.indexOf(findVal) > -1) 
					{
						isRecordFound = true;
						genStore.add({
							'displayField': compStore[i]['displayField'],
							'valueField': compStore[i]['valueField']
						});
					}
				}
			}
			if (isRecordFound)
			{
				comboObj.getStore().removeAll();
				for (var i = 0; i < genStore.getCount(); i++)
				{
					var getRecord = genStore.getAt(i);
					comboObj.getStore().add(getRecord);
				}
				comboObj.setValue(genStore.getAt(0).get('valueField'));
			} 
			else 
			{
				comboObj.getStore().removeAll();
				comboObj.getStore().add({
					'displayField': 'Not Applicable!',
					'valueField': '-1'
				});
				comboObj.setValue('-1');
			}
		}
		searchFieldObj.focus();
	}
});

function doCloseWin()
{
	Ext.getCmp('scheduleWin').destroy();
}



