Ext.define('ConsolidatedView.view.FormItems',{
	extend:'Ext.form.Panel',
	alias:'widget.formitems',
	id: 'formitems',
	cls:'formOuter accordionArrow',
	margin: '8 5 5 5',
	requires: [
		'utilities.ScrollCombo',
		'Ext.ux.form.MultiSelectSI'
	],
	collapsible: true,
	items : [
		{
			xtype : 'container',
			id : 'infoCont',
			margin : 10,
			layout : {
				type : 'hbox',
				pack : 'center'
			},
			items : [
				{
					xtype: 'container',
					id : 'optionCont',
					layout: {
						type: 'vbox',
						pack: 'center',
						align: 'stretch'
					},
					defaults: {
						labelSeparator : '',
						labelAlign: 'top',
						width: 200
					},
					items: [
						{
							xtype:'combo',
							cls: 'dropdown',
							editable : false,
							fieldLabel:config.title.viewByTitle,
							name: 'ec_criteria',
							id: 'ec_criteria',
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local'
						},
						{
							xtype:'scrollcombo',
							cls: 'dropdown',
							fieldLabel:'Zone',
							id: 'ec_userOption',
							name: 'ec_userOption',
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							hidden: true,
							margin: '12 0 0 0'
						}
					]
				},
				{
					xtype: 'container',
					id : 'fieldCont',
					layout: {
						type: 'vbox',
						pack: 'start',
						align: 'stretch'
					},
					defaults: {
						labelSeparator : '',
						labelAlign: 'top',
						width: 250
					},
					margin: '0 0 0 20',
					items: [
						{
							xtype:'scrollcombo',
							cls: 'dropdown',
							id: 'componentType',
							name: 'componentType',
							fieldLabel:config.title.compTypeTitle,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							hidden: false
						},
						{
							xtype: 'fieldcontainer',
							margin: '12 0 0 0',
							items: [
								{
									xtype: 'label',
									text: config.title.compTitle,
								},
								{
									xtype: 'container',
									margin: '4 0 0 0',
									items: [
										{
											xype: 'container',
											cls: 'multisearchlist',
											items: [
												{
													xtype: 'customtrigger',
													id: 'compSearch',
													width: 238,
												}
											]
										},
										{
											xtype: 'multiselectSi',
											id : 'components',
											cls:"multiselect",
											name: 'components',
											autoScroll: true,
											scroll: true,
											margin: 0,
											width: 250,
											displayField: 'displayField',
											valueField: 'valueField',
											height: 100,
											listeners: {
												el: {
													click: function() {
														me.getCompInfo();
													}
												}
											},
											store:new Ext.data.Store({
												fields: ['displayField','valueField'],
												data: []
											})
										}
									]
								}
							]
						},
					]
				},
				{
					xtype: 'container',
					id : 'testCont',
					layout: {
						type: 'vbox',
						pack: 'start',
						align: 'stretch'
					},
					defaults: {
						labelSeparator : '',
						labelAlign: 'top',
						width: 250
					},
					margin: '0 0 0 20',
					items: [
						{
							xtype:'scrollcombo',
							cls: 'dropdown',
							id: 'testName',
							name: 'testName',
							fieldLabel:config.title.reportTypeTitle,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							hidden: false
						},
						{
							xtype: 'fieldcontainer',
							margin: '12 0 0 0',
							items: [
								{
									xtype: 'label',
									text: config.title.descTitle,
									id : 'descTitle'
								},
								{
									xtype: 'container',
									margin: '4 0 0 0',
									items: [
										{
											xype: 'container',
											cls: 'multisearchlist',
											items: [
												{
													xtype: 'customtrigger',
													id: 'descSearch',
													width: 238,
												}
											]
										},
										{
											xtype: 'multiselectSi',
											id : 'descriptor',
											cls:"multiselect",
											name: 'descriptor',
											margin: 0,
											width: 250,
											displayField: 'displayField',
											valueField: 'valueField',
											height: 100,
											store:new Ext.data.Store({
												fields: ['displayField','valueField'],
												data: []
											})
										}
									]
								}
							]
						}
					]
				},
				{
					xtype:'button',
					text: config.title.submitTitle,
					cls: "button20",
					id: "submit",
					name: "submit",
					margin: '185 0 0 20',
					width: 60
				}
			]
		}
	],
	listeners:
	{
		afterrender:function(panel)
		{
			var headerObj = Ext.getCmp("formitems_header");
			headerObj.removeCls("x-panel-header-default");
		},

		collapse: function()
		{
			var titleStr = '';
			var selectedEcOpt = publicJSON.selectedEcOpt;
			var selectedCmpTypeDispName = publicJSON.selectedCmpTypeDispName;
			var selectedCmpType = publicJSON.selectedCmpType;
			var selectedComponentDispName = publicJSON.selectedComponentDispName;
			var selectedComponent = publicJSON.selectedComponent;
			var selectedUserOptionText = publicJSON.selectedUserOptionText;
			if (selectedEcOpt != null &&  selectedEcOpt != "-1")
			{
				if (selectedEcOpt == "Component")
				{
					titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>';
				}
				else
				{
					if (selectedUserOptionText != null && selectedUserOptionText != "-1")
					{
						titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">'+selectedEcOpt+'</span> - <span class="formSelectionValue">'+selectedUserOptionText+'</span>';
					}
					else
					{
						titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>';
					}
				}

				if (selectedCmpType != null && selectedCmpType != "-1" && selectedCmpType != "")
				{
					titleStr = titleStr+'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">Component Type</span> - <span class="formSelectionValue">'+selectedCmpTypeDispName+'</span>';
				}

				if (selectedComponent != null && selectedComponent != "-1" && selectedComponent != "")
				{
					titleStr = titleStr+'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">Component Name</span> - <span class="formSelectionValue">'+selectedComponentDispName+'</span>'
				}
			}
			Ext.getCmp("formitems").setTitle(titleStr);
		},

		expand: function()
		{
			Ext.getCmp("formitems").setTitle('');
		}
	}
});



