
<%@ include file = "../../EcTrackerJson.jsp"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.User"%>
<%@ page import="com.egurkha.UserRegistry"%>
<%@ page import="java.util.*"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="egurkha.config.EcConsolidatedView"%>
<%@ page import="egurkha.config.EcUtils"%>
<%@ page import="com.eg.EgConfigConstants"%>
<%@ page import="com.eg.EgConfigTestsInfo"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.pdfmaker.*"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "java.net.URLEncoder" %>
<%@ page import = "egurkha.EgUIUtils" %>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};

	private String prepareQueryString(Map params)
	{
		if (params == null || params.size() == 0) return "";
		String queryStr = "";
		Iterator itr = params.keySet().iterator();
		while (itr.hasNext())
		{
			String key = (String)itr.next();
			if (key.trim().length() == 0) continue;
			Object value= params.get(key);

			if (value instanceof String[])
			{
				String val[] =(String[])value;
				for(int i=0;i<val.length;i++)
				{
					if (key.equals("descriptor"))
					{
						queryStr += key + "=" + URLEncoder.encode(EgUIUtils.encodeSecurityChar(val[i])) + "&";
					}
					else
					{
						queryStr += key + "=" + val[i] + "&";
					}
				}
			}
			else
			{
				if (value == null) value = "";
				if (key.equals("descriptor"))
				{
					queryStr += key + "=" + URLEncoder.encode(EgUIUtils.encodeSecurityChar((String)value)) + "&";
				}
				else
				{
					queryStr += key + "=" + (String)value + "&";
				}
			}
		}
		if (queryStr.length() > 0) queryStr = queryStr.substring(0,queryStr.length()-1);
		return queryStr;
	}
%>

<%
	String queryString = prepareQueryString(request.getParameterMap());
	JSONObject rootObj = new JSONObject();
	rootObj.put("success","true");
	JSONObject hiddenFields = new JSONObject();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EcUtils ecUtils = new EcUtils();

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");
	String configSkin = user.getConfigSkin();

	String strsubmitClicked = request.getParameter("submitClicked");
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	String userDateFormat = user.getUserDateFormat();
	if (userDateFormat != null && userDateFormat.equalsIgnoreCase("Default"))
	{
		userDateFormat = currentDateFormat;
	}

	// If user date format is set, assign it to current date format.
	if (userDateFormat != null)
	{
		currentDateFormat = userDateFormat;
	}

	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConverter.getDateTime();
	/* Added by Prakash.K Ends */

	String componentType = request.getParameter("componentType");
	String o_componentType = request.getParameter("old_comptype");
	String[] s_selectedComponents = request.getParameterValues("components");

	if (s_selectedComponents != null)
	{
		StringTokenizer strTokensTemp1 = new StringTokenizer(s_selectedComponents[0],",");
		ArrayList selectedComponentList = new ArrayList();
		while (strTokensTemp1.hasMoreTokens())
		{
			selectedComponentList.add((String)strTokensTemp1.nextToken());
		}
		s_selectedComponents = (String[])selectedComponentList.toArray(new String[0]);
		if (s_selectedComponents.length == 0) s_selectedComponents = null;
	}

	String testName = request.getParameter("testName");
	String o_testName = request.getParameter("old_testname");
	String[] descriptor = request.getParameterValues("descriptor");

	if (descriptor != null)
	{
		StringTokenizer strTokensTemp1 = new StringTokenizer(descriptor[0],",");
		ArrayList selectedDescriptorList = new ArrayList();
		while (strTokensTemp1.hasMoreTokens())
		{
			String value = (String)strTokensTemp1.nextToken();
			selectedDescriptorList.add(EgUIUtils.decodeSecurityChar(value));
		}
		descriptor = (String[])selectedDescriptorList.toArray(new String[0]);
		if (descriptor.length == 0) descriptor = null;
	}

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");

	if (ec_criteria != null && 
		ec_criteriaPrevious != null && 
		!ec_criteriaPrevious.equals(ec_criteria))
	{
		componentType = null;
	}

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	if (ec_userOption != null && 
		ec_userOptionPrevious != null && !ec_userOptionPrevious.equals(ec_userOption) && 
		ec_criteria != null && ec_criteriaPrevious != null)
	{
		componentType = null;
	}
	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");

	String request_from = request.getParameter("request_from");
	Map scheduleDetails = (Map)request.getAttribute("ScheduleDetails");

	Vector vecComponentTypes = new Vector();
	Vector vec_components = new Vector();
	Vector vec_ctypes = new Vector();
	vec_ctypes.addAll(aListAssociatedComponents);
	for (int i=0; i<vec_ctypes.size(); i++)
	{
		String str = (String) vec_ctypes.get(i);
		String component_type = str.substring(0,str.indexOf(":"));
		boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
		if (!isConfigTestEnabled) continue;
		if (!vecComponentTypes.contains(component_type))
		{
			vecComponentTypes.add(component_type);
		}
		String component_name = str.substring(str.indexOf(":")+1);
		vec_components.add(component_name+":"+component_type);
	}

	if (vecComponentTypes.contains("Host_system"))
	{
		vecComponentTypes.remove("Host_system");
	}

	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		vecUserOptions = (Vector) scheduleDetails.get("vecUserOptions");
		Object temp = (Object)scheduleDetails.get("descriptor");
		if (temp instanceof String)
		{
			descriptor = new String[]{(String)temp};
		}
		else if (temp instanceof String[])
		{
			descriptor = (String[])temp;
		}
		componentType = (String) scheduleDetails.get("componentType");
		Object comp = (Object)scheduleDetails.get("components");
		if (comp instanceof String)
		{
			s_selectedComponents = new String[]{(String)comp};
		}
		else if (comp instanceof String[])
		{
			s_selectedComponents = (String[])comp;
		}
		testName = (String) scheduleDetails.get("testName");
		o_componentType = (String) scheduleDetails.get("old_comptype");
		o_testName = (String) scheduleDetails.get("old_testname");
	}

	ArrayList al_components = null;
	if (componentType != null && !componentType.equals("-1"))
	{
		al_components = new ArrayList();
		for (int k=0;k<vec_components.size();k++)
		{
			String strComp = (String)vec_components.get(k);
			String component_Type = strComp.substring(strComp.lastIndexOf(":")+1);
			boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_Type);
			if (!isConfigTestEnabled) continue;
			if (componentType!=null && strComp.endsWith(componentType))
			{
				al_components.add(strComp);
			}
		}
	}

	ArrayList sortedTestList = new ArrayList();
	if (componentType != null && !componentType.equals("-1"))
	{
		ArrayList aListEnabledConfigTests = specsInfo.getEnabledTests(componentType,true);
		if (aListEnabledConfigTests != null)
		{
			sortedTestList = sorter.getSortedTestList(aListEnabledConfigTests);
		}
	}

	if (componentType != null && !componentType.equalsIgnoreCase(o_componentType))
	{
		s_selectedComponents = null;
		testName = "";
		descriptor = null;
	}

	List l_selectedComponents = null;
	if (s_selectedComponents != null && !s_selectedComponents[0].equals("-1"))
	{
		l_selectedComponents = Arrays.asList(s_selectedComponents);
	}

	if (testName != null && !testName.equalsIgnoreCase(o_testName))
	{
		descriptor = null;
	}
	Vector vecDescriptors = null;
	if (l_selectedComponents != null && !l_selectedComponents.isEmpty() && 
		testName != null && !testName.equals("-1"))
	{
		EcConsolidatedView ecConsolidatedView = new EcConsolidatedView();
		Map hostAgentsMapping = (Map)session.getAttribute("hostAgentsMapping");
		ecConsolidatedView.setHostAgentsMapping(hostAgentsMapping);
		vecDescriptors = ecConsolidatedView.getDescriptor(testName,componentType,s_selectedComponents);
	}

	List l_selectedDescriptors = null;
	if (descriptor != null && !descriptor[0].equals("-1"))
	{
		l_selectedDescriptors = Arrays.asList(descriptor);
	}
	else if (descriptor == null || descriptor[0].equals("-1"))
	{
		if (vecDescriptors != null && !vecDescriptors.isEmpty())
		{
			ArrayList aList_temp = new ArrayList();
			aList_temp.add((String)vecDescriptors.get(0));
			l_selectedDescriptors = aList_temp;
		}
	}

	ArrayList aListConsolidatedData = (ArrayList)request.getAttribute("aListConsolidatedData");
	session.setAttribute("ConsolidatedViewData",aListConsolidatedData);
	session.setAttribute("componentType",componentType);
	session.setAttribute("testName",testName);

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

	String userName = (String)session.getAttribute("sess_auserid");

	String id = request.getParameter("id");

	if (strsubmitClicked == null)
	{
		strsubmitClicked = "false";
	}
	String submitOrNot = "true";
	String strBackRequest = request.getParameter("back_request");
	if (strBackRequest != null && strBackRequest.equalsIgnoreCase("ScheduleConfig") && strsubmitClicked != null && strsubmitClicked.equalsIgnoreCase("false"))
	{
		submitOrNot = "false";
	}

	StringBuffer printQS = new StringBuffer();
	printQS.append("ec_type=Consolidated_View");
	printQS.append("&ec_trgttype=REPORT");
	printQS.append("&printData=yes");
	printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
	printQS.append("&user_language="+userLanguage);
	printQS.append("&ec_criteria="+ec_criteria);
	printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
	rootObj.put("printQueryStr","../servlet/com.eg.EcRepoLiteC?"+printQS.toString()+"&ec_forPDF=No");

	session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
	session.setAttribute("REPORT_NAME","ConsolidatedView");
	session.setAttribute("REPORT_LAYOUT","Portrait");
	session.setAttribute("PAGE_WIDTH_PDF","1100");
	session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
	session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");

	hiddenFields.put("ec_rtype","Consolidated");
	hiddenFields.put("ec_trgttype","Configuration Report");
	hiddenFields.put("old_comptype",componentType);
	hiddenFields.put("old_testname",testName);
	hiddenFields.put("ec_criteriaPrevious",ec_criteria);
	hiddenFields.put("ec_userOptionPrevious",ec_userOption);

	JSONArray ec_criteriaArr = new JSONArray();
	JSONObject tmpObject = new JSONObject();
	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			tmpObject = new JSONObject();
			String strCriteria = (String)vecCriterias.get(i);
			if(ec_criteria != null && strCriteria.equals(ec_criteria))
			{
				rootObj.put("selectedEcOpt",ec_criteria);
			}
			tmpObject.put("valueField",strCriteria);
			tmpObject.put("displayField",_mapping.getTextDescription("configmgmt.common."+strCriteria));
			ec_criteriaArr.add(tmpObject);
		}
	}
	else
	{
		rootObj.put("selectedEcOpt","-1");
		tmpObject.put("valueField","-1");
		tmpObject.put("displayField",_mapping.getTextDescription("configmgmt.common.Not Applicable"));
		ec_criteriaArr.add(tmpObject);
	}
	rootObj.put("ec_criteriaArr",ec_criteriaArr);

	JSONArray userOptionArr = new JSONArray();
	if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
	{
		if (ec_criteria.equalsIgnoreCase(criterias[0]))
		{
			rootObj.put("EcUserOptionText",_mapping.getTextDescription("configmgmt.common."+criterias[0]));
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[1]))
		{
			rootObj.put("EcUserOptionText",_mapping.getTextDescription("configmgmt.common."+criterias[1]));
		}
		else
		{
			rootObj.put("EcUserOptionText",_mapping.getTextDescription("configmgmt.common."+criterias[2]));
		}

		if (vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			for(int i=0; i<vecUserOptions.size(); i++)
			{
				JSONObject tmpObj = new JSONObject();
				String strUserOption = (String)vecUserOptions.get(i);
				if(ec_userOption != null && strUserOption.equals(ec_userOption))
				{
					rootObj.put("selectedUserOptionText",ec_userOption);
				}
				tmpObj.put("valueField",strUserOption);
				tmpObj.put("displayField",strUserOption);
				userOptionArr.add(tmpObj);
			}
		}
		else
		{
			rootObj.put("selectedUserOptionText","-1");
			JSONObject tmpObj = new JSONObject();
			tmpObj.put("valueField","-1");
			tmpObj.put("displayField",_mapping.getTextDescription("configmgmt.common.Not Applicable"));
			userOptionArr.add(tmpObj);
		}
	}
	rootObj.put("userOptionArr",userOptionArr);

	JSONArray compArr = new JSONArray();
	tmpObject = new JSONObject();
	if (vecComponentTypes != null && !vecComponentTypes.isEmpty())
	{
		rootObj.put("selectedCmpType","-1");
		tmpObject.put("valueField","-1");
		tmpObject.put("displayField",_mapping.getTextDescription("configmgmt.common.Select a component type"));
		compArr.add(tmpObject);

		ArrayList serverList = sorter.getSortedCompTypeList(vecComponentTypes);
		for (int i=0; i<serverList.size(); i++)
		{
			tmpObject = new JSONObject();
			EgName nameObj = (EgName)serverList.get(i);
			String actualName = nameObj.getActualName();
			String localName = nameObj.getLocalName();
			if (actualName.equals(componentType))
			{
				rootObj.put("selectedCmpType",componentType);
				rootObj.put("selectedCmpTypeDispName",localName);
			}
			tmpObject.put("valueField",actualName);
			tmpObject.put("displayField",localName);
			compArr.add(tmpObject);
		}
	}
	else
	{
		rootObj.put("selectedCmpType","-1");
		tmpObject.put("valueField","-1");
		tmpObject.put("displayField",_mapping.getTextDescription("configmgmt.common.Not Applicable"));
		compArr.add(tmpObject);
	}
	rootObj.put("compTypeArr",compArr);

	JSONArray componentArr = new JSONArray();
	tmpObject = new JSONObject();
	String selectedComponentsList = "";

	if (al_components != null)
	{
		String selectedComponents = "";
		String selectedCompDispName = "";
		for (int k=0;k<al_components.size();k++)
		{
			tmpObject = new JSONObject();
			String strComponent = (String)al_components.get(k);
			String tempCompName = strComponent.substring(0,strComponent.lastIndexOf(":"));
			if (tempCompName.endsWith(":NULL"))
			{
				tempCompName = tempCompName.substring(0,tempCompName.indexOf(":"));
			}
			if (l_selectedComponents != null && l_selectedComponents.contains(strComponent))
			{
				selectedComponents = selectedComponents + strComponent + ",";
				selectedComponentsList = selectedComponentsList + tempCompName +",";
				selectedCompDispName = selectedCompDispName + tempCompName + ",";
			}
			tmpObject.put("valueField",strComponent);
			tmpObject.put("displayField",tempCompName);
			componentArr.add(tmpObject);
		}
		if (selectedComponents.indexOf(",") != -1)
		{
			selectedComponents = selectedComponents.substring(0,selectedComponents.length()-1);
			selectedCompDispName = selectedCompDispName.substring(0,selectedCompDispName.length()-1);
		}
		rootObj.put("selectedComponent",selectedComponents);
		rootObj.put("selectedComponentDispName",selectedCompDispName);
	}
	else
	{
		rootObj.put("selectedComponent","-1");
		tmpObject.put("valueField","-1");
		tmpObject.put("displayField",_mapping.getTextDescription("configmgmt.common.Not Applicable"));
		componentArr.add(tmpObject);
	}
	if (selectedComponentsList.indexOf(",") != -1) selectedComponentsList = selectedComponentsList.substring(0,selectedComponentsList.length()-1);
	rootObj.put("componentArr",componentArr);

	JSONArray reportArr = new JSONArray();
	tmpObject = new JSONObject();
	if (sortedTestList != null && sortedTestList.size() > 0)
	{
		rootObj.put("selectedReportType","-1");
		tmpObject.put("valueField","-1");
		tmpObject.put("displayField",_mapping.getTextDescription("configmgmt.common.Select a report type"));
		reportArr.add(tmpObject);

		for (int i=0;i<sortedTestList.size();i++)
		{
			tmpObject = new JSONObject();
			EgName nameObj = (EgName)sortedTestList.get(i);
			String strTestName = nameObj.getActualName();
			String strDispName = nameObj.getLocalName();
			if (strTestName.equals(testName))
			{
				rootObj.put("selectedReportType",testName);
				rootObj.put("selectedReportTypeForTable",strDispName);
			}
			tmpObject.put("valueField",strTestName);
			tmpObject.put("displayField",strDispName);
			reportArr.add(tmpObject);
		}
	}
	else
	{
		rootObj.put("selectedReportType","-1");
		tmpObject.put("valueField","-1");
		tmpObject.put("displayField",_mapping.getTextDescription("configmgmt.common.Not Applicable"));
		reportArr.add(tmpObject);
	}
	rootObj.put("reportArr",reportArr);

	JSONArray descriptorArr = new JSONArray();
	tmpObject = new JSONObject();
	rootObj.put("showDescriptor",new Boolean(true));
	String selectedDesList = "";
	String selectedDesList2 = "";
	if (vecDescriptors != null && !vecDescriptors.isEmpty())
	{
		if (!vecDescriptors.contains("+") && 
			!vecDescriptors.contains(EgConfigConstants.CF_EMPTY_WITH_COLON+"~M~") && 
			!vecDescriptors.contains(EgConfigConstants.CF_EMPTY+"~M~"))
		{
			for (int i=0;i<vecDescriptors.size();i++)
			{
				tmpObject = new JSONObject();
				String strDescriptor = (String)vecDescriptors.get(i);
				String strDescriptorForDisplay = ecUtils.getInfoForDisplay(strDescriptor);
				if (l_selectedDescriptors != null && l_selectedDescriptors.contains(strDescriptor))
				{
					selectedDesList = selectedDesList + strDescriptor +",";
					selectedDesList2 = selectedDesList2 + strDescriptorForDisplay +",";
				}
				tmpObject.put("valueField",strDescriptor);
				tmpObject.put("displayField",strDescriptorForDisplay);
				descriptorArr.add(tmpObject);
			}
			if (selectedDesList.indexOf(",") != -1) selectedDesList = selectedDesList.substring(0,selectedDesList.length()-1);
			rootObj.put("selectedDescriptor",selectedDesList);
		}
		else
		{
			rootObj.put("showDescriptor",new Boolean(false));
			hiddenFields.put("descriptor",(String)vecDescriptors.get(0)); 
		}
	}
	else
	{
		rootObj.put("selectedDescriptor","-1");
		tmpObject.put("valueField","-1");
		tmpObject.put("displayField",_mapping.getTextDescription("configmgmt.common.Not Applicable"));
		descriptorArr.add(tmpObject);
	}
	if (selectedDesList2.indexOf(",") != -1) selectedDesList2 = selectedDesList2.substring(0,selectedDesList2.length()-1);
	rootObj.put("descriptors",descriptorArr);
	rootObj.put("hasConfigDetails",new Boolean(false));
	if (aListConsolidatedData != null && !aListConsolidatedData.isEmpty() && submitOrNot.equalsIgnoreCase("true"))
	{
		rootObj.put("hasConfigDetails",new Boolean(true));
		JSONArray selectionDetailsArr = new JSONArray();
		JSONObject selectionDetailsObj = new JSONObject();

		selectionDetailsObj.put("View By",ec_criteria);
		selectionDetailsArr.add(selectionDetailsObj);

		if (!ec_criteria.equalsIgnoreCase("component"))
		{
			if (ec_userOption == null || ec_userOption.equals("null") || ec_userOption.length() == 0)
			{
				ec_userOption = (String)userOptionArr.get(0);
			}
			selectionDetailsObj = new JSONObject();
			selectionDetailsObj.put(rootObj.get("EcUserOptionText"),ec_userOption);
			selectionDetailsArr.add(selectionDetailsObj);
		}

		selectionDetailsObj = new JSONObject();
		selectionDetailsObj.put("Component Type",_mapping.getComponentTypeDescription(componentType));
		selectionDetailsArr.add(selectionDetailsObj);

		selectionDetailsObj = new JSONObject();
		selectionDetailsObj.put("Components",selectedComponentsList);
		selectionDetailsArr.add(selectionDetailsObj);

		selectionDetailsObj = new JSONObject();
		selectionDetailsObj.put("Report Type",_mapping.getTestDescription(testName));
		selectionDetailsArr.add(selectionDetailsObj);

		selectionDetailsObj = new JSONObject();
		selectionDetailsObj.put("Descriptor",selectedDesList2);
		selectionDetailsArr.add(selectionDetailsObj);

		rootObj.put("selectionDetailsArr",selectionDetailsArr);
		ArrayList aListDistinctDescriptors = (ArrayList)aListConsolidatedData.get(0);
		ArrayList aListAllMeasures = (ArrayList)aListConsolidatedData.get(1);
		TreeMap tmapData = (TreeMap)aListConsolidatedData.get(2);
		int idx_msize = aListAllMeasures.size();

		//For New Pdf Framework
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();

		EgReportAttributes reportAttributes = new EgReportAttributes();

		String pdfTitle = "";
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.CONSOLIDATED VIEW REPORT") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		else
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.CONSOLIDATED VIEW REPORT") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		reportAttributes.setMainTitle(pdfTitle);

		String subTitle = mappingInfo.getTextDescription("configmgmt.consolidated.Component Type") + " : " + mappingInfo.getComponentTypeDescription(componentType) + "\n" + mappingInfo.getTextDescription("configmgmt.consolidated.Report Type") + " : " + mappingInfo.getTestDescription(testName);

		reportAttributes.setSubTitle(subTitle);
		reportAttributes.setReportName("ConsolidatedView");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(false);
		pdfData.setAttributes(reportAttributes);


		String tableHtmlData = "<table border='0' align='center' width='100%' class='body_text' height='100%' cellspacing='0' cellpadding='4'><tr><td valign='top'>";

		JSONArray consolidatedGridCollection = new JSONArray();
		for (int i=0;i<aListDistinctDescriptors.size();i++)
		{
			tmpObject = new JSONObject();
			String strDescriptor = (String)aListDistinctDescriptors.get(i);
			ArrayList aListData = (ArrayList)tmapData.get(strDescriptor);
			int idx_dataSize = aListData.size();

			ArrayList aListInfoHeadings = null;
			boolean isDynamicMeasureTest = false;
			int idx_M = strDescriptor.indexOf("~M~");
			if (idx_M != -1)
			{
				isDynamicMeasureTest = true;

				aListInfoHeadings = new ArrayList();
				String infoHeadings = configTestsInfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",testName);
				if (infoHeadings != null && infoHeadings.length() > 0)
				{
					StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
					while (strTokensTemp.hasMoreTokens())
					{
						String str_temp = strTokensTemp.nextToken();
						aListInfoHeadings.add(str_temp);
					}
				}
			}

			EgTableAttributes egTableAttributes = new EgTableAttributes();
			egTableAttributes.setStartX(0);

			ArrayList aListColumnNames = new ArrayList();
			ArrayList aListData_A = new ArrayList();
			ArrayList userColumnNames = new ArrayList();

			tableHtmlData += "<table border='0' width='100%' class='body_text linesquare' cellspacing='0' cellpadding='0'>";

			//if (!strDescriptor.equals("+") && !ecUtils.getInfoForDisplay(strDescriptor).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) && !ecUtils.getInfoForDisplay(strDescriptor).equals(EgConfigConstants.CF_EMPTY))
			{
				if (!isDynamicMeasureTest)
				{
					tableHtmlData += "<tr><td colspan="+idx_msize+"id='eg_calth' style='font-weight:bold;padding:2px'>"+ecUtils.getInfoForDisplay(strDescriptor)+"</td></tr>";

					if (strDescriptor.equals("+"))
					{
						String tempTestNameStr = (String)rootObj.get("selectedReportTypeForTable");
						tmpObject.put("dataViewHeading",tempTestNameStr);
					}
					else
					{
						tmpObject.put("dataViewHeading",ecUtils.getInfoForDisplay(strDescriptor));
						egTableAttributes.setTitle(ecUtils.getInfoForDisplay(strDescriptor));
					}
				}
				else
				{
					ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(strDescriptor),"~M~");
					int aListTokensSize = aListTokens.size();
					String strData = "";
					for (int x=0;x<aListTokensSize;x++)
					{
						String infoHeading = (String)aListInfoHeadings.get(x);
						String strTemp = (String)aListTokens.get(x);
						if (x == aListTokensSize-1)
						{
							strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
						}
						else
						{
							strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
						}
					}
					egTableAttributes.setTitle(strData);

					tableHtmlData += "<tr><td colspan="+idx_msize+"id='eg_calth' style='font-weight:bold;padding:2px'>"+strData+"</td></tr>";

					tmpObject.put("dataViewHeading",strData);
				}
			}

			JSONArray gridColumn = new JSONArray();

			tableHtmlData += "<tr>";

			for (int j=0;j<idx_msize;j++)
			{
				tableHtmlData += "<td id='cell_header'>"+(String)aListAllMeasures.get(j)+"</td>";
				aListColumnNames.add("C"+j);
				userColumnNames.add((String)aListAllMeasures.get(j));
				gridColumn.add((String)aListAllMeasures.get(j));
			}
			tableHtmlData += "</tr>";

			JSONArray gridStore = new JSONArray();

			boolean hasXMLData = false;
			if (aListData != null && aListData.size() > 0)
			{
				for (int k = 0; k < aListData.size(); k++)
				{
					String val = (String)aListData.get(k);
					if (val.startsWith("<?configuration?>"))
					{
						hasXMLData = true;
						break;
					}
				}
			}


			for (int m=0;m<idx_dataSize;m=m+idx_msize)
			{
				tableHtmlData += "<tr>";

				JSONObject tmpStore = new JSONObject();
				int count = 0;
				for (int n=m;n<m+idx_msize;n++)
				{
					String strData = (String)aListData.get(n);

					if (!strData.startsWith("<?configuration?>"))
					{
						strData = EcUtils.replaceTags(strData);// added newly
					}

					if (hasXMLData)
					{
						// for UI
						strData = StringUtils.replace(strData,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");

						// for CSV
						String newStrData = StringUtils.replace(strData,"<?configuration?><config>","");
						newStrData = StringUtils.replace(newStrData,"</config>","");
						newStrData = StringUtils.replace(newStrData,"<ul>","");
						ArrayList tkns = StringUtils.myTokenizer(newStrData,"</ul>");
						int tknsSize = tkns.size();
						
						if ((n%2) == 1)
						{
							for (int c = 0; c < tknsSize; c++)
							{
								String strLine = (String)tkns.get(c);
								strLine = StringUtils.replace(strLine,"<ul>","");
								
								if (c == 0)
								{
									aListData_A.add(aListData.get(n-1)); // Columnname
								}
								else
								{
									aListData_A.add(""); // Columnname
								}

								if (strLine.equalsIgnoreCase("&nbsp;"))
								{
									aListData_A.add(""); // Columnvalue
								}
								else
								{
									aListData_A.add(strLine); // Columnvalue
								}
							}
						}
					}
					else
					{
						aListData_A.add(strData);
					}
					tableHtmlData += "<td id='cell_bg1'>"+strData+"</td>";

					String tmpData = StringUtils.replace((String)aListAllMeasures.get(count++)," ","");
					tmpData = StringUtils.replace(tmpData,")","");
					tmpData = StringUtils.replace(tmpData,"(","");
					tmpStore.put(StringUtils.replace(tmpData," ",""),strData);
				}
				tableHtmlData += "</tr>";

				gridStore.add(tmpStore);
			}
			tableHtmlData += "</table><table><tr><td height='5' id='blank' colspan="+idx_msize+">&nbsp;</td></tr></table>";

			tmpObject.put("gridColumn",gridColumn);
			tmpObject.put("gridStore",gridStore);

			//For new Pdf Framework
			EgTableModel egTableModel = new EgTableModel(aListData_A,aListColumnNames);

			egTableAttributes.setColumnNames(userColumnNames);

			EgTable egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);

			aListPdfData.add(egTable);
			consolidatedGridCollection.add(tmpObject);
		}

		tableHtmlData += "</td></tr></table></div>";

		//For new pdf framework
		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
		rootObj.put("consolidatedGridCollection",consolidatedGridCollection);
		rootObj.put("tableHtmlData",tableHtmlData);
	}
	else if (aListConsolidatedData != null && aListConsolidatedData.isEmpty())
	{
		rootObj.put("errorText",_mapping.getTextDescription("configmgmt.common.No result found for current selection") + ".");
	}
	else if (aListConsolidatedData == null)
	{
		rootObj.put("errorText",_mapping.getTextDescription("configmgmt.common.No result found for current selection") + ".");
	}
	rootObj.put("hiddenFields",hiddenFields);

	if(queryString !=null)
	{
		session.setAttribute("configLastAccessedURL","/final/config/EcConsolidatedViewIndex.jsp?"+queryString);
	}
	else
	{
		session.setAttribute("configLastAccessedURL","/final/config/EcConsolidatedViewIndex.jsp?cmd=ConsolidatedView");
	}

	out.println(rootObj.toString());
%>



