Ext.define('CurrentConfiguration.controller.Main', {
	extend : 'Ext.app.Controller',
	views : [
		'Main',
		'FormItems',
		'configutilities.Tools',
		'configutilities.PrintPreview',
		'configutilities.SendMail'
	],
	refs:[
		{
			selector : 'main', 
			ref : 'main'
		},
		{
			selector : 'formitems', 
			ref : 'formitems'
		},
		{
			selector : 'tools', 
			ref : 'tools'
		}
	],
	init :function() {
		appCnt = this;
		this.buildFieldData()
		this.control({
			'main': {
				'afterrender': this.afterMainRender
			},
			'main button[id="backBtnMain"]':{
				'click' : this.goBack
			},
			'formitems button[id="submit"]' :{
				'click' : this.showDetails
			},
			'formitems combobox[id="comptype"]' :{
				'select' : this.getInformation
			},
			'formitems combobox[id="comp"]' :{
				'select' : this.getInformation
			},
			'formitems combobox[id="ec_criteria"]' :{
				'select' : this.getDetails
			},
			'formitems combobox[id="ec_userOption"]' :{
				'select' : this.getDetails
			},
			//'formitems button[id="panelinsidetoggle"]': {
				//'click': this.toggleForm
			//},
			'tools' :{
				'afterrender' : this.loadTools
			},
			'tools button[id="saveBtn"]' : {
				'click' : this.saveAsPDF
			},
			'tools button[id="printBtn"]' : {
				'click' : this.printData
			},
			'tools button[id="csvBtn"]' : {
				'click' : this.saveAsCSV
			},
			'tools button[id="mailBtn"]' : {
				'click' : this.sendMail
			},
			'tools button[id="scheduleBtn"]' : {
				'click' : this.setschedule
			},
			'formitems trigger[id="infoSearch"]' : {
				'change' : this.filterMultiselect
			},
			'button[id="saveBtnViewGPO"]' : {
				'click' : this.saveAsGPOPDF
			},
			'button[id="printBtnViewGPO"]' : {
				'click' : this.printAsGPOData
			},
			'button[id="mailBtnViewGPO"]' : {
				'click' : this.sendMailAsGPOData
			}
		});
	},
	//toggleForm:function(obj)
	//{
		//Ext.getCmp('panelinsidetoggle').setDisabled(false);
		//var ornt = Ext.getCmp('formitems');
		//if (ornt.isHidden())
		//{
			//ornt.show();
			//Ext.getCmp('selectionDetails').hide();
		//}
		//else
		//{
			//ornt.hide();
			//Ext.getCmp('selectionDetails').show();
		//}
	//},
	buildFieldData : function()
	{
		Ext.Ajax.request({
			url : config.urls.servletURL,
			params : queryString+"&needData=yes",
			method : 'POST',
			async : false,
			success : function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) 
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					hiddenFieldsKeys = publicJSON['hiddenFields'];
					strRequestFrom = publicJSON['strReqForm'];
				}
			}
		});
	},

	afterMainRender : function()
	{
		me = this;
		if(strRequestFrom != null && (strRequestFrom == "Current" || strRequestFrom == "saveSchedule" || strRequestFrom == "thinClients")) //request from Current
		{
			var s_comptype = Ext.getCmp('comptype');
			var s_compname = Ext.getCmp('comp');
			var s_info = Ext.getCmp('info');
			var ec_userOption = Ext.getCmp('ec_userOption');
			var ec_criteria = Ext.getCmp('ec_criteria');

			ec_criteria.getStore().loadRawData(publicJSON['viewByList']);
			ec_criteria.setValue(publicJSON.selectedEcOpt);

			if (publicJSON.selectedEcOpt != 'Component')
			{
				ec_userOption.getStore().loadRawData(publicJSON.specViewByList);
				ec_userOption.setValue(publicJSON.selectedUserOptionText);
				ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
				ec_userOption.show();
			}
			else
			{
				ec_userOption.hide();
			}
			s_comptype.getStore().loadRawData(publicJSON['compTypes']);
			s_comptype.setValue(publicJSON.selectedCmpType);
			s_compname.getStore().loadRawData(publicJSON['compNames']);
			s_compname.setValue(publicJSON.selectedCmpName);
			s_info.getStore().loadRawData(publicJSON['infoList']);
			s_info.setValue(publicJSON.selectedTests);

			me.setToolsState(true,publicJSON.selectedCmpName);

			if (strRequestFrom != null && strRequestFrom == "saveSchedule")
			{
				Ext.getCmp('backBtnMain').show();
				Ext.getCmp('bkSeperator').show();
				Ext.getCmp('submit').setText('Save');
			}

			if (strRequestFrom == "thinClients")
			{
				me.showDetails("fromOtherPage");
			}
		}
		else //reqFrom other page
		{
			Ext.getCmp('backBtnMain').show();
			me.getFormitems().hide();
			me.getFormitems().setDisabled(true);
			Ext.getCmp('bkSeperator').show();
			Ext.getCmp('scheduleTool').hide();
			Ext.getCmp('schSep').hide();
			me.showDetails("fromOtherPage");
		}
	},

	loadTools : function()
	{
		this.getTools().loadIcon(true,true,true,true,true,true);
	},

	getInformation : function(obj)
	{
		me = this;
		var comp = Ext.getCmp('comp');
		var info = Ext.getCmp('info');
		var changefrom = obj.getId();
		if (changefrom == "comptype")
		{
			comp.setValue(publicJSON['compNames'][0].valueField);
		}
		var s_comptype = Ext.getCmp('comptype').getValue();
		var s_compname = comp.getValue();
		hiddenFields = publicJSON['hiddenFields'];
		var s_oldcomptype = hiddenFields.old_comptype;

		Ext.Ajax.request({
			url : config.urls.initialURL,
			params : {
				'request_from' : 'Current',
				'ec_component' : s_compname,
				'ec_comptype' : s_comptype,
				'old_comptype' : s_oldcomptype
			},
			method : 'POST',
			async : false,
			success : function( response ){
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					info.getStore().removeAll();
					info.getStore().loadRawData(publicJSON['infoList']);
					info.setValue(publicJSON.selectedTests)

					comp.getStore().removeAll();
					comp.getStore().loadRawData(publicJSON['compNames']);
					me.getMain().getComponent('resultPanel').hide();
					appCnt.setToolsState(true,s_compname);
				}
			},
			failure: function(response) // if result page doest not contain success:true, this method fires
			{
				Ext.MessageBox.alert("Ajax Failed","Error in updating details");
			}
		});
	},
	getDetails : function(obj)
	{
		hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		var ec_userOption = Ext.getCmp('ec_userOption');
		var ec_criteria = Ext.getCmp('ec_criteria');
		var s_comptype = Ext.getCmp('comptype');
		var s_compname = Ext.getCmp('comp');
		var s_info = Ext.getCmp('info');
		//Ext.getCmp('panelinsidetoggle').setDisabled(true);
		me.getMain().getComponent('resultPanel').hide();
		s_comptype.setDisabled(true);
		s_compname.setDisabled(true);
		s_info.setDisabled(true);
		if (ec_criteria.getValue() == "Component")
		{
			ec_userOption.setValue("");
		}
		this.getFormitems().submit({
				url : config.urls.configServletURL,
				params : hiddenFields+"cmd=CurrentConfig&needData=yes&request_from="+strRequestFrom+"&id="+id,
				method : 'POST',
				success : function(form, action){
					if ( action.response.status == 200 && !Ext.isEmpty( action.response.responseText ) ) 
					{
						publicJSON = Ext.decode(action.response.responseText);
						hiddenFieldsKeys = publicJSON.hiddenFields;
						ec_criteria.getStore().loadRawData(publicJSON.viewByList);
						ec_criteria.setValue(publicJSON.selectedEcOpt);
						if (publicJSON.selectedEcOpt != 'Component')
						{
							ec_userOption.getStore().loadRawData(publicJSON.specViewByList);
							ec_userOption.setValue(publicJSON.selectedUserOptionText);
							ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
							ec_userOption.show();
						}
						else
						{
							ec_userOption.hide();
						}
						s_comptype.getStore().loadRawData(publicJSON['compTypes']);
						s_comptype.setValue(publicJSON['compTypes'][0].valueField);
						s_compname.getStore().loadRawData(publicJSON['compNames']);
						s_compname.setValue(publicJSON['compNames'][0].valueField);
						s_info.getStore().loadRawData(publicJSON['infoList']);
						delete publicJSON;
						s_comptype.setDisabled(false);
						s_compname.setDisabled(false);
						s_info.setDisabled(false);
						appCnt.setToolsState(true,"-1");
					}
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					Ext.MessageBox.alert("Ajax Failed","Error in updating details");
				}
			});
	},
	showDetails : function(from)
	{
		if(from == "fromOtherPage") // req from other page
		{
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
			myMask.show();
			var url = "../servlet/com.eg.EcConfigurationServletNew";
			var thisForm = this.getFormitems().getForm();

			var newQryStr = queryString.replace("cmd=CurrentConfig&","");

			if(thisForm.isValid())
			{
				thisForm.submit({
					url : url,
					params : newQryStr+"&needData=yes",
					method : 'POST',
					success : function(form, action){
						myMask.hide();
						if(action.response.status == 200 && !Ext.isEmpty(action.response.responseText)) 
						{
							publicJSON = Ext.decode(action.response.responseText);
							if(publicJSON.hasCurrentConfig == true)
							{
								me.setToolsState(false,"showSchedule");
							}
							else
							{
								me.setToolsState(true,"-1");
							}

							var resultPanel = Ext.getCmp('resultPanel');
							var tableHtmlForm = publicJSON['tableHtmlData'];
							var panelLTitle = publicJSON.panelLTitle;
							var panelRTitle = publicJSON.panelRTitle;
							var panelRHeaderLink = publicJSON.panelRHeaderLink;

							resultPanel.show();
							resultPanel.removeAll();
							resultPanel.update(tableHtmlForm);
							resultPanel.doLayout();

							if ( panelLTitle != "" && panelLTitle != undefined && panelRTitle != "" && panelRTitle != undefined)
							{
								Ext.getCmp('resultPanel').setTitle('<div style="padding:2px;" class="font_bold12">'+panelLTitle+'</div>');
								Ext.getCmp('displayMessage2').update('<span  class="font_bold11"><a id="mouse" href="'+panelRHeaderLink+'" target="main" class="eg_monlink">'+panelRTitle+'</a></span>');
							}
							else
							{
								Ext.getCmp('resultPanel').setTitle('<div style="padding:0px;" class="font_bold12">&nbsp;</div>');
								Ext.getCmp('displayMessage2').update('<span  class="font_bold11">&nbsp;</span>');
							}
						}
					},
					failure: function(form, action) 
					{
						myMask.hide();
						Ext.MessageBox.alert("Ajax Failed","Error in updating details");
					}
				});
			}
		}
		else // req from Current
		{
			if (strRequestFrom != null && strRequestFrom == "saveSchedule")
			{
				appCnt.setschedule();
			}
			else
			{
				var checkFlag = me.componentSearch();
				if (checkFlag == false)
				{
					return false;
				}

				var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
				myMask.show();

				var thisForm = this.getFormitems().getForm();
				if (thisForm.isValid())
				{
					var selInfoValues = Ext.getCmp('info').getValue();
					var ec_userOption = Ext.getCmp('ec_userOption').getValue();
					var ec_criteria = Ext.getCmp('ec_criteria').getValue();
					var s_comptype = Ext.getCmp('comptype').getValue();
					var s_compname = Ext.getCmp('comp').getValue();

					// sorting the selected info list as per information multiselect list
					var fullInfoList = new Array();
					var newSelInfoValues = new Array();
					for(var i=0; i<publicJSON['infoList'].length; i++)
					{
						fullInfoList.push(publicJSON['infoList'][i].valueField);
					}
					for(var j=0; j < fullInfoList.length; j++)
					{
						for(var k=0; k<selInfoValues.length; k++)
						{
							if(fullInfoList[j] == selInfoValues[k])
							{
								newSelInfoValues.push(selInfoValues[k]);
							}
						}
					}

					Ext.Ajax.request({
						url : config.urls.servletURL,
						params: hiddenFields+"&ec_test="+newSelInfoValues+"&ec_component="+s_compname+"&ec_comptype="+s_comptype+"&ec_criteria="+ec_criteria+"&ec_userOption="+ec_userOption+"&navigatingFrom=Current",
						method : 'POST',
						success : function(response){
							myMask.hide();
							publicJSON = Ext.decode(response.responseText);
							me.loadResultData();
						},
						failure: function(response)
						{
							myMask.hide();
							Ext.MessageBox.alert("Ajax Failed","Error in updating details");
						}
					});
				}
			}
		}
	},
	loadResultData : function()
	{
		resultPanel = me.getMain().getComponent('resultPanel');
		var tableHtmlForm = publicJSON['tableHtmlData'];
		var panelLTitle = publicJSON.panelLTitle;
		var panelRTitle = publicJSON.panelRTitle;
		var panelRHeaderLink = publicJSON.panelRHeaderLink;

		if ( panelLTitle != "" && panelLTitle != undefined && panelRTitle != "" && panelRTitle != undefined)
		{
			Ext.getCmp('resultPanel').setTitle('<div  class="font_bold12">'+panelLTitle+'</div>');
			Ext.getCmp('displayMessage2').update('<span  class="font_bold11"><a id="mouse" href="'+panelRHeaderLink+'" target="main" class="eg_monlink">'+panelRTitle+'</a></span>');
		}
		else
		{
			Ext.getCmp('resultPanel').setTitle('<div class="font_bold12">&nbsp;</div>');
			Ext.getCmp('displayMessage2').update('<span class="font_bold11">&nbsp;</span>');
		}

		resultPanel.show();
		resultPanel.removeAll();
		resultPanel.update(tableHtmlForm);
		resultPanel.doLayout();

		var s_comptype = Ext.getCmp('comptype');
		var s_compname = Ext.getCmp('comp');
		var s_info = Ext.getCmp('info');
		var ec_userOption = Ext.getCmp('ec_userOption');
		var ec_criteria = Ext.getCmp('ec_criteria');


		//var objArr = Array();
		//objArr.push({key:"View By",value:ec_criteria.getDisplayValue()});
		//if (ec_criteria.getValue() != 'Component')
		//{
			//objArr.push({key:ec_userOption.getFieldLabel(),value:ec_userOption.getValue()});
		//}
		//var boundList = s_info.getSelected();
		//var selectedTextList = "";
		//for (node in boundList)
		//{
			//selectedTextList = selectedTextList + boundList[node].get("displayField") + ",";
		//}
		//selectedTextList = selectedTextList.substring(0,selectedTextList.length-1);
		//objArr.push({key:s_comptype.getFieldLabel(),value:s_comptype.getDisplayValue()});
		//objArr.push({key:s_compname.getFieldLabel(),value:s_compname.getDisplayValue()});
		//objArr.push({key:Ext.getCmp('infoLbl').el.getHTML(),value:selectedTextList});


		if (publicJSON.hasCurrentConfig)
		{
			//var tpl = new Ext.XTemplate(
				//'<tpl for=".">',
				//'<span style="margin-right:20px;margin-bottom:5px;float:left;"><span class="font_bold">{key}</span> - {value}</span>',
				//'</tpl>'
			//);
			//Ext.getCmp('selcetioninnerpanel').tpl=tpl;
			//Ext.getCmp('selcetioninnerpanel').update(objArr);
			//Ext.getCmp('panelinsidetoggle').setDisabled(false);
			Ext.getCmp('formitems').collapse();
			
			//Change identifier: 'SkipGPOconfigMsrs'
			//Change description: Skipping to show the GPO config XML measures for all the policies in print/pdf/email. 
			//                    Print/pdf/email options will be added in the view GPO pop up screen.
			//appCnt.setToolsState(false,publicJSON.selectedCmpName);
			
			var selectedTests =publicJSON.selectedTests;
			var selectedTestsList = selectedTests.split(",");
			
			//hide the controls of pdf/print/email/csv if GPO config test alone selected.
			if(selectedTestsList.length == 1 && (selectedTestsList[0] == "GPOConfigTest_cf"))
			{
				appCnt.setToolsState(true,"-1");
			}
			else
			{
				appCnt.setToolsState(false,publicJSON.selectedCmpName);
			}
			//Change ends for the change identifier 'SkipGPOconfigMsrs'			
			//appCnt.toggleForm();
		}
		else
		{
			appCnt.setToolsState(true,publicJSON.selectedCmpName);
		}

	},
	saveAsPDF : function()
	{
		//var getSaveObj = Ext.widget('savepdf');
		//getSaveObj.savePDF("/final/servlet/com.eg.EcPdfDownloadC");

		downloadAsPDF("/final/servlet/com.eg.EcPdfDownloadC");
	},
	printData : function()
	{
		var printQueryStr = publicJSON.printQueryStr;
		Ext.widget('print',{title : config.title.mainPageTitle}).show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set({
			src: printQueryStr
		});
	},
	saveAsCSV : function()
	{
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var ec_userOption = "";
		if (ec_criteria != 'Component')
		{
			 ec_userOption = Ext.getCmp('ec_userOption').getValue();
		}
		hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
		me.getFormitems().submit({
			url: '../servlet/com.eg.EcCSVController',
			params : 'ec_criteria='+ec_criteria+'&ec_userOption='+encodeURIComponent(ec_userOption)+'&'+hiddenFields,
			standardSubmit : true,
			method: 'POST'
		});
	},
	sendMail : function()
	{
		Ext.widget('sendmail').show();
	},
	saveAsGPOPDF : function()
	{
		downloadAsPDF("/final/servlet/com.eg.EcPdfDownloadC");
	},
	printAsGPOData : function()
	{
		var printQueryStr = viewGPOJSON.printQueryStr;
		Ext.widget('print',{title : config.title.mainPageTitle}).show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set({
			src: printQueryStr
		});
	},
	sendMailAsGPOData : function()
	{
		Ext.widget('sendmail').show();
	},
	setschedule : function()
	{
		var op = "schedule";
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var ec_userOption = Ext.getCmp('ec_userOption').getValue();
		var ec_component = Ext.getCmp('comp').getValue();
		var ec_comptype = Ext.getCmp('comptype').getValue();
		var ec_test = Ext.getCmp('info').getValue();
		if (op == "schedule")
		{
			if (strRequestFrom != null && strRequestFrom == "saveSchedule")
			{
				var checkFlag = me.componentSearch();
				if (checkFlag == false)
				{
					return false;
				}
				hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
				me.getFormitems().submit({
					url: '/final/config/EcSaveScheduleNew.jsp',
					params : 'id='+id+'&ec_criteria='+ec_criteria+'&ec_userOption='+encodeURIComponent(ec_userOption)+'&'+hiddenFields+'&ec_comptype='+ec_comptype+'&ec_test='+ec_test,
					standardSubmit : true,
					method: 'POST'
				});
			}
			else
			{
				hiddenFieldsKeys = publicJSON.hiddenFields;
				hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
				urlStr = "/final/config/EcSaveScheduleNew.jsp?id="+id+"&request_from=Current&"+hiddenFields+"ec_criteria="+ec_criteria+"&ec_userOption="+encodeURIComponent(ec_userOption)+"&ec_component="+ec_component+"&ec_comptype="+ec_comptype+"&ec_test="+ec_test+"&showWindow=yes&com.eg.CSRF_NONCE="+csrfToken;
				scheduleWindow(urlStr);
			}
		}
		else if (op =="favorite")
		{
			urlStr = "/final/config/EcSaveFavorite.jsp";
		}
		else
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,".Illegal Access");
			return false;
		}
	},
	componentSearch : function()
	{
		var s_compname = Ext.getCmp('comp').getValue();
		var s_info = Ext.getCmp('info').getValue();

		var hiddenFieldsKeys = publicJSON['hiddenFields'];
		hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		
		var ec_criteria = Ext.getCmp('ec_criteria');
		var ec_userOption = Ext.getCmp('ec_userOption');
		var tempCriteria = "";
		var tempUserOption = "";

		if (ec_criteria != null && ec_criteria != undefined)
		{
			tempCriteria = ec_criteria.getValue();
		}
		if (ec_userOption != null && ec_userOption != undefined)
		{
			tempUserOption = ec_userOption.getValue();
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorZone);
					return false;
				}
				else if (tempCriteria == "Service")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorService);
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorSegment);
					return false;
				}
			}
		}

		if(s_compname == -1)
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.error1);
			return false;
		}

		if(s_info == "-1" || s_info == '')
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorInfo);
			return false;
		}
	},
	setToolsState : function(iconState,compName)
	{
		var saveObj =me.getTools().getComponent('saveTool');
		var printObj =me.getTools().getComponent('printTool');
		var mailObj =me.getTools().getComponent('mailTool');
		var csvObj =me.getTools().getComponent('csvTool');
		var scheduleToolObj = me.getTools().getComponent('scheduleTool');
		var combineBookletObj = me.getTools().getComponent('bookletTool');
		if (!Ext.isEmpty(saveObj)) {
			saveObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(printObj)) {
			printObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(mailObj)) {
			mailObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(csvObj)) {
			csvObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(combineBookletObj)) {
			combineBookletObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(scheduleToolObj) && compName != '-1') {
			scheduleToolObj.setDisabled(false);
		}
		else
		{
			scheduleToolObj.setDisabled(iconState);
		}
	},
	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+hiddenFields[key]+"&";
		}
		return hiddenQstr;
	},
	goBack : function()
	{
		var ec_criteria = publicJSON.ec_criteria;
		var ec_userOption = publicJSON.ec_userOption;
		var me = this;

		if (publicJSON.goBack)
		{
			window.history.back();
		}
		else if (publicJSON.isReqFromCompsView)
		{
			hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			me.getFormitems().submit({
				url : '../servlet/com.eg.EcConfigurationServletNew',
				params : 'cmd=ComponentsView&requestFrom='+strRequestFrom+'&clickOn='+clickOn+"&"+hiddenFields+"&ec_criteria="+ec_criteria+"&ec_userOption="+encodeURIComponent(ec_userOption)+"&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if (publicJSON.isReqFromBoxView)
		{
			me.getFormitems().submit({
				url : '../servlet/com.eg.EcConfigurationServletNew',
				params : "cmd=BoxView&isOwnPageRequest=yes&searchValue="+publicJSON.searchValue+"&systemName="+publicJSON.systemName+"&ec_criteria="+ec_criteria+"&ec_userOption="+encodeURIComponent(ec_userOption)+"&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
			//window.history.back();
		}
		else if (strRequestFrom != null && strRequestFrom == "saveSchedule")
		{
			hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			me.getFormitems().submit({
				url: '/final/config/EcSaveScheduleNew.jsp',
				params : 'request_from='+strRequestFrom+'&id='+id+'&'+hiddenFields+"&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
	},

	filterMultiselect: function (obj) 
	{
		this.filterComboStore(obj,Ext.getCmp('info'),publicJSON['infoList']);
		obj.toggleTriggger();
    },

	filterComboStore : function(searchFieldObj,comboObj,compStore)
	{
		var findVal = searchFieldObj.getValue().toLowerCase();
		if (Ext.isEmpty(findVal))
		{
			comboObj.getStore().loadRawData(compStore);
			comboObj.setValue(compStore[0]['valueField']);
		}
		else 
		{
			var isRecordFound = false;
			var genStore = new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			});

			for (var i = 0; i < compStore.length; i++)
			{
				var valueFied = compStore[i]['valueField'].toLowerCase();
				if(valueFied.indexOf('-1') !=0)
				{
					var getRecord = compStore[i]['displayField'].toLowerCase();
					if (getRecord.indexOf(findVal) > -1) 
					{
						isRecordFound = true;
						genStore.add({
							'displayField': compStore[i]['displayField'],
							'valueField': compStore[i]['valueField']
						});
					}
				}
			}
			if (isRecordFound)
			{
				comboObj.getStore().removeAll();
				for (var i = 0; i < genStore.getCount(); i++)
				{
					var getRecord = genStore.getAt(i);
					comboObj.getStore().add(getRecord);
				}
				comboObj.setValue(genStore.getAt(0).get('valueField'));
			} 
			else 
			{
				comboObj.getStore().removeAll();
				comboObj.getStore().add({
					'displayField': 'Not Applicable!',
					'valueField': '-1'
				});
				comboObj.setValue('-1');
			}
		}
		searchFieldObj.focus();
	}
	,showGPO_Content : function(policyId,ec_component)
	{	
		Ext.Ajax.request({
			url : config.urls.servletURL,
			params: "ec_rtype=Current&isViewPolicy=true&policyId="+encodeURIComponent(filterEncode(policyId))+"&ec_component="+ec_component,
			method : 'POST',
			success : function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
				{
					viewGPOJSON = Ext.decode(response.responseText);
					
					var policyHtmlContent = viewGPOJSON[policyId];
					if( (policyHtmlContent != null) && (policyHtmlContent.trim() != '')  && (policyHtmlContent.trim() != 'undefined') )
					{
						var policyContentWindow = Ext.create('Ext.window.Window', 
						{
							title: policyId,
							width:'90%',
							height:'90%',
							scroll:false,
							autoScroll:true,
							closable:true,
							layout:'fit',
							closeAction:'destroy',
							modal: true,
							dockedItems: [{
								xtype: 'toolbar',
								dock: 'top',
								border: false,
								height:30,
								padding:'5 10 5 5',
								ui:'toolbarBgWithBottomBorder',
								items: [
								'->',
								{
									xtype: 'container',
									id:'saveToolWin',
									items: [
										{
											xtype: 'button',
											iconCls: 'iconPdf',
											id: 'saveBtnViewGPO',
											style: {
												background: 'none',
												border: '0px'
											},
											listeners: {
												afterrender: function () {
													Ext.create('Ext.tip.ToolTip', {
														target: this.id,
														anchor: 'top',
														cls: 'yellowTip',
														trackMouse: true,
														html: 'Save'
													});
												}
											}
										}
									]
								},
								{
									xtype:'tbseparator'
								},{
									xtype: 'container',
									id:'printToolWin',
									items: [
										{
											xtype: 'button',
											iconCls: 'iconPrinter',
											id: 'printBtnViewGPO',
											style: {
												background: 'none',
												border: '0px'
											},
											listeners: {
												afterrender: function () {
													Ext.create('Ext.tip.ToolTip', {
														target: this.id,
														anchor: 'top',
														cls: 'yellowTip',
														trackMouse: true,
														html: 'Print'
													});
												}
											}
										}
									]
								},
								{
									xtype:'tbseparator'
								},{
									xtype: 'container',
									id:'mailToolWin',
									items: [
										{
											xtype: 'button',
											iconCls: 'iconMail',
											id: 'mailBtnViewGPO',
											style: {
												background: 'none',
												border: '0px'
											},
											listeners: {
												afterrender: function () {
													Ext.create('Ext.tip.ToolTip', {
														target: this.id,
														anchor: 'top',
														cls: 'yellowTip',
														trackMouse: true,
														html: 'Mail'
													});
												}
											}
										}
									]
								}]
							}],
							items:[{
								xtype:'container',
								padding:10,
								id:'policyContentContainer',
								listeners:
								{
									render:function()
									{
										Ext.get('policyContentContainer').dom.innerHTML = policyHtmlContent;
									}
								}
							}]
						}).show();
						policyContentWindow.on("close",function() 
						{
							Ext.Ajax.request({
								url : config.urls.servletURL,
								params: "ec_rtype=Current&isViewPolicy=true&closeWindow=yes",
								method : 'POST',
								failure: function(response)
								{
									Ext.MessageBox.alert("", config.msgs.smthngWntWrng + '. ' + config.msgs.refreshCurCnfPg);
								}

							});
							policyContentWindow.destroy();
						});

					}
					else
					{
						Ext.MessageBox.alert("", config.msgs.smthngWntWrng);
					}
					
				}
			},
			failure: function(response)
			{
				Ext.MessageBox.alert("", config.msgs.smthngWntWrng);
			}
		});
	}
});

function doCloseWin()
{
	Ext.getCmp('scheduleWin').destroy();
}



