Ext.define('DashboardSettings.controller.Main',{
	extend : 'Ext.app.Controller',
	views : [
		'FormItems'
	],
	refs : [
		{
			selector : 'formitems', 
			ref : 'formitems'
		}
	],

	init : function()
	{
		thisCtrl = this;
		this.buildFieldData()
		this.control({
			'formitems' :{
				'afterrender' : this.afterMainRender
			},
			'formitems button[id="update"]' :{
				'click' : this.setData
			}
		});
	},


	buildFieldData : function()
	{
		Ext.Ajax.request({
			url : config.urls.servletURL,
			params : queryString+"&needData=yes",
			method : 'POST',
			async : false,
			success : function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) 
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
				}
			}
		});
	},

	
	afterMainRender : function()
	{
		var viewByObj = Ext.getCmp('viewBy');
		var byOSObj = Ext.getCmp('byOS');
		var byOSVersionObj = Ext.getCmp('byOsVersion');
		var showCountObj = Ext.getCmp('showCount');
		var daywiseChangeObj = Ext.getCmp('daywiseChange');
		var componentNameChangeObj = Ext.getCmp('componentNameChange');
		var componentTypeChangeObj = Ext.getCmp('componentTypeChange');

		viewByObj.getStore().loadRawData(publicJSON.viewByList);
		viewByObj.setValue(publicJSON.selectedViewByOpt);

		var osCheck = publicJSON.osCheck;

		if (!Ext.isEmpty(osCheck) && osCheck == 'true')
		{
			byOSObj.setValue(true);
		}
		
		if (!Ext.isEmpty(osCheck) && osCheck == 'false')
		{
			byOSVersionObj.setValue(true);
		}

		showCountObj.getStore().loadRawData(publicJSON.topNCountList);
		showCountObj.setValue(publicJSON.selectedCount);

		daywiseChangeObj.getStore().loadRawData(publicJSON.daywiseList);
		daywiseChangeObj.setValue(publicJSON.selectedDaywiseCount);

		componentNameChangeObj.getStore().loadRawData(publicJSON.changeList);
		componentNameChangeObj.setValue(publicJSON.selectedChangesAtGlanceCount);

		componentTypeChangeObj.getStore().loadRawData(publicJSON.changeList);
		componentTypeChangeObj.setValue(publicJSON.selectedChangeSummaryCount);
	},


	setData : function()
	{
		var osVersion;
		var viewByObj = Ext.getCmp('viewBy').getValue();
		var byOSObj = Ext.getCmp('byOS').getValue();
		var byOSVersionObj = Ext.getCmp('byOsVersion').getValue();
		var showCountObj = Ext.getCmp('showCount').getValue();
		var daywiseChangeObj = Ext.getCmp('daywiseChange').getValue();
		var componentNameChangeObj = Ext.getCmp('componentNameChange').getValue();
		var componentTypeChangeObj = Ext.getCmp('componentTypeChange').getValue();

		if(byOSObj == true)
		{
			osVersion = "By Operating system";
		}
		else if(byOSVersionObj == true)
		{
			osVersion = "By OS Version";
		}

		var myForm = thisCtrl.getFormitems().getForm();

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();

		if(myForm.isValid())
		{
			myForm.submit({
				url : config.urls.servletURL,
				params : 'cmd=DashboardSetting&osVersion='+osVersion+'&topN=-'+'&showCount='+showCountObj+'&daywiseChange='+daywiseChangeObj+'&componentNameChange='+componentNameChangeObj+'&componentTypeChange='+componentTypeChangeObj+'&flagValue=insert&viewBy='+viewByObj+'&needData=yes',
				method : 'POST',
				async : false,
				success : function( form, action )
				{
					myMask.hide();
					Ext.Msg.alert (config.title.mainPageTitle,config.msg.alertMsg);
				}
			});
		}
	}
});



