Ext.define('DashboardSettings.view.FormItems', {
	extend : 'Ext.form.Panel',
	alias : 'widget.formitems',
	id : 'formitems',
	cls:'outerpanel',
	margin: '8 8 0 8',
	title : config.title.mainPageTitle,

	dockedItems: [
		{
			xtype: 'toolbar',
			cls:'adminHeadInfoText',
			dock: 'top',
			height: 25,
			border:true,
			padding: 3,
			layout:{pack:'center'},
			items: [
				{
					xtype: 'component',
					html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+config.title.infoLabelTitle+'.</center>'
				}
			]
		}
	],

	items : [
		{
			xtype : 'container',
			id : 'infoCont',
			margin : 10,
			layout : {
				type : 'vbox',
				pack : 'start',
				align : 'center'
			},
			defaults : {
				labelSeparator : '',
				labelAlign : 'left',
				labelWidth : 250,
				margin: 5
			},
			items : [
				{
					xtype:'combo',
					cls: 'dropdown',
					editable : false,
					fieldLabel : config.title.viewByTitle,
					name: 'viewBy',
					id: 'viewBy',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					width: 500
				},
				{
					xtype: 'radiogroup',
					cls:'radiobt',
					fieldLabel : config.title.MachineDstrTitle, 
					columns: 2,
					vertical: false,
					id: 'machineDistributionId',
					items: [
						{ boxLabel: 'By OS', name: 'osVersion', inputValue: 'Yes', checked: true, id: 'byOS'},
						{ boxLabel: 'By OS Version', name: 'osVersion', inputValue: 'No', id: 'byOsVersion'}
					],
					width: 500
				},
				{
					xtype : 'combo',
					cls: 'dropdown',
					id : 'showCount',
					fieldLabel : config.title.AvailStatusTitle,
					itemId : 'showCount',
					name : 'showCount',
					store :  new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
					editable : false,
					width: 500
				},
				{
					xtype : 'combo',
					cls: 'dropdown',
					id : 'daywiseChange',
					fieldLabel : config.title.daywiseTitle,
					itemId : 'daywiseChange',
					name : 'daywiseChange',
					store :  new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
					editable : false,
					width: 500
				},
				{
					xtype : 'combo',
					cls: 'dropdown',
					id : 'componentNameChange',
					fieldLabel : config.title.chgAtGlanceTitle,
					itemId : 'componentNameChange',
					name : 'componentNameChange',
					store :  new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
					editable : false,
					width: 500
				},
				{
					xtype : 'combo',
					cls: 'dropdown',
					id : 'componentTypeChange',
					itemId : 'componentTypeChange',
					name : 'componentTypeChange',
					fieldLabel : config.title.chgSumTitle,
					store :  new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
					editable : false,
					width: 500
				},
				{
					xtype : 'button',
					text : config.title.submitTitle,
					action : 'submit',
					id : 'update',
					cls: 'button20',
					margin: '20 0 0 0',
					width: 80
				}
			]
		}
	]
});




