Ext.define('DayWiseChangeSummary.controller.Main', {
	extend : 'Ext.app.Controller',
	views : [
		'Main',
		'FormItems',
		'configutilities.Tools',
		'configutilities.PrintPreview',
		'configutilities.SendMail',
		'configutilities.TimeLine',
		'DayWiseSummaryChart'
	],
	refs :[
		{
			selector : 'main', 
			ref : 'main'
		},
		{
			selector : 'formitems', 
			ref : 'formitems'
		},
		{
			selector : 'tools', 
			ref : 'tools'
		},
		{
			selector : 'timeline', 
			ref : 'timeline'
		},
		{
			selector : 'formitems #hiddenFieldsCt',
			ref : 'hiddenFieldsCt'
		},
		{
			selector : 'daywisesummarychart',
			ref : 'daywisesummarychart'
		}
	],
	init :function() {
		me = this;
		this.buildFieldData()
		this.control({
			'main': {
				'afterrender': this.afterMainRender
			},
			'formitems':{
				'boxready': this.loadChart
			},
			'tools' :{
				'afterrender' : this.loadTools
			},
			'formitems combobox[id="componentType"]' :{
				'select' : this.loadContainer
			},
			'formitems combobox[id="ec_criteria"]' :{
				'select' : this.getInformation
			},
			'formitems combobox[id="ec_userOption"]' :{
				'select' : this.getInformation
			},
			'timeline combo[id="ec_timeline"]':
			{
				'select': this.changeTimeLine
			},
			'formitems button[id="submit"]' :{
				'click' : this.showDetails
			},
			'tools button[id="saveBtn"]' : {
				'click' : this.saveAsPDF
			},
			'tools button[id="printBtn"]' : {
				'click' : this.printData
			},
			'tools button[id="csvBtn"]' : {
				'click' : this.saveAsCSV
			},
			'tools button[id="mailBtn"]' : {
				'click' : this.sendMail
			},
			'tools button[id="scheduleBtn"]' : {
				'click' : this.setschedule
			},
			'main #backBtnMain': {
				'click': this.forwardRequestedURI
			}
		});
	},
	loadContainer : function()
	{
		Ext.getCmp('summary').hide();
	},
	buildFieldData : function()
	{
		Ext.Ajax.request({
			url : config.urls.servletURL,
			params : queryString+"&needData=yes",
			method : 'POST',
			async : false,
			success : function( response ){
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					hiddenFieldsKeys = publicJSON['hiddenFields'];
					timeLineCollection = publicJSON['hiddenCollections'];
					backOperation = publicJSON['backOperation'];
				}
			}
		});
	},
	afterMainRender : function()
	{
		var s_comptype = me.getFormitems().getComponent('infoCont').getComponent('componentType');
		var ec_userOption = me.getFormitems().getComponent('infoCont').getComponent('ec_userOption');
		var ec_criteria = me.getFormitems().getComponent('infoCont').getComponent('ec_criteria');

		if (publicJSON.selectedEcOpt != 'Component')
		{
			ec_userOption.getStore().loadRawData(publicJSON.specViewByList);
			ec_userOption.setValue(publicJSON.selectedUserOptionText);
			ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
			if (publicJSON.specViewByTitle == null || publicJSON.specViewByTitle == undefined)
			{
				ec_userOption.setValue(ec_userOption.getStore().getAt(0).get("valueField"));
			}
			ec_userOption.show();
		}
		else
		{
			ec_userOption.hide();
		}

		ec_criteria.getStore().loadRawData(publicJSON['viewByList']);
		ec_criteria.setValue(publicJSON.selectedEcOpt);
		s_comptype.getStore().loadRawData(publicJSON['compTypes']);
		if (publicJSON.selectedCmpType == null || publicJSON.selectedCmpType == undefined)
		{
			s_comptype.setValue(s_comptype.getStore().getAt(0).get("valueField"));
		}
		else
		{
			s_comptype.setValue(publicJSON.selectedCmpType);
		}
		me.setToolsState(true,publicJSON.selectedCmpType);
		me.fillTimeLineView();
	},
	fillTimeLineView : function()
	{
		var ec_timeline = me.getTimeline().getComponent('ec_timeline');
		var ec_stdate = me.getTimeline().getComponent('ec_stdate');
		var ec_sthr = me.getTimeline().getComponent('ec_sthr');
		var ec_startmin = me.getTimeline().getComponent('ec_startmin');
		var ec_enddate = me.getTimeline().getComponent('ec_enddate');
		var ec_endhr = me.getTimeline().getComponent('ec_endhr');
		var ec_endmin = me.getTimeline().getComponent('ec_endmin');

		ec_timeline.getStore().loadRawData(publicJSON.timeLineDetails.ec_timelineArr);
		ec_timeline.setValue(publicJSON.timeLineDetails.selectedTimeLine);
		ec_timeline.setFieldLabel(publicJSON.timeLineDetails.TimeLineLabel);

		// From Date
		ec_stdate.setValue(publicJSON.timeLineDetails.ec_stdate);
		ec_stdate.setFieldLabel(publicJSON.timeLineDetails.FromLabel);

		//hrs
		ec_sthr.getStore().loadRawData(publicJSON.timeLineDetails.ec_sthr);
		ec_sthr.setValue(publicJSON.timeLineDetails.selectedStartHr);
		ec_sthr.setFieldLabel(publicJSON.timeLineDetails.FromHrLabel);

		//mins
		ec_startmin.getStore().loadRawData(publicJSON.timeLineDetails.ec_startmin);
		ec_startmin.setValue(publicJSON.timeLineDetails.selectedStartMin);
		ec_startmin.setFieldLabel(publicJSON.timeLineDetails.FromMinsLabel);

		//// To Date
		ec_enddate.setValue(publicJSON.timeLineDetails.ec_enddate);
		ec_enddate.setFieldLabel(publicJSON.timeLineDetails.ToLabel);

		//hrs
		ec_endhr.getStore().loadRawData(publicJSON.timeLineDetails.ec_endhr);
		ec_endhr.setValue(publicJSON.timeLineDetails.selectedEndHr);
		ec_endhr.setFieldLabel(publicJSON.timeLineDetails.ToHrLabel);

		//min
		ec_endmin.getStore().loadRawData(publicJSON.timeLineDetails.ec_endmin);
		ec_endmin.setValue(publicJSON.timeLineDetails.selectedEndMin);
		ec_endmin.setFieldLabel(publicJSON.timeLineDetails.ToMinsLabel);

		if (publicJSON.timeLineDetails.selectedTimeLine == "Any")
		{
			ec_stdate.setDisabled(false);
			ec_sthr.setDisabled(false);
			ec_startmin.setDisabled(false);

			ec_enddate.setDisabled(false);
			ec_endhr.setDisabled(false);
			ec_endmin.setDisabled(false);
		}
		else
		{
			ec_stdate.setDisabled(true);
			ec_sthr.setDisabled(true);
			ec_startmin.setDisabled(true);

			ec_enddate.setDisabled(true);
			ec_endhr.setDisabled(true);
			ec_endmin.setDisabled(true);
		}
		if ((strRequestFrom != null && strRequestFrom == "saveSchedule") || (strRequestStart != null && strRequestStart == "saveSchedule"))
		{
			Ext.getCmp('backBtnMain').show();
			Ext.getCmp('bkSeperator').show();
			Ext.getCmp('submit').setText('Save');
		}
	},
	getInformation : function(obj)
	{
		Ext.getCmp('summary').hide();
		var s_comptype = me.getFormitems().getComponent('infoCont').getComponent('componentType');
		var componentType =  s_comptype.getValue();
		var ec_criteria = me.getFormitems().getComponent('infoCont').getComponent('ec_criteria');
		var ec_userOption = me.getFormitems().getComponent('infoCont').getComponent('ec_userOption');
		var str_ec_timeline = "";
		var tempCriteria ="";
		var tempCriteriaPrevious ="";
		var tempUserOption ="";
		var tempUserOptionPrevious ="";
		me.setToolsState(true,componentType);

		var tempCriteria = "";
		var tempUserOption = "";
		if (ec_criteria != null &&ec_criteria != undefined)
		{
			tempCriteria = ec_criteria.getValue();
		}
		if (ec_userOption != null && ec_userOption != undefined && tempCriteria != 'Component')
		{
			tempUserOption = ec_userOption.getValue();
		}

		if (hiddenFieldsKeys.ec_criteriaPrevious != null && hiddenFieldsKeys.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = hiddenFieldsKeys.ec_criteriaPrevious;
		}
		if (hiddenFieldsKeys.ec_userOptionPrevious != null && hiddenFieldsKeys.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = hiddenFieldsKeys.ec_userOptionPrevious;
		}
		if (tempCriteria != "" && tempCriteriaPrevious != "")
		{
			if (tempCriteria == tempCriteriaPrevious)
			{
				if (tempUserOption != tempUserOptionPrevious)
				{
					componentType = "All";
					str_ec_timeline = "1 day";
				}
			}
			else
			{
				componentType = "All";
				str_ec_timeline = "1 day";
			}
		}
		var hiddenFieldsStr = me.getHiddenFields(hiddenFieldsKeys);
		this.storeHiddenFields(timeLineCollection);

		me.getFormitems().submit({
			url: config.urls.configServletURL,
			params : hiddenFieldsStr+'cmd=DaywiseChangeDistributionNew&needData=yes&request_from='+strRequestFrom+'&id='+id+'&componentType='+componentType+' &ec_timeline='+str_ec_timeline+ '&request_start='+strRequestStart+'&date='+new Date().getTime(),
			method: 'POST',
			success: function(form, action){
				publicJSON = Ext.decode(action.response.responseText);
				hiddenFieldsKeys = publicJSON.hiddenFields;
				timeLineCollection = publicJSON.hiddenCollections;
				backOperation = publicJSON.backOperation;

				if (publicJSON.selectedEcOpt != 'Component')
				{
					if (obj.getId() != "ec_userOption")
					{
						ec_userOption.getStore().loadRawData(publicJSON.specViewByList);
						ec_userOption.setValue(publicJSON.selectedUserOptionText);
						ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
						if (publicJSON.specViewByTitle == null || publicJSON.specViewByTitle == undefined)
						{
							ec_userOption.setValue(ec_userOption.getStore().getAt(0).get("valueField"));
						}
					}
					ec_userOption.show();
				}
				else
				{
					ec_userOption.hide();
				}
				s_comptype.getStore().loadRawData(publicJSON['compTypes']);
				s_comptype.setValue(publicJSON.selectedCmpType);
				if (publicJSON.selectedCmpType == null || publicJSON.selectedCmpType == undefined)
				{
					s_comptype.setValue(s_comptype.getStore().getAt(0).get("valueField"));
				}
				else
				{
					s_comptype.setValue(publicJSON.selectedCmpType);
				}
				me.fillTimeLineView();
				me.setToolsState(true,publicJSON.selectedCmpType);
				delete publicJSON;
			},
			failure: function(form, action) 
			{
				Ext.MessageBox.alert("Ajax Failed","Error in updating details");
			}
		});
	},
	changeTimeLine : function()
	{
		var componentType = me.getFormitems().getComponent('infoCont').getComponent('componentType').getValue();
		var tempCriteria = me.getFormitems().getComponent('infoCont').getComponent('ec_criteria').getValue();
		var tempUserOption = "";
		if (tempCriteria != 'Component')
		{
			tempUserOption =  me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').getValue();
		}

		me.setToolsState(true,componentType);

		var hiddenFieldsStr = me.getHiddenFields(hiddenFieldsKeys);
		this.storeHiddenFields(timeLineCollection);

		var ec_stdate = Ext.Date.dateFormat(Ext.getCmp('ec_stdate').getValue(), mgrDateFormat);
		var ec_enddate = Ext.Date.dateFormat(Ext.getCmp('ec_enddate').getValue(), mgrDateFormat);

		me.getFormitems().submit({
			url: config.urls.initialURL,
			params : hiddenFieldsStr+'request_from=Timeline'+'&id='+id+ '&request_start='+strRequestStart+'&ec_criteria='+tempCriteria+'ec_userOption='+ec_userOption+'&date='+new Date().getTime()+'&ec_stdate='+ec_stdate+'&ec_enddate='+ec_enddate,
			method: 'POST',
			success: function(form, action){
				publicJSON = Ext.decode(action.response.responseText);
				timeLineCollection = publicJSON.hiddenCollections;
				backOperation = publicJSON.backOperation;

				me.fillTimeLineView();
				me.getHiddenFieldsCt().removeAll();
				delete publicJSON;
			},
			failure: function(form, action) // if result page doest not contain success:true, this method fires
			{
				Ext.MessageBox.alert("Ajax Failed","Error in updating details");
			}
		});
	},
	showDetails : function()
	{
		if (strRequestFrom != null && strRequestFrom == "saveSchedule")
		{
			me.setschedule();
		}
		else
		{
			var checkFlag = me.componentSearch();
			if (checkFlag == false)
			{
				return false;
			}
			var thisForm = this.getFormitems().getForm();
			hiddenFieldsKeys = publicJSON.hiddenFields;
			hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			this.storeHiddenFields(timeLineCollection);

			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
			myMask.show();

			if(thisForm.isValid())
			{
				this.getFormitems().submit({
					url : config.urls.servletURL,
					params : hiddenFields+"cmd=DaywiseChangeDistributionNew&needData=yes&request_start="+strRequestStart+"&componentType="+componentType,
					method : 'POST',
					success : function(form, action){
						myMask.hide();
						publicJSON = Ext.decode(action.response.responseText);
						//me.loadChartCt();
						//printQueryStr = publicJSON.printURL;
						//me.getFormitems().getComponent('chartPanel').show();
						
						if (publicJSON.hasConfigDetails)
						{
							me.setToolsState(false,componentType);
						}
						else
						{
							me.setToolsState(true,componentType);
						}
						me.loadChart();
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
						Ext.MessageBox.alert("Ajax Failed","Error in updating details");
					}
				});
			}
		}
	},
	componentSearch : function()
	{
		var componentType = me.getFormitems().getComponent('infoCont').getComponent('componentType').getValue();
		var ec_criteria = me.getFormitems().getComponent('infoCont').getComponent('ec_criteria');
		var ec_userOption = me.getFormitems().getComponent('infoCont').getComponent('ec_userOption');
		var tempCriteria = "";
		var tempUserOption = "";

		if (ec_criteria != null && ec_criteria != undefined)
		{
			tempCriteria = ec_criteria.value;
		}
		if (ec_userOption != null && ec_userOption != undefined)
		{
			tempUserOption = ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorZone);
					return false;
				}
				else if (tempCriteria == "Service")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorService);
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorSegment);
					return false;
				}
			}
		}

		if(componentType == -1)
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.error1);
			return false;
		}

		var ec_timeline = me.getTimeline().getComponent('ec_timeline').getValue();

		if (ec_timeline == "Any")
		{
			var startDate = me.getTimeline().getComponent('ec_stdate').getValue();
			var startHr = me.getTimeline().getComponent('ec_sthr').getValue();
			var startMin = me.getTimeline().getComponent('ec_startmin').getValue();

			var endDate = me.getTimeline().getComponent('ec_enddate').getValue();
			var endHr = me.getTimeline().getComponent('ec_endhr').getValue();
			var endMin = me.getTimeline().getComponent('ec_endmin').getValue();

			var curDateInExtjsFormat = getExtjsDateFormat(currentDateFormat);

			//Convert to original format(i.e., to MM/dd/yyyy)
			var startdate1 = Ext.Date.dateFormat(startDate, curDateInExtjsFormat);
			var enddate1 = Ext.Date.dateFormat(endDate, curDateInExtjsFormat);

			var sDate = formatDate(new Date(getDateFromFormat(startdate1,currentDateFormat)),"MM/dd/yyyy");
			var eDate = formatDate(new Date(getDateFromFormat(enddate1,currentDateFormat)),"MM/dd/yyyy");

			if(!validateDateTime(sDate,eDate,startHr,endHr,startMin,endMin))
			{
				Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorTimeLine);
				return false;
			}
		}
	},
	forwardRequestedURI : function()
	{
		if ((strRequestFrom != null && strRequestFrom == "saveSchedule") || (strRequestStart != null && strRequestStart == "saveSchedule"))
		{
			var me = this;
			hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			me.getFormitems().submit({
				url: '/final/config/EcSaveScheduleNew.jsp',
				params : 'request_from='+strRequestFrom+'&id='+id+'&'+hiddenFields+"&currentDateFormat="+currentDateFormat+"&pageFrom=applink",
				standardSubmit : true,
				method: 'POST'
			});
		}
	},
	loadChart : function()
	{
		if (publicJSON.hasConfigDetails)
		{
			Ext.getCmp('formitems').collapse();
		}
		if (publicJSON.hasResultText)
		{
			Ext.getCmp('summary').setTitle(publicJSON.resultHeaderText);
			me.getDaywisesummarychart().loadChart(publicJSON,me);
			Ext.getCmp('summary').show();
		}
		else
		{
			Ext.getCmp('summary').getHeader().hide();
			Ext.getCmp('summary').hide();
		}
	},
	loadTools : function()
	{
		this.getTools().loadIcon(true,true,true,true,true,true);
	},
	setToolsState : function(iconState,compType)
	{
		var saveObj =me.getTools().getComponent('saveTool');
		var printObj =me.getTools().getComponent('printTool');
		var mailObj =me.getTools().getComponent('mailTool');
		var csvObj =me.getTools().getComponent('csvTool');
		var scheduleToolObj = me.getTools().getComponent('scheduleTool');
		var combineBookletObj = me.getTools().getComponent('bookletTool');
		if (!Ext.isEmpty(saveObj)) {
			saveObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(printObj)) {
			printObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(mailObj)) {
			mailObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(csvObj)) {
			csvObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(combineBookletObj)) {
			combineBookletObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(scheduleToolObj) && compType != "-1") {
			scheduleToolObj.setDisabled(false);
		}
		else
		{
			scheduleToolObj.setDisabled(iconState);
		}
	},
	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+hiddenFields[key]+"&";
		}
		return hiddenQstr;
	},
	saveAsPDF : function()
	{
		//var getSaveObj = Ext.widget('savepdf');
		//getSaveObj.savePDF("/final/servlet/com.eg.EcPdfDownloadC");

		downloadAsPDF("/final/servlet/com.eg.EcPdfDownloadC");
	},
	printData : function()
	{
		var printQueryStr = publicJSON.printQueryStr;
		Ext.widget('print',{title : config.title.mainPageTitle}).show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set({
			src: printQueryStr
		});
	},
	saveAsCSV : function()
	{
		var ec_criteria = me.getFormitems().getComponent('infoCont').getComponent('ec_criteria').getValue();
		var ec_userOption = "";
		if (ec_criteria != 'Component')
		{
			 ec_userOption = me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').getValue();
		}
		hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
		this.storeHiddenFields(timeLineCollection);
		me.getFormitems().submit({
			url: '../servlet/com.eg.EcCSVController',
			params : 'ec_criteria='+backOperation.ec_criteria+'&ec_userOption='+encodeURIComponent(backOperation.ec_userOption)+'&'+hiddenFields,
			standardSubmit : true,
			method: 'POST'
		});
	},
	sendMail : function()
	{
		Ext.widget('sendmail').show();
	},
	setschedule : function()
	{
		//Ext.widget('ecschedule').show();
		var op = "schedule";
		var ec_criteria = me.getFormitems().getComponent('infoCont').getComponent('ec_criteria').getValue();
		var ec_userOption = me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').getValue();
		var ec_comptype = me.getFormitems().getComponent('infoCont').getComponent('componentType').getValue();
		var ec_timeline = me.getTimeline().getComponent('ec_timeline').getValue();
		var startDate = me.getTimeline().getComponent('ec_stdate').getValue();
		var endDate = me.getTimeline().getComponent('ec_enddate').getValue();

		//Convert to original format(i.e., to MM/dd/yyyy)
		var startdate1 = Ext.Date.dateFormat(startDate, mgrDateFormat);
		var enddate1 = Ext.Date.dateFormat(endDate, mgrDateFormat);

		hiddenFieldsKeys = publicJSON.hiddenFields;
		hiddenFields = me.getHiddenFields(hiddenFieldsKeys);

		var timeLineHiddenFields =  me.getHiddenFields(timeLineCollection);
		if (op == "schedule")
		{
			if ((strRequestFrom != null && strRequestFrom == "saveSchedule") || (strRequestStart != null && strRequestStart == "saveSchedule"))
			{
				var checkFlag = me.componentSearch();
				if (checkFlag == false)
				{
					return false;
				}
				me.getFormitems().submit({
					url: '/final/config/EcSaveScheduleNew.jsp',
					params : 'id='+id+'&'+hiddenFields+'ec_criteria='+ec_criteria+'&ec_userOption='+ec_userOption+'&'+timeLineHiddenFields+'ec_timeline='+ec_timeline+'&currentDateFormat='+currentDateFormat+'&ec_stdate='+startdate1+'&ec_enddate='+enddate1+'&componentType='+ec_comptype,
					standardSubmit : true,
					method: 'POST'
				});
			}
			else
			{
				urlStr = "/final/config/EcSaveScheduleNew.jsp?id="+id+"&request_from=DaywiseChanges&"+hiddenFields+"showWindow=yes&ec_criteria="+ec_criteria+"&ec_userOption="+ec_userOption+"&"+timeLineHiddenFields+"ec_timeline="+ec_timeline+"&currentDateFormat="+currentDateFormat+"&ec_stdate="+startdate1+"&ec_enddate="+enddate1+"&componentType="+ec_comptype+"&com.eg.CSRF_NONCE="+csrfToken;
				scheduleWindow(urlStr);
			}
		}
		else if (op =="favorite")
		{
			window.location.href = "/final/config/EcSaveFavorite.jsp";
		}
		else
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,".Illegal Access");
			return false;
		}
	},
	storeHiddenFields : function(fields)
	{
		var ec_timeline = me.getTimeline().getComponent('ec_timeline');
		var tmpField = "";
		var tmpArr = new Array();

		this.getHiddenFieldsCt().removeAll();
		
		for (key in fields)
		{

			if (key == "ec_stdate_h" || key == "ec_enddate_h")
			{
				if (ec_timeline.getValue() == "Any")
				{
					var startdate = Ext.Date.dateFormat(Ext.getCmp('ec_stdate').getValue(), mgrDateFormat);
					var enddate = Ext.Date.dateFormat(Ext.getCmp('ec_enddate').getValue(), mgrDateFormat);
					if (key == "ec_stdate_h")
					{
						tmpField = {
							xtype : 'hiddenfield',
							name : key,
							value : startdate
						}
					}
					else
					{
						tmpField = {
							xtype : 'hiddenfield',
							name : key,
							value : enddate
						}
					}
				}
				else
				{
					tmpField = {
						xtype : 'hiddenfield',
						name : key,
						value : fields[key]
					}
				}
			}
			else
			{
				tmpField = {
					xtype : 'hiddenfield',
					name : key,
					value : fields[key]
				}
			}
			tmpArr.push(tmpField);
		}
		this.getHiddenFieldsCt().add(tmpArr);
		tmpArr = new Array();
	},
});

function doCloseWin()
{
	Ext.getCmp('scheduleWin').destroy();
}



