Ext.define('DayWiseChangeSummary.view.DayWiseSummaryChart',{
	extend:'Ext.container.Container',
	alias:'widget.daywisesummarychart',
	html:'<div id="daywisesummarychart"></div>',

	drawHighChart : function(configJsonData,height,width)
	{
		var highChart = {};
		highChart = jQuery.extend(true, {}, getHighChartsInstance('daywisesummarychart',height-100,width-100), highChart);
		highChart.setData(configJsonData.reportData,currentDateFormat,'');
		highChart.drawChart();
	},

	getHeightWidth : function()
	{
		var temp = new Array();
		var height = Ext.getCmp('main').getHeight();
		var width = Ext.getCmp('main').getWidth();
		temp.push(height - 150);
		temp.push(width);
		return temp;
	},

	loadChart:function(configJsonData,thisController)
	{
		var me = this;
		if(!Ext.isEmpty(configJsonData))
		{
			me.removeAll();
			if(configJsonData.hasConfigDetails)
			{
				if (chartType=='fusionchart')
				{
					if (FusionCharts("myColumn3DChartId" )) 
						FusionCharts("myColumn3DChartId").dispose();
					var chart2 = new FusionCharts(configJsonData.reportData.swfPath, "myColumn3DChartId", "800", "350","0","1");
					chart2.setDataXML(configJsonData.reportData.xmlString);
					chart2.setTransparent(true);
					chart2.render("daywisesummarychart");
				}
				else
				{
					var values = me.getHeightWidth();
					me.drawHighChart(configJsonData,values[0],values[1]);
				}
				thisController.setToolsState(false,configJsonData.selectedCmpType);
			}
			else
			{
				thisController.setToolsState(true);
				Ext.select("#daywisesummarychart").update('<div class = "iconInformation" style="margin:10% auto 0 auto;"></div><div style="text-align:center" class="commonErrorMsgText">'+configJsonData.errorText+'.</div>');
			}
		}
	}
});



