Ext.define('DiskCapacity.controller.Main',{
	extend : 'Ext.app.Controller',
	views : [
		'Main',
		'FormItems',
		'ErrorContainer',
		'DiskCapacityChart',
		'configutilities.Tools',
		'configutilities.PrintPreview',
		'configutilities.SendMail',
		'InfoGrid'
	],
	refs : [
		{
			selector : 'main',
			ref : 'main'
		},
		{
			selector : 'infoGrid', 
			ref : 'infoGrid'
		},
		{
			selector : 'formitems', 
			ref : 'formitems'
		},
		{
			selector : 'tools', 
			ref : 'tools'
		},
		{
			selector : 'diskcapacitychart', 
			ref : 'diskcapacitychart'
		},
		{
			selector : 'errorcontainer', 
			ref : 'errorcontainer'
		}
	],

	init : function()
	{
		thisCtrl = this;
		this.buildFieldData()
		this.control({
			'main' : {
				'afterrender' : this.afterMainRender
			},
			'formitems' :{
				'boxready' : this.loadChartCt
			},
			'formitems combobox[id="ec_criteria"]' :{
				'select' : this.getInformations
			},
			'formitems combobox[id="ec_userOption"]' :{
				'select' : this.getInformations
			},
			'formitems combo[id="rangeOption"]' :{
				'select' : this.show
			},
			'formitems button[id="submit"]' :{
				'click' : this.showDetails
			},
			'tools' :{
				'afterrender' : this.loadTools
			},
			'tools button[id="saveBtn"]' : {
				'click' : this.saveAsPDF
			},
			'tools button[id="printBtn"]' : {
				'click' : this.printData
			},
			'tools button[id="csvBtn"]' : {
				'click' : this.saveAsCSV
			},
			'tools button[id="mailBtn"]' : {
				'click' : this.sendMail
			},
			'tools button[id="scheduleBtn"]' : {
				'click' : this.setschedule
			},
			'main #backBtnMain': {
				'click': this.forwardRequestedURI
			}
		});
	},


	buildFieldData : function(){
		Ext.Ajax.request({
			url		: config.urls.servletURL,
			params  : queryString+"&needData=yes&chartType="+chartType,
			method	: 'POST',
			async	: false,
			success	: function( response ){
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					hiddenFieldsKeys = publicJSON['hiddenFields'];
					backOperation = publicJSON['backOperation'];
					NoComp = publicJSON['NoComp'];
				}
			}
		});
	},

	
	afterMainRender : function()
	{
		me = this;
		var ec_userOption =  me.getFormitems().getComponent('infoCont').getComponent('ec_userOption');
		var ec_criteria =  me.getFormitems().getComponent('infoCont').getComponent('ec_criteria');
		var startRange = me.getFormitems().getComponent('infoCont').getComponent('startRange');
		var endRange = me.getFormitems().getComponent('infoCont').getComponent('endRange');
		var rangeOption = me.getFormitems().getComponent('infoCont').getComponent('rangeOption');

		//var size = publicJSON.ranges.length;

		ec_criteria.getStore().loadRawData(publicJSON['viewByList']);
		ec_criteria.setValue(publicJSON.selectedEcOpt);

		if (publicJSON.selectedEcOpt != 'Component')
		{
			ec_userOption.getStore().loadRawData(publicJSON['specViewByList']);
			ec_userOption.setValue(publicJSON.selectedUserOption);
			ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
			ec_userOption.show();
		}
		else
		{
			ec_userOption.hide();
		}

		//startRange.getStore().loadRawData(publicJSON['ranges']);
		//startRange.setValue(publicJSON['ranges'][0].valueField);
		//endRange.getStore().loadRawData(publicJSON['ranges']);
		//endRange.setValue(publicJSON['ranges'][size-1].valueField);

		var selRangeOption = publicJSON['rangeOption'];

		rangeOption.setValue(selRangeOption);

		if (selRangeOption != "BETWEEN")
		{
			Ext.getCmp('endRange').hide();
			Ext.getCmp('rangeSeperator').hide();
		}
		else
		{
			Ext.getCmp('endRange').show();
			Ext.getCmp('rangeSeperator').show();
		} 

		startRange.getStore().loadRawData(publicJSON['startRanges']);
		startRange.setValue(publicJSON['selectedStartRange']);
		endRange.getStore().loadRawData(publicJSON['endRanges']);
		endRange.setValue(publicJSON['selectedEndRange']);
		if(publicJSON.hasConfigDetails)
		{
			thisCtrl.setToolsState(false,false,false,false,false);
		}
		else
		{
			if(NoComp != "" && NoComp != undefined && NoComp != "yes")
			{
				thisCtrl.setToolsState(true,true,true,true,false);
			}
			else
			{
				thisCtrl.setToolsState(true,true,true,true,true);
			}
		}

		if ((strRequestFrom != null && strRequestFrom == "saveSchedule"))
		{
			Ext.getCmp('backBtnMain').show();
			Ext.getCmp('bkSeperator').show();
			Ext.getCmp('submit').setText('Save');
		}

	},

	loadChartCt : function()
	{
		if (strRequestFrom != null && strRequestFrom != "saveSchedule")
		{
			if(publicJSON.chartData !="" && publicJSON.chartData != undefined)
			{
				thisCtrl.getDiskcapacitychart().loadChart(publicJSON,thisCtrl);
			}
			if(publicJSON.hasConfigDetails != false)
			{
				Ext.getCmp('formitems').collapse();
				thisCtrl.getMain().getComponent('hiddenPanel').show();
				thisCtrl.getMain().getComponent('hiddenPanel').getComponent('mainGrid').show();
				thisCtrl.getMain().getComponent('hiddenPanel').getComponent('mainGrid').getStore().loadRawData(publicJSON['systemInfoArray']);
			}
			else if(publicJSON.hasConfigDetails == false)
			{
				Ext.getCmp('hiddenPanel').hide();
				me.getErrorcontainer().update('<table border="0" height="400px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+publicJSON.errorText+'.</div></td></tr></table>');
				me.getErrorcontainer().show();
			}
		}
	},
	loadTools : function()
	{
		thisCtrl.getTools().loadIcon(
			true, //save
			true, //print
			true, //mail
			true, //csv
			true, //booklet
			true //schedule
		);
	},

	saveAsPDF : function()
	{
		//var getSaveObj = Ext.widget('savepdf');
		//getSaveObj.savePDF(config.urls.pdfURL);

		downloadAsPDF(config.urls.pdfURL);
	},

	printData : function()
	{
		var printQueryStr = publicJSON.printQueryStr;
		Ext.widget('print',{title : config.title.mainPageTitle}).show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set({
			src: printQueryStr
		});
	},

	saveAsCSV : function()
	{
		me = this;
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var ec_userOption = "";
		if (ec_criteria != 'Component')
		{
			 ec_userOption = Ext.getCmp('ec_userOption').getValue();
		}

		var urlStr = '../servlet/com.eg.EcCSVController';

		me.getFormitems().submit({
			url: urlStr,
			params: 'ec_criteria='+ec_criteria+'&ec_userOption='+ec_userOption,
			standardSubmit : true,
			method: 'POST'
		});
	},

	sendMail : function()
	{
		Ext.widget('sendmail').show();
	},


	setschedule : function()
	{
		var op = "schedule";
		var me = this;

		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var ec_userOption = Ext.getCmp('ec_userOption').getValue();
		var limit = Ext.getCmp('rangeOption').getValue();
		var start = Ext.getCmp('startRange').getValue();
		var end = Ext.getCmp('endRange').getValue();

		if (op == "schedule")
		{
			if (strRequestFrom != null && strRequestFrom == "saveSchedule")
			{
				var checkFlag = me.validateForm();
				if (checkFlag == false)
				{
					return false;
				}
				me.getFormitems().submit({
					url: '/final/config/EcSaveScheduleNew.jsp',
					params :"id="+id+"&ec_rtype=DiskCapacity&ec_userOption="+encodeURIComponent(ec_userOption)+"&ec_criteria="+ec_criteria+"&limit="+limit+"&start="+start+"&end="+end+"&cmd=DiskCapacity"+"&rangeOption="+limit,
					standardSubmit : true,
					method: 'POST'
				});
			}
			else
			{
				var urlStr = "/final/config/EcSaveScheduleNew.jsp?showWindow=yes&id="+id+"&ec_rtype=DiskCapacity&ec_userOption="+encodeURIComponent(ec_userOption)+"&ec_criteria="+ec_criteria+"&limit="+limit+"&start="+start+"&end="+end+"&cmd=DiskCapacity"+"&request_from=DiskCapacity&rangeOption="+limit+"&com.eg.CSRF_NONCE="+csrfToken;

				scheduleWindow(urlStr);
			}
		}
		else if(op == "favorite")
		{
			window.location.href = "/final/config/EcSaveFavorite.jsp";
		}
		else
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,".Illegal Access");
			return false;
		}
	},

	
	setToolsState : function(save,print,mail,csv,schedule)
	{
		var saveObj =me.getTools().getComponent('saveTool');
		var printObj =me.getTools().getComponent('printTool');
		var mailObj =me.getTools().getComponent('mailTool');
		var csvObj =me.getTools().getComponent('csvTool');
		var scheduleToolObj = me.getTools().getComponent('scheduleTool');
		var combineBookletObj = me.getTools().getComponent('bookletTool');

		if (!Ext.isEmpty(saveObj)) {
			saveObj.setDisabled(save);
		}
		if (!Ext.isEmpty(printObj)) {
			printObj.setDisabled(print);
		}
		if (!Ext.isEmpty(mailObj)) {
			mailObj.setDisabled(mail);
		}
		if (!Ext.isEmpty(csvObj)) {
			csvObj.setDisabled(csv);
		}
		if (!Ext.isEmpty(combineBookletObj)) {
			combineBookletObj.setDisabled(csv);
		}
		if (!Ext.isEmpty(scheduleToolObj)) {
			scheduleToolObj.setDisabled(schedule);
		}
	},

	getInformations : function()
	{
		Ext.getCmp('hiddenPanel').hide();

		var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		var ec_userOption =  me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').getValue();
		var ec_criteria =  me.getFormitems().getComponent('infoCont').getComponent('ec_criteria').getValue();
		var rangeOption = me.getFormitems().getComponent('infoCont').getComponent('rangeOption');
		var startRange = me.getFormitems().getComponent('infoCont').getComponent('startRange');
		var endRange = me.getFormitems().getComponent('infoCont').getComponent('endRange');
		var limitValue = rangeOption.getValue();
		var tempCriteria = "";
		var tempUserOption = "";
		var tempCriteriaPrevious = "";
		var tempUserOptionPrevious = "";

		rangeOption.setDisabled(true);
		startRange.setDisabled(true);
		endRange.setDisabled(true);
		//var size = publicJSON.ranges.length;

		tempCriteria = ec_criteria;

		if (tempCriteria != null && tempCriteria != undefined)
		{
			tempCriteria = ec_criteria;
		}
		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != 'Component')
		{
			tempUserOption = ec_userOption;
		}
		if (hiddenFieldsKeys.ec_criteriaPrevious != null && hiddenFieldsKeys.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = hiddenFieldsKeys.ec_criteriaPrevious;
		}
		if (hiddenFieldsKeys.ec_userOptionPrevious != null && hiddenFieldsKeys.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = hiddenFieldsKeys.ec_userOptionPrevious;
		}

		if (tempCriteria != "" && tempCriteriaPrevious != "")
		{
			if (tempCriteria == tempCriteriaPrevious)
			{
				if (tempUserOption != tempUserOptionPrevious)
				{
					limitValue = "BETWEEN";
				}
			}
			else
			{
				limitValue = "BETWEEN";
			}
		}

		//var url = "../servlet/com.eg.EcConfigurationServletNew?cmd=DiskCapacity&needData=yes&rangeOption="+limitValue+"&request_from="+strRequestFrom+"&id="+id+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious);

		this.getFormitems().submit({
			url : "../servlet/com.eg.EcConfigurationServletNew",
			params: "cmd=DiskCapacity&needData=yes&rangeOption="+limitValue+"&request_from="+strRequestFrom+"&id="+id+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious),
			method : 'POST',
			success : function(form, action){
				var publicJSON = Ext.decode(action.response.responseText);
				hiddenFieldsKeys = publicJSON.hiddenFields;
				me.getFormitems().getComponent('infoCont').getComponent('ec_criteria').getStore().loadRawData(publicJSON.viewByList);
				me.getFormitems().getComponent('infoCont').getComponent('ec_criteria').setValue(publicJSON.selectedEcOpt);

				if (publicJSON.selectedEcOpt != 'Component')
				{
					me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').getStore().loadRawData(publicJSON.specViewByList);
					me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').setFieldLabel(publicJSON.specViewByTitle);
					me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').setValue(publicJSON['selectedUserOption']);
					me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').show();
				}
				else
				{
					me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').hide();
				}

				//startRange.getStore().removeAll();
				//startRange.getStore().loadRawData(publicJSON['ranges']);
				//startRange.setValue(publicJSON['ranges'][0].valueField);
				
				//endRange.getStore().removeAll();
				//endRange.getStore().loadRawData(publicJSON['ranges']);
				//endRange.setValue(publicJSON['ranges'][size-1][0].valueField);

				delete publicJSON;

				rangeOption.setDisabled(false);
				startRange.setDisabled(false);
				endRange.setDisabled(false);

				if(publicJSON.hasConfigDetails)
				{
					me.setToolsState(true,true,true,true,false);
				}
				else
				{
					me.setToolsState(true,true,true,true,true);
				}

			},
			failure : function(form, action)
			{
				Ext.MessageBox.alert("Ajax Failed","Error in updating details");
			}
		});
	},


	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+hiddenFields[key]+"&";
		}
		return hiddenQstr;
	},


	showDetails : function()
	{
		var parameters = "";
		var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		var ec_userOption =  me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').getValue();
		var ec_criteria =  me.getFormitems().getComponent('infoCont').getComponent('ec_criteria').getValue();
		var rangeOption = me.getFormitems().getComponent('infoCont').getComponent('rangeOption');
		var startRange = me.getFormitems().getComponent('infoCont').getComponent('startRange').getValue();
		var endRange = me.getFormitems().getComponent('infoCont').getComponent('endRange').getValue();
		var limitValue = rangeOption.getValue();


		if (strRequestFrom != null && strRequestFrom == "saveSchedule")
		{
			me.setschedule();
		}
		else
		{
			var checkFlag = me.validateForm();
			if (checkFlag == false)
			{
				return false;
			}

			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
			myMask.show();

			var tempCriteria = "";
			var tempUserOption = "";
			var tempCriteriaPrevious = "";
			var tempUserOptionPrevious = "";

			if (ec_criteria != null && ec_criteria != undefined)
			{
				tempCriteria = ec_criteria;
			}
			if (tempCriteria != null && tempCriteria != undefined && tempCriteria != 'Component')
			{
				tempUserOption = ec_userOption;
			}

			if (hiddenFieldsKeys.ec_criteriaPrevious != null && hiddenFieldsKeys.ec_criteriaPrevious != undefined)
			{
				tempCriteriaPrevious = hiddenFieldsKeys.ec_criteriaPrevious;
			}
			if (hiddenFieldsKeys.ec_userOptionPrevious != null && hiddenFieldsKeys.ec_userOptionPrevious != undefined)
			{
				tempUserOptionPrevious = hiddenFieldsKeys.ec_userOptionPrevious;
			}

			if(limitValue == "BETWEEN")
			{
				if(parseInt(startRange) >= parseInt(endRange))
				{
					myMask.hide();
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.commonError);
					return;
				}
				else
				{
					parameters = "cmd=DiskCapacity&needData=yes&rangeOption="+limitValue+"&startRange="+startRange+"&endRange="+endRange+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious)+"&chartType="+chartType;
					//var url = "../servlet/com.eg.EcConfigurationServletNew?cmd=DiskCapacity&needData=yes&rangeOption="+limitValue+"&startRange="+startRange+"&endRange="+endRange+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious)+"&chartType="+chartType;
				}
			}
			else
			{
				parameters = "cmd=DiskCapacity&needData=yes&rangeOption="+limitValue+"&startRange="+startRange+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious)+"&chartType="+chartType;
				//var url = "../servlet/com.eg.EcConfigurationServletNew?cmd=DiskCapacity&needData=yes&rangeOption="+limitValue+"&startRange="+startRange+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious)+"&chartType="+chartType;
			}

			this.getFormitems().submit({
				url: "../servlet/com.eg.EcConfigurationServletNew",
				params: parameters,
				method: 'POST',
				success: function(form,action)
				{
					myMask.hide();
					var jsonData = Ext.decode(action.response.responseText);
					publicJSON = jsonData;
					hiddenFieldsKeys = jsonData.hiddenFields;
					var chartPlaceHolder = Ext.getCmp('chartPlaceHolder');

					if (jsonData.errorText != null && jsonData.errorText != undefined)
					{
						Ext.getCmp('hiddenPanel').hide();
						me.getErrorcontainer().update('<table border="0" height="400px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+jsonData.errorText+'.</div></td></tr></table>');
						me.getErrorcontainer().show();
					}
					else
					{
						me.getErrorcontainer().hide();
						if(jsonData.chartData !="" && jsonData.chartData != undefined)
						{
							thisCtrl.getDiskcapacitychart().loadChart(jsonData,thisCtrl);
							Ext.getCmp('chartPlaceHolder').show();
						}
						else
						{
							Ext.getCmp('chartPlaceHolder').hide();
						}
						thisCtrl.getMain().getComponent('hiddenPanel').show();

						Ext.getCmp('mainGrid').show();
						Ext.getCmp('mainGrid').getStore().loadRawData(jsonData['systemInfoArray']);
					}

					if(jsonData.systemInfoArray == "")
					{
						if(NoComp != "" && NoComp != undefined && NoComp != "yes")
						{
							thisCtrl.setToolsState(true,true,true,true,false);
						}
						else
						{
							thisCtrl.setToolsState(true,true,true,true,true);
						}
					}
					else
					{
						Ext.getCmp('formitems').collapse();
						me.setToolsState(false,false,false,false,false);
					}
				},
				failure: function(form, action)
				{
					myMask.hide();
					Ext.MessageBox.alert("Ajax Failed","Error in updating details");
				}
			});
		}
	},

	show : function()
	{
		var option = Ext.getCmp('rangeOption').getValue();
		if (option == "LESSTHAN" || option == "GREATERTHAN" || option == "LESSTHAN_OR_EQUAL" || option == "GREATERTHAN_OR_EQUAL")
		{
			Ext.getCmp('endRange').hide();
			Ext.getCmp('rangeSeperator').hide();
		}
		else
		{
			Ext.getCmp('endRange').show();
			Ext.getCmp('rangeSeperator').show();
		} 
		if(publicJSON.systemInfoArray == "")
		{
			me.setToolsState(true,true,true,true,false);
		}
		else
		{
			me.setToolsState(false,false,false,false,false);
		}
	},


	validateForm : function()
	{
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var ec_userOption = Ext.getCmp('ec_userOption').getValue();

		var tempCriteria = "";
		var tempUserOption = "";

		if (ec_criteria != null && ec_criteria != undefined)
		{
			tempCriteria = ec_criteria;
		}
		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != 'Component')
		{
			tempUserOption = ec_userOption;
		}
		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorZone);
					return false;
				}
				else if (tempCriteria == "Service")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorService);
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorSegment);
					return false;
				}
			}
		}
	},


	forwardRequestedURI : function()
	{
		if ((strRequestFrom != null && strRequestFrom == "saveSchedule") || (backOperation != null && backOperation.schedule != undefined && backOperation.schedule))
		{
			var me = this;
			hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			me.getFormitems().submit({
				url: '/final/config/EcSaveScheduleNew.jsp',
				params : 'request_from='+strRequestFrom+'&id='+id+'&'+hiddenFields,
				standardSubmit : true,
				method: 'POST'
			});
		}
	}

});





function getSystemDetails(systemName)
{
	var me = this;
	var sysName = systemName.split("(");
	var sysName1 = Ext.String.trim(sysName[0]);
	var criteria = Ext.getCmp('ec_criteria').getValue();
	var userOption = Ext.getCmp('ec_userOption').getValue();
	var rangeOption = Ext.getCmp('rangeOption').getValue();
	var startRange = Ext.getCmp('startRange').getValue();
	var endRange = Ext.getCmp('endRange').getValue();

	window.location.href = "../servlet/com.eg.EcConfigurationServletNew?request_from=DiskCapacity&cmd=BoxView&searchValue=&systemName=" + encodeURIComponent(sysName1) + "&ec_criteria=" + criteria + "&ec_userOption=" + encodeURIComponent(userOption)+"&rangeOption="+rangeOption+"&startRange="+startRange+"&endRange="+endRange+"&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken;
}

function doCloseWin()
{
	Ext.getCmp('scheduleWin').destroy();
}




