Ext.define('DiskCapacity.view.InfoGrid', {
	extend : 'utilities.CustomGrid',
	alias : 'widget.infoGrid',
	cls:'gridSkin_expander',
	id:'infoGrid',

	store : new Ext.data.Store({
		fields : ['hardDiskRange','OSWithSys'],
		data : [],
		groupField : 'hardDiskRange',
		sortOnLoad : false
	}),

	features: [
		{
			ftype: 'grouping',
			id : 'diskRangeWiseGrouping',
			groupHeaderTpl: [
				'{name:this.formatHeader}',
				{
					formatHeader: function(name) 
					{
						var cType = name.split(":");
						return cType[0] + ":" + cType[1];
					}
				}
			],
			hideGroupedHeader: false,
			startCollapsed: false,
		}
	],

	tools: [{
			xtype:'button',
			id :'tc',
			name :'tc',
			iconCls: 'iconCollapseAll',
			enableToggle : true,
			style: {
				background: 'none',
				border: '0px'
			},
			listeners:{
			'toggle':function(obj, pressed, eOpts){
				var thisGrid = Ext.getCmp('mainGrid'),
				groupingFeature = thisGrid.view.getFeature('diskRangeWiseGrouping');
				if(pressed){
						groupingFeature.collapseAll();
						obj.setIconCls('iconExpandAll');
				}else{
						groupingFeature.expandAll();
						obj.setIconCls('iconCollapseAll');
				}
				thisGrid.doLayout();
			}
		}
	}],
	hideGroupedHeader: false,
	startCollapsed: false,
	queryMode : 'local',
	hideHeaders : true,
	viewConfig : {
		cls:'gridSkin_expander_view',
		deferEmptyText : true
	},
	emptyText : "<table border='0' height='150px' width='100%'><tr><td align=center vlaign=top><img src='/final/admin/eg_images/exclamation-icon.gif'><div>No result found for the current selection</div></td></tr></table>",

	columns : {
		defaults: {
			sortable: false,
			hideable: false,
			menuDisabled: true,
			draggable: false,
			resizable: false
		},
		items : [
			{
				text : 'System',
				dataIndex : 'OSWithSys',
				flex : 1,
				renderer : function(value)
				{
					if (value != "" && value.length > 0)
					{
						var mainArr = value.split("#$#"); // system #$# systemDesc (seperated by "|")
						var rowText = '';
						var tmpArr = mainArr[1].split("|");
						rowText ='<thead><tr><th class="OStable_td" colspan="3" style="padding:7px 7px 7px 9px;font-size:8pt;">'+ mainArr[0] + '</th></tr></thead>';
						var colText = '';
						var count = 1;
						var sysSize = tmpArr.length;
						for (var d = 0; d < sysSize; d++)
						{
							if (count == 4) 
							{
								count = 1;
							}
							if (count == 1)
							{
								colText = colText + '<tr>';
							}

							colText = colText + '<td style="padding:7px;font-size:8pt;" valign="center" height="20" width="33%"><img src="../images/clear.png" class="iconConfigSystem" style="vertical-align:baseline;" /><a  style="vertical-align:text-bottom" href="javascript:getSystemDetails(\'' + tmpArr[d] + '\')">' + tmpArr[d]+ '</a>' + '</td>';

							if (count == 3)
							{
								colText = colText + '</tr>';
							}
							count++;

							while (count < 4 && d == sysSize-1)
							{
								colText = colText + '<td width="33%" class="OStable_emptytd">&nbsp;</td>';
								count++;
							}
						}
						rowText = rowText + colText;
						return '<table valign="top" width="100%" class="OStable" style="margin-bottom: 0px">' + rowText+ '</table>';
					}
				}
			}
		]
	}
});



