<%
/*
 *   File				:	EcCurrentConfiguration.jsp
 *   Purpose			:	Displays the current state
 *   Creation Date		:	18/04/2006
 *   Author				:	Krishnamurthi, Balasigamani
 *   UI Design			:	Krishnamurthi
 *   UI Design Changes	:	Jaiwin
 */
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EcTracker.jsp"%>
<%@ page errorPage = "EcProbs.jsp"%>
<%@ page import = "com.eg.EgConfigTestsInfo"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgConfigConstants"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "egurkha.config.EcProcessData"%>
<%@ page import = "egurkha.config.EcUtils"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.eg.EgConfigInfo"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>

<%!
	public static ArrayList breakString(String givenString,int screenLen)
	{
		ArrayList aListResultant = new ArrayList();
		int strLen = givenString.length();
		int resLen = strLen/screenLen;
		int idx = 0;
		int k = 0;
		if (givenString.indexOf(" ")>-1)
		{
			for (int i=0;i<resLen;i++)
			{
				String res = givenString.substring(idx,idx+screenLen);
				int s = res.length();
				if (res.charAt(s-1)==' ')
				{
					res = res.trim();
					aListResultant.add(res);
					idx = idx+screenLen;
				}
				else
				{
					k = res.lastIndexOf(" ");
					if (k==0 || k == -1)
					{
						aListResultant.add(res.substring(0));
						idx = idx+screenLen;
					}
					else
					{
						aListResultant.add(res.substring(0,k));
						String temp = res.substring(k);
						int m = temp.length();
						idx = idx+screenLen;
						idx = idx-m;
					}
				}
				if (i == resLen-1)
				{
					int lastLen = strLen-idx;
					if (lastLen > screenLen)
					{
						resLen = resLen+1;
					}
				}
			}
			String ss = givenString.substring(idx).trim();
			aListResultant.add(ss);
		}
		else
		{
			for (int i=0;i<resLen ;i++)
			{
				String res = givenString.substring(idx,idx+screenLen);
				aListResultant.add(res);
				idx = idx+screenLen;
			}
			aListResultant.add(givenString.substring(idx));
		}
		return aListResultant;
	}

	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();

	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	ArrayList serverList = new ArrayList();
	String configSkin = user.getConfigSkin();
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConverter.getDateTime();
	/* Added by Prakash.K Ends */

	EcUtils ecUtils = new EcUtils();
	EgSpecsInfo specsInfo=new EgSpecsInfo("manager");
	EgConfigTestsInfo configtestsinfo = new EgConfigTestsInfo("manager");

	Vector vec_componentTypes = new Vector();
	Vector vec_components = new Vector();
	Vector allcomps = new Vector();
	boolean goBack = false;

	String changeDuration = configtestsinfo.getServerDisplayValue("CONFIGURATION_CHANGE","ChangeDuration");
	String comptype = request.getParameter("ec_comptype");
	String s_component = request.getParameter("ec_component");
	String o_comptype = request.getParameter("old_comptype");
	String selectedType = request.getParameter("selectedType");
	String compsViewCType = request.getParameter("cType");
	boolean isReqFromCompsView = false;
	boolean requestFromHomePage = false;
	boolean isReqFromBoxView = false;
	boolean isReqFromIBCT = false;
	String reqFrom = request.getParameter("request_from");
	if (reqFrom == null)
	{
		reqFrom = "Current";
	}

	Map scheduleDetails = (Map)request.getAttribute("ScheduleDetails");
	if (scheduleDetails != null && reqFrom != null && reqFrom.equalsIgnoreCase("saveSchedule"))
	{
		comptype = (String)scheduleDetails.get("ec_comptype");
		s_component = (String)scheduleDetails.get("ec_component");
		o_comptype = (String)scheduleDetails.get("old_comptype");
	}
	String id = request.getParameter("id");

	if (reqFrom != null && reqFrom.equalsIgnoreCase("compsview"))
	{
		isReqFromCompsView = true;
		goBack = false;
	}
	if (reqFrom != null && reqFrom.equalsIgnoreCase("BoxView"))
	{
		isReqFromBoxView = true;
		goBack = false;
	}
	if (reqFrom != null && reqFrom.equalsIgnoreCase("HomePage"))
	{
		requestFromHomePage = true;
		goBack = true;
	}
	if (reqFrom != null && reqFrom.equalsIgnoreCase("InventoryByCompType"))
	{
		isReqFromIBCT = true;
		goBack = true;
	}

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");

	if (scheduleDetails != null && reqFrom != null && reqFrom.equalsIgnoreCase("saveSchedule"))
	{
		ec_criteria = (String)scheduleDetails.get("ec_criteria");
		ec_criteriaPrevious = (String)scheduleDetails.get("ec_criteriaPrevious");
	}

	if (ec_criteria == null)
	{
		ec_criteria = "Component";
		ec_criteriaPrevious = "Component";
	}

	if (ec_criteria != null && 
		ec_criteriaPrevious != null && 
		!ec_criteriaPrevious.equals(ec_criteria))
	{
		comptype = null;
		s_component = null;
	}

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	if (scheduleDetails != null && reqFrom != null && reqFrom.equalsIgnoreCase("saveSchedule"))
	{
		vecUserOptions = (Vector)scheduleDetails.get("vecUserOptions");
		ec_userOption = (String)scheduleDetails.get("ec_userOption");
		ec_userOptionPrevious = (String)scheduleDetails.get("ec_userOptionPrevious");
	}

	if (ec_userOption != null && 
		ec_userOptionPrevious != null && !ec_userOptionPrevious.equals(ec_userOption) && 
		ec_criteria != null && ec_criteriaPrevious != null)
	{
		comptype = null;
		s_component = null;
	}

	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
	if (scheduleDetails != null && reqFrom != null && reqFrom.equalsIgnoreCase("saveSchedule"))
	{
		aListAssociatedComponents = (ArrayList)scheduleDetails.get("associatedComponents");
	}
	allcomps.addAll(aListAssociatedComponents);

	if (!allcomps.isEmpty())
	{
		for (int i=0;i<allcomps.size();i++)
		{
			String str = (String) allcomps.get(i);
			String component_type = str.substring(0,str.indexOf(":"));
			boolean isTestEnabled = specsInfo.isConfigTestEnabled(component_type);
			if (!isTestEnabled) continue;
			if (!vec_componentTypes.contains(component_type))
				vec_componentTypes.add(component_type);
			String component_name = str.substring(str.indexOf(":")+1);
			vec_components.add(component_name+":"+component_type);
		}
		Collections.sort(vec_componentTypes);
	}

	Vector v_comp = null;
	if (comptype==null || comptype.equals("-1"))
	{
		v_comp = vec_components;
		Collections.sort(v_comp);
		comptype = "-1";
		if (!comptype.equalsIgnoreCase(o_comptype))
		{
			s_component = "";
		}
	}
	else
	{
		v_comp = new Vector();
		for (int i=0;i<vec_components.size();i++)
		{
			String s_comp = (String)vec_components.get(i);
			if (comptype!=null && s_comp.endsWith(comptype))
				v_comp.add(s_comp);
		}
		Collections.sort(v_comp);
		if (!comptype.equalsIgnoreCase(o_comptype))
			s_component = "";
	}

	String s_componentType = null;
	ArrayList al_information = null;
	String[] selectedStatus = null;
	if ((s_component != null && !s_component.equals("-1")) && comptype.equalsIgnoreCase(o_comptype))
		s_componentType = s_component.substring(s_component.lastIndexOf(":")+1);

	ArrayList aListEnabledConfigTests = null;
	ArrayList aListECTests = null;
	if (s_componentType != null)
	{
		aListEnabledConfigTests = specsInfo.getEnabledTests(s_componentType,true);

		//To fetch excluded tests - Start
		ArrayList excludedTestList = new ArrayList();
		prgBean.createFile("eg_disable.ini");
		String excludedTestForComp = prgBean.getStrValue(s_componentType,s_componentType+":"+s_component.substring(0,s_component.lastIndexOf(":")));
		if (excludedTestForComp != null && !excludedTestForComp.equals(""))
		{
			StringTokenizer excludedTestTokens = new StringTokenizer(excludedTestForComp,",");
			while (excludedTestTokens.hasMoreElements())
			{
				String excludeTestComp = (String)excludedTestTokens.nextElement();
				boolean isCompHost = aListEnabledConfigTests.contains(excludeTestComp);
				if (isCompHost)
				{
					excludedTestList.add(excludeTestComp);
				}
			}
		}

		String excludedTestForHost = prgBean.getStrValue("Default_server","Default_server"+":"+s_component.substring(0,s_component.indexOf(":")));
		if (excludedTestForHost != null && !excludedTestForHost.equals(""))
		{
			StringTokenizer excludedTestTokens = new StringTokenizer(excludedTestForHost,",");
			while (excludedTestTokens.hasMoreElements())
			{
				String excludeTest = (String)excludedTestTokens.nextElement();
				boolean isComptypeTest = aListEnabledConfigTests.contains(excludeTest);
				if (isComptypeTest)
				{
					excludedTestList.add(excludeTest);
				}
			}
		}
		//To fetch excluded tests - End

		//Will contain only running tests after the removeAll operation
		aListEnabledConfigTests.removeAll(excludedTestList);
		al_information = configtestsinfo.getInformationList(s_componentType);
		if (al_information != null)
		{
			//Pick-up those templates for which the underlying configuration test is enabled
			ArrayList aListInformations = new ArrayList();
			for (int i=0; i<al_information.size(); i++)
			{
				String strInformation = (String)al_information.get(i);
				ArrayList aListInfoSublist = configtestsinfo.getInformationSublist(s_componentType + ":" + strInformation);
				if (aListInfoSublist == null) continue;
				for (int j=0; j<aListInfoSublist.size(); j++)
				{
					String subinformation = (String)aListInfoSublist.get(j);
					ArrayList aListInfoSublistDetails = configtestsinfo.getInformationSublistDetails(s_componentType + ":" + strInformation + ":" + subinformation);
					if (aListInfoSublistDetails == null || aListInfoSublistDetails.isEmpty()) continue;
					String testname = (String)aListInfoSublistDetails.get(0);
					if (!aListEnabledConfigTests.contains(testname)) continue;
					if (!aListInformations.contains(strInformation))
					{
						aListInformations.add(strInformation);
					}
				}
			}
			al_information = aListInformations;

			selectedStatus = new String[al_information.size()];
		}
		else
		{
			aListECTests = sorter.getSortedTestList(aListEnabledConfigTests);
		}
	}

	ArrayList al_configDetails = (ArrayList)request.getAttribute("Configuration Details");
	String[] s_selectedInformations = (String[])request.getAttribute("Selected Informations");
	String navigatingFrom = (String)request.getAttribute("navigatingFrom");

	if (scheduleDetails != null && reqFrom != null && reqFrom.equalsIgnoreCase("saveSchedule"))
	{
		String tests[] = null;
		Object temp = (Object)scheduleDetails.get("ec_test");
		if (temp instanceof String)
		{
			tests = new String[]{(String)temp};
		}
		else if (temp instanceof String[])
		{
			tests = (String[])temp;
		}
		s_selectedInformations = tests;
	}

	String strBackRequest = request.getParameter("back_request");
	if (strBackRequest != null && strBackRequest.equalsIgnoreCase("ScheduleConfig"))
	{
		String tests[] = request.getParameterValues("ec_test");
		s_selectedInformations = tests;
	}

	List l_selectedInformations = null;
	String selectedInformationsInCurrent = null;
	StringBuffer strBuffer = new StringBuffer();
	if (s_selectedInformations != null && s_selectedInformations.length > 0)
	{
		if (navigatingFrom == null)
		{
			l_selectedInformations = Arrays.asList(s_selectedInformations);
		}
		else  //CitrixAppUsers
		{
			StringTokenizer strTokensTemp = new StringTokenizer(s_selectedInformations[0],",");
			l_selectedInformations = new ArrayList();
			while (strTokensTemp.hasMoreTokens())
			{
				String str_temp = strTokensTemp.nextToken();
				l_selectedInformations.add(str_temp);
			}
		}

		for (int j=0; j<l_selectedInformations.size(); j++)
		{
			strBuffer.append((String)l_selectedInformations.get(j)+",");
		}

		if (al_information != null)
		{
			for (int i=0;i<al_information.size();i++)
			{
				String s = (String)al_information.get(i);
				if (l_selectedInformations.contains(s))
					selectedStatus[i] = "selected";
				else
					selectedStatus[i] = "";
			}
		}
	}
	else if (s_selectedInformations != null && s_selectedInformations.length == 0)
	{
		for (int i=0;i<aListECTests.size();i++)
		{
			EgName name = (EgName)aListECTests.get(i);
			String actualTestName = name.getActualName();
			strBuffer.append(actualTestName+",");
		}
	}

	if (strBuffer != null && strBuffer.length() > 0)
	{
		selectedInformationsInCurrent = strBuffer.substring(0,strBuffer.length()-1);
	}

	int i_configDataColumnCount = configtestsinfo.getConfigurationDataColumnCount();
	session.setAttribute("CURRENT_DATA",al_configDetails);

	String selectedTestnames = (String)request.getAttribute("Selected Testnames");

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

	String userName = (String)session.getAttribute("sess_auserid");
%>

	<html>
	<head>
	<title><egui:intnl text="configmgmt.configuration.eG Configuration Management" /></title>
	<meta name="Author" content="Krishnamurthi">
	<style>
	@page {size : landscape; margin : 0in }  
	@page :footer {content: none, "Macro Home" decimal(pageno), none;}  
	</style>
	<!-- <link rel="stylesheet" href="../config/styles/ec_style_green.css" /> -->
	<egui:skin ui="config"/>
	<!-- <script language="JavaScript1.2" src="../config/scripts/ec_images.js"></script> -->
	<script language="JavaScript1.2" src="../config/scripts/ec_validate.js"></script>
	<script type="text/javascript" src="/../final/scripts/screen_display.js"></script>
	<script language="JavaScript1.2">
		function getInformations()
		{
			document.forms[0].action = "../config/EcCurrentConfiguration.jsp?request_from=<%=reqFrom%>&id=<%=id%>";
			document.forms[0].submit();
		}

		function showDetails(path)
		{
			var thisForm = document.forms[0];
			var component = thisForm.ec_component.value;
			var server = thisForm.ec_comptype.value;

			var tempCriteria = "";
			var tempUserOption = "";
			if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
			{
				tempCriteria = thisForm.ec_criteria.value;
			}
			if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
			{
				tempUserOption = thisForm.ec_userOption.value;
			}

			if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
			{
				if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
				{
					if (tempCriteria == "Zone")
					{
						alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
						return false;
					}
					else if (tempCriteria == "Service")
					{
						alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
						return false;
					}
					else if (tempCriteria == "Segment")
					{
						alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
						return false;
					}
				}
			}

			if(component == -1)
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Component" />');
				return false;
			}
		
			var information = thisForm.ec_test.value;
			if(information == "-1" || information == '')
			{
				alert('<egui:intnl text="configmgmt.common.Please select atleast one Information for the choosen Component" />');
				return false;
			}

			if(path == "submit")
			{
				thisForm.action = "../servlet/com.eg.EcConfigurationServlet";
				thisForm.submit();
				thisForm.x.value = '<egui:intnl text="configmgmt.common.Loading" />'+'...';
				thisForm.x.disabled = true;
			}
		}

		function schedule(op)
		{
			var checkFlag = showDetails('schedule');
			if(checkFlag == false) return;
			var thisForm = document.CfMacro;
			if (op == "schedule")
			{
<%
	if (reqFrom != null && reqFrom.equalsIgnoreCase("saveSchedule"))
	{
%>
				thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>";
<%
	}
	else
	{
%>
				thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>&request_from=Current";
<%
	}
%>
			}
			else if (op =="favorite")
				thisForm.action = "/final/config/EcSaveFavorite.jsp";
			else
			{
				alert('<egui:intnl text="configmgmt.common.Illegal Access" />');
				return;
			}
			thisForm.submit();
		}

		function mail()
		{
<%
			if (al_configDetails == null || al_configDetails .size() == 0)
			{
%>
				alert('<egui:intnl text="configmgmt.common.No data available" />');
				return;
<%
			}
%>
			sendMail();
		}

		function closeWin()
		{
			if(window.newwin !=null)
			{
				newwin.close();
			}
			if(window.datawin !=null)
			{
				datawin.close();
			}
			if(window.mailwin !=null)
			{
				mailwin.close();
			}
			if(window.statusWin!=null)
			{
				statusWin.close();
			}
		}

		function printData()
		{
<%
			if (al_configDetails == null || al_configDetails .size()==0)
			{
%>
				alert('<egui:intnl text="configmgmt.common.No data available" />');
				return;
<%
			}

			StringBuffer printQS = new StringBuffer();

			if (request.getParameter("ec_component") != null)
			{
				printQS.append("ec_component="+EgURLEncoder.encode(request.getParameter("ec_component"),"UTF-8"));
			}

			printQS.append("&ec_type=Current");
			printQS.append("&ec_trgttype=Configuration_Report");
			printQS.append("&printData=yes");
			printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
			printQS.append("&user_language="+userLanguage);
			printQS.append("&ec_criteria="+ec_criteria);
			printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
%>
			var s_qryString = "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>&ec_forPDF=No";
			print(s_qryString);
		}

		function savePdf()
		{
<%
			if (al_configDetails == null || al_configDetails .size() == 0)
			{
%>
				alert('<egui:intnl text="configmgmt.common.No data available" />');
				return;
<%
			}
			session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
			session.setAttribute("REPORT_NAME","CurrentConfiguration");
			session.setAttribute("REPORT_LAYOUT","Portrait");
			session.setAttribute("PAGE_WIDTH_PDF","1100");
			session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
			session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
%>
			getPdf('<%=configSkin%>');
		}

		function getCitrixDetails(heading,userOption,applicationName)
		{
			var thisForm = document.forms[0];

			thisForm.ec_rtype.value="CitrixApplicationsAndUsers";

			if (applicationName == "-1")
			{
				thisForm.action = "../servlet/com.eg.EcConfigurationServlet?heading="+heading+"&userOption="+encodeURIComponent(userOption)+"&requestFrom=CurrentPage";
			}
			else
			{
				thisForm.action = "../servlet/com.eg.EcConfigurationServlet?heading="+heading+"&userOption="+encodeURIComponent(userOption)+"&applicationName="+applicationName+"&requestFrom=CurrentPage";
			}

			thisForm.submit();
		}

		function goBackToCompView()
		{
			var sType = '<%=selectedType%>';
			var cType = '<%=compsViewCType%>';
			var reqFrom = '<%=request.getParameter("requestFrom")%>';
			var clickOn = '<%=request.getParameter("clickOn")%>';
			var thisForm = document.forms[0];
			thisForm.action = '../servlet/com.eg.EcConfigurationServlet?cmd=ComponentsView&requestFrom='+reqFrom+'&selectedType='+sType+'&componentType='+cType+'&clickOn='+clickOn+'&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
			thisForm.submit();
		}

		function goBackToSaveSchedule()
		{
			var thisForm = document.forms[0];
			thisForm.action = "/final/config/EcSaveSchedule.jsp?request_from=<%=reqFrom%>&id=<%=id%>";
			thisForm.submit();
		}

		function getDetails()
		{
			thisForm = document.forms[0];
			thisForm.action = "../servlet/com.eg.EcConfigurationServlet?cmd=CurrentConfig&request_from=<%=reqFrom%>&id=<%=id%>";
			thisForm.submit();
		}

		function csv()
		{
<%
			if (al_configDetails == null || al_configDetails.size()==0)
			{
%>
				alert('<egui:intnl text="configmgmt.common.No data available" />');
				return;
<%
			}
%>
			thisForm = document.forms[0];
			thisForm.action = '../servlet/com.eg.EcCSVController?ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
			thisForm.submit();
		}

	</script>
	</head>

	<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" onUnLoad="closeWin()" style="overflow:auto" onLoad="bigScreen();">
	<form name="CfMacro" method="post" style="margin:0px">
	
	<input type="hidden" name="ec_rtype" value="Current">
	<input type="hidden" name="ec_trgttype" value="Configuration_Report">
	<input type="hidden" name="old_comptype" value="<%=comptype%>">
	<input type="hidden" name="user_language" value="<%=userLanguage%>">
	<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
	<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">

<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%" height="100%">

	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<div style="border:0px blue solid;height:24px">
				<div style="border:0px solid;float:left;padding:5px" class="main_head_top">
					&nbsp;<b><egui:intnl text="configmgmt.configuration.CONFIGURATION" /></b>
				</div>
				<div style="border:0px solid red;float:right;height:22px;">
<%

	if (requestFromHomePage || isReqFromBoxView || isReqFromCompsView || isReqFromIBCT)
	{
%>
					<div style="border:0px solid red;height:22px;float:right;position:relative;margin-top:2px">
						<table cellspacing="0" cellpadding="0" border="0" height="20">
							<tr>
								<td width="50" align="center" id="leftcurve" > <img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

								<td width="2" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="2" > </td>

								<td align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="printData()">  </td>

								<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif" width="13" > </td>

								<td width="13" align="center"  id="leftcurvebg" > <img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

								<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>

								<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"></td>

								<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>

								<td width="13" align="center" id="leftcurvebg"><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

								<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>

							</tr>
						</table>
					</div>
<%
	}
%>
					<div style="border:0px solid;float:right;padding:5px">
<%
	if (goBack)
	{
%>
						<a id='mousehand' onClick="javascript:history.back();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
						</a>
<%
	}
	else if (isReqFromCompsView)
	{
%>
						<a id='mousehand' onClick="goBackToCompView();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
						</a>
<%
	}
	else if (isReqFromBoxView)
	{
%>
						<a id='mousehand' onClick="history.back();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
						</a>
<%
	}
	else if (reqFrom != null && reqFrom.equalsIgnoreCase("saveSchedule"))
	{
%>
						<a id='mousehand' onClick="goBackToSaveSchedule();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;&nbsp;
						</a>
<%
	}
%>
					</div>
				</div>
			</div>
		</td>
	</tr>

<%
	if (requestFromHomePage || isReqFromBoxView || isReqFromCompsView || isReqFromIBCT)
	{
%>
	<tr>
		<td valign="top" id="bgmedium" width="100%" height="5px" class="eg_blankspace">&nbsp;</td>
	</tr>
<%
	}
%>

	<tr>
		<td valign="top" id="bgmedium" width="100%" height="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
				<!-- new tab start here -->
<%
	if (!requestFromHomePage && !isReqFromBoxView && !isReqFromCompsView && !isReqFromIBCT)
	{
%>
				<tr>
					<td id="padding6" style="padding-bottom:0px">
						<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" id="toptable" style="table-layout:fixed">
							<col width="55"><col width="10"><col width="170">
							<col width="150"><col width="10"><col width="350">
							<tr>
								<td align="right" nowrap><b><egui:intnl text="configmgmt.common.View By" /></b></td>
								<td align="center"><b>:</b></td>
								<td valign="middle">
									<select name="ec_criteria" style="width:170px;" onChange='javascript:getDetails()'>
<%
		if (vecCriterias != null && !vecCriterias.isEmpty())
		{
			for(int i=0; i<vecCriterias.size(); i++)
			{
				String selected = "";
				String strCriteria = (String)vecCriterias.get(i);
				if(ec_criteria != null && strCriteria.equals(ec_criteria))
				{
					selected = "selected";
				}
%>
				<option value="<%=strCriteria%>" <%=selected%>>
					<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
				</option>
<%
			}
		}
		else
		{
%>
			<option value="-1">
				<egui:intnl text="configmgmt.common.Not Applicable" />
			</option>
<%
		}
%>
									</select>
								</td>
<%
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
%>
								<td align="right" nowrap>
<%
			if (ec_criteria.equalsIgnoreCase(criterias[0]))
			{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
			}
			else if (ec_criteria.equalsIgnoreCase(criterias[1]))
			{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
			}
			else
			{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
			}
%>
								</td>
								<td align="center"><b>:</b></td>
								<td>
									<select name="ec_userOption" style="width: 250px;" onChange='javascript:getDetails()'>
<%
			if (vecUserOptions != null && !vecUserOptions.isEmpty())
			{
				for(int i=0; i<vecUserOptions.size(); i++)
				{
					String selected = "";
					String strUserOption = (String)vecUserOptions.get(i);
					if(ec_userOption != null && strUserOption.equals(ec_userOption))
					{
						selected = "selected";
					}
%>
					<option value="<%=strUserOption%>" <%=selected%>>
						<%=strUserOption%>
					</option>
<%
				}
			}
			else
			{
%>
				<option value="-1">
					<egui:intnl text="configmgmt.common.Not Applicable" />
				</option>
<%
			}
%>
									</select>
								</td>
<%
		}
		else
		{
%>
								<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
		}
%>
							</tr>
						</table>
					</td>
				</tr>
				<!-- new tab end here -->

				<tr>
					<td id="padding6">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable">
							<tr>
								<td>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:fixed" id="text_bold"> <col width="20"><col width="250"><col width="10"><col width="350"><col width="200">
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp;
											</td>
										</tr>

										<tr height="20">
											<td align="center">&nbsp;</td>
											<td nowrap align="right">
												<egui:intnl text="configmgmt.common.Component Type" />
											</td>
											<td align="center">:</td>
											<td nowrap align="left">
												<select name="ec_comptype" style="width:320px" onChange='javascript:getInformations()'>
<%
		if (vec_componentTypes != null && !vec_componentTypes.isEmpty())
		{
%>
													<option value="-1">
														<egui:intnl text="configmgmt.common.Please choose a component type" />
													</option>
<%
			if (comptype==null || comptype.equals("-1"))
			{
				serverList = sorter.getSortedCompTypeList(vec_componentTypes);
				for (int i=0;i<serverList.size();i++)
				{
					EgName nameObj = (EgName)serverList.get(i);
					String actualName = nameObj.getActualName();
					String localName = nameObj.getLocalName();
%>
													<option value="<%=actualName%>"><%=localName%></option>
<%
				}
			}
			else
			{
				serverList = sorter.getSortedCompTypeList(vec_componentTypes);
				for (int i=0;i<serverList.size();i++)
				{
					EgName nameObj = (EgName)serverList.get(i);
					String actualName = nameObj.getActualName();
					String localName = nameObj.getLocalName();
					String selected = "";
					if (actualName != null && actualName.equals(comptype))
					{
						selected = "selected";
					}
%>
													<option value="<%=actualName%>" <%=selected%>>
														<%=localName%>
													</option>
<%
				}
			}
		}
		else
		{
%>
													<option value="-1">
														<egui:intnl text="configmgmt.common.Not Applicable" />
													</option>
<%
		}
%>
												</select>
											</td>
											<td  align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp; </td>
										</tr>
										<tr>
											<td  align="center">&nbsp;</td>
											<td nowrap align="right"> <egui:intnl text="configmgmt.common.Component"/> </td>
											<td align="center">:</td>
											<td nowrap>
												<select style="width:320px" name="ec_component" onChange='javascript:getInformations()'>
<%
		if (v_comp != null && !v_comp.isEmpty())
		{
%>

													<option value="-1">
														<egui:intnl text="configmgmt.common.Please choose a component" />
													</option>
<%
			for (int i=0;i<v_comp.size();i++)
			{
				String componentTemp = (String)v_comp.get(i);
				String tempCompName = "";
				String tempCompType = "";
				String selected = "";
				if (componentTemp != null)
				{
					tempCompName = componentTemp.substring(0,componentTemp.lastIndexOf(":"));
					if (tempCompName.endsWith(":NULL"))
						tempCompName = tempCompName.substring(0,tempCompName.indexOf(":"));
					tempCompType = componentTemp.substring(componentTemp.lastIndexOf(":")+1);
					//getting component type mapping name
					tempCompType = mappingInfo.getComponentTypeDescription(tempCompType);
					if (componentTemp.equals(s_component))
					{
						selected = "selected";
					}
				}
%>
													<option value="<%=componentTemp%>" <%=selected%>>
														<%=tempCompName + ":"+ tempCompType%>
													</option>
<%
			}
		}
		else
		{
%>
													<option value="-1">
														<egui:intnl text="configmgmt.common.Not Applicable" />
													</option>
<%
		}
%>
												</select>
											</td>
											<td  align="center">&nbsp;</td>
										</tr>

										<tr>
											<td colspan="5" height="5" id="blank">&nbsp; </td>
										</tr>

										<tr>
											<td align="center">&nbsp;</td>
											<td nowrap align="right" valign="top">
												<egui:intnl text="configmgmt.configuration.Information" />
											</td>
											<td align="center" valign="top">:</td>
											<td nowrap>
												<select name="ec_test" style="height:90px;width:320px" multiple>
<%
		if (s_selectedInformations != null && s_selectedInformations.length > 0)
		{
			if (al_information!=null && al_information.size()>0)
			{
				for (int i=0;i<al_information.size();i++)
				{
					String strInformation = (String)al_information.get(i);
%>
													<option value="<%=strInformation%>" <%=selectedStatus[i]%>>
														<egui:intnl text='<%="configmgmt.configuration."+strInformation%>' />
													</option>
<%
				}
			}
			else
			{
				if (aListECTests != null)
				{
					for (int i=0;i<aListECTests.size();i++)
					{
						EgName name = (EgName)aListECTests.get(i);
						String enableVal = name.getActualName();
						String enableDis = name.getLocalName();
						String selected = "";
						if (l_selectedInformations.contains(enableVal))
						{
							selected = "selected";
						}
%>
													<option value="<%=enableVal%>" <%=selected%>><%=enableDis%></option>
<%
					}
				}
				else
				{
%>
													<option value= "-1">
														<egui:intnl text="configmgmt.common.Not Applicable" />
													</option>
<%
				}
			}
		}
		else
		{
			if (al_information!=null && al_information.size()>0)
			{
				for (int i=0;i<al_information.size();i++)
				{
					String strInformation = (String)al_information.get(i);
%>
													<option value="<%=strInformation%>" selected>
														<egui:intnl text='<%="configmgmt.configuration."+strInformation%>' />
													</option>
<%
				}
			}
			else
			{
				if (aListECTests != null && !aListECTests.isEmpty())
				{
					for (int i=0;i<aListECTests.size();i++)
					{
						EgName name = (EgName)aListECTests.get(i);
						String enableVal = name.getActualName();
						String enableDis = name.getLocalName();
%>
													<option value="<%=enableVal%>" selected><%=enableDis%></option>
<%
					}
				}
				else
				{
%>
													<option value= "-1">
														<egui:intnl text="configmgmt.common.Not Applicable" />
													</option>
<%
				}
			}
		}
%>
												</select>
											</td>
											<td  align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp; </td>
										</tr>
										<tr>
											<td  colspan="3" align="center">&nbsp;</td>
											<td align="left">
												<table border="0" cellspacing="0" cellpadding="0" width="70%">
													<tr>
<%
		if (reqFrom != null && reqFrom.equalsIgnoreCase("saveSchedule"))
		{
%>
														<td align="center" width="100%" height="20">
															<input type="button" name="x" value='<egui:intnl text="configmgmt.common.SAVE" />' id="darkbutton" style="width: 75px; height: 20px;" href="" onClick="schedule('schedule');">
														</td>
<%
		}
		else
		{
%>
														<td align="center" width="100%" height="20">
															<input type="button" name="x" value='<egui:intnl text="configmgmt.common.SUBMIT" />' id="darkbutton" style="width: 75px; height: 20px;" onClick="javascript:showDetails('submit');">
														</td>
<%
		}
%>
													</tr>
												</table>
											</td>
											<td align="right" style="height:24" valign="bottom" >
												<table align="right" cellspacing="0" cellpadding="0" border="0" height="20"> 
													<tr>
														<td width="50" align="center" id="leftcurve"><img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>
														<td width="2" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="2"></td>
														<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="javascript:printData()"> </td>
														<td width="12" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="12"></td>
														<td align="center" id="leftcurvebg"><img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>
														<td width="12" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="12"></td>
														<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"></td>
														<td width="12" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="12"> </td>
														<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"></td>
														<td width="12" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="12"></td>
														<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/schedules.gif" border="0" title='<egui:intnl text="configmgmt.common.ADD TO SCHEDULES" />' onClick="javascript:schedule('schedule')"> </td>
														<td width="12" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="12"></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
	}
%>

				<tr>
					<td id="padding6" height="100%" width="100%" style="padding-top:0px">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
<%
	if (al_configDetails != null)
	{
%>
							<input type="hidden" name="submitClicked" value="true">
<%
		if (!al_configDetails.isEmpty())
		{
			//For New Pdf Framework - Krishnamurthi
			ArrayList aListPdfData = new ArrayList();
			EgPdfData pdfData = new EgPdfData();
			EgReportAttributes reportAttributes = new EgReportAttributes();

			ArrayList a_title = (ArrayList)al_configDetails.get(0);  //ArrayList for Title
			String title = (String) a_title.get(0); //Add the title to the main title of PDF

			String component = s_component.substring(0,s_component.lastIndexOf(':'));
			if (component.endsWith(":NULL"))
				component = component.substring(0,component.lastIndexOf(':'));

			String pdfTitle = "";
			if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
			{
				pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.CURRENT CONFIGURATION REPORT") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
			}
			else
			{
				pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.CURRENT CONFIGURATION REPORT") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
			}
			reportAttributes.setMainTitle(pdfTitle);

			String pdfSubTitle = mappingInfo.getTextDescription("configmgmt.configuration.Configuration Details for") + " " + component + " [" + title+ "]" ;

			reportAttributes.setSubTitle(pdfSubTitle);
			reportAttributes.setReportName("CurrentConfiguration");
			reportAttributes.setModule("CONFIG");
			reportAttributes.setPortrait(false);
			pdfData.setAttributes(reportAttributes);
%>
							<tr>
								<td align="center" width="100%" height="100%" valign="top" id="bottomtable">
									<table width="100%" border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td width="72%" id="bgdark" class="whitefont" height="20" align="left" >&nbsp;&nbsp;<egui:intnl text="configmgmt.configuration.Configuration Details for" /> <%=component%> [<%=title%>]</td>
											<td align="center" width="28%" id="bgdark"><a id="" href="/final/servlet/com.eg.EcConfigurationServlet?request_from=<%=reqFrom%>&ec_rtype=Change&ec_option1=Component Name&ec_timeline=<%=changeDuration%>&ec_prevtimeline=<%=changeDuration%>&ec_option2=<%=EgURLEncoder.encode(s_component,"UTF-8")%>&ec_changetype=Latest&ec_test=<%=selectedTestnames%>&selectedInformationsInCurrent=<%=selectedInformationsInCurrent%>&ec_viewchange=byInformation&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="_self" class="eg_monlink_white"><b><egui:intnl text="configmgmt.configuration.View changes for current selection" /> &rsaquo;&rsaquo;&rsaquo; </b></a></span></td>
										</tr>

										<tr>
											<td align="center" width="100%" height="100%" valign="top" colspan="3">
												<table width="100%" border="0" cellspacing="0" cellpadding="0">
<%
			for(int m=1;m<al_configDetails.size();m++)
			{
				ArrayList a = (ArrayList)al_configDetails.get(m);  //ArrayList for each test

				ArrayList al_heading = (ArrayList)a.get(0); //Heading - ArrayList
				String heading = (String)al_heading.get(0);

				ArrayList al_flags_both = (ArrayList)a.get(1); //Rows and Column Display Flags - ArrayList 
				ArrayList al_flags_row = (ArrayList)al_flags_both.get(0); //Row Display Flags - ArrayList
				ArrayList al_flags_column = (ArrayList)al_flags_both.get(1); //Column Display Flags - ArrayList

				ArrayList al_columnNames = (ArrayList)a.get(2); //Column Names - ArrayList
				int colCount = al_columnNames.size();

				TreeMap tmap_data = (TreeMap)a.get(3); //Values - TreeMap

				ArrayList aListInfoHeadings = (ArrayList)a.get(4); //Info Headings - ArrayList

				boolean isDynamicMeasureTest = false;
				String firstKey = (String)tmap_data.firstKey();
				int idx_M = firstKey.indexOf("~M~");
				if (idx_M != -1)
				{
					isDynamicMeasureTest = true;
				}

				EgTableAttributes egTableAttributes = new EgTableAttributes();
				egTableAttributes.setTitle(mappingInfo.getTextDescription("configmgmt.configuration."+heading));
				egTableAttributes.setStartX(0);

				ArrayList aListColumnNames = new ArrayList();
				ArrayList aListData = new ArrayList();
				ArrayList userColumnNames = new ArrayList();
				ArrayList fieldTypes = new ArrayList();
%>
													<tr>
														<td height="5" id="blank" class="bgwhite" >&nbsp;</td>
													</tr>
													<tr>
														<td align="center" valign="top" id="bgwhite" >
															<table width="99%" border="0" cellspacing="0" cellpadding="0" id="bottomtable">
																<tr>
																	<td colspan="2" class="bgdarkimg"  height="20">
																		<egui:intnl text='<%="configmgmt.configuration."+heading%>' />
																	</td>
																</tr>
																<tr>
																	<td width="100%" id="form_border">
																		<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text">
<%
				Iterator iter = tmap_data.keySet().iterator();
				boolean colHeading_flag = false;
				boolean field_flag = true;
				int trueFlagColCount = 0;

				int f = 0;
				while(iter.hasNext())
				{
					String key_info = (String)iter.next();
					ArrayList al2 = (ArrayList)tmap_data.get(key_info);
					if (al2.size() != (colCount - 1)) continue;

					if (key_info.equals("+") || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY))
					{
						//Show row-wise data - Non-Info based - Don't show Descriptor
						aListColumnNames.add("C1");
						aListColumnNames.add("C2");
						userColumnNames.add(mappingInfo.getTextDescription("configmgmt.configuration.Attribute"));
						userColumnNames.add(mappingInfo.getTextDescription("configmgmt.configuration.Value"));

						fieldTypes.add("0");
						fieldTypes.add("0");

						for(int x=1;x<colCount;x++)
						{
							String display_flag = (String)al_flags_column.get(x);
							if (display_flag.equals("true"))
							{
								String columnName = (String)al_columnNames.get(x);
								aListData.add(columnName);
								aListData.add(al2.get(x-1));
%>
																			<tr>
																				<td id="cell_header_single" width="50%"> <%=columnName%> </td>
																				<td id="cell_bg1" width="50%">
<%
								String strValue = (String)al2.get(x-1);
								if (strValue.length() <= 100)
								{
									out.println(strValue);
								}
								else
								{
									ArrayList aListStrValues = null;
									if (columnName.equalsIgnoreCase("VM Arguments"))
									{
										aListStrValues = breakString(strValue,68);
									}
									else
									{
										aListStrValues = breakString(strValue,70);
									}
									for (int r=0;r<aListStrValues.size();r++)
									{
										String str_value = (String)aListStrValues.get(r);
										str_value = EcUtils.replaceTags(str_value);
										out.println(str_value+"<br>");
									}
								}
%>
																				</td>
																			</tr>
<%
							}
						}
					}
					else
					{
						if (colCount <= i_configDataColumnCount)
							egTableAttributes.setDataGrouping(false);
						else
							egTableAttributes.setDataGrouping(true);

						//Info-Based
						if (colCount <= i_configDataColumnCount)
						{
							//Column-wise
							if (!colHeading_flag)
							{
%>
																			<tr>
<%
								for(int n=0;n<colCount;n++)
								{
									String display_flag = (String)al_flags_column.get(n);
									if(display_flag!=null && display_flag.equals("true"))
									{
										String columnName = (String)al_columnNames.get(n);

										aListColumnNames.add("C"+n);
										userColumnNames.add(columnName);
										fieldTypes.add("0");
										trueFlagColCount++;

										if (colCount == 2)
										{
%>
																				<td id="cell_header" width="50%"><%=(String)al_columnNames.get(n)%></td>
<%
										}
										else if (colCount == 3)
										{
%>
																				<td id="cell_header" width="33%"><%=(String)al_columnNames.get(n)%></td>
<%
										}
										else if (colCount == 4)
										{
%>
																				<td id="cell_header" width="25%"><%=(String)al_columnNames.get(n)%></td>
<%
										}
										else if (colCount == 5)
										{
%>
																				<td id="cell_header" width="20%"><%=(String)al_columnNames.get(n)%></td>
<%
										}
										else if (colCount == 6)
										{
%>
																				<td id="cell_header" width="16%"><%=(String)al_columnNames.get(n)%></td>
<%
										}
										else if (colCount == 7)
										{
%>
																				<td id="cell_header" width="14%"><%=(String)al_columnNames.get(n)%></td>
<%
										}
										else
										{
%>
																				<td id="cell_header"><%=(String)al_columnNames.get(n)%></td>
<%
										}
									}
								}
%>
																			</tr>
<%
								colHeading_flag = true;
							}

							//if (key_info.indexOf('>') != -1) //Present... Tree form
							//	key_info = key_info.substring(key_info.lastIndexOf('>')+1);

							String row_flag = (String)al_flags_row.get(f);
							if (row_flag.equals("true"))
							{
%>
																			<tr>
<%
								if (!isDynamicMeasureTest)
								{
									aListData.add(ecUtils.getInfoForDisplay(key_info));
									String strInfo = ecUtils.getInfoForDisplay(key_info);
									if (strInfo.length() <= 50)
									{
%>
																				<td id="cell_bg1" valign="top"><%=strInfo%></td>
<%
									}
									else
									{
%>
																				<td valign="top" id="cell_bg1">
<%
										ArrayList aListStrValues = breakString(strInfo,50);
										for (int r=0;r<aListStrValues.size();r++)
										{
											String str_value = (String)aListStrValues.get(r);
											out.print(str_value+"<br>");
										}
%>
																				</td>
<%
									}
								}
								else
								{
%>
																				<td valign="top" id="cell_bg1">
<%
									ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
									int aListTokensSize = aListTokens.size();
									String strData = "";
									String strDataForPDF = "";
									for (int x=0;x<aListTokensSize;x++)
									{
										String infoHeading = (String)aListInfoHeadings.get(x);
										String strTemp = (String)aListTokens.get(x);
										if (x == aListTokensSize-1)
										{
											strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
											strDataForPDF = strDataForPDF + infoHeading + ": " + strTemp;
										}
										else
										{
											strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
											strDataForPDF = strDataForPDF + infoHeading + ": " + strTemp + ", ";
										}
									}
									out.println(strData);
									aListData.add(strDataForPDF);
%>
																				</td>
<%
								}

								for(int z=0;z<colCount-1;z++)
								{
									String display_flag = (String)al_flags_column.get(z+1);
									if (display_flag.equals("true"))
									{
										String s_value = (String)al2.get(z);
										if (s_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
										{
											aListData.add(mappingInfo.getTextDescription("configmgmt.common.Yes"));
%>
																				<td id="cell_bg1" wrap valign="top">
																					<egui:intnl text="configmgmt.common.Yes" />
																				</td>
<%
										}
										else
										{
											aListData.add(s_value);

											if (s_value.length()<=25)
											{
												s_value = EcUtils.replaceTags(s_value);
%>
																				<td id="cell_bg1" valign="top"><%=s_value%></td>
<%
											}
											else
											{
												if (colCount == 3)
												{
													if (s_value.length()<=33)
													{
														s_value = EcUtils.replaceTags(s_value);
%>
																				<td id="cell_bg1" valign="top"><%=s_value%></td>
<%
													}
													else
													{
%>
																				<td valign="top" id="cell_bg1">
<%
														ArrayList aListStrValues = breakString(s_value,33);
														for (int r=0;r<aListStrValues.size();r++)
														{
															String str_value = (String)aListStrValues.get(r);
															str_value = EcUtils.replaceTags(str_value);
															out.print(str_value+"<br>");
														}
%>
																				</td>
<%
													}
												}
												else if (colCount == 2)
												{
													if (s_value.length()<=100)
													{
														s_value = EcUtils.replaceTags(s_value);
%>
																				<td id="cell_bg1" valign="top"><%=s_value%></td>
<%
													}
													else
													{
%>
																				<td valign="top" id="cell_bg1" nowrap>
<%
														ArrayList aListStrValues = breakString(s_value,100);
														for (int r=0;r<aListStrValues.size();r++)
														{
															String str_value = (String)aListStrValues.get(r);
															str_value = EcUtils.replaceTags(str_value);
															out.print(str_value+"<br>");
														}
%>
																				</td>
<%
													}
												}
												else if (colCount == 6)
												{
													if (s_value.length()<=35)
													{
														s_value = EcUtils.replaceTags(s_value);
%>
																				<td id="cell_bg1" valign="top"><%=s_value%></td>
<%
													}
													else
													{
%>
																				<td valign="top" id="cell_bg1">
<%
														ArrayList aListStrValues = breakString(s_value,35);
														for (int r=0;r<aListStrValues.size();r++)
														{
															String str_value = (String)aListStrValues.get(r);
															str_value = EcUtils.replaceTags(str_value);
															out.print(str_value+"<br>");
														}
%>
																				</td>
<%
													}
												}
												else if (colCount == 5)
												{
													if (s_value.length()<=35)
													{
														s_value = EcUtils.replaceTags(s_value);
%>
																				<td id="cell_bg1" valign="top"><%=s_value%></td>
<%
													}
													else
													{
%>
																				<td valign="top" id="cell_bg1">
<%
														ArrayList aListStrValues = breakString(s_value,35);
														for (int r=0;r<aListStrValues.size();r++)
														{
															String str_value = (String)aListStrValues.get(r);
															str_value = EcUtils.replaceTags(str_value);
															out.print(str_value+"<br>");
														}
%>
																				</td>
<%
													}
												}
												else if (colCount == 7)
												{
													if (s_value.length()<=35)
													{
														s_value = EcUtils.replaceTags(s_value);
%>
																				<td id="cell_bg1" valign="top"><%=s_value%></td>
<%
													}
													else
													{
%>
																				<td valign="top" id="cell_bg1">
<%
														ArrayList aListStrValues = breakString(s_value,35);
														for (int r=0;r<aListStrValues.size();r++)
														{
															String str_value = (String)aListStrValues.get(r);
															str_value = EcUtils.replaceTags(str_value);
															out.print(str_value+"<br>");
														}
%>
																				</td>
<%
													}
												}
												else
												{
													if (s_value.length()<=25)
													{
														s_value = EcUtils.replaceTags(s_value);
%>
																				<td id="cell_bg1" valign="top"><%=s_value%></td>
<%
													}
													else
													{
%>
																				<td valign="top" id="cell_bg1">
<%
														ArrayList aListStrValues = breakString(s_value,25);
														for (int r=0;r<aListStrValues.size();r++)
														{
															String str_value = (String)aListStrValues.get(r);
															str_value = EcUtils.replaceTags(str_value);
															out.print(str_value+"<br>");
														}
%>
																				</td>
<%
													}
												}
											}
										}
									}
								}
							}
							else
							{
								aListData.add(ecUtils.getInfoForDisplay(key_info));
								for(int z=0;z<trueFlagColCount-1;z++)
								{
									aListData.add("");
								}
%>
																				<td id="cell_bg1" valign="top" colspan="<%=trueFlagColCount%>"><%=ecUtils.getInfoForDisplay(key_info)%></td>
<%
							}
%>
																			</tr>
<%
						}
						else
						{
							//Row-wise
							String row_flag = (String)al_flags_row.get(f);
							if (field_flag)
							{
								aListColumnNames.add("C1");
								aListColumnNames.add("C2");
								aListColumnNames.add("C3");
								userColumnNames.add(mappingInfo.getTextDescription("configmgmt.configuration.Descriptor"));
								userColumnNames.add(mappingInfo.getTextDescription("configmgmt.configuration.Attribute"));
								userColumnNames.add(mappingInfo.getTextDescription("configmgmt.configuration.Value"));

								fieldTypes.add("0");
								fieldTypes.add("0");
								fieldTypes.add("0");

								egTableAttributes.setDataGroupingField(0);
								field_flag = false;
							}
							//if (key_info.indexOf('>') != -1) //Present... Tree form
							//	key_info = key_info.substring(key_info.lastIndexOf('>')+1);
							if (row_flag.equals("true"))
							{
								String strDataForPDF = "";
								if (!isDynamicMeasureTest)
								{
%>
																			<tr>
																				<td height="20" colspan="2" class="bglightimg"><%=ecUtils.getInfoForDisplay(key_info)%></td>
																			</tr>

<%
								}
								else
								{
%>
																			<tr>
																				<td valign="top" class="bglightimg" colspan="2">
<%
									ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
									int aListTokensSize = aListTokens.size();
									String strData = "";
									for (int x=0;x<aListTokensSize;x++)
									{
										String infoHeading = (String)aListInfoHeadings.get(x);
										String strTemp = (String)aListTokens.get(x);
										if (x == aListTokensSize-1)
										{
											strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
											strDataForPDF = strDataForPDF + infoHeading + ": " + strTemp;
										}
										else
										{
											strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
											strDataForPDF = strDataForPDF + infoHeading + ": " + strTemp + ", ";
										}
									}
									out.println(strData);
%>
																				</td>
																			</tr>
<%
								}

								for(int p=1;p<colCount;p++)
								{
									String display_flag = (String)al_flags_column.get(p);
									if (display_flag.equals("true"))
									{
										if (!isDynamicMeasureTest)
										{
											aListData.add(ecUtils.getInfoForDisplay(key_info));
										}
										else
										{
											aListData.add(strDataForPDF);
										}
										aListData.add((String)al_columnNames.get(p));
%>
																			<tr>
																				<td id="cell_header_single" width="50%"><%=(String)al_columnNames.get(p)%></td>
<%
										String s_value = (String)al2.get(p-1);
										if (s_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
										{
											aListData.add(mappingInfo.getTextDescription("configmgmt.common.Yes"));
%>
																				<td id="cell_bg1" width="50%"><egui:intnl text="configmgmt.common.Yes" />&nbsp;</td>
<%
										}
										else
										{
											aListData.add(s_value);
											if (s_value.length() <= 100)
											{
												s_value = EcUtils.replaceTags(s_value);
%>
																				<td id="cell_bg1" width="50%"><%=s_value%>&nbsp;</td>
<%
											}
											else
											{
%>
																				<td id="cell_bg1" width="50%">
<%
												ArrayList aListStrValues = breakString(s_value,100);
												for (int r=0;r<aListStrValues.size();r++)
												{
													String str_value = (String)aListStrValues.get(r);
													str_value = EcUtils.replaceTags(str_value);
													out.print(str_value+"<br>");
												}
%>
																				</td>
<%
											}
										}
%>
																			</tr>
<%
									}
								}
							}
							else
							{
								aListData.add(ecUtils.getInfoForDisplay(key_info));
								aListData.add("");
								aListData.add("");
%>
																			<tr>
																				<td height="20" colspan="2" class="cell_bg2"><%=ecUtils.getInfoForDisplay(key_info)%></td>
																			</tr>
<%
							}
						}
					}
					f++;
				}
%>
																		</table>
																	</td>
																</tr>
															</table>
														</td>
													</tr>

													<tr>
														<td colspan="3" id="bgwhite"><img src="/final/config/images/spacer.gif" height="5"></td>
													</tr>
<%
				//For new Pdf Framework
				EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);

				egTableAttributes.setColumnNames(userColumnNames);
				egTableAttributes.setFieldTypes(fieldTypes);

				EgTable egTable = new EgTable();
				egTable.setModel(egTableModel);
				egTable.setAttributes(egTableAttributes);

				aListPdfData.add(egTable);
			}
%>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
			//For new pdf framework
			pdfData.setData(aListPdfData);
			session.setAttribute("pdfData",pdfData);
		}
		else
		{
%>
							<tr>
								<td align="center">
									<table border="0" align="center" width="100%" id="bottomtable" height="100%">
										<tr>
											<td align="center">
												<table border="0" align="center" width="100%" class="body_text" >
													<tr>
														<td align="center"><img src="/final/config/images/unavailable-data.gif" title='<egui:intnl text="configmgmt.common.No Data" />'></td>
													</tr>
													<tr>
														<td align="center"><b><egui:intnl text="configmgmt.common.No result found for current selection" /></b></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
		}
	}
	else
	{
%>
							<input type="hidden" name="submitClicked" value="false">
							<tr>
								<td align="center">
									<table border="0" align="center" width="100%"  height="100%" id="bottomtable">
										<tr>
											<td align="center">
												<table border="0" align="center" width="100%" class="body_text">
													<tr>
														<td align="center">&nbsp;</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
%>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</form>
</body>
</html>



