<!DOCTYPE html>

<%@ include file="EcTracker.jsp" %>
<%@ page import = "java.util.*"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import = "com.eg.EgURLEncoder"%>


<%!
	public static String prepareEnocodedQueryString(Map params)
	{
		if (params == null || params.size() == 0) return "";
		String queryStr = "";
		try
		{
			Iterator itr = params.keySet().iterator();
			while (itr.hasNext())
			{
				String key = (String)itr.next();
				if (key.trim().length() == 0) continue;
				Object value= params.get(key);

				if (value instanceof String[])
				{
					String val[] =(String[])value;
					for(int i=0;i<val.length;i++)
						queryStr += key + "=" + EgURLEncoder.encode(val[i],"UTF-8") + "&";
				}
				else
				{
					if (value == null) value = "";
					queryStr += key + "=" + EgURLEncoder.encode((String)value,"UTF-8") + "&";
				}
			}
			if (queryStr.length() > 0) queryStr = queryStr.substring(0,queryStr.length()-1);
		}
		catch(Exception e)
		{
			queryStr = "";
		}
		return queryStr;
	}
%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String queryString = prepareEnocodedQueryString(request.getParameterMap());

	String ec_comptype = request.getParameter("ec_comptype");
	String ec_component = request.getParameter("ec_component");
	String o_comptype = request.getParameter("old_comptype");

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");

	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");
	String request_from = request.getParameter("requestFrom");
	String submitOrNot = (String) request.getAttribute("isSubmit");

	if (submitOrNot == null || "null".equals(submitOrNot))
	{
		submitOrNot = "true";
	}

	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		submitOrNot = "false";
	}

	String userName = (String)session.getAttribute("sess_auserid");
	String id = request.getParameter("id");
	String strBackRequest = request.getParameter("back_request");
	String strsubmitClicked = request.getParameter("submitClicked");
	if (strsubmitClicked == null)
	{
		strsubmitClicked = "false";
	}
	if (strBackRequest != null && strBackRequest.equalsIgnoreCase("ScheduleConfig") && strsubmitClicked != null && strsubmitClicked.equalsIgnoreCase("false"))
	{
		submitOrNot = "false";
	}

	String configServletURL = "../servlet/com.eg.EcConfigurationServletNew";
	String servletURL = configServletURL;

	if (queryString == null) queryString = "cmd=Home";

	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		servletURL = "../servlet/com.eg.EcSchedulerCNew";
		if (queryString == null) queryString = "";
	}

%>

<html>
<head>
	<meta charset="utf-8">

	<!--Skin color--------->
	<egui:skin ui = "configindex"/>

	<script type="text/javascript" src="../extjs/ext-all.js"></script>

	<!-- Fancy Scroll-->
	<script src="/final/jquery/jquery.js"></script>
	<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
	<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
	<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
	<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>

	
	<!--For Highcharts-->
	<script src="/final/Highcharts/js/highcharts.js"></script>
	<script src="/final/Highcharts/js/modules/exporting.js"></script>
	<script src="../config/scripts/EcHighCharts.js"></script>

	<!-- Utilities File -->
	<script language="Javascript1.2" src="/final/config/utilities/Schedule.js"></script> 
	<script language="Javascript1.2" src="/final/config/utilities/Common.js"></script> 
	<!-- End -->

	<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
	<script language="Javascript1.2" src="/final/config/scripts/ec_validate.js"></script>
	<script language="JavaScript1.2" src="/../final/scripts/screen_display.js"></script>

	<script language="JavaScript1.2">
		var publicJSON = "";
		var strRequestFrom = '<%=request_from%>';
		var ec_criteria = '<%=ec_criteria%>';
		var ec_userOption = '<%=ec_userOption%>';
		var id = '<%=id%>';
		var hiddenFieldsKeys = "";
		var chartType = "HighCharts";
		var queryString = '<%=queryString%>';
		var hiddenFieldsKeys = '';
		var probsErrorMessage = '<egui:intnl text="config.error.Problem encountered while loading the user interface"/>';
		var requestTimeOut = '<egui:intnl text="config.error.Response timed out"/>';
		var errorTitle = '<egui:intnl text="config.user.Error"/>';
		
		var config = {
		title : {
			mainPageTitle : '<egui:intnl text="configmgmt.configuration.DASHBOARD" />',
			submitTitle : '<egui:intnl text="configmgmt.common.Submit" />',
			viewByTitle : '<egui:intnl text="configmgmt.common.View By" />',
			compTypeTitle : '<egui:intnl text="configmgmt.common.Component Type" />',
			compNameTitle : '<egui:intnl text="configmgmt.common.Component" />',
			serverTitle : '<egui:intnl text="configmgmt.common.Server Name" />',
			ApplicationTitle : '<egui:intnl text="configmgmt.common.Application" />',
			backBtn : '<egui:intnl text="configmgmt.common.Back" />',
			row1col1title : '<egui:intnl text="configmgmt.common.Machines" />',
			row1col2title : '<egui:intnl text="configmgmt.common.Change Summary" />',
			row2col2title : '<egui:intnl text="configmgmt.common.Changes At-A-Glance" />',
			row3col2title : '<egui:intnl text="configmgmt.common.Changes Over Time" />',
			byOSVersionGridColLabel1 : '<egui:intnl text="configmgmt.dashboard.Operating system" />',
			byOSVersionGridColLabel2 : '<egui:intnl text="configmgmt.dashboard.Version" />',
			byOSVersionGridColLabel3 : '<egui:intnl text="configmgmt.dashboard.Count" />',
			topninstallsGridLabel1 : '<egui:intnl text="configmgmt.dashboard.Name" />',
			topninstallsGridLabel2 : '<egui:intnl text="configmgmt.dashboard.Installs" />',
			changesummaryGridLabel1 : '<egui:intnl text="configmgmt.dashboard.Component Type" />',
			changesummaryGridLabel2 : '<egui:intnl text="configmgmt.dashboard.Changes" />',
			changeAtAGlanceGridLabel1 : '<egui:intnl text="configmgmt.dashboard.Component Name" />',
			changeAtAGlanceGridLabel2 : '<egui:intnl text="configmgmt.dashboard.Changes" />',
			changeAtAGlanceGridLabel3 : '<egui:intnl text="configmgmt.dashboard.Changes in" />',
		},
		urls : {
			initialURL : "../config/ConfigMgmtHome/data/ConfigMgmtHomeJson.jsp",
			servletURL : "<%=servletURL%>",
			pdfURL : "/final/servlet/com.eg.EcPdfDownloadC"
		},
		msgs : {
			errorMsg1 : '<egui:intnl text="configmgmt.common.Please select a component." />',
			errorZone : '<egui:intnl text="configmgmt.common.Please select a Zone." />',
			errorService : '<egui:intnl text="configmgmt.common.Please select a Service." />',
			errorSegment : '<egui:intnl text="configmgmt.common.Please select a Segment." />',
			errorApp : '<egui:intnl text="configmgmt.common.Please select an application." />',
			errorCompType : '<egui:intnl text="configmgmt.common.Please select a component type." />'
		}
	};
	</script>
	<script src="../config/ConfigMgmtHome/app/app.js"></script>
	<script language="javascript">
		Ext.onReady(function(){
			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
				else
				{
					if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : requestTimeOut,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
					else
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : probsErrorMessage,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
				}
			});
		});
	</script>
</head>

<body>
<div id="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;">
	<div class="x-mask-loading" style="position:relative">
		Loading...
	</div>
</div>
</body>

</html>



