<%
/*
 *   File					:	EcViewSchedule.jsp
 *   Purpose				:	View the configured schedule
 *   Creation Date			:	22/06/2006
 *   Author					: 	Balasigamani, Krishnamurthi
  *  UI Design Changes		:	Jaiwin
 */
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EcTracker.jsp" %>
<%@ page import = "egurkha.config.EcScheduleTask" %>
<%@ page import = "egurkha.config.EcReportParam" %>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	String user_id = user.getLoginID();
	EcScheduleTask[] task = EcScheduleTask.getScheduleListForUser(user_id);
	
	//date format
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String userDateFormat = user.getUserDateFormat();
	if (userDateFormat != null && userDateFormat.equalsIgnoreCase("Default"))
	{
		userDateFormat = currentDateFormat;
	}
	//end here

	int page1=1;

	double total_num_records=0;
	double total_num_records_per_page=0;
	int total_num_page=1;

	if((task!=null) && (task.length>0))
	{
		total_num_records=task.length;
		total_num_records_per_page=15.00;

		if(task.length<=10)
		{
			total_num_page=1;
		}
		else
		{
			total_num_page=(int)Math.round(Math.ceil(total_num_records/total_num_records_per_page));
		}
	}
%>

<html>
<!-- <link rel=stylesheet href="/final/config/styles/ec_style_green.css"> -->
<egui:skin ui="config"/>

<script language="JavaScript">

	var totalpages=<%=total_num_page%>;
	function checkPageNumber()
	{
		var thisform=window.document.Ecschedule;
		if(totalpages<thisform.pageno.value)
		{
			alert('<egui:intnl text="configmgmt.schedule.Page Number" />'+" '"+thisform.pageno.value+"' "+'<egui:intnl text="configmgmt.schedule.does not exist" />'+"!");
			thisform.pageno.value="";
			thisform.pageno.focus();
			return false;
		}
		if(thisform.pageno.value<=0)
		{
			alert('<egui:intnl text="configmgmt.schedule.Page Number" />'+" '"+thisform.pageno.value+"' "+'<egui:intnl text="configmgmt.schedule.does not exist" />'+"!");
			thisform.pageno.value="";
			thisform.pageno.focus();
			return false;
		}
		if(isNaN(thisform.pageno.value))
		{
			alert('<egui:intnl text="configmgmt.schedule.Page Number" />'+" '"+thisform.pageno.value+"' "+'<egui:intnl text="configmgmt.schedule.is Invalid" />'+"!");
			thisform.pageno.value="";
			thisform.pageno.focus();
			return false;
		}
		thisform.action = "/final/config/EcViewSchedule.jsp";
		thisform.submit();	
	}

	function showPage(pageno)
	{
		var thisform=window.document.Ecschedule;
		thisform.action = "/final/config/EcViewSchedule.jsp?pageno="+pageno;
		thisform.submit();
	}
	
	function deleteSchedules()
	{
		var thisform=window.document.Ecschedule;
		var sch_id="";
		var sch_name="";
		for(i=0;i<thisform.elements.length;i++)
		{
			if(thisform[i].type=="checkbox" && thisform[i].name!="all" && thisform[i].checked)
			{
				sch_id += thisform[i].value +",";

				var Td = document.getElementById(thisform[i].value);
				if (Td.innerText)
				{
					sch_name += "'"+Td.innerText+"_cf',";
				}
				else if (Td.textContent)
				{
					sch_name += "'"+Td.textContent.trim()+"_cf',";
				}
			}
		}

		if (sch_id=="") 
		{
			alert('<egui:intnl text="configmgmt.schedule.Please select a schedule" />');
			return;
		}

		if(!confirm('<egui:intnl text="configmgmt.schedule.Are you sure to delete the selected item(s)" />'+'?')) return;
		sch_id= sch_id.substring(0,sch_id.length - 1);
		sch_name = sch_name.substring(0,sch_name.length - 1);

		thisform.action = "/final/servlet/com.eg.EcSchedulerC?cmd=Delete&id="+sch_id+"&sch_name="+sch_name;
		thisform.submit();
	}

	function checkAll(flag)
	{
		var thisform=window.document.Ecschedule;
		for(i=0;i<thisform.elements.length;i++)
		{
			if(thisform[i].type=="checkbox" && thisform[i].name!="all")
				thisform[i].checked = flag;
		}
	}

	function Toggle(e)
	{
		if (e.checked)
		{
			document.Ecschedule.all.checked = AllChecked();
		}
		else
		{
			document.Ecschedule.all.checked = false;
		}
	}
	
	function AllChecked()
	{
		ml = document.Ecschedule;
		len = ml.elements.length;

		for(var i = 0 ; i < len ; i++)
		{
			if (ml.elements[i].name == "mid" && !ml.elements[i].checked) {
			return false;
			}
		}
		return true;
	}

</script>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0">
<form name="Ecschedule" method="post" style="margin:0px">
<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center" height="100%">

	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="padding5">
				<tr>
					<td align="left" id="main_head_top" width="97%" nowrap>
						&nbsp;<b><egui:intnl text="configmgmt.schedule.SCHEDULES" />
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td align="center" valign="top" id="padding6" class="bgmedium" width="100%" height="100%">
			<table ID="bottomtable" width="100%" align="center" cellspacing="0" cellpadding="0" border="0" class="cellborder"  height="100%" >
				<tr>
					<td  height="15" id="blank">&nbsp;</td>
				</tr>
				<tr>
					<td valign="top">
						<table align="center" width="95%" cellspacing="0" cellpadding="0"  border="0"  id="body_text" class="bottomtable"><col width="5%" style="padding-left:4px"><col width="20%" style="padding-left:4px"><col width="25%" style="padding-left:4px"><col width="15%" style="padding-left:4px"><col width="15%" style="padding-left:4px"><col width="20%" style="padding-left:4px">
<%
	if(task == null || task.length == 0)
	{
%>
							<tr>
								<td colspan="6" align="center"  height="26" class="bglightlight" ID="blackcontent">
									<b><egui:intnl text="configmgmt.schedule.You do not have any schedules configured currently" />.</b>
								</td>
							</tr>
<%
	}
	else
	{
%>
							<tr  height="23" >
								<th nowrap class="table_header_dash">&nbsp;</th>
								<th nowrap style="text-align:left" class="table_header_dash">
									<b><egui:intnl text="configmgmt.schedule.Schedule Name" /></b>
								</th>
								<th nowrap style="text-align:left" class="table_header_dash">
									<b><egui:intnl text="configmgmt.schedule.Report Type" /></b>
								</th>
								<th nowrap style="text-align:left" class="table_header_dash">
									<b><egui:intnl text="configmgmt.schedule.Mail" /></b>
								</th>
								<th nowrap style="text-align:left" class="table_header_dash">
									<b><egui:intnl text="configmgmt.schedule.Print" /></b>
								</th>
								<th nowrap style="text-align:left" class="table_header_dash">
									<b><egui:intnl text="configmgmt.schedule.Creation Time" /></b>
								</th>
							</tr>
								
							<tr>
								<td colspan="6" class="table_header" id="white_content" style="border-right-width:0px;padding-left:5px"><input type="checkbox" name="all" onClick="checkAll(this.checked)" id="eg_input" style="background:transparent">&nbsp;<egui:intnl text="configmgmt.schedule.All Schedules" />
								</td>
							</tr>
<%
		EgDateInfo egDate = new EgDateInfo();
		int start_index_page=1;
		int end_index_page=total_num_page>15?15:total_num_page;
		if(request.getParameter("pageno")!=null)
		{
			try
			{
				page1=Integer.parseInt(request.getParameter("pageno"));
				if(page1==1)
				{
					start_index_page=1;
					end_index_page=total_num_page>15?15:total_num_page;
				}
				if(page1>=6)
				{
					start_index_page=page1-5;
					end_index_page=page1+4;
											
					if(end_index_page>total_num_page)
					{
						start_index_page=start_index_page-(end_index_page-total_num_page);
						end_index_page=total_num_page;
					}
					if(page1==total_num_page)
					{
						start_index_page=page1-9;
						end_index_page=total_num_page;
					}
				}
			}
			catch(Exception e)
			{
				page1=1;
			}
		}
		
		int starting_record=0;
		int ending_record=15;

		if(page1>1)
		{
			starting_record=((page1-1)*15);
			ending_record=(15*page1);
			if(ending_record>(task.length))
			{
				ending_record=task.length;
			}
		}
		else
		{
			if(ending_record>(task.length))
			{
				ending_record=task.length;
			}
		}

		for(int i=starting_record;i<ending_record;i++)
		{
			long sch_id = task[i].getScheduleId();
			String schName = task[i].getName();
			if (schName != null && schName.length()  > 3)
			{
				schName = schName.substring(0,schName.length() - 3);
			}
%>
							<tr height="30" >
								<td>&nbsp;<input type="checkbox" name="mid" value="<%=sch_id%>" onclick="Toggle(this)" style="background:transparent"  id="eg_input">
								</td>
								<td id="<%=sch_id%>"><a class="eg_monlink" style="text-decoration:underline;"  href="/final/servlet/com.eg.EcSchedulerC?cmd=Edit&id=<%=sch_id%>&request_from=ViewSchedulePage"><%=schName%></td>
								<td>
									<egui:intnl text='<%="configmgmt.schedule."+(new EcReportParam(task[i].getDetails())).getReportName()%>' />
								</td>
<%
			String creationDate = egDate.egetDateUS(task[i].getCreationTime().getTime());
			String dateOnly = creationDate.substring(0,creationDate.indexOf(' '));
			String timeOnly = creationDate.substring(creationDate.indexOf(' ')+1);
			dateOnly = DateUtil.changeDateFormat(dateOnly,"MM/dd/yyyy",currentDateFormat);

			/* Added by Prakash.K starts */
			EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateOnly+" "+timeOnly,user);
			String dateAndTime = timeZoneConverter.getDateTime();
			/* Added by Prakash.K ends */
%>
								<td>
									<egui:intnl text='<%="configmgmt.schedule."+task[i].getMailFrequency()%>' />
								</td>
								<td>
									<egui:intnl text='<%="configmgmt.schedule."+task[i].getPrintFrequency()%>' />
								</td>
								<td>
									<%=dateAndTime%>
								</td>
							</tr>
							<tr>
								<td  height="1" id="blank" class="linebottom" colspan="6">&nbsp;</td>
							</tr>
<%
		}
%>
							<tr  height="10">
								<td colspan="6"></td>
							</tr>
							<tr>
								<td class="table_header" style="border-right-width:0px" colspan="6" height="25" valign="middle">&nbsp;&nbsp;
									<input type="button" value='<egui:intnl text="configmgmt.common.DELETE" />' id="darkbutton"  onClick="javascript:deleteSchedules();" style="width:65px;height:20px;">
								</td>
							</tr>
<%
		if(total_num_page>1)
		{
%>
							<tr class="cellbg" height="24">
								<td colspan="6">
									<table border="0" width="100%" class="border">
										<tr>
											<td align="left">
											&nbsp;
											</td>
											<td align="center" width="40%">
												<egui:intnl text="configmgmt.schedule.Go to Page" /> : <input type="text" name="pageno" style="width: 25px; text-align: center;">
												<input type="button" value='<egui:intnl text="configmgmt.schedule.GO" />' ID="er_delete"  style="width: 22px; height: 20px;" onClick="return checkPageNumber();">
											</td>
											<td colspan=3 class="alarmlink" width="40%" align="center">
<%
			if(page1>1)
			{
%>
												<img src="/final/reporter/images/home.gif" width="10" height="8" border="0" alt='<egui:intnl text="configmgmt.schedule.First" />' onClick="javascript:showPage(1)" >
													&nbsp;&nbsp;
												<img src="/final/reporter/images/prev.gif" width="10" height="8" border="0" alt='<egui:intnl text="configmgmt.schedule.Previous" />' onClick="javascript:showPage(<%=(page1-1)%>)" >
													&nbsp;
<%
			}
			else
			{
%>
													&nbsp;
<%
			}
			
			for(int i=start_index_page;i<=end_index_page;i++)
			{
				if((i>total_num_page) ||(i<=0))
				{
					continue;
				}
				else
					if(page1==i)
					{
%>
												<b class="alarmlink1"><%=i%></b>
<%
					}
					else
					{
%>
												<b><a href="/final/config/EcViewSchedule.jsp?pageno=<%=i%>" class="alarmlink"><%=i%></a></b>
<%
					}
			}
%>
												&nbsp;
<%
			if(page1!=total_num_page)
			{
%>
												<img src="/final/reporter/images/next2.gif" width="10" height="8" border="0" alt='<egui:intnl text="configmgmt.schedule.Next" />' onClick="javascript:showPage(<%=(page1+1)%>)" > 
												&nbsp;&nbsp;

												<img src="/final/reporter/images/end.gif" width="10" height="8" border="0" alt='<egui:intnl text="configmgmt.schedule.Last" />' onClick="javascript:showPage(<%=(total_num_page)%>)" >
												&nbsp;

<%
			}
			else
			{
%>
												&nbsp;
<%
			}

%>
											</td>
											<td>&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
<%
		}
	}
%>
						</table>
					</td>
				</tr>

				<tr height="15"><td>&nbsp;</td></tr>
			</table>
		</td>
	</tr>

</table>
</form>
</body>
</html>
