Ext.define('IPAddress.view.IPAddressChart',
	{
		extend:'Ext.container.Container',
		alias:'widget.ipaddresschart',
		html:'<div id="ipaddresschart"></div>',
		loadChart:function(configJsonData,thisController){
			var me = this;
			if(!Ext.isEmpty(configJsonData))
			{
				if(configJsonData.hasConfigDetails)
				{
					if (chartType=='fusionchart')
					{
						if(FusionCharts("myStackedBarSystem3DChartId"))
						{
							FusionCharts( "myStackedBarSystem3DChartId" ).dispose();
						}
						var myChart = new FusionCharts(configJsonData.chartData.swfPath,"myStackedBarSystem3DChartId", "90%", "280","0","1");
						myChart.setDataXML(configJsonData.chartData.xmlString);
						myChart.setTransparent(true);
						myChart.render("ipaddresschart");
					}
					else
					{
						var highChart = {};
						highChart = jQuery.extend(true, {}, getHighChartsInstance('ipaddresschart',configJsonData.chartData.chartHeight+50,configJsonData.chartData.chartWidth+50), highChart);
						highChart.setData(configJsonData.chartData,'','');
						highChart.drawChart();
					}
				}
				else
				{
					Ext.select("#ipaddresschart").update('<div class = "iconExclamation" style="margin:2% auto 0 auto;"></div><div class="font_normal12" style="text-align:center"><b>'+configJsonData.errorText+'.</b></div>');
				}
			}
		}
});



