var req_from = "";
Ext.define('MeasureComparison.controller.Main', {
	extend : 'Ext.app.Controller',
	views : [
		'Main',
		'FormItems',
		'SelectionDetails',
		'configutilities.TimeLineForMesComparsion'
	],
	refs:[
		{
			selector : 'main', 
			ref : 'main'
		},
		{
			selector : 'formitems', 
			ref : 'formitems'
		},
		{
			selector : 'selectionDetails', 
			ref : 'selectionDetails'
		},
		{
			selector : 'timelineformescomparsion', 
			ref : 'timelineformescomparsion'
		}
		
	],
	init :function() {
		me = this;
		this.buildFieldData()
		this.control({
			'main': {
				'afterrender': this.afterMainRender
			},
			'timelineformescomparsion combo[id="ec_timeline"]':
			{
				'select': this.changeTimeLine
			},
			'timelineformescomparsion datepicker[id="ec_stdate"]':
			{
				'select': this.changeTimeLine
			},
			'timelineformescomparsion combo[id="ec_sthr"]':
			{
				'select': this.changeTimeLine
			},
			'timelineformescomparsion combo[id="ec_startmin"]':
			{
				'select': this.changeTimeLine
			},
			'timelineformescomparsion datepicker[id="ec_enddate"]':
			{
				'select': this.changeTimeLine
			},
			'timelineformescomparsion combo[id="ec_endhr"]':
			{
				'select': this.changeTimeLine
			},
			'timelineformescomparsion combo[id="ec_endmin"]':
			{
				'select': this.changeTimeLine
			},
			'formitems button[id="submit"]' :{
				'click' : this.showDetails
			},
			'formitems combobox[id="ec_comptype"]' :{
				'select' : this.getInformation
			},
			'formitems combobox[id="ec_component"]' :{
				'select' : this.getInformation
			},
			'formitems combobox[id="ec_test"]' :{
				'select' : this.setInformation
			},
			'formitems combobox[id="ec_criteria"]' :{
				'select' : this.getDetails
			},
			'formitems combobox[id="ec_userOption"]' :{
				'select' : this.getDetails
			},
			'formitems combobox[id="descriptor"]' :{
				'select' : this.getDescriptor
			},
			'formitems combobox[id="ec_measure"]' :{
				'select' : this.getMeasureDiff
			},
			'formitems combobox[id="ec_measureChangeTime"]' :{
				'select' : this.getMeasureChangeTime
			},
			'main button[id="justDiff"]' :{
				'click' : this.showOnlyDiffData
			},
			'main button[id="showAll"]' :{
				'click' : this.showAllData
			},
			'main button[id="prevDiff"]' :{
				'click' : this.previousDiff
			},
			'main button[id="nextDiff"]' :{
				'click' : this.nextDiff
			},
			'main button[id="backBtnMain"]':{
				'click' : this.goBack
			}
		});
	},
	
	buildFieldData : function()
	{
		Ext.Ajax.request({
			url : config.urls.servletURL,
			params : queryString+"&needData=yes",
			method : 'POST',
			async : false,
			success : function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) 
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					hiddenFieldsKeys = publicJSON['hiddenFields'];
					timeLineCollection = publicJSON['hiddenCollections'];
				}
			}
		});
	},

	afterMainRender : function()
	{
		if(strRequestFrom != null && strRequestFrom.toLowerCase() == 'measurecomp') // request from own page
		{
			Ext.getCmp('backBtnMain').hide();
			me.getFormitems().show();
			/** Loading combolist values **/
			var s_comptype = Ext.getCmp('ec_comptype');
			var s_compname = Ext.getCmp('ec_component');
			var s_info = Ext.getCmp('ec_test');
			var ec_userOption = Ext.getCmp('ec_userOption');
			var ec_criteria = Ext.getCmp('ec_criteria');

			ec_criteria.getStore().loadRawData(publicJSON['viewByList']);
			ec_criteria.setValue(publicJSON.selectedEcOpt);

			if (publicJSON.selectedEcOpt != 'Component')
			{
				ec_userOption.getStore().loadRawData(publicJSON.specViewByList);
				ec_userOption.setValue(publicJSON.selectedUserOptionText);
				ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
				ec_userOption.show();
			}
			else
			{
				ec_userOption.hide();
			}
			s_comptype.getStore().loadRawData(publicJSON['compTypes']);
			s_comptype.setValue(publicJSON.selectedCmpType);
			s_compname.getStore().loadRawData(publicJSON['compNames']);
			s_compname.setValue(publicJSON.selectedCmpName);
			s_info.getStore().loadRawData(publicJSON['infoList']);
			s_info.setValue(publicJSON.selectedTests);
			Ext.getCmp("submit").setDisabled(false);
			Ext.getCmp('descriptor').hide();
			Ext.getCmp('ec_measure').hide();
			Ext.getCmp('ec_measureChangeTime').hide();
			me.fillTimeLineView();
		}
		else if(strRequestFrom != null && (strRequestFrom.toLowerCase() == 'changeconfig' || strRequestFrom.toLowerCase() == 'showcompchanges') )// request from change configuration
		{
			Ext.getCmp('backBtnMain').show();
			me.getFormitems().hide();
			me.getFormitems().setDisabled(true);
			me.showDetails("changeconfig");
		}
	},
	fillTimeLineView : function()
	{
		var hiddenFieldsStr = me.getHiddenFields(hiddenFieldsKeys);
		this.storeHiddenFields(timeLineCollection);
		var ec_timeline = Ext.getCmp('ec_timeline');
		var ec_stdate = Ext.getCmp('ec_stdate');
		var ec_sthr = Ext.getCmp('ec_sthr');
		var ec_startmin = Ext.getCmp('ec_startmin');
		var ec_enddate = Ext.getCmp('ec_enddate');
		var ec_endhr = Ext.getCmp('ec_endhr');
		var ec_endmin = Ext.getCmp('ec_endmin');

		ec_timeline.getStore().loadRawData(publicJSON.timeLineDetails.ec_timelineArr);
		ec_timeline.setValue(publicJSON.timeLineDetails.selectedTimeLine);
		
		// From Date
		ec_stdate.setValue(publicJSON.timeLineDetails.ec_stdate);
		ec_sthr.getStore().loadRawData(publicJSON.timeLineDetails.ec_sthr);
		ec_sthr.setValue(publicJSON.timeLineDetails.selectedStartHr);
		ec_startmin.getStore().loadRawData(publicJSON.timeLineDetails.ec_startmin);
		ec_startmin.setValue(publicJSON.timeLineDetails.selectedStartMin);

		// To Date
		ec_enddate.setValue(publicJSON.timeLineDetails.ec_enddate);
		ec_endhr.getStore().loadRawData(publicJSON.timeLineDetails.ec_endhr);
		ec_endhr.setValue(publicJSON.timeLineDetails.selectedEndHr);
		ec_endmin.getStore().loadRawData(publicJSON.timeLineDetails.ec_endmin);
		ec_endmin.setValue(publicJSON.timeLineDetails.selectedEndMin);

		if (publicJSON.timeLineDetails.selectedTimeLine == "Any")
		{
			ec_stdate.setDisabled(false);
			ec_sthr.setDisabled(false);
			ec_startmin.setDisabled(false);

			ec_enddate.setDisabled(false);
			ec_endhr.setDisabled(false);
			ec_endmin.setDisabled(false);
		}
		else
		{
			ec_stdate.setDisabled(true);
			ec_sthr.setDisabled(true);
			ec_startmin.setDisabled(true);

			ec_enddate.setDisabled(true);
			ec_endhr.setDisabled(true);
			ec_endmin.setDisabled(true);
		}
	},
	changeTimeLine : function(obj)
	{
		var descObj = Ext.getCmp('descriptor');
		var measObj = Ext.getCmp('ec_measure');
		var measureChangeTime = Ext.getCmp('ec_measureChangeTime');
		if( (obj.id == 'ec_timeline') && (obj.value == 'Any') )
		{
			Ext.getCmp('ec_stdate').setValue(null);
			Ext.getCmp('ec_sthr').setValue(null);
			Ext.getCmp('ec_startmin').setValue(null);
			Ext.getCmp('ec_enddate').setValue(null);
			Ext.getCmp('ec_endhr').setValue(null);
			Ext.getCmp('ec_endmin').setValue(null);
			
			Ext.getCmp('ec_stdate').setDisabled(false);
			Ext.getCmp('ec_sthr').setDisabled(false);
			Ext.getCmp('ec_startmin').setDisabled(false);
			Ext.getCmp('ec_enddate').setDisabled(false);
			Ext.getCmp('ec_endhr').setDisabled(false);
			Ext.getCmp('ec_endmin').setDisabled(false);	
			
			measObj.setValue(null);
			descObj.setValue(null);
			measureChangeTime.setValue(null);
			
			measureChangeTime.hide();
			measObj.hide();
			descObj.hide();
			
			Ext.getCmp("baseText").setValue("");
			Ext.getCmp("newText").setValue("");

			Ext.getCmp('measDiffFrame').update(null);
			
			Ext.getCmp('differencePanel').setVisible(false);
			Ext.getCmp('measDiffFrame').setVisible(false);
			
			Ext.getCmp("submit").setDisabled(true);
		}
		else if(
		(Ext.getCmp('ec_timeline').getValue() == 'Any' && Ext.getCmp('ec_stdate').getValue() != null && Ext.getCmp('ec_sthr').getValue() != null && Ext.getCmp('ec_startmin').getValue() != null && Ext.getCmp('ec_enddate').getValue() != null && Ext.getCmp('ec_endhr').getValue() != null && Ext.getCmp('ec_endmin').getValue() != null)
		)
		{
			Ext.getCmp("submit").setDisabled(false);
			
			measObj.setValue(null);
			descObj.setValue(null);
			measureChangeTime.setValue(null);
			
			measureChangeTime.hide();
			measObj.hide();
			descObj.hide();
			
			Ext.getCmp("baseText").setValue("");
			Ext.getCmp("newText").setValue("");

			Ext.getCmp('measDiffFrame').update(null);
			
			Ext.getCmp('differencePanel').setVisible(false);
			Ext.getCmp('measDiffFrame').setVisible(false);	
		}
		else if(
		!(Ext.getCmp('ec_timeline').getValue() == 'Any' && (obj.id == 'ec_stdate' || obj.id == 'ec_sthr' || obj.id == 'ec_startmin' || obj.id == 'ec_enddate' || obj.id == 'ec_endhr' || obj.id == 'ec_endmin'))
		)
		
		{
			var tempCriteria = 'Component';
			var tempUserOption = "";
			me.getMain().getComponent('differencePanel').hide();
			var hiddenFieldsStr = me.getHiddenFields(hiddenFieldsKeys);
			Ext.getCmp("submit").setDisabled(false);
			
			measObj.setValue(null);
			descObj.setValue(null);
			measureChangeTime.setValue(null);
			
			Ext.getCmp("baseText").setValue("");
			Ext.getCmp("newText").setValue("");
			
			measureChangeTime.hide();
			measObj.hide();
			descObj.hide();
			this.storeHiddenFields(timeLineCollection);
			var strRequestStart ='';
			me.getFormitems().submit({
				url: config.urls.initialURL,
				params : hiddenFieldsStr+'request_from=Timeline'+'&id='+id+ '&request_start='+strRequestStart,
				method: 'POST',
				success: function(form, action){
					publicJSON = Ext.decode(action.response.responseText);
					timeLineCollection = publicJSON.hiddenCollections;
					me.fillTimeLineView();
					delete publicJSON;
				},
				failure: function(form, action)
				{
					Ext.MessageBox.alert("Ajax Failed","Error in updating details");
				}
			});
		}	
	},
	
	getInformation : function(obj)
	{
		me = this;
		var comp = Ext.getCmp('ec_component');
		var info = Ext.getCmp('ec_test');
		var infoMeas = Ext.getCmp('ec_measure');
		var measureChangeTime = Ext.getCmp('ec_measureChangeTime');
		var changefrom = obj.getId();
		if (changefrom == "ec_comptype")
		{
			comp.setValue(publicJSON['compNames'][0].valueField);
		}
		var s_comptype = Ext.getCmp('ec_comptype').getValue();
		var s_compname = comp.getValue();
		hiddenFields = publicJSON['hiddenFields'];
		var s_oldcomptype = hiddenFields.old_comptype;
		var str_ec_timeline = me.getTimelineformescomparsion().getComponent('ec_timeline').getValue();
		if(str_ec_timeline == null || str_ec_timeline =="")
		{
			str_ec_timeline = "1 day";
		}
		var urlStr = "cmd=xmlCurrentConfig&needData=yes&ec_comptype="+s_comptype+"&ec_component="+s_compname+"&old_comptype="+s_oldcomptype;

		if (str_ec_timeline != "Any")
		{
			urlStr = urlStr + "&ec_timeline="+str_ec_timeline+"&ec_prevtimeline="+str_ec_timeline;
		}
		else
		{
			var ec_stdate_h = Ext.Date.dateFormat(Ext.getCmp('ec_stdate').getValue(), mgrDateFormat);
			var ec_enddate_h = Ext.Date.dateFormat(Ext.getCmp('ec_enddate').getValue(), mgrDateFormat);
			var ec_sthr_h = me.getTimelineformescomparsion().getComponent('ec_sthr').getValue();
			var ec_startmin_h = me.getTimelineformescomparsion().getComponent('ec_startmin').getValue();
			var ec_endhr_h = me.getTimelineformescomparsion().getComponent('ec_endhr').getValue();
			var ec_endmin_h = me.getTimelineformescomparsion().getComponent('ec_endmin').getValue();
			urlStr = urlStr + "&ec_timeline="+str_ec_timeline+"&ec_prevtimeline="+str_ec_timeline+"&ec_stdate_h="+ec_stdate_h+"&ec_sthr_h="+ec_sthr_h+"&ec_startmin_h="+ec_startmin_h+"&ec_enddate_h="+ec_enddate_h+"&ec_endhr_h="+ec_endhr_h+"&ec_endmin_h="+ec_endmin_h;
		}

		Ext.Ajax.request({
			url : config.urls.initialURL,
			params : urlStr,
			method : 'POST',
			async : false,
			success : function( response ){
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					info.getStore().removeAll();
					info.getStore().loadRawData(publicJSON['infoList']);
					info.setValue("-1");
					comp.getStore().removeAll();
					comp.getStore().loadRawData(publicJSON['compNames']);
					Ext.getCmp("submit").setDisabled(false);
					Ext.getCmp('descriptor').hide();
					infoMeas.hide();
					measureChangeTime.hide();
					me.getMain().getComponent('differencePanel').hide();
				}
			},
			failure: function(response)
			{
				Ext.MessageBox.alert("Ajax Failed","Error in updating details");
			}
		});
	},
	setInformation: function(obj)
	{
		var info = Ext.getCmp('ec_test');
		var descObj = Ext.getCmp('descriptor');
		var measObj = Ext.getCmp('ec_measure');
		var measureChangeTime = Ext.getCmp('ec_measureChangeTime');
		descObj.setValue(null);
		measObj.setValue(null);
		measureChangeTime.setValue(null);
		descObj.hide();
		measObj.hide();
		measureChangeTime.hide();
		var infoValue = obj.getValue();
		info.setValue(infoValue);
		Ext.getCmp("submit").setDisabled(false);
		me.getMain().getComponent('differencePanel').hide();
	},
	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+hiddenFields[key]+"&";
		}
		return hiddenQstr;
	},
	storeHiddenFields : function(fields)
	{
		var ec_timeline = me.getTimelineformescomparsion().getComponent('ec_timeline');
		var tmpField = "";
		var tmpArr = new Array();
		var hiddenProcessObj = Ext.getCmp('hiddenFieldsCt');
		hiddenProcessObj.removeAll();

		for (key in fields)
		{
			if (key == "ec_stdate_h" || key == "ec_enddate_h")
			{
				if (ec_timeline.getValue() == "Any")
				{
					var startdate = Ext.Date.dateFormat(Ext.getCmp('ec_stdate').getValue(), mgrDateFormat);
					var enddate = Ext.Date.dateFormat(Ext.getCmp('ec_enddate').getValue(), mgrDateFormat);
					if (key == "ec_stdate_h")
					{
						tmpField = {
							xtype : 'hiddenfield',
							name : key,
							value : startdate
						}
					}
					else
					{
						tmpField = {
							xtype : 'hiddenfield',
							name : key,
							value : enddate
						}
					}
				}
				else
				{
					tmpField = {
						xtype : 'hiddenfield',
						name : key,
						value : fields[key]
					}
				}
			}
			else
			{
				tmpField = {
					xtype : 'hiddenfield',
					name : key,
					value : fields[key]
				}
			}
			tmpArr.push(tmpField);
		}
		hiddenProcessObj.add(tmpArr);
		tmpArr = new Array();
	},
	getDetails : function(obj)
	{
		hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		var ec_userOption = Ext.getCmp('ec_userOption');
		var ec_criteria = Ext.getCmp('ec_criteria');
		var s_comptype = Ext.getCmp('ec_comptype');
		var s_compname = Ext.getCmp('ec_component');
		var s_info = Ext.getCmp('ec_test');

		me.getMain().getComponent('differencePanel').hide();
		s_comptype.setDisabled(true);
		s_compname.setDisabled(true);
		s_info.setDisabled(true);
		if (ec_criteria.getValue() == "Component")
		{
			ec_userOption.setValue("");
		}
		this.getFormitems().submit({
				url : "../servlet/com.eg.EcConfigurationServletNew",
				params : hiddenFields+"cmd=xmlCurrentConfig&needData=yes&request_from="+strRequestFrom+"&id="+id,
				method : 'POST',
				success : function(form, action){
					publicJSON = Ext.decode(action.response.responseText);
					hiddenFieldsKeys = publicJSON.hiddenFields;
					ec_criteria.getStore().loadRawData(publicJSON.viewByList);
					ec_criteria.setValue(publicJSON.selectedEcOpt);
					if (publicJSON.selectedEcOpt != 'Component')
					{
						ec_userOption.getStore().loadRawData(publicJSON.specViewByList);
						ec_userOption.setValue(publicJSON.selectedUserOptionText);
						ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
						ec_userOption.show();
					}
					else
					{
						ec_userOption.hide();
					}
					s_comptype.getStore().loadRawData(publicJSON['compTypes']);
					s_comptype.setValue(publicJSON['compTypes'][0].valueField);
					s_compname.getStore().loadRawData(publicJSON['compNames']);
					s_compname.setValue(publicJSON['compNames'][0].valueField);
					s_info.getStore().loadRawData(publicJSON['infoList']);
					delete publicJSON;
					s_comptype.setDisabled(false);
					s_compname.setDisabled(false);
					s_info.setDisabled(false);
					s_info.setValue("-1");
					Ext.getCmp("submit").setDisabled(false);
					Ext.getCmp("descriptor").hide();
					Ext.getCmp("ec_measure").hide();
					Ext.getCmp("ec_measureChangeTime").hide();
					
					
				},
				failure: function(form, action)
				{
					Ext.MessageBox.alert("Ajax Failed","Error in updating details");
				}
			});
	},
	validateData: function()
	{
		var s_comptype = Ext.getCmp('ec_comptype').getValue();
		var s_compname = Ext.getCmp('ec_component').getValue();
		var s_info = Ext.getCmp('ec_test').getValue();
		var s_meas = Ext.getCmp('ec_measure').getValue();
		var measureChangeTime = Ext.getCmp('ec_measureChangeTime').getValue();
		
		var s_descriptor = Ext.getCmp('descriptor');
		
		if(s_compname == null || s_compname == "" || s_compname == '-1')
		{
			Ext.Msg.alert(config.title.mainPageTitle,config.msgs.errorCompName);
			return false;
		}
		else if(s_info == null || s_info == "" || s_info == '-1')
		{
			Ext.Msg.alert(config.title.mainPageTitle,config.msgs.alertInfoMsg);
			return false;
		}
		else
		{
			return true;
		}
		
	},
	showDetails : function(from)
	{
		req_from = from;
		Ext.getCmp('selectionDetails').hide();
		if(Ext.getCmp('difftoolbar') != null)
		{
			Ext.getCmp('difftoolbar').hide();			
		}
		if(from == "changeconfig")
		{
			var url = "../servlet/com.eg.EcConfigurationServletNew";

			var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			this.storeHiddenFields(timeLineCollection);

			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
			myMask.show();

			var newQryStr = queryString.replace("cmd=xmlCurrentConfig&","cmd=XmlMeasureUsingJs&");

			this.getFormitems().submit({
				url : url,
				params : newQryStr+"&needData=yes",
				method : 'POST',
				success : function(form, action) {
					publicJSON = Ext.decode(action.response.responseText);
					var hasSelectionDetails = publicJSON['hasSelectionDetails'];
					Ext.getCmp('differencePanel').setVisible(true);
					Ext.getCmp('measDiffFrame').setVisible(true);
					if (hasSelectionDetails == true)
					{
						Ext.getCmp('formitems').collapse();
						var isDecriptorBased = publicJSON['isDecriptorBased'];
						var descriptorObj = Ext.getCmp('descriptor');
						var infoMeas = Ext.getCmp('ec_measure');
						var measureChangeTime = Ext.getCmp('ec_measureChangeTime');
						var descAndMeasArr = publicJSON['descAndMeasArrL1'];
						var descWithMeasArr = publicJSON['descAndMeasArrL2'];
						var selectedDscrAndMsurAndChngTmObj = publicJSON['selectedDscrAndMsurAndChngTmObj'];
						var dscrMsrsListAndChngTm = publicJSON['dscrMsrsListAndChngTm'];	
						if(isDecriptorBased)
						{
							var descList = publicJSON['descList'];
							var selectedDescriptor = publicJSON['selectedDescriptor'];
							var selectedMeasure = publicJSON['selectedMeasure'];
							var selectedMeasureTime = publicJSON['selectedMeasureTime'];
							descriptorObj.show()
							descriptorObj.getStore().removeAll();
							descriptorObj.getStore().loadRawData(descList);
							
							if (typeof(selectedDescriptor) != "undefined")
							{
								descriptorObj.setValue(selectedDescriptor);
							}
							else
							{
								descriptorObj.setValue(descList[0].valueField);
							}
							var descValue = descriptorObj.getValue();
							
							var measList = descWithMeasArr[descValue];
							infoMeas.show();
							infoMeas.getStore().removeAll();
							infoMeas.getStore().loadRawData(measList);

							var measVal = measList[0].valueField;
							
							if (typeof(selectedMeasure) != "undefined")
							{
								measVal = selectedMeasure;
								infoMeas.setValue(selectedMeasure);
							}
							else
							{
								infoMeas.setValue(measVal);
							}
							var measureChageList = dscrMsrsListAndChngTm[descValue][measVal];
							measureChangeTime.show();
							measureChangeTime.getStore().removeAll();
							measureChangeTime.getStore().loadRawData(measureChageList);
							
							var measureValues;
							if ( (typeof(selectedMeasureTime) != "undefined") )
							{
								measureChangeTime.setValue(selectedMeasureTime);
								measureValues = selectedDscrAndMsurAndChngTmObj[descValue][measVal][selectedMeasureTime];
							}
							else
							{
								var measChangeVal = measureChageList[0].valueField;
								measureChangeTime.setValue(measChangeVal);
								measureValues = descAndMeasArr[descValue][measVal][measChangeVal];
							}
							
							me.showMeasDifference(measureValues);					
						}
						else
						{
							var selectedMeasure = publicJSON['selectedMeasure'];
							var selectedMeasureTime = publicJSON['selectedMeasureTime'];

							descriptorObj.hide();
							var measList = descWithMeasArr["+"];
							infoMeas.show();
							infoMeas.getStore().removeAll();
							infoMeas.getStore().loadRawData(measList);

							var measVal = measList[0].valueField;
							
							if (typeof(selectedMeasure) != "undefined")
							{
								measVal = selectedMeasure;
								infoMeas.setValue(selectedMeasure);
							}
							else
							{
								infoMeas.setValue(measVal);
							}
							var measureChageList = dscrMsrsListAndChngTm["+"][measVal];
							measureChangeTime.show();
							measureChangeTime.getStore().removeAll();
							measureChangeTime.getStore().loadRawData(measureChageList);
							
							var measureValues;
							if ( (typeof(selectedMeasureTime) != "undefined") )
							{
								measureChangeTime.setValue(selectedMeasureTime);
								measureValues = selectedDscrAndMsurAndChngTmObj["+"][measVal][selectedMeasureTime];
							}
							else
							{
								var measChangeVal = measureChageList[0].valueField;
								measureChangeTime.setValue(measChangeVal);
								measureValues = descAndMeasArr["+"][measVal][measChangeVal];
							}
							
							me.showMeasDifference(measureValues);		
							
						}
					}
					else
					{
						Ext.getCmp('measDiffFrame').update(publicJSON['tableHtmlData']);
						Ext.getCmp('diffHeader').hide();
						Ext.getCmp('justDiff').hide();
						Ext.getCmp('showAll').hide();
						Ext.getCmp('prevDiff').hide();
						Ext.getCmp('nextDiff').hide();
						Ext.getCmp('clorCode').hide();
					}
					//end
					myMask.hide();
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
					Ext.MessageBox.alert("Ajax Failed","Error in updating details");
				}
			});
		}
		else
		{
			var url = "../servlet/com.eg.EcConfigurationServletNew";
			var thisForm = this.getFormitems().getForm();

			var isValidateflag = me.validateData();
			
			if (isValidateflag)
			{
				var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
				this.storeHiddenFields(timeLineCollection);

				var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
				myMask.show();
				
				this.getFormitems().submit({
					url : url,
					params : "cmd=XmlMeasureUsingJs&needData=yes&"+hiddenFields,
					method : 'POST',
					success : function(form, action) {
						publicJSON = Ext.decode(action.response.responseText);
						var hasSelectionDetails = publicJSON['hasSelectionDetails'];
						Ext.getCmp('differencePanel').setVisible(true);
						Ext.getCmp('measDiffFrame').setVisible(true);
						
						if (hasSelectionDetails == true)
						{
							Ext.getCmp('formitems').collapse();
							var isDecriptorBased = publicJSON['isDecriptorBased'];
							var descriptorObj = Ext.getCmp('descriptor');
							var infoMeas = Ext.getCmp('ec_measure');
							var measureChangeTime = Ext.getCmp('ec_measureChangeTime');
							var descAndMeasArr = publicJSON['descAndMeasArrL1'];
							var descWithMeasArr = publicJSON['descAndMeasArrL2'];
							var selectedDscrAndMsurAndChngTmObj = publicJSON['selectedDscrAndMsurAndChngTmObj'];
							var dscrMsrsListAndChngTm = publicJSON['dscrMsrsListAndChngTm'];
							if(isDecriptorBased)
							{
								var descList = publicJSON['descList'];
								var selectedDescriptor = publicJSON['selectedDescriptor'];
								var selectedMeasure = publicJSON['selectedMeasure'];
								var selectedMeasureTime = publicJSON['selectedMeasureTime'];
								
								descriptorObj.show()
								descriptorObj.getStore().removeAll();
								descriptorObj.getStore().loadRawData(descList);
								
								if (typeof(selectedDescriptor) != "undefined")
								{
									descriptorObj.setValue(selectedDescriptor);
								}
								else
								{
									descriptorObj.setValue(descList[0].valueField);
								}
								var descValue = descriptorObj.getValue();
								
								var measList = descWithMeasArr[descValue];
								infoMeas.show();
								infoMeas.getStore().removeAll();
								infoMeas.getStore().loadRawData(measList);

								var measVal = measList[0].valueField;
								
								if (typeof(selectedMeasure) != "undefined")
								{
									measVal = selectedMeasure;
									infoMeas.setValue(selectedMeasure);
								}
								else
								{
									infoMeas.setValue(measVal);
								}
								var measureChageList = dscrMsrsListAndChngTm[descValue][measVal];
								measureChangeTime.show();
								measureChangeTime.getStore().removeAll();
								measureChangeTime.getStore().loadRawData(measureChageList);
								var measChangeVal = measureChageList[0].valueField;
								measureChangeTime.setValue(measChangeVal);
								var measureValues;
								
								if ( (typeof(selectedMeasureTime) != "undefined") )
								{
									measureChangeTime.setValue(null);
									measChangeVal = selectedMeasureTime ;
									measureChangeTime.setValue(selectedMeasureTime);
								}
								
								var measureChangeDetails = descAndMeasArr[descValue][measVal];
								for(var i = 0; i < measureChangeDetails.length; i++)
								{
									measureValues = measureChangeDetails[i][measChangeVal];
									if(measureValues != null)
									{
										break;
									}
								}
								me.showMeasDifference(measureValues);
							}
							else
							{
								descriptorObj.hide();
								var measList = descWithMeasArr["+"];
								var selectedDescriptor = publicJSON['selectedDescriptor'];
								var selectedMeasure = publicJSON['selectedMeasure'];
								var selectedMeasureTime = publicJSON['selectedMeasureTime'];
								var measVal = measList[0].valueField;
								infoMeas.show();
								infoMeas.getStore().removeAll();
								infoMeas.getStore().loadRawData(measList);
								
								if (typeof(selectedMeasure) != "undefined")
								{
									measVal = selectedMeasure;
									infoMeas.setValue(selectedMeasure);
								}
								else
								{
									infoMeas.setValue(measVal);
								}
								var measureChageList = dscrMsrsListAndChngTm["+"][measVal];
								measureChangeTime.show();
								measureChangeTime.getStore().removeAll();
								measureChangeTime.getStore().loadRawData(measureChageList);
								
								var measureValues;
								if ( (typeof(selectedMeasureTime) != "undefined") )
								{
									measureChangeTime.setValue(selectedMeasureTime);
								}
								else
								{
									var measChangeVal = measureChageList[0].valueField;
									measureChangeTime.setValue(measChangeVal);
									var measureChangeDetails = descAndMeasArr["+"][measVal];
									for(var i = 0; i < measureChangeDetails.length; i++)
									{
										measureValues = measureChangeDetails[i][measChangeVal];
										if(measureValues != null)
										{
											break;
										}
									}
								}
								me.showMeasDifference(measureValues);
							}
						}
						else
						{
							Ext.getCmp('measDiffFrame').update(publicJSON['tableHtmlData']);
							Ext.getCmp('diffHeader').hide();
							Ext.getCmp('justDiff').hide();
							Ext.getCmp('showAll').hide();
							Ext.getCmp('prevDiff').hide();
							Ext.getCmp('nextDiff').hide();
							Ext.getCmp('clorCode').hide();
						}
						//end
						myMask.hide();
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
						Ext.MessageBox.alert("Ajax Failed","Error in updating details");
					}
				});
			}
		}
	},
	getDescriptor: function(obj)
	{
		var descAndMeasArr = publicJSON['descAndMeasArrL1'];
		var descValue = obj.getValue();
		var measureChangeTime = Ext.getCmp('ec_measureChangeTime');		
		var descWithMeasArr = publicJSON['descAndMeasArrL2'];
		var measList = descWithMeasArr[descValue];
		var infoMeas = Ext.getCmp('ec_measure');
		infoMeas.show();
		infoMeas.getStore().removeAll();
		infoMeas.getStore().loadRawData(measList);
		var measVal = measList[0].valueField;
		var dscrMsrsListAndChngTm = publicJSON['dscrMsrsListAndChngTm'];
		var selectedDscrAndMsurAndChngTmObj = publicJSON['selectedDscrAndMsurAndChngTmObj'];
		var measuerChageTimeList = dscrMsrsListAndChngTm[descValue][measVal];
		measureChangeTime.show();
		measureChangeTime.getStore().removeAll();
		measureChangeTime.getStore().loadRawData(measuerChageTimeList);
		var measChangeTimeVal = measuerChageTimeList[0].valueField;
		
		if(measList.length == 1)
		{
			infoMeas.setValue(measVal);
			measureChangeTime.setValue(measChangeTimeVal);
			var measureChangeDetails = descAndMeasArr[descValue][measVal];
			var measureValues;
			for(var i = 0; i < measureChangeDetails.length; i++)
			{
				measureValues = measureChangeDetails[i][measChangeTimeVal];
				if(measureValues != null)
				{
					break;
				}
			}
			me.showMeasDifference(measureValues);
			Ext.getCmp("submit").setDisabled(true);
		}
		else
		{
			infoMeas.setValue(null);
			infoMeas.emptyText = "Select Measure";
			infoMeas.applyEmptyText();
			measureChangeTime.setValue(null);
			measureChangeTime.emptyText = "Select Measure ChangeTime";	
			measureChangeTime.applyEmptyText();
			Ext.getCmp("submit").setDisabled(true);
			
			Ext.getCmp("baseText").setValue("");
			Ext.getCmp("newText").setValue("");
			Ext.getCmp('measDiffFrame').update(null);			
			Ext.getCmp('differencePanel').setVisible(false);
			Ext.getCmp('measDiffFrame').setVisible(false);
		}	
	},
	getMeasureDiff: function(obj)
	{
		var isDecriptorBased = publicJSON['isDecriptorBased'];
		var descValue = Ext.getCmp('descriptor').getValue();
		var measVal = obj.getValue();
		var dscrMsrsListAndChngTm = publicJSON['dscrMsrsListAndChngTm'];
		var measuerChageTimeList = "";
		if (isDecriptorBased)
		{
			measuerChageTimeList = dscrMsrsListAndChngTm[descValue][measVal];
		}
		else
		{
			measuerChageTimeList = dscrMsrsListAndChngTm["+"][measVal];
		}
		var measChangeTimeVal = measuerChageTimeList[0].valueField;
		var measureChangeTime = Ext.getCmp('ec_measureChangeTime');	
		measureChangeTime.show();
		measureChangeTime.getStore().removeAll();
		measureChangeTime.getStore().loadRawData(measuerChageTimeList);
		measureChangeTime.setValue(measChangeTimeVal);
		
		var descAndMeasArr = publicJSON['descAndMeasArrL1'];
		
		
		var measureValues = "";
		if (isDecriptorBased)
		{
			var measureChangeDetails = descAndMeasArr[descValue][measVal];
			for(var i = 0; i < measureChangeDetails.length; i++)
			{
				measureValues = measureChangeDetails[i][measChangeTimeVal];
				if(measureValues != null)
				{
					break;
				}
			}
		}
		else
		{
			var measureChangeDetails = descAndMeasArr["+"][measVal];
			for(var i = 0; i < measureChangeDetails.length; i++)
			{
				measureValues = measureChangeDetails[i][measChangeTimeVal];
				if(measureValues != null)
				{
					break;
				}
			}
		}
		Ext.getCmp('differencePanel').setVisible(true);
		Ext.getCmp('measDiffFrame').setVisible(true);
		Ext.getCmp("submit").setDisabled(false);
		me.showMeasDifference(measureValues);
		
		Ext.getCmp("submit").setDisabled(true);	
	},
	getMeasureChangeTime: function(obj)
	{
		var isDecriptorBased = publicJSON['isDecriptorBased'];
		var descValue = Ext.getCmp('descriptor').getValue();
		var measVal = Ext.getCmp('ec_measure').getValue();
		var measureChangeTimeValue = obj.getValue();
		var descAndMeasArr = publicJSON['descAndMeasArrL1'];
		var measureValues = "";
		if (isDecriptorBased)
		{
			var measureChangeDetails = descAndMeasArr[descValue][measVal];
			for(var i = 0; i < measureChangeDetails.length; i++)
			{
				measureValues = measureChangeDetails[i][measureChangeTimeValue];
				if(measureValues != null)
				{
					break;
				}
			}
		}
		else
		{
			var measureChangeDetails = descAndMeasArr["+"][measVal];
			for(var i = 0; i < measureChangeDetails.length; i++)
			{
				measureValues = measureChangeDetails[i][measureChangeTimeValue];
				if(measureValues != null)
				{
					break;
				}
			}
		}
		Ext.getCmp("submit").setDisabled(false);
		me.showMeasDifference(measureValues);
	},
	showMeasDifference: function(measureValues)
	{
		Ext.getCmp("submit").setDisabled(true);
		var indVal = measureValues.indexOf("~@@@~");
		var prevData = measureValues.substring(0,indVal);
		var presData = measureValues.substring(indVal+5);
		var isDiffThere = publicJSON['isDifferncePres'];

		if (isDiffThere)
		{
			if (req_from == "changeconfig")
			{
				var selectionDetailsArr = publicJSON['selectionDetailsArr'];
				Ext.getCmp("baseText").setValue(prevData);
				Ext.getCmp("newText").setValue(presData);
				diffUsingJS(0);
				if((prevData != '' && prevData != null)  && (presData!=null && presData!= null) )
				{
					Ext.getCmp('justDiff').show();
					Ext.getCmp('showAll').show();
					Ext.getCmp('prevDiff').show();
					Ext.getCmp('nextDiff').show();
					Ext.getCmp('clorCode').show();

					var tpl = new Ext.XTemplate(
						'<tpl exec="this.objectToArray(values)"></tpl>',
						'<tpl for="this.array">',
						'<span style="margin-right:20px;margin-bottom:5px;float:left;"><span class="font_bold">{key} : </span>{value}</span>',
						'</tpl>',
						{
							objectToArray: function(values){
								this.array = [];
								for(var key in values){
									var dataObj = values[key];
									for(var key2 in dataObj){
										this.array.push({key: key2, value: dataObj[key2]});
									}
								}
							}
						}
					);

					Ext.getCmp('selectionDetails').show();
					Ext.getCmp('selectioninnerpanel').tpl=tpl;
					Ext.getCmp('selectioninnerpanel').update(publicJSON.selectionDetailsArr);
				}
			}
			else
			{
				Ext.getCmp("baseText").setValue(prevData);
				Ext.getCmp("newText").setValue(presData);
				diffUsingJS(0);
				if((prevData != '' && prevData != null)  && (presData!='' && presData!= null) )
				{
					if(Ext.getCmp('difftoolbar') != null)
					{
						Ext.getCmp('difftoolbar').show();			
					}
					Ext.getCmp('diffHeader').show();
					Ext.getCmp('justDiff').show();
					Ext.getCmp('showAll').show();
					Ext.getCmp('prevDiff').show();
					Ext.getCmp('nextDiff').show();
					Ext.getCmp('clorCode').show();
				}
			}
		}
		else
		{
			Ext.getCmp('measDiffFrame').update(publicJSON['tableHtmlData']);
			Ext.getCmp('diffHeader').hide();
			Ext.getCmp('justDiff').hide();
			Ext.getCmp('showAll').hide();
			Ext.getCmp('prevDiff').hide();
			Ext.getCmp('nextDiff').hide();
			Ext.getCmp('clorCode').hide();
		}
	},
	showOnlyDiffData: function()
	{
		document.getElementById("prevDiffIndex").value='';
		diffUsingJS(0);
		var divId = document.getElementById("diffoutput");
		var rows = divId.getElementsByTagName('tr');
		if(rows != null)
		{
			for (var j = 1; j <rows.length; j+=1)
			{
				rows[j].style.display = 'none';
			}
		}
		var x = divId.getElementsByClassName("change");
		if(x != null)
		{
			for(var i=0;i<x.length;i++)
			{
				if(x[i].style.display = 'none')
				{
					x[i].style.display = '';
				}
			}
		}

		Ext.getCmp('measDiffFrame').update(document.getElementById('diffoutput').innerHTML);
		Ext.getCmp('showAll').enable();
		Ext.getCmp('showAll').setIconCls("iconConfigCompareSame");
		Ext.getCmp("justDiff").disable();
		Ext.getCmp("justDiff").setIconCls("iconConfigCompareDiffDisabled");
	},
	showAllData:function()
	{
		document.getElementById("prevDiffIndex").value='';
		diffUsingJS(0);
		Ext.getCmp('showAll').disable();
		Ext.getCmp('showAll').setIconCls("iconConfigCompareSameDisabled");
		Ext.getCmp("justDiff").enable();
		Ext.getCmp("justDiff").setIconCls("iconConfigCompareDiff");
		
	},
	nextDiff : function()
	{
		findingNext();
	},
	previousDiff : function()
	{
		findingPrev();
	},

	goBack : function()
	{
		var newQryStr = queryString.replace("cmd=xmlCurrentConfig","");
		//var newQryStr1 = newQryStr.replace("&ec_rtype=","");

		var arrSpiltUp = newQryStr.split("&");
		var reqQryString = "";

		for (var i = 0; i < arrSpiltUp.length; i++)
		{
			var keyValPair = arrSpiltUp[i];
			var keyValSplitUp = keyValPair.split("=");
			var key = keyValSplitUp[0];
			var value = keyValSplitUp[1];
			if (!Ext.isEmpty(key))
			{
				if(key == 'ec_rtype')
				{
					continue;
				}
				if(key == 'request_from')
				{
					value = "MeasCompPage";
				}
				if (key == 'ec_test' || key == 'descriptor' || key == 'ec_measureChangeTime' || key == "ec_measure")
				{
					value = "";
				}
				if( key == 'cmd')
				{
					value = "";
				}
				if(key == 'ec_option2' || key == 'ec_component')
				{
					value = encodeURIComponent(value);
				}
				reqQryString += "&"+key+"="+value;
			}
		}
		reqQryString = reqQryString.replace("&ec_test=","");
		reqQryString = reqQryString.replace("&changeConfigSelTest=","&ec_test=");
		me.getFormitems().submit({
			url : "/final/servlet/com.eg.EcConfigurationServletNew",
			params : reqQryString+"&ec_rtype=Change",
			standardSubmit : true,
			method: 'POST'
		});
	}
});

	function diffUsingJS(viewType)
	{
		document.getElementById("prevDiffIndex").value = ''; 
		var baseText = Ext.getCmp("baseText").getValue();
		var newTextValue = Ext.getCmp("newText").getValue();
		base = difflib.stringAsLines(baseText),
		newtxt = difflib.stringAsLines(newTextValue),
		sm = new difflib.SequenceMatcher(base, newtxt),
		opcodes = sm.get_opcodes(),
		contextSize = Ext.getCmp("contextSize").getValue();
		contextSize = contextSize || null;
		var diffoutputdiv = document.getElementById('diffoutput')
		diffoutputdiv.innerHTML = "";
		Ext.getCmp("diffHeader").show();
		//XML validate begin
		var flag = false;
		var validationResults = "<table class='diff'><tbody><tr>";
		if(baseText == null || baseText == 'null' || baseText.length == 0)
		{
			validationResults+="<td><strong><span style='color:#F6262D;'>BASE TEXT doesnot contains well-formed xml data.</span></strong></td>";
			flag = true;
		}
		else
		{
			validationResults+="<td style='color:green'>BASE TEXT contains well-formed xml data.</td>";
		}

		if(newTextValue == null || newTextValue == 'null' || newTextValue.length == 0)
		{
			validationResults+="<td><strong><span style='color:#F6262D;'>NEW TEXT doesnot contains well-formed xml data</span></strong></td>";
			flag = true;
		}
		else
		{
			validationResults+="<td style='color:#26F683'>NEW TEXT contains well-formed xml data.</td>";
		}
		validationResults+='</tr></tbody></table>';
		if(flag)
		{
			diffoutputdiv.innerHTML = validationResults;
			Ext.getCmp('justDiff').hide();
			Ext.getCmp('showAll').hide();
			Ext.getCmp('prevDiff').hide();
			Ext.getCmp('nextDiff').hide();
			Ext.getCmp('clorCode').hide();
			Ext.getCmp('measDiffFrame').update(document.getElementById('diffoutput').innerHTML);
			return false;
		}
		//end

		diffoutputdiv.appendChild(diffview.buildView({
			baseTextLines: base,
			newTextLines: newtxt,
			opcodes: opcodes,
			baseTextName: "",
			newTextName: "",
			contextSize: contextSize,
			viewType: viewType,
			requestFrom: 'MeasComparisonPage'
		}));

		Ext.getCmp('measDiffFrame').update(document.getElementById('diffoutput').innerHTML);

		enableAndDisableButton();

		Ext.getCmp('clorCode').update('<table class="colorCodediff" width="100%" height="20px"><tr><td class="xmlComparisonReplace" nowrap width="25%" align="center">Difference ('+replaceCount+','+replaceCount+')</td><td class="xmlComparisonEmpty" nowrap width="25%" align="center">Empty ('+insertCount+','+deleteCount+')</td><td class="xmlComparisonInsertHd" nowrap width="25%" align="center">Insert (0,'+insertCount+')</td><td class="xmlComparisonDeleteHd" nowrap width="25%" align="center">Delete ('+deleteCount+',0)</td></tr></table>');
	}

	
	function showDiff(prevData,presData)
	{
		var urlStr = "../config/XmlComparison/data/ecShowDiff.jsp";
		Ext.Ajax.request({
			url : urlStr,
			standardSubmit : true,
			method: 'POST',
			params : {
				'previousValue' : prevData,
				'presentValue' : presData,
			},
			success : function(response)
			{
				var publicJSON = Ext.decode(response.responseText);
				var tableHtmlData = publicJSON['tableHtmlData'];

				var moreDetailsWin = Ext.create('Ext.window.Window',{
					alias:'widget.showLineDiff',
					title : "SHOW DIFFERENCE",
					id:'diffWindow',
					modal : true,
					resizable : false,
					constrain : true,
					closeAction: 'destory',
					doClose: function() {
						this.destroy();
					},
					width: 600,
					height: 450,
					padding:'5 10 10 10',
					scroll : true,
					autoScroll : true,
					items : [{
						xtype : "container",
						html : tableHtmlData
					}]
				});
				moreDetailsWin.show();
			}
		});
	}

	function findingNext()
	{
		
		var divId = document.getElementById("diffoutput").innerHTML=''; 
		var y = document.getElementsByClassName("change");
		var value = document.getElementById("prevDiffIndex").value;
		var rowIndex = 0;
		if ( value!=null && value.length>0 )
		{
			var prevIndex = parseInt(value)
			$(y[prevIndex]).find("td").removeClass('xmlComparisonHighlight');
			rowIndex = parseInt(value)+1;
		}
		y[rowIndex].scrollIntoView(false);
		var firstTdClass = $(y[rowIndex]).find("td:first").attr('class');
		var secondTdClass = $(y[rowIndex]).find("td:last").attr('class');
		$(y[rowIndex]).find("td").addClass('xmlComparisonHighlight');
		
		if(y.length !== rowIndex )
		{
			document.getElementById("prevDiffIndex").value = rowIndex;
		}
		
		enableAndDisableButton();
	}

	function findingPrev()
	{
		var divDatainner = document.getElementById("diffoutput").innerHTML;
		var divId = document.getElementById("diffoutput").innerHTML=''; 
		var y = document.getElementsByClassName("change");
		var value = document.getElementById("prevDiffIndex").value;
		var rowIndex = 0;
		if(value!=null && value.length>0 )
		{
			var prevIndex = parseInt(value)
			$(y[prevIndex]).find("td").removeClass('xmlComparisonHighlight');
			rowIndex = parseInt(value)-1;
		}
		y[rowIndex].scrollIntoView(false);
		var firstTdClass = $(y[rowIndex]).find("td:first").attr('class');
		var secondTdClass = $(y[rowIndex]).find("td:last").attr('class');
		$(y[rowIndex]).find("td").addClass('xmlComparisonHighlight');
		
		if(rowIndex>=0 )
		{
			document.getElementById("prevDiffIndex").value = rowIndex;
		}
		enableAndDisableButton();
		
	}

	function enableAndDisableButton()
	{
		var curIndex = document.getElementById("prevDiffIndex").value;
		Ext.getCmp('prevDiff').disable();
		Ext.getCmp('prevDiff').setIconCls("iconConfigComparePrevDisabled");
		Ext.getCmp("nextDiff").enable();
		Ext.getCmp("nextDiff").setIconCls("iconConfigCompareNext");
		
		var x = document.getElementsByClassName("change");
		if(x == null || x.length == 0)
		{
			Ext.getCmp('prevDiff').disable();
			Ext.getCmp('prevDiff').setIconCls("iconConfigComparePrevDisabled");
			Ext.getCmp("nextDiff").disable();
			Ext.getCmp("nextDiff").setIconCls("iconConfigCompareNextDisabled");
			
		}
		if(curIndex!=null && curIndex.length>0)
		{
			curIndex = parseInt(curIndex);
			if(curIndex>0)
			{
				Ext.getCmp('prevDiff').enable();
				Ext.getCmp('prevDiff').setIconCls("iconConfigComparePrev");
				
			}
			
			if(curIndex == (x.length)-1)
			{
				Ext.getCmp("nextDiff").disable();
				Ext.getCmp("nextDiff").setIconCls("iconConfigCompareNextDisabled");
			}
		}
		
	}