Ext.define('MeasureComparison.view.FormItems', {
	extend: 'Ext.form.Panel',
	alias: 'widget.formitems',
	id: 'formitems',
	cls:'formOuter accordionArrow',
	layout: 'column',
	height: 160,
	collapsible: true,

	requires: [
		'utilities.ScrollCombo',
		'configutilities.TimeLineForMesComparsion'
	],

	defaults:{
		labelAlign:'top',
		labelSeparator:'',
		width: 200
	},

	items : [
		{
			xtype : 'combobox',
			fieldLabel :config.title.viewByTitle,
			id : 'ec_criteria',
			cls: 'dropdown',
			width: 100,
			name : 'ec_criteria',
			itemId : 'ec_criteria',
			store : new Ext.data.Store(
			{
				fields: ['displayField','valueField'],
				data: []
			}),
			queryMode : 'local',
			displayField :'displayField',
			valueField : 'valueField',
			editable : false,
			margin: '10 10 10 10'
		},
		{
			xtype : 'scrollcombo',
			cls: 'dropdown',
			id : 'ec_userOption',
			name : 'ec_userOption',
			itemId : 'ec_userOption',
			store : new Ext.data.Store(
			{
				fields: ['displayField','valueField'],
				data: []
			}),
			queryMode : 'local',
			displayField :'displayField',
			valueField : 'valueField',
			hidden : true,
			defaultListConfig: {
				minWidth: 250,
				maxHeight: 300
			},
			width: 150,
			margin: '10 10 10 10'
		},
		{
			xtype : 'scrollcombo',
			cls: 'dropdown',
			fieldLabel : config.title.compTypeTitle,
			id : 'ec_comptype',
			itemId : 'ec_comptype',
			name : 'ec_comptype',
			store :  new Ext.data.Store(
			{
				fields: ['displayField','valueField'],
				data: []
			}),
			queryMode : 'local',
			displayField :'displayField',
			valueField : 'valueField',
			defaultListConfig: {
				minWidth: 250,
				maxHeight: 300
			},
			margin: '10 10 10 10'
		},
		{
			xtype : 'scrollcombo',
			cls: 'dropdown',
			fieldLabel :config.title.componentTitle,
			id : 'ec_component',
			itemId : 'ec_component',
			name : 'ec_component',
			store :  new Ext.data.Store(
			{
				fields: ['displayField','valueField'],
				data: []
			}),
			queryMode : 'local',
			displayField :'displayField',
			valueField : 'valueField',
			defaultListConfig: {
				minWidth: 250,
				maxHeight: 300
			},
			margin: '10 10 10 10'
		},
		{
			xtype : 'scrollcombo',
			cls: 'dropdown',
			fieldLabel : config.title.informationTitle,
			id : 'ec_test',
			name : 'ec_test',
			store :  new Ext.data.Store(
			{
				fields: ['displayField','valueField'],
				data: []
			}),
			queryMode : 'local',
			displayField :'displayField',
			valueField : 'valueField',
			defaultListConfig: {
				minWidth: 250,
				maxHeight: 300
			},
			margin: '10 10 10 10'
		},
		{
			xtype : 'timelineformescomparsion',
			id : 'timeline',
			width: 550,
			margin: '10 0 10 10'
		},
		{
			xtype: 'scrollcombo',
			fieldLabel: config.title.descriptor,
			cls: 'dropdown',
			id:'descriptor',
			name:'descriptor',
			displayField:'displayField',
			valueField:'valueField',
			queryMode: 'local',
			hidden: true,
			store:new Ext.data.Store({
				fields: ['displayField','valueField'],
				data: []
			}),
			width: 150,
			defaultListConfig: {
				minWidth: 250,
				maxHeight: 300
			},
			margin: '10 10 10 10'
		},
		{
			xtype : 'scrollcombo',
			cls: 'dropdown',
			fieldLabel :config.title.measuresTitle,
			id : 'ec_measure',
			name : 'ec_measure',
			hidden: true,
			store :  new Ext.data.Store(
			{
				fields: ['displayField','valueField'],
				data: []
			}),
			queryMode : 'local',
			displayField :'displayField',
			valueField : 'valueField',
			width: 150,
			defaultListConfig: {
				minWidth: 250,
				maxHeight: 300
			},
			margin: '10 10 10 10'
		},
		{
			xtype : 'scrollcombo',
			cls: 'dropdown',
			fieldLabel :config.title.msrChngTimeTitle, 
			id : 'ec_measureChangeTime',
			name : 'ec_measureChangeTime',
			hidden: true,
			store :  new Ext.data.Store(
			{
				fields: ['displayField','valueField'],
				data: []
			}),
			queryMode : 'local',
			displayField :'displayField',
			valueField : 'valueField',
			width: 150,
			defaultListConfig: {
				minWidth: 250,
				maxHeight: 300
			},
			margin: '10 10 10 10'
		},
		{
			xtype : 'button',
			text : config.title.submitTitle,
			action : 'submit',
			id : 'submit',
			cls: 'button20',
			margin: '30 10 10 10',
			width: 65
		},
		{
			xtype : 'container',
			id : 'hiddenFieldsCt',
			height : 0,
			hidden : true
		},
		{
			xtype: 'textfield',
			name: 'contextSize',
			id: 'contextSize',
			hidden: true
		},
		{
			xtype: 'hiddenfield',
			id: 'baseText',
			name: 'baseText',
			value: ''
		},
		{
			xtype: 'hiddenfield',
			id: 'newText',
			name: 'newText',
			value: ''
		}
	],
	listeners:
	{
		afterrender:function(panel)
		{
			var headerObj = Ext.getCmp("formitems_header");
			headerObj.removeCls("x-panel-header-default");
		},

		collapse: function()
		{
			var titleStr = '';
			var selectedEcOpt = publicJSON.selectedEcOpt;
			var selectedCmpTypeDispName = publicJSON.selectedCmpTypeDispName;
			var selectedCmpType = publicJSON.selectedCmpType;
			var selectedCmpDispName = publicJSON.selectedCmpDispName;
			var selectedCmpName = publicJSON.selectedCmpName;
			var selectedUserOptionText = publicJSON.selectedUserOptionText;
			var fromDateAndTime = publicJSON.FromDateAndTime;
			var toDateAndTime = publicJSON.ToDateAndTime;

			if (selectedEcOpt != null &&  selectedEcOpt != "-1")
			{
				if (selectedEcOpt == "Component")
				{
					titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>';
				}
				else
				{
					if (selectedUserOptionText != null && selectedUserOptionText != "-1")
					{
						titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">'+selectedEcOpt+'</span> - <span class="formSelectionValue">'+selectedUserOptionText+'</span>';
					}
					else
					{
						titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>';
					}
				}

				if (selectedCmpType != null && selectedCmpType != "-1")
				{
					titleStr = titleStr+'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">Component Type</span> - <span class="formSelectionValue">'+selectedCmpTypeDispName+'</span>';
				}

				if (selectedCmpName != null && selectedCmpName != "-1")
				{
					titleStr = titleStr+'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">Component Name</span> - <span class="formSelectionValue">'+selectedCmpDispName+'</span>';
				}
				if (fromDateAndTime != null && toDateAndTime != null)
				{
					titleStr = titleStr+'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">From</span> - <span class="formSelectionValue">'+fromDateAndTime+'</span>'
					titleStr = titleStr+'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">To</span> - <span class="formSelectionValue">'+toDateAndTime+'</span>'
				}
			}
			Ext.getCmp("formitems").setTitle(titleStr);
		},
		expand: function()
		{
			Ext.getCmp("formitems").setTitle('');
		}
	}
});



