Ext.define('OsBoxInfo.controller.Main',{
	extend : 'Ext.app.Controller',
	views : [
		'Main',
		'FormItems',
		'ErrorContainer',
		'InfoGrid',
		'OsBoxInfoChart',
		'configutilities.Tools',
		'configutilities.PrintPreview',
		'configutilities.SendMail',
	],
	refs : [
		{
			selector : 'main',
			ref : 'main'
		},
		{
			selector : 'formitems', 
			ref : 'formitems'
		},
		{
			selector : 'infoGrid', 
			ref : 'infoGrid'
		},
		{
			selector : 'tools', 
			ref : 'tools'
		},
		{
			selector : 'osboxinfochart', 
			ref : 'osboxinfochart'
		},
		{
			selector : 'errorcontainer', 
			ref : 'errorcontainer'
		}
	],

	init : function()
	{
		thisCtrl = this;
		this.buildFieldData()
		this.control({
			'main' :{
				'afterrender' : this.afterMainRender
			},
			'formitems' :{
				'boxready' : this.loadChartCt
			},
			'formitems combobox[id="ec_criteria"]' :{
				'select' : this.getInformations
			},
			'formitems combobox[id="ec_userOption"]' :{
				'select' : this.getInformations
			},
			'formitems trigger[id="searchId"]' :{
				'keydown' : this.componentSearch
			},
			'formitems button[id="submit"]' :{
				'click' : this.componentSearch
			},
			'formitems combo[id="osName"]' :{
				'select' : this.hideChartContainer
			},
			'tools' :{
				'afterrender' : this.loadTools
			},
			'tools button[id="saveBtn"]' : {
				'click' : this.saveAsPDF
			},
			'tools button[id="printBtn"]' : {
				'click' : this.printData
			},
			'tools button[id="csvBtn"]' : {
				'click' : this.saveAsCSV
			},
			'tools button[id="mailBtn"]' : {
				'click' : this.sendMail
			},
			'tools button[id="scheduleBtn"]' : {
				'click' : this.setschedule
			},
			'main #backBtnMain': {
				'click': this.forwardRequestedURI
			}
		});
	},

	buildFieldData : function(){
		Ext.Ajax.request({
			url : config.urls.servletURL,
			params : queryString+"&needData=yes",
			method : 'POST',
			async : false,
			success : function( response ){
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					hiddenFieldsKeys = publicJSON['hiddenFields'];
					backOperation = publicJSON['backOperation'];
				}
			}
		});
	},

	afterMainRender : function()
	{
		me = this;
		if(strRequestFrom.toLowerCase() == "os" || strRequestFrom.toLowerCase() == "osversion")
		{
			Ext.getCmp('formitems').hide();
			Ext.getCmp('schSep').hide();
			Ext.getCmp('scheduleTool').hide();
			me.loadChartCt();
		}
		else
		{
			var ec_userOption = me.getFormitems().getComponent('infoCont').getComponent('ec_userOption');
			var ec_criteria = me.getFormitems().getComponent('infoCont').getComponent('ec_criteria');
			var osNameId = me.getFormitems().getComponent('infoCont').getComponent('osName');
			var searchId = me.getFormitems().getComponent('infoCont').getComponent('searchId');

			ec_criteria.getStore().loadRawData(publicJSON['viewByList']);
			ec_criteria.setValue(publicJSON.selectedEcOpt);

			if (publicJSON.selectedEcOpt != 'Component')
			{
				ec_userOption.getStore().loadRawData(publicJSON['specViewByList']);
				if(publicJSON.selectedUserOption != "" && publicJSON.selectedUserOption != undefined)
				{
					ec_userOption.setValue(publicJSON.selectedUserOption);
				}
				else
				{
					ec_userOption.setValue(publicJSON.specViewByList[0].valueField);
				}
				ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
				ec_userOption.show();
			}
			else
			{
				ec_userOption.hide();
			}
			if(publicJSON.searchValue != null && publicJSON.searchValue != undefined)
			{
				searchId.setValue(publicJSON.searchValue);
			}
			osNameId.getStore().loadRawData(publicJSON['osList']);
			if(publicJSON['selectedOsName'] != "" && publicJSON['selectedOsName'] != undefined)
			{
				osNameId.setValue(publicJSON['selectedOsName']);
			}
			else
			{
				osNameId.setValue(publicJSON['osList'][0].valueField);
			}
		}

		if(publicJSON.hasConfigDetails)
		{
			me.setToolsState(false,publicJSON['selectedOsName']);
		}
		else
		{
			me.setToolsState(true,publicJSON['selectedOsName']);
		}

		if (strRequestFrom != null && strRequestFrom == "saveSchedule")
		{
			Ext.getCmp('backBtnMain').show();
			Ext.getCmp('bkSeperator').show();
			Ext.getCmp('submit').setText('Save');
		}
		if((backOperation != null && backOperation.home != undefined && backOperation.home == "yes"))
		{
			Ext.getCmp('bkSeperator').show();
			Ext.getCmp('backBtnMain').show();
		}
		if((backOperation != null && backOperation.schedule != undefined && backOperation.schedule == "yes"))
		{
			Ext.getCmp('bkSeperator').show();
			Ext.getCmp('backBtnMain').show();
		}
	},


	loadChartCt : function()
	{
		if (strRequestFrom != null && strRequestFrom != "saveSchedule")
		{
			var hiddenPanelTitle = publicJSON.containerTitle;
			if(hiddenPanelTitle != "" && hiddenPanelTitle != null && hiddenPanelTitle != undefined)
			{
				thisCtrl.getMain().getComponent('hiddenPanel').setTitle(publicJSON.containerTitle);
			}
			else
			{
				thisCtrl.getMain().getComponent('hiddenPanel').setTitle("DISTRIBUTION OF SYSTEM");
			}
			if(publicJSON.chartData !="" && publicJSON.chartData != undefined)
			{
				thisCtrl.getOsboxinfochart().loadChart(publicJSON,thisCtrl);
			}

			if(publicJSON.versionAndSysArray != undefined && publicJSON.versionAndSysArray != "" && publicJSON.versionAndSysArray != null)
			{
				Ext.getCmp("formitems").collapse();
				me.getErrorcontainer().hide();
				thisCtrl.getMain().getComponent('hiddenPanel').show();
				thisCtrl.getMain().getComponent('hiddenPanel').getComponent('gridContainer').add({xtype:'infoGrid'});
				Ext.getCmp('infoGrid').getStore().loadRawData(publicJSON.versionAndSysArray);
			}
			else
			{
				Ext.getCmp('hiddenPanel').hide();
				me.getErrorcontainer().update("<table align='center' cellspacing='0' cellpadding='0' width='100%' border='0'><tr><td><table align='center' cellspacing='0' cellpadding='0' width='100%' border='0' style='table-layout:fixed'><tr><td colspan='7' align='center' valign='middle' height='300' class='eg_subhead'><img src='/final/config/images/spacer.gif' class='iconInformation'><div class='commonErrorMsgText' id='noCompAlrtDiv'>"+jsonData.errorText+"</div></table></td></tr></table>");
				me.getErrorcontainer().show();
			}
		}
	},


	getInformations : function(obj)
	{
		Ext.getCmp('hiddenPanel').hide();
		var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		var ec_userOption = me.getFormitems().getComponent('infoCont').getComponent('ec_userOption');
		var ec_criteria = me.getFormitems().getComponent('infoCont').getComponent('ec_criteria');
		var osNameId = me.getFormitems().getComponent('infoCont').getComponent('osName');
		var searchId = me.getFormitems().getComponent('infoCont').getComponent('searchId');

		osNameId.setDisabled(true);
		searchId.setDisabled(true);

		this.getFormitems().submit({
			url : config.urls.configServletURL,
			params :hiddenFields+"&cmd=OsInventory&needData=yes&request_from="+strRequestFrom+"&id="+id,
			method : 'POST',
			success : function(form, action){
				var publicJSON = Ext.decode(action.response.responseText);
				var from = obj.getId();
				hiddenFieldsKeys = publicJSON.hiddenFields;
				ec_criteria.getStore().loadRawData(publicJSON.viewByList);
				ec_criteria.setValue(publicJSON.selectedEcOpt);
				if (publicJSON.selectedEcOpt != 'Component')
				{
					ec_userOption.getStore().loadRawData(publicJSON.specViewByList);
					ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
					if(from == "ec_criteria")
					{
						ec_userOption.setValue(publicJSON['selectedUserOption']);
					}
					ec_userOption.show();
				}
				else
				{
					ec_userOption.hide();
				}
				osNameId.getStore().removeAll();
				osNameId.getStore().loadRawData(publicJSON['osList']);
				if (!Ext.isEmpty(publicJSON['selectedOsName']))
				{
					osNameId.setValue(publicJSON['selectedOsName']);
				}
				else
				{
					osNameId.setValue(publicJSON['osList'][0].valueField);
				}
				delete publicJSON;
				osNameId.setDisabled(false);
				searchId.setDisabled(false);
				me.setToolsState(true,publicJSON['selectedOsName']);
			},
			failure: function(form, action) 
			{
				Ext.MessageBox.alert("Ajax Failed","Error in updating details");
			}
		});
	},

	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+hiddenFields[key]+"&";
		}
		return hiddenQstr;
	},
	
	hideChartContainer : function()
	{
		Ext.getCmp('hiddenPanel').hide();
		me.setToolsState(true,publicJSON['selectedOsName']);
	},

	showSrchIcon : function()
	{
		Ext.get('MyTrigger_0').setStyle('display','none');
		Ext.get('MyTrigger_1').setStyle('display','block');
	},

	componentSearch : function()
	{
		var me = this;
		if (strRequestFrom != null && strRequestFrom == "saveSchedule")
		{
			me.setschedule();
		}
		else
		{
			var checkFlag = me.checkFormValidation();
			if (checkFlag == false)
			{
				return false;
			}
			//var hiddenFieldsKeys = publicJSON.hiddenFields;
			//var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
			var egTitleSearchStr = Ext.getCmp('searchId').getValue();
			var ec_criteria = Ext.getCmp('ec_criteria').getValue();
			var osName = Ext.getCmp('osName').getValue();
			var ec_userOption = Ext.getCmp('ec_userOption').getValue();

			if (egTitleSearchStr == "" || egTitleSearchStr.length == 0)
			{
				Ext.get('MyTrigger_0').setStyle('display','none');
				Ext.get('MyTrigger_1').setStyle('display','block');
			}
			else
			{
				Ext.get('MyTrigger_1').setStyle('display','none');
				Ext.get('MyTrigger_0').setStyle('display','block');
			}

			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
			myMask.show();

			this.getFormitems().submit({
				url: config.urls.servletURL,
				params :hiddenFields+ "&cmd=OSInventory&needData=yes&searchValue="+egTitleSearchStr+"&osName="+osName+"&ec_criteria="+ec_criteria+"&ec_userOption="+encodeURIComponent(ec_userOption)+"&isSubmit=true",
				method: 'POST',
				success: function(form,action)
				{
					var jsonData = Ext.decode(action.response.responseText);
					publicJSON = jsonData;
					//hiddenFieldsKeys = jsonData.hiddenFields;
					var title = jsonData['containerTitle'];
					myMask.hide();

					if (jsonData.errorText != null && jsonData.errorText != undefined)
					{
						Ext.getCmp('hiddenPanel').hide();
						me.getErrorcontainer().update("<table align='center' cellspacing='0' cellpadding='0' width='100%' border='0'><tr><td><table align='center' cellspacing='0' cellpadding='0' width='100%' border='0' style='table-layout:fixed'><tr><td colspan='7' align='center' valign='middle' height='300' class='eg_subhead'><img src='/final/config/images/spacer.gif' class='iconInformation'><div class='commonErrorMsgText' id='noCompAlrtDiv'>"+jsonData.errorText+"</div></table></td></tr></table>");
						me.getErrorcontainer().show();
						me.setToolsState(true,jsonData['selectedOsName']);
					}
					else
					{
						Ext.getCmp('formitems').collapse();
						Ext.getCmp('hiddenPanel').show();
						me.getErrorcontainer().hide();

						if(jsonData.chartData !="" && jsonData.chartData != undefined)
						{
							Ext.getCmp('hiddenPanel').setTitle(title);
							Ext.getCmp('chartPlaceHolder').show();
							me.getOsboxinfochart().loadChart(jsonData,me);
						}
						else
						{
							Ext.getCmp('hiddenPanel').setTitle("DISTRIBUTION OF SYSTEM");
							Ext.getCmp('chartPlaceHolder').hide();
						}
						Ext.getCmp('gridContainer').removeAll();
						Ext.getCmp('gridContainer').add({xtype:'infoGrid'});
						Ext.getCmp('infoGrid').getStore().loadRawData(jsonData.versionAndSysArray);

						if(jsonData.versionAndSysArray == "")
						{
							me.setToolsState(true,jsonData['selectedOsName']);
						}
						else
						{
							me.setToolsState(false,jsonData['selectedOsName']);
						}
					}
				},
				failure: function(form, action)
				{
					myMask.hide();
					Ext.MessageBox.alert("Ajax Failed","Error in updating details");
				}
			});
		}
	},

	loadTools : function()
	{
		thisCtrl.getTools().loadIcon(true,true,true,true,true,true);
	},


	saveAsPDF : function()
	{
		//var getSaveObj = Ext.widget('savepdf');
		//getSaveObj.savePDF(config.urls.pdfURL);
		downloadAsPDF(config.urls.pdfURL)
	},

	printData : function()
	{
		var printQueryStr = publicJSON.printQueryStr;
		Ext.widget('print',{title : config.title.mainPageTitle}).show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set({
			src: printQueryStr
		});
	},

	saveAsCSV : function()
	{
		me = this;
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var ec_userOption = "";
		if (ec_criteria != 'Component')
		{
			 ec_userOption = Ext.getCmp('ec_userOption').getValue();
		}
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
		var urlStr = '../servlet/com.eg.EcCSVController';
		me.getFormitems().submit({
			url: urlStr,
			params: 'ec_criteria='+ec_criteria+'&ec_userOption='+ec_userOption+'&'+hiddenFields,
			standardSubmit : true,
			method: 'POST'
		});
	},

	sendMail : function()
	{
		Ext.widget('sendmail').show();
	},


	setschedule : function()
	{
		var op = "schedule";
		var me = this;

		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var ec_userOption = Ext.getCmp('ec_userOption').getValue();
		var osName = Ext.getCmp('osName').getValue();
		var searching = Ext.getCmp('searchId').getValue();
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
		if (op == "schedule")
		{
			if (strRequestFrom != null && strRequestFrom == "saveSchedule")
			{
				var checkFlag = me.checkFormValidation();
				if (checkFlag == false)
				{
					return false;
				}
				me.getFormitems().submit({
					url: '/final/config/EcSaveScheduleNew.jsp',
					params :"id="+id+"&ec_criteria="+ec_criteria+"&ec_userOption="+ec_userOption+"&osSelect="+osName+"&"+hiddenFields+"&searching="+searching+"&submitClicked=true",
					standardSubmit : true,
					method: 'POST'
				});
			}
			else
			{
				var urlStr =  "/final/config/EcSaveScheduleNew.jsp?showWindow=yes&id="+id+"&request_from=OSInventory&ec_criteria="+ec_criteria+"&ec_userOption="+ec_userOption+"&osSelect="+osName+"&"+hiddenFields+"&searching="+searching+"&submitClicked=true&com.eg.CSRF_NONCE="+csrfToken;
				scheduleWindow(urlStr);
			}
		}
		else if (op =="favorite")
		{
			window.location.href = "/final/config/EcSaveFavorite.jsp";
		}
		else
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,".Illegal Access");
			return false;
		}
		//me.getFormitems().submit({
			//url: urlStr,
			//standardSubmit : true,
			//method: 'POST'
		//});
	},

	
	setToolsState : function(iconState,osName)
	{
		var saveObj =me.getTools().getComponent('saveTool');
		var printObj =me.getTools().getComponent('printTool');
		var mailObj =me.getTools().getComponent('mailTool');
		var csvObj =me.getTools().getComponent('csvTool');
		var scheduleToolObj = me.getTools().getComponent('scheduleTool');
		var combineBookletObj = me.getTools().getComponent('bookletTool');
		if (!Ext.isEmpty(saveObj)) {
			saveObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(printObj)) {
			printObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(mailObj)) {
			mailObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(csvObj)) {
			csvObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(scheduleToolObj) && osName != "-1") {
			scheduleToolObj.setDisabled(false);
		}
		else
		{
			scheduleToolObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(combineBookletObj)) {
			combineBookletObj.setDisabled(iconState);
		}

	},
	

	checkFormValidation : function()
	{
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var osName = Ext.getCmp('osName').getValue();
		var ec_userOption = Ext.getCmp('ec_userOption').getValue();
		var egTitleSearchStr = Ext.getCmp('searchId').getValue();

		var tempCriteria = "";
		var tempUserOption = "";

		if (ec_criteria != null && ec_criteria != undefined)
		{
			tempCriteria = ec_criteria;
		}
		if (ec_userOption != null && ec_userOption != undefined)
		{
			tempUserOption = ec_userOption;
		}
		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorZone);
					return false;
				}
				else if (tempCriteria == "Service")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorService);
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorSegment);
					return false;
				}
			}
		}
		if (ec_criteria != null && ec_criteria != undefined)
		{
			tempCriteria = ec_criteria;
		}
		if (ec_userOption != null && ec_userOption != undefined)
		{
			tempUserOption = ec_userOption;
		}

		if(osName == "-1")
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorOS);
			return false;
		}

		var sub = checkspecial(egTitleSearchStr,"`~!@#$%^&*()+={}[]|\\;\"\'<>,?\/");
		if(!sub)
		{
			Ext.getCmp('searchId').focus();
			Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.specialCharError);
			return false;
		}
	},


	forwardRequestedURI : function()
	{
		if ((strRequestFrom != null && strRequestFrom == "saveSchedule") || (backOperation != null && backOperation.schedule == "yes"))
		{
			var me = this;
			hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			me.getFormitems().submit({
				url: '/final/config/EcSaveScheduleNew.jsp',
				params : 'request_from='+strRequestFrom+'&id='+id+'&'+hiddenFields,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if((backOperation != null && backOperation.home != undefined && backOperation.home == "yes"))
		{
			var ec_criteria = backOperation.ec_criteria;
			var ec_userOption = backOperation.ec_userOption;
			window.location.href= '../servlet/com.eg.EcConfigurationServletNew?cmd=Home&ec_criteria='+ec_criteria+'&ec_userOption='+encodeURIComponent(ec_userOption);
		}
	}

});



function getSystemDetails(systemName)
{
	var criteria = Ext.getCmp('ec_criteria').getValue();
	var osNameValue = Ext.getCmp('osName').getValue();
	var userOption = Ext.getCmp('ec_userOption').getValue();
	var searchValue = me.getFormitems().getComponent('infoCont').getComponent('searchId').getValue();

	window.location.href = "../servlet/com.eg.EcConfigurationServletNew?request_from="+strRequestFrom+"&cmd=BoxView&searchValue="+searchValue+"&systemName=" + encodeURIComponent(systemName) + "&ec_criteria=" + criteria + "&ec_userOption=" + encodeURIComponent(userOption)+"&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken;
}

function doCloseWin()
{
	Ext.getCmp('scheduleWin').destroy();
}



