Ext.define('OsBoxInfo.view.InfoGrid', {
	extend : 'utilities.CustomGrid',
	alias : 'widget.infoGrid',
	cls:'gridSkin_expander',
	id:'infoGrid',
	store : new Ext.data.Store({
		fields:['title','SystemsWithVersion'],
		groupField: 'title',
		data : [],
		sortOnLoad : false // disables the default sorting of an extjs grid
	}),

	features: [{
		ftype: 'grouping',
		id : 'osWiseGrouping',
		groupHeaderTpl: [
			'{name:this.formatServerName}',
			{
				formatServerName: function(name) {
					var cType = name;
					return cType;
				}
			}
		],
		hideGroupedHeader: false,
		startCollapsed: false
	}],

	tools: [{
			xtype:'button',
			id :'tc',
			name :'tc',
			iconCls: 'iconCollapseAll',
			enableToggle : true,
			style: {
				background: 'none',
				border: '0px'
			},
			listeners:{
			'toggle':function(obj, pressed, eOpts){
				var thisGrid = Ext.getCmp('infoGrid'),
				groupingFeature = thisGrid.view.getFeature('osWiseGrouping');
				if(pressed){
						groupingFeature.collapseAll();
						obj.setIconCls('iconExpandAll');
				}else{
						groupingFeature.expandAll();
						obj.setIconCls('iconCollapseAll');
				}
				thisGrid.doLayout();
			}
		}
	}],
	hideHeaders : true,
	viewConfig: {
		deferEmptyText: true,
		cls:'gridSkin_expander_view'
	},
	emptyText: '<table align="center" height="150"><tr><td align="center"> <img src="/final/config/images/spacer.gif" class="iconExclamation"><div class="commonErrorMsgText" id="noCompAlrtDiv">No systems found for the selected OS</div> </td></tr></table>',
	columns :{
		items:[
			{
				text : 'System',
				dataIndex : 'SystemsWithVersion',
				flex : 1,
				renderer : function(value)
				{
					if (value != "" && value.length > 0)
					{
						var mainArr = value.split("#$#"); // version #$# systemlist(seperated by |)
						var rowText = '';
						var tmpArr = mainArr[1].split("|");
						rowText ='<thead><tr width="100%"><th colspan="3" class="OStable_td" style="padding:5px 7px 5px 9px;font-size:11px;">'+config.title.version+' : '+ mainArr[0] + '</th></tr></thead>';
						var colText = '';
						var count = 1;
						var sysSize = tmpArr.length;
						for (var d = 0; d < sysSize; d++)
						{
							if (count == 4) 
							{
								count = 1;
							}
							if (count == 1)
							{
								colText = colText + '<tr width="100%">';
							}

							colText = colText + '<td style="padding:5px;font-size:8pt;" valign="center" height="20" width="33%"><img src="../images/clear.png" class="iconConfigSystem" style="vertical-align:baseline;" /><a id="mouse" class="eg_monlink" style="vertical-align:text-bottom" href="javascript:getSystemDetails(\'' + tmpArr[d] + '\')">' + tmpArr[d]+ '</a></td>';

							if (count == 3)
							{
								colText = colText + '</tr>';
							}
							count++;

							while (count < 4 && d == sysSize-1)
							{
								colText = colText + '<td width="33%" class="OStable_emptytd">&nbsp;</td>';
								count++;
							}
						}
						rowText = rowText + colText;
						return '<table class="OStable" valign="top" width="100%" style="margin-bottom: 0px">' + rowText+ '</table>';
					}
				}
			}
		]
	}
});



