Ext.define('ProcessorFamily.controller.Main',{
	extend : 'Ext.app.Controller',
	views : [
		'Main',
		'FormItems',
		'ErrorContainer',
		'configutilities.Tools',
		'configutilities.PrintPreview',
		'configutilities.SendMail',
		'ProcessorFamilyChart'
	],
	refs : [
		{
			selector : 'main',
			ref : 'main'
		},
		{
			selector : 'formitems', 
			ref : 'formitems'
		},
		{
			selector : 'tools', 
			ref : 'tools'
		},
		{
			selector : 'errorcontainer', 
			ref : 'errorcontainer'
		},
		{
			selector : 'processorfamilychart', 
			ref : 'processorfamilychart'
		},
	],

	init : function()
	{
		thisCtrl = this;
		this.buildFieldData()
		this.control({
			'main' : {
				'afterrender' : this.afterMainRender
			},
			'formitems' : {
				'boxready' : this.loadResultData
			},
			'formitems combobox[id="ec_criteria"]' :{
				'select' : this.getInformations
			},
			'formitems combobox[id="ec_userOption"]' :{
				'select' : this.getInformations
			},
			'formitems button[id="submit"]' :{
				'click' : this.get
			},
			'tools' :{
				'afterrender' : this.loadTools
			},
			'tools button[id="saveBtn"]' : {
				'click' : this.saveAsPDF
			},
			'tools button[id="printBtn"]' : {
				'click' : this.printData
			},
			'tools button[id="csvBtn"]' : {
				'click' : this.saveAsCSV
			},
			'tools button[id="mailBtn"]' : {
				'click' : this.sendMail
			},
			'tools button[id="scheduleBtn"]' : {
				'click' : this.setschedule
			},
			'main #backBtnMain': {
				'click': this.forwardRequestedURI
			}
		});
	},


	buildFieldData : function(){
		Ext.Ajax.request({
			url		: config.urls.servletURL,
			params	: queryString+"&needData=yes",
			method	: 'POST',
			async	: false,
			success	: function( response ){
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					hiddenFieldsKeys = publicJSON['hiddenFields'];
					backOperation = publicJSON['backOperation'];
				}
			}
		});
	},

	
	afterMainRender : function()
	{
		me = this;
		var ec_userOption =  me.getFormitems().getComponent('infoCont').getComponent('ec_userOption');
		var ec_criteria =  me.getFormitems().getComponent('infoCont').getComponent('ec_criteria');
		var pf = me.getFormitems().getComponent('infoCont').getComponent('processorFamily');

		ec_criteria.getStore().loadRawData(publicJSON['viewByList']);
		ec_criteria.setValue(publicJSON.selectedEcOpt);

		if (publicJSON.selectedEcOpt != 'Component')
		{
			ec_userOption.getStore().loadRawData(publicJSON['specViewByList']);
			ec_userOption.setValue(publicJSON.selectedUserOption);
			ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
			ec_userOption.show();
		}
		else
		{
			ec_userOption.hide();
		}
		pf.getStore().loadRawData(publicJSON['processorList']);
		pf.setValue(publicJSON['selectedProcessor']);
		if(publicJSON.hasConfigDetails)
			thisCtrl.setToolsState(false,publicJSON['selectedProcessor']);
		else
			thisCtrl.setToolsState(true,publicJSON['selectedProcessor']);

		if ((strRequestFrom != null && strRequestFrom == "saveSchedule"))
		{
			Ext.getCmp('backBtnMain').show();
			Ext.getCmp('bkSeperator').show();
			Ext.getCmp('submit').setText('Save');
		}
	},
	

	loadResultData : function()
	{
		if (strRequestFrom != null && strRequestFrom != "saveSchedule")
		{
			if(publicJSON.chartData !="" && publicJSON.chartData != undefined)
			{
				thisCtrl.getProcessorfamilychart().loadChart(publicJSON,thisCtrl);
			}
			if(publicJSON.hasConfigDetails)
			{
				Ext.getCmp('formitems').collapse();
				thisCtrl.getMain().getComponent('hiddenPanel').show();
				thisCtrl.getMain().getComponent('hiddenPanel').getComponent('mainGrid').show();
				thisCtrl.getMain().getComponent('hiddenPanel').getComponent('mainGrid').getStore().loadRawData(publicJSON['systemInfoArray']);
			}
			else
			{
				Ext.getCmp('hiddenPanel').hide();
				me.getErrorcontainer().update('<table border="0" height="400px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+'No result found for the current selection'+'.</div></td></tr></table>');
				me.getErrorcontainer().show();
			}
		}
	},


	loadTools : function()
	{
		thisCtrl.getTools().loadIcon(
			true, //save
			true, //print
			true, //mail
			true, //csv
			true, //booklet
			true //schedule
		);
	},

	saveAsPDF : function()
	{
		//var getSaveObj = Ext.widget('savepdf');
		//getSaveObj.savePDF(config.urls.pdfURL);

		downloadAsPDF(config.urls.pdfURL);
	},

	printData : function()
	{
		var printQueryStr = publicJSON.printQueryStr;
		Ext.widget('print',{title : config.title.mainPageTitle}).show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set({
			src: printQueryStr
		});
	},

	saveAsCSV : function()
	{
		me = this;
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var ec_userOption = "";
		if (ec_criteria != 'Component')
		{
			 ec_userOption = Ext.getCmp('ec_userOption').getValue();
		}
		window.location = '../servlet/com.eg.EcCSVController?ec_criteria='+ec_criteria+'&ec_userOption='+ec_userOption;
	},

	sendMail : function()
	{
		Ext.widget('sendmail').show();
	},


	setschedule : function()
	{
		var op = "schedule";
		var me = this;

		var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var ec_userOption = Ext.getCmp('ec_userOption').getValue();
		var processorFamily = Ext.getCmp('processorFamily').getValue();
		var tempCriteriaPrevious = "";
		var tempUserOptionPrevious = "";

		if (hiddenFieldsKeys.ec_criteriaPrevious != null && hiddenFieldsKeys.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = hiddenFieldsKeys.ec_criteriaPrevious;
		}
		if (hiddenFieldsKeys.ec_userOptionPrevious != null && hiddenFieldsKeys.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = hiddenFieldsKeys.ec_userOptionPrevious;
		}

		if (op == "schedule")
		{
			if (strRequestFrom != null && strRequestFrom == "saveSchedule")
			{
				var checkFlag = me.validateForm();
				if (checkFlag == false)
				{
					return false;
				}
				window.location = "/final/config/EcSaveScheduleNew.jsp?ec_rtype=Processor&ec_userOption="+encodeURIComponent(ec_userOption)+"&ec_criteria="+ec_criteria+"&family="+encodeURIComponent(filterEncode(processorFamily))+"&id="+id+"&isSubmit=true&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious);
			}
			else
			{
				var urlStr = "/final/config/EcSaveScheduleNew.jsp?showWindow=yes&ec_rtype=Processor&ec_userOption="+encodeURIComponent(ec_userOption)+"&ec_criteria="+ec_criteria+"&family="+encodeURIComponent(filterEncode(processorFamily))+"&id="+id+"&request_from=Processor&isSubmit=true&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious)+"&com.eg.CSRF_NONCE="+csrfToken;

				scheduleWindow(urlStr);
			}
		}
		else if(op == "favorite")
		{
			window.location.href = "/final/config/EcSaveFavorite.jsp";
		}
		else
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,".Illegal Access");
			return false;
		}
	},

	
	setToolsState : function(iconState,pf)
	{
		var saveObj =me.getTools().getComponent('saveTool');
		var printObj =me.getTools().getComponent('printTool');
		var mailObj =me.getTools().getComponent('mailTool');
		var csvObj =me.getTools().getComponent('csvTool');
		var scheduleToolObj = me.getTools().getComponent('scheduleTool');
		var combineBookletObj = me.getTools().getComponent('bookletTool');
		if (!Ext.isEmpty(saveObj)) {
			saveObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(printObj)) {
			printObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(mailObj)) {
			mailObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(csvObj)) {
			csvObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(combineBookletObj)) {
			combineBookletObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(scheduleToolObj) && pf != "-1") {
			scheduleToolObj.setDisabled(false);
		}
		else
		{
			scheduleToolObj.setDisabled(iconState);
		}
	},

	getInformations : function()
	{
		Ext.getCmp('hiddenPanel').hide();

		var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		var ec_userOption =  me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').getValue();
		var ec_criteria =  me.getFormitems().getComponent('infoCont').getComponent('ec_criteria').getValue();
		var pf = me.getFormitems().getComponent('infoCont').getComponent('processorFamily');
		var tempCriteria = "";
		var tempUserOption = "";
		var tempCriteriaPrevious = "";
		var tempUserOptionPrevious = "";

		pf.setDisabled(true);

		tempCriteria = ec_criteria;

		if (tempCriteria != null && tempCriteria != undefined)
		{
			tempCriteria = ec_criteria;
		}
		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != 'Component' && ec_userOption != undefined && ec_userOption != null)
		{
			tempUserOption = ec_userOption;
		}
		if (hiddenFieldsKeys.ec_criteriaPrevious != null && hiddenFieldsKeys.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = hiddenFieldsKeys.ec_criteriaPrevious;
		}
		if (hiddenFieldsKeys.ec_userOptionPrevious != null && hiddenFieldsKeys.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = hiddenFieldsKeys.ec_userOptionPrevious;
		}

		//var url = "../servlet/com.eg.EcConfigurationServletNew?needData=yes&ec_rtype=Processor&request_from="+strRequestFrom+"&id="+id+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious);

		this.getFormitems().submit({
			url : "../servlet/com.eg.EcConfigurationServletNew",
			params: "needData=yes&ec_rtype=Processor&request_from="+strRequestFrom+"&id="+id+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious),
			method : 'POST',
			success : function(form, action){
				var publicJSON = Ext.decode(action.response.responseText);
				hiddenFieldsKeys = publicJSON.hiddenFields;
				me.getFormitems().getComponent('infoCont').getComponent('ec_criteria').getStore().loadRawData(publicJSON.viewByList);
				me.getFormitems().getComponent('infoCont').getComponent('ec_criteria').setValue(publicJSON.selectedEcOpt);

				if (publicJSON.selectedEcOpt != 'Component')
				{
					me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').getStore().loadRawData(publicJSON.specViewByList);
					me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').setFieldLabel(publicJSON.specViewByTitle);
					me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').setValue(publicJSON['selectedUserOption']);
					me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').show();
				}
				else
				{
					me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').hide();
				}
				pf.getStore().removeAll();
				pf.getStore().loadRawData(publicJSON['processorList']);
				pf.setValue(publicJSON['processorList'][0].valueField);

				delete publicJSON;

				pf.setDisabled(false);
				me.setToolsState(true,publicJSON['processorList'][0].valueField);
			},
			failure : function(form, action)
			{
				Ext.MessageBox.alert("Ajax Failed","Error in updating details");
			}
		});
	},


	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+hiddenFields[key]+"&";
		}
		return hiddenQstr;
	},


	get : function()
	{
		var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		var ec_userOption =  me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').getValue();
		var ec_criteria =  me.getFormitems().getComponent('infoCont').getComponent('ec_criteria').getValue();
		var family = me.getFormitems().getComponent('infoCont').getComponent('processorFamily').getValue();

		if (strRequestFrom != null && strRequestFrom == "saveSchedule")
		{
			me.setschedule();
		}
		else
		{
			var checkFlag = me.validateForm();
			if (checkFlag == false)
			{
				return false;
			}
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
			myMask.show();

			var tempCriteria = "";
			var tempUserOption = "";
			var tempCriteriaPrevious = "";
			var tempUserOptionPrevious = "";

			if (ec_criteria != null && ec_criteria != undefined)
			{
				tempCriteria = ec_criteria;
			}
			if (tempCriteria != null && tempCriteria != undefined && tempCriteria != 'Component')
			{
				tempUserOption = ec_userOption;
			}

			if (hiddenFieldsKeys.ec_criteriaPrevious != null && hiddenFieldsKeys.ec_criteriaPrevious != undefined)
			{
				tempCriteriaPrevious = hiddenFieldsKeys.ec_criteriaPrevious;
			}
			if (hiddenFieldsKeys.ec_userOptionPrevious != null && hiddenFieldsKeys.ec_userOptionPrevious != undefined)
			{
				tempUserOptionPrevious = hiddenFieldsKeys.ec_userOptionPrevious;
			}

			//var url = "../servlet/com.eg.EcConfigurationServletNew?needData=yes&ec_rtype=Processor&processorFamily="+family+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious);

			Ext.Ajax.request({
				url: "../servlet/com.eg.EcConfigurationServletNew",
				params: "needData=yes&ec_rtype=Processor&processorFamily="+encodeURIComponent(filterEncode(family))+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious),
				method: 'POST',
				success: function(response)
				{
					myMask.hide();
					var jsonData = Ext.decode(response.responseText);
					publicJSON = jsonData;
					hiddenFieldsKeys = jsonData.hiddenFields;

					if (jsonData.errorText != null && jsonData.errorText != undefined)
					{
						Ext.getCmp('hiddenPanel').hide();
						me.getErrorcontainer().update('<table border="0" height="400px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+jsonData.errorText+'.</div></td></tr></table>');
						me.getErrorcontainer().show();
					}
					else
					{
						me.getErrorcontainer().hide();
						if(jsonData.chartData !="" && jsonData.chartData != undefined)
						{
							thisCtrl.getProcessorfamilychart().loadChart(jsonData,thisCtrl);
							Ext.getCmp('chartPlaceHolder').show();
						}
						else
						{
							Ext.getCmp('chartPlaceHolder').hide();
						}
						thisCtrl.getMain().getComponent('hiddenPanel').show();
						Ext.getCmp('mainGrid').show();
						Ext.getCmp('mainGrid').getStore().loadRawData(jsonData['systemInfoArray']);
					}

					if(jsonData.systemInfoArray == "")
					{
						me.setToolsState(true,publicJSON['processorList'][0].valueField);
					}
					else
					{
						Ext.getCmp('formitems').collapse();
						me.setToolsState(false,publicJSON['processorList'][0].valueField);
					}
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
					Ext.MessageBox.alert("Ajax Failed","Error in updating details");
				}
			});
		}
	},

	validateForm : function()
	{
		var tempCriteria = "";
		var tempUserOption = "";
		var ec_userOption =  me.getFormitems().getComponent('infoCont').getComponent('ec_userOption').getValue();
		var ec_criteria =  me.getFormitems().getComponent('infoCont').getComponent('ec_criteria').getValue();
		var family = me.getFormitems().getComponent('infoCont').getComponent('processorFamily').getValue();
		
		if (ec_criteria != null && ec_criteria != undefined)
		{
			tempCriteria = ec_criteria;
		}
		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != 'Component')
		{
			tempUserOption = ec_userOption;
		}
		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorZone);
					return false;
				}
				else if (tempCriteria == "Service")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorService);
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorSegment);
					return false;
				}
			}
		}

		if (family == "-1")
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.pfError);
			return false;
		}
	},

	
	forwardRequestedURI : function()
	{
		if ((strRequestFrom != null && strRequestFrom == "saveSchedule") || (backOperation != null && backOperation.schedule != undefined && backOperation.schedule))
		{
			var me = this;
			var ec_criteria = Ext.getCmp('ec_criteria').getValue();
			var ec_userOption = Ext.getCmp('ec_userOption').getValue();
			var processorFamily = Ext.getCmp('processorFamily').getValue();
			hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			window.location = "/final/config/EcSaveScheduleNew.jsp?request_from="+strRequestFrom+"&id="+id+"&"+hiddenFields+"&ec_userOption="+encodeURIComponent(ec_userOption)+"&ec_criteria="+ec_criteria+"&family="+encodeURIComponent(filterEncode(processorFamily));
		}
	}

});



function getSystemDetails(systemName)
{
	var sysName = systemName.split("(");
	var systemName1 = sysName[0];
	var system = systemName1.trim();
	var criteria = Ext.getCmp('ec_criteria').getValue();
	var userOption = Ext.getCmp('ec_userOption').getValue();
	var family = Ext.getCmp('processorFamily').getValue();

	window.location.href = "../servlet/com.eg.EcConfigurationServletNew?request_from=Processor&cmd=BoxView&searchValue=&systemName=" + encodeURIComponent(system) + "&ec_criteria=" + criteria + "&ec_userOption=" + encodeURIComponent(userOption)+"&processorFamily="+encodeURIComponent(filterEncode(family))+"&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken;
}


function doCloseWin()
{
	Ext.getCmp('scheduleWin').destroy();
}









