Ext.define('ProcessorFamily.view.FormItems', {
	extend : 'Ext.form.Panel',
	alias : 'widget.formitems',
	id : 'formitems',
	cls:'formOuter accordionArrow',
	margin: '8 5 5 5',
	collapsible: true,
	requires : [
		'utilities.ScrollCombo'
	],

	items : [
		{
			xtype : 'container',
			id : 'infoCont',
			margin : 10,
			layout : {
				type : 'hbox',
				pack : 'center'
			},
			defaults : {
				labelSeparator : '',
				labelAlign : 'top'
			},
			items : [
				{
					xtype:'combo',
					cls: 'dropdown',
					width: 130,
					editable : false,
					fieldLabel:config.title.viewByTitle,
					name: 'ec_criteria',
					id: 'ec_criteria',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					margin: '0 0 0 10'
				},
				{
					xtype:'scrollcombo',
					width : 200,
					cls: 'dropdown',
					fieldLabel:'Zone',
					id: 'ec_userOption',
					name: 'ec_userOption',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					hidden: true,
					margin: '0 0 0 10'
				},
				{
					xtype : 'scrollcombo',
					fieldLabel:config.title.pfTitle,
					cls: 'dropdown',
					id : 'processorFamily',
					itemId : 'processorFamily',
					name : 'processorFamily',
					store :  new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
					width : 250,
					margin: '0 0 0 10'
				},
				{
					xtype : 'button',
					text : config.title.submitTitle,
					action : 'submit',
					id : 'submit',
					cls: 'button20',
					margin: '20 0 0 10',
					width: 80
				}
			]
		}
	],
	listeners:
	{
		afterrender:function(panel)
		{
			var headerObj = Ext.getCmp("formitems_header");
			headerObj.removeCls("x-panel-header-default");
		},
		collapse: function()
		{
			var titleStr = '';
			var selectedEcOpt = publicJSON.selectedEcOpt;
			var selectedUserOptionText = publicJSON.selectedUserOption;
			var selectedProcessor = publicJSON.selectedProcessor;

			if (selectedEcOpt != null &&  selectedEcOpt != "-1")
			{
				if (selectedEcOpt == "Component")
				{
					titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>';
				}
				else
				{
					if (selectedUserOptionText != null && selectedUserOptionText != "-1")
					{
						titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">'+selectedEcOpt+'</span> - <span class="formSelectionValue">'+selectedUserOptionText+'</span>';
					}
					else
					{
						titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>';
					}
				}

				if (selectedProcessor != null && selectedProcessor != "-1")
				{
					titleStr = titleStr + '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">Processor Family</span> - <span class="formSelectionValue">'+selectedProcessor+'</span>';
				}
			}
			Ext.getCmp("formitems").setTitle(titleStr);
		},
		expand: function()
		{
			Ext.getCmp("formitems").setTitle('');
		}
	}
});




