Ext.define('RAMCapacity.view.FormItems', {
	extend : 'Ext.form.Panel',
	alias : 'widget.formitems',
	id : 'formitems',
	cls:'formOuter accordionArrow',
	margin: '8 5 5 5',
	collapsible: true,
	requires : [
		'utilities.ScrollCombo'
	],

	items : [
		{
			xtype : 'container',
			id : 'infoCont',
			margin : 10,
			layout : {
				type : 'hbox',
				pack : 'center'
			},
			defaults : {
				labelSeparator : '',
				labelAlign : 'top'
			},
			items : [
				{
					xtype:'combo',
					cls: 'dropdown',
					width: 130,
					editable : false,
					fieldLabel:config.title.viewByTitle,
					name: 'ec_criteria',
					id: 'ec_criteria',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					margin: '0 0 0 10'
				},
				{
					xtype:'scrollcombo',
					width : 200,
					cls: 'dropdown',
					fieldLabel:'Zone',
					id: 'ec_userOption',
					name: 'ec_userOption',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					hidden: true,
					margin: '0 0 0 10'
				},
				{
					xtype : 'combo',
					cls: 'dropdown',
					fieldLabel : config.title.limit,
					id : 'rangeOption',
					itemId : 'rangeOption',
					name : 'rangeOption',
					store: new Ext.data.Store({
						fields : ['valueField','displayField'],
						data : [
							{'displayField':'Less Than','valueField':'LESSTHAN'},
							{'displayField':'Less Than or Equal','valueField':'LESSTHAN_OR_EQUAL'},
							{'displayField':'Greater Than','valueField':'GREATERTHAN'},
							{'displayField':'Greater Than or Equal','valueField':'GREATERTHAN_OR_EQUAL'},
							{'displayField':'Between','valueField':'BETWEEN'}
						]
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
					value : 'BETWEEN',
					editable : false,
					margin: '0 10 0 10'
				},
				{
					xtype : 'combo',
					cls: 'dropdown',
					id : 'startRange',
					itemId : 'startRange',
					name : 'startRange',
					store :  new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
					editable : false,
					width : 100,
					margin:'20 10 10 0'
				},
				{
					xtype : 'displayfield',
					fieldLabel : '-',
					id : 'rangeSeperator',
					margin:'20 10 10 0'
				},
				{
					xtype : 'combo',
					cls: 'dropdown',
					id : 'endRange',
					itemId : 'endRange',
					name : 'endRange',
					store :  new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
					editable : false,
					width : 100,
					margin:'20 10 10 0'
				},
				{
					xtype : 'button',
					text : config.title.submitTitle,
					action : 'submit',
					id : 'submit',
					cls: 'button20',
					margin: '20 0 0 10',
					width: 80
				}
			]
		}
	],
	listeners:
	{
		afterrender:function(panel)
		{
			var headerObj = Ext.getCmp("formitems_header");
			headerObj.removeCls("x-panel-header-default");
		},
		collapse: function()
		{
			var titleStr = '';
			var selectedEcOpt = publicJSON.selectedEcOpt;
			var selectedUserOptionText = publicJSON.selectedUserOption;
			var rangeOption = publicJSON.rangeOption;
			var selectedStartRange =  parseInt(publicJSON.selectedStartRange);
			var selectedEndRange = parseInt(publicJSON.selectedEndRange);
			var selectedStartRangeStr = "";
			var selectedEndRangeStr = "";

			if (selectedStartRange != null)
			{
				if (selectedStartRange < 1024)
				{
					selectedStartRangeStr = selectedStartRange + " MB";
				}
				else 
				{
					selectedStartRangeStr = selectedStartRange/1024 + " GB";
				}
			}

			if (selectedEndRange != null)
			{
				if (selectedEndRange < 1024)
				{
					selectedEndRangeStr = selectedEndRange + " MB";
				}
				else 
				{
					selectedEndRangeStr = selectedEndRange/1024 + " GB";
				}
			}

			if (selectedEcOpt != null &&  selectedEcOpt != "-1")
			{
				if (selectedEcOpt == "Component")
				{
					titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>';
				}
				else
				{
					if (selectedUserOptionText != null && selectedUserOptionText != "-1")
					{
						titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">'+selectedEcOpt+'</span> - <span class="formSelectionValue">'+selectedUserOptionText+'</span>';
					}
					else
					{
						titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>';
					}
				}
				if (rangeOption != null)
				{
					if (rangeOption == "LESSTHAN")
					{
						titleStr = titleStr + '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">RAM SIZE</span> - <span class="formSelectionValue">Less Than</span> <span class="formSelectionValue">'+selectedStartRangeStr+'</span>';
					}
					else if (rangeOption == "LESSTHAN_OR_EQUAL")
					{
						titleStr = titleStr + '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">RAM SIZE</span> - <span class="formSelectionValue">Less Than or Equal</span> <span class="formSelectionValue">'+selectedStartRangeStr+'</span>';
					}
					else if (rangeOption == "GREATERTHAN")
					{
						titleStr = titleStr + '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">RAM SIZE</span> - <span class="formSelectionValue">Greater Than</span> <span class="formSelectionValue">'+selectedStartRangeStr+'</span>';
					}
					else if (rangeOption == "GREATERTHAN_OR_EQUAL")
					{
						titleStr = titleStr + '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">RAM SIZE</span> - <span class="formSelectionValue">Greater Than or Equal</span> <span class="formSelectionValue">'+selectedStartRangeStr+'</span>';
					}
					else
					{
						titleStr = titleStr + '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">RAM SIZE</span> - <span class="formSelectionValue">Between</span> <span class="formSelectionValue">'+selectedStartRangeStr+'</span> - <span class="formSelectionValue">'+selectedEndRangeStr+'</span>';
					}
				}
			}
			Ext.getCmp("formitems").setTitle(titleStr);
		},
		expand: function()
		{
			Ext.getCmp("formitems").setTitle('');
		}
	}
});




