Ext.define('ReportBooklet.controller.Main', {
	extend:'Ext.app.Controller',
	views:['ReportBooklet.view.Main'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'bookletgrid', ref:'bookletgrid'},
		{selector:'customwindow', ref:'customwindow'}
	],
	init: function () 
	{
		this.control({
			'main' :
			{
				'afterrender' : this.afterMainRender
			},
			'bookletgrid':
			{
				'afterrender':this.deleteAllReport
			},
			'bookletgrid textfield[name="bookletlivesearch"]':
			{
				change:this.doFilter
			},
			'customwindow button[id=bindReport]' : {
				'click' : this.bindReport
			},
			'customwindow button[id=updateBooklet]' : {
				'click' : this.updateReportGrid
			},
			'bookletReportGrid':{
				'afterrender':this.deleteAllReport
			},
		})
	},

	afterMainRender: function()
	{
		var me = this;
		Ext.Ajax.request({
			url : config.urls.servletURL,
			params : "cmd=EcReportBooklet&needData=yes",
			method : 'POST',
			async : false,
			success : function(response){
				if ( response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					var dataArray = publicJSON.bookletArr;
					if (dataArray != null && dataArray.length >0)
					{

						var datArray=me.getBookletgrid().dataArray;
						var dummyArray=me.getBookletgrid().dummyArray;
						me.getBookletgrid().getStore().removeAll();

						datArray.splice(0, datArray.length);
						dummyArray.splice(0, dummyArray.length);
						for(var i=0;i<dataArray.length;i++)
						{
							datArray.push(dataArray[i]);
							dummyArray.push(dataArray[i]);
						}
						var curpage=me.getBookletgrid().activePage;
						var totalCount=me.getBookletgrid().getStore().totalCount;
						var pageSize=me.getBookletgrid().getStore().pageSize;
						if(Math.round(totalCount/pageSize)<curpage)
						{
							me.getBookletgrid().activePage=Math.round(totalCount/pageSize);
						}
						if(me.getBookletgrid().activePage<=0)
							me.getBookletgrid().activePage=1;
						me.getBookletgrid().getStore().loadPage(me.getBookletgrid().activePage);
					}
					else
					{
						Ext.getCmp('bookletgridID').hide();
						Ext.getCmp('bookletViewMain').update('<table border="0" height="350px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText" style="margin:1% auto 0 auto;">'+config.msgs.noDataMsg+'.</div></td></tr></table>');
					}
				}
			}
		});
	},

	openReportWindow: function(record)
	{
		eachRec=record;
		Ext.widget('customwindow');
		this.getCustomwindow().setTitle(config.title.pageTitle);
		this.getCustomwindow().show();
		var reportGridIDStore = Ext.getCmp('reportGridID');
		if(eachRec.data['status']=='NotGen' || eachRec.data['status']=='Not Generated')
		{
			Ext.getCmp('bindReport').setDisabled(false);
		}

		reportGridIDStore.getStore().loadRawData(eachRec.data['reports']);
		Ext.getCmp('binderNameField').setValue(eachRec.data['bookletname']);
		Ext.getCmp('descriptionField').setValue(eachRec.data['description']);
		Ext.getCmp('updateBooklet').hide();
		Ext.getCmp('bookletItemField').setValue(eachRec.data['reports'].length);

	},

	bindReport: function()
	{
		var description = Ext.getCmp('descriptionField').getValue();
		eachRec.set('description', description);
		var record = eachRec;
		this.reportBinder(record);
	},

	reportBinder: function(record)
	{
		record.set('status', '<div style="position:relative;"><img src="/final/reporter/images/processing.gif" border="0" /></div>');
		record.set('generate', '<div style="position:relative;height:16px;"><img src="/final/images/Light/regenerate_on.gif" border="0" /></div>');
		if (!Ext.isEmpty(this.getCustomwindow()))
			this.getCustomwindow().doClose();
		Ext.Ajax.request({
			url: '../servlet/com.eg.EcBookletGenerateC',
			method: 'POST',
			params: 'isFileDowload=true&bookletname=' + record.data['bookletname'] + '&bookletID=' + record.data['bookletID'] + '&rOrder=' + record.data['rOrder']+'&description='+ record.data['description'],
			success: function(response) {
				try
				{
					if (response.status == 200)
					{
						record.set('generate','');
						record.set('status','Generated');
					}
				}
				catch (e)
				{
					alert('Error during binding')
				}
			}
		});
	},

	updateReportGrid: function()
	{
		var me = this;
		var thisBooklet = this;
		var description = Ext.getCmp('descriptionField').getValue();
		var bookletname = Ext.getCmp('binderNameField').getValue();
		if(bookletname=="" || bookletname.length==0)
		{
			thisBooklet.getAlertMessage(config.title.pageTitle,config.msgs.alertMsg1);
			return;
		}
		if(!checkspecial(bookletname,"`~!@#$%^&*()+={}[]|\\:;\"'<>,.?/"))
		{
			thisBooklet.getAlertMessage(config.title.pageTitle,config.msgs.alertMsg2);
			return ;
		}
		if(!checkspecial(description,"`~!@#$%^&*()+={}[]|\\:;\"'<>,.?/"))
		{
			thisBooklet.getAlertMessage(config.title.pageTitle,config.msgs.alertMsg3);
			return ;
		}//
		var mainGrid = Ext.getCmp('bookletgridID');
		var mainGridCnt = mainGrid.getStore().data.items.length;
		for (var j =0 ; j < mainGridCnt; j++)
		{
			var data_inner = mainGrid.getStore().data.items[j].data.bookletname;
			if(eachRec.index!=j && bookletname==data_inner)
			{
				thisBooklet.getAlertMessage(config.title.pageTitle,config.msgs.alertMsg4);
				return ;
			}
		}
		var viewStoreObj = Ext.getCmp('reportGridID');
		var dataCnt = viewStoreObj.getStore().data.items.length;
		var containSpl = -1;
		var rNames = '';
		for (var i =0 ; i < dataCnt; i++)
		{
			var data = viewStoreObj.getStore().data.items[i].data.reportNames;
			rNames = rNames+data+'#'+viewStoreObj.getStore().data.items[i].data.reportID;
			if(i < dataCnt-1)
				rNames=rNames+',';
			if(!checkspecial(data,"`~!@#$%^&*()+={}[]|\\:;\"'<>,.?/"))
			{
				containSpl = i;
				break;
			}
			for (var j =0 ; j < dataCnt; j++)
			{
				var data_inner = viewStoreObj.getStore().data.items[j].data.reportNames;
				
				if(i!=j && data==data_inner)
				{
					thisBooklet.getAlertMessage(config.title.pageTitle,config.msgs.alertMsg5);
					return ;
				}
			}
		}
		if(containSpl > -1)
		{
			Ext.MessageBox.show({
				title: config.title.pageTitle,
				msg: config.msgs.alertMsg6,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING,
				fn : function()
				{
					var data = viewStoreObj.getStore().data.items[containSpl].data.reportNames;
					var rowIndex = viewStoreObj.getStore().find("reportNames",data);
					cellEditing.startEdit(rowIndex,1);
				}
			});
			return ;
		}
		Ext.getCmp('reportGridID').getView().refresh();
		var initMask = new Ext.LoadMask(viewStoreObj.getEl(),{msg : "Loading ..."});
		initMask.show();
		
		Ext.Ajax.request({
			url: '../servlet/com.eg.EcBookletGenerateC',
			method: 'POST',
			params: 'isUpdateBooklet=true&bookletID=' + eachRec.data['bookletID'] + '&rName=' + rNames+'&description='+description+'&bookletname='+bookletname,
			success: function(response)
			{
				try
				{
					if (response.status == 200)
					{
						initMask.hide();
						Ext.getCmp('bindReport').setDisabled(false);
						Ext.getCmp('updateBooklet').hide();
						eachRec.set('bookletname', bookletname);
						eachRec.set('description', description);
						eachRec.set('status', 'Not Generated');
						eachRec.set('reports', viewStoreObj.getStore().data.items);
						me.getAlertMessageInfo(config.title.pageTitle,config.msgs.alertMsg7);
					}
				}
				catch (e)
				{
					alert('Error during updateing')
				}
			}
		});
	},
	
	updateOrder: function()
	{
		var me = this;
		Ext.getCmp('bindReport').setDisabled(false);
		eachRec.set('status', 'Not Generated');
		var description = Ext.getCmp('descriptionField').getValue();
		eachRec.set('description', description);
		var reportGridIDStore = Ext.getCmp('reportGridID').getStore();
		var description = Ext.getCmp('descriptionField').getValue();
		var lengthReport = reportGridIDStore.data.length;
		var reorderID = [];
		for (var iR = 0; iR < lengthReport; iR++)
		{
			reorderID.push(reportGridIDStore.getAt(iR).get('reportID'));
		}
		eachRec.set('rOrder', reorderID.toString());
		eachRec.set('reports', reportGridIDStore.data.items);
		Ext.Ajax.request({
			url: '../servlet/com.eg.EcBookletGenerateC',
			method: 'POST',
			params: 'isUpdateOrder=true&bookletID=' + eachRec.data['bookletID'] + '&rOrder=' + reorderID+'&description='+description,
			success: function(response)
			{
				try
				{
					if (response.status == 200)
					{
						//me.getAlertMessage('BOOKLETS','Rearanged successfully!');
					}
				}
				catch (e)
				{
					alert('Error during updateing')
				}
			}
		});
	},

	deleteAllReport: function(grid)
	{
		var me = this;
		var gridId=grid.getId();
		var msgInfo = config.msgs.alertMsg8;
		var deleteFrom = '';
		var removeIconId='';
		if (gridId=='reportGridID')
		{
			deleteFrom = 'report';
			removeIconId='#removeAllReport';
			msgInfo = config.msgs.alertMsg9;
		}
		else if (gridId=='bookletgridID')
		{
			deleteFrom = 'booklet';
			removeIconId='#removeAll';
		}
		else
		{
			return;
		}
		grid.mon(Ext.select(removeIconId), 'click', function() 
		{
			var selected = grid.getView().getSelectionModel().getSelection();
			var reportGridStore = grid.getStore();
			var noOfrecords = reportGridStore.getCount();
			var selectionModelObj = grid.getSelectionModel();
			if(removeIconId=='#removeAllReport' && noOfrecords==selectionModelObj.getSelection().length)
			{
				me.getAlertMessage(config.title.pageTitle,config.msgs.alertMsg10);
				return;
			}
			if (noOfrecords > 0)
			{
				var reportSelected = false;
				if (selectionModelObj.getSelection().length > 0)
				{
					reportSelected = true;
				}
				if (reportSelected)
				{
					Ext.Msg.show({
						title: config.title.pageTitle,
						msg: msgInfo,
						buttons: Ext.Msg.YESNO,
						icon: Ext.Msg.QUESTION,
						fn: function(buttonId) {
							if (buttonId == "yes")
							{
								if(removeIconId=='#removeAllReport')
								{
									var rID = "";
									var description = Ext.getCmp('descriptionField').getValue();
									Ext.each(selected, function(item) {
										rID += item.data.reportID + ',';
										var rOrder = eachRec.data['rOrder'].split(',');
										var index = rOrder.indexOf(item.data.reportID);
										if (index > -1) 
										{
											rOrder.splice(index, 1);
										}
										eachRec.set('rOrder', rOrder.toString());
										reportGridStore.remove(item);
									});

									eachRec.set('reports', reportGridStore.data.items);
									eachRec.set('status', 'Not Generated');
									Ext.getCmp('bindReport').setDisabled(false);
									Ext.getCmp('bookletItemField').setValue(eachRec.data['reports'].length);
									rID = rID.substring(0, (rID.length - 1));

									Ext.Ajax.request({
										url: '../servlet/com.eg.EcBookletGenerateC',
										method: 'POST',
										params: 'isReportDel=true&reportID=' + rID + '&rOrder=' + eachRec.data['rOrder'] + '&bookletID=' + eachRec.data['bookletID']+'&description='+description,
										success: function(response)
										{
											try
											{
												if (response.status == 200) {
													me.getAlertMessageInfo(config.title.pageTitle,'Reports are deleted successfuly');
												}
											} catch (e) {
												alert(e);
											}
										}
									});
								}
								else if(removeIconId=='#removeAll')
								{
									alert("removeAll");
									var rID = "";
									var bID = "";
									Ext.each(selected, function(item) {
										bID += item.data.bookletID + ',';
										rID += item.data.rOrder + ',';
										reportGridStore.remove(item);
									});

									bID = bID.substring(0, (bID.length - 1));
									rID = rID.substring(0, (rID.length - 1));

									Ext.Ajax.request({
										url: '../servlet/com.eg.EcBookletGenerateC',
										method: 'POST',
										params: 'isBookletDel=true&bookletID=' + bID + '&reportID=' + rID,
										success: function(response)
										{
											try
											{
												if (response.status == 200)
												{
													me.afterMainRender();
													me.getAlertMessageInfo(config.title.pageTitle,config.msgs.alertMsg11);
												}
											}
											catch (e)
											{
												alert(e);
											}
										}
									});
								}
							}
						}
					});
				} 
				else
				{
					if (deleteFrom == 'report')
					{
						me.getAlertMessage(config.title.pageTitle,config.msgs.alertMsg12);
					}
					else
					{
						me.getAlertMessage(config.title.pageTitle,config.msgs.alertMsg13);
					}
					
					return;
				}
			}
		});
	},

	deleteSingleReport: function(grid,record)
	{
		var me = this;
		var reportGridStore = grid.getStore();
		var description = Ext.getCmp('descriptionField').getValue();
		if(reportGridStore.getCount()==1)
		{
			me.getAlertMessage(config.title.pageTitle,config.msgs.alertMsg10);
			return;
		}
		Ext.Msg.show({
			title: config.title.pageTitle,
			msg: config.msgs.alertMsg14,
			buttons: Ext.Msg.YESNO,
			icon: Ext.Msg.QUESTION,
			fn: function(buttonId)
			{
				if (buttonId == "yes")
				{
					var rID = record.data.reportID;
					var rOrder = eachRec.data['rOrder'].split(',');
					var index = rOrder.indexOf(record.data.reportID);
					if (index > -1) 
					{
						rOrder.splice(index, 1);
					}
					eachRec.set('rOrder', rOrder.toString());
					reportGridStore.remove(record)
					grid.refresh();
					eachRec.set('reports', reportGridStore.data.items);
					eachRec.set('status', 'Not Generated');
					Ext.getCmp('bindReport').setDisabled(false);
					Ext.getCmp('bookletItemField').setValue(eachRec.data['reports'].length);
					Ext.Ajax.request({
						url: '../servlet/com.eg.EcBookletGenerateC',
						method: 'POST',
						params: 'isReportDel=true&reportID=' + rID + '&rOrder=' + eachRec.data['rOrder'] + '&bookletID=' + eachRec.data['bookletID']+'&description='+description,
						success: function(response)
						{
							try
							{
								if (response.status == 200)
								{
									me.getAlertMessageInfo(config.title.pageTitle,config.msgs.alertMsg16);
								}
							}
							catch (e)
							{
								alert('Error in Single report delete');
							}
						}
					});
				}
			}
		});
	},

	deleteSingleBooklet: function(grid,record)
	{
		var me = this;
		var reportGridStore = grid.getStore();
		Ext.Msg.show({
			title: config.title.pageTitle,
			msg: config.msgs.alertMsg15,
			buttons: Ext.Msg.YESNO,
			icon: Ext.Msg.QUESTION,
			fn: function(buttonId)
			{
				if (buttonId == "yes")
				{
					var rID =record.data.rOrder;
					var bID = record.data.bookletID;
					reportGridStore.remove(record);
					grid.refresh();

					Ext.Ajax.request({
						url: '../servlet/com.eg.EcBookletGenerateC',
						method: 'POST',
						params: 'isBookletDel=true&bookletID=' + bID + '&reportID=' + rID,
						success: function(response)
						{
							try
							{
								if (response.status == 200)
								{
									me.afterMainRender();
									me.getAlertMessageInfo(config.title.pageTitle,config.msgs.alertMsg17);
								}
							}
							catch (e)
							{
								alert(e);
							}
						}
					});
				}
			}
		});
	},

	doFilter: function(obj)
	{
		this.filterGrid(obj.getValue());
	},

	filterGrid: function(value)
	{
		if (value == "" || value.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		var bookletGridObj = Ext.getCmp('bookletgridID');

		if (value == "" || value.length == 0)
		{
			bookletGridObj.getStore().clearFilter();
		}
		else
		{
			bookletGridObj.getStore().clearFilter();
			var userFilter = new Ext.util.Filter({
				filterFn: function(item) 
				{
					var bookletName = item.get('bookletname');
					if (bookletName.toLowerCase().indexOf(value.toLowerCase()) != -1)
					{
						return true
					}
				}
			});
			bookletGridObj.getStore().filter(userFilter);
		}
	},

	getAlertMessage: function(title,msg)
	{
		Ext.MessageBox.show({
			title: title,
			msg: msg,
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
		});
	},

	getAlertMessageInfo: function(title,msg)
	{
		Ext.MessageBox.show({
			title: title,
			msg: msg,
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.INFO
		});
	}
});



