Ext.define('ReportBooklet.view.BookletListGrid',
{
	extend: 'utilities.CustomGrid',
	requires:[
		'Ext.ux.grid.FiltersFeature',
		'Ext.ux.data.PagingMemoryProxy',
		'utilities.CustomGrid'
	],
	alias: 'widget.bookletgrid',
	id: 'bookletgridID',
	ui: 'newGridPanel',
	border: true,
	autoScroll: false,
	scroll: false,
	screenLabels: null,
	dataArray : null,
	dummyArray : null,
	pageLimit: 22,
	activePage: 1,
	flex: 1,
	margin: '0 10 10 10',

	viewConfig: 
	{
		emptyText : '<table width="100%" height="100%" align="center" valign="middle"><tr><td align="center" valign="middle"><div  class="iconExclamation"></div><div class="font_normal11">'+config.msgs.emptyMsg1+'</div></td></tr></table>',
		deferEmptyText:false
	},

	initComponent:function()
	{
		var me=this;
		this.selModel = new Ext.selection.CheckboxModel(
		{
			checkOnly: true,
			headerWidth:27,
			injectCheckbox: 'first'
		});
		if(Ext.isEmpty(this.dataArray))
		{
			this.dataArray=[];
		}
		this.dummyArray=this.dataArray.slice();
		this.store = Ext.create('Ext.data.Store', {
			proxy : {
				type : 'pagingmemory',
				reader : {
					type : 'json'
				}
			},
			pageSize:this.pageLimit,
			autoLoad : true,
			data : this.dataArray,
			sortOnLoad: true,
			fields: [{name:'bookletID'},{name:'bookletname',sortType:Ext.data.SortTypes.asUCString},{name:'description',sortType:Ext.data.SortTypes.asUCString},{name:'bookletItems',sortType:Ext.data.SortTypes.asUCString},{name:'status'},{name:'view'},{name: 'reports',type: 'auto'}, 'rOrder'],
			sorters: { property: 'bookletname', direction : 'ASC' },
			id: 'tmpStore'
		});
		this.columns = [
			{
				text: config.title.gridCol1,
				dataIndex: 'bookletname',
				flex: 0.5,
				sortable: true,
				renderer: function(value, metaData, record, row, col, store, gridView)
				{
					metaData.style = 'cursor: pointer;';
					var dispVal = value;
					metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
					return dispVal;
				},
				listeners :
				{
					'click':function(grid, htmlRow, index, columnIndex,mouseEvent, record)
					{
						thisCtrl.getController('Main').openReportWindow(record);
					}
				}
			},
			{
				header: config.title.gridCol2,
				flex: 1,
				sortable :true,
				dataIndex: 'description',
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					var dispVal = value;
					metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
					return dispVal;
				}
			},
			{
				header: config.title.gridCol3,
				align:'center',
				width: 140,
				sortable :true,
				dataIndex: 'bookletItems',

				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					var dispVal = record.data['reports'].length;
					metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
					return dispVal;
				}
			},
			{
				header: config.title.gridCol4,
				width: 120,
				dataIndex: 'status',
				renderer:function(value, metaData, record, row, col, store, gridView)
				{
					if (value != 'Generated' && value != 'Not Generated' && value != 'NotGen')
					{
						metaData.tdCls="iconColumn";
					}
					else if(metaData.tdCls=="iconColumn"){
						metaData.tdCls="";
					}
					return value;
				}
			},
			{
				header: '',
				xtype : 'actioncolumn',
				sortable :false,
				dataIndex : 'generate',
				width : 40,
				renderer:function(value, metaData, record, row, col, store, gridView)
				{
					var cls='';
					if (record.data['status']=='Generated')
					{
						cls = 'iconGenerateOn';
					}
					else if(record.data['status']=='NotGen' || record.data['status']=='Not Generated')
					{
						cls='iconGenerateOff';
					}
					value = '<div  data-qtip="Generate Booklet" data-qclass="yellowTip" style="cursor:pointer;position:relative;margin: 0px auto;top:1px;" class="'+cls+'"   ></div>';
					return value;
				},
				listeners :
				{
					'click':function(grid, htmlRow, index, columnIndex,mouseEvent, record)
					{
						thisCtrl.getController('Main').reportBinder(record);
					}
				}
			},
			{
				header: '',
				xtype : 'actioncolumn',
				sortable :false,
				dataIndex : 'view',
				width : 40,
				renderer:function(value, metaData, record, row, col, store, gridView)
				{
					var cls='iconReportNotBindDownload';
					if (record.data['status']=='Generated')
					{
						cls = 'iconReportBindDownload';
					}
					value = '<div  data-qtip="Download Booklet" data-qclass="yellowTip" style="cursor:pointer;position:relative;margin: 0px auto;top:1px;" class="'+cls+'"   ></div>';
					return value;
				},
				listeners :
				{
					'click':function(grid, htmlRow, index, columnIndex,mouseEvent, record)
					{
						if(record.data['status']=='Generated')
						{
							Ext.create('Ext.form.Panel', {
							renderTo: Ext.getBody(),
							standardSubmit: true,
							url: '../servlet/com.eg.EcBookletFileDownloadC?bookletID=' + record.data['bookletID']
							}).submit();
						}
					}
				}
			},
			{
				header: '<div style="cursor:pointer" id="removeAll" class="iconDeleteAll" data-qclass="yellowTip" data-qtip="Delete All"></div>',
				xtype : 'actioncolumn',
				sortable :false,
				width: 40,
				dataIndex : 'remove',
				renderer:function(value, metaData, record, row, col, store, gridView)
				{
					value = '<div  data-qtip="Delete" data-qclass="yellowTip" style="cursor:pointer;position:relative;margin: 0px auto;top:2px;" class="iconDelete"   ></div>';
					return value;
				},
				listeners :
				{
					'click':function(grid, htmlRow, index, columnIndex,mouseEvent, record)
					{
						thisCtrl.getController('Main').deleteSingleBooklet(grid,record);
					}
				}
			}
		];
		var meGrid = this;
		this.dockedItems = [
			{
				xtype: 'pagingtoolbar',
				cls: 'newPagination',
				dock: 'bottom',
				displayInfo: true,
				style:strSkin =="Light"?{'border-top':'0px !important'}:{'border-top':'1px'},
				id: 'FavListPaging',
				name: 'FavListPaging',
				pageSize: this.pageLimit,
				store: this.store,
				displayMsg: 'Displaying Booklets {0} - {1} of {2}',
				emptyMsg: config.msgs.emptyMsg2,
				listeners: {
					change : function(thisd, params)
					{
						if(!Ext.isEmpty(params))
						{
							meGrid.activePage = params.currentPage;
						}
						else
						{
							meGrid.activePage=0;
						}
					}
				}
			},
			{
				xtype: 'toolbar',
				cls: 'toolbar',
				dock: 'top',
				flex: 1,
				height: 38,
				items:[
					{ 
						xtype: 'tbfill' 
					},
					{
						xtype: 'trigger',
						id : 'bookletlivesearch',
						name : 'bookletlivesearch',
						trigger1Cls: 'x-form-clear-trigger',
						trigger2Cls: 'x-form-search-trigger',
						cls: 'whitedropdown_search',
						emptyText: 'Search test name',
						margin: 0,
						getTriggerMarkup: function() 
						{
							var me = this,
							i = 0,
							hideTrigger = (me.readOnly || me.hideTrigger),
							triggerCls,
							triggerBaseCls = me.triggerBaseCls,
							triggerConfigs = [],
							unselectableCls = Ext.dom.Element.unselectableCls,
							style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
							cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
							if (!me.trigger1Cls) {
								me.trigger1Cls = me.triggerCls;
							}
							for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) 
							{
								if (i == 0)
								{
									triggerConfigs.push({
										tag: 'td',
										role: 'presentation',
										valign: 'top',
										cls: cls,
										id : 'MyTrigger_'+i,
										style: style + "display:none;",
										cn: {
											cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
											role: 'presentation'
										}
									});
								}
								else
								{
									triggerConfigs.push({
										tag: 'td',
										role: 'presentation',
										valign: 'top',
										cls: cls,
										id : 'MyTrigger_'+i,
										style: style,
										cn: {
											cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
											role: 'presentation'
										}
									 });
								}
							}
							triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
							return Ext.DomHelper.markup(triggerConfigs);
						},
						onTrigger1Click: function()
						{
							this.reset();
						},
						onTrigger2Click: function()
						{
							thisCtrl.getController('Main').filterGrid(this.getValue());
						}
					}
				]
			}
		]
		this.callParent();
	},
	listeners:
	{
		sortchange:function(ct, column, e, t, eOpts )
		{
			 this.getStore().loadPage(this.activePage);
		}
	}
});



