Ext.define('ReportBooklet.view.CustomWindow', {
	extend: 'Ext.window.Window',
	requires: [
		'ReportBooklet.view.BookletReportGrid'
	],
	alias: 'widget.customwindow',
	width: 640,
	height: 265,
	padding: 0,
	header:{
		style:{'margin':'0px 10px 0px 10px','padding':'4px 0px 1px 0px'}
	},
	ghost: false,
	frame: false,
	border: true,
	ui: 'newPopupWindow withBorderShadow newplainHeader_border',
	modal: true,
	closable: true,
	draggable: true,
	resizable: false,
	layout: 'column',
	closeAction: 'destroy',
	buttonAlign: 'center',
	defaults:
	{
		labelSeparator: '',
		labelAlign: 'top',
	},
	items: [
		{
			xtype: 'textfield',
			cls: 'textbox',
			id: 'binderNameField',
			itemId: 'binderNameField',
			fieldLabel: 'Booklet Name',
			columnWidth: 0.30,
			margin : '10 0 10 10',
			maxLength: 32,
			enforceMaxLength: true,
			listeners:
			{
				change: function( obj, e, eOpts )
				{
					Ext.getCmp('updateBooklet').show();
				}
			}
		},
		{
			xtype: 'textfield',
			cls: 'textbox',
			id: 'descriptionField',
			itemId: 'descriptionField',
			fieldLabel: 'Description',
			columnWidth: 0.50,
			margin : '10 0 10 10',
			listeners:
			{
				change: function( obj, e, eOpts )
				{
					Ext.getCmp('updateBooklet').show();
				}
			}
		},
		{
			xtype: 'textfield',
			cls: 'textbox',
			fieldLabel: 'No. of Reports',
			name: 'bookletItemField',
			id: 'bookletItemField',
			columnWidth: 0.20,
			margin : '10 10 10 10',
			readOnly: true
		},
		{
			xtype: 'bookletReportGrid',
			height: 124,
			columnWidth: 1.0,
			margin: '0 10 0 10'
		},
		{
			xtype: 'container',
			margin: '10 0 0 0',
			columnWidth: 1.0,
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			items:[
				{
					xtype: 'button',
					text: config.msgs.btnMsg1,
					ui: 'newButtonSmall',
					width: 90,
					id: 'bindReport',
					name: 'bindReport',
					disabled: true
				},
				{
					xtype: 'button',
					text: config.msgs.btnMsg2,
					ui: 'newButtonSmall',
					width: 90,
					id: 'updateBooklet',
					name: 'updateBooklet',
					margin: '0 0 0 10',
					hidden: true
				}
			]
		}
	],
	listeners:
	{
		beforeclose: function(win) 
		{
			cellEditing.cancelEdit();
		}
	}
});



