<%@ include file = "../../EcTrackerJson.jsp" %>
<%@ page import="net.sf.json.*" %>
<%@ page import="com.eg.EgMappingInfo" %>
<%@ page import="com.eg.*" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="java.io.*" %>
<%@ page import="egurkha.reporter.*" %>
<%@ page import="java.util.*" %>
<%@ page import="java.text.SimpleDateFormat" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	try
	{
		String userIDBooklet = (String)session.getAttribute("sess_auserid");
		ErBookletGroupInfoBean gPDFbean = new ErBookletGroupInfoBean();
		List bookletList =  gPDFbean.getBookletNamesAndIDs(userIDBooklet,true,true,"configuration");
		List reportList=null;
		
		JSONArray bookletArr = null;
		JSONObject rootObj  = new JSONObject();
		if(bookletList!=null)
		{
			JSONObject bookletObj = null;
			JSONObject reportObj = null;
			bookletArr = new JSONArray();
			int bookletSize = bookletList.size();
			for(int ib=0;ib<bookletSize;ib++)
			{
				ErBookletGroupInfoBean booklet =(ErBookletGroupInfoBean)bookletList.get(ib);

				bookletObj = new JSONObject();
				reportObj  = new JSONObject();
				String bookletName = booklet.getBookletName();
				if (!bookletName.endsWith("_cf"))
				{
					continue;
				}
				bookletName = bookletName.substring(0,bookletName.indexOf("_cf"));
				bookletObj.put("bookletname", bookletName);
				bookletObj.put("bookletID", booklet.getBookletID());
				if(booklet.getStatus().equalsIgnoreCase("NotGen"))
					bookletObj.put("status","Not Generated");
				else if(booklet.getStatus().equalsIgnoreCase("Completed"))
					bookletObj.put("status","Generated");
				else
					bookletObj.put("status",booklet.getStatus());

				bookletObj.put("description",booklet.getDescription());
				bookletObj.put("createdOn",booklet.getCreatedOn());
				bookletObj.put("view","test");
				  
				reportList = booklet.getBookletReportInfo();
				JSONArray reportArray = new JSONArray();
				
				String pdfLocation = EgInstallInfo.getInstallDir()+"/manager/binder/"+booklet.getBookletID()+"/";
				for(int jk=0;jk<reportList.size();jk++)
				{
					ErBookletReportInfoBean rBean=(ErBookletReportInfoBean)reportList.get(jk);
					String reportName = rBean.getReportName();
					if (!reportName.endsWith("_cf"))
					{
						continue;
					}
					reportName = reportName.substring(0,reportName.indexOf("_cf"));

					File file  = new File(pdfLocation+rBean.getReportID()+".pdf");
					String lastModified ="";
					double kilobytes=0.0;
					if(file.exists())
					{
						double bytes = file.length();
						kilobytes = (bytes / 1024);
						if((kilobytes+"").indexOf(".")>-1)
						{
							kilobytes = (Math.round(kilobytes*100))/100;
						}
						SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
						lastModified = sdf.format(file.lastModified());
						lastModified = DateUtil.changeDateFormat(lastModified,"MM/dd/yyyy HH:mm:ss",this_user.getUserDateFormat()+" HH:mm:ss");
					}
					JSONObject rDetail = new JSONObject();
					Map paramMap = rBean.getParameters();
					String isAnyTimeline = null;
					Object isAnyTimelineObj = paramMap.get("ec_timeline");
					if(isAnyTimelineObj instanceof String[])
					{
						String[] isAnyTimeline1=(String[])isAnyTimelineObj;
						isAnyTimeline  = isAnyTimeline1[0];
					}
					else
					{
						isAnyTimeline=(String)(paramMap).get("ec_timeline");
					}

					if(isAnyTimeline==null || isAnyTimeline.equalsIgnoreCase("null")|| isAnyTimeline.equalsIgnoreCase("Any"))
					{
						isAnyTimeline = "Any";
					}
					else if (isAnyTimeline.endsWith("last"))
					{
						String lastCount = isAnyTimeline.substring(0, isAnyTimeline.indexOf(DateTimeTokenizer.BLANK_SPACE));
						String lastTime = isAnyTimeline.substring(isAnyTimeline.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, isAnyTimeline.length());
						String tmpStr = lastTime.substring(0, isAnyTimeline.lastIndexOf("_")-2);
						if(lastCount.equals("1"))
						{
							isAnyTimeline = "Last " + tmpStr ;
						}
						else
						{
							isAnyTimeline = "Last " + lastCount + " " + tmpStr;
						}
					}
					rDetail.put("reportID",rBean.getReportID());
					rDetail.put("reportNames",reportName);
					rDetail.put("isAnyTimeline",isAnyTimeline);
					rDetail.put("pageRange","All pages");
					rDetail.put("fileSize",kilobytes+" KB");
					rDetail.put("modifiedDate",lastModified);
					reportArray.add(rDetail);
				}

				bookletObj.put("reports",reportArray);
				bookletObj.put("bookletItems",reportArray.size()+"");
				bookletObj.put("rOrder",booklet.getReportOrder());
				bookletArr.add(bookletObj);
			}
			rootObj.put("bookletArr",bookletArr);
			out.println(rootObj.toString());
		}
		session.setAttribute("configLastAccessedURL","/final/config/EcReportBookletIndex.jsp");
	}
	catch(Exception e)
	{
		System.err.println("Exception occur at EcReportBookletJson");
		e.printStackTrace();
	}
%>



