Ext.define('SaveSchedule.controller.Main', {
	extend : 'Ext.app.Controller',
	views : [
		//'CreateSchedule',
		'Main'
	],
	refs :[
		{
			selector : 'main', 
			ref : 'main'
		}
		//,{
			//selector : 'createschedule', 
			//ref : 'createschedule'
		//}
	],
	init:function() {
		me = this;
		this.buildFieldData()
		this.control({
			'main' : {
				'afterrender' :  this.afterMainRender
			},
			'main button[id="backBtnMain"]' : {
				'click' :  this.backButton
			},
			'main button[id="saveBtn"]' : {
				'click' :  this.saveSchedule
			},
			'main combo[id="schedule_held_on"]' : {
				'select' :  this.scheduleOn
			},
			'main combo[id="mail_freq"]' : {
				'select' :  this.loadHiddenCombo
			},
			'main combo[id="print_freq"]' : {
				'select' :  this.loadHiddenCombo
			},
		});
	},
	buildFieldData : function()
	{
		Ext.Ajax.request({
			url : config.urls.initialURL,
			params : queryString,
			method : 'POST',
			async : false,
			success : function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					jsonData = Ext.decode(jsonText);
					 isSchedulePrintEnabled = jsonData['isSchedulePrintEnabled'];
				}
			}
		})
	},
	afterMainRender : function()
	{
		if (isSchedulePrintEnabled)
		{
			me.getMain().getComponent('infoCont').getComponent('print_freq').show();
		}
		if (queryString.indexOf('showWindow=yes')> -1)
		{
			me.getMain().getHeader().hide();
			//me.getMain().addCls('scheduleFavoriteInner');
			me.getMain().margin = 0;
			me.getMain().getComponent('gridDisplay').hide();
			Ext.getCmp('backBtnMain').hide();
		}
		else
		{
			me.getMain().setTitle(config.title.mainPageTitle);
			me.getMain().getHeader().show();
			me.getMain().addCls('outerpanel');
			me.getMain().getComponent('gridDisplay').show();
			if (request_from.length > 0)
			{
				Ext.getCmp('backBtnMain').show();
			}
			else
			{
				Ext.getCmp('backBtnMain').hide();
			}
			me.getMain().getComponent('infoCont').getComponent('sch_name').setValue(jsonData.editScheduleJson.sch_name);
			me.getMain().getComponent('infoCont').getComponent('mail_freq').setValue(jsonData.editScheduleJson.sch_mailFreq);
			me.getMain().getComponent('infoCont').getComponent('mail_on').setValue(jsonData.editScheduleJson.sch_mailon);
			me.getMain().getComponent('infoCont').getComponent('mail_id').setValue(jsonData.editScheduleJson.sch_mail_id);
			me.getMain().getComponent('infoCont').getComponent('print_freq').setValue(jsonData.editScheduleJson.sch_printFreq);
			me.getMain().getComponent('infoCont').getComponent('print_on').setValue(jsonData.editScheduleJson.sch_printon);
			me.getMain().getComponent('infoCont').getComponent('schedule_held_on').setValue(jsonData.editScheduleJson.schedule_on);
			if (jsonData.editScheduleJson.schedule_on == "AnyTime")
			{
				me.getMain().getComponent('infoCont').getComponent('timeAt').setValue(jsonData.editScheduleJson.strTime);
				me.getMain().getComponent('infoCont').getComponent('timeAt').show();
			}
			else
			{
				me.getMain().getComponent('infoCont').getComponent('timeAt').hide();
			}
			var selectedName = jsonData.selectedName;
			var selectedValue = jsonData.selectedValue;

			selectedNameArray = selectedName.split('#');
			selectedValueArray = selectedValue.split('#');

			var aStore = new Ext.data.Store({
				fields: ['selectName','selectDetails'],
			});
			var showModifyLink = jsonData["showModifyLink"];
			if (showModifyLink)
			{
				me.getMain().getComponent('gridDisplay').setTitle(config.title.gridTitle+' <a id="mouse" data-qtip="Click here to modify your selection" onClick="me.modifyDetails()" target="main" class="eg_monlink"><img src="/final/images/spacer.gif" class="iconModify">');
			}
			for (var i=0; i<selectedNameArray.length; i++)
			{
				var selectName = selectedNameArray[i];
				var selectValue = selectedValueArray[i];
				aStore.add({'selectName': selectName, 'selectDetails': selectValue});
				me.getMain().getComponent('gridDisplay').bindStore(aStore);
			}
		}
		me.loadHiddenFields();
	},
	modifyDetails : function()
	{
		var ulrStr = jsonData['modifyURL'];
		me.loadHiddenFields();
		var schForm = Ext.getCmp('saveschedule');
		var thisForm = schForm.getForm();

		thisForm.submit({
			url: ulrStr,
			//params : hiddenFields,
			standardSubmit : true,
			method: 'POST'
		});

	},
	loadHiddenFields : function()
	{
		var me = Ext.getCmp('saveschedule');
		var frmObj = me.getForm();
		var hiddenFields = jsonData.hiddenFields;
		for (var hiddenField in hiddenFields) {
			if (!frmObj.findField("'" + hiddenField + "'")) {
				me.add({
					xtype : 'hidden',
					id  : hiddenField,
					name : hiddenField,
					value : hiddenFields[hiddenField]
				});
			}
			else
			{
				frmObj.findField("'" + hiddenField + "'").setValue(hiddenFields[hiddenField]);
			}
		}
	},
	scheduleOn : function()
	{
		var str_schOn = me.getMain().getComponent('infoCont').getComponent('schedule_held_on').getValue();
		var timeAt =  me.getMain().getComponent('infoCont').getComponent('timeAt');
		if (str_schOn == "AnyTime")
		{
			timeAt.show();
		}
		else
		{
			timeAt.hide();
		}
	},
	loadHiddenCombo : function(obj)
	{
		from = obj.getId();
		if (from == "mail_freq")
		{
			var str_mailfreq = me.getMain().getComponent('infoCont').getComponent('mail_freq').getValue();
			var mailOn =  me.getMain().getComponent('infoCont').getComponent('mail_on');
			if (str_mailfreq == "Weekly")
			{
				mailOn.setValue("Sunday");
				mailOn.show();
			}
			else
			{
				mailOn.hide();
			}
		}
		else
		{
			var str_printfreq = me.getMain().getComponent('infoCont').getComponent('print_freq').getValue();
			var printOn =  me.getMain().getComponent('infoCont').getComponent('print_on');
			if (isSchedulePrintEnabled)
			{
				if (str_printfreq == "Weekly")
				{
					printOn.setValue("Sunday");
					printOn.show();
				}
				else
				{
					printOn.hide();
				}
			}
		}
	},
	backButton : function()
	{
		request_from = request_from.trim();
		if (request_from != null && request_from == "viewschedulepage")
		{
			history.back();
		}
		else if (request_from != null && request_from == "saveschedule")
		{
			me.goBackToViewSchedule();
		}
		else if (request_from != null && (request_from == "current" || request_from == "change"))
		{
			me.goBack();
		}
		else if (request_from != null && (request_from == "osinventory" || request_from == "box view" || request_from == "compsview"))
		{
			me.goBack();
		}
		else if (request_from != null && (request_from == "softwareavailability" || request_from == "serviceavailability" || request_from == "hotfixavailability" || request_from == "servicestatus"))
		{
			me.goBack();
		}
		else if (request_from != null && (request_from == "diskcapacity" || request_from == "ramcapacity" || request_from == "servicepack"))
		{
			me.goBack();
		}
		else if (request_from != null && (request_from == "systemmanufacturer" || request_from == "processor" || request_from == "ipaddress"))
		{
			me.goBack();
		}
		else if (request_from != null && (request_from == "defaultgateway" || request_from == "printer" || request_from == "daywisechanges"))
		{
			me.goBack();
		}
		else if (request_from != null && (request_from == "changesbycomponentname" || request_from == "changesbycomponenttype"))
		{
			me.goBack();
		}
		else if (request_from != null && (request_from == "consolidated" || request_from == "citrixapplicationsandusers"))
		{
			me.goBack();
		}
	},
	goBackToViewSchedule : function()
	{
		var schForm = Ext.getCmp('saveschedule');
		var thisForm = schForm.getForm();
		thisForm.submit({
			url:  "/final/config/EcViewScheduleIndex.jsp",
			standardSubmit : true,
			method: 'POST'
		});
	},
	goBack : function()
	{
		var schForm = Ext.getCmp('saveschedule');
		var thisForm = schForm.getForm();
		thisForm.submit({
			url : config.urls.servletURL,
			params : queryString+"&back_request=ScheduleConfig",
			standardSubmit : true,
			method: 'POST'
		});
	},
	saveSchedule : function()
	{
		var schName = me.getMain().getComponent('infoCont').getComponent('sch_name').getValue();
		var mailFreq = me.getMain().getComponent('infoCont').getComponent('mail_freq');
		var mailIDValue = me.getMain().getComponent('infoCont').getComponent('mail_id').getValue();
		var mailID = me.getMain().getComponent('infoCont').getComponent('mail_id');
		var printFreq = me.getMain().getComponent('infoCont').getComponent('print_freq');
		var mailFreqValue = me.getMain().getComponent('infoCont').getComponent('mail_freq').getValue();
		var printFreqValue = me.getMain().getComponent('infoCont').getComponent('print_freq').getValue();
		if(!checkblank(schName))
		{
			Ext.Msg.alert(config.title.mainPageTitle,config.msgs.schNameError);
			return;
		}
		else if (!checkspace(schName))
		{
			Ext.Msg.alert(config.title.mainPageTitle,config.msgs.spaceError);
			return;
		}
		else if (!checkspecial(schName,"+-=~!@#$%^&*()\"\';"))
		{
			Ext.Msg.alert(config.title.mainPageTitle,config.msgs.specialCharError);
			return;
		}
		else if(mailFreqValue != "None")
		{
			if(!checkmultiplemailid(mailIDValue))
			{
				mailID.focus();
				return;
			}
		}
		else if (!Ext.isEmpty(printFreq) && mailFreqValue == "None")
		{
			Ext.Msg.alert(config.title.mainPageTitle,config.msgs.error2);
			return;
		}
		else if(printFreqValue == "None")
		{
			Ext.Msg.alert(config.title.mainPageTitle,config.msgs.error1);
			mailFreq.focus();
			return;
		}

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Saving...'});
		myMask.show();

		var schForm = Ext.getCmp('saveschedule');
		var thisForm = schForm.getForm();
		var hiddenFieldsKeys = jsonData['hiddenFields'];
		var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		var closeFn =  window.parent;
		if (request_from == "viewschedulepage")
		{
			closeFn = this;
		}
		var details  = thisForm.findField("details").getValue();
		if (thisForm.isValid())
		{
			thisForm.submit({
				url : config.urls.saveURL,
				params : 'cmd=Save',
				method : 'POST',
				success : function(form, action){
					myMask.hide();
					var publicJSON = Ext.decode(action.response.responseText);
					if (publicJSON.hasSaved)
					{
							Ext.Msg.show({
								title : config.title.mainPageTitle,
								msg : config.msgs.savedMsg,
								icon : 'iconInformation',
								buttons : Ext.Msg.OK,
								fn : function(btn){
									if (queryString.indexOf('showWindow=yes')> -1)
									{
										closeFn.doCloseWin();
									}
									else
									{
										window.location.href = "/final/config/EcViewScheduleIndex.jsp";
									}
								}
							});
					}
					else
					{
						Ext.Msg.alert(config.title.mainPageTitle,config.msgs.error3);
					}
				}
			});
		}
	},
	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+hiddenFields[key]+"&";
		}
		return hiddenQstr;
	},
	doCloseWin : function()
	{
		history.back();
	}
});



