Ext.define('SearchConfiguration.controller.Main', {
	extend : 'Ext.app.Controller',
	views : [
		'SearchConfiguration.view.FormItems',
		'SearchConfiguration.view.Viewport',
		'configutilities.Tools',
		'configutilities.PrintPreview',
		'configutilities.SendMail'
	],
	refs:[
		{
			selector : 'viewport', 
			ref : 'viewport'
		},
		{
			selector : 'formitems', 
			ref : 'formitems'
		},
		{
			selector : 'tools', 
			ref : 'tools'
		}
	],
	init :function() {
		appCnt = this;
		queryArray = new Array();
		queryValueArray = new Array();
		count = 0;
		flagDeleteClicked = 'false';
		flagAddClicked = 'false';
		this.buildFieldData();

		this.control({
			'viewport': {
				'afterrender': this.afterMainRender
			},
			'formitems combo[id="searchFor"]': {
				'select': this.searchForChange
			},
			'formitems combo[id="instatId"]': {
				'select': this.hotfixOrHarddiskInstallationStatusChange
			},
			'formitems button[id="addBtn"]': {
				'click': this.addQuery
			},
			'viewport button[id="deleteBtn"]': {
				'click': this.deleteQuery
			},
			'viewport button[id="searchBtn"]': {
				'click': this.searchQuery
			},
			'formitems combo[id="ososId"]': {
				'select': this.osForOSChange
			},
			'formitems combo[id="naosId"]': {
				'select': this.networkAdapterOSChange
			},
			'formitems combo[id="os"]': {
				'select': this.hotfixOrHardDiskOSChange
			},
			'formitems combo[id="swosId"]': {
				'select': this.softwareOSChange
			},
			'formitems combo[id="naInstatId"]': {
				'select': this.adapterInstallStatusChange
			},
			'formitems combo[id="swInstatId"]': {
				'select': this.swInstallStatusChange
			},
			'formitems combo[name="searchBy"]': {
				'select': this.searchByForHotfixChange
			},
			'formitems combo[name="searchByForDisk"]': {
				'select': this.searchByForDiskChange
			},
			'formitems combo[name="searchByForNA"]': {
				'select': this.searchByForNAChange
			},
			'formitems combo[name="searchByForOS"]': {
				'select': this.searchByForOSChange
			},
			'formitems combo[name="searchByForSoftware"]': {
				'select': this.searchByForSoftwareChange
			},
			'tools' :{
				'afterrender' : this.loadTools
			},
			'tools button[id="saveBtn"]' : {
				'click' : this.saveAsPDF
			},
			'tools button[id="printBtn"]' : {
				'click' : this.printData
			},
			'tools button[id="csvBtn"]' : {
				'click' : this.saveAsCSV
			},
			'tools button[id="mailBtn"]' : {
				'click' : this.sendMail
			}
		});
	},

	buildFieldData : function()
	{
		Ext.Ajax.request({
			url : config.urls.servletURL,
			params : queryString+"&needData=yes",
			method : 'POST',
			async : false,
			success : function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) 
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					hiddenFieldsKeys = publicJSON['hiddenFields'];
				}
			}
		});
	},

	afterMainRender : function()
	{
		Ext.getCmp('schSep1').hide();
		var searchForObj = Ext.getCmp('searchFor');

		searchForObj.getStore().loadRawData(publicJSON.searchForValues);

		if(publicJSON.selectedSrchFor != null && publicJSON.selectedSrchFor != "" && publicJSON.selectedSrchFor != undefined)
		{
			searchForObj.setValue(publicJSON.selectedSrchFor);
		}
		else
		{
			searchForObj.setValue(publicJSON.searchForValues[0].valueField);
		}

		var searchFor = searchForObj.getValue();
		if(!Ext.isEmpty(searchFor) && searchFor.toLowerCase() != 'please select' && searchFor != '-1')
		{
			appCnt.searchForChange(strRequestFrom);
		}
		if(publicJSON.containsData != null && publicJSON.containsData != "" && publicJSON.containsData != undefined && publicJSON.containsData != "no")
		{
			appCnt.setToolsState(false);
		}
		else
		{
			appCnt.setToolsState(true);
		}
	},

	searchForChange : function(reqFrom)
	{
		var searchFor = Ext.getCmp('searchFor').getValue();
		var searchByObj = Ext.getCmp('searchBy');
		var searchByForDiskObj = Ext.getCmp('searchByForDisk');
		var searchByForNAObj = Ext.getCmp('searchByForNA');
		var searchByForOSObj = Ext.getCmp('searchByForOS');
		var searchByForSoftwareObj = Ext.getCmp('searchByForSoftware');

		var hotfixOrHardDiskObj = Ext.getCmp('hotfixOrHardDisk');
		var networkAdapterObj = Ext.getCmp('networkAdapter');
		var OSContainerObj = Ext.getCmp('OSContainer');
		var softwareContainerObj = Ext.getCmp('softwareContainer');

		// hf and hd related
		var hfPatternObj = Ext.getCmp('hfpatternId');
		var ecStdateIdObj = Ext.getCmp('ec_stdateId');
		var ecEnddateIdObj = Ext.getCmp('ec_enddateId');
		var hdOSObj = Ext.getCmp('os');
		var hfnameIdObj = Ext.getCmp('hfnameId');
		var hdfsIdObj = Ext.getCmp('hdfsId');
		var hdcpIdObj = Ext.getCmp('hdcpId');
		var instatIdObj = Ext.getCmp('instatId');
		var hfDispColCntObj = Ext.getCmp('hfDispColCnt');

		// na related
		var napatternObj = Ext.getCmp('napatternId');
		var osObj = Ext.getCmp('naosId');
		var naInstatIdObj = Ext.getCmp('naInstatId');
		var naDispColCntObj = Ext.getCmp('naDispColCnt');

		Ext.getCmp('formitems').getForm().reset();
		Ext.getCmp('searchFor').setValue(searchFor);

		if (reqFrom != null && (reqFrom == 'SystemPage' || reqFrom == 'SearchPage'))
		{
			var qryStrSplitUp = queryString.split('&');
			for (var i = 0; i < qryStrSplitUp.length ; i++)
			{
				var value = qryStrSplitUp[i];

				if (searchFor == 'hf')
				{
					if (value.startsWith('searchBy='))
					{
						var valSplitUp = value.split('=');
						var selVal = valSplitUp[1];
						Ext.getCmp('searchBy').setValue(selVal);
						Ext.getCmp('searchBy').show();
						Ext.getCmp('hotfixOrHardDisk').show();
						appCnt.searchByForHotfixChange('queryString');
						break;
					}
				}
				else if (searchFor == 'hd')
				{
					if (value.startsWith('searchByForDisk='))
					{
						var valSplitUp = value.split('=');
						var selVal = valSplitUp[1];
						Ext.getCmp('searchByForDisk').setValue(selVal);
						Ext.getCmp('searchByForDisk').show();
						Ext.getCmp('hotfixOrHardDisk').show();
						Ext.getCmp('hfnameId').hide();
						appCnt.searchByForDiskChange('queryString');
						break;
					}
				}
				else if (searchFor == 'na')
				{
					if (value.startsWith('searchByForNA='))
					{
						var valSplitUp = value.split('=');
						var selVal = valSplitUp[1];
						Ext.getCmp('searchByForNA').setValue(selVal);
						Ext.getCmp('searchByForNA').show();
						Ext.getCmp('networkAdapter').show();
						Ext.getCmp('naInstatId').show();
						appCnt.searchByForNAChange('queryString');
						break;
					}
				}
				else if (searchFor == 'os')
				{
					if (value.startsWith('searchByForOS='))
					{
						var valSplitUp = value.split('=');
						var selVal = valSplitUp[1];
						Ext.getCmp('searchByForOS').setValue(selVal);
						Ext.getCmp('searchByForOS').show();
						Ext.getCmp('OSContainer').show();
						appCnt.searchByForOSChange('queryString');
						break;
					}
				}
				else if (searchFor == 'sw')
				{
					if (value.startsWith('searchByForSoftware='))
					{
						var valSplitUp = value.split('=');
						var selVal = valSplitUp[1];
						Ext.getCmp('searchByForSoftware').setValue(selVal);
						Ext.getCmp('searchByForSoftware').show();
						Ext.getCmp('softwareContainer').show();
						appCnt.searchByForSoftwareChange('queryString');
						break;
					}
				}
			}
			if (queryString.indexOf('queryItems=') > 0)
			{
				appCnt.searchQuery('queryString');
			}
		}
		else
		{
			Ext.getCmp('searchBy').setValue('byname');
			Ext.getCmp('searchByForDisk').setValue('byfs');
			Ext.getCmp('searchByForNA').setValue('byname');
			Ext.getCmp('searchByForOS').setValue('byram');
			Ext.getCmp('searchByForSoftware').setValue('byname');

			Ext.suspendLayouts();

			if (searchFor == 'Please select' || searchFor == '-1')
			{
				searchByObj.hide();
				searchByForDiskObj.hide();
				searchByForNAObj.hide();
				searchByForOSObj.hide();
				searchByForSoftwareObj.hide();

				hotfixOrHardDiskObj.hide();
				networkAdapterObj.hide();
				OSContainerObj.hide();
				softwareContainerObj.hide();
			}
			else if (searchFor == 'hf')
			{
				hotfixOrHardDiskObj.show();
				networkAdapterObj.hide();
				OSContainerObj.hide();
				softwareContainerObj.hide(); // containers

				searchByObj.show();
				searchByForDiskObj.hide();
				searchByForNAObj.hide();
				searchByForOSObj.hide();
				searchByForSoftwareObj.hide(); // srch by

				hdOSObj.show();
				hfPatternObj.hide();
				hfnameIdObj.show();
				instatIdObj.show();
				hfDispColCntObj.hide();
				hdfsIdObj.hide();
				hdcpIdObj.hide();
			}
			else if (searchFor == 'hd')
			{
				hotfixOrHardDiskObj.show();
				networkAdapterObj.hide();
				OSContainerObj.hide();
				softwareContainerObj.hide(); // containers

				searchByObj.hide();
				searchByForDiskObj.show();
				searchByForNAObj.hide();
				searchByForOSObj.hide();
				searchByForSoftwareObj.hide(); // srch by

				hdOSObj.show();
				hdfsIdObj.show();

				hfPatternObj.hide();
				hfnameIdObj.hide();
				ecStdateIdObj.hide();
				ecEnddateIdObj.hide();
				instatIdObj.hide();
				hfDispColCntObj.hide();
			}
			else if (searchFor == 'na')
			{
				hotfixOrHardDiskObj.hide();
				networkAdapterObj.show();
				OSContainerObj.hide();
				softwareContainerObj.hide(); // containers

				searchByObj.hide();
				searchByForDiskObj.hide();
				searchByForNAObj.show();
				searchByForOSObj.hide();
				searchByForSoftwareObj.hide(); // srch by

				osObj.show();
				Ext.getCmp('nasId').show();
				naInstatIdObj.show();
				naDispColCntObj.hide();
				napatternObj.hide();
			}
			else if (searchFor == 'os')
			{
				hotfixOrHardDiskObj.hide();
				networkAdapterObj.hide();
				OSContainerObj.show();
				softwareContainerObj.hide(); // containers

				searchByObj.hide();
				searchByForDiskObj.hide();
				searchByForNAObj.hide();
				searchByForOSObj.show();
				searchByForSoftwareObj.hide(); // srch by

				Ext.getCmp('ec_stdateOSId').hide();
				Ext.getCmp('ec_enddateOSId').hide();
				Ext.getCmp('ososId').show();
				Ext.getCmp('osoperatorId').show();
				Ext.getCmp('osramId').show();
			}
			else if (searchFor == 'sw')
			{
				hotfixOrHardDiskObj.hide();
				networkAdapterObj.hide();
				OSContainerObj.hide();
				softwareContainerObj.show(); // containers

				searchByObj.hide();
				searchByForDiskObj.hide();
				searchByForNAObj.hide();
				searchByForOSObj.hide();
				searchByForSoftwareObj.show(); // srch by
				Ext.getCmp('swDispColCnt').hide();

				Ext.getCmp('swosId').show();
				Ext.getCmp('swnameId').show();
				Ext.getCmp('swpatternId').hide();
				Ext.getCmp('ec_swstdateId').hide();
				Ext.getCmp('ec_swenddateId').hide();
			}

			Ext.resumeLayouts(true);

			Ext.Ajax.request(
			{
				url : config.urls.initialURL,
				scope : this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					if (searchFor == 'hf' || searchFor == 'hd')
					{
						Ext.getCmp('os').getStore().loadRawData(jsonData.osArray);
						Ext.getCmp('os').setValue(jsonData.osArray[0].valueField);

						if (searchFor == 'hf')
						{
							hfnameIdObj.getStore().loadRawData({'displayField': 'Not Applicable', 'valueField': '-1'});
							hfnameIdObj.setValue('-1');
						}
						else if (searchFor == 'hd')
						{
							hdfsIdObj.getStore().loadRawData({'displayField': 'Not Applicable', 'valueField': '-1'});
							hdfsIdObj.setValue('-1');
						}
					}
					else if (searchFor == 'na')
					{
						osObj.getStore().loadRawData(jsonData.osArray);
						osObj.setValue(jsonData.osArray[0].valueField);

						Ext.getCmp('nasId').getStore().loadRawData({'displayField': 'Not Applicable', 'valueField': '-1'});
						Ext.getCmp('nasId').setValue('-1');

						naInstatIdObj.show();
						naInstatIdObj.setValue('All');
					}
					else if (searchFor == 'os')
					{
						Ext.getCmp('ososId').getStore().loadRawData(jsonData.osArray);
						Ext.getCmp('ososId').setValue(jsonData.osArray[0].valueField);

						Ext.getCmp('osoperatorId').setValue('=');

						Ext.getCmp('osramId').getStore().loadRawData({'displayField': 'Not Applicable', 'valueField': '-1'});
						Ext.getCmp('osramId').setValue('-1');
					}
					else if (searchFor == 'sw')
					{
						Ext.getCmp('swosId').getStore().loadRawData(jsonData.osArray);
						Ext.getCmp('swosId').setValue(jsonData.osArray[0].valueField);

						Ext.getCmp('swnameId').getStore().loadRawData({'displayField': 'Not Applicable', 'valueField': '-1'});
						Ext.getCmp('swnameId').setValue('-1');

						Ext.getCmp('swInstatId').setValue('All');
					}
				}
			});
		}
	},

	getValueFromQryString : function(searchValue)
	{
		if (!Ext.isEmpty(queryString))
		{
			var queryStrSplitUp = queryString.split("&");
			for (var i = 0 ; i < queryStrSplitUp.length ; i++)
			{
				var val = queryStrSplitUp[i];
				if (val.startsWith(searchValue))
				{
					var temp = val.split('=');
					var value = filterDecode(temp[1]);
					return value;
				}
			}
		}
	},

	searchByForSoftwareChange: function(reqFrom)
	{
		var groupValue = Ext.getCmp('searchByForSoftware').getValue();
		Ext.getCmp('swDispColCnt').hide();

		if (groupValue == 'byname')
		{
			var osVal = publicJSON.osArray[0].valueField;
			Ext.getCmp('swpatternId').hide();
			Ext.getCmp('ec_swstdateId').hide();
			Ext.getCmp('ec_swenddateId').hide();

			Ext.getCmp('swosId').show();
			Ext.getCmp('swnameId').show();

			// reset the formitems
			if (reqFrom == 'queryString')
			{
				osVal = appCnt.getValueFromQryString("swos=");
			}
			Ext.getCmp('swosId').getStore().loadRawData(publicJSON.osArray);
			Ext.getCmp('swosId').setValue(filterDecode(osVal));

			if (reqFrom == 'queryString')
			{
				var softwareName = appCnt.getValueFromQryString("swname=");
				Ext.getCmp('swnameId').getStore().loadRawData(publicJSON.softwareArray);
				Ext.getCmp('swnameId').setValue(filterDecode(softwareName));
			}
			else
			{
				Ext.getCmp('swnameId').getStore().loadRawData({'displayField': 'Not Applicable', 'valueField': '-1'});
				Ext.getCmp('swnameId').setValue('-1');
			}
		}
		else if (groupValue == 'bydate')
		{
			var defaultStartDate = '';
			var defaultEndDate = '';
			Ext.getCmp('ec_swstdateId').show();
			Ext.getCmp('ec_swenddateId').show();

			Ext.getCmp('swpatternId').hide();
			Ext.getCmp('swosId').hide();
			Ext.getCmp('swnameId').hide();

			// reset the formitems
			if (reqFrom == 'queryString')
			{
				defaultStartDate = appCnt.getValueFromQryString("sw_ec_stdate=");
				defaultEndDate = appCnt.getValueFromQryString("sw_ec_enddate=");
			}
			Ext.getCmp('ec_swstdateId').setValue(defaultStartDate);
			Ext.getCmp('ec_swenddateId').setValue(defaultEndDate);
		}
		else if (groupValue == 'bypattern')
		{
			var defaultPatternVal = '';
			Ext.getCmp('swpatternId').show();

			Ext.getCmp('ec_swstdateId').hide();
			Ext.getCmp('ec_swenddateId').hide();
			Ext.getCmp('swnameId').hide();
			Ext.getCmp('swosId').hide();

			// reset the formitems
			if (reqFrom == 'queryString')
			{
				defaultPatternVal = appCnt.getValueFromQryString("swpattern=");
			}
			Ext.getCmp('swpatternId').setValue(defaultPatternVal);
		}
		var defaultInstallStatus = 'All';

		if (reqFrom == 'queryString')
		{
			defaultInstallStatus = appCnt.getValueFromQryString("swInstat=");
		}

		Ext.getCmp('swInstatId').setValue(defaultInstallStatus);
		var installedStatus = Ext.getCmp('swInstatId').getValue();
		if(installedStatus == 'Yes')
		{
			Ext.getCmp('swDisplaycolumnsId').show();
			Ext.getCmp('swDispColCnt').show();
			if (reqFrom == 'queryString')
			{
				var displayColValues = appCnt.getValueFromQryString("swdisplaycolumns=");
				Ext.getCmp('swDisplaycolumnsId').getStore().loadRawData(publicJSON.displayColValues);
				Ext.getCmp('swDisplaycolumnsId').setValue(displayColValues);
			}
		}
		else
		{
			Ext.getCmp('swDisplaycolumnsId').hide();
			Ext.getCmp('swDispColCnt').hide();
		}
	},

	searchByForOSChange: function(reqFrom)
	{
		var groupValue = Ext.getCmp('searchByForOS').getValue();

		if (groupValue == 'byname')
		{
			var osVal = publicJSON.osArray[0].valueField;
			Ext.getCmp('osoperatorId').hide();
			Ext.getCmp('ec_stdateOSId').hide();
			Ext.getCmp('ec_enddateOSId').hide();
			Ext.getCmp('osramId').hide();

			Ext.getCmp('ososId').show();

			// reset the formitems
			if (reqFrom == 'queryString')
			{
				osVal = appCnt.getValueFromQryString("osos=");
			}
			Ext.getCmp('ososId').getStore().loadRawData(publicJSON.osArray);
			Ext.getCmp('ososId').setValue(osVal);
		}
		else if (groupValue == 'byram')
		{
			var defaultOperator = '=';
			var osVal = publicJSON.osArray[0].valueField;
			Ext.getCmp('ososId').show();
			Ext.getCmp('osoperatorId').show();
			Ext.getCmp('osramId').show();

			Ext.getCmp('ec_stdateOSId').hide();
			Ext.getCmp('ec_enddateOSId').hide();

			// reset the formitems
			if (reqFrom == 'queryString')
			{
				osVal = appCnt.getValueFromQryString("osos=");
			}
			Ext.getCmp('ososId').getStore().loadRawData(publicJSON.osArray);
			Ext.getCmp('ososId').setValue(osVal);

			if (reqFrom == 'queryString')
			{
				defaultOperator = appCnt.getValueFromQryString("osoperator=");
			}
			Ext.getCmp('osoperatorId').setValue(defaultOperator);

			if (reqFrom == 'queryString')
			{
				var ramSize = appCnt.getValueFromQryString("osram=");
				Ext.getCmp('osramId').getStore().loadRawData(publicJSON.ramSizeArray);
				Ext.getCmp('osramId').setValue(ramSize);
			}
			else
			{
				Ext.getCmp('osramId').getStore().loadRawData({'displayField': 'Not Applicable', 'valueField': '-1'});
				Ext.getCmp('osramId').setValue('-1');
			}
		}
		else if (groupValue == 'bydate')
		{
			var defaultStartDate = '';
			var defaultEndDate = '';
			Ext.getCmp('ec_stdateOSId').show();
			Ext.getCmp('ec_enddateOSId').show();

			Ext.getCmp('ososId').hide();
			Ext.getCmp('osoperatorId').hide();
			Ext.getCmp('osramId').hide();

			if (reqFrom == 'queryString')
			{
				defaultStartDate = appCnt.getValueFromQryString("os_ec_stdate=");
				defaultEndDate = appCnt.getValueFromQryString("os_ec_enddate=");
			}
			// reset the formitems
			Ext.getCmp('ec_stdateOSId').setValue(defaultStartDate);
			Ext.getCmp('ec_enddateOSId').setValue(defaultEndDate);
		}
	},

	searchByForNAChange: function(reqFrom)
	{
		var groupValue = Ext.getCmp('searchByForNA').getValue();
		Ext.getCmp('naDispColCnt').hide();

		if (groupValue == 'byname')
		{
			var osVal = publicJSON.osArray[0].valueField;
			if (reqFrom == "queryString")
			{
				osVal = appCnt.getValueFromQryString("naos=");
			}
			Ext.getCmp('naosId').getStore().loadRawData(publicJSON.osArray);
			Ext.getCmp('naosId').setValue(osVal);

			if (reqFrom == "queryString")
			{
				var na = appCnt.getValueFromQryString("nas=");
				Ext.getCmp('nasId').getStore().loadRawData(publicJSON.adaptersArray);
				Ext.getCmp('nasId').setValue(na);
			}
			else
			{
				Ext.getCmp('nasId').getStore().loadRawData({'displayField': 'Not Applicable', 'valueField': '-1'});
				Ext.getCmp('nasId').setValue('-1');
			}

			Ext.getCmp('naosId').show();
			Ext.getCmp('nasId').show();

			Ext.getCmp('napatternId').hide();
		}
		else if (groupValue == 'bypattern')
		{
			var defaultNaPattern = '';
			Ext.getCmp('napatternId').show();

			Ext.getCmp('naosId').hide();
			Ext.getCmp('nasId').hide();

			if (reqFrom == "queryString")
			{
				defaultNaPattern = appCnt.getValueFromQryString("napattern=");
			}
			Ext.getCmp('napatternId').setValue(defaultNaPattern);
		}
		var defaultInstalStatus = 'All';

		if (reqFrom == "queryString")
		{
			defaultInstalStatus = appCnt.getValueFromQryString("naInstat=");
		}
		Ext.getCmp('naInstatId').setValue(defaultInstalStatus);
		var installStatus = Ext.getCmp('naInstatId').getValue();

		if(installStatus == 'Yes')
		{
			Ext.getCmp('naDisplaycolumnsId').show();
			Ext.getCmp('naDispColCnt').show();
			if (reqFrom == "queryString")
			{
				var displayColsValue = appCnt.getValueFromQryString("nadisplaycolumns=");
				Ext.getCmp('naDisplaycolumnsId').getStore().loadRawData(publicJSON.displayColValues);
				Ext.getCmp('naDisplaycolumnsId').setValue(displayColsValue);
			}
		}
		else
		{
			Ext.getCmp('naDisplaycolumnsId').hide();
			Ext.getCmp('naDispColCnt').hide();
		}
	},

	searchByForDiskChange: function(reqFrom)
	{
		var groupValue = Ext.getCmp('searchByForDisk').getValue();
		var osVal = publicJSON.osArray[0].valueField;

		if (reqFrom == "queryString")
		{
			osVal = appCnt.getValueFromQryString("hfos=");
		}
		Ext.getCmp('os').getStore().loadRawData(publicJSON.osArray);
		Ext.getCmp('os').setValue(osVal);

		if (groupValue == 'byfs')
		{
			Ext.getCmp('hdfsId').show();
			Ext.getCmp('hdcpId').hide();

			if (reqFrom == "queryString")
			{
				var fs = appCnt.getValueFromQryString("hdfs=");
				Ext.getCmp('hdfsId').getStore().loadRawData(publicJSON.fileSystemArray);
				Ext.getCmp('hdfsId').setValue(fs);
			}
			else
			{
				Ext.getCmp('hdfsId').getStore().loadRawData({'displayField': 'Not Applicable', 'valueField': '-1'});
				Ext.getCmp('hdfsId').setValue('-1');
			}
		}
		else if (groupValue == 'bycp')
		{
			Ext.getCmp('hdfsId').hide();
			Ext.getCmp('hdcpId').show();

			if (reqFrom == "queryString")
			{
				var cp = appCnt.getValueFromQryString("hdcp=");
				Ext.getCmp('hdcpId').getStore().loadRawData(publicJSON.capacityArray);
				Ext.getCmp('hdcpId').setValue(cp);
			}
			else
			{
				Ext.getCmp('hdcpId').getStore().loadRawData({'displayField': 'Not Applicable', 'valueField': '-1'});
				Ext.getCmp('hdcpId').setValue('-1');
			}
		}
	},

	searchByForHotfixChange: function(reqFrom)
	{
		var defaultInstallStatus = 'All';
		var groupValue = Ext.getCmp('searchBy').getValue();
		Ext.getCmp('hfDispColCnt').hide();

		if (groupValue == 'bydate')
		{
			var defaultStartDate = '';
			var defaultEndDate = '';

			Ext.getCmp('ec_stdateId').show();
			Ext.getCmp('ec_enddateId').show();

			Ext.getCmp('os').hide();
			Ext.getCmp('hfnameId').hide();
			Ext.getCmp('hfpatternId').hide();

			if (reqFrom == 'queryString')
			{
				defaultStartDate = appCnt.getValueFromQryString("hf_ec_stdate=");
				defaultEndDate = appCnt.getValueFromQryString("hf_ec_enddate=");
			}

			Ext.getCmp('ec_stdateId').setValue(defaultStartDate);
			Ext.getCmp('ec_enddateId').setValue(defaultEndDate);
		}
		else if (groupValue == 'byname')
		{
			var osVal = publicJSON.osArray[0].valueField;
			Ext.getCmp('os').show();
			Ext.getCmp('hfnameId').show();

			Ext.getCmp('ec_stdateId').hide();
			Ext.getCmp('ec_enddateId').hide();
			Ext.getCmp('hfpatternId').hide();

			if (reqFrom == 'queryString')
			{
				osVal = appCnt.getValueFromQryString("hfos=");
			}
			Ext.getCmp('os').getStore().loadRawData(publicJSON.osArray);
			Ext.getCmp('os').setValue(osVal);

			if (reqFrom == 'queryString')
			{
				var hfName = appCnt.getValueFromQryString("hfname=");
				Ext.getCmp('hfnameId').getStore().loadRawData(publicJSON.hotfixArray);
				Ext.getCmp('hfnameId').setValue(hfName);
			}
			else
			{
				Ext.getCmp('hfnameId').getStore().loadRawData({'displayField': 'Not Applicable', 'valueField':'-1'});
				Ext.getCmp('hfnameId').setValue('-1');
			}
		}
		else if (groupValue == 'bypattern')
		{
			var hfPatternVal = '';
			Ext.getCmp('hfpatternId').show();

			Ext.getCmp('os').hide();
			Ext.getCmp('hfnameId').hide();
			Ext.getCmp('ec_stdateId').hide();
			Ext.getCmp('ec_enddateId').hide();

			if (reqFrom == 'queryString')
			{
				hfPatternVal = appCnt.getValueFromQryString("hfpattern=");
			}
			Ext.getCmp('hfpatternId').setValue(hfPatternVal);
		}

		if (reqFrom == 'queryString')
		{
			defaultInstallStatus = appCnt.getValueFromQryString("instat=");
		}
		Ext.getCmp('instatId').setValue(defaultInstallStatus);
		var installedStatus = Ext.getCmp('instatId').getValue();

		if(installedStatus == 'Yes')
		{
			Ext.getCmp('displaycolumnsId').show();
			Ext.getCmp('hfDispColCnt').show();
			if (reqFrom == 'queryString')
			{
				displayColsValue = appCnt.getValueFromQryString("hfdisplaycolumns=");
				Ext.getCmp('displaycolumnsId').getStore().loadRawData(publicJSON.displayColValues);
				Ext.getCmp('displaycolumnsId').setValue(displayColsValue);
			}
		}
		else
		{
			Ext.getCmp('displaycolumnsId').hide();
			Ext.getCmp('hfDispColCnt').hide();
		}
	},

	swInstallStatusChange: function()
	{
		var searchFor = Ext.getCmp('searchFor').getValue();
		var searchBy = Ext.getCmp('searchByForSoftware').getValue();
		var installed = Ext.getCmp('swInstatId').getValue();

		var swDispColCntObj = Ext.getCmp('swDispColCnt');
		var displayColumnsObj = Ext.getCmp('swDisplaycolumnsId');
		var displayColumnsArr = new Array();

		if (installed == 'Yes' && searchBy != 'bydate')
		{
			swDispColCntObj.show();
			displayColumnsObj.show();

			Ext.Ajax.request(
			{
				url : config.urls.initialURL,
				params: 'searchinfo='+searchFor+'&cmd=SearchConfig',
				scope : this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					publicJSON = jsonData;

					var displayColumns = jsonData.displayColValues;

					if (!Ext.isEmpty(displayColumnsObj))
					{
						displayColumnsObj.getStore().loadRawData(jsonData.displayColValues);
					}

					for (var i=0; i<displayColumns.length; i++)
					{
						displayColumnsArr[i] = jsonData.displayColValues[i].valueField;
					}

					displayColumnsObj.setValue(displayColumnsArr);
				}
			});
		}
		else
		{
			swDispColCntObj.hide();
			displayColumnsObj.hide();
		}
	},

	adapterInstallStatusChange: function()
	{
		var searchFor = Ext.getCmp('searchFor').getValue();
		var installed = Ext.getCmp('naInstatId').getValue();

		var naDispColCntObj = Ext.getCmp('naDispColCnt');
		var displayColumnsObj = Ext.getCmp('naDisplaycolumnsId');
		var displayColumnsArr = new Array();

		if (installed == 'Yes')
		{
			naDispColCntObj.show();
			displayColumnsObj.show();

			Ext.Ajax.request(
			{
				url : config.urls.initialURL,
				params: 'searchinfo='+searchFor+'&cmd=SearchConfig',
				scope : this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					publicJSON = jsonData;

					var displayColumns = jsonData.displayColValues;

					if (!Ext.isEmpty(displayColumnsObj))
					{
						displayColumnsObj.getStore().loadRawData(jsonData.displayColValues);
					}

					for (var i=0; i<displayColumns.length; i++)
					{
						displayColumnsArr[i] = jsonData.displayColValues[i].valueField;
					}

					displayColumnsObj.setValue(displayColumnsArr);
				}
			});
		}
		else
		{
			displayColumnsObj.hide();
			naDispColCntObj.hide();
		}
	},

	softwareOSChange: function()
	{
		var searchFor = Ext.getCmp('searchFor').getValue();
		var selectedOSName = Ext.getCmp('swosId').getValue();

		if(Ext.isEmpty(selectedOSName) || selectedOSName.toLowerCase() == 'please select an os')
		{
			Ext.getCmp('swnameId').getStore().loadRawData({'displayField': 'Not Applicable', 'valueField': '-1'});
			Ext.getCmp('swnameId').setValue('-1');
		}
		else
		{
			Ext.Ajax.request(
			{
				url : config.urls.initialURL,
				params: 'cmd=SearchConfig&searchinfo='+searchFor+'&swos='+selectedOSName,
				scope : this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					Ext.getCmp('swnameId').getStore().loadRawData(jsonData.softwareArray);
					Ext.getCmp('swnameId').setValue(jsonData.softwareArray[0].valueField);
				}
			});
		}
	},

	hotfixOrHardDiskOSChange: function()
	{
		var searchFor = Ext.getCmp('searchFor').getValue();
		var hdfsIdObj = Ext.getCmp('hdfsId'); // harddisk filesystem type
		var hdcpIdObj = Ext.getCmp('hdcpId'); // harddisk capacity
		var hfnameIdObj = Ext.getCmp('hfnameId');
		var selectedOSName = Ext.getCmp('os').getValue();
		var searchBy = Ext.getCmp('searchByForDisk').getValue();

		if(Ext.isEmpty(selectedOSName) || selectedOSName.toLowerCase() == 'please select an os')
		{
			if(searchFor == 'hd')
			{
				if(searchBy == 'byfs')
				{
					hdfsIdObj.getStore().loadRawData({'displayField': 'Not Applicable', 'valueField': '-1'}); // harddisk filesystem type
					hdfsIdObj.setValue('-1');
				}

				if(searchBy == 'bycp')
				{
					hdcpIdObj.getStore().loadRawData({'displayField': 'Not Applicable', 'valueField': '-1'}); // harddisk capacity
					hdcpIdObj.setValue('-1');
				}
			}

			if(searchFor == 'hf')
			{
				hfnameIdObj.getStore().loadRawData({'displayField': 'Not Applicable', 'valueField': '-1'}); // hotfix name
				hfnameIdObj.setValue('-1');
			}
		}
		else
		{
			Ext.Ajax.request(
			{
				url : config.urls.initialURL,
				params: 'cmd=SearchConfig&searchinfo='+searchFor+'&hfos='+selectedOSName,
				scope : this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					if(searchFor == 'hd')
					{
						if(searchBy == 'byfs')
						{
							hdfsIdObj.getStore().loadRawData(jsonData.fileSystemArray);
							hdfsIdObj.setValue(jsonData.fileSystemArray[0].valueField);
						}

						if(searchBy == 'bycp')
						{
							hdcpIdObj.getStore().loadRawData(jsonData.capacityArray);
							hdcpIdObj.setValue(jsonData.capacityArray[0].valueField);
						}
					}

					if(searchFor == 'hf')
					{
						hfnameIdObj.getStore().loadRawData(jsonData.hotfixArray);
						hfnameIdObj.setValue(jsonData.hotfixArray[0].valueField);
					}
				}
			});
		}
	},

	networkAdapterOSChange: function()
	{
		var searchFor = Ext.getCmp('searchFor').getValue();
		var nasObj = Ext.getCmp('nasId');
		var selectedOSName = Ext.getCmp('naosId').getValue();

		if(Ext.isEmpty(selectedOSName) || selectedOSName.toLowerCase() == 'please select an os')
		{
			nasObj.getStore().loadRawData({'displayField': 'Not Applicable', 'valueField': '-1'});
			nasObj.setValue('-1');
		}
		else
		{
			Ext.Ajax.request(
			{
				url : config.urls.initialURL,
				params: 'cmd=SearchConfig&searchinfo='+searchFor+'&naos='+selectedOSName,
				scope : this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					nasObj.getStore().loadRawData(jsonData.adaptersArray);
					nasObj.setValue(jsonData.adaptersArray[0].valueField);
				}
			});
		}
	},

	osForOSChange: function()
	{
		var searchFor = Ext.getCmp('searchFor').getValue();
		var selectedOSName = Ext.getCmp('ososId').getValue();

		if(Ext.isEmpty(selectedOSName) || selectedOSName.toLowerCase() == 'please select an os')
		{
			Ext.getCmp('osramId').getStore().loadRawData({'displayField': 'Not Applicable', 'valueField': '-1'});
			Ext.getCmp('osramId').setValue('-1');
		}
		else
		{
			Ext.Ajax.request(
			{
				url : config.urls.initialURL,
				params: 'cmd=SearchConfig&searchinfo='+searchFor+'&osos='+selectedOSName,
				scope : this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					Ext.getCmp('osramId').getStore().loadRawData(jsonData.ramSizeArray);
					Ext.getCmp('osramId').setValue(jsonData.ramSizeArray[0].valueField);
				}
			});
		}
	},

	hotfixOrHarddiskInstallationStatusChange: function()
	{
		var searchFor = Ext.getCmp('searchFor').getValue();
		var installed = Ext.getCmp('instatId').getValue();
		var hfSrchByVal = Ext.getCmp('searchBy').getValue();

		var hfDispColLabelObj = Ext.getCmp('hfDispColLabel');
		var hfDispColCntObj = Ext.getCmp('hfDispColCnt');
		var displayColumnsObj = Ext.getCmp('displaycolumnsId');
		var displayColumnsArr = new Array();

		if (hfSrchByVal != 'bydate' && installed == 'Yes')
		{
			hfDispColCntObj.show();
			displayColumnsObj.show();
			hfDispColLabelObj.show();

			Ext.Ajax.request(
			{
				url : config.urls.initialURL,
				params: 'searchinfo='+searchFor+'&cmd=SearchConfig',
				scope : this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					publicJSON = jsonData;

					var displayColumns = jsonData.displayColValues;

					if (!Ext.isEmpty(displayColumnsObj))
					{
						displayColumnsObj.getStore().loadRawData(jsonData.displayColValues);
					}

					for (var i=0; i<displayColumns.length; i++)
					{
						displayColumnsArr[i] = jsonData.displayColValues[i].valueField;
					}

					displayColumnsObj.setValue(displayColumnsArr);
				}
			});
		}
		else
		{
			hfDispColCntObj.hide();
			displayColumnsObj.hide();
			hfDispColLabelObj.hide();
		}
	},

	addQuery: function()
	{
		var storeDataArr = new Array();
		flagAddClicked = 'true';

		var search_info = Ext.getCmp('searchFor').getValue();
		var heading = '';
		var headingDisplay = '';
		var os = '';
		var temp1 = '';
		var temp2 = '';
		var temp = '';
		var tempDisplay = '';

		var FromDateFlag = false;
		var ToDateFlag = false;

		if(Ext.isEmpty(search_info) || search_info.toLowerCase() == 'please select' || search_info == '-1')
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg17);
			return;
		}

		if (search_info == 'hf')
		{
			var searchBy = Ext.getCmp('searchBy').getValue();
			if (searchBy == 'bydate')
			{
				var fdate = Ext.Date.format(Ext.getCmp('ec_stdateId').getValue(),'m/d/Y');
				var tdate = Ext.Date.format(Ext.getCmp('ec_enddateId').getValue(),'m/d/Y');

				if (fdate == "")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg2);
					return false;
				}

				if (tdate == "")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg3);
					return false;
				}

				var formatFromDate = Ext.Date.format(Ext.getCmp('ec_stdateId').getValue(), mgrDateFormat);
				var formatToDate = Ext.Date.format(Ext.getCmp('ec_enddateId').getValue(), mgrDateFormat);

				var stHr="0";
				var endHr="0";

				if(!checktime(fdate,tdate,stHr,endHr))
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg13);
					return;
				}

				var temp_instat = Ext.getCmp('instatId').getValue();

				if (search_info == "hf")
				{
					heading = "Hotfix:Date|";
					headingDisplay = 'Hotfix' + ':' + 'Date' + '|';
				}

				temp = heading + "From=" + formatFromDate + "#To=" + formatToDate + "#Installed=" + temp_instat;
				tempDisplay = headingDisplay + 'From' + '=' + formatFromDate + '#' + 'To' + '=' + formatToDate + '#' + 'Installed' + '=' + temp_instat;
			}
			else if (searchBy == 'byname')
			{
				var os = Ext.getCmp('os').getValue();
				if (Ext.isEmpty(os) || os.toLowerCase() == 'please select an os')
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg1);
					return;
				}

				temp1 = Ext.getCmp('hfnameId').getValue();
				temp2 = Ext.getCmp('instatId').getValue();

				if (temp1 == "-1")
				{
					if (search_info == "hf") 
					{
						Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg4);
					}
					return;
				}

				if (search_info == "hf")
				{
					heading = "Hotfix:Name|";
					headingDisplay = 'Hotfix' + ':' + 'Name' + '|';
					nameHeading = "Hotfix";
					nameHeadingDisplay = 'Hotfix';
				}

				if (temp2 == "Yes")
				{
					var arr = new Array();
					var n = 0
					arr = Ext.getCmp('displaycolumnsId').getValue();

					if (arr.length == 0)
					{
						Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg6);
						return;
					}

					temp = heading + "OS=" + os + "#" + nameHeading + "=" + temp1 + "#Installed=" + temp2 + "#Displaycolumns=" + arr;
					tempDisplay = headingDisplay + 'OS' + '=' + os + "#" + nameHeadingDisplay + "=" + temp1 + '#' + 'Installed' + '=' + temp2 + '#' + 'Displaycolumns' + '=' + arr;
				}
				else
				{
					temp = heading + "OS=" + os + "#" + nameHeading + "=" + temp1 + "#Installed=" + temp2;
					tempDisplay = headingDisplay + 'OS' + '=' + os + "#" + nameHeadingDisplay + "=" + temp1 + '#' + 'Installed' + '=' + temp2;
				}
			}
			else if (searchBy == 'bypattern')
			{
				temp1 = Ext.getCmp('hfpatternId').getValue();
				temp2 = Ext.getCmp('instatId').getValue();

				if(Ext.isEmpty(temp1))
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg10);
					return;
				}

				if (!checkspecial(temp1,"#$%\\\"\'"))
				{
					Ext.getCmp('hfpatternId').focus();
					return;
				}

				if (search_info == "hf")
				{
					heading = "Hotfix:Pattern|";
					headingDisplay = config.title.hotfixTitle + ':' + config.title.patternTitle + '|';
				}

				if (temp2 == "Yes")
				{
					var arr = new Array();
					var n = 0
					arr = Ext.getCmp('displaycolumnsId').getValue();

					if (arr.length == 0)
					{
						Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg6);
						return;
					}

					temp = heading + "Pattern=" + temp1 + "#Installed=" + temp2 + "#Displaycolumns=" + arr;
					tempDisplay = headingDisplay + config.title.patternTitle + '=' + temp1 + '#' + config.title.installedLabel + '=' + temp2 + '#' + config.title.displayColumnsLabel + '=' + arr;
				}
				else
				{
					temp = heading + "Pattern=" + temp1 + "#Installed=" + temp2;
					tempDisplay = headingDisplay + config.title.patternTitle + '=' + temp1 + '#' + config.title.installedLabel + '=' + temp2;
				}
			}
		}
		else if (search_info == 'hd')
		{
			os = Ext.getCmp('os').getValue();
			var searchBy = Ext.getCmp('searchByForDisk').getValue();
			var fileSystemType = Ext.getCmp('hdfsId').getValue();
			var capacity = Ext.getCmp('hdcpId').getValue();

			if (Ext.isEmpty(os) || os.toLowerCase() == 'please select an os')
			{
				Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg1);
				return;
			}

			if (searchBy == 'byfs')
			{
				heading = "Harddisk:FilesystemType|";
				headingDisplay = 'Harddisk' + ':' + 'FilesystemType' + '|';

				temp1 = fileSystemType;
				if (Ext.isEmpty(fileSystemType) || fileSystemType.toLowerCase() == 'please select a filesystem type')
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg7);
					return;
				}

				temp = heading + "OS=" + os + "#FilesystemType=" + temp1;
				tempDisplay = headingDisplay + 'OS' + '=' + os + '#' + 'FilesystemType' + '=' + temp1;
			}

			if (searchBy == 'bycp')
			{
				heading = "Harddisk:Capacity|";
				headingDisplay = 'Harddisk' + ':' + 'Capacity' + '|';

				temp1 = capacity;
				if (Ext.isEmpty(capacity) || capacity.toLowerCase() == 'please select a capacity')
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg8);
					return;
				}

				temp = heading + "OS=" + os + "#Capacity=" + temp1;
				tempDisplay = headingDisplay + 'OS' + '=' + os + '#' + 'Capacity' + '=' + temp1;
			}
		}
		else if (search_info == 'na')
		{
			var inStatus = Ext.getCmp('naInstatId').getValue();
			var searchBy = Ext.getCmp('searchByForNA').getValue();
			var networkAdapter = Ext.getCmp('nasId').getValue();

			if (searchBy == 'byname')
			{
				os = Ext.getCmp('naosId').getValue();
				if (Ext.isEmpty(os) || os.toLowerCase() == 'please select an os')
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg1);
					return;
				}

				if (Ext.isEmpty(networkAdapter) || networkAdapter.toLowerCase() == 'please select a network adapter')
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg9);
					return;
				}

				temp1 = Ext.getCmp('nasId').getValue();
				temp2 = inStatus;

				var tmpStr =  temp1;
				if (tmpStr.indexOf('@@@') > 0)
				{
					var tmpId = tmpStr.substring(tmpStr.indexOf('@@@')+3);
					if (tmpId != '-')
					{
						tmpStr = tmpStr.substring(0,tmpStr.indexOf('@@@')) + ' {'+tmpId+'}';
					}
					else
					{
						tmpStr = tmpStr.substring(0,tmpStr.indexOf('@@@'));
					}
				}
				heading = "Networkadapter:Name|";
				headingDisplay = config.title.networkAdapterLabel + ':' + config.title.nameTitle + '|';

				if (temp2 == "Yes")
				{
					var arr = new Array();
					arr = Ext.getCmp('naDisplaycolumnsId').getValue();
					arr = appCnt.arrangeDisplayColVal(arr);

					if (arr.length == 0)
					{
						Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg6);
						return;
					}

					temp = heading + "OS=" + os + "#Networkadapter=" + temp1 + "#Installed=" + temp2 + "#Displaycolumns=" + arr;
					tempDisplay = headingDisplay + config.title.osLabel + '=' + os + '#' + config.title.networkAdapterLabel + '=' + tmpStr + '#' + config.title.installedLabel + '=' + temp2 + '#' + config.title.displayColumnsLabel + '=' + arr;
				}
				else
				{
					temp = heading + "OS=" + os + "#Networkadapter=" + temp1 + "#Installed=" + temp2;
					tempDisplay = headingDisplay + config.title.osLabel + '=' + os + '#' + config.title.networkAdapterLabel + '=' + tmpStr + '#' + config.title.installedLabel + '=' + temp2;
				}
			}

			if (searchBy == 'bypattern')
			{
				var byPatternValue = Ext.getCmp('napatternId').getValue();

				if (Ext.isEmpty(byPatternValue))
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg10);
					Ext.getCmp('napatternId').focus();
					return;
				}

				temp1 = byPatternValue;
				temp2 = inStatus;
				heading = "Networkadapter:Pattern|";
				headingDisplay = config.title.networkAdapterLabel + ':' + config.title.patternTitle + '|';

				if (temp2 == "Yes")
				{
					var arr = new Array();
					arr = Ext.getCmp('naDisplaycolumnsId').getValue();
					arr = appCnt.arrangeDisplayColVal(arr);

					if (arr.length == 0)
					{
						Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg6);
						return;
					}

					temp = heading + "Pattern=" + temp1 + "#Installed=" + temp2 + "#Displaycolumns=" + arr;
					tempDisplay = headingDisplay + config.title.patternTitle + '=' + temp1 + '#' + config.title.installedLabel + '=' + temp2 + '#' + config.title.displayColumnsLabel + '=' + arr;
				}
				else
				{
					temp = heading + "Pattern=" + temp1 + "#Installed=" + temp2;
					tempDisplay = headingDisplay + config.title.patternTitle + '=' + temp1 + '#' + config.title.installedLabel + '=' + temp2;
				}
			}
		}
		else if (search_info == "os")
		{
			var searchBy = Ext.getCmp('searchByForOS').getValue();

			if (searchBy == 'bydate')
			{
				var FromDateFlag = false;
				var ToDateFlag = false;

				var fdate = Ext.Date.format(Ext.getCmp('ec_stdateOSId').getValue(),'m/d/Y');
				var tdate = Ext.Date.format(Ext.getCmp('ec_enddateOSId').getValue(),'m/d/Y');

				if (fdate == "")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg2);
					return false;
				}

				if (tdate == "")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg3);
					return false;
				}

				var stHr="0";
				var endHr="0";

				if(!checktime(fdate,tdate,stHr,endHr))
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg13);
					return;
				}

				var formatFromDate = Ext.Date.format(Ext.getCmp('ec_stdateOSId').getValue(), mgrDateFormat);
				var formatToDate = Ext.Date.format(Ext.getCmp('ec_enddateOSId').getValue(), mgrDateFormat);

				heading = "OS:Date|";
				headingDisplay = config.title.osLabel + ':' + config.title.dateLabel + '|';

				temp = heading + "From=" + formatFromDate + "#To=" + formatToDate;
				tempDisplay = headingDisplay + config.title.fromTitle + '=' + formatFromDate + '#' + config.title.toTitle + '=' + formatToDate;
			}

			if (searchBy == 'byname')
			{
				temp1 = Ext.getCmp('ososId').getValue();
				heading = "OS:OSname|";
				headingDisplay = config.title.osLabel + ':' + config.title.osNameLabel + '|';

				temp = heading + "OS=" + temp1;
				tempDisplay = headingDisplay + config.title.osLabel + '=' + temp1;

				var osValueForOS = Ext.getCmp('ososId').getValue();
				if (Ext.isEmpty(osValueForOS) || osValueForOS.toLowerCase() == 'please select an os')
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg1);
					return;
				}
			}

			if (searchBy == 'byram')
			{
				temp1 = Ext.getCmp('osramId').getValue();
				os = Ext.getCmp('ososId').getValue();
				temp2 = Ext.getCmp('osoperatorId').getValue();

				heading = "OS:RAMsize|";
				headingDisplay = config.title.osLabel + ':' + config.title.ramSizeLabel + '|';

				temp = heading + "OS = " + os + "#RAMsize " + temp2 + " " + temp1; 
				tempDisplay = headingDisplay + config.title.osLabel + ' = ' + os + '#' + config.title.ramSizeLabel + ' ' + temp2 + ' ' + temp1; 

				if (Ext.isEmpty(os) || os.toLowerCase() == 'please select an os')
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg1);
					return;
				}

				if (Ext.isEmpty(temp1) || temp1.toLowerCase() == 'please select a size')
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg11);
					return;
				}
			}
		}
		else if (search_info == 'sw')
		{
			var searchBy = Ext.getCmp('searchByForSoftware').getValue();

			if (searchBy == 'bydate')
			{
				var fdate = Ext.Date.format(Ext.getCmp('ec_swstdateId').getValue(),'m/d/Y');
				var tdate = Ext.Date.format(Ext.getCmp('ec_swenddateId').getValue(),'m/d/Y');

				if (fdate == "")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg2);
					return false;
				}

				if (tdate == "")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg3);
					return false;
				}

				var stHr="0";
				var endHr="0";

				if(!checktime(fdate,tdate,stHr,endHr))
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg13);
					return;
				}

				var formatFromDate = Ext.Date.format(Ext.getCmp('ec_swstdateId').getValue(), mgrDateFormat);
				var formatToDate = Ext.Date.format(Ext.getCmp('ec_swenddateId').getValue(), mgrDateFormat);

				var temp_instat = Ext.getCmp('swInstatId').getValue();

				if (search_info == "sw")
				{
					heading = "Software:Date|";
					headingDisplay = 'Software' + ':' + 'Date' + '|';
				}

				temp = heading + "From=" + formatFromDate + "#To=" + formatToDate + "#Installed=" + temp_instat;
				tempDisplay = headingDisplay + 'From' + '=' + formatFromDate + '#' + 'To' + '=' + formatToDate + '#' + 'Installed' + '=' + temp_instat;
			}
			else if (searchBy == 'byname')
			{
				var os = Ext.getCmp('swosId').getValue();
				if (Ext.isEmpty(os) || os.toLowerCase() == 'please select an os')
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg1);
					return;
				}

				temp1 = Ext.getCmp('swnameId').getValue();
				temp2 = Ext.getCmp('swInstatId').getValue();

				if (temp1 == "-1")
				{
					if (search_info == "sw") 
						Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg12);
					return;
				}

				if (search_info == "sw") 
				{
					heading = "Software:Name|";
					headingDisplay = 'Software' + ':' + 'Name' + '|';
					nameHeading = "Software";
					nameHeadingDisplay = 'Software';
				}

				if (temp2 == "Yes")
				{
					var arr = new Array();
					arr = Ext.getCmp('swDisplaycolumnsId').getValue();
					arr = appCnt.arrangeDisplayColVal(arr);

					if (arr.length == 0)
					{
						Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg6);
						return;
					}

					temp = heading + "OS=" + os + "#" + nameHeading + "=" + temp1 + "#Installed=" + temp2 + "#Displaycolumns=" + arr;
					tempDisplay = headingDisplay + 'OS' + '=' + os + "#" + nameHeadingDisplay + "=" + temp1 + '#' + 'Installed' + '=' + temp2 + '#' + 'Displaycolumns' + '=' + arr;
				}
				else
				{
					temp = heading + "OS=" + os + "#" + nameHeading + "=" + temp1 + "#Installed=" + temp2;
					tempDisplay = headingDisplay + 'OS' + '=' + os + "#" + nameHeadingDisplay + "=" + temp1 + '#' + 'Installed' + '=' + temp2;
				}
			}
			else if (searchBy == 'bypattern')
			{
				temp1 = Ext.getCmp('swpatternId').getValue();
				temp2 = Ext.getCmp('swInstatId').getValue();

				if(Ext.isEmpty(temp1))
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg10);
					return;
				}

				if (!checkspecial(temp1,"#$%\\\"\'"))
				{
					Ext.getCmp('swpatternId').focus();
					return;
				}

				if (search_info == "sw")
				{
					heading = "Software:Pattern|";
					headingDisplay = config.title.softwareTitle + ':' + config.title.patternTitle + '|';
				}

				if (temp2 == "Yes")
				{
					var arr = new Array();
					arr = Ext.getCmp('swDisplaycolumnsId').getValue();
					arr = appCnt.arrangeDisplayColVal(arr);

					if (arr.length == 0)
					{
						Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg6);
						return;
					}

					temp = heading + "Pattern=" + temp1 + "#Installed=" + temp2 + "#Displaycolumns=" + arr;
					tempDisplay = headingDisplay + config.title.patternTitle + '=' + temp1 + '#' + config.title.installedLabel + '=' + temp2 + '#' + config.title.displayColumnsLabel + '=' + arr;
				}
				else
				{
					temp = heading + "Pattern=" + temp1 + "#Installed=" + temp2;
					tempDisplay = headingDisplay + config.title.patternTitle + '=' + temp1 + '#' + config.title.installedLabel + '=' + temp2;
				}
			}
		}

		// checking for duplicate data validation starts here
		var storeCount = Ext.getCmp('query').getStore().getCount();

		for (var i = 0; i < storeCount; i++)
		{
			var valueFieldStr = Ext.getCmp('query').getStore().getAt(i).get('valueField');

			if (valueFieldStr == temp)
			{
				Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg14);
				return;
			}
		}
		// validation ends here

		if (count == 0)
		{
			queryArray[count] = tempDisplay;
			queryValueArray[count] = temp;
		}
		else
		{
			queryArray[count] = tempDisplay;
			queryValueArray[count] = temp;
		}
		count = count + 1;

		for (var i=0; i<queryArray.length; i++)
		{
			var aQuery = queryArray[i];
			var aValueQuery = queryValueArray[i];

			storeDataArr.push({'displayField': aQuery, 'valueField': aValueQuery});
		}
		Ext.getCmp('query').getStore().loadRawData(storeDataArr);
	},

	deleteQuery: function()
	{
		flagDeleteClicked = 'true';

		var storeArr = new Array();
		var alreadyStoreCount = Ext.getCmp('query').getStore().getCount();

		var selectedQuery = Ext.getCmp('query').getValue();

		for (var i=0; i<alreadyStoreCount; i++)
		{
			var storeStr = Ext.getCmp('query').getStore().getAt(i).get('valueField');
			var displayField = Ext.getCmp('query').getStore().getAt(i).get('displayField');
			var flag = 'false';

			for (var j=0; j<Ext.getCmp('query').getValue().length; j++)
			{
				var selectedStr = selectedQuery[j];

				if (storeStr == selectedStr)
				{
					count--;
					Ext.Array.remove(queryArray,displayField);
					Ext.Array.remove(queryValueArray,storeStr);
					flag = 'true';
					break;
				}
				else
				{
					flag = 'false';
				}
			}
			if ( flag != 'true' )
			{
				storeArr.push({'displayField': displayField, 'valueField': storeStr});
			}
		}
		Ext.getCmp('query').getStore().loadRawData(storeArr);

		if (Ext.getCmp('query').getStore().getCount() == 0)
		{
			queryArray = new Array();
			queryValueArray = new Array();
			count = 0;
		}
	},

	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+hiddenFields[key]+"&";
		}
		return hiddenQstr;
	},

	searchQuery: function(reqFrom)
	{
		var parameters = '';
		var query = '';
		var encodedQuery = '';

		var search_info = Ext.getCmp('searchFor').getValue();
		if(Ext.isEmpty(search_info) || search_info.toLowerCase() == 'please select' || search_info == '-1')
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg17);
			return;
		}

		if (reqFrom == 'queryString')
		{
			var storeValsArr = new Array();
			var queryItems = '';
			var queryValues = '';
			var qrySplitUp = queryString.split("&");

			for (var i = 0 ; i < qrySplitUp.length ; i++)
			{
				var val = qrySplitUp[i];
				if (val.startsWith('queryItems='))
				{
					var temp = val.split('queryItems=');
					queryValues = filterDecode(temp[1]);
					break;
				}
			}
			var tempVal = new Array();
			if (strRequestFrom == 'SystemPage' || strRequestFrom == 'SearchPage')
			{
				tempVal = queryValues.split('###');
			}
			else
			{
				tempVal = queryValues.split('$$$');
			}

			for (var i = 0; i < tempVal.length; i++)
			{
				var queryValue = tempVal[i];
				if (strRequestFrom == 'SearchPage')
				{
					String.prototype.replaceAll = function(search, replacement) {
						var target = this;
						return target.split(search).join(replacement);
					};
					queryValue = queryValue.replaceAll('$','#');
				}
				storeValsArr.push({'displayField':queryValue, 'valueField': queryValue});
				queryArray.push(queryValue);
				queryValueArray.push(queryValue);
				count++;
				if (i == tempVal.length)
				{
					queryItems += tempVal[i];
				}
				else
				{
					queryItems += tempVal[i] + ',';
				}
			}
			Ext.getCmp('query').getStore().loadRawData(storeValsArr);
			//Ext.getCmp('query').setValue(queryItems);
		}

		var cnt = Ext.getCmp('query').getStore().getCount();
		if(cnt == 0)
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg16);
			return;
		}

		for (var i = 0; i < cnt; i++)
		{
			var valueField = Ext.getCmp('query').getStore().getAt(i).get('valueField');
			if (i == 0)
			{
				query = valueField;
			}
			else
			{
				query = query + "###" + valueField;
			}
		}

		encodedQuery = filterEncode(query);
		hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		Ext.getCmp('query').setDisabled(true);

		parameters = hiddenFields+"&queryItems="+ encodedQuery + "&allOpts=" + encodedQuery+"&needData=yes&searchinfo="+search_info;


		if(search_info == 'hf')
		{
			var installStatus = Ext.getCmp('instatId').getValue();

			if (installStatus != 'Yes')
			{
				Ext.getCmp('displaycolumnsId').setDisabled(true);
			}
			Ext.getCmp('naDisplaycolumnsId').setDisabled(true);
			Ext.getCmp('swDisplaycolumnsId').setDisabled(true);
		}
		if(search_info == 'hd' || search_info == 'os')
		{
			Ext.getCmp('displaycolumnsId').setDisabled(true);
			Ext.getCmp('naDisplaycolumnsId').setDisabled(true);
			Ext.getCmp('swDisplaycolumnsId').setDisabled(true);
		}
		if(search_info == 'na')
		{
			var installStatus = Ext.getCmp('naInstatId').getValue();

			if (installStatus != 'Yes')
			{
				Ext.getCmp('naDisplaycolumnsId').setDisabled(true);
			}
			Ext.getCmp('displaycolumnsId').setDisabled(true);
			Ext.getCmp('swDisplaycolumnsId').setDisabled(true);
		}
		if(search_info == 'sw')
		{
			var installStatus = Ext.getCmp('swInstatId').getValue();

			if (installStatus != 'Yes')
			{
				Ext.getCmp('swDisplaycolumnsId').setDisabled(true);
			}
			Ext.getCmp('displaycolumnsId').setDisabled(true);
			Ext.getCmp('naDisplaycolumnsId').setDisabled(true);
		}

		var encodeParams = '';
		var hfnameVal = Ext.getCmp('hfnameId').getValue();
		if (hfnameVal != null && hfnameVal != undefined && !Ext.isEmpty(hfnameVal))
		{
			Ext.getCmp('hfnameId').submitValue=false;
			encodeParams = encodeParams+ "&hfname="+filterEncode(hfnameVal);
		}

		var hfpatternVal = Ext.getCmp('hfpatternId').getValue();
		if (hfpatternVal != null && hfpatternVal != undefined && !Ext.isEmpty(hfpatternVal))
		{
			Ext.getCmp('hfpatternId').submitValue=false;
			encodeParams = encodeParams+ "&hfpattern="+filterEncode(hfpatternVal);
		}

		var napatternId = Ext.getCmp('napatternId').getValue();
		if (napatternId != null && napatternId != undefined && !Ext.isEmpty(napatternId))
		{
			Ext.getCmp('napatternId').submitValue=false;
			encodeParams = encodeParams+ "&napattern="+filterEncode(napatternId);
		}

		var nasVal = Ext.getCmp('nasId').getValue();
		if (nasVal != null && nasVal != undefined && !Ext.isEmpty(nasVal))
		{
			Ext.getCmp('nasId').submitValue=false;
			encodeParams = encodeParams+ "&nas="+filterEncode(nasVal);
		}

		var swnameVal = Ext.getCmp('swnameId').getValue();
		if (swnameVal != null && swnameVal != undefined && !Ext.isEmpty(swnameVal))
		{
			Ext.getCmp('swnameId').submitValue=false;
			encodeParams = encodeParams+ "&swname="+filterEncode(swnameVal);
		}

		var swpatternVal = Ext.getCmp('swpatternId').getValue();
		if (swpatternVal != null && swpatternVal != undefined && !Ext.isEmpty(swpatternVal))
		{
			Ext.getCmp('swpatternId').submitValue=false;
			encodeParams = encodeParams+ "&swpattern="+filterEncode(swpatternVal);
		}

		var osoperatorVal = Ext.getCmp('osoperatorId').getValue();
		if (osoperatorVal != null && osoperatorVal != undefined && !Ext.isEmpty(osoperatorVal))
		{
			Ext.getCmp('osoperatorId').submitValue=false;
			encodeParams = encodeParams+ "&osoperator="+filterEncode(osoperatorVal);
		}

		this.getFormitems().submit(
		{
			url : config.urls.servletURL,
			params: parameters+encodeParams,
			scope : this,
			method : 'POST',
			async: false,
			success: function(form, action){
				if(action.response.status == 200 && !Ext.isEmpty(action.response.responseText)) 
				{
					Ext.getCmp('query').setDisabled(false);
					Ext.getCmp('displaycolumnsId').setDisabled(false);
					Ext.getCmp('naDisplaycolumnsId').setDisabled(false);
					Ext.getCmp('swDisplaycolumnsId').setDisabled(false);

					myMask.hide();
					var jsonText = action.response.responseText;
					var jsonData = Ext.decode(jsonText);
					publicJSON = jsonData;
					Ext.getCmp('resultPanel').show();
					Ext.getCmp('resultPanel').removeAll();
					Ext.getCmp('resultPanel').update(jsonData.tableHtmlData);

					if(publicJSON.containsData != null && publicJSON.containsData != "" && publicJSON.containsData != undefined && publicJSON.containsData != "no")
					{
						appCnt.setToolsState(false);
					}
					else
					{
						appCnt.setToolsState(true);
					}
				}
			},
			failure: function(response)
			{
				myMask.hide();
			}
		});
	},

	setToolsState : function(iconState)
	{
		var saveObj = appCnt.getTools().getComponent('saveTool');
		var printObj = appCnt.getTools().getComponent('printTool');
		var mailObj = appCnt.getTools().getComponent('mailTool');
		var csvObj = appCnt.getTools().getComponent('csvTool');
		if (!Ext.isEmpty(saveObj)) {
			saveObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(printObj)) {
			printObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(mailObj)) {
			mailObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(csvObj)) {
			csvObj.setDisabled(iconState);
		}
	},

	loadTools : function()
	{
		this.getTools().loadIcon(true,true,true,true,false,false);
	},

	saveAsPDF : function()
	{
		if(publicJSON.containsData != null && publicJSON.containsData != "" && publicJSON.containsData != undefined && publicJSON.containsData != "no")
		{
			downloadAsPDF("/final/servlet/com.eg.EcPdfDownloadC");
		}
		else
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg15);
			return;
		}
	},
	printData : function()
	{
		if(publicJSON.containsData != null && publicJSON.containsData != "" && publicJSON.containsData != undefined && publicJSON.containsData != "no")
		{
			var printQueryStr = publicJSON.printQueryStr;
			Ext.widget('print',{title : config.title.mainPageTitle}).show();
			var printContentDiv = Ext.select('#printContentDiv');
			printContentDiv.set({
				src: printQueryStr
			});
		}
		else
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg15);
			return;
		}

	},
	saveAsCSV : function()
	{
		if(publicJSON.containsData != null && publicJSON.containsData != "" && publicJSON.containsData != undefined && publicJSON.containsData != "no")
		{
			Ext.getCmp('formitems').setDisabled(true);

			this.getFormitems().submit({
				url: '../servlet/com.eg.EcCSVController',
				standardSubmit : true,
				method: 'POST'
			});
			Ext.defer(function(){
				Ext.getCmp('formitems').setDisabled(false);
			},200);
		}
		else
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg15);
			return;
		}
	},
	sendMail : function()
	{
		if(publicJSON.containsData != null && publicJSON.containsData != "" && publicJSON.containsData != undefined && publicJSON.containsData != "no")
		{
			Ext.widget('sendmail').show();
		}
		else
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errmsg15);
			return;
		}
	},
	arrangeDisplayColVal: function(selInfoValues)
	{
		var fullInfoList = new Array();
		var newSelInfoValues = new Array();

		if (!Ext.isEmpty(selInfoValues))
		{
			for(var i=0; i<publicJSON['displayColValues'].length; i++)
			{
				fullInfoList.push(publicJSON['displayColValues'][i].valueField);
			}
			for(var j=0; j < fullInfoList.length; j++)
			{
				for(var k=0; k<selInfoValues.length; k++)
				{
					if(fullInfoList[j] == selInfoValues[k])
					{
						newSelInfoValues.push(selInfoValues[k]);
					}
				}
			}
		}
		return newSelInfoValues;
	}
});




