var originalShow = Ext.window.MessageBox.prototype.show;

Ext.override(Ext.window.MessageBox,{
	minWidth : 300,
	show: function(cfg) {
		if (cfg != undefined && cfg.msg != undefined)
		{
			cfg.msg = Ext.String.trim(cfg.msg);
			var lastChar = cfg.msg.charAt(cfg.msg.length-1);
			if (lastChar  !=  '.'  &&  lastChar  !=  '?')
			{
				cfg.msg = cfg.msg + ".";
			}
		}
		if (cfg != undefined && cfg.msg != undefined && !cfg.hasOwnProperty("width"))
		{
			var tmpWidth = cfg.msg.length * 7;
			Ext.applyIf(cfg,{width : tmpWidth});
		}
		return originalShow.apply(this, arguments);
	},
	alert: function(cfg, msg, fn, scope) {
		if (Ext.isString(cfg)) {
			if (msg != undefined)
			{
				msg = Ext.String.trim(msg);
				var lastChar = msg.charAt(msg.length-1);
				if (lastChar  !=  '.'  &&  lastChar  !=  '?')
				{
					msg = msg + ".";
				}
			}
			cfg = {
				title : cfg,
				msg : msg ,
				buttons: this.OK,
				icon : 'iconExclamation',
				fn: fn,
				scope : scope,
				minWidth: this.minWidth
			};
		}
		return this.show(cfg);
	},
	confirm: function(cfg, msg, fn, scope) {
		if (Ext.isString(cfg)) {
			if (msg != undefined)
			{
				msg = Ext.String.trim(msg);
				var lastChar = msg.charAt(msg.length-1);
				if (lastChar  !=  '?')
				{
					msg = msg + "?";
				}
			}
			cfg = {
				title: cfg,
				icon: 'iconConfirmation',
				msg: msg,
				buttons: this.YESNO,
				callback: fn,
				scope: scope
			};
		}
		return this.show(cfg);
	}
});

Ext.define('SearchConfiguration.view.Viewport', {
	extend: 'Ext.container.Viewport',
	layout: 'fit',
	id: 'viewport',

	requires: [
		'SearchConfiguration.view.FormItems',
		'utilities.CustomGrid',
		'utilities.ScrollCombo',
		'configutilities.Tools',
		'configutilities.PrintPreview',
		'configutilities.SendMail',
		'utilities.CommonPanel',
		'Ext.ux.form.MultiSelectSI'
	],

	initComponent: function() {
		Ext.get('loadmask').remove();
		this.items = [
			{
				frame: false,
				border: false,
				layout: 'border',
				bodyPadding:0,
				padding:0,
				items: [
					{
						region: 'west',
						cls:'outerpanel',
						title : config.title.mainPageTitle,
						xtype: 'formitems',
						width:250,
						margin :'8 0 0 8',
						layout:{type:'vbox',align:'stretch'},
						collapsible:true,
						hideCollapseTool:true,
						scroll:false,
						autoScroll:false,
						split: true,
						collapsed:false,
						collapseMode :'mini',
						collapsed:(Ext.isEmpty(sessionStorage.getItem("borderCollapse"))?false:sessionStorage.getItem("borderCollapse")=='true'?true:false),
					},
					{
						region: 'center',
						title : config.title.mainPageTitle,
						cls:'outerpanel',
						margin :'8 8 0 0',
						bodyPadding:5,
						layout: {
							type: 'vbox',
							align: 'stretch'
						},
						items:[
							{
								xtype: 'multiselectSi',
								cls:'multiselect',
								height: 105,
								width: 700,
								margin: 5,
								autoScroll: true,
								scroll: false,
								name: 'query',
								id: 'query',
								value: '',
								store:new Ext.data.Store({
									fields: ['displayField','valueField'],
									data: [],
								}),
								displayField: 'displayField',
								valueField: 'valueField'
							},
							{
								xtype: 'container',
								layout: {
									type: 'hbox',
									pack: 'center'
								},
								margin: '0 5 5 5',
								defaults: {
									width: 80,
									cls:'button20'
								},
								items: [
									{
										xtype: 'button',
										text: config.title.delBtnTitle,
										id: 'deleteBtn'
									},
									{
										xtype: 'button',
										text: config.title.srchBtnTitle,
										id: 'searchBtn',
										margin: '0 0 0 10'
									}
								]
							},
							{
								xtype: 'panel',
								id: 'resultPanel',
								scroll: true,
								flex: 1,
								autoScroll : true,
								layout : 'fit',
								cls:'containerShadow config_containerShadow config_resultPanel',
								overflowY:'auto',
								title: config.title.srchResultTitle,
								hidden: true,
								margin: 5,
								bodyPadding:'10 10 5 10'
							}
						],
						tools: [
							{
								xtype: 'tools'
							}
						]
					}
				]
			}
		];

		this.callParent();
	}

});



