Ext.define('ServicePackDistribution.view.Main',{
	extend: "utilities.OuterPanel",
	alias: "widget.main",
	requires: [
		'ServicePackDistribution.view.FormItems',
		'ServicePackDistribution.view.ErrorContainer',
		'configutilities.Tools',
		'utilities.CommonPanel'
	],
	id: "main",
	title : config.title.mainPageTitle,
	layout: {
		align: "stretch",
		type: "vbox"
	},
	margin : '8 8 0 8',
	tools : [
		{
			xtype : 'button',
			text : config.title.backTitle,
			cls : 'backbutton',
			id : 'backBtnMain',
			iconCls:'iconBack',
			hidden : true
		},
		{
			xtype: 'tbseparator',
			id: 'bkSeperator',
			hidden : true
		},
		{
			xtype : 'tools'
		}
	],
	items : [
		{
			xtype : 'formitems',
			margin: '8 8 0 8'
		},
		{
			xtype : 'commonPanel',
			id : 'hiddenPanel',
			margin: 8,
			hidden : true,
			items : [
				{
					xtype : 'servicepackdistributionchart',
					id : 'chartPlaceHolder',
					margin : '10 10 0 10',
				},
				{
					xtype : 'grid',
					cls :'gridSkin_expander',
					id : 'mainGrid',
					margin : '10 10 10 10',
					store : new Ext.data.Store({
						fields : ['heading','subHeadingWithSys'],
						data : [],
						groupField : 'heading',
						sortOnLoad : false
					}),
					features: [{
						ftype: 'grouping',
						id : 'groupingId',
						groupHeaderTpl: [
							'{name:this.formatHeader}',
							{
								formatHeader: function(name) {
									var cType = name.split(":");
									if(cType.length == 1)
									{
										return cType[0];
									}
									else if(cType.length == 2)
									{
										return cType[0] + ":" + cType[1];
									}
									else if(cType.length == 3)
									{
										return cType[0] + ":" + cType[1] + ":" +cType[2];
									}
								}
							}
						],
						hideGroupedHeader: false,
						startCollapsed: false,
					}],
					tools: [
						{
							xtype:'button',
							id :'tc',
							name :'tc',
							iconCls: 'iconCollapseAll',
							enableToggle : true,
							style: {
								background: 'none',
								border: '0px'
							},
							listeners:{
								'toggle':function(obj, pressed, eOpts){
									var thisGrid = Ext.getCmp('mainGrid'),
									groupingFeature = thisGrid.view.getFeature('groupingId');
									if(pressed){
										groupingFeature.collapseAll();
										obj.setIconCls('iconExpandAll');
									}else{
										groupingFeature.expandAll();
										obj.setIconCls('iconCollapseAll');
									}
									thisGrid.doLayout();
								}
							}
						}
					],
					queryMode : 'local',
					hideHeaders : true,
					viewConfig : {
						deferEmptyText : true,
						cls:'gridSkin_expander_view'
					},

					emptyText : "<table border='0' height='350px' width='100%'><tr><td align=center vlaign=top><img src='/final/images/spacer.gif' class='iconInformation'><div>No result found for the current selection</div></td></tr></table>",

					columns : {

						defaults : {
							sortable : true,
							hideable : false,
							menuDisabled : true,
							draggable : false,
							resizable : false,
							flex : 1
						},
						items : [
							{
								text : 'System',
								dataIndex : 'subHeadingWithSys',
								width : 280,
								renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
								{
									var column = "";
									if (value != "" && value.length > 0)
									{
										var mainArr = value.split("#$#");

										if(mainArr.length > 1) // contains upgraded system list.
										{
											var rowText1 = '';
											var colText1 = '';
											var tmpArr1 = mainArr[1].split("|"); // system list
											rowText1 ='<thead><tr><th class="OStable_td" colspan="3" style="padding:7px 7px 7px 9px;font-size:8pt;">'+ mainArr[0] + '</th></tr></thead>';
											count = 1;

											var sysSize = tmpArr1.length;
											for (var d = 0; d < sysSize; d++)
											{
												if (count == 4) 
												{
													count = 1;
												}
												if (count == 1)
												{
													colText1 = colText1 + '<tr>';
												}

												colText1 = colText1 + '<td style="padding:7px;font-size:8pt;" valign="center" height="20" width="33%"><img src="../images/clear.png" class="iconConfigSystem" style="vertical-align:baseline;" /><a id="mouse" style="vertical-align:bottom" href="javascript:getSystemDetails(\'' + tmpArr1[d] + '\')">' + tmpArr1[d]+ '</a>' + '</td>';

												count++;
												while (count < 4 && d == sysSize-1)
												{
													colText1 = colText1 + '<td width="33%" class="OStable_emptytd">&nbsp;</td>';
													count++;
												}
												if (count == 4)
												{
													colText1 = colText1 + '</tr>';
												}
											}
											rowText1 = rowText1 + colText1;
											column = rowText1;

											return '<table valign="top" class="OStable" style="margin: 2px 0px 2px 0px" width="100%">' + column+ '</table>';
										}
										else // contains only excat match system list.
										{
											var colText = '';
											var count = 1;
											var tmpArr = value.split("|");
											var sysSize = tmpArr.length;
											for (var d = 0; d < sysSize; d++)
											{
												if (count == 4) 
												{
													count = 1;
												}
												if (count == 1)
												{
													colText = colText + '<tr>';
												}

												colText = colText + '<td style="padding:7px;font-size:8pt;" valign="center" height="20" width="33%"><img src="../images/clear.png" class="iconConfigSystem" style="vertical-align:baseline;" /><a id="mouse" style="vertical-align:bottom" href="javascript:getSystemDetails(\'' + tmpArr[d] + '\')">' + tmpArr[d]+ '</a></td>';

												count++;
												while (count < 4 && d == sysSize-1)
												{
													colText = colText + '<td width="33%" class="OStable_emptytd">&nbsp;</td>';
													count++;
												}
												if (count == 4)
												{
													colText = colText + '</tr>';
												}
											}
											metaData.tdCls += "configServicePack";
											return "<table width='100%' style='margin:0px' valign='top'><tbody>"+colText+"</tbody></table>";
										}
									}
									else
									{
										return value;
									}
								}
							}
						]
					}
				}
			]
		},
		{
			xtype: "errorcontainer",
			hidden: true
		}
	]
});



