
Ext.define('ShowComponentChanges.controller.Main',{
	extend: 'Ext.app.Controller',
	views : [
		'Main',
		'AllConfigChangesChart',
		'configutilities.Tools',
		'utilities.CommonPanel',
		'ConfigPagingGrid',
		'ErrorPanel',
		'configutilities.PrintPreview',
		'configutilities.SendMail'
 	],
	
	refs : [
		{selector : 'main',ref : 'main'},
		{selector : 'main #resultViewContainer',ref : 'resultViewContainer'},
		{selector : 'main #configform',ref : 'configurationform'},
		{selector: 'allconfigchangeschart',ref: 'allconfigchangeschart'},
		{selector: 'errorpanel',ref: 'errorpanel'},
		{selector : 'tools',ref : 'tools'},
		{selector: 'configpaginggridshowcompchanges',ref: 'configpaginggridshowcompchanges'},
	],
	init :function() {
		me = this;
		this.buildFieldData()
		this.control({
			'main': {
				'afterrender': this.afterMainRender
			},
			'main': {
				'boxready': this.loadResultData
			},
			'tools' :{
				'afterrender' : this.loadTools
			},
			'tools button[id="saveBtn"]' : {
				'click' : this.saveAsPDF
			},
			'tools button[id="printBtn"]' : {
				'click' : this.printData
			},
			'tools button[id="csvBtn"]' : {
				'click' : this.saveAsCSV
			},
			'tools button[id="mailBtn"]' : {
				'click' : this.sendMail
			},
			'tools button[id="scheduleBtn"]' : {
				'click' : this.setschedule
			},
			'main #backBtnMain': {
				'click': this.forwardRequestedURI
			},
		});
	},
	buildFieldData : function()
	{
		Ext.Ajax.request({
			url : config.urls.initialURL,
			params : queryString,
			method : 'POST',
			async : false,
			success : function( response ){
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					hiddenFieldsKeys = publicJSON['hiddenFields'];
				}
			}
		});
	},
	afterMainRender : function()
	{
		timeZone = publicJSON.timeZone;
		selectDate = publicJSON.selectDate;
		me.getMain().setTitle(publicJSON.applicationTitle);
		//me.loadResultData();
	},
	loadResultData : function()
	{
		var me = this;
		if (publicJSON.hasConfigDetails)
		{
			me.getErrorpanel().hide();
			me.getResultViewContainer().removeAll();
			me.getResultViewContainer().show();

			if (publicJSON.ArrangeBy == "info")
			{
				var gridCollection = "";
				var tplView = "";
				var chartArray = new Array();
				for (key in publicJSON.aListComponentsView)
				{
					tplView = tplView + '<div class="dataPanel showComp_panel" style="margin:0px" ><div class="x-panel-header" style="padding-top:5px;height:29px;"><span class="x-panel-header-text" style="height: 29px;">'+publicJSON.aListComponentsView[key].panelLeftDisplayValue+'</span></div>';

					tplView = tplView + '<div id="'+publicJSON.aListComponentsView[key].chartContainer.chartId+'" style="text-align:center;"></div>';
					chartArray.push(publicJSON.aListComponentsView[key].chartContainer);
					for (key2 in publicJSON.aListComponentsView[key].gridContainer)
					{
						tplView = tplView + me.createXTemplate(publicJSON.aListComponentsView[key].gridContainer[key2]);
					}
					tplView = tplView + "</div>";
				}
				var viewPanel2 = {
					xtype: "container",
					margin : 10,
					html : tplView
				}
				me.getResultViewContainer().add(viewPanel2);
				for (chartCol in chartArray)
				{
					if (chartType == 'fusionchart')
					{
						if (FusionCharts("myColumnChartId_"+chartCol)) 
							FusionCharts("myColumnChartId_"+chartCol).dispose();
						var chart2 = new FusionCharts(chartArray[chartCol].swfPath, "myColumnChartId_"+chartCol, "650", "250","0","1");
						chart2.setDataXML(chartArray[chartCol].xmlString);
						chart2.setTransparent(true);
						chart2.render(chartArray[chartCol].chartId);
					}
					else
					{
						var highChart = {};
						highChart = jQuery.extend(true, {}, getHighChartsInstance(chartArray[chartCol].chartId,chartArray[chartCol].chartHeight-20,chartArray[chartCol].chartWidth+50), highChart);
						highChart.setData(chartArray[chartCol],currentDateFormat,'');
						highChart.drawChart();
					}
				}
			}
			else
			{
				//if (publicJSON.ComponentNameOnly != undefined && publicJSON.ComponentNameOnly)
				{
					var viewPanel = {
						xtype: "commonPanel",
						defaults : {
							margin : '5 5 5 5'
						},
						title: publicJSON.aListComponentsView[0].panelLeftDisplayValue,
						tools : [
							{
								xtype : 'tbspacer'
							},
							{
								xtype : 'label',
								text : publicJSON.aListComponentsView[0].panelRightDisplayValue
							}
						],
						//dockedItems: [{
							//xtype: 'toolbar',
							//dock: 'top',
							//id : 'configDockItems',
							//layout:{
								//type : 'hbox',
								//pack:'center'
							//},
							//items: [
								//{
									//xtype:'container',
									//id : 'displayMessage',
									//html:publicJSON.aListComponentsView[0].chartContainer.chartTitle
								//}
							//]
						//}],
						items: [
							{
								xtype: "allconfigchangeschart",
								style : {'text-align':'center'},
								margin : 5
							}
						]
					}
					me.getResultViewContainer().suspendEvents(true);
					me.getResultViewContainer().add(viewPanel);
					me.getAllconfigchangeschart().updateBoxData(publicJSON.aListComponentsView[0].chartContainer);
					me.getResultViewContainer().resumeEvents();
				}

				me.getResultViewContainer().add({
					xtype : 'configpaginggridshowcompchanges',
					margin : '10 5 5 5',
					arrayStore : publicJSON.allComponentsContaienr.gridData,
					pageLimit : publicJSON.allComponentsContaienr.maxPageItems
				});

				if (publicJSON.allComponentsContaienr.hideComponentColumn)
				{
					me.getConfigpaginggridshowcompchanges().columns[1].hide();
				}
				else
				{
					me.getConfigpaginggridshowcompchanges().columns[1].show();
				}
			}
			me.getResultViewContainer().doComponentLayout();
			me.setToolsState(false);
		}
		else
		{
			me.getResultViewContainer().removeAll();
			me.getResultViewContainer().hide();
			me.setToolsState(true);
			if (publicJSON.errorText != null && publicJSON.errorText != undefined)
			{
				me.getErrorpanel().update('<div class = "iconExclamation" style="margin:10% auto 0 auto;"></div><div style="text-align:center"><b>'+publicJSON.errorText+'</b>.</div>');
				me.getErrorpanel().show();
			}
		}
	},

	getAllChangesDateForThisMeasure : function(curMesCnt,data)
	{
		var allChangesDate = "";
		for(var t = curMesCnt; t < data.length; t++)
		{
			if( t > curMesCnt && data[t].Measure != '&nbsp;')
			{
				break;
			}
			allChangesDate += "<div style='line-height:2em;'>"+data[t].ChangeDate +"</div>";
		}
		return allChangesDate;
	},

	getAllPreviousValueForThisMeasure : function(curMesCnt,data)
	{
		var allPreviousDate = "";
		for(var t = curMesCnt; t < data.length; t++)
		{
			if( t > curMesCnt && data[t].Measure != '&nbsp;')
			{
				break;
			}
			var preVal = data[t].PreviousValue;
			var preValTemp = preVal.split(/[ ,]/);
			if(preValTemp[0].toLowerCase() == 'click')
			{
				var preValTemp1 = preVal.split("#$#");
				var realPreVal = preValTemp1[0];
				var urlLink = preValTemp1[1];
				allPreviousDate += '<div style="line-height:2em;"><a id="mouse" href=\'javascript:goToMeasureComparisonPage("'+urlLink+'")\' target="_self">'+realPreVal+'</a></div>';
			}
			else
			{
				allPreviousDate += "<div style='line-height:2em;'>" + preVal + "</div>";
			}
		}
		return allPreviousDate;
	},

	getAllPresentValueForThisMeasure : function(curMesCnt,data)
	{
		var allPresentDate = "";
		for(var t = curMesCnt; t < data.length; t++)
		{
			if( t > curMesCnt && data[t].Measure != '&nbsp;')
			{
				break;
			}
			var presentVal = data[t].PresentValue;
			var presentValTemp = presentVal.split(/[ ,]/);
			if(presentValTemp[0].toLowerCase() == 'click')
			{
				var presentValTemp1 = presentVal.split("#$#");
				var realPresentVal = presentValTemp1[0];
				var urlLink = presentValTemp1[1];
				allPresentDate += '<div style="line-height:2em;"><a id="mouse" href=\'javascript:goToMeasureComparisonPage("'+urlLink+'")\' target="_self">'+realPresentVal+'</a></div>';
			}
			else
			{
				var preVal = "";
				var tmpStr = data[t].PresentValue;
				if (tmpStr.indexOf("|Diff#") != -1)
				{
					var tmpStr2 = tmpStr.substring(tmpStr.indexOf("|Diff#") + 6);
					var diffArr = tmpStr2.split("|$|");
					preVal += tmpStr.substring(0,tmpStr.indexOf("|Diff#"));
					preVal += '<img src="/final/images/diff.png" onclick=\'javascript:me.loadChange("'+encodeURIComponent(filterEncode(diffArr[0]))+'","'+encodeURIComponent(filterEncode(diffArr[1]))+'","'+encodeURIComponent(filterEncode(diffArr[2]))+'","'+encodeURIComponent(filterEncode(diffArr[3]))+'","'+encodeURIComponent(filterEncode(diffArr[4]))+'","'+encodeURIComponent(filterEncode(diffArr[5]))+'");\' alt="Show the difference" class="mouse"/>';
				}
				else
				{
					preVal += tmpStr;
				}
				allPresentDate += "<div style='line-height:2em;'>"+ preVal +"</div>";
			}
		}
		return allPresentDate;
	},

	createXTemplate : function(gridContainerObj)
	{
		var tplView = "";
		tplView += '<div class="changeConfig_div">';
		if(gridContainerObj.hasDescriptors == "true")
		{
			tplView += '<table border="0" cellspacing="0" cellpadding="0" class="configurationTable2" width="100%">';
		}
		else
		{
			tplView += '<table border="0" cellspacing="0" cellpadding="0" class="configurationTable1" width="100%">';
		}

		tplView = tplView + '<thead><th class="configurationTableHead">'+gridContainerObj.gridTitle+'</th></thead>';

		tplView = tplView +'<tbody><tr><td><div class="configurationInnerTable"><table cellspacing="0" style="width:100%" cellpadding="5" border="0" align="center"><thead><tr>';
		for (c in gridContainerObj.gridColumns)
		{
			var str = gridContainerObj.gridColumns[c];
			tplView = tplView + '<th>'+str+'</th>';
		}
		tplView = tplView + '</tr></thead>';

		for (c1 in gridContainerObj.gridColumnData)
		{
			var count = 0;
			var hasDesc = false;
			var rowData = gridContainerObj.gridColumnData[c1].rowData;
			for (var i = 0; i < rowData.length; i++)
			{
				var measure = rowData[i].Measure;

				if(measure != null && measure != "" && measure != undefined)
				{
					if(measure != "&nbsp;")
					{
						tplView = tplView + '<tr>';
						if (count == 0)
						{
							if (gridContainerObj.hasDescriptors == "true")
							{
								hasDesc = true;
								var tmpStr = rowData[0].Descriptor;
								if (tmpStr.indexOf("|New#") != -1)
								{
									tplView = tplView + '<td style="vertical-align:top; width:30%">'+tmpStr.substring(0,tmpStr.indexOf("|New#"));
									tplView = tplView + '&nbsp;<img src="/final/config/images/new_info.gif" border="0"></td>';
								}
								else
								{
									tplView = tplView + '<td style="vertical-align:top; width:30%">'+tmpStr+'</td>';
								}
							}
							count++;
						}
						else
						{
							if (hasDesc)
							{
								tplView = tplView + '<td style="vertical-align:top; width:30%">&nbsp;</td>';
							}
						}
						tplView = tplView +'<td style="vertical-align:top; width:17.5%">'+rowData[i].Measure+'</td>';
						var changesDate = me.getAllChangesDateForThisMeasure(i,rowData);
						tplView += "<td style='vertical-align:top; width:17.5%'>"+changesDate+"</td>";
						var previousValues = me.getAllPreviousValueForThisMeasure(i,rowData);
						tplView += "<td style='vertical-align:top; width:17.5%'>"+previousValues+"</td>";
						var presentValues = me.getAllPresentValueForThisMeasure(i,rowData);
						tplView += "<td style='vertical-align:top; width:17.5%'>"+presentValues+"</td>";
						tplView = tplView + '</tr>';
					}
				}
			}
			//tplView += '</tr>';
		}
		tplView = tplView + '</table></div></td></tr></tbody></table></div>';
		return tplView;
	},

	loadChange : function(previousValue,presentValue,compValue,testValue,descValue,measureValue)
	{
		var me = this;
		var params = "previousValue="+previousValue+"&presentValue="+presentValue+"&componentName="+compValue+"&testName="+testValue+"&descriptor="+descValue+"&measureName="+measureValue;
		var url = "/final/config/ecShowDifference.jsp";
		Ext.Ajax.request({
			url : url,
			params: params,
			method : 'POST',
			success : function(response)
			{
				Ext.widget('window',{
					layout : 'fit',
					minHeight:250,
					maxHeight:500,
					autoHeight : true,
					width: 400,
					flex : 1,
					model : true,
					ghost : false,
					autoScroll : true,
					scroll : false,
					constrain : true,
					title : 'Difference',
					html : response.responseText
				}).show();
			}
		});
	},
	loadTools : function()
	{
		this.getTools().loadIcon(true,true,true,true,true,false);
	},
	setToolsState : function(iconState,compType)
	{
		var saveObj =me.getTools().getComponent('saveTool');
		var printObj =me.getTools().getComponent('printTool');
		var mailObj =me.getTools().getComponent('mailTool');
		var csvObj =me.getTools().getComponent('csvTool');
		var combineBookletObj = me.getTools().getComponent('bookletTool');
		if (!Ext.isEmpty(saveObj)) {
			saveObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(printObj)) {
			printObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(mailObj)) {
			mailObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(csvObj)) {
			csvObj.setDisabled(iconState);
		}
		if (!Ext.isEmpty(combineBookletObj)) {
			combineBookletObj.setDisabled(iconState);
		}
		Ext.getCmp('schSep').hide();
	},
	
	forwardRequestedURI : function()
	{
		var me = this;
		if (hiddenFieldsKeys.requestFromSearch != undefined && hiddenFieldsKeys.requestFromSearch)
		{
			hiddenFieldsKeys = publicJSON.hiddenFields;
			me.storeHiddenFields(hiddenFieldsKeys);
			me.getConfigurationform().submit({
				url: '/final/config/ChangeConfigIndex.jsp',
				params : 'request_start='+request_start+'&request_from='+request_from+'&timeZone='+timeZone+'&selectDate='+selectDate,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if (hiddenFieldsKeys.requestForCType != undefined && hiddenFieldsKeys.requestForCType)
		{
			hiddenFieldsKeys = publicJSON.hiddenFields;
			me.storeHiddenFields(hiddenFieldsKeys);
			me.getConfigurationform().submit({
				url: '/final/config/ChangeConfigIndex.jsp',
				params : 'request_from='+request_from+'&timeZone='+timeZone+'&selectDate='+selectDate,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if (hiddenFieldsKeys.requestToChange != undefined && hiddenFieldsKeys.requestToChange)
		{
			hiddenFieldsKeys = publicJSON.hiddenFields;
			me.storeHiddenFields(hiddenFieldsKeys);
			me.getConfigurationform().submit({
				url: '/final/config/ChangeConfigIndex.jsp',
				params :'componentName='+encodeURIComponent(componentName)+'&request_start='+request_start+'&request_from='+request_from,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if (hiddenFieldsKeys.requestFromDashboard != undefined && hiddenFieldsKeys.requestFromDashboard)
		{
			window.history.back();
		}
		else if (hiddenFieldsKeys.others != undefined && hiddenFieldsKeys.others)
		{
			hiddenFieldsKeys = publicJSON.hiddenFields;
			me.storeHiddenFields(hiddenFieldsKeys);
			me.getConfigurationform().submit({
				url:  '/final/servlet/com.eg.EcConfigurationServletNew',
				standardSubmit : true,
				method: 'POST'
			});
		}
	},
	saveAsPDF : function()
	{
		//var getSaveObj = Ext.widget('savepdf');
		//getSaveObj.savePDF("/final/servlet/com.eg.EcPdfDownloadC");

		downloadAsPDF("/final/servlet/com.eg.EcPdfDownloadC");
	},
	printData : function()
	{
		var printQueryStr = publicJSON.printQueryStr;
		Ext.widget('print',{title : config.title.mainPageTitle}).show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set({
			src: printQueryStr
		});
	},
	saveAsCSV : function()
	{
		hiddenFieldsKeys = publicJSON.hiddenFields;
		me.storeHiddenFields(hiddenFieldsKeys);
		me.getConfigurationform().submit({
			url: '../servlet/com.eg.EcCSVController',
			params : 'ec_criteria='+hiddenFieldsKeys.ec_criteriaPrevious+'&ec_userOption='+hiddenFieldsKeys.ec_userOptionPrevious,
			standardSubmit : true,
			method: 'POST'
		});
	},
	sendMail : function()
	{
		Ext.widget('sendmail').show();
	},
	storeHiddenFields : function(fields)
	{
		var me = this;
		var tmpField = "";
		var tmpArr = new Array();
		for (key in fields)
		{
			tmpField = {
				xtype : 'hiddenfield',
				name : key,
				value : fields[key]
			}
			tmpArr.push(tmpField);
		}
		me.getConfigurationform().removeAll();
		me.getConfigurationform().add(tmpArr);
		tmpArr = new Array();
	}
});



function goToMeasureComparisonPage(linkurl)
{
	window.location.href = "../servlet/com.eg.EcConfigurationServletNew?cmd=xmlCurrentConfig&request_from=ShowCompChanges&"+linkurl;
}



