Ext.define('ShowComponentChanges.view.ConfigPagingGrid', {
	extend : 'utilities.CustomGrid',
	alias : 'widget.configpaginggridshowcompchanges',
	cls:'gridSkin',
	requires: [
		'Ext.ux.data.PagingMemoryProxy'
	],
	id:'configpaginggridshowcompchanges',
	arrayStore : null,
	pageLimit : 0,

	initComponent : function()
	{
		this.store = Ext.create('Ext.data.Store', {
			fields:['dateandtime','component', 'information', 'descriptor', 'measure','previousvalue','presentvalue'],
			data : this.arrayStore,
			pageSize:this.pageLimit,
			proxy: {
				type: 'pagingmemory',
				reader:
				{
					type: 'json'
				}
			}
		});

		this.columns = [
			{
				header : 'Change Date',
				dataIndex : 'dateandtime',
				flex :1
			},
			{
				header : 'Component',
				dataIndex : 'component',
				flex :1
			},
			{
				header : 'Information',
				dataIndex : 'information',
				flex :1
			},
			{
				header : 'Descriptor',
				dataIndex : 'descriptor',
				flex :1,
				sortable : false,
				renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
				{
					if (value.indexOf("|New#new_info") != -1)
					{
						value = value.substring(0,value.indexOf("|New#new_info"));
						return value+'<img src="/final/config/images/new_info.gif" border="0">';
					}
					else
					{
						return value;
					}
				}
			},
			{
				header : 'Measure',
				dataIndex : 'measure',
				flex :1,
				sortable : false,
				renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
				{
					if (Ext.isArray(value))
					{
						var tmpTable = "<table cellpadding='4' cellspacing='0' border='0'>";
						for (var i = 0;i<value.length;i++)
						{
							var valueStr = value[i];
							if (valueStr.indexOf("|New#new_info") != -1)
							{
								valueStr = valueStr.substring(0,valueStr.indexOf("|New#new_info"));
								valueStr = valueStr+'<img src="/final/config/images/new_info.gif" border="0">';
							}
							else if (valueStr.indexOf("|New#removed") != -1)
							{
								valueStr = valueStr.substring(0,valueStr.indexOf("|New#new_info"));
								valueStr = valueStr + valueStr+'<img src="/final/config/images/removed_info.gif" border="0">';
							}
							tmpTable = tmpTable + "<tr><td style='font-size:11px;line-height:1.7em'>"+valueStr+"</td></tr>";
						}
						tmpTable = tmpTable + "</table>";
						return tmpTable;
					}
					else
					{
						if (value.indexOf("|New#new_info") != -1)
						{
							value = value.substring(0,value.indexOf("|New#new_info"));
							return value+'<img src="/final/config/images/new_info.gif" border="0">';
						}
						else if (value.indexOf("|New#removed") != -1)
						{
							value = value.substring(0,value.indexOf("|New#new_info"));
							return value+'<img src="/final/config/images/removed_info.gif" border="0">';
						}
						else
						{
							return value;
						}
					}
				}
			},
			{
				header :'Previous Value',
				dataIndex : 'previousvalue',
				flex :1,
				sortable : false,
				renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
				{
					if (Ext.isArray(value))
					{
						var tmpTable = '<table cellpadding="4" cellspacing="0" border="0">';
						for (var i = 0;i<value.length;i++)
						{
							var preValTemp = value[i].split(/[ ,]/);
							if(preValTemp[0].toLowerCase() == 'click')
							{
								var valueArr = value[i].split("#$#");
								var displayVal = valueArr[0];
								var urlLink = valueArr[1];
								tmpTable = tmpTable + '<tr><td style="font-size:11px;line-height:1.7em"><a id="mouse" href=\'javascript:goToMeasureComparisonPage("'+urlLink+'")\' target="_self" class="eg_monlink">'+displayVal+'</a></td></tr>';
							}
							else
							{
								tmpTable = tmpTable + '<tr><td style="font-size:11px;line-height:1.7em">'+value[i]+'</td></tr>';
							}
						}
						tmpTable = tmpTable + '</table>';
						return tmpTable;
					}
					else
					{
						var preValTemp = value.split(/[ ,]/);
						if(preValTemp[0].toLowerCase() == 'click')
						{
							var valueArr = value.split("#$#");
							var displayVal = valueArr[0];
							var urlLink = valueArr[1];
							return '<a id="mouse" href=\'javascript:goToMeasureComparisonPage("'+urlLink+'")\' target="_self" class="eg_monlink">'+displayVal+'</a>';
						}
						else
						{
							return value;
						}
					}
				}
			},
			{
				header : 'Present Value',
				dataIndex : 'presentvalue',
				flex :1,
				sortable : false,
				renderer : function(value, metaData, record, rowIndex, colIndex, store, view)
				{
					var finalStr = "";
					if (Ext.isArray(value))
					{
						var tmpTable = '<table cellpadding="4" cellspacing="0" border="0" margin="2px">';
						for (var i = 0;i<value.length;i++)
						{
							var presentValTemp = value[i].split(/[ ,]/);
							if(presentValTemp[0].toLowerCase() == 'click')
							{
								var valueArr = value[i].split("#$#");
								var displayVal = valueArr[0];
								var urlLink = valueArr[1];
								tmpTable = tmpTable + '<tr><td style="font-size:11px;line-height:1.7em"><a id="mouse" href=\'javascript:goToMeasureComparisonPage("'+urlLink+'")\' target="_self" class="eg_monlink">'+displayVal+'</a></td></tr>';
							}
							else
							{
								var tmpStr = value[i];
								if (tmpStr.indexOf("|Diff#") != -1)
								{
									var tmpStr2 = tmpStr.substring(tmpStr.indexOf("|Diff#") + 6);
									var diffArr = tmpStr2.split("|$|");

									tmpTable = tmpTable + '<tr><td style="font-size:11px;line-height:1.7em">'+tmpStr.substring(0,tmpStr.indexOf("|Diff#"))+'</td></tr>';
								}
								else
								{
									tmpTable = tmpTable + '<tr><td style="font-size:11px;line-height:1.7em">'+tmpStr+'</td></tr>';
								}
							}
						}
						tmpTable = tmpTable + '</table>';
						finalStr = tmpTable;
					}
					else
					{
						var presentValTemp = value.split(/[ ,]/);
						if(presentValTemp[0].toLowerCase() == 'click')
						{
							var valueArr = value.split("#$#");
							var displayVal = valueArr[0];
							var urlLink = valueArr[1];
							finalStr = finalStr + '<a id="mouse" href=\'javascript:goToMeasureComparisonPage("'+urlLink+'")\' target="_self" class="eg_monlink">'+displayVal+'</a>';
						}
						else
						{
							if (value.indexOf("|Diff#") != -1)
							{
								var tmpStr2 = value.substring(value.indexOf("|Diff#") + 6);
								var diffArr = tmpStr2.split("|$|");

								var tplView = '<img src="/final/images/diff.png" onclick=\'javascript:me.loadChange("'+encodeURIComponent(diffArr[0])+'","'+encodeURIComponent(diffArr[1])+'","'+encodeURIComponent(diffArr[2])+'","'+encodeURIComponent(diffArr[3])+'","'+encodeURIComponent(diffArr[4])+'","'+encodeURIComponent(diffArr[5])+'");\' alt="Show the difference" class="mouse"/>';

								finalStr = value.substring(0,value.indexOf("|Diff#"))+tplView;
							}
							else
							{
								finalStr = value;
							}
						}
					}
					return finalStr;
				}
			}
		];

		this.dockedItems = [
			{
				xtype:'pagingtoolbar',
				cls:'pagingtoolbar',
				dock: 'bottom',
				displayInfo: true,
				pageSize:this.pageLimit,
				store: this.store,
				displayInfo: true,
				displayMsg: 'Displaying changes {0} - {1} of {2}'
			}
		]
		this.callParent();
	}

});



